



# 一、概述
### 通信流程
为兼容SPI模块做法，大部分核间通讯协议采用 基站-SDK 之间的通信协议,  仅作简要示例说明，详细协议参见《通讯协议-教育新版-基站部分.md》，主要用到基站-SDK 协议的 信标设置 和 数据上传部分，其他大部分基站管理类指令基本上取消，因为基站管理由大核负责，直接解析平台化JSON协议管理。只有小核需要知道的信息，比如白名单列表，快速下发内容，才需要大核传给小核。相应的协议参考基站协议。

### 
# 二， 协议描述
![基站&SDK通信格式](img/基站&SDK通信格式.png)

##  设置投票模式信标

设置投票模式，就控制了基站的投票模式，包括投票类型和参数、投票的启动和停止。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站类指令 |
| 2 | BASEID | 指定的基站编号 |
| 3 | CMDTYPE | 基站命令类型<br> 3 读取当前投票模式，后继的参数无意义<br>4 设置当前投票模式 |
| 4 | DATAPOS | 表决序号（结果记录序号） |
| 5 | MODE | 投票模式 |
| 6-29 | MODES | 投票参数，具体和MODE有关，不同模式下参数意义不同 |

从第4字节起，参数的含义和表决器投票模式信标中的参数含义是一模一样的，决定了表决器的投票状态，具体参数的含义和格式，参见《表决系统通讯协议-政务商务-表决器部分 V4.1》中的2.2节中的多种投票模式参数。

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 3 当前投票模式 |
| 4 | DATAPOS | 当前表决序号 |
| 5 | MODE | 当前投票模式 |
| 6-29 | MODES | 当前投票参数，具体和MODE有关，不同模式下参数意义不同 |

## 设置扩展投票信标

对应键盘协议的2.2.17节扩展投票信标内容。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站类指令 |
| 2 | BASEID | 指定的基站编号 |
| 3 | CMDTYPE | 基站命令类型<br> 14读取当前扩展信标信息，后继的参数无意义<br>15设置当前扩展投票信标信息 |
| 4 | INFOTYPE | 对应键盘协议的INFOTYPE<br>基站可以根据值做特定处理 |
| 5-29 || 内容和键盘协议一样暂按基站原指令，指令数据只到29，从4起最多26字节 |
||||

从第4字节起，参数的含义和表决器投票模式信标中的参数含义是一模一样的。

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 14当前投票模式 |
| 4 | INFOTYPE | 第4字节起和设置指令一样内容 |
||||

## 设置基础扩展信标
20230817 M6键盘需要后台签到功能，此功能是基于政企协议基础信标实现的，现有新协议下已经没有基础信标了，故增加如下协议

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站类指令 |
| 2 | BASEID | 指定的基站编号 |
| 3 | CMDTYPE | 基站命令类型 <br>18 读基础扩展信标参数 <br>19 写参数  |
| 4-5 | AUTHCODE | 授权号，2字节，高位在前 0-0xFFFF <br>=0时候不使用授权模式，表决器可以参与表决<br>>0时候，表决器保存的授权号相同才能参与表决 |
| 6| LOGIN| 登录申请模式(后台签到模式)具体含义同表决器协议 |
| 7 |default||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 18 反馈参数 |
| 4-5 | AUTHCODE | 授权号，2字节，高位在前 0-0xFFFF <br>=0时候不使用授权模式，表决器可以参与表决<br>>0时候，表决器保存的授权号相同才能参与表决 |
| 6| LOGIN| 登录申请模式(后台签到模式)具体含义同表决器协议 |
||||

## 2.1 设置投票模式信标

设置投票模式，就控制了基站的投票模式，包括投票类型和参数、投票的启动和停止。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站类指令 |
| 2 | BASEID | 指定的基站编号 |
| 3 | CMDTYPE | 基站命令类型<br> ~~3 读取当前投票模式，后继的参数无意义~~<br>4 设置当前投票模式 |
| 4 | DATAPOS | 表决序号（结果记录序号） |
| 5 | MODE       | 投票模式<br>低6位是表决模式：<br>1-9是政务应用 10-19商务应用和教育 20-29多项和批次 30-39二维表评测 40-50管理类<br><br>0、空闲，表决停止（含答案提示）<br> 1、签到<br> 2、表决 <br>4、评分 <br>5、判断题<br> 9、模拟测试（通讯效果）<br><br>10、单选多选<br> 11、排序 <br>12、填空 <br>13、抢答 <br>14、测验 <br>15、提交作业<br>16、语音答题<br>17、分组PK<br><br>40 对码模式<br><br> $\color{red} {高2位bit6 和 bit7 } $<br> Bit6=1，白名单基站，0是普通配对基站，由基站程序控制不可设置<br> Bit7=1表示键盘要接收多条的扩展信标（2.2.17节）内容才能启动投票（键盘改无线休眠模式到32.5ms1次以快速接收，并持续到收齐内容后改标准模式减少耗电） |
| 6-22     | MODES      | 投票参数，具体和MODE有关，不同模式下参数意义不同             |
| 23       | STATE      | 低七位表示后台签到的Count序号（1-127循环），开启一轮新的后台签到则该序号变一次。Bit7 = 1 表示开启后台签到。 |
| 24       | WCT_Pos    | 低四位为当前片在WCT中的位置(0-7)以便键盘统一休眠 <br>$\color{red} {最高位 bit7 } $ <br> bit7=1, 表示有基础扩展信标，通常启动后一直在0x17信标前广播发送，直到收到停止指令，才取消发送，如果在投票模式，键盘需先确认收到过基础扩展信标后才能进入投票，避免反复过程<br>bit6：Plus模式-><br>1：基站周期点名;<br>0：基站不发点名<br> |
| 25       | ATTRIB1    | BIT0 =0表示基站是配对基站（套装），1是自由基站（名单），这个bit位SDK不能直接修改，只能用设置基站模式修改；键盘在配对或自由选基站时候，根据此位选择基站 <br>BIT1=0 键盘不用定时监听投票信标，1启用定时监听（S61键盘有按键后才监听投票模式，这个用于控制回到标准中天模式）<br> BIT2=1键盘不关机，用于测试和生产<br> BIT4,3 控制4档键盘自动关机时间，不关机是BIT2控制<br> 00 -30秒 01-2分钟 10-10分钟 11-45分钟 <br>BIT5 =1键盘心跳打开 0关闭（要求基站同步自主控制2.3.1节里面的控制位）<br> ==BIT6—登录菜单显示允许位。1允许登录 0不允许登录== <br>BIT7—积分显示 1显示 0不显示 |
| 26       | ATTRIB2    | 基站特性2，控制考勤 <br>BIT0，1=键盘每秒发送考勤信号次数，0-3，0相当于关闭 <br>BIT2，3=00---其实还可以当他用<br>高4位是键盘发送考勤信号功率（功率写死可当他用，bit7没用） |
| 27       | ATTRIB3    | 基站特性3—基站主频点，用于键盘不跟踪到副频点 |
|  |  |  |

注意：

1. DATAPOS在1-255之间变化，只要是新一轮表决，就由电脑控制变化一次，例如1变为2，2变为3，只要变化，就表示是新的一轮表决开始，例如1直接变为255也是可以的。
2. 但目前DATAPOS也是保存单次表决结果的指定位置，即高可靠系统，会把表决结果按DATAPOS指定的位置保存到FLASH中。

&emsp;&emsp;不同的表决模式MODE下，后继的表决参数MODES字节含义不同，现在分别讨论不同模式下的参数含义。

3. 从第4字节起，参数的含义和表决器投票模式信标中的参数含义是一模一样的，决定了表决器的投票状态，具体参数的含义和格式，参见《表决系统通讯协议-政务商务-表决器部分》中的2.2节中的多种投票模式参数。

## 

## 2.2 基站传送表决器投票数据

小核获取投票器数据后按以下格式打包发给大核，具体协议参见《通讯协议-教育新版-基站部分.md》

### 2.2.1  新增结果类型

参见下节数据描述，MSGTYPE值不同代表不同数据类型。

| **MSGTYPE 值**|**数据类型** |
| --- | --- |
| 21 | 硬件序列号16字节结果，每个单独键盘结果16字节信息 |
| 22 | 硬件序列号字符串结果，每个键盘结果27字节信息 |
| 23 | 老考勤信号，取消 |
| 24 | 2.4G远程考勤数据带电压 |
| 25 | 类似21，键盘结果是同时包含键盘编号ID |
| 26 | 类似22，键盘结果是同时包含键盘编号ID |
| 27 | 8字节BCD格式投票结果带电量，SN+ID，含测验 |
| 28 | SN\_ID，带电量，字符串结果 |
| 29 | SN\_ID模式下的，长结果（25字节，键盘最多1次） |
| 30 | T2语音体系的结果包 |
|||

### 2.2.2 硬件序列号-16字节结果

&emsp;&emsp;个基站数据包可1次传递多个表决器的结果，每个结果用1字节值类型、4字节SN号（比原来少2字节）、新加2字节、2字节时间和7字节的值来传递，1结果16字节。

注意：传递SN号结果的数据包，为提高效率，长度已经不是使用键盘编号结果的29字节，而是USB模式下最多58字节（受限于HID的最多64字节一包，减去3字节同步码，1字节长度，2字节CRC），TCPIP模式下用128字节包有122，实际有效数据还要减去5。

整个结果数据包结构如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 5 基站结果上传 |
| 4 | MSGNO | 数据包序号 |
| 5 | MSGTYPE | 基站数据包类型<br> 21硬件序列号结果-新16字节结果（每组数据16字节，共3组）<br>25 类似类型21,11、12字节是键盘编号ADDH和ADDL |
| 6 | ANSTYPE | 第1个结果的数据包类型<br>如果类型为0xFF，表示后面就没有数据了<br>SDK根据ANSTYPE来对后面15字节数据进行解码，具体参考《通讯协议-教育新版-键盘部分》协议<br>具体是除了字符串，其他凡是可以16字节传输的都用这个格式传递，投票结果、状态报告、登录信息、键盘请求 |
| 7-10 | KEYSN | 第1个结果的表决器硬件序列号，4字节，高位在前 |
| 11 | DATAPOS/ADDH | 结果对应的投票序号或者ADDH |
| 12 | SENDPOS/ADDL | 键盘内部的提交数据序号或者ADDL |
| 13-14 | KEYTIME | 第1个结果的按键时间， 2字节，高位在前<br>一般是离投票开始的时间，单位是20ms，最大约21分钟 |
| 15-21 | VALUE | 第1个结果的7字节值，一般用BCD码表示，高位在前，F表示空字符，最多14位数 |
| 22-37 || 第2个表决器的结果的16字节<br>首字节是ANSTYPE，如果类型为0xFF，表示后面就没有数据了 |
| 38-53 || 第3个表决器的结果的16字节 |
| 54--58 || 如果数据包够长，后面依次有多个结果<br>USB接口形式就没有数据了 |
||||

注意：这些结果值的格式，从ANSTYPE起每组16字节，就是直接拷贝键盘传递过来的数据，具体的数据含义，参考《通讯协议-教育新版-表决器部分.md》3.2节序列号结果类。

### 2.2.3 SN+ID模式下，BCD结果+电量

&emsp;&emsp;USB数据包只能有效数据58字节，减去前5个必要字节，余53字节，原先7BCD结果是17字节1个键盘，由于数字题要16位和加上电量（K1、T1键盘），至少19字节，所以只能打2包，为适应以后增加信息，53字节分两段一段可以26字节，对应到从ANSTYPE起26字节是一个键盘的数据。

传整个结果数据包结构如下：（第6字节到第24字节都是拷贝键盘数据）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 5 基站结果上传 |
| 4 | MSGNO | 数据包序号 |
| 5 | MSGTYPE | 基站数据包类型 27SN+ID模式下字符串结果+电量（每组27字节） |
| 6 | ANSTYPE | 第1个结果的数据包类型<br>这里是7或8，从这里开始的数据都是直接拷贝键盘数据<br>如果类型为0xFF，表示后面就没有数据了 |
| 7-10 | KEYSN | 第1个结果的表决器硬件序列号，4字节，高位在前 |
| 11-12 | ID | 第1个结果的表决器编号，2字节，高位在前 |
| 13-14 | KEYTIME | 第1个结果的按键时间， 2字节，高位在前<br>如果是填空，单位时间20ms，如果是测验，单位时间100ms |
| 15-22 | VALUE | 第1个结果的8字节值，一般用BCD码表示，高位在前，F表示空字符，最多14位数 |
| 23 | VOLT | 电压值，单位20mV |
| 24-31 | RSSI？ | 可能添加RSSI等其他信息，暂时全00<br>一直到第31字节，这样ANSTYPE起是26字节 |
| 32 | ANSTYPE2 | 第2个键盘结果的ANSTYPE |
| 33-57 | ANSVAL2 | 第2个键盘结果的从KEYSN到最后一个字节的值，25字节 |
| 58 || 空，USB基站只有58字节 |
||||


## 2.3 管理类
### 2.3.1 基站键盘SN名单管理-长包
见基站协议 5.3
用于T2基站，1个长指令包读写所有键盘SN名单。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型18 T2基站SN名单管理-长包格式 |
| 4 | MODE | 1 读取名单(仅仅在线)<br> 2 写名单<br> 3 双基站下白名单删除SN，由SDK判断双基站有键盘SN号相同后发出指令，避免老基站占坑 <br>4 锁定键盘，可以n个 <br>5 锁定所有当前在线的键盘 <br>6 解锁键盘<br>7 解锁所有锁定的键盘 <br>8 读取所有名单及离在线状态-从byte7开始4字节SN+1字节的离线(0)在线(1)状态|
| 5 | TYPE | 名单类型，暂1 |
| 6 | NUM | SN的个数 |
| 7-10 | SN1 | 第一个SN，高位前，4字节 |
| 11-14 | SN2 | 第2个SN |
||| 。。。 |
| … || 第NUM个SN |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>18 T2基站SN名单管理-长包格式 |
| 4 | MODE | 对应SDK的MODE值 |
| 5 | TYPE | 名单类型，暂1 |
| 6 | NUM | SN的个数 |
| 7-10 | SN1 | 第一个SN，高位前，4字节 |
| 11-14 | SN2 | 第2个SN |
||||

### 基站组合多包
详见基站协议 5.8