[TOC]
# 一、概述
&emsp;&emsp;教育新版本协议，可以认为是原有老ARS体系的子集，取消了基础信标，只有1个投票信标，然后数据提交按SN号模式有重新定义，确认包也重新定义。
&emsp;&emsp;基站的通讯时序，变成1个投票信标，然后等待10个周期的键盘提交数据，然后2个SN号格式的确认包，然后重新一轮。
&emsp;&emsp;由于新硬件平台无线最大只能32字节，配对码4字节，实际最大有效数据28字节。
&emsp;&emsp;采用无线射频技术的产品，通讯数据包的结构如下：
| **同步码** | **长度** | **配对码** | **表决数据包** | **校验码** |
| --- | --- | --- | --- | --- |
配对码有4字节，用于在无线射频系统中标识哪个表决器属哪个基站。

&emsp;&emsp;注意：电脑通过基站向表决器发数据包时候，向基站发送的数据是不包含配对码的，基站向表决器转发时候自动加配对码；同理，基站转发表决器数据包到电脑时候，自动去掉配对码。
&emsp;&emsp;真正有用的数据，是表决数据包部分的数据。以下文档所涉及的数据描述，都是仅针对表决数据包讨论，不包括同步码、长度、校验码等其他字节数据。

&emsp;&emsp;对于表决数据包的讨论，本文档是按数据包的传输方式分类描述的，分为基站信标、上传单包、上传多包、下传单包、下传多包进行描述，便于统筹设计，另外在第七章中提供了按实现功能划分的索引表。

&emsp;&emsp;表决数据包，长度目前最大28字节，前面有4字节配对码，最大包长度32。

&emsp;&emsp;对于不是无线传输的数据，例如USB传输的基站指令，对于少于250字节的数据，打包格式是：（兼容原来老系统协议）
| **引导头-3字节** | **长度-1字节** | **有效数据-N字节** | **CRC-2字节** |
| --- | --- | --- | --- |
|F5 AA AA|后继数据长度=N+2|命令和数据|校验值|
&emsp;&emsp;具体通讯协议里面，描述的是有效数据段（命令和数据）的解析。
&emsp;&emsp;CRC沿用CRC-16算法，不使用效验的话，先0000。

&emsp;&emsp;凡是超出250字节的，例如WIFI语音数据，用超长包格式打包。区别是引导头不同，和长度字节是2字节。
| **引导头-3字节** | **长度-2字节** | **有效数据-N字节** | **CRC-2字节** |
| --- | --- | --- | --- |
|F5 AA AB|后继数据长度=N+2 高位在前|命令和数据|校验值|
备注：TCP数据包每封包尽量不超过1460字节，UDP不超1472。
# 二、基站信标类
##  ==~~2.1 基础信标（取消）~~==

&emsp;&emsp;~~基础信标是基站定时发送到一个信标信号。~~

&emsp;&emsp;~~基础信标用于实现表决器锁定基站、是否要特殊登录、实现授权后才能表决、投票计时等功能，同时也控制了表决系统的一些特性，例如是否允许自动关机、背光模式等等。~~

&emsp;&emsp;~~键盘接收到基础信标后，如果有数据提交，可以按防冲突算法在10个时间片内向基站提交数据，并接收0x15类的应答确认，如果提交不成功，延时在下一个周期再提交。具体参考3.1节和《表决系统通讯协议-应用文档-基础原理》~~

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x10 标识 |
| 2 | BADDH | 基站编号 |
||||
||||
| 7-8 | AUTHCODE | 授权号，2字节，高位在前，0-0xFFFF =0时候不使用授权模式，表决器可以参与表决>0时候，表决器保存的授权号相同才能参与表决 |
| 9 | LOGIN | 登录申请模式（后台签到模式），是否需要IC卡、登录码（用户编号、登录密码等）、用户姓名信息、学号信息，或直接授权<br>低4位是登录模式:<br>=0 无申请要求，要等待授权指令授权<br> =1 按键签到（应答同后面的签到码，用BCD码1FFFFF提交结果）<br> =2 要输入数字签到码登录（用3.4.3节签到码格式应答）<br> =3 ~~IC卡登录，要插入IC卡~~ V4.5 输入学号登陆<br> =4 输入（英文）姓名登录<br> =5 自动学号登陆（投票器设置好的学号信息）<br> =6 自动姓名登陆（投票器设置好的学号信息)<br><br>第7位=1的时候，表示是动态编号模式，表决器需要先用硬件序列号登陆，重新分配键盘编号（例如教育应用大学模式）|
| 10 | REPORT +LANGUAGE | 表决器报告状态模式<br> Bit0待机中报告 Bit1投票中报告 (Bit2开关机报告暂不实现)时间间隔暂时为10秒间隔<br>但如果是投票中报告，如果开始表决后5秒内没按键，就提前报告状态<br>高4位值，控制键盘使用的语言(V4.75)：<br>0是用户自己选择，>1则指定语言，具体什么语言由键盘程序决定，一般1是中文，2是英文 |
| 11 | OFFTIME | 自动关机时间<br>0xFF不关机 0使用硬件缺省其他：按分钟为单位关机 |
| 12 | ATTRIB | 表决器特性：背光模式+蜂鸣器模式<br> Bit0,1是背光模式 0关背光 1按键点亮，延时关 2结果提交成功后延时灭，否则一直保持亮，直到表决停止 3一直亮 <br>Bit2是蜂鸣器模式 1开 0关 <br>Bit3 自动提交模式 1延时自动提交 0要按提交键或OK键提交（对政务版本的表决、评议模式有效，或商务的单选多选有效）<br>Bit4 振动反馈控制 1开0关|
||||
||||
||||

## 2.2 投票模式信标


&emsp;&emsp;投票模式信标主要是作为基站取表决器数据的指令或信标。

&emsp;&emsp;投票模式信标决定了表决开始、停止，以及投票模式和参数，例如单选多选还是数字题目。

&emsp;&emsp;新版投票信标在老体系信标上增加了4字节在末尾，来传递原来基础信标里面的一些特性。

### 2.2.1 取包信标概述

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | GETCMD | 应答模式（组呼、竞争式） <br>0x17 新版本教育协议投票信标，全4字节SN号操作<br>键盘用0x93类或者0x94类指令提交数据，基站0x18、0x19做确认 |
| 2-3 | NowT | 时标值，2字节，高位在前<br>从投票启动开始的时间，用于表决器同步计时，20ms为单位，最大约21分钟，最大0xFFFF不自动变为0 |
| 4 | DATAPOS | 表决序号（结果记录序号）<br> 1-0xFF，值发生变化的时候，代表是新的一轮表决开始<br>注意：也用作表决、评议、单选多选时候结果保存的位置，可用指令读出保存的结果 |
| 5 | MODE | 投票模式<br>低6位是表决模式：<br>1-9是政务应用 10-19商务应用和教育 20-29多项和批次 30-39二维表评测 40-50管理类<br><br>0、空闲，表决停止（含答案提示）<br> 1、签到<br> 2、表决 <br>4、评分 <br>5、判断题<br> 9、模拟测试（通讯效果）<br><br>10、单选多选<br> 11、排序 <br>12、填空 <br>13、抢答 <br>14、测验 <br>15、提交作业<br>16、语音答题<br>17、分组PK<br><br>40 对码模式<br><br> $\color{red} {高2位bit6 和 bit7 } $<br> Bit6=1，白名单基站，0是普通配对基站，由基站程序控制不可设置<br> Bit7=1表示键盘要接收多条的扩展信标（2.2.17节）内容才能启动投票（键盘改无线休眠模式到32.5ms1次以快速接收，并持续到收齐内容后改标准模式减少耗电） |
| 6-22 | MODES | 投票参数，具体和MODE有关，不同模式下参数意义不同 |
| 23 | STATE | 低七位表示后台签到的Count序号（1-127循环），开启一轮新的后台签到则该序号变一次。Bit7 = 1 表示开启后台签到。 |
| 24 | WCT_Pos | 低四位为当前片在WCT中的位置(0-7)以便键盘统一休眠 <br>$\color{red} {最高位 bit7 } $ <br> bit7=1, 表示有基础扩展信标，通常启动后一直在0x17信标前广播发送，直到收到停止指令，才取消发送，如果在投票模式，键盘需先确认收到过基础扩展信标后才能进入投票，避免反复过程<br>bit6：Plus模式-><br>1：基站周期点名;<br>0：基站不发点名<br>|
| 25 | ATTRIB1 | BIT0 =0表示基站是配对基站（套装），1是自由基站（名单），这个bit位SDK不能直接修改，只能用设置基站模式修改；键盘在配对或自由选基站时候，根据此位选择基站 <br>BIT1=0 键盘不用定时监听投票信标，1启用定时监听（S61键盘有按键后才监听投票模式，这个用于控制回到标准中天模式）<br> BIT2=1键盘不关机，用于测试和生产<br> BIT4,3 控制4档键盘自动关机时间，不关机是BIT2控制<br> 00 -30秒 01-2分钟 10-10分钟 11-45分钟 <br>BIT5 =1键盘心跳打开 0关闭（要求基站同步自主控制2.3.1节里面的控制位）<br> ==BIT6—登录菜单显示允许位。1允许登录 0不允许登录== <br>BIT7—积分显示 1显示 0不显示 |
| 26 | ATTRIB2 | 基站特性2，控制考勤 <br>BIT0，1=键盘每秒发送考勤信号次数，0-3，0相当于关闭 <br>BIT2，3=00---其实还可以当他用<br>高4位是键盘发送考勤信号功率（功率写死可当他用，bit7没用） |
| 27 | ATTRIB3 | 基站特性3—基站主频点，用于键盘不跟踪到副频点 |
| ~~28~~ | ~~ATTRIB4~~ | ~~基站特性~~ 4（被CRC占用） |
| 28 | CRC | 效验值CRC16值的低位字节，注意键盘提交数据是2字节 CRC16从GETCMD到第27字节的ATTRIB3<br>注意：对WIFI体系或者5.8GTDMA体系，这里开始是2.2.18节扩展信标的内容，效验值CRC位置另外确定 |
||||

注意：

1. DATAPOS在1-255之间变化，只要是新一轮表决，就由电脑控制变化一次，例如1变为2，2变为3，只要变化，就表示是新的一轮表决开始，例如1直接变为255也是可以的。
2. 但目前DATAPOS也是保存单次表决结果的指定位置，即高可靠系统，会把表决结果按DATAPOS指定的位置保存到FLASH中。

&emsp;&emsp;不同的表决模式MODE下，后继的表决参数MODES字节含义不同，现在分别讨论不同模式下的参数含义。

### 2.2.2 空闲模式

&emsp;&emsp;空闲模式，就表示表决停止了。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =0，表示表决已经停止 |
| 6 | MSGTYPE | 附加信息类型<br>0 无，纯停止指令<br> 1 对错判断 <br>2投票结果显示（政务体系）<br> 3停止答题（高思定制—先停止，然后公布答案，然后才是停止）（有些键盘模式3也是对错判断）<br> ==4 停止带自定义信息，第8字节开始是16字符串信息== <br>9 唤醒键盘（高思，确实是9）<br>6 T2 5.8G是唤醒键盘 |
| 7-9 | HHMMSS | 基站时间 时:分:秒（暂时不改）<br>用于键盘实时时钟更新，000000键盘不处理<br>==备注：在MSGTYPE=3模式下，第7字节是前面投票模式== |
| 10 | REPMODE | 状态报告（键盘状态监控）间隔模式<br>1- 不报告<br>2- 空闲时候报告<br>3- 答题时候报告<br>4- 全时报告|
| 11 | REPTIME | 状态报告间隔，单位0.5s |
| 12 | KEYREP | 低4位，即时反馈模式<br>0- 不启用<br>1- 通用键码，不显示<br>2- 字母模式，带等级名称显示，最大5等级<br>3- 数字模式，带等级名称显示<br>4-菜单模式，按菜单选择反馈内容<br><br>高4位，等级类别，前面模式2、3时候有效<br>0-内部固定等级1<br>1-内部固定等级2<br>2-用户自定义1，最大5等级（需要提前下载到键盘）
| 13 | KEYMAX | 即时反馈最大有效按键<br>例如4，那么ABCD按键可按 ，KEYMAX ＞ 20 则（KEYMAX-20）为指定按键反馈，按键顺序与签到题指定按键一致 |
| 14 | ATTRIB_EX1 | Bit0-1 语言选择 ~~00中文 01英文~~<br> 00 默认，按键盘设置 01中文 02英文 |
| 15 | HW | 待升级硬件版本 用于后台升级 |
| 16-18 | SW | 待升级固件版本 用于后台升级|
| <font color="#00dd00">19</font>| <font color="#00dd00">BR</font> |<font color="#00dd00">待升级硬件分支 同硬件信号下匹配的不同分支 用于后台升级</font>|
| ..24 |||
<br>

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =0，表示表决已经停止 |
| 6 | MSGTYPE | 附加信息类型<br>1 对错提示 |
| 7 | TIP | 对错提示模式<br> 0 不显示对错和答案<br> 1 仅显示对错（投票器自己判断）<br>2 显示对错和答案 |
| 8 | ANSTYPE | 正确答案格式，可参考对应模式的应答数据格式<br>由于有对错判断功能的，一般需要显示正确答案，最终都要字符串比较，所以暂仅实现按字符串格式的<br>3 字符串，最多16字节，0提前结束(表决评议等级对应数字字符"1"-"0"，单选多选排序都用"A"-"Z"，多选要按"A"到"Z"的顺序重新排列，数字题用数字字符) |
| 9-24 | ANSMSG | 正确答案，最多16字节 |

### 2.2.3 签到模式

&emsp;&emsp;签到模式用于现场确定到会人数，在使用申请签到的模式下，可用指令控制签到所要输入的信息，例如要使用IC卡签到，输入用户信息等。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =1，签到模式 |
| 6 | MODE1 | 1 按键签到模式，用于清点人数，不能签到到人<br>2 User-ID、签到码签到（输入数字，用户号或密码）<br> ~~3 签到带SN号信息~~ <br>3、UID签到，带 ~~时间~~ 、电压值、序列号<br>（2、3、4统一为UID签到，返回带UID和电压值） |
| 7 | MODE2 | 0 不允许修改，首次按键有效<br>1 允许修改，末次按键有效 |
| 8 | KEYC | >0等于指定按键签到 1-9依次为按键1-9、10按键0、11UP、12Down、13ok、14Esc、15Menu|
| 9-24 | 。。。 | 参数值没有意义 |

### 2.2.4 表决模式

表决模式这里是指单项表决，对一个议题表达观点和态度，选择"赞成、反对、弃权"等。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =2，表决模式 |
| 6 | MODE1 |1&emsp;3键表决模式，中文版本是赞成/反对/弃权，英文版本是Yes/No/Abstain<br>2&emsp;2键表决模式，中文版本是赞成/反对，英文版本是Yes/No
| 7 | MODE2 | 0 不允许修改，首次按键有效<br>1 允许修改，末次按键有效|
| 8 | MODE3 | 保密模式N<br>0 不保密 1显示保密，按键提示后，延时取消按键提示<br>其他具体和产品型号有关 |
||||


### 2.2.5 判断题模式

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =5，判断题模式 |
| 6 | MODE1 | 1 True/False 对/错<br>2 Yes/No 是/否<br>3 √/×<br>4 错题本，学生输入自己是否答对 |
| 7 | MODE2 | 0 不允许修改，首次按键有效<br>1 允许修改，末次按键有效 |
| 8 | MODE3 | 保密模式，具体和产品型号有关<br>0 不保密 1显示保密，按键提示后，延时取消按键提示 |
| 9-11 || 空，用于大小题号和单选多选对齐 |
| 12 | NO1 | 大题号，0不显示，用于兼容以前键盘 |
| 13 | NO2 | 小题号，0不显示<br>用于键盘显示类似"单选题 1-3" |
| 14-24 | 。。。 | 参数值没有意义 |

### 2.2.6 数字模式

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =4，单项评分 |
| 6 | MODE1 | 评分模式<br>0 自由输入，不限定规则，最多输入14位（7字节BCD码），小数点算1位<br>1-8 原先商务体系保持兼容<br><br>9 极域-分组输入，0-99，参数模式和模式2相同（注意极域S62在ID模式下是用字符串提交的，SN模式下还是BCD）<br>20 带上下限 的数字题|
| 7 | MODE2 | 0 不允许修改，提交后不能修改<br>1 允许修改，提交后可以修改 |
| 8 | MODE3 | 保密模式，具体和产品型号有关<br>0 不保密 1显示保密 |
| 9-11 || 空，用于大小题号和单选多选对齐 |
| 12 | NO1 | 大题号，0不显示，用于兼容以前键盘 |
| 13 | NO2 | 小题号，0不显示<br>用于键盘显示类似"单选题 1-3" |
| 14-15 | 上限 | 0-655.35 精度0.01 |
| 16-17 | 下限 | 0-655.35 精度0.01 |
| 18 | 小数点位数 | 0 没有小数点 1 一位小数点 2 二位小数点 |
| 19-24 | 。。。 | 参数值没有意义 |
<br>
<br>
K1版本，带上下限的时候，不支持大小题号：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =4，单项评分 |
| 6 | MODE1 | 评分模式，K1版本<br>10 带规则，控制上下限，位数，最大16位输入，显示"数字题"<br>11 同上，但显示"请评分" |
| 7 | NUMLIKE | 低4位控制小数位数，F不限定位数，0不能有小数（输入整数）<br>高4位控制整数位数，F不限定，0表示只能输入小数 |
| 8 || 空 |
| 9-16 | MAX | 8字节BCD码格式的上限例如FFFFFFFFFFFF1234表示1234 |
| 17-24 | MIN | 8字节BCD码格式的下限 |

==数字式选举==
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =4，单项评分 |
| 6 | MODE1 | =8 数字式选举 |
| 7 | MODE2 | BIT1: 0重复 1不重复 <br> BIT2: 0不允许修改 1允许修改<br> BIT3: 0不保密 1保密|
| 8 | MaxSelN | 最大允许选举人数，0不限定，最大值暂时99|
| 9 | MinSelN| 必须选几个人，0不限定 |
| 9-10 | Abstain| 设定特殊值 0不设置 键盘内默认777 |
| 11-12 | Blank|  设定特殊值 0不设置 键盘内默认999 |
| 13-14 | TestIndex|测试编号起始，该位置有值后键盘启动测试对应这个位置起始开始发送数据|

### 2.2.7 模拟测试

模拟测试用于测试系统。可了解表决器状态或模拟进行投票测试，而不需要太多人员参与。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =9，模拟测试 |
| 6 | MODE1 | 模拟模式 <br>1 报告状态，用状态报告指令报告相关状态，键盘显示大ID和SN，用于生产排查，使用3.2.5节SN号+ID 号的状态报告提交结果<br>（远距离考勤防冲突测试，MODE2值是1秒发多少次，MODE3是发送多少秒就停止。这样，老批量速度测试软件就可评估）<br> 2 三键表决模拟，1号赞成，2号反对，3号弃权，4号赞成，5号反对。。。依次类推 <br>3报告状态， ~~但带~~~~ SN号信息（同模式1，放这里只是表示也支持模式3）~~，键盘显示姓名和SN号，使用3.2.3节SN+ID+字符串格式提交结果，如果要支持16字符姓名，使用3.2.5状态报告里面的姓名模式 <br>4远距离考勤测试，MODE2值是1秒发多少次，MODE3是射频功率等级，用于研发内部测试批量键盘通过校门的效果<br>5 WIFI数据传输测试（用模拟的语音数据测试，3.2.10节） <br>6 键盘扫描测试，开启此题后，键盘按任意键上传状态信息，用于生成编号等操作）<br>7 键盘扫描测试，开启此题后，键盘自动提交一包后台静默升级的状态包|
| 7 | MODE2 | 启动后，多少秒内随机模拟按下按键，0=马上<br>Mode1=5时，是WIFI测试方法，暂0，数据传输测试 |
| 8 | MODE3 | 提交成功后，多少秒内再重新提交，模拟修改按键，0=不测试|
| 9-24 | 。。。 | 参数值没有意义 |

### 2.2.8 单选多选模式

单选多选主要用于商务应用，对选择题进行选择。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =10，单选多选带计时模式 |
| 6 | MODE1 | 选项编号类型，对带液晶的表决器有用<br>1&emsp;显示字母ABCD。。。<br> 2&emsp;显示数字1234。。。 <br>3&emsp;多选自动测试<br> 4&emsp;简单选举，最多10人，显示按ABCD，结果也用多选格式提交（极域需求） <br>5&emsp;同4，但显示按数字，0代表10（极域需求）<br> 6&emsp;自动10次按键提交 <br>7&emsp;自动10次按键提交，但用字符串格式<br>8&emsp;网龙模式，单选显示投票题（单项），多选显示投票题（不定项）<br>9&emsp;科大讯飞定制，10单选题，Mode5是题目数，Mode6是最大选项，一般是4<br>10&emsp;科大讯飞定制，10个判断题，Mode5是题目数<br>30&emsp;可设置键盘回复的自动测试 |
| 7 | MODE2 | 0 不允许修改，提交后不能修改<br>1 允许修改，提交后可以修改 |
| 8 | MODE3 | 保密模式，具体和产品型号有关<br>0 不保密 1显示保密 |
| 9 | MODE4 | 迫选模式<br>0 不迫选，但限选MODE6个项目数<br>1 迫选，必须选出足够的项目数MODE6 <br>2 允许单个选项选多次，例如"BAAC"，但最多也只能MODE6项<br>3 允许单个选项选多次而且迫选，用于多空填空 |
| 10 | MODE5 | 最大可供选择项目数，最大值为10 |
| 11 | MODE6 | 可选出数目，最小值是1，最大值不超出MODE5 |
| 12 | NO1 | 大题号，0不显示，用于兼容以前键盘 |
| 13 | NO2 | 小题号，0不显示用于键盘显示类似"单选题 1-3" |
| 14 | NO_MODE | 题号显示模式 0按1<br>1-XX-YY，XX表示大题，YY表示小题，XX及YY均为自然数字<br>2-为XXXX，X为自然数字<br>3-为X(YY)，X表示大题，Y表示小题，X为中文，Y为自然数字 |
| 15 | MODE7 | ==MODE1\==30有效 1按数字解析 2按字母解析 0默认== |
| 16-23 | BCDVALUE | ==MODE1\==30有效 键盘需要发送的结果值 结果值，8字节BCD码表示的值==，高位在前，F表示结束字符，最多16位数，E是小数点，D是空格，C是负号 <br>2、单值结果一般就第一个BCD值有效，例如1FFFFFFF表示1，SDK用"1"表示<br>3、表示数字时候， E表示小数点，例如 1234E5FFFF 表示"1234.5" <br>4、表示单选多选排序的时候，0表示第10个选项，例如 01 32 FF FF 就是"JACB"|
| 24 | 。。。 | 参数值没有意义 |

### 2.2.9 排序模式

排序主要用于商务应用和教育应用，结果是按用户选择的顺序输出的。
排序题可以实现连线题类型，因为只要左边选项确定，输入右边连线选项的顺序即可。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =11，排序模式 |
| 6 | MODE1 | 选项编号类型，对带液晶的表决器有用<br>1 显示字母ABCD。。。 2显示数字1234。。。 |
| 7 | MODE2 | 0 不允许修改，提交后不能修改<br>1 允许修改，提交后可以修改 |
| 8 | MODE3 | 保密模式，暂不支持<br>0 不保密 1显示保密 |
| 9 | MODE4 | 迫选模式<br>0 不迫选，但限选MODE6个项目数<br>1 迫选，必须选出足够的项目数MODE6 <br>2 允许单个选项选多次，例如"BAAC"，但最多也只能MODE6项<br>3允许单个选项选多次而且迫选，用于多空填空 |
| 10 | MODE5 | 最大可供选择项目数，最大值为10 |
| 11 | MODE6 | 可选出数目，最小值是1，最大值不超出MODE2 |
| 12 | NO1 | 大题号，0不显示，用于兼容以前键盘 |
| 13 | NO2 | 小题号，0不显示<br>用于键盘显示类似"单选题 1-3" |
| 14-24 | 。。。 | 参数值没有意义 |

### 2.2.10 填空模式

填空模式用于商务应用，输入一系列的数字或英文字符。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =12，填空模式 |
| 6 | MODE1 | 填空类型<br>1 任意输入<br>2 选项填空，ABCD输入<br>3 数字填空，输入数字<br>4  填空自动测试|
| 7 | MODE2 | 0 不允许修改，提交后不能修改<br>1 允许修改，提交后可以修改 |
| 8 | MODE3 | 保密模式，具体和产品型号有关<br>0 不保密 1显示保密 |
| 9-11 || 空，用于大小题号和单选多选对齐 |
| 12 | NO1 | 大题号，0不显示，用于兼容以前键盘 |
| 13 | NO2 | 小题号，0不显示<br>用于键盘显示类似"单选题 1-3" |
| 10-24 | 。。。 | 参数值没有意义 |

### 2.2.11 对码模式

&emsp;&emsp;对码模式表示基站在对码状态，用于表决器快速对码。表决器手动切换进入对码状态后，自动寻找在对码状态的基站，然后自动完成对码。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =40，对码模式 |
| 6 | MODE1 | 0 普通配对模式 <br>1 快速配对模式1（==S60支持快速配对即可==）<br> 2 快速配对模式2（不公开，生产多套同时配对用）参见后面快速配对原理 |
| 7 | CHAN | 配对后基站的真实频点，SDK不能改写，写0<br>但基站会自动取频点值，然后键盘自动锁到真实频点 |
| 8,9 | ID | 0 只配对，不写键盘编号<br>其他值>0：<br> a、对键盘来说，键盘编号自动改写到这个号 <br>b、对SDK而言，是编号开始值，只需要写一次<br>c、对基站而言，编号成功一个键盘，ID自动加1 |
| 10 | PWD_EN | 1 键盘需要核对密码正确后才能配对（由键盘自己判断密码） |
| 11-13 | PWD | 3字节密码，用数字，例如 01 02 03 表示密码123<br>空填0xFF，比如01 02 FF 表示密码12 |
| 14| NetPos|当前组网序号  |
| 15-24 | 。。。 | 参数值没有意义 |

快速配对原理：
进入快速配对模式的基站，在频点0发送快速配对指令，键盘开机按特殊按键进入快速配对模式，例如M52按.按键开机，就先进入频点0一秒钟，如果这一秒能收到快速配对指令就直接配对和编号了。由于固定频点，省略了扫描时间，也减少了扫描错过的概率，所以能快速配对。基站在原有频点也一样发配对信息，以兼容老配对模式，和配对后键盘能锁频，但2个频点发送间隔根据实际测试效果配置。

### 2.2.12 抢答和游戏模式

抢答特指按特定的按键进行抢答，如果是要求直接提交答案的，用单选功能实现。

用3.2.1节统一BCD码格式提交结果

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =13，抢答模式或按键游戏模式 |
| 6 | MODE1 | 0 普通抢答模式 <br>1 按键游戏 <br>2 抢红包 <br>3 带键值抢答（网奕自由按键模式），键值放BCD码第一字节（例如0F到9F代表数字0-9,0x10代表数字10,0x19代表19）<br>4 拔河游戏<br>5 自定义名称游艺<br>6 抢答测试—速度测试，按模式0或2自动模拟按键提交<br>7 按键游戏自动测试模式（KEYS是1秒几个按键，SENDRULE是总共发送多少个按键）|
| 7 | KEYS | 按键模式，<br>低4位有效按键数<br>0- 所有按键有效<br>1- 特定用OK按键抢红包（青果键盘）<br>N- 键码多少内的按键有效，例如4表示1-4按键有效<br>高4位按键显示模式（针对模式2）<br>0- 单选字母<br>1- 单选数字<br>2- 多选字母<br>3- 多选数字<br>4- 判断题|
| 8 | SENDRULE | 低4位是去重规则 <br>0- 常规，提交最后1个按键 <br>1- 去重，提交时间间隔内只提交1次 <br>2- 计数，提交按键次数（数字值格式），例如拔河<br>最高bit是否允许修改<br>1=允许 0 不允许 |
| 9 | SENDTIME | 提交时间间隔，单位0.5秒<br>备注：这个参数可能没有意义，键盘都要做成上次提交成功后到当前时间，未提交的按键次数或者最后按键 |
| 10-24 | GAMENAME | MODE1=5时候是游戏名称，15字符<br>其他模式没有意义<br>MODE1=0时，字节[10]是指定按键抢答：<br>>0指定按键抢答，0等于默认。<br>（1、2、3、4、5、6、7、8、9、0、up、down、ok、esc、voice） |

青果打怪模式：Mode1取4拔河模式，Keys取1，SENDRULE取2计数模式，键盘按SENDTIME间隔设置ResultState=1提交数据，结果格式按数值格式，而且按按键总次数提交，不清零。

MODE1=1的按键游戏模式，说明如下：

键盘用A区和B区的方式，用排序（支持多个连续按键）的格式，例如3.2.11节，但首字母是A区或B区，然后剩余的15个字母是按键序列，当A区满了，用B区传输，B区满了，再用A区传送，不停循环，达到传输连续按键序列的目的。但每次传输的值，并不是新按键，而是包含前面按键的，SDK或应用程序要判断，减去上次收到的按键，才能知道哪些是新按键。

例如（按3.2.11节结果8BCD可以提交15个按键，如果是3.2.1节是13个）

第1次返回：AABC 表示现在是A区信息，按键是ABC

第2次返回：AABCAAA 按键是ABCAAA，但新按键是AAA

第3次返回：AABCAAABBBCCCDDD 新按键是BBBCCCDDD，这时候已经是15个按键，准备启用B区发送

第4次返回：BCC 是B区信息，新按键是CC

第5次返回：BCCAAB 新按键是AAB

第6次返回：BCCAABCDEFABCDEF 新按键是CDEFABCDEF，这时候B区15按键已满，准备A区发送

第7次返回：AAC 新按键是AC

第8次返回：AAC 无新按键，这次数据是键盘通讯重发引起的

总结：

对键盘而言，有两个区保存结果，A写满了才用B区，但后台提交，要注意A没送成功，B有还有的情况

### 2.2.13 测验模式（含多题小测）

这里的测验特指异步测验模式，每个学生可选择不同的答题进度。

具体参数是否有用，要根据测验的实现细节，和投票器型号有关。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4 | DATAPOS | DATAPOS和以前的不同，都表示进入测验模式，投票器可以自动进入测验 |
| 5 | MODE | =14，异步测验模式 |
| 6 | MODE1 | 测验模式（新版只使用每道题传结果的提交结果模式）<br>0 测验停止，不能再答题<br>1,2 均不指定题型 <br>4 指定题型-30题，单选多选 <br>5 多题（16题，可指定单选多选排序判断数字）<br> 6 多题带题型，32题，不带单选多选固定选项数目 <br>7 多题模式 衡水定制 <br>8多题模式 网奕定制 <br>9 小测，16题，可指定单选多选排序判断数字（K1） <br>10 简单分段模式，8段，每段内题型一样（K1） <br>11 自动提交测试<br>12 小测，64题，单选多选判断数字，不含选项数<br><br>20 带200题型控制的测验进行中（见2.2.13-1说明）<br>21 测验停止，下发200题答案，含得分（见2.2.13-2说明）<br>22 带题干内容的测验进行中<br><br><font color="#FF0000">自定义题型测验题：（6.6.2）</font><br>40 带数据下发的自定义题（类测验流程下发数据表并自动开始，没收键盘收齐报告）<br>41 纯数据表下发（用于提前下载），<font color="#FF0000">键盘端需做处理，原连续保持5S内收不到数据包发送申请，添加逻辑8S内收不到数据包发送键盘已收完，固定数据格式采用状态包，SDK自己识别</font><br>42 增量表下发（采用6.6.2.4格式下发，只告知采用已有数据表内的哪些题继续作答，键盘端缓存需独立开来，保留原有数据表缓存） |
| 7-8 | <font color="#dd0000">TESTNUM</font>| <font color="#dd0000">2字节题目编号</font>|
| ~~9-16~~ | ~~TESTNAME~~ | ~~测验名称，8字符~~ |
| 17-24 | 。。。 | 参数值没有意义 |

特殊地，当使用指定题型模式时候，下列参数解析如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 6 | MODE1 | 测验模式<br>4 指定题型，最多30道题，可指定单选多选，选项数最多8|
| 7 | REPORT | 汇报答题进度吗<br>1 汇报，切换题目后，用状态报告指令报告现在的题号<br>0不汇报 |
| 8 | TESTNUM | 题目数目，1-30 注意，最多30 |
| 9-23 | QTYPES | 15字节的题型数据，每4bit对应一个题目<br>从低4位开始，即第9字节的低4位对应第1题，高4位第2题，第10字节的低4位是第3题。。。<br>每4bit定义如下：<br>bit0是单选多选，=0单选，=1多选<br>Bit1-bit3是选项数目，0=选项数1，1=选项数2，…，7=选项数8 |
| 24 | 。。。 | 参数值没有意义 |

多题模式5，下列参数解析如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 6 | MODE1 | 测验模式<br>5多题模式，最多16道题，可指定单选多选数字，选项数最多8（每题可指定选项数目） |
| 7 | REPORT | 汇报答题进度吗<br>1 汇报，切换题目后，用状态报告指令报告现在的题号<br>0不汇报 |
| 8 | TESTNUM | 题目数目，1-16 注意，最多16 |
| 9-24 | QTYPES | 16字节的题型数据，每字节对应一个题目<br>低4位是题目类型，0单选，1多选 ~~（排序）~~ ，2数字，3判断，4排序<br>高4位是单选多选排序时候的选项数目，例如4是4选项 |
||||

多题模式6，下列参数解析如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 6 | MODE1 | 测验模式<br>6多题模式，最多32道题，不指定单选多选选项数（颂大客户）|
| 7 | REPORT | 汇报答题进度吗<br>1 汇报，切换题目后，用状态报告指令报告现在的题号<br>0 不汇报 |
| 8 | TESTNUM | 题目数目，1-32 注意，最多32 |
| 9-24 | QTYPES | 16字节的题型数据，每字节对应一个题目<br>低4位和高4位是题目类型，0单选，1多选 ~~（排序）~~ ，2数字，3判断，4排序，5填空（不能输入），6解答（不能输入） |

多题模式7 衡水定制 略

多题模式8 网奕定制 略

小测模式9，下列参数解析如下：（对应K1小测题）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 6 | MODE1 | 测验模式<br>9 小测模式，类似模式5，最多16道题，可指定题型，选项数最多8，每题可指定选项数目 |
| 7 | MODE2 | 输入模式<br>0 常规测验题多排输入<br>1 速答模式，可以一行输入，中间逗号分开，例如A，B，<br>2 单字符连续输入，只支持单选，例如AABC |
| 8 | TESTNUM | 题目数目，1-16 注意，最多16<br>高思模式下可以32 |
| 9-24 | QTYPES | 16字节的题型数据，每字节对应一个题目<br>低4位是题目类型，1单选，2多选（排序），3数字，4判断，5语音，（6自由输入），<br>高4位是单选多选排序时候的选项数目，例如4是4选项 |

分段模式10，下列参数解析如下：（对应K1小测题）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 6 | MODE1 | 测验模式<br>10 简单分段模式，题号最多8分段，可指定题型，每段题型一样，但每段最多15道题目，也不能指定单选多选选项数目 |
| 7 | MODE2 | 题号显示模式<br>0 数字<br>1 大小题号 |
| 8 | ~~TESTNUM~~ | ~~题目数目~~ （键盘不处理，按9-24的分段数据计算总题目数） |
| 9-24 | QTYPES | 16字节的题型数据，每字节对应一段题目数目和类型，00是空<br>低4位是题目类型，0不显示（主观题），1单选，2多选（排序），3数字，4判断，（5自由输入）<br>高4位是这个分段的题目数量，例如10是10题目，最大15题目，0表示空 |

备注： 每个分段的开始题号，靠键盘自己计算

自动提交测试模式11，下列参数解析如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 6 | MODE1 | 测验模式<br>11 自动提交测试模式，自动填答案A-J<br>用于测试测验是否存在少交和错误答案情况 |
| 7 || 空，不处理 |
| 8 | TESTNUM | 题目数目，1-100 |
| 9-24 |||

小测模式12，类似模式9，下列参数解析如下

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 6 | MODE1 | 测验模式<br>12小测模式，类似模式9，最多64道题，可指定题型，不指定选项数 |
| 7 | MODE2 | 输入模式<br>0 常规测验题多排输入<br>1 速答模式，可以一行输入，中间逗号分开，例如A，B，<br>2 单字符连续输入，只支持单选，例如AABC |
| 8 | TESTNUM | 题目数目，1-64 注意，最多64 |
| 9-24 | QTYPES | 16字节的题型数据，每字节对应4个题目的题型控制，单选多选选项数固定4或者6，不同产品定义可能不同<br>每2个bit位是题目类型，0单选，1多选（排序），2判断，3数字<br>例如0xE4=0b11100100 表示 第1题单选，第2题多选，第3题判断，第4题数字 |

### 2.2.13-1 带200题型控制

测验模式20是用于支持200题目的题型控制，键盘收到的指令格式如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =14，异步测验模式 |
| 6 | MODE1 | 测验模式<br>=20 带200题型控制的测验进行中 |
| 7-8 | EXAMNO | 测验编号，高字节在前<br>用于键盘取对应EXAMNO的题型数据进行考试<br>（题号显示模式、测验名称等都在数据表中）<br>可以暂为0，或不判断，只支持1个测试题型数据 |
| 9-24 || 空 |

**SDK 启动带 200 题型控制的流程如下：**

1. SDK先把题型数据写入到基站，参考基站协议2.3节指令；数据里面关键信息带测验编号EXAMNO和格式，和题型数据；
2. SDK执行写投票信标指令，里面MODE=14，MODE1=20，和EXAMNO值
3. 基站不会马上发投票信标，而是根据14和20知道是带题型控制信息的，开始用2.4节的广播信息信标，而且依次广播不同的题型信息片段，大约5秒钟，理论上所有投票器都能收齐；这时候不发投票信标，广播信息信标发5个时序，留5个时序接收数据，然后发确认信标；
4. 键盘到唤醒周期，监听基站信标，听到是广播信息信标，停止无线休眠，持续接收，接收到哪个数据片段就保存，并判断是否全部收齐（投票器根据DATAPOS和EXAMNO判断）
5. 投票器如果收齐了题型数据，自动按题型数据来启动测验输入，里面含题号格式、考试名称、题型数据；具体怎么显示、怎么控制输入都根据数据表来具体确定，这里是一个总的控制指令，不含过多信息；
6. 基站广播一段时间的题型数据后，例如5秒后，停止发广播信息信标，发投票信标，就是上面表格投票信标，表示测验进行中；这时候已经恢复正常的接收键盘数据的流程；
7. 如果有投票器是迟开机的，收到投票信标，取EXAMNO值和自己的比较，发现没有对应的测验题型数据，按3.2.6节键盘请求进行申请重新播报。
8. 基站收到申请播报，就重新执行步骤3和步骤6一次，保证新键盘可靠收到题型数据

具体的题型数据格式，见2.4.1节。

### 2.2.13-2 200题答案含得分下发

停止测验需要下载得分、键盘对错判断时候，启动这个指令如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4 | DATAPOS | DATAPOS和以前的不同，进入测验模式 |
| 5 | MODE | =14，异步测验模式 |
| 6 | MODE1 | 测验模式<br>=30带200题型答案和得分下发中 |
| 7-8 | EXAMNO | 测验编号，高字节在前<br>用于键盘取对应EXAMNO的题型数据进行考试<br>（题号显示模式、测验名称等都在数据表中） |
| 9 | MODE2 | 答案和得分的组合模式<br>0 纯答案不包含得分<br>1 纯得分不含答案<br>2 答案+得分<br>基站根据这个模式，来控制广播什么数据，如果是模式2，先广播答案，然后再广播得分，这点基站要特殊处理 |
| 10-24 || 空 |

SDK停止测验并下发答案流程如下：

1. SDK先把答案数据写入到基站，参考基站协议2.3节指令；这个步骤，可以写完题型数据之后，就写答案数据，即先把答案下载到基站准备好；也可以收卷的时候执行，但建议提前执行；
2. SDK执行写投票信标指令，里面MODE=14，MODE1=30，和EXAMNO值
3. 基站判断是14、30指令后，启动答案下发和得分下发流程，用用2.4节的广播信息信标，广播对应EXAMNO的答案数据；这个广播周期，不需要再插入读键盘结果的周期，可全部用于广播答案信息；如果需要下载得分，还需要广播得分。发送完毕，停止发广播信息信标，发投票信标内容，就是上面表格投票信标，等软件调用退出这个模式，回到空闲模式，退出考试；
4. 键盘收到答案下发指令，就退出无线休眠状态，持续接收，并保存收到的答案，判断是否收齐所有答案，收齐后自动评改， ~~显示对错、得分~~ ；也就是说，所有评改投票器自己编程完成对错题判断，但得分由电脑软件指定

具体答案数据包格式，见2.4.2节。

### 2.2.13-3 带题干内容测验（含离线答题模式）

测验模式22是用于支持20题目的带题干内容的测验，键盘收到的指令格式如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4 | DATAPOS | DATAPOS和以前的不同，进入测验模式 |
| 5 | MODE | =14，异步测验模式 |
| 6 | MODE1 | 测验模式<br>=22 带题干内容的的测验进行中<br>=23 带题干内容的离线答题题目下载<br>=24 离线题目答案提交<br>=25 不带题干的离线200题型数据下载 |
| 7-8 | EXAMNO | 测验编号，高字节在前<br>用于键盘取对应EXAMNO的题型数据进行考试<br>（题号显示模式、测验名称等都在数据表中）<br>可以暂为0，或不判断，只支持1个测试题型数据 |
| 9-24 || 空 |

&emsp;&emsp;Mode=22时候，题干内容的下载方案，见6.6节透传多包。前期也可用原来的200题型方案（2.4节广播信息信标）。

&emsp;&emsp;Mode=23时候，题干内容下载同Mode22，但加上如果键盘下载成功，用3.2.6节报告，这样sdk能知道键盘下载成功，确保可靠下载。

&emsp;&emsp;Mode=24时候，用户已经离线完成了Mode23的答案，在这个环节，用单题提交答案的方式，一个一个提交答案，同时可以满足Mode23和Mode25。

&emsp;&emsp;Mode=25是针对离线200题型的下载。

### 2.2.14 作业模式

作业模式，特指收取作业结果。即学生已经完成电子作业，老师在课堂上统一接收。

也可以用于收取特定的数据结果，例如离线调查结果。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =15，提交作业结果模式 |
| 6 | MODE1 | 提交模式。<br>对于教育应用，是否指定作业名称接收<br>1 不指定，学生随便可选1个作业提交（先实现这种模式）<br>2 ~~指定名称，无对应名称作业时，学生可选择另一个提交~~ <br>3 指定科目编号提交（1-9）<br> 4 自动测试，课后练习单题提交结果<br>5 指定科目、日期，进入后台接收模式，允许键盘提交数据<br>6 指定科目、日期，进入作业接收增量模式<br>7 模式5、6的自动测试|
| 7-14 | HOMEWK | ~~作业名称，8字符，用于确定是收哪个作业~~ <br>如果是指定编号，首字节是科目编号<br>自动测试模式4下，首字节是科目编号 |
| 15-24 | 。。。 | 参数值没有意义 |

&emsp;&emsp;提交作业流程：基站先用上述指令进入收作业模式，然后键盘使用3.2.7节多包申请提交发包申请，然后SDK再用4.1类开始多包接收进行接收具体作业结果。

在Mode1=5，6时候，格式细节如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =15，提交作业结果模式 |
| 6 | MODE1 | 提交模式。<br>5 指定科目、日期，进入后台接收模式，允许键盘提交数据<br>6 指定科目、日期，进入作业接收增量模式<br>7 模式5、6的自动测试 |
| 7-8 | HWK1 | 第1字节，高4位是科目编号1-9，低4位是月份，第1字节00表示后面空，这里科目月份合一是为了适应以后可能>4科目的需求第2字节，是日期 |
| 9-24 | HWK2-9 | 其他8科，每科2字节，第1字节00表示后面没有了 |
||||

### 2.2.15 语音答题模式

语音答题，答题器可以录音上传，可上传多个。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =16，语音答题 |
| 6 | MODE1 |0，正常录音模式<br>1，自动录音测试<br>2，语音红包模式，键盘提示有区别，SDK有连续语音数据流输出<br>3，数据信道传输测试，按语音包格式，数据长度FMODE决定，而且数据有规律，测试软件可以容易判断是否有丢包现象和错误数据<br>4，语音质量测试|
| 7 | TIME | 录音限时，单位秒，0不限时 |
| 8 | NUM | 是否允许多个录音 0，只能1个，>1可以多少个 |
| 9 | ALERT | 剩余多少秒开始提醒，0 不提醒 |
| 10 | FMODE | 录音格式，暂0<br>0 缺省格式，中天内部标准选定以下一种 <br>1 A率压缩，8K采样，8bit数据 <br>2 PCM格式不压缩，8K采样，16bit数据 <br>3 A率压缩，16K采样，8bit数据 <br>4 PCM格式不压缩，16K采样，16bit <br>5 A率压缩，32K采样，8bit数据 <br>6 SPEEX压缩，8K采样率<br>7 SPEEX压缩，16K采样率 |
| 11 | OK_STATUS | 0 正常流程<br>1 强制流程 录音过后按OK键提交录音结束语句，使用心跳提交 |
| 12-13 | VOLUME | 语音质量测试时候有效<br>2字节，录音信号幅度值下限，大于才ok |
| 14-15 | NOISE | 语音质量测试时候有效<br>2字节，录音信号底噪上限，小于才ok |
| 16 | Buttonmode | 按键方式 0 默认 按压录音  1 单击录音 |
| 17-24 | 。。。 | 参数值没有意义 |
### 2.2.16 拍照图片传输

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =17，拍照传输 |
| 6 | MODE1 | 0 60路同时传输模式<br>1 先拍先传模式（适合单个传输） |
| 7 | MODE2 | 0是手动。大于0，自动拍照间隔，用于自动测试 |
| 8 | MODE3 | 拍照次数 0xFF一直自动拍照 |
| 9 | MODE4 | 压缩等级，1-100，0表示使用缺省值 |
| -24 | 。。。 | 参数值没有意义 |

~~2.2.16 分组PK模式（待细化）~~

~~分组~~ PK开始，每组可以不同题目，每组人员可以答组内不同题目。

~~暂针对~~ WIFI系统，由于参数比较长，大于RF的24字节，是使用WIFI系统长指令包格式打包。如果是RF系统，使用2.4节发信息信标实现。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =17，分组PK |
| 6 || 允许参加的组别，bit位控制，1=允许参加，0不参加|
| 7-14 |||
| 15-24 | 。。。 | 参数值没有意义 |

### 2.2.17 扩展信标（高思、新东方）

&emsp;&emsp;【高思 T1\_WIFI版本】需求上，要求每一个题型都可以自定义6个汉字的题型显示，要求多题控制题型满足到30题目，所以投票信标28字节放不下。考虑到是wifi平台，走的是tcpip或者udp，协议包长度可以加长，所以，可以在2.2.1节的投票信标第28字节后面，附加新的信息。（wifi平台SDK是软基站，所以暂无对应的基站设置指令）

&emsp;&emsp;也就是具体命令包开头，F5 AA AA LEN中的LEN长度，要根据实际的做调整，加大。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | GETCMD | ~~0x31 表示附加信标信息~~ <br>注意，高思wifi版本，这个位置其实是第29字节 |
| 2 | ATTRIB3 | 特性控制3。这里，bit=1表示开或者允许，0表示关<br>Bit0 开机震动<br>Bit1 刷卡震动<br>Bit2 答题开始震动<br>Bit3 开机蜂鸣<br>Bit4 刷卡蜂鸣<br>Bit5 答题蜂鸣<br>Bit6 指示灯开关<br>Bit7 心跳信号开关 |
| 3 | ATTRIB4 | 预留，特性4。bit=1表示开或者允许，0表示关<br>Bit0 全程麦克风使能|
| 4-15 | TITLE | 自定义12字节的题型名称，6个汉字，如果不是00开头，键盘就显示这个题型，例如多选时候可以显示"不定项多选"<br>00开头，表示没有用自定义，还是显示标准题型提示，例如"多选" |
| 16-31 | QTYPES | （高思小测使用小测模式9）<br>这里对应17到32题的16字节的题型数据，每字节对应一个题目低4位是题目类型，1单选，2多选（排序），3数字，4判断，5语音，（6自由输入），<br>高4位是单选多选排序时候的选项数目，例如4是4选项 |

#### 2.2.17-1 自定义题型名称

【新东方模式】，要求自定义题型名称，8汉字。考虑到通用性，设计如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | GETCMD | 0x33 表示扩展投票信标信息（0x31和0x32做基站广播信息信标了） |
| 2 | INFOTYPE | 信息类型 <br>1= 自定义题型名称 <br>~~2可能是题型控制…~~ |
| 3 | ~~NULL~~ INFOBITS | ~~暂0，备用，\>0可能是组呼用的组号，0表示竞争式~~ <br>8bit，对应INFOTYPE=1-8，bit=1表示键盘这次投票用到这个类型的信息，键盘要收齐才能启动投票界面 |
| 4 | DATAPOS | 用于键盘判断，内部保存的自定义名称是否是这次投票的<br>不是，不用显示。键盘开机先置0。 |
| 5-24 | TITLE | 自定义20字节的题型名称，10个汉字，例如多选时候可以显示"不定项多选" 。具体支持多少汉字显示看键盘类型。 |
| 25-27 || 第27字节写基站主频点（解决自定义题型有些键盘锁频不稳） |
| 28 | CRC ||

&emsp;&emsp;基站一般情况下，不广播这个信标，如果启用了自定义题型名称（SDK执行了写扩展信标指令《基站2.4节写扩展信标》，而且DATAPOS相同---SDK写DATAPOS的时候是下次投票的DATAPOS），启动投票后， ~~就和~~~~ 0x17信标交替广播，就是1次0x33，1次0x17，都是1问10答，SN模式下各32.5ms，停止投票后又恢复只有0x17信标广播。~~（在增加指定键盘答题后修改成）基站在0x17信标前先发送所有的0x33信标（如果有多条，例如同时启用自定义标题和指定答题器，那就有2条0x33，但INFOTYPE不同），然后发0x17，然后等键盘数据，然后发确认，然后再发0x33，重复，直到停止答题，停止答题后恢复只有0x17的信标。

&emsp;&emsp;键盘端处理0x33指令，按INFOTYPE位置先保存信息，不休眠继续听无线指令即可。为可靠判断投票是否带0x33扩展信息和收齐，键盘可以加上投票启动时候无线不休眠300ms，300ms后如果有0x33那基本都收齐了，然后启动正式投票输入流程。如果有0x33信息，要判断DATAPOS是否相同，不同，表示不是这次的信息不用处理。

#### 2.2.17-2 指定键盘答题

用SN号指定某些答题器参与投票：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | GETCMD | 0x33 表示扩展投票信标信息 |
| 2 | INFOTYPE | 信息类型2=指定键盘SN答题 |
| 3 | NULL | 暂0 |
| 4 | DATAPOS | 用于键盘判断，内部保存的自定义名称是否是这次投票的&emsp;&emsp;不是，不用显示。键盘开机先置0。 |
| 5-8 | SN1 | 可投票的键盘1的SN，高位在前 |
| 9-12 | SN2 | 第2个SN，全0表示空 |
| 13-16 | SN3 | 第3个SN，全0表示空 |
| 17-20 | SN4 | 第4个SN，全0表示空 |
| 21-24 | SN5 | 第5个SN，全0表示空 |
| 25-27 || 空 |
| 28 | CRC ||

### 2.2.18 手写单题

数据的提交格式，参考《语音TDMA协议设计V0.7》，用0x97包提交。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 5 | MODE | =18，手写答题 |
| 6 | MODE1 | 参数暂无
 |
| 7- | 。。。 | 参数值没有意义 |

### 2.2.19 T2扩展信标

#### 2.2.19-1 自定义标题和指定SN答题、遥控开机

T2由于投票信标可以64字节，所以自定义标题和指定SN是直接放后32字节

同时，0x32遥控开机，和标准版本的0x32指令冲突

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | GETCMD | 0x31 投票附加信息<br>0x32 遥控开机 |
| 2 | ATTRIB3 | bit == 0 表示开 1表示关<br><font color="#ff0000">这里为了兼容0开1关</font><br /><br>bit0 开机震动<br>bit1 刷卡震动 <br>bit2 答题开始震动<br>bit3 预留<br>bit4 预留<br>bit5 预留<br>bit6 指示灯开关<br>bit7 预留<br><font color="#ff0000">该字节不由信标带下来，为设置基站参数，基站保存写入</font><br /> |
| 3 | ATTRIB3 | 预留<br><font color="#ff0000">该字节不由信标带下来，为设置基站参数，基站保存写入</font><br /> |
| 4-19|xtitle[16]| 16字节 |
| 20-27|xtitle[8]| 最多2个键盘 |
| 28|Broadcast Number| 值等于datapos 广播序号 1-255 由软件下发广播信息内带的datapos，基站填写到这个位置（软件知道下发的广播是哪个datapos投票的解析数据） 该位置对应6.6.2.2透传广播 其中键盘申请为3.2.6的REQTYPE==20|
||||

#### 2.2.19-2提交成功后提示信息

&emsp;&emsp;科大讯飞定制增加，和自定义标题一起，可修改2个提示。
&emsp;&emsp;SDK通过基站协议-2.4节设置扩展信标进行设置，对应INFOTYPE是3。（实际SDK是按InfoType做的，没考虑GETCM---基站协议笔误）
&emsp;&emsp;如果先设置INFOTYPE=3的内容，然后再设置0x17投票信标启动投票（并且是带0x31自定义标题内容的），就表示这次投票功能要启用0x39信标功能。这时候T2基站，投票信标发送2条各64字节，第1条是0x17（带0x31内容），然后发0x39信标，原先是2条相同的0x17。
&emsp;&emsp;包括录音模式也改成发2条，原先录音只有1条0x17。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | GETCMD | 0x39 表示T2扩展投票信标信息 |
| 2 | InfoType | 暂3 |
| 3-18 | TitleSendOk | 提交成功后提示语16字符 |
| 。。。 || 后期可加其他信息 |
||||

## 2.3 确认包信标

### 2.3.1 标准确认包

新版确认包，可以一次确认5个SN号键盘数据。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x18，新版本SN号确认包的第1包 <br>0x19，新版本SN号确认包的第2包<br>（可判断时序位置，利于时钟同步） |
| 2 | CMD_BITS1 | 用于通知键盘的一些控制位 ==（基站同频，无投票信标模式下才用）== <br> BIT0 =1 考勤打开 0考勤关闭 <br>BIT1=1 心跳打开 0心跳关闭<br> BIT2=1 监听基站信标，用于在线测试 0不监听信标<br>BIT4,3 控制4档键盘自动关机时间，不关机是BIT2控制<br>00 -30秒 01-2分钟 10-10分钟 11-45分钟 |
| 3 | CMD_BITS2 | 备用 |
| 4-7 | SN1 | 第一个SN号，高位在前<br>全00为空 |
| 8 | SN1-CMD | 对第一个SN号键盘的确认状态<br>键盘据此命令做不同的提示或操作 0-200 已经用作测验题确认题号<br>201 数据提交正确（或自由登陆OK） <br>202 数据格式不对，数据提交无效（或自由登陆失败，密码不对） <br>203 不在投票状态，数据提交无效 <br>204 没有投票权限，数据提交无效（包括不在白名单）<br>205 表示键盘进入监听模式（适配S7 7键的不监听键盘）<br> |
| 9-12 | SN2 | 第2个SN号，高位在前 |
| 13 | SN2-CMD | 对第2个SN号键盘的确认状态<br>定义同SN1-CMD |
| 14-17 | SN3 | 第3个SN号，高位在前 |
| 18 | SN3-CMD | 对第3个SN号键盘的确认状态<br>定义同SN1-CMD |
| 19-22 | SN4 | 第4个SN号，高位在前 |
| 23 | SN4-CMD | 对第4个SN号键盘的确认状态<br>定义同SN1-CMD |
| 24-27 | SN5 | 第5个SN号，高位在前 |
| 28 | SN5-CMD | 对第5个SN号键盘的确认状态<br>定义同SN1-CMD |

特殊地，200题型测试测试中发现，丢题是因为确认包没有CRC的情况，为保持兼容，基站在200题型时候，确认包只发4个SN，第5个SN特殊处理当CRC用：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 24-26 | CRC_EN | 3字节FF，这样既可以保证没有SN相同（兼容老的协议），新版本键盘也可以知道是带CRC效验的确认包 |
| 27-28 | CRC ||

### 2.3.2 确认包带基站信息（白名单模式）

告诉指定SN的键盘，它对应的白名单基站是在什么频点，是对3.2.4节键盘登录请求模式3的应答。一般情况下不发送，只有键盘发请求后才发送，一个时序内（例如30ms）应答。

考虑到只有几个频点的白名单方案，可能同时很多键盘开机，白名单确认多些能提高速度，对指令优化如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x1A，确认包带信息<br>用于指挥键盘做一些事情，信息比较多，2.3.1节没法处理了<br>可以当做类似0x30指令的另外一种格式的单包下载 |
| 2 | MSGTYPE | 信息类型，也决定了后面数据的解析格式<br>2 白名单基站信息(多个键盘同时确认) |
| 3 | FREQ | 基站的主频点，键盘跳到基站主频点去听命令<br>（配对码直接从包头取，原始数据包CMD前有4自己配对码） |
| 4-7 | SN1 | 第1个键盘SN |
| 8-11 | SN2 | 第2个键盘SN，全00或FF表示空 |
| 12-15 | SN3 | 第3个键盘SN |
| 16-19 | SN4 | 第4个键盘SN |
| 20-23 | SN5 | 第5个键盘SN |
| 24-28 | SN6 | 第6个键盘SN |

拓维EA5000T双模块版本：（仅对应一个键盘）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x1A，确认包带信息用于指挥键盘做一些事情，信息比较多，2.3.1节没法处理了<br>可以当做类似0x30指令的另外一种格式的单包下载 |
| 2 | MSGTYPE | 信息类型，也决定了后面数据的解析格式<br>1 白名单基站信息 |
| 3-6 | SN | 要接收指令的键盘的SN号，4字节，高位在前 |
| 7 | FREQ | 基站的主频点，键盘跳到基站主频点去听命令<br>（配对码直接从包头取，原始数据包CMD前有4自己配对码） |
| 8-20 |Name| 基站名称 |
| 21 |Netpos| 当前netpos值 |
| 22-23 |PSW| 0表示没密码-该位置为组网信标内PSW值 |
| 24-25 |PSW_enable| 0x5a 0x98,因原始改位置是无序乱码固写一个固定核对值，核对值有效则值有效|
| 21-28 || 空 |

## 2.4 广播信息信标

用于由基站控制，广播一段数据，这样会比SDK控制发送更快。

当键盘听到这种命令，就会连续监听数据，直到收到正常的取包信标。键盘一般需要保存数据，并判断是否全部收齐，收齐后一般还根据数据包类型自动执行某些操作。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x31 基站连续广播信息，ID模式，所有接收或指定 <br>0x32 基站连续广播信息，指定SN模式<br>0x33 （用作基站扩展信标—参见2.2.17节） |
| 2-3 | KEYID | 键盘编号，高位前<br> 0000表示广播，所有键盘都接收<br>不是0000就指定ID<br>如果指定SN模式，这里可以放6字节SN键盘的高2字节，4字节SN的话填FFFF |
| 4-7 | SN | 4字节SN |
| 8 | DCMD | 低4位，数据包类型—键盘根据类型选择保存位置和处理方式<br> 1 多题题型数据<br> 2多题答案数据<br> 3 得分表数据<br> 4 短信息下发<br> ==高4位作为datapos用，基站自动增加== ，1-15，用于键盘判断是否是新数据还是上次数据重播 |
| 9 | TSLOT | 时序信息，用于键盘判断是否能提交数据，有基站自动控制<br>高4位，代表广播信标占用几个时序，1起，例如5的话，表示广播信息用了5个时序，那么只剩下10-5=5个时序键盘可以提交数据低4位，表示这个数据包是第几个时序，1起，利于键盘跟踪同步 |
| 10 | SLOTMAX | 下发数据包共多少包数据，1起，每包16字节<br>（最大255,255x16= ==4080字节==） |
| 11 | SLOTN | 第多少包数据 |
| 12-27 | DATA | 这个包的16字节数据 |
| 28 | CRC | 校验值CRC16值的低位字节，从第1到第27字节<br>（不能超出28字节，加4字节配对码就到2401最大的32字节） |

以下描述的是广播的数据包的总的格式，最终是用上述指令，切成每片16字节数据来广播：

### 2.4.1多题题型格式

注意，有多种格式，键盘根据格式号具体处理，长度也不一样。
对于题型数据，具体数据格式受FORMAT控制，一般EXAMNO位置不变。
格式2，多个分段，每段里面小题题型可以单独设置，测验名称16中文字符
注意下面字节编号，对应物理地址都要减1！

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | TYPE | 数据包类型<br>1 测验题题型数据 |
| 2 | FORMAT | 数据包格式<br>2 格式2，下面所有数据都是格式2的结构 |
| 3 | PACKLEN | 数据包数据量，以16字节为1单位，（最大255x16=4080字节数据），有些可以固定<br>例如16，表示共256字节 |
| 4-5 | EXAMNO | 测验编号，高位在前 |
| 6 | ITEMNO\_M | 题号显示模式，（大题和后面分段一个概念）<br>1-XX-YY，XX表示大题，YY表示小题，XX及YY均为自然数字<br>2-为XXXX，X为自然数字<br>3-为X(YY)，X表示大题，Y表示小题，X为中文，Y为自然数字 |
| 7 | SECTIONS | 分段数目，最多16 |
| 8 | TOTAL | 题目总数，最大200，可以输入的题目<br>不包含有题号但不能输入的题目，例如主观题，SDK要计算 |
| 9 | SELMAX | 单选多选最大选项数目，小于4的默认4，最大10 |
| 。。。 || 空 |
| 17-48 | EXAMNAME | 32字节的测验名称 |
||| **（以下是 2 字节为一段的分段信息，共 32 字节，空填 00 ）** |
| 49 | SECTION_NO1 | 第1段显示段号码，也就是支持第一段显示段号二 |
| 50 | NUM1 | 第1段题目数，一定要准确，键盘要根据来取题型和显示小题号 |
| 51-52 || 第2段的段号和题目数 |
| 。。。 |||
| 79-80 | SECTION16 | 第16段的段号和题目数，如果有16段 |
||| **（以下开始是**** 1 ****字节代表的每题的题型）** |
| 81 | TYPE1 | 第一段题目1的题型类型<br>0不能输入（主观题），1单选，2多选（排序），3数字，4判断，（5自由输入）6 语音 7 手写<br>（如果要每题还控制选型数目，高4位做，暂统一SLEMAX控制） |
| 82 | TYPE2 | 第一段题目2的题型类型 |
| 。。。 |||
| 280 || 第200题的题型，如果有200题的话 |
| -288 || 凑满16字节 |

（下面是K1版本的格式1）
格式1，分段题型，段内题型一致，选择题可设定最大项目数：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | TYPE | 数据包类型<br>1 测验题题型数据 |
| 2 | FORMAT | 数据包格式<br>1 格式1，下面所有数据都是格式1的结构 |
| 3 | PACKLEN | 数据包数据量，以16字节为1单位，（最大255x16=4080字节数据）<br>例如16，表示共256字节 |
| 4-5 | EXAMNO | 测验编号，高位在前 |
| 6 | ITEMNO\_M | 题号显示模式<br>0 数字<br>1 大小题号 |
| 7-8 || 空 |
| 9-24 | EXAMNAME | 16字节的测验名称 |
||| （以下是4字节为一段的测验题题型） |
| 25 | NUM | 第一段题目数 |
| 26 | TYPE | 第一段题目类型<br>0不显示（主观题），1单选，2多选（排序），3数字，4判断，（5自由输入）6 语音 7 手写 |
| 27 | SELMAX | 题目类型是单选多选时候是选项数，0的时候不限定<br>选择题项目数，一般是4 |
| 28 | STARTNO | 空，0。>0可作为开始题号，但事实上可以不用 |
| 29-32 || 4字节第二段题型数据 |
||| 第3段题型数据… |
|| 。。。 | 一直到PACKLENx16位置，空的填00 |
||||

### 2.4.2 答案下发格式

第一个版本，每道题16字节字符串答案。
注意：判断要根据题型，是主观题的不判断不显示

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | TYPE | 数据包类型2 <br>测验题答案 |
| 2 | FORMAT | 数据包格式<br>1 格式1字符串答案，下面所有数据都是格式1的结构 |
| 3 | PACKLEN | 数据包数据量，以16字节为1单位，从第1字节起<br>例如16，表示共256字节 |
| 4-5 | EXAMNO | 测验编号，高位在前<br>对应题型数据的EXAMNO |
| 6 | EXAMNUM | 题目总数 |
| 7-16 || 空 |
||| （以下是16字节一个题目答案数据） |
| 17-32 | ANSOK1 | 第1题题目正确答案，字符串编码 |
| 33-48 | ANSOK2 | 16字节，第2题题目的分数和正确答案 |
| 。。。 | ANSOK3 | 16字节，第3题题目的分数和正确答案 |
| 。。。 || 。。。 |

### 2.4.3 得分下发格式

这个模式主要的广播所有键盘的得分，来取代单包下载模式（可能速度慢）
键盘在信标表里面找自己对应的SN的得分，然后显示。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | TYPE | 数据包类型<br>3 键盘得分表，通过SN或者ID来控制 |
| 2 | FORMAT | 数据包格式<br>1 格式1，下面所有数据都是格式1的结构 |
| 3 | PACKLEN | 数据包数据量，以16字节为1单位，从第1字节起<br>例如16，表示共256字节 |
| 4-5 | EXAMNO | 测验编号，高位在前<br>对应题型数据的EXAMNO |
| 6 | KEYPADNUM | 键盘个数 |
| 7-8 || 空 |
||| （以下是8字节一个键盘得分数据，6字节SN，1字节得分） |
| 9-16 || 8字节，第1个键盘的SN和得分<br>前6字节是SN号，教育体系前2字节FFFF<br>第7字节是得分<br>第8字节是小数得分（暂不用） |
| 17-24 || 8字节，第2个键盘的SN和得分 |
| 25-32 || 8字节，第3个键盘的SN和得分 |
| 。。。 || 。。。 |
||||

### 2.4.4乐教乐学-多题题型格式

乐教乐学定制要求3级题号，要求最多999题目，支持填空和自判题
对于题型数据，具体数据格式受FORMAT控制，一般EXAMNO位置不变。
注意下面字节编号，对应物理地址都要减1！

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | TYPE | 数据包类型<br>1 测验题题型数据 |
| 2 | FORMAT | 数据包格式<br>3 格式3，乐教乐学专用 |
| 3 | PACKLEN | 数据包数据量，以16字节为1单位，（最大255x16=4080字节数据），有些可以固定<br>例如16，表示共256字节 |
| 4-5 | EXAMNO | 测验编号，高位在前 |
| 6-7 | TOTAL | 题目总数，高位前，最多999|
| 8 | SELMAX | 单选多选缺省选项数目，一般是4，最大10 |
| 9 | QUES_MODE | 题号显示类型，1-3 <br>4（带上限设置数字题类型）<br><font color="#00dd00"> 5、6、7 多科目200题，对于123显示模式</font><br /> |
| 10-16 || 备用 |
||| **（以下是 4 字节为为 1 题的题型信息， 100 题目就是400 字节）** |
| 17-19 | QUES_NO1 | 3字节的题号，例如题号11-22-33的话，3字节前后就是11、22、33。0表示空，例如1-3就是1、3、0<br>（带上限数字题类型 第一字节表示题号 、第二/三字节表示上限、刻度0.01 最大655.35，下限默认为0） 超限提交 键盘自己提示"输入超限" <br><font color="#00dd00"> 12 字节表示大小题号<br>第三字节<br>低四位表示科目，高四位预留<br>低四位：<br>1语文<br>2数学<br>3英语<br>4政治<br>5历史<br>6地理<br>7生物<br>8物理<br>9化学</font><br />|
| 20 | TYPE1 | 第一段题目1的题型类型，低4位<br>0不能输入-跳过（主观题），1单选，2多选（排序），3数字，4判断，（5自由输入）6 语音 7 手写 8自判题-对错（乐教乐学）9 自判题-数字（输入评分）<br>高4位控制选型数目，如果是0，单选多选按前面SELMAX值<br>（带上限数字题类型 该位置不表示题型，键盘自己固定全为数字题）<br>该位置含义改为小数点位数（0 无小数点 1/2 位小数点 最多支持2位，只使用低4Bit 高4BIT预留） |
| 21-24 | QUESINFO2 | 4字节，第2个题目的题型数据 |
| 。。。 |||
| 。。。 || 4字节，第TOTAL题的题型数据 |
| 。。。 || 凑满16字节 |

### 2.4.5带题干内容题型

带题目文字内容的题型，数据包格式如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | TYPE | 数据包类型<br>2 带题干内容测验题题型数据 |
| 2 | FORMAT | 数据包格式<br>1 格式1，以下字节顺序是对应格式1的 |
| 3-4 | EXAMNO | 测验编号，高位在前 |
| 5-6 | DataLEN | Data段的字节长度，从第9字节开始计算 |
| 7-8 | DataCrc | Data段的CRC值，0000不判断，从第9字节开始计算 |
| 9 | Data | 题型数据 |

Data 段格式：

| TitleNum | 题目总数量 | 1 Byte |
| --- | --- | --- |
| Num | 当前题号 TopicNum | 1 Byte |
| NumLEN | 当前题号TitleData长度 | 2 Byte |
| InputType | 答案显示类型(题型，和200题统一)<br>1:单选<br>2:多选<br>3:数值 <br>4:判断√×<br>5:填空-自由输入<br><br>以下暂不做：<br> ~~6:表决-赞成 反对~~~~ <br>7:表决-赞成 反对 弃权 <br>~~~~8:对错~~~~ <br>9:是否~~| 1 Byte |
| MODE1 | 最大可供选择项目数，最大值为10 | 1 Byte |
| MODE2 | 可选出数目，最小值是1，最大值不超出MODE5 | 1 Byte |
| MODE3 | 预留，先0 | 1 Byte |
| TitleData | 题目文本数据 | N data |

TitleData 格式：纯文本\n换行 （键盘根据\N换行显示与一行显示完全换行。换行时注意英文半子）

这是一个例题\n
A:选项1\n
B:选项2\n
C:选项3\n
D:选项4\n
E:选项5\n

TitleData最大200字节95汉字左右，则总缓存大小为：（200+7）*20 +3 = 4143字节
TitleData最大150字节70汉字左右， 则总缓存大小为：（150+7）*20 +3 = 3143字节

## 2.5投票附加数据 - S6新体系

新体系下（需具备键盘统一周期休眠） 投票附加数据协议，具体传输方式与协议如下：

![WCT](img/WCT.png)

在WCT周期中的第0周期发送17信标之前发送投票附加数据包 ==（周期性广播发送）==，基站根据数据内容的长度，自动切换成相应的发送包数，目前暂定缓存最大5包。并且0X34扩展信息包不需要2.5MS才发送一次，基站到达发送时刻一次性发送出去。
Cmd_Data 不足32一包 后面补0

==使用方式：暂时只支持一次投票只有一次附加数据。不可以在一次投票过程中有多次不同的附加数据==

基站：必定MODE的BIT7位= 1，才有0x34包在WCT周期中周期性发送
键盘：当MODE的BIT7位为1时，必须等待收完DATAPOS相同的0X34附加信息才开始答题。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | GETCMD | 0x34表示扩展投票信标信息 |
| 2 | PACKMAX | 后续传输包数量 暂定此处为最大为5（最大支持五包连续，数据最大为：21+32+32+32+32 =149字节 = 基站每条指令缓存大小）指令按大小基站自动调整是发送一个包还是3个包（基站提供） |
| 3-4 | CRC16 | 本包透传数据的CRC CmdData 的CRC（基站提供） |
| 5 | DATAPOS | 用于键盘判断，是与那次投票绑定的数据。<br>不是，不用显示。键盘开机先置0。 |
| 6-7 | NULL | 预留 |
| 8-28 | Cmd_Data | 第一包21字节（SDK提供） |
| 29-61 | Cmd_Data | 第二包32字节（SDK提供） |
| 62-93 | Cmd_Data | 第三包32字节（SDK提供） |
| 94-125 | Cmd_Data | 第四包32字节（SDK提供） |
| 126-157 | Cmd_Data | 第五包32字节（SDK提供） |

### 2.5.1 CMD概述

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 1：自定义题目标题 |
| 1 | LEN | 长度（长度为Data长度，可为0） |
| N | Data | 数据详细内容 |

### 2.5.2 自定义题目标题

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 1：自定义题目标题 |
| 1 | LEN | 长度： 暂定8个字 < 16字节 |
| N | Data | 字符串标题数据 |
### 2.5.3 选举名单bit位图

| **字节** | **标识符** | **描述** | 
| --- | --- | --- |
| 1 | CMD | 类型<br> 2： 选举名单bit位图 |
| 1 | LEN | 长度： 125字节 |
| N | Bits | 1表示允许 0不允许 |
## 2.6基础扩展信标
原理同2.5投票附加数据 - S6新体系， 开启后不管是空闲还是投票，在取消之前每次都会在0x17信标前发送。在0x17投票信标的WCT_Pos字节的 bit7=1, 表示有基础扩展信标，基站通常收到基础扩展启动指令后一直在0x17信标前广播发送，直到收到基础扩展信标停止指令，才取消发送，如果在投票模式，键盘需先确认收到过基础扩展信标后才能进入投票，避免反复过程。
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x35 标识 |
| 2 | TYPE| 子类，不同子类，6-32的数据含义不一致 |
| 3 | PACKMAX | 目前仅为1，留出扩展空间，如有需要可以参考章节2.5修改为多包模式 |
| 4-5 | CRC16 | 后续总数据，（目前是6-32字节）的CRC（基站提供） |
| 6-28 | DATA | 数据 |

## 2.6.1 基础配置
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 2 | TYPE| 1，基础配置 |
| 3 | PACKMAX | 1 |
| 4-5 | CRC16 | 后续总数据（目前是6-32字节的CRC） 的CRC（基站提供） |
| 6-7 | AUTHCODE | 授权号，2字节，高位在前，0-0xFFFF <br>=0时候不使用授权模式，表决器可以参与表决<br>>0时候，表决器保存的授权号相同才能参与表决 |
| 8 | LOGIN | 登录申请模式（后台签到模式），是否需要IC卡、登录码（用户编号、登录密码等）、用户姓名信息、学号信息，或直接授权<br>低4位是登录模式:<br>=0 无申请要求，要等待授权指令授权<br> =1 按键签到（应答同后面的签到码，用BCD码1FFFFF提交结果）<br> =2 要输入数字签到码登录（用3.4.3节签到码格式应答）<br> =3 ~~IC卡登录，要插入IC卡~~ V4.5 输入学号登陆<br> =4 输入（英文）姓名登录<br> =5 自动学号登陆（投票器设置好的学号信息）<br> =6 自动姓名登陆（投票器设置好的学号信息)<br><br>第7位=1的时候，表示是动态编号模式，表决器需要先用硬件序列号登陆，重新分配键盘编号（例如教育应用大学模式）|
| 9-12 | FREQ1-FREQ4 | 主频点，副频点2，副频点3，副频点4，0的话不启用 |
| 13-28 | ... | 保留 |

## 2.7点名信标 
投票信标与广播信标需要置位plus模式位
点名信标为连续2个标、0x12点名1-5号 0x13点名6-10号。
时序如下图：
![点名时序图](img/点名时序图.png)
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x12/0x13 标识 |
| 2 | SEQ| 序号1-255 新的一轮点名 ，控制键盘上传间隔|
| 3 | TickCount| 序号1-255 基站发送一轮信标该值加1 12/13标内该值相同，用于键盘判断是否在连续点名周期|
| 4 | ACK |上个周期收到键盘SN的ACK<br> 12回12  13回13<br> 按bit位设置 bit = 1表示收到该位置SN的数据 <br>位控制（直接位域控制）<br>1:SN1ACK<br>2:SN2ACK<br>3:SN3ACK<br>4:SN4ACK<br>5:SN5ACK|
| 5-8 | SN1 | 键盘的SN号，4字节，高位前，全00表示空|
| 9-12 | SN2 | 键盘的SN号，4字节，高位前，全00表示空|
| 13-16 | SN2 | 键盘的SN号，4字节，高位前，全00表示空|
| 17-20 | SN2 | 键盘的SN号，4字节，高位前，全00表示空|
| 21-24 | SN2 | 键盘的SN号，4字节，高位前，全00表示空|
| 25-27 | NULL |预留 |
| 28| CRC | 空中数据最后1字节是CRC|

键盘被点名上传信息格式如下:
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>22 点名上传|
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7-8 | KEYID | 表决器ID |
| 9 | HMODEL | 键盘的型号代码|
| 10 | HVER | 键盘硬件版本 |
| 11-13 | SVER | 键盘软件版本，3字节，10进制数字 |
| 14 | VOLT | 电池电压，Bit7为1表示在充电，低7位x0.04V就是电池当前电压 |
| 15 | SEQ | 键盘该轮次值 对应0x12/0x13 |
| 16 | TickCount | 键盘该轮次值 对应0x12/0x13 |

# 三、上传单包类

## 3.1概述

&emsp;&emsp;上传单包类主要是上传简单的投票结果、状态、申请等。一般情况下，表决器如果有数据要上传，在收到基站的投票信标后，根据防冲突算法，在一定的时序里发送数据包。基站接收到完整数据包后，给出数据确认应答，让表决器知道数据已经上传，不再多次发送。
&emsp;&emsp;新体系，键盘仅使用键盘SN模式提交数据，上传单包的数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x93新体系硬件序列号提交结果0x94硬件序列号带编号提交结果（S6Plus）|
| 2 | ANSTYPE | 数据包类型|
| 3-28 | ANSDATA | 根据结果类型ANSTYPE的不同，有不同的数据长度和含义 |

对于不同类型的数据格式，后节详细解析。

基站对上传单包数据的确认应答包结构具体参考2.3节。

## 3.2新版序列号结果类

键盘使用硬件序列号而不是键盘编号来上传数据，这时候数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x93新体系硬件序列号提交结果<br>0x94硬件序列号带编号提交结果（S6Plus）<br>0x94开头时候，第7、8字节是键盘编号 |
| 2 | ANSTYPE | 数据包类型（根据ANSTYPE的不同，第3字节起数据格式有不同定义）<br> 0 状态<br>1 统一BCD码格式<br>2 测验中的单选多选排序类型<br>3 测验中的数字题结果类型（最多12位数）<br>4 填空和测验中的字符串<br>6 键盘主动提交，带类型<br>7 SN+ID，含电量统一BCD格式数据，按字母解码 <br>8 SN+ID，含电量统一BCD格式数据，按数字解码<br> 9 SN+ID的字符串，带电量和效验<br><br>11 登录信息<br>12键盘请求 <br>13 多包申请 <br>14 考勤定位<br>15 批次表决BCD码格式数据，按字母ABCD解码<br>16 批次表决BCD码格式数据，按数字解码<br><br>20 语音数据<br><br>32 键盘申请发送透传数据包<br> 40 反馈键盘后台升级情况包<br> 99 固件升级结果|
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前<br>例如SN号AB120500，那么第1字节值是0xAB，第2字节0x12，依次类推 |
| 7 | DATAPOS/ADDH | 功能等同投票信标中的DATAPOS，正常提交结果必须等同于当前DATAPOS，用于基站判断，是否是当次投票结果。由于新体系键盘出于省电，平常是不监听信标的，就有可能提交结果的时候，投票已经停止或者已经到下一个，这样，基站就能判断结果无效反馈给键盘<br>启动投票的时候，键盘记录DATAPOS值下来，提交结果带上，不要用信标里面的值。<br>为0表示不需要，例如遥控器<br>ANSCMD=0x94时候，本字节是键盘编号高位ADDH字节 |
| 8 | SENDPOS/ ADDL | 键盘提交一次结果就变化一次，用于SDK判断，是否和上次结果一样，这样，对于重复数据，SDK就不弹出消息<br>这对遥控器操作比较有用<br>ANSCMD=0x94时候，本字节是键盘编号低位ADDL字节 |
| 9 | ANSDATA | 根据结果类型ANSTYPE的不同，有不同的数据长度和含义<br>一般只到第17字节，从ANSTYPE起占用16字节 |
| 10-24 |||
| 23-24 | CRC16 | 2字节效验值，值高位在前，效验值计算方法，从ANSCMD开始共22字节，按CRC16算法计算效验值（见参考代码）<br>注意：3.2.3节字符串格式除外，因为占用到24字节了—所以CRC挪到27-28字节 |

对于不同类型的数据格式，后节详细解析。
基站对上传单包数据的确认应答包结构参见2.3节。

### 3.2.1统一BCD码格式

用统一的格式，来传递单值（签到、表决、评议、判断）、单选多选、排序、评分和UID签到结果。
数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x93 使用硬件序列号提交单包结果0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>1 统一BCD码格式，2字节时间和7字节BCD码<br>(UID签到时候是6字节BCD，最后1字节是电压值) |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7 | DATAPOS/ADDH | 结果对应的投票序号或者ADDH |
| 8 | SENDPOS/ADDL | 键盘内部的提交数据序号或者ADDL |
| 9-10 | KEYTIME | 按键时间，离投票开始的时间，2字节，高位在前，单位是20ms，最大约21分钟 |
| 11-17 | BCDVALUE | 7字节BCD码表示的值，高位在前，F表示结束，最多14位数<br> E是小数点，D是空格，C是负号，A是数字0<br>1. 表示数字时候， E表示小数点，例如1234E5FFFFFF表示"1234.5"<br>2. 表示单选多选排序的时候，0表示第10个选项，例如 01 32 FF FF FFFFFF就是"JACB"<br>3. 单值结果一般就第一个BCD值有效，例如1FFFFFFFFFFFFF表示1（判断对=1 错=2 是=1 否=2）<br>4. UID签到时候，前6BCD码是用户UID数字，最多12位数字，第7字节是电压值，单位0.04V<br><br>**注意： SDK 要根据当前的投票模式，来判断数据的真正格式和含义** |
| 18-28 || 无意义 |

### 3.2.2 测验结果BCD码格式

课堂测验时候（每道题单独送---不支持字符串），使用SN号传数据，数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x93 使用硬件序列号提交单包结果<br>0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br> 2 用序列号的测验中的单选多选排序类型，1次只包含一个项目结果，长度和3.6.1节统一BCD码格式统一 <br>3 用序列号的批次数字题结果类型（最多12位数）|
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7 | DATAPOS/ADDH | 结果对应的投票序号或者ADDH |
| 8 | SENDPOS/ADDL | 键盘内部的提交数据序号或者ADDL |
| 9-10 | KEYTIME | 按键时间，离投票开始的时间，2字节，高位在前，单位是100ms，最大约105分钟<br>值为0表示使用电脑时间 |
| 11 | ITEMNO1 | 项目序号，1字节（和老体系不一样） |
| 12-17 | BCDVALUE1 | 项目结果，6字节BCD码表示的值，高位在前，F表示空字符，最多12位数<br> 2、单值结果一般就第一个BCD值有效，例如1FFFFFFF表示1，SDK用"1"表示<br>3、表示数字时候， E表示小数点，例如 1234E5FFFF 表示"1234.5" 4、表示单选多选排序的时候，0表示第10个选项，例如 01 32 FF FF 就是"JACB"<br><br>选举值可以用单值表示，例如1选择或同意，2表示取消选择或反对；评议值也可以用单值表示； |
| ..24 || 空（不能使用，因为SN值结果在基站打包中仅16字节） |

### 3.2.3填空和测验的字符串格式

用于传递填空或测验中的字符串格式数据，数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>9字符串（带电量、效验） |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7-8 | ID | 键盘编号，2字节，高位前 |
| 9 | KEYTIME | 如果是填空，单位时间0.5s，如果是测验，单位时间1分钟<br> 注意是单字节，不是平常的双字节，最大值0xFE<br>=FF表示是单题提交课后练习结果，特殊格式 |
| 10 | SLOTN或者ITEMNO | 如果是填空，高4位表示总共有多少片数据（1片16字符），0表示有1片段，低4位表示片段号码（0起），这样填空可以传 ~~256~~ 15x16字符<br>如果是测验，是题号，表示是那个题目的答案 |
| 11 | VOLT | 电池电压，单位20mV |
| 12-26 | STRING | 15字节字符串，ASCII码，0代表字符结束<br>注意：由于产品经理要求还是带完整电量，考虑到CRC比较重要，所以这里的字符串修改成1段只15字符，原先16字符 |
| 27-28 || CRC16效验值 |

相对于老格式4，把时间做成1字节，SLOT做成1字节，为CRC腾出2字节

备注：测试扫描模式下，带姓名扫描时，如果用这个格式，由于基站CRC判断位置，老系统在23、24字节，导致实际只能传10字节姓名。解决方案是基站端做兼容判断，如果23、24字节crc不对，加上27、28判断，可以对所有模式，但为了降低crc误通过的风险，甚至可以只针对0x94的9模式。

特殊地，KRYTIME=0xFF时候，表示是单题课后练习结果：
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 9 | KEYTIME | =FF表示是单题提交课后练习结果 |
| 10 | SUBJECT | 科目编号 |
| 11 | ITEMNO | 题号 |
| 12-26 | STRING | 15字节字符串，ASCII码，0代表字符结束 |
| 27-28 || CRC16效验值 |

老格式如下：（注意：加上配对码后就是无线最大数据32字节了）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x93 使用硬件序列号提交单包结果<br>0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>4字符串 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7 | DATAPOS/ADDH | 结果对应的投票序号或者ADDH |
| 8 | SENDPOS/ADDL | 键盘内部的提交数据序号或者ADDL |
| 9-10 | KEYTIME | 按键时间，高位在前<br>如果是填空，单位时间20ms，如果是测验，单位时间100ms |
| 11 | SLOTN | 如果是填空，表示总共有多少片数据（1片16字符），一般是1，如果大于1，键盘就分片提交，1片1片提交，SDK缓存，接收完毕弹出完整信息<br>如果是测验，是题目总数，但SDK也无需判断<br>如果是分组PK，是组号，对应题目组 |
| 12 | SLOT/NO| 如果是填空，表示后面16字节是第几片数据，1起<br>如果是测验，表示是第几题的数据，1起<br>如果是分组PK，这里是题目组里面的题号 |
| 13-28 | STRING | 16字节字符串，ASCII码，0代表字符结束 |

注意：能龙版本，手动选题型，主动提交的，有一种用16字符输入多题的（测验，但都是单选，一次输入16字符），也用这种格式提交，STRING用字符，SLOTN和SLOT暂都是0以区别正常的填空和测验

### 3.2.4登录信息

传递键盘的登录申请信息，包括配对、自由登陆基站。

数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x93 使用硬件序列号提交单包结果0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>11 登录信息 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7 | DATAPOS/ADDH | 值=0 或者ADDH |
| 8 | SENDPOS/ADDL | 键盘内部的提交数据序号或者ADDL |
| 9 | TYPE | 操作类型<br> 1 上线信息，基站只有收到该类型数据才会上报SDK或服务器，其他模式内部处理，不上报。例如，白名单模式下，键盘先发白名单申请，成功后再发上线信息。这里基站回205用于防止键盘上线信息丢失。<br> 2 登陆自由基站（用于提交基站密码登陆）---基站自由模式序列号，基站名称是密码---键盘要等待基站确认见2.3节<br>3 登录白名单模式基站（拓维大基站双模块版本，键盘在0频点请求，等待确认告知频点和配对码---基站用2.3.2节确认包应答）<br>4 CH-UID登录模式，需要基站授权<br>5 组呼情况下键盘监听基站点名超时时上传的入网信息，基站不上传到SDK <br> 6 配对（用于通知基站配对成功）---基站固定系列号模式且快速配对<br> 10 登录基站，键盘菜单搜索基站登录  <br>==特别的，当基站是加密基站时，3，6，10应该开启发私钥流程，其中6类型，开启配对模式即开始发私钥，关闭配对后停止。3，10是收到键盘申请后基站固定发几轮，然后停止==|
| 10 | HMODEL | 键盘的型号代码 |
| 11 | HVER | 键盘硬件版本 |
| 12-14 | SVER | 键盘软件版本，3字节，10进制数字 |
| 15-16 | PWD | 2字节BCD码格式的登陆密码（登陆自由基站有效）<br>例如123F代表密码123 |
| 17 || TYPE等于10 是登录基站的时候 如果登录基站有密码 这里键盘会置1并附带上密码 |

CH-UID模式下，15字节起是3字节的UID

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 15-17 | PWD | 3字节BCD码格式的用户UID登录，支持6位数字<br>例如123F代表123 |
|  |  |  |

### 3.2.5状态信息

用于报告状态（例如正道远心跳信号），或者在线测试的时候，数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x93 使用硬件序列号提交单包结果<br>0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>0 状态报告 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7 | DATAPOS/ADDH | ADDH |
| 8 | SENDPOS/ADDL | ~~键盘内部的提交数据序号~~~~ 或者~~ADDL |
| 9 | HMODEL | 键盘的型号代码<br>特殊地，0xF0起用于报告附加信息 |
| 10 | HVER | 键盘硬件版本 |
| 11-13 | SVER | 键盘软件版本，3字节，10进制数字 |
| 14 | VOLT | 电池电压，Bit7为1表示在充电，低7位x0.04V就是电池当前电压 |
| 15 | RSSI | 键盘接收到的基站的射频信号强度<br>S61-24R1版本，在线测试时候=1，用于区分心跳和在线测试 |
| 16 | STATUS | 开关机状态，0用于兼容老系统不弹，1开机，2关机<br>（新东方泡泡要求关机也发心跳，2秒1次） |
| 17 | SendPos | 该次结果发送次数 键盘自己计数 |
| 16- | USERID | 学号，16字节，字符串格式<br>（仅用于WIFI答题器体系，包长度有变化） |
| 18-20 | NULL | 空 |

当HMODEL=0xF0-0xFF时候，用于在线扫描报告键盘对应的其他信息，例如姓名：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>0 状态报告 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7-8 | ID | 键盘编号，2字节，高位前 |
| 9 | HMODEL | 0xF0-报告姓名 |
| 10 | VOLT | 电池电压，Bit7为1表示在充电，低7位x0.04V就是电池当前电压 |
| 11-26 | USERID | 学号，16字节，字符串格式 |
| 27-28 | CRC16 | 效验值 |

备注：基站端老版本CRC位置固定在23、24字节，要兼容，基站端CRC算法可以23、24不对的时候再判断27、28，或只针对0x94、0模式进行特殊crc判断

备注：由于基站如果按状态报告打包处理，传输不了姓名，SDK也不好兼容，所以基站协议新增了类型29，专门打包这个需25字节的格式。

### 3.2.6键盘请求

提交遥控器键码、服务申请。

数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x93 使用硬件序列号提交单包结果<br>0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型12键盘申请 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7 | DATAPOS/ADDH | 值=0或者ADDH |
| 8 | SENDPOS/ADDL | 键盘内部的提交数据序号或者ADDL |
| 9 | REQTYPE | 请求类型<br>1 遥控器<br>2 服务请求（学生举手）<br>3 投票器键码提交<br>4 键盘申请基站重新广播数据REQ1是0或FF表示全部广播，否则用8bit表示要广播那个区，每区512字节（最大限定4080字节了）--如果广播时间短也可以简化为前、后两区？<br>5 透传多包申请重播，REQ1是8bit表示基站要广播哪个数据段，透传数据每段现在1K字节，暂最多8K字节<br>6 题干内容（或离线评测数据表）下载全部ok <br>20 对应新增6.6.2.2APP数据透传广播的申请|
| 10 | REQ1 | 遥控器键码或服务请求代码 |
| 11 | REQ2 | 暂0 |
| 12-17 |||

### 3.2.7多包申请

提交家庭作业等批量数据的上传请求。
数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x92 使用硬件序列号提交单包结果 |
| 2 | ANSTYPE | 数据包类型<br>13 多包申请 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7-8 | ID | 键盘编号 |
| 9-10 | KEYTIME | 按键时间，离投票开始的时间，2字节，高位在前，单位是20ms，最大约21分钟 |
| 11 | PACKTYPE | 1 测验结果（或其他批量数据）<br>2作业结果 <br>3 发短信 <br>4 填空信息 |
| 12 | PACKID | 数据包辨别码，一般是0，不是0表示是第几个，例如第2个作业在PACKTYPE=2的时候，<br>=F0，表示后面数据是多个作业的科目信息<br>=F1，表示多个作业用1个压缩打包传输 |
| 13-14 | HWKBITS | PACKID=F0时候，这里用bit置1表示对应科目有作业提交<br>高位前，只有bit8-bit0有效，代表9科目<br>例如0001表示科目1有数据，0003表示科目1和2有数据 |
| 15-17 || 空，不超出17字节，不影响基站数据打包 |

&emsp;&emsp;SDK再用4.1类开始多包接收进行接收具体批量结果。

&emsp;&emsp;如果PACKTYPE=2，PACKID=F0，SDK先把bit位转成科目编号，然后一个一个科目单独对键盘进行提取，好处是可以沿用原来SDK的单独取一门作业功能。

&emsp;&emsp;如果PACKTYPE=2，PACKID=F1，那么4.1节的取作业时候PACKID也保持F1值，表示用1个打包取作业数据，取完后再解压成单科目结果信息。

### 3.2.8考勤定位

&emsp;&emsp;为减少无线发射时间，满足3年使用，数据包缩短，采用新的格式，而且是没有配对码的，这样，基站判断第一个字节是特定的0xFA（0xFB。。。）字节，就知道是没有配对码的格式。新数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0xFA 考勤定位短包（不包含配对码） |
| 2-5 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 6 | VOLT | 低7位是电池电压，单位0.04VBit7暂保留，例如防拆报警 |
||||

（老格式，仅供参考：）
用于报告位置和时间，数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x93 使用硬件序列号提交单包结果 |
| 2 | ANSTYPE | 数据包类型<br>14考勤定位 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7 | DATAPOS | 值=0 |
| 8 | SENDPOS | 键盘内部的提交数据序号 |
| 9 | MSGTYPE | 数据格式<br>1 无位置信息，键盘数据10-17字节值00，但考勤基站会添加<br>2 带低频唤醒，有位置信息和时间信息 |
| 10 | GATE | 门号，位置号，1开始 |
| 11 | RDNO | 阅读头编号，1开始<br>1 内阅读器1号<br>5 内阅读器2号<br>6 外部阅读器1号<br>7 外部阅读器2号|
| 12 | RSSI | 可能的信号强度值 |
| 13-16 | TIME | 时、分、秒、0.01秒，10进制|
| 17 |||

### 3.2.9键盘主动发信模式（带类型）

用于键盘不监听基站信标，其实基站也不控制投票类型，键盘手动选择要提交的数据类型，来传递选择ABCD（单选多选排序）、判断（是否/对错）、数值的单题结果，以及多题结果(测验)，仍然保持共16字节的有效数据模式（从SN算起）。
相对于3.2.1节，去掉了DATAPOS，加了类型，并附加状态报告和题号，时间参数运算方法改变。
数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x93使用硬件序列号提交单包结果 |
| 2 | ANSTYPE | 数据包类型<br>6键盘主动发信模式 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7 | SENDPOS | 键盘内部的提交数据序号，有新值提交键盘+1<br>用于SDK优化不弹出多条相同信息 |
| 8 | DATATYPE | 数据类型 决定后面的解码格式，特别是BCDVALUE值<br> 1 选择题，SDK按ABCD输出 <br>2 判断，SDK按12输出或TF都可以 <br>3 数字题，SDK按1234输出<br>4 申请 例如举手、错题等（SDK可以迟点做） |
| 9 | ITEMNO | 题号<br>平常单题是0<br>多题是>1表示题号 |
| 10-11 | KEYTIME | 按提交键后到现在的时间差，单位20ms，测验模式下100ms<br>SDK可以倒推出实际的按键时间 |
| 12 | STATUS | 状态<br>Bit 0=1弱电 |
| 13-17 | BCDVALUE | 5字节BCD码表示的值，高位在前，F表示空字符，最多10位数<br> a、表示数字时候， E表示小数点，A是\*，B是#，C是-，F是空格，例如 1234E5FFFFFF表示"1234.5"<br> b、表示单选多选排序的时候，0表示第10个选项，例如 01 32 FF FF FF就是"JACB" <br>c、单值结果一般就第一个BCD值有效，例如1FFFFFFFFFFFFF表示1（判断对=1 错=2 是=1 否=2）|

### 3.2.10语音录音数据（WIFI版本）

用于提交答题器录音数据。
带实际录音数据的，按超长数据格式打包，打包格式参考第一节概述，F5 AA AB开头，后面长度数据是2字节的。
数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>20录音数据 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7 | ADDH | 投票器编号高位ADDH |
| 8 | ADDL | 投票器编号低位ADDL |
| 9 | DATAPOS | 对应启动录音时候投票信标的DATAPOS，用于标识是哪次录音 |
| 10 | RECNO | 1起，第几个录音，允许多个录音的话<br>0表示录音停止，或者录音没开始，还是用长数据包格式打包-F5 AA AB开头，但长度可以缩小，可以不含语音数据VOICE |
| 11 | RTYPE | 录音数据格式，1起<br> 1 A率压缩，8K采样，8bit数据<br> 2 PCM格式不压缩，8K采样，16bit数据 <br>3 A率压缩，16K采样，8bit数据 <br>4 PCM格式不压缩，16K采样，16bit <br>5 A率压缩，32K采样，8bit数据<br>6 SPEEX压缩，8K采样率<br>7 SPEEX压缩，16K采样率 |
| 12-13 | SLOT | 录音数据片号，每片1024字节<br>0起，高位前，65536片，可65536K字节，每秒8KB可8192秒 |
| 14-15 | LEN | 实际语音数据字节数，高字节前 |
| 16--+1024 | VOICE | 语音数据，1024字节一个包，也可以缩短 |

### 3.2.11 SN+ID，含电量统一BCD格式数据

由于K1、T1键盘需求要求支持16位数字，要求每次结果带电量，通过基站打包分析，USB一次打包2个键盘数据的话，键盘数据最大可以26字节，原先除了字符串外统一是17字节。考虑到扩展，键盘数据长度还是先按24计算，

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>7 SN+ID，含电量统一BCD格式数据，按字母ABCD解码<br>8 SN+ID，含电量统一BCD格式数据，按数字解码<br>这里带了类型，键盘提交要注意，以前是SDK根据现在的投票模式来处理，那么做带题型测验的时候，SDK还需判断题型数据，不方便，这样修改就比较容易解析数据 <br>17 18 等于原始7 8 类型 但22位置填写校验和1-22字节|
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7-8 | ID | 表决器编号ID，高字节在前 |
| 9-10 | KEYTIME | 按键时间，离投票开始的时间，2字节，高位在前，平常单位20ms，测验时候单位是100ms，最大约105分钟<br>值为0表示使用电脑时间 |
| 11 | ITEMNO1 | 测验中的项目序号，1字节，1起<br>如果是单个投票，这里填00，或者SDK不处理<br>项目序号>0时候，SDK时间单位按100ms计算<br>特殊地，题号101表示用户按OK键确认提交（青果），后面的值可以全FF |
| 12-19 | BCDVALUE1 | 结果值，8字节BCD码表示的值，高位在前，F表示结束字符，最多16位数，E是小数点，D是空格，C是负号<br> 2、单值结果一般就第一个BCD值有效，例如1FFFFFFF表示1，SDK用"1"表示<br>3、表示数字时候， E表示小数点，例如 1234E5FFFF 表示"1234.5" <br>4、表示单选多选排序的时候，0表示第10个选项，例如 01 32 FF FF 就是"JACB"<br><br><font color="#dd0000">5、特殊的，FFFF1F组合表示确认提交，<br>&emsp;&emsp;FFFF0F组合表示用户又转回修改；</font><br />|
| 20 | VOLT | 电池电压，单位20mV |
| 21 | SendPos | 该次结果发送次数 键盘自己计数 |
| 22 |SUM| 空，先填00 <br>17/18类型：22位置填写校验和1-21字节|
| 23-24 |CRC| CRC，1到第22字节 |

### 3.2.12固件升级结果

键盘固件升级完成或失败后，上报给基站，应用可完成对失败键盘的静默升级。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型 99 固件升级结果 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7-8 | ID | 表决器编号ID，高字节在前 |
| 9 | STATUS | 1 升级成功 \>1是升级失败的原因 |
| 10 | HW | 键盘硬件代码 |
| 11-13 | SW1-SW3 | 键盘软件版本，3字节 |

### 3.2.13 批次表决BCD码格式数据

M6键盘批次表决，由于题目数量有两字节，原有的ANSTYPE=7的数据格式不能适用，在此基础上增加ANSTYPE=15的数据格式。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>15--批次表决BCD码格式数据，按字母ABCD解码<br>16--批次表决BCD码格式数据，按数字解码<br>这里带了类型，键盘提交要注意，以前是SDK根据现在的投票模式来处理，那么做带题型测验的时候，SDK还需判断题型数据，不方便，这样修改就比较容易解析数据 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7-8 | ID | 表决器编号ID，高字节在前 |
| 9-10 | KEYTIME | 按键时间，离投票开始的时间，2字节，高位在前，平常单位20ms，测验时候单位是100ms，最大约105分钟<br>值为0表示使用电脑时间 |
| 11-12 | ITEMNO1 | 批次提交的题号，2字节，1起<br>如果是单个投票，这里填00，或者SDK不处理<br> |
| 13-20 | BCDVALUE1 | 结果值，8字节BCD码表示的值，高位在前，F表示结束字符，最多16位数，E是小数点，D是空格，C是负号<br> 2、单值结果一般就第一个BCD值有效，例如1FFFFFFF表示1，SDK用"1"表示<br>3、表示数字时候， E表示小数点，例如 1234E5FFFF 表示"1234.5" <br>4、表示单选多选排序的时候，0表示第10个选项，例如 01 32 FF FF 就是"JACB"<br><br><font color="#dd0000">5、特殊的，FFFF1F组合表示确认提交，<br>&emsp;&emsp;FFFF0F组合表示用户又转回修改；</font><br />|
| 21 | VOLT | 电池电压，单位20mV |
| 22 | SendPos | 该次结果发送次数 键盘自己计数 |
| 23-24 || CRC，1到第22字节 |
### 3.2.14 键盘后台静默升级状态包

数据格式是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94 使用硬件序列号提交单包结果 |
| 2 | ANSTYPE | 40  键盘发送给基站 后台升级情况不方便，这样修改就比较容易解析数据 （该包基站处理，不提交给SDK）<br>==键盘自主发送   无需升级、已收全的键盘、版本与升级固件一致的键盘 不回复该包。同时增加模式测试9子类7章节2.2.7 开测试可以让键盘发送一次该包。无需升级以及已接收完整的键盘或版本与升级固件一致 也需回复该包。方便上层查看实时状态制作测试软件==|
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7 | Percentage | 键盘接收情况百分比  ，收到为100%之后 基站可以无视该包下面Offset Start  Bit MAP数据 |
| 8 | Offset Start | 上传键盘丢失包数 计算偏移起点值（不完全反馈）256K 需要32个8 现在只有10*8 = 80K |
| 9 | PACK_END | 键盘端收到的最大包序号,可以与下面bit表共同确认未收到的数据 |
| 10-12 | SW | 键盘升级数据的版本号，SW1 SW2 SW3|
| 13-22 | Bit MAP | 10字节   偏移之后的键盘接收固件情况 bit位单位1K 基站判断时注意别越界|
| 23-24|CRC|CRC，1到第22字节 |

==bit比对以前是 for (uint8_t i = 0; i < 32; i++)==
==现在为：for (uint8_t i = Offset Start; i < 32; i++)==
# 四、上传多包类

&emsp;&emsp;上传多包类指令主要用于表决器向基站快速传送一批次的数据，因为不需要竞争通讯的时序，效率较片段提交的方式高效得多。

商务应用：
&emsp;&emsp;目前仅脱机调研模式使用了上传多包类的指令。表决器如果实现发短信功能也需要主动的多包上传。
&emsp;&emsp;目前批次和二维评测的结果都是采用片段提交的方式提交的，而没有采用一次性提交方式。

教育应用：
&emsp;&emsp;上传测验结果、作业、短信、超16字符填空。

## 4.1 开始多包接收

&emsp;&emsp;上传多包一种情况是表决器主动提出要上传，参见多包申请指令，这时候电脑可以知道要求上传的多包数据类型PACKTYPE和数据包辨别码PACKID。

&emsp;&emsp;上传多包另外一种情况是，电脑指定要某种多包数据，这时候需要知道数据包的长度。

&emsp;&emsp;具体原理参见文档《表决系统通讯协议-应用文档-基础原理》。

&emsp;&emsp;以上两种情况，都用进入多包上传模式指令，获取数据包长度：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | PACKCMD | 0x20上传多包类指令 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>FFFF时候，是用序列SN号指定键盘进行上传 V4.74 |
| 4 | CMD | 1 表示是进入多包上传模式 |
| 5 | PACKTYPE | 多包数据类型<br>1 测验结果 2作业结果 3发短信4超16字符填空信息 |
| 6 | PACKID | 数据包辨别码，例如作业编号<br>=F1的时候， 表示取多个作业科目的合起来的一个打包，取出后再展开成单个科目 |
| 7-9 || 空 |
| 10-15 | SN | 使用SN号模式时候是键盘SN号，否则空 |
| 16-24 | 。。。 | 参数值没有意义，或根据需要设定 |

表决器应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | PACKCMD | 0xA0上传多包类应答 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>FFFF，用后面SN号指定键盘 |
| 4 | CMD | 1 进入多包模式应答 |
| 5 | PACKTYPE | 多包数据类型，例如2是作业 |
| 6 | PACKID | 数据包辨别码，例如是科目号 |
| 7 | PACKH | 数据包长度（段总数）高字节 |
| 8 | PACKL | 数据包长度（段总数）低字节 |
| 9 || 空 |
| 10-15 | SN | 键盘SN号 |
| 16-24 | 。。。 | 参数值没有意义 |

数据包的PACKH和PACKL是这么计算的：
&emsp;&emsp;数据包以16字节为1片，16片为1段，PACKH相当于段号（从0开始计算），PACKL是最后一段的数据片数目。数据包实际长度=16字节x（16 x PACKH + PACKL）。SDK收到长度后，就可以根据长度，一个一个数据包地询问收取。

注意：当PACKH=0xFF和PACKL=0xFF时候，表示没有这个数据包。

## 4.2 询问多包和应答

询问表决器多包指令是：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | PACKCMD | 0x20上传多包类指令 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>FF01--FFFE，用SN号指定键盘进行多包上传低位字节01-FE，是上传次序UPSN，由SDK管理，只要是针对下一个键盘的上传就变化一次，例如依次加1，实际上可以理解为给于SN号上传多包的键盘的一个临时键盘编号，因为键盘后面传实际数据时候，由于数据包长度限制，不带SN号，就靠这个号码辨别。不单独统一使用FFFF是避免基站数据可能有延迟，回给SDK的是上次键盘数据，注意：键盘要记录UPSN值，因为应答要用到 |
| 4 | CMD | 2 询问多包数据 |
| 5 | PACKTYPE | 多包类型 |
| 6 | PACKID | 数据包标识码 |
| 7 | PACKH | 需要上传的数据段编号，以16字节为1片，16片为1个数据段<br>PACKH值指定了哪个段的数据要上传 |
| 8-9 | PACKLS | 2字节，用Bit位表示要上传哪些片，为1要上传，0不需上传<br>共16Bit，对应0-15片数据片<br>注意：低位字节在前，高位字节在后<br>PACKLS值指定了PACKH段中的哪些数据片要上传 |
| 10-15 | SN | 当KEYID= ~~FFFF~~ 时候是键盘SN号，否则空<br>V4.77前笔误，应该是FF01-FFFE |
| 10-24 || 参数无意义 |

表决器应答：（依次送回要传输的数据片的内容）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | PACKCMD | 0xA0上传多包类指令应答 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>FF01-FFFE，用SN号提交多包上传数据，高位是FF，低位是UPSN值，这里的UPSN值就是询问包中的UPSN值 |
| 4 | CMD | 2 回应多包数据 |
| 5 | PACKTYPE | 多包类型 |
| 6 | PACKID | 数据包标识码 |
| 7 | PACKH | 数据段编号 |
| 8 | PACKL | 0-15，数据片编号 |
| 9-24 | PACKDATA | 16字节的数据 |

## 4.3 多包接收完毕确认

&emsp;&emsp;多包接收完毕确认指令用于通知表决器多包接收已经完成，如果是主动申请提交的话，不再进行这个多包数据的多包上传申请。

指令结构：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | PACKCMD | 0x20上传多包类指令 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>FFFF，用SN号指定键盘 |
| 4 | CMD | 3 多包接收完毕确认 |
| 5 | PACKTYPE | 多包类型 |
| 6 | PACKID | 数据包标识码 |
| 7-9 || 空 |
| 10-15 | SN | 当KEYID=FFFF时候是键盘SN号，否则空 |
| 16-24 || 参数无意义 |

表决器应答表示收到：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | PACKCMD | 0xA0上传多包类指令应答 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>FFFF，用SN号指定键盘 |
| 4 | CMD | 3 多包接收完毕应答 |
| 5 | PACKTYPE | 多包类型 |
| 6 | PACKID | 数据包标识码 |
| 7-9 || 空 |
| 10-15 | SN | 当KEYID=FFFF时候是键盘SN号，否则空 |
| 16-24 || 参数无意义 |

## 4.4 具体应用

&emsp;&emsp;多包数据上传的时候，用数据类型PACKTYPE值和数据包标识码PACKID来标识数据的类型，即PACKTYPE值和PACKID值决定了上传的数据包类型、格式。和3.2.7节多包申请里面定义相同。

商务政务涉及到数据表类型有：

| PACKTYPE 值 | PACKID 值 | 数据包类型 |
| --- | --- | --- |
| 1 | 0 | 简单类型的脱机调研数据，仅支持单选多选，最多8选8 |
| 2 | 0 | 待定 |
| 3 | 0 | 发短信 |
| 4 | 0 | 超16字符填空信息 |

教育应用涉及到数据表类型有：

| PACKTYPE 值 | PACKID 值 | 数据包类型 |
| --- | --- | --- |
| 1 | 0 | 测验结果 |
| 2 | 0 | 作业结果 |
| 3 | 0 | 发短信 |
| 4 | 0 | 超16字符填空信息 |

## 4.5序列号上传多包

&emsp;&emsp;上传多包在使用序列号来标识键盘时候，由于是SDK指定键盘询问的，所以，4.1节到4.3节，都可以修改成兼容按SN号指定和应答，唯键盘上传数据时，为保持和ID方式兼容和数据包长度不修改，应答数据包没包含SN号。

## 4.6 透传多包上传

总体流程：

-> 键盘向基站申请需要上传多包数据

-> 基站点名获取键盘数据

-> 基站释放该SN点名。

### 4.6.1 键盘申请包

键盘向基站发送申请包开始多包传输。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型32 键盘申请发送透传数据包 |
| 3-6 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 7 | TR\_POS | 透传轮次号 不能为0 1-255键盘自增 |
| 8-9 | INTERVAL | 键盘发送一个透传包需要时间，单位us<br> 用于基站确定点名间隔，同时其他键盘可做无线休眠 |
| 10 | PACKTYPE | 多包类型 |
| 11 | PACKID | 多包标识码 |
| 12-15 | PACKLEN | 需要上传的包数据总长度，long值，高位前 |
| 16-17 | DATALEN | 单位包长度，一次包传输长度封顶1K（32+1包/16+1包） |
| 18-19 | PACKCRC | 多包上传数据总CRC。00暂时不核对。 |

### 4.6.2 基站点名包

基站点名键盘回复数据

注意：1、键盘没有回复，超时时间为10个SLEEP_INTERVAL时长（发送10次没回复）

2、上个键盘已经收齐，需要切换时，不直接切换到发送信标而是发送SN为0的点名包， ~~再进入超时10个SLEEP_INTERVAL判断。（发送10次空包没人申请则超时）~~

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | PACKCMD | 0x28上传多包类点名 |
| 2-3 | SLEEP_INTERVAL | 键盘休眠间隙 单位us 下一信标间隔时间<br>基本等同于键盘申请指令里面的INTERVAL值 |
| 4-7 | SN | 键盘SN ~~全0为可以继续键盘申请（这里注意下）~~ |
| 8 | TR_POS | 透传轮次 键盘上传的轮次号 不能为0 1-255键盘自增 |
| ~~9~~ | ~~REC_OK~~ | ~~上一片区 ACK收齐回复 ，0x55 表示上一周期收全并CRC正确，其他错误~~ |
| 9-10 | ASK_PACK_NO | 询问键盘包序号，从1开始 基站主动询问包（总包除以单位包得到包总序号），高位前<br>=0表示基站通知收齐了 |
| ~~11-14~~ | ~~DATALEN~~ | ~~已接收的包数据总长度 （不限制模式下全FF）~~ |
| 11 | PACKTYPE | 多包类型 |
| 12 | PACKID | 多包标识码 |
| 13-14 | DATALEN | 单位包长度 |
||||

### 4.6.3 键盘透传上传包

&emsp;&emsp;键盘被4.6.2节基站点名后的应答。

&emsp;&emsp;对透传包的接收，基站判断是透传包后，设置继续接收标志并置超时定时器，收到1包就添加到buf尾部，如果超时没到就收到N包，去处理。如果超时没N包，直接丢弃。

&emsp;&emsp;键盘接收可以都丢弃（首包0x8F丢，后继数据包，ATC码判断相同的概率比较低）。

&emsp;&emsp;键盘在上传过程中根据SN被切换（或为0）或者切回发送信标则判断已全部上传完成（省掉最后基站给键盘确认）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 0-3 | ATC | 配对码 |
| 4-7 | MULTI_CODE | 多包透传标志 0x 8f 0x de 0x 48 0xfe（相当于CMD=0x8F） |
| 8 | MULTI_N | 后续传输包数量 此处为N |
| 9 | MULTI_TYPE | 透传数据包格式，暂1，后面数据按后面解析 |
| 10-11 | CRC16 | 全部DownData的 CRC |
| 12-15 | SN | 4字节SN |
| 16 | TR_POS | 透传轮次 |
| 17-18 | ASK_PACK_NO | 当前包序号从1开始 对应基站点名询问包序号 |
| 19 | PACKTYPE | 多包类型 |
| 20 | PACKID | 多包标识码 |
| 21-22 | DATALEN | DownData长度 |
| 23 | DataPos | 数据题目序号 |
| 24-25 | CID | 键盘CID |
| --31 || 空。从ATC开始，到这里共32字节<br>下面是数据片段实际数据，32字节1个无线包 |
| 32*N | DownData | 透传数据 32或者64的倍数 数据不满 补充0到32的倍数 |

# 五、下载单包类

## 5.1概述

&emsp;&emsp;表决器下载单包类指令主要用于控制表决器执行某种操作，例如修改编号、遥控关机等。

发送给表决器的指令结构如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器管理类指令 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前 <br>0x0000时候是广播，所有表决器都接收和处理<br>其他值是指定编号执行，编号和KEYID相同的才执行命令 |
| 4 | KCMD | 执行命令的类型 |
| 5-24 | KCMDS | 根据KCMD值不同，有不同含义 |
| 25-26 || 一般是空00 |
| 27-28 | CRC16 | 这里如果有值不等于0，表示指令带效验，从1计算到26字节<br>这里如果是0，或者数据包只有24字节，表示老体系的不带效验<br>本章节后面，长度24字节的，都可以变成28字节，不修改文档了 |

对于广播式指令（KEYID=0），表决器一般不回应结果状态，对于指定编号的，对应KEYID编号的表决器回应执行的结果：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器遥控指令应答 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前 |
| 4 | KCMD | 对应指令类型 |
| 5-24 | CMDMSG | 指令回应状态或其他信息 |

KCMD列表：

| **KCMD 值**|**功能模式** |
| --- | --- |
| 1，2 | 读写表决器配置 |
| 3,4 | 读写表决器硬件信息 |
| 5 | 遥控关机 |
| 7 | 信道测试 |
|||
| 10 | 显示表决器版本编号等信息 |
| 11 | 读写学号或姓名 |
| 12 | 功能检验测试 |
| 13,14 | 读写OEM硬件信息（极域） |
| 15 | 分组设置 |
| 16 | 外设动作控制 |
| 17 | 回写测验题答案 |
| 18 | 读取测验题答案 |
| 19 | 写OEM型号显示名称 |
| 20 | 授权 |
| 21-25 | 表决结果显示，政务协议 |
|||
| 30 | WIFI服务器信息 |
| 31 | 遥控绑定和解绑 |
| -36 | 手机类设置 |
|||

## 5.2 表决器管理类

### 5.2.1 读写表决器配置

用于读取或修改表决器的基本参数，例如表决器编号。

发送给表决器的指令结构如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 表决器编号，或0x0000广播（广播模式下不应答） |
| 4 | KCMD | 1 读表决器配置<br>2 写表决器配置 |
| 5-6 | NEWID | 写表决器配置操作时候有效<br>新表决器编号，2字节，高位在前，0000不改变 |
| 7 | ~~OFFTIME~~ | ~~写表决器配置操作时候有效<br> 表决器自动关机时间，以分钟为单位，0xFF不自动关机<br>某些型号不支持修改~~ |
| 8 | LOCKBASE | 固定配对模式还是自由配对模式<br>目前暂应用在教育系列 <br>1 固定配对 <br>2自由配对（可搜寻基站）<br>3 白名单模式 |
| ~~9~~ | ~~FIXCHAN~~ | ~~锁频模式<br> 0和 1自动锁频 2固定锁频~~ |
| 10-24 || 参数无意义 |

表决器回应表决器配置信息：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器遥控指令应答 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前 |
| 4 | KCMD | 1 表决器配置信息 |
| 5-6 | KEYID | 表决器编号 |
| 7 | ~~OFFTIME~~ | ~~表决器自动关机时间~~ |
| 8 | LOCKBASE | 固定配对模式还是自由配对模式 |
| 9-24 || 参数无意义 |

### 5.2.2 读写硬件信息

用于读取硬件型号、版本、序列号等信息。

发送给表决器的指令结构如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 表决器编号，或0x0000广播 |
| 4 | KCMD | 3 读表决器硬件信息<br>4 写表决器硬件信息（内部使用，不对外公开） |
| 5 | MODEL | 硬件型号代码，固件程序写死 |
| 6 | HVER | 硬件版本号，固件程序写死 |
| 7 | SVER | 软件版本号，固件程序写死 |
| 8-13 | SERIAL | 硬件序列号，6字节，高位在前，写操作时有效<br> ~~教育体系前4字节有效，后2字节填写FF~~<br> SDK是后4字节有效，前2字节00 |
| 14 | NEWVER | 0xA0 表示后面3字节是新的版本号 |
| 15-17 | SW\_3B | 3字节固件版本号，例如1、0、0表示V1.0.0<br>11、12、13表示V11.12.13 |
| 18-24 || 参数无意义 |

表决器回应表决器硬件信息：（可以一次回SN和ID）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器遥控指令应答 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前 |
| 4 | KCMD | 3 表决器硬件信息 |
| 5 | MODEL | 硬件型号代码 |
| 6 | HVER | 硬件版本号 |
| 7 | SVER | 软件版本号 |
| 8-13 | SERIAL | 硬件序列号，6字节，高位在前 |
| 14 | NEWVER | 0xA0 表示后面3字节是新的版本号 |
| 15-17 | SW\_3B | 3字节固件版本号 |
| 18-24 || 参数无意义 |

### 5.2.3 表决器遥控关机

&emsp;&emsp;遥控无线表决器关机，对有线系统无效。表决器不对指令应答，一般要多发送几次确保表决器接收到指令。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 表决器编号，一般是0x0000，所有表决器关机，否则是指定某个表决器关机 |
| 4 | KCMD | 5 遥控关机 |
| 5 | OFFMODE | 0 正常关机，需要按键才能开机，也即退出遥控开机模式<br> N 进入一键遥控开机模式，键盘定时监听基站是否遥控开机，持续N天后自动退出遥控开机模式，如果N=255表示一直遥控开机<br>（注意：中间键盘手动开机后自动关机的、离线关机的，不要影响这个遥控开机计时，除非重新遥控设置） |
| 6-8 || 参数无意义 |
| 9 | ZONEMODE | 0 不使用指定范围，全部修改<br>1 按键盘范围修改 |
| 10-11 | KEYMIN | 指定键盘编号范围时候的开始值，高位在前 |
| 12-13 | KEYMAX | 指定键盘编号范围时候的结束值，高位在前 |
| 14-24 || 参数无意义 |

### 5.2.4 表决器授权

用于控制投票器是否可以登录基站，或者投票权限
发送给投票器的指令结构如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 指定表决器编号 可以0000广播<br>0xFFFF，指定SN |
| 4 | KCMD | 20 表决器授权 |
| 5 | AUTHOK | 1 登录成功，授权成功 <br>2 签到信息错误，重新输入 <br>3 失败，系统不允许，表决器不要再提交登录请求<br>4 白名单键盘重新登录 |
| 6-7 | ~~AUTHCODE~~ | ~~授权号，2字节，高位在前<br> 在授权成功下有效~~ |
| 8-9 || 空 |
| 10-15 | SN | 投票器硬件序列号，6字节，动态配对编号时候有效<br>对教育新体系，后4字节SN有效 |
| 16-24 || 参数无意义 |

表决器回应：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器遥控指令应答 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>SN号模式下是0xFFFF |
| 4 | KCMD | 20 授权应答 |
| 5 | AUTHOK | 授权应答类型<br>同AUTHOK接收值，便于判断是哪个指令的应答 |
| 6-7 | AUTHCODE | 当前的授权号，2字节，高位在前<br>应答类型为1时候有效 |
| 8-9 || 空 |
| 10-15 | SERIALID | 投票器硬件序列号，6字节，动态配对编号时候有效 |
| 16-24 || 参数无意义 |

### 5.2.5 表决器信道测试

表决器信道测试用于测试指定表决器的双向成功率和信号强度，仅用于无线表决器。

发送给表决器的指令结构如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 指定表决器编号<br>FFFF，用SN号指定键盘 |
| 4 | KCMD | 7 无线信道测试 |
| 5 | SENDN | 发送次数 |
| 6 | OKN | 成功双向通讯次数 |
| 7 | RSSI1 | 基站接收到的表决器发射的无线信号强度，单位-dbm<br>(由基站自动填写，SDK不需处理) |
| 8,9 || 空 |
| 10-15 | SN | 当KEYID=FFFF时候是键盘SN号，否则空<br>对教育新体系，后4字节SN有效 |
| 16-24 || 参数无意义 |

表决器回应：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器遥控指令应答 |
| 2-3 | KEYID | 指定表决器编号<br>FFFF，用SN号表示键盘 |
| 4 | KCMD | 7 无线信道测试应答 |
| 5 | SENDN | 接收到的发送次数数据SENDN |
| 6 || 空 |
| 7 | RSSI1 | 基站接收到的表决器发射的无线信号强度 |
| 8 | RSSI2 | 表决器接收到的基站发射的无线信号强度，单位-dbm |
| 9 | VOLT | 电池电压，Bit7为1表示在充电，低7位x0.04V就是电池当前电压 |
| 10-15 | SN | 当KEYID=FFFF时候是键盘SN号，否则空 |
| 10-24 || 参数无意义 |

电脑接收到回应后，判断SENDN是否等于上次发送的SENDN，是的话表示双向通讯成功一次，OKN加1。

### 5.2.6 读写姓名等个人信息

教育系列键盘可以通过SN号在键盘内写好学号或姓名。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 指定表决器编号，0000广播<br>FFFF，用SN号指定键盘 |
| 4 | KCMD | 11读写学号或姓名 |
| 5 | MODE | 1读学号 <br>2 写学号 <br>3 读姓名<br> 4 写姓名<br>5 读金币数<br>6 写金币数（见单独说明）<br>7 清空姓名<br>8 写姓名学号金币数（5.8G体系长指令）<br>9  清金币数（得分）--一般用于广播，单独清零可以用写金币<br>10 读8汉字姓名<br>11 写8汉字姓名<br> 12 写单题得分（科大讯飞-键盘自主按UI要求显示），格式同写金币<br>13 清除得分（科大讯飞）|
| 6-17 | IDSTR | 学号字符串，最多12字符，参数在写学号时候才有用 |
| 18 || 空 |
| 19-24 | SN | 表决器SN号，6字节，高位在前对教育新体系，后4字节SN有效 |
||||
| 25-36 | Name | 姓名，最多12个字符，5.8G才这么用 |
| 37 || 空 |
| 38-41 | MONEY | 金币数，高位在前 |

投票器回应：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 投票器遥控指令应答 |
| 2-3 | KEYID | ~~投票器编号，2字节，高位在前~~<br>=0xffff，使用SN号下载姓名 |
| 4 | KCMD | 11 读写学号或姓名 |
| 5 | MODE | 1 读学号 <br>2 写学号 <br>3 读姓名 <br>4 写姓名<br>8 姓名学号金币数, 回复SN |
| 6-17 | IDSTR | 学号字符串，最多12字符，参数在写学号时候才有用 |
| 18 || 空 |
| 19-24 | SN | 表决器SN号，6字节，高位在前<br>对教育新体系，后4字节SN有效，前2字节必须FFFF |

如果要支持8汉字姓名，使用如下指令：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 指定表决器编号，0000广播<br>FFFF，用SN号指定键盘 |
| 4 | KCMD | 11读写学号或姓名 |
| 5 | MODE | 10读8汉字姓名<br>11写8汉字姓名（键盘判断SN的位置不同） |
| 6-21 | NAME | 姓名，最多16字符8汉字 |
| 22 | NULL ||
| 23-26 | SN | 表决器SN号，4字节，高位在前 |
| 27-28 | CRC16 ||

对应的键盘应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器下载单包类指令 |
| 2-3 | KEYID | FFFF，用SN号应答 |
| 4 | KCMD | 11读写学号或姓名 |
| 5 | MODE | 10读写8汉字姓名应答 |
| 6-21 | NAME | 姓名，最多16字符8汉字 |
| 22 | NULL ||
| 23-26 | SN | 表决器SN号，4字节，高位在前 |
| 27-28 | CRC16 ||

读写金币数，含本次操作信息：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 指定表决器编号<br>FFFF，用SN号指定键盘 |
| 4 | KCMD | 11读写学号或姓名 |
| 5 | MODE | 5读金币数6写金币数 |
| 6-9 | MONEY | 4字节现在金币总数，高位前 |
| 10 | ADD | 本次增减金币数显示0 不显示 1显示增加金币 2显示减金币 |
| 11-12 | MONNYADD | 本次增加或减少的金币数，2字节，高位前 |
| 13-18 || 空 |
| 19-24 | SN | 表决器SN号，6字节，高位在前<br>对教育新体系，后4字节SN有效 |

投票器回应：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 投票器遥控指令应答 |
| 2-3 | KEYID | ~~投票器编号，2字节，高位在前~~<br>=0xffff，使用SN号下载姓名 |
| 4 | KCMD | 11 读写学号或姓名 |
| 5 | MODE | 5读金币数6写金币数 |
| 6-9 | MONEY | 4字节现在金币总数，高位前 |
| 。。。 || 空 |
| 19-24 | SN | 表决器SN号，6字节，高位在前<br>对教育新体系，后4字节SN有效，前2字节必须FFFF |

### 5.2.7 读写OEM预置信息

用于读写OEM预置信息，包括即时反馈的按键等级提示。
发送给表决器的指令结构如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 表决器编号，或0x0000广播<br>FFFF，用SN号指定键盘 |
| 4 | KCMD | 13 读OEM硬件信息<br>14 写OEM硬件信息 |
| 5 | OEM | OEM信息代码<br> 1 极域10字节SN（只能极域，不对外公开）<br> 2 即时反馈按键提示自定义等级 <br>3 锐捷定制键盘的蓝牙MAC地址（IDSTR是6字节），键盘要串口发给蓝牙芯片，读取时候，读蓝牙芯片MAC返回<br>4 出厂日期（暂字符串格式，放IDSTR） |
| 6 | IDNO | 具体信息位置编号<br>对于极域SN，填0，原先IDSTR从这里开始<br>对于OEM=2即时等级提示，这里是键码，1起 |
| 7-18 | IDSTR | 信息字符串 |
| 19-24 | SN | 表决器SN号，6字节，高位在前<br>对教育新体系，后4字节SN有效，前2字节必须FFFF |

表决器回应表决器硬件信息：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器遥控指令应答 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前SN模式下FFFF |
| 4 | KCMD | 13 OEM硬件信息 |
| 5 | OEM | OEM信息代码 |
| 6 | IDNO | 具体信息位置编号 |
| 7-18 | IDSTR | 信息字符串 |
| 19-24 | SN | 表决器SN号，6字节，高位在前<br>对教育新体系，后4字节SN有效，前2字节必须FFFF |

### 5.2.8 显著显示表决器信息

用于遥控表决器在液晶上显著显示硬件信息，例如用大字体显示编号，利于分发和查看。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 表决器编号，一般是0x0000，所有表决器都显示 |
| 4 | KCMD | 10 显著显示表决器信息 |
| 5 | MODE | 1 大字体显示表决器编号<br>2 液晶闪烁显示，利于查找 |
| 6-24 || 参数无意义 |

### 5.2.10 检验模式(硬件自测)

用于控制表决器进入特殊的检验模式，而达到进行某项功能检验的目的。表决器不予应答，一般要多发送几次确保表决器接收到指令。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 表决器编号，一般是0x0000，所有表决器都执行 |
| 4 | KCMD | 12 检验模式（原桌牌协议是11，但和读写学号冲突了） |
| 5 | MODE | 检验的类型<br>对于带液晶表决器，0是正常待机状态，1是液晶液晶全亮 2交替全亮全灭，时间可控<br>对于电子桌牌，0是缺省模式，1是全亮，2是全灭，3是横扫，4是纵扫<br>对于计分牌，0、1是前后数码管全亮，2是全灭，3是间隔全亮和全灭，间隔1秒 |
| 6 | T1 | 液晶测试模式2 时候全亮时间，单位秒 |
| 7 | T2 | 液晶测试模式2 时候全灭时间，单位秒 |
| 8-24 || 参数无意义 |

### 5.2.11 WIFI服务器模式

&emsp;&emsp;【T1-WIFI体系】这个指令是通过UDP广播给接入网络的语音答题器或其他类似设备，告诉答题器如何连接服务器的。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，一般是0x0000，所有答题器都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 30 WIFI服务器信息 |
| 5-10 | SN | 答题器硬件序列号，6字节<br>对教育新体系，后4字节SN有效 |
| 11 | MODE | 告诉答题器连接服务器的模式<br>暂时1，用IP地址连接，后面是主控IP地址信息 |
| 12-15 | IP | 4字节的主控IP地址 |
| 16-17 | PORT | 暂时00，用户不指定端口值 |
||||

### 5.2.12 遥控绑定和解绑

用于遥控修改答题器连接服务器方式，和同时修改学生信息。类似NFC修改绑定，但通过遥控指令方式，不是刷卡方式。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，一般是0x0000，所有答题器都执行或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 31 绑定和解绑 |
| 5-10 | SN | 答题器硬件序列号，6字节对教育新体系，后4字节SN有效 |
| 11 | MODE | 1 绑定<br>2 解绑 |
||||
||||

投票器回应：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 投票器遥控指令应答 |
| 2-3 | KEYID | 投票器编号，2字节，高位在前（指令是指定编号的）<br>=0xFFFF，用SN应答 |
| 4 | KCMD | 31绑定和解绑的应答 |
| 5-10 | SN | 答题器硬件序列号，6字节<br>对教育新体系，后4字节SN有效 |
| 11 | MODE | 1 绑定2 解绑 |
||||
||||

### 5.2.13 分组设置（未确定）

用于修改答题器的分组设置。注意本指令超标准长度。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 15 分组设置 |
| 5-10 | SN | 答题器硬件序列号，6字节<br>对教育新体系，后4字节SN有效 |
| 11 | GROUP | 组号，1起 |
| 12-27 | NAME | 组名，最大16字符，8汉字 |
||||

投票器回应：（注意本指令超标准长度）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 投票器遥控指令应答 |
| 2-3 | KEYID | 投票器编号，2字节，高位在前（指令是指定编号的）<br>=0xFFFF，用SN应答 |
| 4 | KCMD | 15 分组设置应答 |
| 5-10 | SN | 答题器硬件序列号，6字节<br>对教育新体系，后4字节SN有效 |
| 11 | GROUP | 组号，1起 |
| 12-27 | NAME | 组名，最大16字符，8汉字 |
||||

### 5.2.14 外设动作控制（未确定）

用于控制投票器外设执行动作，震动、指示灯、蜂鸣器等。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 16 外设动作控制 |
| 5-10 | SN | 答题器硬件序列号，6字节<br>对教育新体系，后4字节SN有效 |
| 11 | MODE | 控制外设类型<br> 1 震动 <br>2 指示灯<br> 3 蜂鸣器 <br>4 背光<br>5 麦克风录音打开<br>6 手写笔迹传输打开 |
| 12- || 控制参数 |
||||

不同外设类型参数如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 11 | MODE | 控制外设类型1 震动 |
| 12 | TIMES | 震动次数 |
| 13 | POWER | 强度，1=弱 2=中 3=强，其他按2处理 |
| 14 | TON | 每次开时间，单位0.5s，\>1 |
| 15 | TOFF | 每次关时间，单位0.5s，为0就是连续震动 |
||||

| 11 | MODE | 控制外设类型<br>2 指示灯 |
| --- | --- | --- |
| 12 | TIMES | 闪烁次数，0是马上灭，255是长亮 |
| 13 | POWER | 亮度，暂0，但SDK有接口 |
| 14 | TON | 每次开时间，单位0.5s，\>1 |
| 15 | TOFF | 每次关时间，单位0.5s，为0就是连续亮 |
| 16 | R | 灯颜色 红值 |
| 17 | G | 灯颜色 绿值 |
| 18 | B | 灯颜色 蓝值 |
||||

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 11 | MODE | 控制外设类型<br>3 蜂鸣器 |
| 12 | TIMES | 响次数 |
| 13 | POWER | 强度，1=弱 2=中 3=强，其他按2处理 |
| 14 | TON | 每次开时间，单位0.5s，\>1 |
| 15 | TOFF | 每次关时间，单位0.5s，为0就是连续震动 |
||||

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 11 | MODE | 控制外设类型4 背光 |
| 12 | TIMES | 闪烁次数 |
| 13 | POWER | 暂0 |
| 14 | TON | 每次开时间，单位0.5s，\>1 |
| 15 | TOFF | 每次关时间，单位0.5s，为0就是连续震动 |
||||

投票器回应：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 投票器遥控指令应答 |
| 2-3 | KEYID | 投票器编号，2字节，高位在前（指令是指定编号的）<br>=0xFFFF，用SN应答 |
| 4 | KCMD | 16 外设控制应答 |
| 5-10 | SN | 答题器硬件序列号，6字节<br>对教育新体系，后4字节SN有效 |
| 11 | MODE | 外设类型，对应设置指令 |
| 12 | OK | 1 OK<br>0 失败，一般是不支持 |
||||

### 5.2.15 文字自定义显示

用于在指定键盘上指定位置显示字符串。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 17 自定义显示（T2代码用于StopByMsg了，先写键盘，停止时候再显示）<br>19 自定义显示 |
| 5-8 | SN | 答题器硬件序列号，4字节（注意是4字节，以满足高思显示8汉字） |
| 9 | MODE2 | 显示模式<br> 0 使用后面的字符串内容<br> 1-9 预置显示信息（提前下载好，或写死的方案）<br>高4位可控制字体大小（暂不用） |
| 10 | XY | 显示位置，以8点为1单位<br>高4位是X，低4位是Y |
| 11-26 | STR | MODE2=0时候要显示的字符串，最大16字符 |
| 27-28 | CRC16 | 效验值 |

投票器回应：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 投票器遥控指令应答 |
| 2-3 | KEYID | 投票器编号，2字节，高位在前（指令是指定编号的）=0xFFFF，用SN应答 |
| 4 | KCMD | 17 自定义显示应答 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | OK | 1=OK |
||||

### 5.2.16 回写测验题内容

用于替换键盘的时候，已经答题的题目，内容通过软件写回替换后的键盘。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000广播<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 17 回写测验题答题结果 |
| 5-8 | SN | 答题器硬件序列号，4字节<br>（为了兼容同时写2题目减少时间，是8BCD字节的测验内容） |
| 9 | NO1 | 题号1 |
| 10-17 | VAL1 | 8字节BCD码表示的题目输入内容 |
| 18 | NO2 | 题号2，如果=00表示后面空，即1次回写1题目内容 |
| 19-26 | VAL1 | 8字节BCD码表示的题目2输入内容 |
| 27-28 | CRC16 ||

投票器回应：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 投票器遥控指令应答 |
| 2-3 | KEYID | 投票器编号，2字节，高位在前（指令是指定编号的）<br>=0xFFFF，用SN应答 |
| 4 | KCMD | 17 回写测验题答题结果应答 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | OK | 1 OK<br>0 失败，一般是不支持 |
| 10-17 | VAL1 | 8字节BCD码表示的题目输入内容 |
||||

### 5.2.17 读取测验题结果

用于指定某个键盘，读取某个题号的结果，用于解决键盘漏交的bug。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000广播<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 18 读取测验题答题结果 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | NO | 题号 |
||||
| 27-28 | CRC16 ||

投票器回应：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 投票器遥控指令应答 |
| 2-3 | KEYID | 投票器编号，2字节，高位在前（指令是指定编号的）<br>=0xFFFF，用SN应答 |
| 4 | KCMD | 18 返回测验答题结果 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | NO | 题号 |
| 10 | TYPE | 7 按ABCD解码 8 按数字解码 |
| 11-18 | VAL | 8字节BCD码表示的题目输入内容 |
| 19-20 | TIME | 按键时间 |
| 21 | VOLT | 电压值 |
||||
| 27-28 | CRC16 ||

### 5.2.18获取调试信息（未设计）

### 5.2.19 写OEM型号显示名称

用于更改液晶上的型号显示名称。

一般是广播，键盘不用应答，但键盘显示出来供人工核查。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000广播<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 19 写键盘型号显示名称 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9-24 | MODEL_NAME | 型号名称，最多16字符 |
||||
| 27-28 | CRC16 ||

投票器回应：（广播时候不用）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 投票器遥控指令应答 |
| 2-3 | KEYID | 投票器编号，2字节，高位在前（指令是指定编号的）<br>=0xFFFF，用SN应答 |
| 4 | KCMD | 19 写键盘型号显示名称 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | OK | 1 OK<br>0 失败，一般是不支持 |
| 10-25 | MODEL_NAME | 型号名称，最多16字符 |
||||
| 27-28 | CRC16 ||

## 5.3 手机类设置

### 5.3.1 服务器地址

用于指定云平台服务器地址和端口。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 30 设置服务器地址 |
| 5-8 | SN | 答题器硬件序列号，4字节（注意是4字节） |
| 9 | MODE | 1 设置 2读取 |
| 10 |||
| 11-26 | DNS | 不包含HTTP的服务器地址和端口，最大16字符 |
| 27-28 | CRC16 | 效验值 |

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 30 设置服务器地址 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | MODE | 2读取应答 |
| 10 |||
| 11-26 | DNS | 不包含HTTP的服务器地址和端口，最大16字符 |
| 27-28 | CRC16 | 效验值 |

### 5.3.2 GPS定位设置

用于指定GPS定位参数。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 31 GPS定位设置 |
| 5-8 | SN | 答题器硬件序列号，4字节（注意是4字节） |
| 9 | MODE | 1 设置 2读取 |
| 10 | T1 | 定位间隔，多长时间获取1次定位数据，单位分钟 |
| 11 | T2 | 上报间隔，多长时间上报1次定位数据，单位分钟 |
| 12-15 | WORKT1 | 工作时段1，4字节，分别是开始小时、开始分钟、结束小时、结束分钟 |
| 16-19 | WORKT2 | 工作时段2，结构同上 |
||| 空 |
| 27-28 | CRC16 | 效验值 |

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 31 GPS定位设置 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | MODE | 2读取应答 |
| 10 | T1 | 定位间隔 |
| 11 | T2 | 上报间隔 |
| 12-15 | WORKT1 | 工作时段1 |
| 16-19 | WORKT2 | 工作时段2 |
||||
| 27-28 | CRC16 | 效验值 |

### 5.3.3 通话设置

用于设置通话参数。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 32 通话设置 |
| 5-8 | SN | 答题器硬件序列号，4字节（注意是4字节） |
| 9 | MODE | 1 设置 2读取 |
| 10 | T1 | 允许通话时长，单位分钟 |
| 11 | PH\_NUM | 亲情号码数目 |
| 12-15 | WORKT1 | 允许通话时段1，4字节，分别是开始小时、开始分钟、结束小时、结束分钟 |
| 16-19 | WORKT2 | 允许通话时段2，结构同上 |
||| 空 |
| 27-28 | CRC16 | 效验值 |

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 32 通话设置 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | MODE | 2读取应答 |
| 10 | T1 | 通话时长 |
| 11 | PH\_NUM | 亲情号码数目 |
| 12-15 | WORKT1 | 工作时段1 |
| 16-19 | WORKT2 | 工作时段2 |
||||
| 27-28 | CRC16 | 效验值 |

### 5.3.4 短信设置

用于设置短信参数。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 33 短信设置 |
| 5-8 | SN | 答题器硬件序列号，4字节（注意是4字节） |
| 9 | MODE | 1 设置 2读取 |
| 10 | MSG\_NUM | 短信保存条数 |
| 11 |||
| 12-15 | WORKT1 | 允许短信时段1，4字节，分别是开始小时、开始分钟、结束小时、结束分钟 |
| 16-19 | WORKT2 | 允许短信时段2，结构同上 |
||| 空 |
| 27-28 | CRC16 | 效验值 |

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 33 短信设置 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | MODE | 2读取应答 |
| 10 | MSG\_NUM | 短信保存条数 |
| 11 || 空 |
| 12-15 | WORKT1 | 工作时段1 |
| 16-19 | WORKT2 | 工作时段2 |
||||
| 27-28 | CRC16 | 效验值 |

### 5.3.5 亲情号码设置

用于设置亲情电话本号码参数。（号码数目在通话设置）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 34 亲情号码设置 |
| 5-8 | SN | 答题器硬件序列号，4字节（注意是4字节） |
| 9 | MODE | 1 设置号码 2读取号码 3设置姓名 4读取姓名 |
| 10 | NO | 电话本位置 1-10 |
| 11-26 | NAME_PHONE | 姓名或者电话，最大16字符，中文按GB2312编码 |
| 27-28 | CRC16 | 效验值 |

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 34 亲情号码设置 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | MODE | 2号码读取应答 4姓名应答 |
| 10 | NO | 电话本位置 |
| 11-26 | NAME_PHONE | 姓名或者电话，最大16字符，中文按GB2312编码 |
| 27-28 | CRC16 | 效验值 |

### 5.3.6 快捷短信设置

用于设置短信回复快捷短语。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 35 短信回复设置 |
| 5-8 | SN | 答题器硬件序列号，4字节（注意是4字节） |
| 9 | MODE | 1 设置2读取 |
| 10 | NO | 短语编号，一般1-9 |
| 11-26 | MSG | 回复短语，最大16字符，中文按GB2312编码，最多8汉字<br>例如 "收到"、"我到学校了"、"我放学了" |
| 27-28 | CRC16 | 效验值 |

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 35 短信短语设置 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | MODE | 2短信短语应答 |
| 10 | NO | 短语编号 |
| 11-26 | MSG | 短语内容 |
| 27-28 | CRC16 | 效验值 |

### 5.3.7 工作日设置

用于设置通话、短信规则起效果的工作日。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x30 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 36 工作日设置 |
| 5-8 | SN | 答题器硬件序列号，4字节（注意是4字节） |
| 9 | MODE | 1 设置2读取 |
| 10 | NO | 工作日规则编号<br> 1 周一到周五 <br>2 周一到周六 <br>3 周一到周日|
||||
| 27-28 | CRC16 | 效验值 |

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB0 表决器下载单包类指令 |
| 2-3 | KEYID | 答题器编号，用编号指定答题器，0000表示所有键盘都执行<br>或者0xFFFF，用SN号指定答题器 |
| 4 | KCMD | 36 工作日设置 |
| 5-8 | SN | 答题器硬件序列号，4字节 |
| 9 | MODE | 2读取应答 |
| 10 | NO | 工作日规则编号 |
||||
| 27-28 | CRC16 | 效验值 |

## 5.4 T2Soc快速设置

指令按64字节设计，除去4字节配对码和2字节CRC，指令58字节。
==第58字节为序号字节 SDK针对每个不同的SN 发送一条就COUNT++。1-255 循环
传输序号，用于键盘去重，SDK针对每个SN自增（1-255循环）==
指令码改用0x38。

### 5.4.1 自定义文本显示

用于修改答题器液晶显示。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x38 T2Soc下载单包类指令 |
| 2-5 | SN | 指定答题器的SN，全0是广播 |
| 6 | KCMD | 1 自定义三行文本 |
| 7 | SCMD（6Bit） | 具体下发类型：<br> 1：自定义姓名<br> 2：积分字符串 <br>3：积分五角星（0-7） <br>4：第二行文本（现已处理4=5）<br> 5：第二行文本（原用于提交之后，现已处理4=5）<br>6：第三行文本 |
| 7 | CONT（2Bit） | 0 ：不操作 1：写入 2：清除 |
| 8-23 | TEXT | 16字节文本 |
| 24 | SCMD（6Bit）CONT（2Bit） ||
| 25-40 | TEXT ||
| 41 | SCMD（6Bit）CONT（2Bit） ||
| 42-57 | TEXT ||

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB8 表决器下载单包类指令 |
| 2-5 | SN | 答题器SN |
| 6 | KCMD | 1 自定义三行文本应答 |
| 7-58 || Copy指令回复 |

### 5.4.2 指定答题

指定答题器进入特定答题模式，含自定义标题。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x38 T2Soc下载单包类指令 |
| 2-5 | SN | 指定答题器的SN，全0是广播 |
| 6 | KCMD | 2 指定答题 |
| 7 | DATAPOS | 从本字节开始16字节，等同于2.2节第4字节起的16字节 |
| 8 | MODE | 投票模式 |
| 9-26 | MODES | 投票参数 |
||||
| 27-42 | TITLE1 | 16字节自定义标题 |
| 43-58 | TITLE2 | 预留标题2 |

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB8 表决器下载单包类指令 |
| 2-5 | SN | 答题器SN |
| 6 | KCMD | 2 指定答题应答 |
||||
| -58 |||

### 5.4.3 外设控制

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x38 T2Soc下载单包类指令 |
| 2-5 | SN | 指定答题器的SN，全0是广播 |
| 6 | KCMD | 3 外设控制 |
| 7 | LED_CTRL | LED是否本次指令控制 1是 0否 |
| 8 | LEDTIMES | LED灯闪烁次数，0是马上灭，255是长亮 |
| 9 | LED_TON | 每次开时间，单位0.1s，>1 |
| 10 | LED_TOFF | 每次关时间，单位0.1s，为0就是连续亮 |
| 11 | R | LED灯颜色 红值 |
| 12 | G | LED灯颜色 绿值 |
| 13 | B | LED灯颜色 蓝值 |
| 14 | BEEP_CTRL | 蜂鸣器是否本次指令控制 1是 0否 |
| 15 | BEEPTIMES | 蜂鸣器响次数 |
| 16 | BEEP_TON | 每次开时间，单位0.1s，>1 |
| 17 | BEEP_TOFF | 每次关时间，单位0.1s，为0就是连续震动 |
| 18 | MOTO_CTRL | 马达是否本次指令控制 1是 0否 |
| 19 | MOTO TIMES | 马达响次数 |
| 20 | MOTO _TON | 每次开时间，单位0.1s，>1 |
| 21 | MOTO _TOFF | 每次关时间，单位0.1s，为0就是连续震动 |
||||

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB8 表决器下载单包类指令 |
| 2-5 | SN | 答题器SN |
| 6 | KCMD | 3 外设控制 |
||||
| -58 |||

### 5.4.4 遥控关机

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x38 T2Soc下载单包类指令 |
| 2-5 | SN | 指定答题器的SN，全0是广播 |
| 6 | KCMD | 4 遥控关机 |
||||

### 5.4.5 遥改配对码（解绑）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x38 T2Soc下载单包类指令 |
| 2-5 | SN | 指定答题器的SN，全0是广播 |
| 6 | KCMD | 5 遥改配对码 |
| 6-9 | MatchCode | 4字节配对码（全0相当于清除配对码） |
||||

### 5.4.6 通讯测试

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x38 T2Soc下载单包类指令 |
| 2-5 | SN | 指定答题器的SN |
| 6 | KCMD | 6 通讯测试 |
| 7-8 | SendPos | 发送序号（改成整数，1000次） |
| 9-10 | RcvOk | 成功次数 |

键盘应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB8 表决器下载单包类指令 |
| 2-5 | SN | 答题器SN |
| 6 | KCMD | 6 通讯测试 |
| 7-8 | SendPos | 接收到的发送序号，这样发送方好判断成功率 |
| -58 |||

### 5.4.7 空指令

本指令用于测试指令的传输是否漏，比如SDK向基站发送1000条，T2Soc基站会同时先模块传输，最终模块判断是空指令不会执行，只是返回收到指令的累加数量（通过LOG结果返回显示）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x38 T2Soc下载单包类指令 |
| 2-5 | SN | 指定答题器的SN |
| 6 | KCMD | 0 空指令，用于指令传输测试是否丢包 |
||||
||||

### 5.4.8 键盘参数设置

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x38 T2Soc下载单包类指令 |
| 2-5 | SN | 指定答题器的SN 全0是广播 |
| 6 | KCMD | 7 参数设置 |
| 7 | CID_ CTRL | 0 ：不操作 1：写入 2：清除 3读取 |
| 8-9 | CID[2] | CID |
||||

键盘应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB8 表决器下载单包类指令 |
| 2-5 | SN | 答题器SN |
| 6 | KCMD | 7参数设置 |
| 7 | CID_ CTRL | ----- |
| 8-9 | CID[2] | CID读取值 |
| -58 |||

### 5.4.9 长姓名

用于修改答题器液晶显示。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x38 T2Soc下载单包类指令 |
| 2-5 | SN | 指定答题器的SN，全0是广播 |
| 6 | KCMD | 8 长姓名下发 |
| 7 | NULL | 预留 |
| 8-55 | NAME | 长姓名字符串（48字节） |
| 56-58 | NULL | 预留 |

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB8 表决器下载单包类指令 |
| 2-5 | SN | 答题器SN |
| 6 | KCMD | 8 长姓名下发 |
| 7-58 || Copy指令回复 |

### 5.4.10 生僻字12号字体

用于修改答题器液晶显示。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x38 T2Soc下载单包类指令 |
| 2-5 | SN | 指定答题器的SN，全0是广播 |
| 6 | KCMD | 20 生僻字12号字体 |
| 7-8 | GB_CODE1 | GB18030_编码 |
| 9-32 | GB_DATA1 | 点阵库数据（24字节） |
| 33-34 | GB_CODE2 | GB18030_编码 |
| 35-58 | GB_DATA2 | 点阵库数据（24字节） |

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB8 表决器下载单包类指令 |
| 2-5 | SN | 答题器SN |
| 6 | KCMD | 20 生僻字12号字体 |
| 7-58 || Copy指令回复 |

### 5.4.11设置键盘频点

用于修改答题器频点，注意修改完频点之后，如果目标频点短时间内没基站则会离线。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0x38 T2Soc下载单包类指令 |
| 2-5 | SN | 指定答题器的SN，全0是广播 |
| 6 | KCMD | 10设置键盘频点 |
| 7 | FREQ | 频点值 不为0 |

键盘应答：（广播的话不需应答）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | KEYCMD | 0xB8 表决器下载单包类指令 |
| 2-5 | SN | 答题器SN |
| 6 | KCMD | 10设置键盘频点 |
| 7-58 || Copy指令回复 |

## 5.5 S6体系快速设置

### 5.5.1 信标总体格式

下发信标格式：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
|| **ATC（ 4Byte ）**|**配对码** |
| 1 | KEYCMD | 0x37 下载单包类指令(自动拼包版本) |
| 2-5 | SN | 指定答题器的SN，全0是广播（SDK提供） |
| 6 | PACKMAX | 后续传输包数量 此处为最大为3<br>（最大支持三包连续，数据最大为：19+32+32 =83字节 = 基站每条指令缓存大小）<br>指令按大小基站自动调整是发送一个包还是3个包（基站提供） |
| 7-8 | CRC16 | 本包透传数据的CRC CmdData 的CRC（基站提供） |
| 9 | Tr_Count | 传输序号，用于键盘去重，SDK针对每个SN自增（1-255循环）<br>//SDK断线从1重新开始，键盘重新与基站连接清0（SDK提供） |
| 10-28 | Cmd_Data | 第一包19字节（SDK提供） |
| 29-61 | Cmd_Data | 第二包32字节（SDK提供） |
| 62-93 | Cmd_Data | 第三包32字节（SDK提供） |

备注： CmdData内可支持对同一个SN下发几条设置信息，只需保证字节长度不超过83字节。 数据越短速度越快。

ACK格式：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
|| **ATC （ 4Byte ）**|**配对码** |
| 1 | KEYCMD | 0xB7下载单包类指令ACK(自动拼包版本) |
| 2-5 | SN | 指定答题器的SN |
| 6 | NULL | 预留 |
| 7-8 | NULL | 预留 |
| 9 | Tr_Count | 传输序号，用于键盘去重，基站针对每个SN自增（1-255循环）<br> ==对应下发信标== |
| 10-28 | NULL | 预留 |

### 5.5.2 CMD概述

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 1：姓名写 <br>2：姓名清 <br>3：积分字符串<br> 4：积分栏清<br> 5：积分五角星 <br>6：积分爱心显示 <br>7：测验题分数<br><br>10：第二行文本写 <br>11：第二行文本清 <br>12：第三行文本写 <br>13：第三行文本清<br>30：外设控制 LED <br>31：外设控制 BEEP <br>32：外设控制 MOTO<br><br>40：遥控关机 <br>41：遥改配对码 <br>42：键盘参数设置 - CID<br>43：键盘参数设置 - FSN<br>44：键盘授权<br>45：键盘授权 登录拒绝<br>46：键盘授权 踢出授权<br>50：指定答题<br> 51：答题标题<br> 52："发送中"预置 <br>53："发送中"预置清<br> 54："已发送"预置 <br>55："已发送"预置清<br>56："在线"预置<br>57："在线"预置清<br>58："离线"预置<br>59："离线"预置清<br><br>60：订餐短消息 <br>61：恢复出厂设置<br>62 清除多科科目所有预置<br><br>70生僻字12号字体<br>71："语文"预置<br>72："数学"预置<br>73："英语"预置<br>74："政治"预置<br>75："历史"预置<br>76："地理"预置<br>77："生物"预置<br>78："物理"预置<br>79："化学"预置<br>80答案补交<br>81-86：对应的文本<br>87为清除81-86预设值<br>90：测验题锁定与解锁<br>91：多科科目10名称预置<br>92：多科科目11名称预置<br>93：多科科目12名称预置<br>94~99：多科科目名称预置备用<br>


|
| 1 | LEN | 长度（长度为Data长度，可为0） |
| N | Data | 数据详细内容 |

#### 5.5.2.1 姓名写/清

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型 1：姓名写 2：姓名清 |
| 1 | LEN | 长度<br>写姓名长度最大83字节<br>清姓名长度为0 |
| N | Data | 数据详细内容 （LEN=0时没有Data） |

#### 5.5.2.2 积分写/清

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 3：积分写<br> 4：积分清 |
| 1 | LEN | 长度<br>写积分长度最大16字节<br>清积分长度为0 |
| N | Data | 数据详细内容 （LEN=0时没有Data） |

#### 5.5.2.3 积分五角星

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 5：积分五角星 |
| 1 | LEN | 1（固定长度1） |
| 1 | Data | 等级（0-6） |

#### 5.5.2.4 积分爱心

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 6：写积分爱心 |
| 1 | LEN | 1（固定长度1） |
| 1 | Data | 等级（0-6） |

#### 5.5.2.5 测验题分数

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 7：写测验题分数 |
| 1 | LEN | 2（固定长度2） |
| 2 | Data | 测验题分数精度0.1 最大6553.5 |

#### 5.5.2.6 文本写/清

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 10：第二行文本写<br> 11：第二行文本清 <br>12：第三行文本写<br> 13：第三行文本清 |
| 1 | LEN | 文本字符串长度（清LEN=0） |
| 16 | TEXT | 最大16字节（目前键盘限制到16字节） |

#### 5.5.2.7 外设控制

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型 <br>30：外设控制 LED LEN =6<br> 31：外设控制 BEEP LEN =3 <br>32：外设控制 MOTO LEN =3 |
| 1 | LEN | 长度 |
| 1 | LEDTIMES | 开关次数，0是马上关，255是一直开 |
| 1 | LED_TON | 每次开时间，单位0.1s，\>1 |
| 1 | LED_TOFF | 每次关时间，单位0.1s，为0就是连续开 |
| 1 | R | LED灯颜色 红值 LED才有 |
| 1 | G | LED灯颜色 绿值 LED才有 |
| 1 | B | LED灯颜色 蓝值 LED才有 |

#### 5.5.2.8 遥控关机

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型 <br>40：遥控关机 |
| 1 | LEN | 长度 0 |

#### 5.5.2.9 遥改配对码

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 41：遥改配对码 |
| 1 | LEN | 长度 4 |
| 4 | ATC | 配对码 |

#### 5.5.2.10 键盘参数设置 - CID

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 42：键盘设置CID |
| 1 | LEN | 长度 2 |
| 2 | CID | 编号 |

#### 5.5.2.11 键盘参数设置 - FSN

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 43：键盘设置FSN |
| 1 | LEN | 长度 4 |
| 4 | FSN | 编号 |

#### 5.5.2.12 键盘授权

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 44：键盘授权  登录成功|
| 1 | LEN | 长度 1 |
| 1 | AUTHORIZE | 授权：<br>1，登录成功；<br>2，信息有误，重新登录；<br>3，失败，系统不允许；<br>4，白名单键盘重新登录；|

#### 5.5.2.12 键盘授权

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 45：键盘授权 登录拒绝|
| 1 | LEN | 长度 1 |
| 1 | |
#### 5.5.2.12 键盘授权

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 46：键盘授权 踢出授权|
| 1 | LEN | 长度 1 |
| 1 | |
#### 5.5.2.12 设置键盘离线关机时间

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 47：离线关机时间|
| 1 | LEN | 长度 2 |
| 2 | TIME | 关机时间单位 1S <br>键盘内置最小10S 防止设错|

#### 5.5.2.13 指定答题

正常单体的指定答题

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 50：指定答题 |
| 1 | LEN | 长度 LEN 后面的数据长度 |
| 1 | DATAPOS | ~~从本字节开始16字节，等同于2.2节第4字节起的16字节~~<br>  ==这里保留，指定答题，SDK 不更改DataPos , 键盘根据基站下发包中提供的 Tr\_Count 作为去重（一次 SDK 指令键盘只生效一次）<br>基站响应指定投票时，不需要像 T2 一样关闭投票信标。不做特殊处理。将指定答题当成一包传输数据，并且数据不需要同步到信标中去。<br> 键盘处理，记录当前投票信标中的DataPos ，在这个过程中发生了指定答题之后，键盘再收到投票信标 DataPos 不变则不响应投票信标的内容。== |
| 1 | MODE | 投票模式 |
| N<18 | MODES | 投票参数 这里SDK是否可以优化，识别到不同的题目后面全0的省掉 减少LEN长度。 |

#### 5.5.2.14 答题标题

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br>51：答题标题 （只能50指定答题打包在同一条内，固定为这次指定答题的标题） |
| 1 | LEN | 长度 LEN 后面的数据长度 |
| N | TEST | 文本 |

#### 5.5.2.15 预置配置显示

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 52："发送中"预置 <br>53："发送中"预置清 <br>54："已发送"预置<br> 55："已发送"预置清<br> 56："在线"预置 <br>57："在线"预置清 <br>58："离线"预置<br> 59："离线"预置清 |
| 1 | LEN | 文本字符串长度（清LEN=0） |
| 16 | TEXT | 最大16字节（目前键盘限制到16字节） |

#### 5.5.2.16 短消息下发

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型 60：订餐短消息。 |
| 1 | LEN | 文本字符串长度（清LEN=0） |
| 1 | NULL | 预留 |
| 1 | month | 月份 1 - 12 |
| 1 | date | 日期 1 - 31 |
| 16 | TEXT | 最大80字节 |

#### 5.5.2.17 生僻字12&16

用于生僻字12号字体 字符下传。最多单条内支持三个生僻字。多的需要SDK拆包。

只有一个生僻字下发时 只需根据LED长度设置即可

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 70生僻字12号字体 |
| 1 | LEN | 文本字符串长度（清LEN=0） 26/52/78 |
| 2 | GB_CODE1 | GB18030_编码 |
| 24 | GB_DATA1 | 点阵库数据（24字节） |
| 2 | GB_CODE2 | GB18030_编码 |
| 24 | GB_DATA2 | 点阵库数据（24字节） |
| 2 | GB_CODE3 | GB18030_编码 |
| 24 | GB_DATA3 | 点阵库数据（24字节） |

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 69生僻字16号字体 |
| 1 | LEN | 文本字符串长度（清LEN=0） |
| 2 | GB_CODE1 | GB18030_编码 |
| 32 | GB_DATA1 | 点阵库数据（32字节） |
| 2 | GB_CODE2 | GB18030_编码 |
| 32 | GB_DATA2 | 点阵库数据（32字节） |

#### 5.5.2.18 测验题补题答案

逻辑，SDK进入测验结束时，自动判断谁漏题了，启用快速设置询问键盘该题，键盘若未达，则提交空答案

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 80答案补交 |
| 1 | LEN | 文本字符串长度（清LEN=0） |
| 1 | SendPos | 缺第几题 |

#### 5.5.2.19 恢复出厂设置

包含：
&emsp;&emsp;清空短信消息/姓名/分数/自定义信息等等 键盘内缓存不清除配对码

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型 61：恢复出厂设置 |
| 1 | LEN | 文本字符串长度（清LEN=0） |
| 1 | NULL | 预留 |


#### 5.5.2.20 文本预设

对应测验题显示 81单选，82多选（排序），83数字，84判断  85自判题-对错（乐教乐学）86 自判题-数字（输入评分）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型 81-86：对应的文本 87为清除81-86预设值|
| 1 | LEN | 文本字符串长度（清LEN=0） |
| 16 | TEXT | 最大16字节（目前键盘限制到16字节） |

#### 5.5.2.21 测验题锁定解锁

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型 90：测验题锁定与解锁|
| 1 | LEN | 文本字符串长度（清LEN=0） |
| 1 | data | 1锁定 2解锁 |

#### 5.5.2.22 测验题预置标题更改

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 类型<br> 62 清除该类所有预置<br>71："语文"预置 <br>72："数学"预置<br>73："英语"预置<br>74："政治"预置<br>75："历史"预置<br>76："地理"预置<br>77："生物"预置<br>78："物理"预置<br>79："化学"预置<br>|
| 1 | LEN | 文本字符串长度（清LEN=0） |
| 16 | TEXT | 最大10字节（目前键盘限制到10字节） |

# 六、下载多包类

## 6.1 概述

&emsp;&emsp;下载多包类主要用于下载一批数据。例如项目名称表、评议规则表等。

&emsp;&emsp;我们统一使用《广播式下载方式》来下载多包（即数据表），具体原理参见《表决系统通讯协议-应用文档-原理》。

## 6.2 进入和退出下载状态

通知表决器进入下载模式的好处：

1、在重新下载未成功的表决器时候，仅通知未成功的进入下载状态，其他成功的表决器就可以不处理下载数据；

2、能立即知道是否在线，表决器可以准备擦除FLASH，V4.52对于支持文件下载的就按文件名称创建文件；

3、退出时，表决器能知道下载完成。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | DOWNCMD | 0x40 下载多包类指令 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>一般要指定表决器编号使指定键盘进入或退出下载状态<br>但0x0000广播时候，键盘也执行<br>FF01到FFFE时候，是用序列号指定键盘 V4.74<br>低位字节01-FE，表示下载次序，由SDK管理，新下载变化一次，<br>键盘收到的时候，记录下，同时，此次序也出现在下载数据包中，这样键盘可判断是否是我可以下载的数据，避免上次下载状态没正常退出而错误接受数据 |
| 4 | DOWNCMD | 1 进入或退出下载状态 |
| 5 | DOWNTYPE | 多包类型 |
| 6 | DOWNID | 数据包标识码 |
| 7 | DCMD | 模式 1进入下载 0退出下载 |
| ~~8-24~~ | ~~INFO~~ | ~~在DOWNTYPE=40下载文件模式时候，是下载文件名称，16字符~~ |
| 8-13 | SN | 序列号模式时候，6字节键盘序列号，用于指定键盘<br>对教育新体系，后4字节SN有效，前2字节FFFF<br>暂不支持文件下载 |
| 14-23 | BIN_INFO | 在DOWNTYPE=30固件升级模式，待下载固件的信息定义：1BYTE可升硬件版本 + 3BYTE待升固件版本 + 2BYTE待升固件校验字(CRC-16) + 4BYTE待升固件大小，共10字节<br>其他模式参数无意义 |
||||
| 27-28 | CRC16 | 这里如果有值不等于0，表示指令带效验，从1计算到26字节<br>这里如果是0，或者数据包只有24字节，表示老体系的不带效验<br>本章节后面，长度24字节的，都可以变成28字节，不修改文档了 |

表决器回应结果状态：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | DOWNCMD | 0xC0 下载多包类指令应答 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>不是0000也不是FFFF，是要询问的表决器的编号<br>FFFF 表示用SN号代表键盘 |
| 4 | DOWNCMD | 1回应下载状态 |
| 5 | DOWNTYPE | 多包类型 |
| 6 | DOWNID | 数据包标识码 |
| 7 | DCMDACK | 现在模式 1已经进入下载模式 0已经退出下载模式 |
| 8-24 | SN | 使用SN号模式时候，键盘的SN，6字节否则参数无意义 |

## 6.3 广播式下载数据包和查询状态

具体原理参见《表决系统通讯协议-应用文档-原理》。
下载数据包指令结构如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | DOWNCMD | 0x40 下载多包类指令 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>0xFFFF的时候是部分表决器下载，是常用模式，进入下载模式的表决器才处理数据 <br>0x0000时候是广播下载，所有表决器都接收和处理<br>其他值是指定下载，编号和KEYID相同的才处理数据<br>FF01到FFFE时候，是序列号模式 V4.74<br>低位字节和进入下载模式时候的低位字节相同，用于键盘判断是否是当前下载数据 |
| 4 | DOWNCMD | 2 广播式下载具体数据 |
| 5 | DOWNTYPE | 多包类型 |
| 6 | DOWNID | 数据包标识码<br>文件下载模式时候是最高位地址 V4.52<br>由于非文件下载模式PACKH加上PACKL，只能下载65536字节，文件下载模式为支持大文件，用DOWNID作为高位地址，可以下载16384K字节 |
| 7 | PACKH | 数据段编号，0-255 |
| 8 | PACKL | 数据片编号， 0-15 |
| 9-24 | PACKDATA | 16字节的数据 |
||||
| 27-28 | CRC16 | 这里如果有值不等于0，表示指令带效验，从1计算到26字节<br>这里如果是0，或者数据包只有24字节，表示老体系的不带效验<br>本章节后面，长度24字节的，都可以变成28字节，不修改文档了 |

备注：
1. 投票器先判断PACKH是否发生变化，发生变化就表示新的16片数据下载开始了，要把标志16片段下载成功状态的OKBITS全置1；
2. 然后计算地址，把PACKDATA16字节数据写到指定位置，对于非文件下载，地址=(PACKH\*16+PACKL)\*16，对于文件下载，地址=（（DOWNID\*256+PACKH）\*16+PACKL)\*16;
3. 然后把OKBITS中对应PACKL的比特位置0表示已经对应片段下载成功，用于应答下面的下载状态询问指令

询问下载成功状态指令结构：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | DOWNCMD | 0x40 下载多包类指令 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>使用键盘编号模式时候，不是0000也不是FFFF，是要询问的表决器的编号<br>FFFF，使用SN号询问键盘 |
| 4 | DOWNCMD | 3 询问广播式下载的执行状态 |
| 5 | DOWNTYPE | 多包类型 |
| 6 | DOWNID | 数据包标识码 |
| 7 | PACKH | 数据段编号 |
| 8-24 | SN | 指定键盘的SN号，6字节参数无意义 |

表决器回应下载成功状态：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | DOWNCMD | 0xC0 下载多包类指令应答 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br>不是0000也不是FFFF，是要询问的表决器的编号<br>FFFF，使用SN号回答 |
| 4 | DOWNCMD | 3 回应广播式下载的执行状态 |
| 5 | DOWNTYPE | 多包类型 |
| 6 | DOWNID | 数据包标识码 |
| 7 | PACKH | 数据段编号 |
| 8-9 | OKBITS_L<br>OKBITS_H | 下载成功状态，共16Bit，代表0-15号数据片，Bit=0表示下载成功<br>注意是低位字节在前，例如OKBITS_L=3，OKBITS_H=128时候，表示第1、2、16个数据片没下载成功，即0、1号和15号数据片不成功 |
| 10-24 | SN | 指定键盘的SN号，6字节<br>不是SN模式时参数无意义 |

## 6.4 数据包类型分类

通过DOWNTYPE和DOWNID两个字节的组合，可以决定下载数据包的类型。

下面列出目前使用的几种类型。具体数据包的格式和含义，请参见《数据表规范-政务商务》。

| **DOWNTYPE 值**| **DOWNID 值** | **数据包类型** |
| --- | --- | --- |
| ~~1~~ | ~~1~~ | ~~固定编号项目名称表~~ |
| ~~1~~ | ~~2~~ | ~~随机名称编号表~~ |
| ~~1~~ | ~~3~~ | ~~二维评测指标名称表~~ |
| ~~2~~ | ~~1~~ | ~~评议规则表~~ |
| ~~2~~ | ~~2~~ | ~~评议规则说明信息表~~ |
| ~~3~~ | ~~1~~ | ~~评分规则表~~ |
| ~~3~~ | ~~2~~ | ~~评分规则说明信息表~~ |
||||
| 10 | 变化 | 即时信息 |
| 11 | 变化 | 短消息 |
| 12 || 股东信息 |
||||
| **20** | **变化** | **多题答案数据** |
| **21** | **变化** | **测验 100 题的纯多选模式答案** |
||||
| **30** | **0** | **键盘固件升级 bin 文件** |
| **31** | **0** | **T2 键盘升级 bin 文件（每片传输不是 16 字节）** |
| **32** | **0** | **T2 模块升级 bin 文件** |
||||
| 40 | 高位地址 | 指定文件名称（可含目录）下载文件 |
| 50 || xPad的透传多包信息 |

### 6.4.1 关于即时信息短信的特殊说明

即时信息定义为马上显示在屏幕上的信息，不保存，看完即丢。

短信定义为保存的，可查看，即时显示或提醒。

下载数据包指令结构不变，但DOWNID和PACKH含义不同：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | DOWNCMD | 0x40 下载多包类指令 |
| 2-3 | KEYID | 表决器编号，2字节，高位在前<br> 0x0000时候是广播发信息，所有表决器都接收和处理，不需进入下载模式 <br>0xFFFF的时候是对多个表决器发信息，已经进入下载模式的才处理其他值是指定下载，编号和KEYID相同的才接收信息 |
| 4 | DOWNCMD | 2 广播式下载具体数据 |
| 5 | DOWNTYPE | 固定为10即时信息或11短信 12股东信息 50是xPad透传多包信息，一般是字符串信息20 多题答案数据 |
| 6 | DOWNID | 发一次信息就变化一次，表决器据此可知道是新的信息来了 |
| 7 | PACKH | 数据片总数，0表示1，F表示最多16片，也就是所短信息最多256字符，但一般限定64字符以内 |
| 8 | PACKL | 0-15，当前发送的数据片的编号 |
| 9-24 | PACKDATA | 16字节的数据 |

&emsp;&emsp;对于短信接收，表决器只要判断DOWNTYPE为10或11，然后DOWNID和以前的不同，就知道是新短信过来，并根据PACKH知道信息的长度，建立新的下载状态位。

&emsp;&emsp;然后根据PACKH判断所有片段是否都接收完毕，可以自动显示。

&emsp;&emsp;对于广播给所有表决器的信息，表决器不需单个单个进入下载模式，由SDK控制各片段信息多广播几次，表决器自己判断接收完整就显示。

&emsp;&emsp;对应指定单个表决器发信息，为提高速度，不对表决器执行进入下载模式，但要查询下载状态，确保信息完整下载，并且不执行退出下载模式。

&emsp;&emsp;对应指定多个表决器发信息，就必须进入下载模式，然后下载，然后查询，为提高下载速度，对表决器不执行退出下载模式。

&emsp;&emsp;所以，因为不执行退出下载状态，要注意的是，表决器要对短信模式下的进入下载状态要单独处理，避免和指定多个的表决器下载项目名称表等其他操作搞混。

### 6.4.2 多题答案

&emsp;&emsp;多题答案广播的处理方式，和6.4.1节的即时信息处理是一样的，按ID=0000广播方式处理，键盘也不需先进入下载模式，但DOWNTYPE值是专用的20。键盘收到完整的答案信息后，自动进行对错判断处理和显示。

&emsp;&emsp;下载的数据的内部格式，和 2.4.1节的多题答案相同。

&emsp;&emsp;软件调用流程，是先打开持续监听信标开关，然后启动测验的多题模式，键盘按键后进入作答，时间到后，软件调用测验停止，然后启动多题答案发送流程，SDK广播信息的次数，根据实际测试情况调整，保证99%键盘正确收到，然后软件调用停止投票进入空闲模式。考虑到需求上，键盘在考试完毕后需要重新显示答案信息，答案信息保存入EEPROM为好。

### 6.4.3 100题纯多选答案

&emsp;&emsp;多题答案广播的处理方式，和6.4.1节的即时信息处理是一样的，按ID=0000广播方式处理，键盘也不需先进入下载模式，但DOWNTYPE值是专用的21。键盘收到完整的答案信息后，自动进行对错判断处理和显示。

&emsp;&emsp;下载的数据的内部格式，和 2.4.3节的100题多选答案相同。

&emsp;&emsp;软件调用流程，是先打开持续监听信标开关，然后启动测验的多题模式，键盘按键后进入作答，时间到后，软件调用测验停止，然后启动多题答案发送流程，SDK广播信息的次数，根据实际测试情况调整，保证99%键盘正确收到，然后软件调用停止投票进入空闲模式。考虑到需求上，键盘在考试完毕后需要重新显示答案信息，答案信息保存入EEPROM为好。

### 8.4.4 键盘固件升级

键盘升级流程：（软件控制）

1. 键盘开机
2. 软件启用2.2.7节在线测试的模式3，带SN号状态报告，获取所有开机的键盘的SN号及固件版本信息；——报告状态中需要增加硬件版本信息域
3. 人工确认开始无线升级
4. 软件调用6.2节指令，按SN模式，告诉键盘进入无线升级固件下载模式，键盘可以显示固件下载中，逐个操作键盘进入固件下载模式（键盘中将严格比对，硬件版本号是否适合升级、固件版本号是否适合升级。符合升级要求则启动升级，否则不进入升级——避免同一固件多次升级或者硬件版本的不支持等情况）
5. 软件调用6.3节流程， ~~按~~~~ SN模式~~ 按照0xFF01-FFFE方式对启动升级功能的键盘，实行固件数据包广播（DOWNTYPE=30，按文件方式，DOWNID是高位地址），并查询键盘，最终保证每个键盘的固件能下载成功，当然也有失败的
6. 软件用6.2节的退出下载指令，按SN模式，让键盘退出下载模式，同时键盘自己启动固件升级过程；
7. 软件回到2.2.7节的在线扫描模式3，读取升级完成的键盘的SN号和版本号，版本成功的显示升级正确；——报告状态中需要增加硬件版本信息域
8. 软件可以指定SN关闭键盘，然后对升级不成功的键盘，尝试下一轮升级，人工同意的情况下

由于固件长度不一，这里只定义文件的前16字节含义：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BINTYPE | 格式号，暂固定=0xF0 |
| 2-9 | MODELNAME | 键盘型号字符串，8字节，用于上位机软件显示<br>例如S6plus |
| 10 | HMODEL | 键盘的型号代码，一定要和键盘型号代码相同<br>用于上位机软件，判断连接的键盘是否适合升级这个固件 |
| 11 | HVER | 键盘硬件版本 |
| 12-14 | SVER | 键盘软件版本，3字节，10进制数字<br>一定要和固件内部版本号相同，便于上位机软件好对比版本，知道键盘升级成功 |
| 15-16 | CRC-16 | 固件校验字 |

## 6.5 透传升级

### 6.5.1 概述

**流程：准备 -> 开始 -> 透传 -> 询问 -> 补传 -> 结束**

**准备阶段：** 只在基站端 键盘无感知 监听到相对干净的信道。（这阶段现阶段不设计，后续可根据实际情况看是否添加）

**开始阶段：** 在升级频点，开始4S广播告知键盘开始传输，包含数据量长度 总CRC 数据类型 本轮传输POS等信息。

**透传阶段：** 以100MS为间隔，1K为单位 发送2-3次 循环 直到发送完所有数据。

**询问阶段：** 透传完成之后，开始询问键盘接收进度。（Bit表表示）已收全键盘不回复基站。

**补传阶段：** 根据bit表透传键盘漏收数据/并重复询问与透传直到接收完成或者超时。

**结束阶段：** 发送4S广播告知键盘升级结束可以结束固件升级。

BIN文件头类型总结：

T2-KEYBOARD-BIN- &emsp;原始16字节头 不带任何信息

T2-BIN-XX.XX.XX &emsp;16字节带版本号信息的头（ST版本）

T2-GDB-XX.XX.XX &emsp;16字节带版本号信息的头（GD版本）

T2 &emsp;&emsp;&emsp;&emsp;&emsp;表示改BIN支持的类型 识别符

BIN/GDB &emsp;&emsp;表示改型号下 不同的MCU 类型 BIN文件识别符

| HEAD | 含义 | HW |
| --- | --- | --- |
| T2-BIN | T2_ST版本BIN文件 | 71 |
| T2-GDB | T2_GD版本BIN文件 | 72 |


<br>**BIN文件头类型总结：（S6）部分调整**
**SUN<font color="#dd0000">H</font><font color="#00dd00">B</font><font color="#0000dd">N</font>-XX.XX.XX**     16字节带版本号信息的头
<br>**基站BIN文件头类型总结：**
**BAS<font color="#dd0000">H</font><font color="#00dd00">B</font><font color="#0000dd">N</font>-XX.XX.XX**     16字节带版本号信息的头
| HEAD | 含义 |
| --- | --- |
| SUN | 识别头  固定识别字符串 |
| <font color="#dd0000">H</font>| U8   HW硬件号 |
| <font color="#00dd00">B</font> | U8   BR 硬件分支号 |
| <font color="#0000dd">N</font> | U8   无异议 预留 |
| XX.XX.XX | SW 固件版本 |

***
==升级总体设计图==
![升级总流程](img/升级总流程.png)
***
![广播阶段](img/广播阶段.png)
***
![透传阶段](img/透传阶段.png)
***
![询问阶段](img/询问阶段.png)
***

### 6.5.2 广播开始/结束

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4 | ATC | 配对码 |
| 1 | DOWNCMD | 0x42 透传下载多包方式 |
| 1 | DOWNTYPE | 透传多包类型 1 固件下载 |
| 1 | DOWNPOS | 透传序号 不能为0 1-255基站自增（新的一轮升级） |
| 1 | DOWNACT | 1进入透传 2退出透传（只ST支持）<br> 11进入透传 12退出透传 (区分硬件型号的开始升级，用于兼容以前未做GD和ST区分升级的兼容)<br>基站处理：针对S6 若SDK下发BR为空 则使用 1/2 ，不为空则使用11/12}  |
| 6 | SN | 6字节键盘序列号，用于指定键盘<br>对教育新体系，前2字节FFFF后4字节SN有效，全0表示所有键盘 |
| 4 | DOWNLEN | 4BYTE待升固件大小 |
| 2 | DOWNCRC | 2BYTE待升固件校验字(CRC-16) |
| 1 | SendPos | 发送序号 |
| 1 | HW | 硬件版本 -> (区分硬件，键盘自己识别) |
| 3 | SW | 固件版本 |
| <font color="#00dd00">1</font>| <font color="#00dd00">BR</font> |<font color="#00dd00">硬件分支 同硬件信号下匹配的不同分支</font>|
| 4 | 预留 ||
| 2 | CRC16 ||

### 6.5.3 透传数据

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4 | ATC | 配对码 |
| 4 | MATCHCODE | 核准匹配码 0xfe 48 de 7f |
| 1 | PACKMAX | 后续传输包数量 此处为32 |
| 1 | DOWNCMD | 0x01 透传数据传输 |
| 2 | CRC16 | 本包透传数据的CRC |
| 1 | DOWNPOS | 透传序号 不能为0 1-255基站自增（新的一轮升级） |
| 1 | DOWNCount | 当前包序号 0开始 |
| 1 | $\color {red} {HW} $ | $\color {red} {硬件版本 (区分硬件，键盘自己识别)} $ |
| <font color="#00dd00">1</font>| <font color="#00dd00">BR</font> |<font color="#00dd00">硬件分支 同硬件信号下匹配的不同分支</font>|
| 16 | 预留 ||
| 1024 | DownData | 透传数据 暂定 1K |

### 6.5.4 询问

2包32

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4 | ATC | 配对码 |
| 4 | MATCHCODE | 核准匹配码 0xfe 48 de 7f |
| 1 | PACKMAX | 后续传输包数量 此处为1 |
| 1 | DOWNCMD | 0x02 透传询问带回复SN |
| 2 | CRC16 | 计算 所有SN区域的CRC校验 |
| 1 | Pos | 询问序号从1开始累计 不等于0 |
| 1 | $\color {red} {HW} $ | $\color {red} {硬件版本 (区分硬件，键盘自己识别)} $ |
| 2 | NULL | 预留 |
| 48 | SN | 4字节键盘序列号，用于回复上一轮已收到的键盘SN号12个SN |

AES加密格式
第1包
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| ==2== | ==TIMECODE== | ==滚动码== |
| ==2== | ATC | 配对码 |
| 4 | MATCHCODE | 核准匹配码 0xfe 48 de 7f |
| 1 | PACKMAX | 后续传输包数量 此处为1 |
| 1 | DOWNCMD | 0x02 透传询问带回复SN |
| 2 | CRC16 | 计算 所有SN区域的CRC校验 |
| 1 | Pos | 询问序号从1开始累计 不等于0 |
| 1 | $\color {red} {HW} $ | $\color {red} {硬件版本 (区分硬件，键盘自己识别)} $ |
| 2 | NULL | 预留 |
| 16 | SN | 4字节键盘序列号，用于回复上一轮已收到的键盘SN号4个SN |
第2包
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| ==2== | ==TIMECODE== | ==滚动码== |
| 28 | SN | 4字节键盘序列号，用于回复上一轮已收到的键盘SN号==7==个SN |
| 2 | NULL | 无效数据 |

### 6.5.5 键盘回复

2包32

（已收齐键盘不响应回复）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4 | ATC | 配对码 |
| 4 | MATCHCODE | 核准匹配码 7f de 48 0xfe |
| 1 | PACKMAX | 后续传输包数量 此处为1 |
| 1 | DOWNCMD | 0x82 透传键盘询问回复 |
| 2 | CRC16 | LostBuf 的校验和 |
| 4 | SN | 4字节SN |
| 1 | $\color {red} {HW} $ | $\color {red} {硬件版本} $ |
| 15 | 预留 ||
| 32 | LostBuf | Bit 位判断收齐数组,单位1K 1表示没收到 0表示收到 最多256K |

AES加密格式
第1包
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| ==2== | ==TIMECODE== | ==滚动码== |
| ==2== | ATC | 配对码 |
| 4 | MATCHCODE | 核准匹配码 7f de 48 0xfe |
| 1 | PACKMAX | 后续传输包数量 此处为1 |
| 1 | DOWNCMD | 0x82 透传键盘询问回复 |
| 2 | CRC16 | LostBuf 的校验和 |
| 4 | SN | 4字节SN |
| 1 | $\color {red} {HW} $ | $\color {red} {硬件版本} $ |
| 15 | 预留 ||
第2包
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| ==2== | ==TIMECODE== | ==滚动码== |
| ==30== | LostBuf | Bit 位判断收齐数组,单位1K 1表示没收到 0表示收到 最多==240K== |

## 6.6 透传多包（题干）

&emsp;&emsp;用类似透传升级的方法，来实现多包数据对键盘的下载，例如带题干内容的题型数据的下载，往往可能4K字节，相比2.4节的广播信息信标1包只能16字节，透传数据包的传输效率差不多高一倍。

步骤如下：

~~1. 基站以1K字节为单位（透传数据包的单位），广播所有数据，执行N遍，也可以每1K广播N次，然后下1K字节；
2. 转投票信标环节，表示业务开始，例如测验，这样接收完整的键盘就可以开始答题了；
3. 没接收完整的键盘，或者后开机的键盘，就在投票信标环节发申请重播，包含哪些1K字节没收到的信息；
4. 基站自动重播键盘没收到的数据段M遍，然后继续第2步骤；~~

<font color="#ff0000">
整体流程与以前一致， 改动点如下：<br>
1、将基站发送RF数据给键盘 替换成透传发包<br>
2、SDK到基站协议 增加1Byte 高位地址位，用于传输大于4096大小的数据包</font>

### 6.6.1 透传数据格式

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4 | ATC | 配对码 |
| 4 | MATCHCODE | 核准匹配码 0xfe 48 de 7f |
| 1 | PACKMAX | 后续传输包数量 此处为8 |
| 1 | DOWNCMD | 0x05  透传数据传输 |
| 2 | CRC16 | LostBuf 的校验和 |
| 1 | DOWNPOS | 透传序号  不能为0   1-255基站自增（新的一轮升级） |
| 1 | DOWNCount | 当前包序号 0开始 |
| 1 | NULL | NULL |
| 1 | NULL | NULL |
| 1 | CountMax | 本轮次传输包最大序号 |
| 1 | SpaceTime | 0默认不休眠 (每帧 帧间距离)可用于键盘休眠 也可不休，原则上 SpaceTime= PACKMAX*1MS，基站填写 |
| 15 | 预留 | NULL ，实际物理包头32不含数据 为包头信息|
| N | DownData| 透传数据  暂定 256B |
----
### 6.6.2 数据内容格式

为传输过来的DownData 数据内容解析，DownData前16字节为数据包内容信息，后续Data为实际数据内容
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 数据包标识 |
| 2 | LEN | 数据内容[Data]长度 |
| 13 | NULL | 预留 |
| N | Data | 数据内容 |
----
#### 6.6.2.1 测验题题型数据
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 1 题型数据|
| 2 | LEN | 数据内容[Data]长度 |
| 13 | NULL | 预留 |
| N | Data | 数据内容，<font color="#ff0000">原2.4.4 816字节内容</font> |
----
#### 6.6.2.2 测验题答案数据
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 2 答案数据 |
| 2 | LEN | 数据内容[Data]长度 |
| 13 | NULL | 预留 |
| N | Data | 数据内容 <font color="#ff0000">原2.4.2 字节内容</font>|
----
#### 6.6.2.2 APP层透传数据至键盘端 （解析依赖APP与键盘定义）
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 3 透传数据 |
| 2 | LEN | 数据内容[Data] + 1 长度 保持前面16个字节偏移 |
| 13 | NULL | 预留 |
| 1 | Broadcast Number | 值等于datapos 透传数据编号 1-255 由软件确定是那一轮投票datapos的对应的广播 涵盖在Data内的第一字节|
| N | Data | 数据内容|
#### 6.6.2.3 数据表内容数据

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 10 数据表内容|
| 2 | LEN | 数据内容[PACK]长度 |
| 2 | Pack_NO | 数据表编号，高位在前 |
| 2 | TOTAL | 题目总数，高位在前 |
| 9 | NULL |  |
| N | PACK | 数据内容 |



<font color="#ff0000">以下是Data数据内容解析规则</font>
PACK 由最小单位包 一 一 组成
表6.6.2.3-1 最小单位包结构
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 指令码|
| 2 | LEN | Data 长度 |
| N | Data | 数据 |

##### 6.6.2.3.1 数据表内容数据
CMD 类型
| **CMD** | **含义** | **描述** |
| --- | --- | --- |
| 0x01 | 通用题型数据 | 适用于非指定的所有题号|
| 0x02 | 通用选项数据|  适用于非指定的所有题号|
| 0x03 | 通用规则数据|  适用于非指定的所有题号|
| 0x04 | 通用控制权限名单|  针对某个或某部分SN的键盘控制权限，如回避表等|
| 0x10 | 单题配置数据|  用于指定某题号的属性配置|

&emsp;&emsp;数据表采用的是所有属性数据全部是通用属性数据，没有自定义数据，哪怕仅用一次也是放在通用属性里面，SDK按属性集中发送，每条属性数据之间用\0结束，单题配置逐个指定每项属性序号，每道题的配置信息是定长的，所以当查询每道题是不用全局搜索，只要按题号偏移即可定位。

&emsp;&emsp;通用题型数据指的是题目UI显示部分，包括题干和可能有的选项内容，每条题型\0结束，单题配置指定本题对应的题型序号。

&emsp;&emsp;通用选项数据指的是键值对应具体选项，如按1键表示“满意”，按2键表示“不满意”，0x02表示的通用选项数据，通常会把整套答题可能用到的选项数据都列出来，如：1:1赞成/2反对；2:1赞成/2反对/3弃权；3:1同意/2反对/3弃权；4:1满意/2基本满意/3不满意；5:1满意/2基本满意/3不满意/4不了解；6:1满意/2基本满意/3一般/4不满意；7:1非常满意/2满意/3不了解/4不满意/5非常不满意；8:1非常同意/2同意/3不了解/4不确定/5非常不同意；9:1优秀/2称职/3不称职；10:1优秀/2称职/3基本称职/4不称职；总计10条选项，每条选项用\0结束，单题配置指定本题对应的选项序号。

&emsp;&emsp;通用规则数据指的是题目规则，如数字题输入数字范围，最大最小值等等具体规则，也是如通用选项数据一样列除所有通用规则，具体某一道题有需要的话可从中选择一条规则数据使用。每条选项用\0结束，单题配置指定本题对应的规则序号。

&emsp;&emsp;控制权限名单，暂时有允许和不允许等情况，后面跟具体的SN名单。每一条权限控制用\0结束，单题配置指定本题对应某条控制名单，也可以不指定，正常答题，如果有指定，键盘需要找到这条控制名单，查询是否有自己的SN在列，如果有则按照权限控制做出对应的动作。

&emsp;&emsp;指定单题配置数据指的是针对某一道单题配置前面通用的各项数据的序号，每道题的配置是定长的，查询可以直接偏移定位，不用全局搜索。


##### 6.6.2.3.2 通用题型数据
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x01,表示通用题型数据 |
| 2 | LEN| 后续数据的总字节长度 ，高位在前 |
| 2 | Len_1 | 本单元的字节长度，高位在前 |
| Len_1 | TitleData | 题目文本字符串数据 |
| ... | ... | ... |
| 2 | Len_n | 本单元的字节长度，高位在前 |
| Len_n | TitleData | 题目文本字符串数据 |

TitleData 格式：纯文本\n换行 （键盘根据\N换行显示与一行显示完全换行。换行时注意英文半字）每个标题用\0结尾。
这是一个例题\n
A:选项1\n
B:选项2\n
C:选项3\n
D:选项4\n
E:选项5\n

##### 6.6.2.3.3 通用选项数据
通用选项数据还是遵循表6.6.2.3-1结构，Data由若干个选项数据单元组成，具体见下表。
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x02,表示通用选项数据 |
| 2 | LEN| 后续数据的总字节长度 ，高位在前 |
| 2 | Len_1 | 本选项单元的字节长度，高位在前 |
| 1 | Number | 本单元选项数量 |
| Len_1-1 | Option | 本单元选项文本字符串，有Number条字符串，每条字符串以\0结尾 |
| ... | ... | ... |
| 2 | Len_n | 本选项单元的字节长度，高位在前 |
| 1 | Number | 本单元选项数量 |
| Len_n-1 | Option | 本单元选项文本字符串，有Number条字符串，每条字符串\0结尾 |

##### 6.6.2.3.4 通用规则数据
通用规则数据还是遵循表6.6.2.3-1结构，Data由若干个规则数据单元组成，具体见下表。
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x03,表示通用规则数据 |
| 2 | LEN | 后续数据的总字节长度 ，高位在前 |
| 2 | Len_1 | 自定义规则数据字节长度，如选用通用规则数据则为0 |
| Len_1 | Rule | 自定义规则数据 |
| ... | ... | ... |
| 2 | Len_n | 自定义规则数据字节长度，如选用通用规则数据则为0 |
| Len_n | Rule | 自定义规则数据 |


Rule：
采用CMD+LEN+DATA 格式  ，基础规则1
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x01,标准配置参数 |
| 1 | LEN | 长度1字节 |
| 1 | Mode | 输入模式,默认0；<br>0 字母选项模式，键盘发送的BCD码按字母解码；<br>1 数字选项模式，键盘发送的BCD码按数字解码；<br>2  纯数字模式 ，包含（上下键输入负号与点号），表示纯粹的数字数据；<br>3  填空自由组合的字符串模式，键盘自己实现输入方式；<br>4  多小题字母模式，用一个多选结果示多个单题答案，如结果[ABCD]表示第1题是A,第2题是B，第3题是C，第4题是D； <br> |
| 1 | ST1 | bit0 ： 修改模式， 0 不允许修改，1 允许修改，默认 1 <br>bit1 ： 保密模式，0 不保密，1 保密显示，默认 0 <br>bit2 ： 迫选，0 不迫选(允许缺选)，1 迫选(不允许缺选)，默认 0 <br>bit3 ： 重复，0不重复，1允许重复，默认 1 <br>bit4 ： 自动排序，0 保留输入顺序，1 选项自动排序，默认 1 <br>bit5 ： 自动提交，0 按提交键提交，1 延时自动提交，默认 0<br>bit6 ： 暂 0 <br>bit7 ： 暂 0  |
| 1 | ST2 | 备用控制位域，保留，作为通用配置，可能在不同模式有不同含义，暂0 |
| 2 | MAX | 批次最大可选人数，高位在前，默认 4 |
| 2 | MIN | 批次最小可选人数，高位在前，默认 1 |
| 1 | Maximum | 选项数据，最大可供选择项目数，最大值为10，默认 4 |
| 1 | Maxoptions | 选项数据，可选出数目，最小值是1，最大值不超出Maximum，默认 1|
| 4 | 数字上限 | 类型浮点，默认 100 |
| 4 | 数字下限 | 类型浮点，默认 0.1 |


扩展规则2
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x02,分段式数字选举配置参数 |
| 1 | LEN | 长度1字节 |
| 1 | Mode | 输入模式，默认 1<br>1，表示分段式数字选举模式|
| 1 | ST1 | bit0 ： 修改模式， 0 不允许修改，1 允许修改，默认 1 <br>bit1 ： 保密模式，0 不保密，1 保密显示，默认 0 <br>bit2 ： 迫选，0 不迫选(允许缺选)，1 迫选(不允许缺选)，默认 0 <br>bit3 ： 重复，0不重复，1允许重复，默认 1 <br>bit4 ： 自动排序，0 保留输入顺序，1 选项自动排序，默认 1 <br>bit5 ： 自动提交，0 按提交键提交，1 延时自动提交，默认 0 <br>bit6 ：暂 0 <br>bit7 ：暂 0  |
| 1 | ST2 | 备用控制位域，保留，作为通用配置，可能在不同模式有不同含义，暂0 |
| 2 | MAX | 批次最大可选人数，高位在前，默认 4 |
| 2 | MIN | 批次最小可选人数，高位在前，默认 1 |
| 1 | RETAIN_NUM | 保留数字个数，表示后续有多少个保留数字，一般每个保留数字对应某个特殊功能，（如777表示弃权，999表示后面全空不填），不能用作一般的数字选举序号，默认2，后面数据默认跟777，999 |
| 2 | RETAIN_1 | 保留数字1，高位在前 |
| ... | ... | ... |
| 2 | RETAIN_n | 保留数字n，高位在前 |
| 1 | RANGE_NUM | 数字范围个数，表示后续有多少个start_end数据对，高位在前，默认3 |
| 2 | RANGE1_START | 数字范围1 起始数字，高位在前，默认 1 |
| 2 | RANGE1_END | 数字范围1 结束数字，高位在前，默认 100 |
| 2 | RANGE2_START | 数字范围2 起始数字，高位在前，默认 200 |
| 2 | RANGE2_END | 数字范围2 结束数字，高位在前，默认 300 |
| 2 | RANGE3_START | 数字范围3 起始数字，高位在前，默认 400 |
| 2 | RANGE3_END | 数字范围3 结束数字，高位在前，默认 500 |
| ... | ... | ... |
| 2 | RANGEn_START | 数字范围n 起始数字，高位在前 |
| 2 | RANGEn_END | 数字范围n 起始数字，高位在前 |


##### 6.6.2.3.6 通用控制权限名单
控制权限名单还是遵循表6.6.2.3-1结构，Data由若干个控制权限名单数据单元组成，具体见下表。
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x04,表示通用控制权限数据 |
| 2 | LEN | 后续数据的总字节长度 ，高位在前 |
| 2 | Len_1 | 通用控制权限数据单元字节长度 |
| 1 | PERMISSION | 许可，1，允许；2，禁止 |
| Len_1-1 | LIST | SN 列表 |
| ... | ... | ... |
| 2 | Len_n | 通用控制权限数据单元字节长度 |
| 1 | PERMISSION | 许可，1，允许；2，禁止 |
| Len_n-1 | LIST | SN 列表 |

##### 6.6.2.3.5 单题配置数据
指定单题数据还是遵循表6.6.2.3-1结构，Data由若干个单题配置数据单元组成，具体见下表。
注意：如果某题题号未出现在列表中，则表示该题所有属性配置均用该属性默认的第1个配置。只要某一题的任意一个属性不是用的第1个默认配置，则该题需完整的列除所有属性对应序号。亦即要么没有，要么是完整的属性配置，确保列表出现的每题配置都是等长的。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 0x10,表示指定单题数据|
| 2 | LEN | 后续数据的总字节长度 ，高位在前|
| 2 | QNUM | 题目数量 |
| 1 | PROPNUM | 每题的配置数据包含属性个数，如 4 |
| 1 | 01 | 题型 |
| 1 | 02 | 选项 |
| 1 | 03 | 规则 |
| 1 | 04 | 控制权限名单 |
| 2 | Number | 本题题号 序号 |
| 1 | Title | 本题题型 序号 |
| 1 | Option | 本题选项 序号 |
| 1 | Rule | 本题规则 序号 |
| 1 | Permission | 本题控制权限名单 序号 |
| ... | ... | ... |
| 2 | Number | 本题题号 序号 |
| 1 | Title | 本题题型 序号 |
| 1 | Option | 本题选项 序号 |
| 1 | Rule | 本题规则 序号 |
| 1 | Permission | 本题控制权限名单 序号 |

#### 6.6.2.4 数据表增量表
只下载数据题号，这里做限制，键盘最多支持1K的缓存，大概400+题（大数据表内二轮筛选最大支持取400）
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMD | 11 数据表增量表内容|
| 2 | TitieNum | 数据内容[TitieNum]长度 |
| 2 | Pack_NO | 数据表编号，高位在前 |
| 2 | TitieNum | 2字节题目编号 |
| 2 | TitieNum | 2字节题目编号 |
----

## 6.7 透传多包后台升级

&emsp;&emsp;
==后台升级流程：==
1、基站上电自动找SDK获取 是否有预存的键盘固件==基站协议5.2.35 写基站后台升级状态==。获取相应信息。（附带强制升级与判断升级两种逻辑给于基站判断）
2、基站收取键盘数据时（投票包与状态包） 自动预览键盘数据内的版本信息位置。（根据SDK设置）发现有与预存键盘固件版本低的可以开启升级。或收到键盘提交的升级过程的数据包==键盘协议3.2.14 键盘后台静默升级状态包==，则可以开启进入后台升级流程
3、基站开启周期性发送升级数据包==键盘协议6.7.1后台升级数据格式==。（每次发送逻辑都是从序号小的开始增大循环）  键盘自己判断是否需要升级与接收升级包
4、键盘在接收升级包过程中固定时长或接收若干包则提交一包百分比接收包==键盘协议3.2.14 键盘后台静默升级状态包==，（该包同时反馈收到的数据缺失情况）
5、基站接收到键盘发送的数据缺失包，置位重发数据表示位，用于下一次发送的序号。


具体事项如下：
==SDK：==
1、导入可升级固件、可选强制升级与判断升级两类。
2、可制作后台升级软件 间隔时间询问键盘后台升级状态（9键盘测试类）

==基站：==
1、	查询基站是否有升级固件。
2、	进入发送条件：接收到键盘数据/状态包中版本号与当前版本不符合/SDK导入新的后台升级固件、单次触发（导入动作）/接收到键盘发送的后台升级反馈包中未满100%的键盘值。
3、	循环发送，单次发送到结束过程中的接收到的键盘反馈包，置位下一次发送的数据BIT标志（与原固件升级类似）

==键盘：==
1、	接收到后台升级包 判断是否需要升级。
2、	触发后台升级状态之后，间隔时长回复基站当前升级状况。

### 6.7.1 后台升级数据格式

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4 | ATC | 配对码 |
| 4 | MATCHCODE | 核准匹配码 0xfe 48 de 7f |
| 1 | PACKMAX | 后续传输包数量 此处为32 |
| 1 | DOWNCMD | 0x05 透传数据传输 <br> 0x01 统一升级数据包 <br>0x02 统一升级透传询问带回复SN <br>==0x03 后台升级1K数据包==|
| 2 | CRC16 | LostBuf 的校验和 |
| 1 | DOWNPOS | 透传序号  不能为0   1-255基站自增（新的一轮升级） |
| 1 | DOWNCount | 当前包序号 0开始 |
| 1 | CountMax | 本轮次传输包最大序号 |
| 1 | NULL | NULL |
| 1 | CountMax | 本轮次传输包最大序号 |
| 1 | SpaceTime | 0默认不休眠 (每帧 帧间距离)可用于键盘休眠 也可不休，原则上 SpaceTime= PACKMAX*1MS，基站填写 |
| 4 | DOWNLEN | 4BYTE待升固件大小 |
| 2 | DOWNCRC | 2BYTE待升固件校验字(CRC-16) |
| 1 | HW | 硬件版本 -> (区分硬件，键盘自己识别) |
| 3 | SW | 固件版本 |
| <font color="#00dd00">1</font>| <font color="#00dd00">BR</font> |<font color="#00dd00">硬件分支 同硬件信号下匹配的不同分支</font>|
| 2 | SUM | 后面1K数据的2字节累加和与CRC一起辨别|
| 1 | CRC | 头包的CRC从ATC开始到SUM结束的CRC校验信息取低位|
| N | DownData| 透传数据  暂定 1024B |
----


# 七、组网
组网逻辑： 基站在0频点广播信息，键盘监听0频点。（手动登录则需要保证监听时长，扫描多一些频点）
键盘在0频点听到连接信息之后，有密码，选择该基站时，则需输入密码正确才可跳转到正常频点入网。无密码则直接跳转到正常频点去组网。
在正常频点->监听到17投票信标（未入网成功则不处理投票信标数据）->竞争发送申请入网信息。等待基站ACK回复。协议如下：
==备注：~~将原17信标（ATTRIB3）位频点改为组网序号~~ 。暂取消改设定==

## 7.1基站连接信标（0频点广播）
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4 | ATC | 配对码 |
| 5 | GETCMD | 0x51  基站连接信息（基站配对码已经在前面）|
| 6 | NET_SEQ | 组网序号，改变范围1-255 每次根据对应方式改动值、需eeprom存储，掉电保存，基站自管理，用于键盘复连<br>==配对模式：== <br>更改配对码更新netpos <br>==基站白名单模式：==<br>1、基站更改白名单名单操作：清空、替换。更新NetPos<br>2、基站更改白名单名单操作：增加单个、删除单个、不修改netpos  照旧使用下发指令踢出键盘。  若键盘不在线，键盘再次开机的时候会复连基站，上报登录信息时/或答题信息，回复ACK拒绝。（ACK内CMD==204）|
| 7 | NETMODE | 基站组网模式，1配对 2白名单 |
| 8-11 | FREQ1-FREQ4 | 主频点，副频点2，副频点3，副频点4，0的话不启用 |
| 12 | HOP | 0没跳频，1-4表示当前模块跳频频点编号，1表示在主频点 |
| 13 | ST-Bit | 位控制（直接位域控制）<br>1：基站信息公开位<br>&emsp;0表示可公开，键盘能扫描到基站信息并显示<br>&emsp;1不公开，键盘不显示，但已配对的键盘可正常连接。<br>2：配对模式，1表示当前基站处于配对模式下可供键盘配对。0无<br>3：白名单模式，1表示当前基站处于白名单模式。0：无<br>4：Plus模式-><br>1：基站周期点名;<br>0：基站不发点名<br>5：名单锁定：键盘只在Plus模式下生效<br>&emsp;1：开启名单锁定（键盘自控无法配对，无法登录，基站名单只能有上层接口与刷卡接口添加）<br>&emsp;0：关闭名单锁定（键盘可配对，可登录，基站自动加入到名单中，基站不踢人）<br>6：键盘开启话费识别：1键盘开启话费识别 0:不开启 |
| 14-15 | PSW | 密码（0表示没密码） |
| 16-17 | 2 Byte| 基站配对码前两个字节(原因：B200配合M6 AES加密，协议占用了配对码前两个字节，但是键盘需要完整的4字节配对码，所有在此带下去给键盘) |
| 18-30| Name | 基站名称（6个汉字） |
| 31-32 | CRC|  |

## 7.2 键盘入网申请

<br>&emsp;入网确认信标指令格式（先兼容使用原登录信息添加一个字节表示）：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | GETCMD | 0x94  |
| 2 | TYPE | 11 （登录信息） |
| 3-6 | SN1-SN4 | SN1-SN4 |
| 7-8 | CID1-2 | 2字节CID |
| 9 | Mode | 一字节 |
| 10 | TYP | 硬件型号 |
| 11 | HW | 硬件版本 |
| 12-14 | SW1-3 | 软件版本，3字节 |
| 15-16 | PWD1-2| 硬件版本 |
| 17 | NetMode | <font color="#dd0000">1 表示入网申请</font> |
| 31-32 | CRC |  |

## 7.2 键盘入网申请

&emsp;&emsp;组网确认使用（0x18/0x19） 确认方式如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4-7 | SN1 | 第一个SN号，高位在前<br>全00为空  |
| 8 | SN1-CMD | 对第一个SN号键盘的确认状态<br>键盘据此命令做不同的提示或操作<br>01 数据提交正确（或自由登陆OK）<br>02 数据格式不对，数据提交无效（或自由登陆失败，密码不对）<br>03 不在投票状态，数据提交无效<br>04 没有投票权限，数据提交无效（包括不在白名单）<br><font color="#dd0000">10 失败  11 成功在主频点  12入网ok，但换频点2   13换频点3   14换频点4  19系统容量满  20没在白名单<br>51 - 151   组网成功分配的组呼编号</font><br>0xFn 表示有n个未阅读短信？  |

# 八、加密
## 8.1 加密层
### 8.1.1 加密方法
&emsp;&emsp;采用AES256加密，每32字节独立加密一次，适配无线硬件底层32字节收发。
32字节加密尽量前后相关，也就是有1个字节变化，密文内容都变化。待算法选定和验证，同时加解密时间要求小于500us。
### 8.1.2 密钥
&emsp;&emsp;平常收发双方都用LinkKey（32字节）加密，LinkKey错误，解密数据错误。
&emsp;&emsp;所以双方有个约定LinkKey（私钥）的过程，LinkKey也不可能明文传输，一般是通过PublicKey（公钥）进行加密。PublicKey是产品设计时候就约定好的，两边一样。
&emsp;&emsp;私钥的传输，根据我们的系统，设计为仅配对的时候交换。配对时间比较短，同时管理上要求安全环境，公钥被获取、私钥被获取的概率降低。同时正常投票时候，没有私钥的传输过程，降低破解概率。
&emsp;&emsp;对接收方，由于有两个Key，一种方案是先LinkKey解密后判断是否正确，不正确后用PublicKey解密，但必须都和通讯协议相关才能知道是否秘钥对。第2种方案是约定特殊状态，特殊状态下才用PublicKey解密，例如配对模式、离线后在广播频点等。我们采用第2种方式。
&emsp;&emsp;秘钥的生成方法，根据随机数、硬件序列号等相关生成，具体看最后代码。
&emsp;&emsp;秘钥包括公钥，在硬件上不能明文储存，避免破解。
### 8.1.3 配对设计
&emsp;&emsp;平常基站在广播频点，用公钥加密，广播原来的连接信息。键盘在广播频点接收，自动换公钥解密，所以所有基站的连接信息都能获取，所以键盘能按老体系跑起来。
&emsp;&emsp;基站进入配对后，在广播频点发连接信息，外还发送特殊的私钥传输信息。
&emsp;&emsp;键盘手动操作进入都配对状态后，在广播频点监听连接，获取ATC码和频点、私钥后，然后切换到主频点，提交配对信息并收到确认，配对成功。如果是有组网过程的，先入网，再提交配对信息。
### 8.1.4 免配对
&emsp;&emsp;工厂测试需要免配对，客户应用中快速更新秘钥，也需要免配对过程。
基站进入免配对状态后，LinkKey暂时采用PublicKey，同时广播频点的连接信息，标注自己是免配对的。ATC码也改成免配对ATC码。
&emsp;&emsp;键盘离线后，在广播频点用PublicKey监听，（可以加1秒收不到原先基站的连接信息后），听到基站连接信息并且是免配对的，也进入免配对模式，临时改用新的ATC码，LinkKey用PublicKey。
### 8.1.5 白名单
&emsp;&emsp;白名单键盘和基站，都在广播频点用PublicKey加密通讯。键盘提出申请后，如果有合适基站，基站发应答，应答里面要包含现在通讯的LinkKey、ATC码、频点。
## 8.2 传输层设计
### 8.2.1 防非法拷贝指令
&emsp;&emsp;如果黑客用设备，在空中拷贝了一条指令，虽然是加密的密文，但如果黑客重发这条指令，基站和键盘端用LinkKey解密后，指令是正确的，就会错误执行。
&emsp;&emsp;一般用指令中添加带时间特性的滚动码解决这个问题。接收到指令后，先判断滚动码是否合理，不合理，认为是非法指令。
&emsp;&emsp;我们采用简单的2字节滚动码方案，首先，要求键盘提交的信息，滚动码和基站的滚动码相同（或在一定的范围，根据实际调试数据决定），基站才认为键盘提交信息是ok的。同时，基站发送的滚动码，是按一定时间依次递增的，这样，超过一定时间的滚动码，键盘不认，解决黑客重发一条指令的问题。
&emsp;&emsp;这个滚动码暂时定义为TimeCode，暂时0-32767之间变化，高位1做备用。基站变化间隔暂定每次发包都递增1。
### 8.2.2 单包
&emsp;&emsp;添加TimeCode后，就占用了平常无线包32字节的空间，所以要考量原有协议体系，单包、多包怎么适配，包括多包上传、多包透传下载。
&emsp;&emsp;原有协议，是4字节ATC码，加28字节的协议指令，而且28字节基本都有用全，如果少2字节，改动比较麻烦。
&emsp;&emsp;解决方案是只用2字节的ATC码。因为加密体系，还有32字节的秘钥，这个秘钥就相当于ATC码了。
&emsp;&emsp;这样，原先的单包上传、单包下载类的指令，都不需要改动。也就是加密体系的单包格式是：
TimeCode（2B）+ATC（2B）+指令(28字节)=32字节。
相当于：
![timecode](img/AES_timecode.png)
### 8.2.3 多包
&emsp;&emsp;多包，就是超过30字节后怎么传输，主要适配原先的多包透传下载、S6的快速设置。
方案1：【暂采用方案1】
&emsp;&emsp;传输层对超过30字节的数据，自动分割成多个30字节片段，连续发送。例如，32字节，就分成2包发送，每包前面都是2字节的TimeCode。
但第1包里面有连续多包标志和信息，一般还带长度、CRC值，便于接收端判断是否接收完整和正确。
&emsp;&emsp;缺点，第1包后每包传输少了2字节。
&emsp;&emsp;优点，对接收端，每次都拼接30字节即可，里面具体格式可以变动，比较灵活。
方案2：
&emsp;&emsp;第1包是有特定格式的，携带后面包数，第1包后面都是32字节，不带TimeCode和ATC。
&emsp;&emsp;优点，某些情况下比方案1少传输1包，应用层不需了解多包是怎么实现的，例如对应用层而言，接收到的多包数据都是经过crc效验了的正确数据。
&emsp;&emsp;缺点，传输层编码和解码复杂一点，还有一些约定的限制，例如一次不超过1024字节，应用层发送需要指定包号。同时协议确定了就不能改了，扩充性不如方案1。
## 8.3 具体协议指令的变动
### 8.3.1 单包
![singlepack](img/AES_singlepack.png)
### 8.3.2 透传多包
![multiplepack](img/AES_multiplepack.png)
### 8.3.3 快速设置
&emsp;&emsp;接收程序，判断新的一包HEAD里面的CMD是0x37的时候，也做后继多包拼接。
### 8.3.4 LinkKey信息包
CMD=0x52，基站端2个包连续发送。
第1包
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1-2 | Time | TimeCode   |
| 3-4 | ATC | 配对码，2Byte  |
| 5 | CMD | 0x52  基站连接信息（基站配对码已经在前面）|
| 6 | AESMODE | 加密模式，暂1|
| 7-8 | KEYCRC | 32字节LinkKey的CRC16值|
| 9 | PACKNO | 0,第1包 |
| 10-25 | LINKKEY | 前16字节的LinkKey值|
第2包
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1-2 | Time | TimeCode   |
| 3-4 | ATC | 配对码，2Byte  |
| 5 | CMD | 0x52  基站连接信息（基站配对码已经在前面）|
| 6 | AESMODE | 加密模式，暂1|
| 7-8 | KEYCRC | 32字节LinkKey的CRC16值|
| 9 | PACKNO | 1,第2包 |
| 10-25 | LINKKEY | 后16字节的LinkKey值|
### 8.3.5 基站连接信息
单包格式，信息如下：
指令格式：
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1-2 | Time | TimeCode   |
| 3-4 | ATC | 配对码2Byte   |
| 5 | CMD | 0x51  基站连接信息（基站配对码已经在前面）  |
| 6 | NET_SEQ | 组网序号，如果变化，键盘重新入网  |
| 7 | NETMODE | 基站组网模式，1配对 2白名单 3免配对（加）  |
| 8-11 | FREQ1-FREQ4 | 主频点，副频点2，副频点3，副频点4，<br>0的话不启用   |
| 12 | HOP | 0没跳频，1-4表示当前模块跳频频点编号，1表示在主频点   |
| 13 | ST-bit | 位控制（直接位域控制）<br>1：基站信息公开位<br>&emsp;0表示可公开，键盘能扫描到基站信息并显示<br>&emsp;1不公开，键盘不显示，但已配对的键盘可正常连接。<br>2：配对模式中，1表示当前基站处于配对模式下可供键盘配对。0无<br>3：白名单模式，1表示当前基站处于白名单模式。0：无<br>4：Plus模式->1： 基站周期组呼点名心跳/键盘上线时发送入网包 暂不使用<br>&emsp;0：基站不发点名心跳/键盘上线时不发送入网包（键盘竞争方式）<br>5：名单锁定：键盘只在Plus模式下生效<br>&emsp;1：开启名单锁定（键盘自控无法配对，无法登录，基站名单只能有上层接口与刷卡接口添加）<br>&emsp;0：关闭名单锁定（键盘可配对，可登录，基站自动加入到名单中，基站不踢人）   |
| 14-15 | psw | 密码（0表示没密码）   |
| 16-17 | 2 Byte | 预留   |
| 18-30 | Name 12字节 | 基站名称（6个汉字）   |
| 31-32 | CRC |    |
# 九、版本历史
multiple
V0.5新体系基本框架。

V0.6增加发信息信标（基站控制的广播信息，用于快速传递信息，2.4节），但综合考虑，多题答案下载，还是先用老体系的多包下载流程，由SDK完成，见6.4.2节。

V0.7 1. 对码模式快速配对可带密码（2.2.11节） 2. 考勤由基站控制开关（2.2.1节） 3 考勤频率和功率由基站控制 ~~4. 键盘后期需增加液晶老化测试，基站需支持该命令~~ 4、基站控制键盘不关机

V0.8增加3.2.9节键盘主动发信模式，同时2.3节确认信标，补充了S61考勤开关、心跳开关；3.2.8节考勤定位数据包减少到6字节；

V0.85 增加白名单模式支持，基站带监听信道的，3.2.4键盘登录加了白名单模式3，对应应答处理增加了2.3.2节确认包带信息；3.2.5节状态报告增加键盘编号ID用于测试

V0.9版本对应S6plus体系修改： 3.2节序列号结果，增加0x94模式，同时传SN和ID号；点赞举手原来3.2.6节支持，增加一种键码发送方式；2.2.12抢答模式增加键值抢答；2.2.13测验中的多题模式5，由于S6Plus多选是去重的，所以增加排序模式4；3.2.4节登录信息增加CH-UID模式；对应CH-UID模式，增加5.2.4节表决器授权指令（和政务SN地址有点不同）；增加5.2.6节读写姓名，12字符；测验100题纯多选答案，增加6.4.3节和2.4.3节；键盘无线升级，修改6.4节多包下载类型，增加6.4.4节固件升级流程说明和格式定义；2.3.2节白名单基站确认包信息修改成可支持多个键盘确认；

V0.91 3.2.3节增加能龙多题数据说明；

V0.92 5.2.1节增加固定配对模式和白名单模式切换指令（优化信标控制后可以不用）；2.2.1节投票信标里面Mode值修改成可区分白名单基站和普通配对基站；5.2.4节键盘授权指令增加白名单键盘重新登录控制（用于白名单基站换名单后，前面在线键盘需要重新登录）；

测验多题里面，增加32题目题型控制，有主观题不可作答，但多选选项数目固定

【V0.95增加wifi语音答题器相关功能】

1、投票模式增加2.2.15语音答题、2.2.16分组PK模式

2、键盘管理类增加5.2.11-16节—wifi服务器信息、遥控绑定和解绑、分组设置、外设控制、文字自定义显示、获取调试信息，完善5.1节里面的模式列表

3、概述补充完善数据打包格式，增加用于传递语音数据的大包格式；

4、3.2.10增加语音录音数据类型；3.2.3节增加分组PK答案的说明；

5、3.2.5节状态报告信息，增加学号信息，仅用于wifi体系

6、2.2.7节在线测试增加wifi底层数据收发测试模式

【V0.96】

1. 抢答模式修正，原先模式1是带按键值抢答，应该是3，否则和抢红包等冲突
2. 2.1节投票信标增加控制关机时间4档，同时2.3.1节确认信标也增加

【V0.97】

1、3.2节序列号结果类，加上CRC16效验值，但暂不支持字符串结果类型

### 【V0.99】-【V1.0】

迈向V1.0的pre版本，根据K1键盘设计新的特性，新加蛮多

1. 基站下发指令加上效验，避免空中数据出错，2.2节投票信标加效验；下载单包、上传单包、下载多包统统加上效验，但可以K1开始支持；
2. 支持新基站广播信息包，以完成题型下载、答案下载等大数据下发，但必须同样数据

细化2.4节，细化2.4.1节题型控制，2.4.2节答案下发，删除2.4.3节bit位答案；3.2.6节增加键盘申请基站重新广播数据

1. 第2.2.13节测验题支持模式9快速小测、模式10题号分段、模式11自动测试模式；
2. 第2.2.12抢答模式增加字母数字显示、游戏模式，可自定义名称，指定按键，去重规则；
3. 第2.2.2空闲模式增加即时反馈细节、状态监控细节；
4. 第2.2.6节数字评分支持上下限和格式化，K1支持；
5. 第2.2.10节填空增加字母填空、数字填空、自动测试；
6. 5.2.8节显示增加闪烁显示用于找投票器；5.2.6节增加写金币数，可设置总的和这次增减的；
7. 第2.2.5节判断题增加显示模式√/×；增加5.2.7节用于即时反馈的按键等级自定义；
8. 增加3.2.11节，带电量数据格式，而且数字题支持16位数字；
9. 单选多选、判断、数字、排序、填空增加大小题号信息；
10. 3.2.5节状态报告单独分出SN+ID+姓名，用于生产排查；
11. 3.2.3节完善字符串提交带效验，设计新类型格式；
12. 无线升级键盘报告升级成功？--使用状态报告即可，键盘主流程做
13. 2.12节抢答增加自动测试，满足速度测试要求
14. 99_3 2.2.12节抢答抢红包，应青果要求增加是否允许修改
15. 2.15节录音增加自动测试模式
16. 2.7节增加锐捷键盘蓝牙芯片MAC地址读写
17. 99_4 3.2.3节字符串结果支持课后练习单题提交结果；2.2.14节收作业支持课后练习单题提交自动测试；
18. 2.14节收作业支持多科目带日期以及自动测试，3.2.7节申请多包提交支持多个家庭作业
19. 2.15节语音题增加语音红包模式
20. 99_5 2.2.12节抢答模式增加青果OK键抢红包的说明，和3.2.11节多题结果增加OK按键确认提交不再修改的特殊说明；多选模式补充多2个测试模式和极域模式（老S62极域版本支持？）
21. 99_5 5.2.6节增加清除姓名，语音增加16Kspeex
22. 99_6 2.2.13测验增加小测模式12，支持64题目题型
23. 99_6 2.2.8单选多选增加网龙模式，显示定项或不定项

【V0.99_7】

高思语音答题器增加很多功能特性，需要扩展投票信标，用2.2.17节实现

1、所有题型都需要支持设置6个汉字—2.2.17节

2、抢答功能需要支持判断题—2.2.12节增加

3、多题功能需要支持30道题，可以设置题目类型单选、多选、判断、语音答题所有题型

4、需要支持震动设置，开机震动，刷卡震动，启动答题震动

5、需要支持蜂鸣设置，开机蜂鸣，刷卡蜂鸣，启动答题蜂鸣

6、需要支持LED设置，可设置指示灯开启/关闭

7、需要支持心跳包设置，此处是否可以用定时报告状态处理？如果OK，则不需要修改协议—按状态报告做

8、需要支持写批次号，此处是不是用极域的OEM信息处理？如果是，则不需要修改协议—按OEM做

9、2.2.1节投票信标增加锐捷的请教申请控制位

【V0.99_8】完善基站广播信息包协议

1、2.4节广播命令码改0x31、0x32，原0x41、0x42（AES加密用了0x40类）

2、2.2.13-2节广播信息类型确定答案下发支持键盘得分，但答案和得分是分别下载，这样，答案可以提前先下载到基站

3、2.4.2节答案下发格式修改成答案用字符串

4、增加2.2.13-3键盘得分表格式

5、完成5.2.15文字自定义显示指令，可用于抢红包结果显示，后面修改成4字节SN，以支持高思要求8汉字

【V0.99_9】针对A1键盘功能，手写协议等

1、增加2.2.18节手写投票模式

2、2.2.1节完善文档，把2.2.17节扩展信标信息附上说明，控制震动、背光等

3、200题型格式修改，2.4.1节，测验名称支持到16中文，题型加语音、手写----但测验里面的手写、语音怎么传输？还是可以动态传输，只是数据带题号

4、在5.2.14节指定键盘外设动作，增加麦克风和手写

5、单选多选等增加题号显示模式

6、2.4.1节200题型，增加A1用的版本

【V0.99_10】

1、2.2.17节扩展信标，增加了新东方的自定义题型名称

2、增加 2.4.4节的乐教乐学多题题型格式

3、新东方泡泡，2.2.12节抢答游戏模式，对游戏按键做详细说明，以满足快速按键测试

4、游戏按键模式增加自动测试

5、泡泡，心跳用状态报告，加开关机状态，3.2.5节

6、泡泡，一键唤醒，补充到空闲模式2.2.2节，原先高思实现过

7、5.2.3节遥控关机，增加支持是否进入遥控开机模式

【V0.99_11】

1、5.2.16节乐教乐学，给替换键盘回写已答题内容

2、3.2.6节完善键盘申请基站重新广播信息信标（题目内容），可指定全部或部分

【V0.99_12】

1、增加指定题号取数据，临时解决漏题问题；

【V0.99_13】

1、增加5.3节手机参数设置类

【V0.99_14】

1、2.2.17扩展信标增加指定答题器答题，并修改信标发送方式在0x17前而不是交替

2、支持图片拍照

【V0.99_15】

1、2.3.1节确认包，支持带CRC，可解决200题测验丢题并保持老协议键盘兼容

2、图片拍照支持自动多次测试

3、图片拍照加压缩等级，用于判断原图好不好

【V0.99_16】

1、指定键盘答题，有键盘可能先收到0x17投票启动指令，会出现投票界面闪一下，由于也有同时用到多种扩展信标的情况，所以0x17用剩余的1bit告诉键盘要收多条扩展信标，2.2.17的扩展信标原NULL字节改成bit位告诉键盘这次有哪些内容（多条）要完整接收；

2、5.2.6节读写个人信息加清除金币小模式

3、5.2.6节读写姓名增加8汉字模式，原只能6汉字

4、针对扫描模式带姓名，原3.2.3节由于crc位置只能传10字节5汉字的问题，做了解决方案的调整，3.2.5节可传16字符，但基站CRC要做兼容调整

5、空闲模式补充了高思停止模式下，第7字节是刚才投票模式参数

【V0.99_17】

1、判断题增加错题本小模式，2.2.5节

2、投票信标增加积分显示屏蔽控制位，2.2.1节

【V0.99_18】

1、2.2.2节空闲模式-增加停止显示自定义信息

2、2.2.17-1节自定义题型名称增加频点信息

3、修改投票信标里面积分显示控制描述，因为T1lite实际做反了

【V0.99_19】

多选增加科大讯飞10小题模式

BCD码增加空格、负号的定义

【V0.99_20】

1、确定5.2.15节文本自定义显示，用于T2答题后回显自定义文字信息

2、增加和补充2.2.19 T2扩展信标，可自定义答题开始和提交ok后提示语

3、5.2.6写个人信息增加单题得分显示

4、2.4.4节200题格式增加题号显示模式，第9字节

【V0.99_21】

1、多选修改迫选模式，增加可重复选项，等同于排序题

2、签到模式增加可指定按键

3、多选模式增加10小题判断题模式

4、增加键盘固件升级成功和失败结果类型，3.2.12节

【V0.99_22】

1、设计用于T2Soc的统一的单包设置指令，5.4节

【V0.99_23】

1、修改5.4.1 自定义文本显示

2、修改5.4.3 外设控制加马达

3、增加5.4.8 键盘CID设置

4、增加5.2.19写键盘OEM型号名称

【V0.99_24】

增加4.6节键盘多包上传透传模式（李傲寒设计）

【V0.99-25】

1、语音模式，多1字节，控制是否录音完毕要提交OK确认

2、空闲模式，增加控制中英文切换

3、5.2.7节增加出厂日期信息

【V0.99-26】

1、修改5.4.1节自定义文本显示

2、增加5.4.9 长姓名下载

3、2.2.12节抢答增加指定按键

4、修改4.6节透传多包上传，和基站配合

5、录音增加语音质量测试模式

【V0.99-28】

1、2.4.4节多题型格式，增加带上限的全数字题模式，用于给老师打分

2、2.2.6数字模式加上下限

3、2.2.2节空闲模式，中英文设置修改

【V0.99-29】题干

1. 增加6.6节透传多包流程说明
2. 增加2.2.13-3节带题干内容的测验模式
3. 2.13-3节同时增加离线下载模式，确保离线下载每个键盘成功；和接收离线答题结果模式
4. 键盘请求3.2.6节增加透传多包申请重播和全部下载ok报告
5. 增加2.4.5节带题干内容的测验题型结构

【V0.99-30】

1. 增加5.4.10 T2语音答题器的生僻字下载

【V0.99-31】

1. 增加5.5 章节S6体系快速设置，包含指定标题、部分预置设置,并添加12号生僻字字库数据下载。
2. 修改2.2.8 选择投票模式信标 怎么MODE1=30的可设置键盘上次答案的投票测试方式
3. 将2.2.13-2小节内答案下发指令修改成30
4. 5.4章节添加数据包内最后一个字节（第58字节）解释：为COUNT传输序号位。（已实现并使用，补充文档）
5. 2.2.1添加投票信标第24位 低四位表示休眠周期位。当前信标处于WCT中的第几个周期
6. 增加2.5章节 投票数据的附加信息发送方式
7. 补充快速下发爱心与测验题分数
8. 5.5.2.16 测验题补题逻辑
9. ATTRIB1修改BIT6位改成登录允许位置
10. 新增5.5.2.17 键盘恢复出厂设置

【V0.99-32】

1、3.2.5 3.2.11 添加第21位发送次数，键盘自身统计，SDK显示。

2.修改3.2.5 SendPos到第17字节


