[TOC]
# 一、概述

&emsp;&emsp;本通讯协议，是在老通讯协议《通讯协议-政务商务-基站部分-V5.0.docx版本》上进行修改，大部分都是相同，本文仅就修改部分做说明。
&emsp;&emsp;设置基础信标部分，做了修改，适应新教育体系特性，指令改7和8。
&emsp;&emsp;设置投票信标没有变动，只是键盘协议多了一些模式，个别参数定义有变动。
&emsp;&emsp;获取基站数据的流程没有变动，只是数据包格式增加新的格式定义，SDK对新格式进行解析即可。增加的是格式，一种类似原来的16字节一包的数据，另外一种是对SN号模式字符串数据的支持。
&emsp;&emsp;基站设置没有变动，但有些特性，进行了增减。

***
![基站&SDK通信格式](img/基站&SDK通信格式.png)
==加解密方式==
==1、	建立连接阶段==
0X61 CMD=0x38 写私钥给基站。
这期间使用PublicKey（公钥）进行加密
在这个阶段传输  私钥
秘钥的生成方法，由SDK生成可以根据随机数、硬件序列号等相关生成，具体可以参看键盘&基站AES加密方式
秘钥包括公钥，在硬件上不能明文储存，避免破解。
写完私钥之后 进入正常工作阶段 

==2、工作阶段==  一直使用LinkKey（私钥）进行交互 直到断连

加密使用AES_ctr 不定长加密



# 二、设置投票模式

&emsp;&emsp;设置基础信标部分，做了修改，适应新教育体系特性，指令改7和8。
&emsp;&emsp;设置投票信标没有变动，只是键盘协议多了一些模式，个别参数定义有变动。

## 2.1 设置新基础信标

&emsp;&emsp;设置信标信息主要是修改基站平常广播的基础信标内容。信标的具体信息的含义，请参考表决器协议部分。操作方法类似原设置基础信标。

电脑发给基站：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站类指令 |
| 2 | BASEID | 指定的基站编号 |
| 3 | CMDTYPE | 基站命令类型<br>7 读取新教育体系基础信标，后继的参数无意义<br>8 设置新教育体系基础信标 |
| 4 | ATTRIB1 | 基站特性1（对应键盘协议投票信标第25字节）<br>具体以键盘协议为准<br> BIT0 （基站是配对还是自由标识）在此不可设置 <br>BIT1=0 键盘不用定时监听投票信标，1启用定时监听<br>BIT2=1 键盘不关机 |
| 5 | ATTRIB2 ||
| 6 | ~~ATTRIB3~~ | 实际用在频点了，不能控制 |
| 7 | ~~ATTRIB4~~ | 不能控制 |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 7 当前新扩展信标内容 |
| 4 | ATTRIB1 ||
| 5 | ATTRIB2 ||
| 6 | ATTRIB3 ||
| 7 | ATTRIB4 ||
| 8-29 || 参数无意义 |

## 2.2 设置投票模式信标

设置投票模式，就控制了基站的投票模式，包括投票类型和参数、投票的启动和停止。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站类指令 |
| 2 | BASEID | 指定的基站编号 |
| 3 | CMDTYPE | 基站命令类型<br> 3 读取当前投票模式，后继的参数无意义<br>4 设置当前投票模式 |
| 4 | DATAPOS | 表决序号（结果记录序号） |
| 5 | MODE | 投票模式 |
| 6-29 | MODES | 投票参数，具体和MODE有关，不同模式下参数意义不同 |

从第4字节起，参数的含义和表决器投票模式信标中的参数含义是一模一样的，决定了表决器的投票状态，具体参数的含义和格式，参见《表决系统通讯协议-政务商务-表决器部分 V4.1》中的2.2节中的多种投票模式参数。

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 3 当前投票模式 |
| 4 | DATAPOS | 当前表决序号 |
| 5 | MODE | 当前投票模式 |
| 6-29 | MODES | 当前投票参数，具体和MODE有关，不同模式下参数意义不同 |

## 2.3 设置发信息信标

对应教育键盘新版协议2.4节，先设置要发送的内容，然后启动基站发送，或者由基站自主判断启动发送。

如果是指定键盘发送，基站执行一段时间后，返回执行结果。

### 2.3.1 设置发送参数

用于设置广播时候的时长，以及占用间隔。
时长主要根据广播包的长度，保证键盘都能可靠接收到。基站内部初始化也设置一个缺省参数，用户程序也可以不设置。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站类指令 |
| 2 | BASEID | 指定的基站编号 |
| 3 | CMDTYPE | 基站命令类型<br>11设置发送参数 |
| 4 | TYPE | 参数类型（基站暂记录5种或10种） <br>1 题型答案广播参数<br>2 答案广播参数 |
| 5 | TIMES | 持续发送时间，单位0.5秒 |
| 6 | SLOTS | 广播时间片占用10个周期里面的多少周期 |
| 7-29 |||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 11设置发送参数 |
| 4 | OK | 1 表示收到 |
||||

### 2.3.2 设置发送内容

&emsp;&emsp;SDK根据实际数据包的大小，例如键盘协议的2.4.2节的答案下发，来设置SLOTMAX值，和填写SLOTN和对应的16字节数据片段DATA的内容，并通过基站的确认包确认，把完整的要基站广播的信息先完整传给基站。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站类指令 |
| 2 | BASEID | 指定的基站编号 |
| 3 | CMDTYPE | 基站命令类型12 设置或读取发送内容 |
| 4 | DCMD | 数据包类型—键盘根据类型选择保存位置和处理方式<br> 1 多题题型数据<br> 2多题答案数据<br>0x81 读取多题题型数据（Bit7=1是读取，用于SDK异常退出再进时候，不知道题型，没法准确解析键盘数据），SLOTN参数有效，SLOTMAX无效<br>。。。 |
| 5 | SLOTMAX | 下发数据包共多少包数据，1起，每包16字节<br>（最大255,255x16=4080字节） |
| 6 | SLOTN | 第多少包数据，0开始 |
| 7-22 | DATA | 这个包的16字节数据 |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 12设置发送内容 |
| 4 | OK | 1 |
| 5 | SLOTMAX | （如果DCMD是读取，SLOTMAX开始数据有效）<br>回传数据包共多少包数据，1起，这样SDK知道共多少包，可依次读回 |
| 6 | SLOTN | 第多少包数据 |
| 7-22 | DATA | 这个包的16字节数据 |

### 2.3.3 启动发送和结果

控制基站启动广播发送。目前教育体系不需要这个指令，下载题型、广播答案都是基站根据测验题模式控制的。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站类指令 |
| 2 | BASEID | 指定的基站编号 |
| 3 | CMDTYPE | 基站命令类型<br>13 启动发送 |
| 4 | ID | 是广播还是指定ID或者SN<br>0 广播 1ID 2SN |
| 5-10 | ID-SN | ID模式是前2字节SN模式是6字节，教育模式下前2字节FFFF |
| 11 | DCMD | 启动哪一种数据包广播<br> 1 多题题型数据 <br>2多题答案数据<br>。。。 |
| 12-29 |||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 13 启动发送 |
| 4 | OK | 1 表示收到 |
||||

## 2.4 设置扩展投票信标

对应键盘协议的2.2.17节扩展投票信标内容。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站类指令 |
| 2 | BASEID | 指定的基站编号 |
| 3 | CMDTYPE | 基站命令类型<br> 14读取当前扩展信标信息，后继的参数无意义<br>15设置当前扩展投票信标信息 |
| 4 | INFOTYPE | 对应键盘协议的INFOTYPE<br>基站可以根据值做特定处理 |
| 5-29 || 内容和键盘协议一样暂按基站原指令，指令数据只到29，从4起最多26字节 |
||||

从第4字节起，参数的含义和表决器投票模式信标中的参数含义是一模一样的。

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 14当前投票模式 |
| 4 | INFOTYPE | 第4字节起和设置指令一样内容 |
||||

## 2.5 ~~设置空闲信标参数~~

~~对应键盘协议的停止投票、空闲时候信标 REPMODE开始的参数设置。~~
~~主要为了S6的空闲模式按键实时反馈。~~

| ~~**字节**~~ | ~~**标识符**~~ | ~~**描述**~~ |
| --- | --- | --- |
| ~~1~~ | ~~BASECMD~~ | ~~0x60 基站类指令~~ |
| ~~2~~ | ~~BASEID~~ | ~~指定的基站编号~~ |
| ~~3~~ | ~~CMDTYPE~~ | ~~基站命令类型<br>16读取当前空闲信标信息，后继的参数无意义<br>17设置当前空闲投票信标信息~~ |
| ~~4~~ | ~~REPMODE~~ | ~~对应键盘协议的REPMODE<br>基站可以根据值做特定处理~~ |
| ~~5-24~~ || ~~内容和键盘协议一样~~ |
||||

~~从第4字节起，参数的含义和表决器空闲模式信标中的参数含义是一模一样的。支持本协议的新基站，用保存的参数替换SDK下发的停止投票后面的参数。Sdk还是带参数，以支持旧版本基站。~~

~~基站应答：~~

| ~~**字节**~~ | ~~**标识符**~~ | ~~**描述**~~ |
| --- | --- | --- |
| ~~1~~ | ~~BASECMD~~ | ~~0xE0 基站类指令应答~~ |
| ~~2~~ | ~~BASEID~~ | ~~应答的基站的编号~~ |
| ~~3~~ | ~~CMDTYPE~~ | ~~应答类型<br>16当前投票模式~~ |
| ~~4-24~~ | ~~REPMODE~~ | ~~当前的REPMODE值和其他值~~ |
||||


## 2.6  基础扩展信标
20230817 M6键盘需要后台签到功能，此功能是基于政企协议基础信标实现的，现有新协议下已经没有基础信标了，故增加如下协议

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站类指令 |
| 2 | BASEID | 指定的基站编号 |
| 3 | CMDTYPE | 基站命令类型 <br>18 读基础扩展信标参数 <br>19 写参数  |
| 4-5 | AUTHCODE | 授权号，2字节，高位在前 0-0xFFFF <br>=0时候不使用授权模式，表决器可以参与表决<br>>0时候，表决器保存的授权号相同才能参与表决 |
| 6| LOGIN| 登录申请模式(后台签到模式)具体含义同表决器协议 |
| 7 |default||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 18 反馈参数 |
| 4-5 | AUTHCODE | 授权号，2字节，高位在前 0-0xFFFF <br>=0时候不使用授权模式，表决器可以参与表决<br>>0时候，表决器保存的授权号相同才能参与表决 |
| 6| LOGIN| 登录申请模式(后台签到模式)具体含义同表决器协议 |
||||

## 2.7 设置新增表决器特性
SDK向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x60 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 20 读取参数 <br>21写参数 |
| 4 | ATTRIB |表决器特性参数|
| 5 | default | |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 20 反馈参数 |
| 4 | ATTRIB |表决器特性参数|
| 5 | default | |





# 三、获取表决器投票数据

## 3.1 概述

SDK从基站获取投票器数据的方式和原来一样。SDK仅需要对新增加的SN号结果解析即可（格式有变动，多了字符串、考勤信息）

## 3.2 新增结果类型

参见下节数据描述，MSGTYPE值不同代表不同数据类型。

| **MSGTYPE 值**|**数据类型** |
| --- | --- |
| 21 | 硬件序列号16字节结果，每个单独键盘结果16字节信息 |
| 22 | 硬件序列号字符串结果，每个键盘结果27字节信息 |
| 23 | 老考勤信号，取消 |
| 24 | 2.4G远程考勤数据带电压 |
| 25 | 类似21，键盘结果是同时包含键盘编号ID |
| 26 | 类似22，键盘结果是同时包含键盘编号ID |
| 27 | 8字节BCD格式投票结果带电量，SN+ID，含测验 |
| 28 | SN\_ID，带电量，字符串结果 |
| 29 | SN\_ID模式下的，长结果（25字节，键盘最多1次） |
| 30 | T2语音体系的结果包 |
|||

### 3.2.1 硬件序列号-16字节结果

&emsp;&emsp;个基站数据包可1次传递多个表决器的结果，每个结果用1字节值类型、4字节SN号（比原来少2字节）、新加2字节、2字节时间和7字节的值来传递，1结果16字节。

注意：传递SN号结果的数据包，为提高效率，长度已经不是使用键盘编号结果的29字节，而是USB模式下最多58字节（受限于HID的最多64字节一包，减去3字节同步码，1字节长度，2字节CRC），TCPIP模式下用128字节包有122，实际有效数据还要减去5。

整个结果数据包结构如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 5 基站结果上传 |
| 4 | MSGNO | 数据包序号 |
| 5 | MSGTYPE | 基站数据包类型<br> 21硬件序列号结果-新16字节结果（每组数据16字节，共3组）<br>25 类似类型21,11、12字节是键盘编号ADDH和ADDL |
| 6 | ANSTYPE | 第1个结果的数据包类型<br>如果类型为0xFF，表示后面就没有数据了<br>SDK根据ANSTYPE来对后面15字节数据进行解码，具体参考《通讯协议-教育新版-键盘部分》协议<br>具体是除了字符串，其他凡是可以16字节传输的都用这个格式传递，投票结果、状态报告、登录信息、键盘请求 |
| 7-10 | KEYSN | 第1个结果的表决器硬件序列号，4字节，高位在前 |
| 11 | DATAPOS/ADDH | 结果对应的投票序号或者ADDH |
| 12 | SENDPOS/ADDL | 键盘内部的提交数据序号或者ADDL |
| 13-14 | KEYTIME | 第1个结果的按键时间， 2字节，高位在前<br>一般是离投票开始的时间，单位是20ms，最大约21分钟 |
| 15-21 | VALUE | 第1个结果的7字节值，一般用BCD码表示，高位在前，F表示空字符，最多14位数 |
| 22-37 || 第2个表决器的结果的16字节<br>首字节是ANSTYPE，如果类型为0xFF，表示后面就没有数据了 |
| 38-53 || 第3个表决器的结果的16字节 |
| 54--58 || 如果数据包够长，后面依次有多个结果<br>USB接口形式就没有数据了 |
||||

注意：这些结果值的格式，从ANSTYPE起每组16字节，就是直接拷贝键盘传递过来的数据，具体的数据含义，参考键盘通讯协议3.6节序列号结果类。

### 3.2.2 硬件序列号-字符串结果

&emsp;&emsp;传递序列号模式下的字符串结果和测验结果（单题提交），每组数据不是16字节，而是27字节，usb模式下一次只能传1个键盘字符串结果。

整个结果数据包结构如下：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 5 基站结果上传 |
| 4 | MSGNO | 数据包序号 |
| 5 | MSGTYPE | 基站数据包类型 <br>  22硬件序列号结果-字符串结果（每组27字节）<br>26 类似类型22,11、12字节是键盘编号ADDH和ADDL |
| 6 | ANSTYPE | 第1个结果的数据包类型<br>如果类型为0xFF，表示后面就没有数据了 |
| 7-10 | KEYSN | 第1个结果的表决器硬件序列号，4字节，高位在前 |
| 11 | DATAPOS/ADDH | 结果对应的投票序号或者ADDH |
| 12 | SENDPOS/ADDL | 键盘内部的提交数据序号或者ADDL |
| 13-14 | KEYTIME | 第1个结果的按键时间， 2字节，高位在前<br>一般是离投票开始的时间，单位是20ms，最大约21分钟 |
| 15 | SLOTN ||
| 16 | SLOT/NO| 16字符的片号，或测验题目号 |
| 17-32 | STRING | 第1个结果的16个字符串 |
| 33-59 || ~~第~~ 2个表决器的结果的27字节（由于USB数据只能58字节，所以USB结构的话，1次只能传1个键盘字符串数据） |
||||

### 3.2.3 上报考勤数据（取消）

新打包格式，可打包6个数据，比老版多一倍。
基站==\>PC, 基站发送id、时间信息给PC端，数据格式：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站编号 |
| 3 | CMDTYPE | 5 基站结果上传 |
| 4 | MSGNO | 数据包序号 |
| 5 | MSGTYPE | 基站数据包类型: 23考勤结果-十六进制结果（每组8字节） |
| 6 | ANSTYPE | 记录条数: 0x00=无记录 |
| 7-14 | IDPACK1 | id数据包1 |
| 15-22 | IDPACK2 | id数据包2 |
| 23-30 | IDPACK3 | id数据包3 |
| 31-38 | IDPACK4 | id数据包4 |
| 39-46 | IDPACK5 | id数据包5 |
| 47-54 | IDPACK6 | id数据包6 |

id数据包格式定义

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1-4 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 5 | RDNO | 读头编号: 1=1#阅读器, 2=2#阅读器 |
| 6 | TIME[hour] | 小时，10进制 |
| 7 | TIME[min] | 分，10进制 |
| 8 | TIME[sec] | 秒，10进制 |

参考数据:

F5 AA AA

3C

E0

01

05

01

17

06

0F 15 64 05 01 01 0E 02

0F 15 64 05 02 01 0E 02

B5 49 19 0F 01 01 0E 02

B5 49 19 0F 02 01 0E 02

0F 17 BA D5 01 01 0E 02

0F 17 BA D5 02 01 0E 02

00 00 00 00

18 4D

### 3.2.4 上报考勤数据带电压

基站==\>PC, 基站发送id、时间信息给PC端，数据格式：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站编号 |
| 3 | CMDTYPE | 5 基站结果上传 |
| 4 | MSGNO | 数据包序号 |
| 5 | MSGTYPE | 基站数据包类型: 24考勤结果-带电压 |
| 6 | ANSTYPE | 记录条数: 0x00=无记录 |
| 7-14 | IDPACK1 | id数据包1 |
| 15-22 | IDPACK2 | id数据包2 |
| 23-30 | IDPACK3 | id数据包3 |
| 31-38 | IDPACK4 | id数据包4 |
| 39-46 | IDPACK5 | id数据包5 |
| 47-54 | IDPACK6 | id数据包6 |

id数据包格式定义

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1-4 | KEYSN | 表决器硬件序列号，4字节，高位在前 |
| 5 | RDNO | 读头编号: 1=1#阅读器, 2=2#阅读器 |
| 6 | VOLT | 低7位是电池电压，单位0.04VBit7暂保留，例如防拆报警 |
| 7-8 | TIME | 2字节秒数，高位前 |
||||

### 3.2.5 序列号和编号同时传

分别见3.2.1节和3.2.2节，类型25和类型26。

### 3.2.6 SN+ID模式下，BCD结果+电量

&emsp;&emsp;USB数据包只能有效数据58字节，减去前5个必要字节，余53字节，原先7BCD结果是17字节1个键盘，由于数字题要16位和加上电量（K1、T1键盘），至少19字节，所以只能打2包，为适应以后增加信息，53字节分两段一段可以26字节，对应到从ANSTYPE起26字节是一个键盘的数据。

传整个结果数据包结构如下：（第6字节到第24字节都是拷贝键盘数据）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 5 基站结果上传 |
| 4 | MSGNO | 数据包序号 |
| 5 | MSGTYPE | 基站数据包类型 27SN+ID模式下字符串结果+电量（每组27字节） |
| 6 | ANSTYPE | 第1个结果的数据包类型<br>这里是7或8，从这里开始的数据都是直接拷贝键盘数据<br>如果类型为0xFF，表示后面就没有数据了 |
| 7-10 | KEYSN | 第1个结果的表决器硬件序列号，4字节，高位在前 |
| 11-12 | ID | 第1个结果的表决器编号，2字节，高位在前 |
| 13-14 | KEYTIME | 第1个结果的按键时间， 2字节，高位在前<br>如果是填空，单位时间20ms，如果是测验，单位时间100ms |
| 15-22 | VALUE | 第1个结果的8字节值，一般用BCD码表示，高位在前，F表示空字符，最多14位数 |
| 23 | VOLT | 电压值，单位20mV |
| 24-31 | RSSI？ | 可能添加RSSI等其他信息，暂时全00<br>一直到第31字节，这样ANSTYPE起是26字节 |
| 32 | ANSTYPE2 | 第2个键盘结果的ANSTYPE |
| 33-57 | ANSVAL2 | 第2个键盘结果的从KEYSN到最后一个字节的值，25字节 |
| 58 || 空，USB基站只有58字节 |
||||

### 3.2.7 SN+ID模式下，字符串结果+电量

传整个结果数据包结构如下：（第6字节到第24字节都是拷贝键盘数据）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 5 基站结果上传 |
| 4 | MSGNO | 数据包序号 |
| 5 | MSGTYPE | 基站数据包类型 28SN+ID模式下字符串结果+电量（每组26字节） |
| 6 | ANSTYPE | 第1个结果的数据包类型<br>9字符串（带电量、效验），从这里开始到第30字节的数据都是直接拷贝键盘数据<br>如果类型为0xFF，表示后面就没有数据了 |
| 7-10 | KEYSN | 第1个结果的表决器硬件序列号，4字节，高位在前 |
| 11-12 | ID | 第1个结果的表决器编号，2字节，高位在前 |
| 13 | KEYTIME | 如果是填空，单位时间0.5s，如果是测验，单位时间1分钟 |
| 14 | SLOTN或者ITEMNO | 如果是填空，高4位表示总共有多少片数据（1片16字符），0表示有1片段，低4位表示片段号码（0起），这样填空可以传256字符<br>如果是测验，是题号，表示是那个题目的答案 |
| 15 | VOLT | 电压，单位20mV |
| 16-30 | STRING | 15字节字符串，ASCII码，0代表字符结束 |
| -31 |||
| 32 | ANSTYPE2 | 第2个键盘结果的ANSTYPE |
| 33-57 | ANSVAL2 | 第2个键盘结果的从KEYSN到最后一个字节的值，25字节 |
| 58 || 空，USB基站只有58字节 |
||||

### 3.2.8 SN+ID模式下，长结果

传整个结果数据包结构如下：（第6字节开始都是拷贝键盘数据）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE0 基站类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 5 基站结果上传 |
| 4 | MSGNO | 数据包序号 |
| 5 | MSGTYPE | 基站数据包类型<br> 29SN+ID模式下字符串结果+电量（每组25字节或更多） |
| 6 | ANSTYPE | 第1个结果的数据包类型<br>（目前是0状态报告，但里面小模式是报告16字符姓名的） |
| 7-10 | KEYSN | 第1个结果的表决器硬件序列号，4字节，高位在前 |
| 11-12 | ID | 第1个结果的表决器编号，2字节，高位在前 |
| 13-30 || 其他键盘数据18字节，从ANSTYPE开始算共25字节数据<br>或更多，但目前最多25了 |
||| （基站只能送1个数据，2个空间不够） |
||||
||||

备注：这个类型主要是为了打包状态报告里面需要16字符姓名。

## 3.3 基站报告状态

&emsp;&emsp;用于基站主动报告信息，由于可靠性需要带确认，当成键盘结果包是最简单的，不打断SDK的处理流程，基站把消息模拟成结果压到队列即可。

基站模拟键盘结果类型，所以这里是按键盘打包格式：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型11 基站报告状态 |
| 3 | REP\_TYPE | 报告类型 <br>1 键盘快速设置失败<br>2 键盘快速设置成功<br>3 基站测试结果反馈，<br>4 键盘在线状态<br>5 多包上传状态<br>6 NFC刷卡消息<br>（后面格式根据这个类型值解析）<br>10 基站log文字信息 <br>11 基站报告键盘离在线信息|
||||

### 3.3.1 键盘快速设置回报

基站模拟键盘结果类型，所以这里是按键盘打包格式：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>11 基站报告状态 |
| 3 | REP\_TYPE | 报告类型 <br>1 键盘快速设置失败 <br>2键盘快速设置成功<br>（后面格式根据这个类型值解析） |
| 4 | SetDataPos | 快速设置指令里面的的DataPos<br>REP\_TYPE=3时，反馈基站测试结果 ，对于到CMDTYPE=13, |
| 5 | CMD | 0x38 键盘命令码，快速设置是0x38<br>其实从本字节开始的N个字节，都是对应设置指令的，这样SDK配合DataPos能准确判断键盘是哪个指令执行失败，注意基站要准确返回DataPos |
| 6-9 | SN | 键盘SN，4字节 |
| 10 | KCMD | 快速设置的哪个类型的指令 |
| 11-18 | KCMD1 | 从KCMD起拷贝8个字节吧，SDK可能用到 |
||||
| 23-24 || CRC，1到第22字节 |

### 3.3.2 基站测试结果回报

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>11 基站报告状态 |
| 3 | REP\_TYPE | 报告类型<br> 3 基站测试结果反馈<br>（后面格式根据这个类型值解析） |
| 4 | SetDataPos | REP\_TYPE=3时，反馈基站测试结果 ，对应到5.2.13节的CMDTYPE=13 基站功能测试 |

### 3.3.3 键盘在线状态回报

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>11 基站报告状态 |
| 3 | REP\_TYPE | 报告类型<br> 4 键盘在线状态回报 |
| 4 | STATUS | 1 在线状态汇总<br> 2 新键盘加入<br>3 键盘退出(基站判断键盘离线) |
| 5-6 | TOTAL | 基站现在在线键盘数目，高位前 |
| 7-8 | TEMPPOS | 平常是0，在STATUS=1的时候，是编号，1到TOTAL，用于SDK判断是否所有在线键盘的状态都收到了 |
| 9-12 | SN | 4字节键盘SN号 |
| 13 | HMODEL | 键盘的型号代码 |
| 14 | HVER | 键盘硬件版本 |
| 15-17 | SVER | 键盘软件版本，3字节，10进制数字 |
| 18 | VOLT | 电池电压，Bit7为1表示在充电，低7位x0.04V就是电池当前电压 |
||||

### 3.3.4 多包上传状态报告

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>11 基站报告状态 |
| 3 | REP\_TYPE | 报告类型<br> 5 基站多包上传状态 |
| 4 | STATUS | 1 键盘多包上传数据接收成功 <br>2 接收失败<br>3 基站申请多包数据上传 |
| 5 | PACKTYPE | 多包类型，这和键盘提交的多包申请里的类型一致 |
| 6 | PACKID | 数据包辨别码，一般是0，和键盘提交的多包申请里数据一致 |
| 7-10 | PACKLEN | 多包总字节长度，long类型，高位前 |
| 11-12 | DATALEN | SDK取包每次多少字节，short类型，高位前<br>这个是基站根据硬件条件来决定 |
| 13 | BASEID | 基站序号，一般1 |
| 14-17 | SN | 键盘序列号，4字节 |
||||

### 3.3.5 NFC刷卡消息-入网消息

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>11 基站报告状态 |
| 3 | REP\_TYPE | 报告类型<br> 6 NFC刷卡消息 |
| 4 | STATUS | 1 基站容量满（含键盘开机入网受限）<br> 2 基站报告正常刷卡的键盘SN <br>3 新键盘刷卡，由于容量限定，首个键盘被移出名单<br>4 刷卡写指定配对码消息 <br>5 报告M1卡的SN |
| 5-8 | SN | 键盘SN ==STATUS：5 时 SN取值高低位与正常反向== |
| 9 | ONLINEN | 在线键盘数目 |

### 3.3.5 基站Log信息

&emsp;&emsp;以往基站或键盘的调试信息，只能串口、RTT实时打印，需要连接线和特殊工具才能获取，这里提供一种直接通过USB上报的方法，就是把调试信息当一种类型的投票结果传给SDK，SDK直接解码显示到log显示界面，这样，调试很方便。参见3.2.2节基站的应答数据包，1包共60字节，平常传32字符信息没问题。

调试信息指令格式：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | GETCMD | 0x9F Log文本信息 |
| 2 | TYPE | 暂1，表示格式1 |
| 3 | SOURCE\_ID | 来源，0-4，比如0是主控，1是模块1，也可以当告警等级<br>SDK那边可以分开不同的tab页显示 |
| 4-5 | TIME | 时间，2字节，高位前，单位20ms，一般是投票启动时为0<br>SDK转换成分、秒、毫秒显示 |
| 6-- | LogText | 开始是Log文本信息，SDK按文本显示 |
||||
| 59-60 |||


### 3.3.7 基站主动报告键盘离在线消息

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | ANSCMD | 0x94硬件序列号带编号提交结果 |
| 2 | ANSTYPE | 数据包类型<br>11 基站报告状态 |
| 3 | REP\_TYPE | 报告类型<br> 11 键盘离在线信息 |
| 4-7 | kp_sn | 键盘SN |
| 8 | state | 键盘状态:0-离线;1-在线|
| 9-11 | version | 键盘版本号 |
| 12 | volt | 键盘电量|

# 五、基站管理

## 5.1概述

为减少工作量，基站设置大部分保持兼容。原来设置基站名称的地方，改为设置自由模式下的基站密码。新加考勤基站配置。

命令CMDTYPE总表：（和政务商务体系兼容）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br> 1 读取基站配置 <br>2 设置基站配置 <br>3 读取基站硬件信息，例如SN <br>4 设置基站硬件信息（内部使用，不对外公开）<br> 5 读取基站配对码<br> 6 设置基站配对码（内部使用，不对外公开）<br> 7 基站升级<br> 8 平板基站参数设置 <br>9 基站软件狗功能 <br>10 信道评估 <br>11 通用附加配置 <br>12 TCPIP相关配置 <br>13 基站测试 <br>14 白名单管理 <br>15 基站OEM读<br> 16 基站OEM写 <br>17 基站键盘SN名单管理 <br>18 基站键盘SN名单管理-长包<br>22 基站下载多包 <br>23 基站上传多包（和AES加密冲突）<br> 24 AES加密写设置 <br>25 CRC 读设置<br> 26 CRC 写设置<br> 27 基站下载单包<br> 28 基站下载单包-快速设置-1024字节<br><br>30 组网相关 <br>31 测试相关<br> 32 Log信息 <br>33 SDK退出 <br>34 读基站字符串<br>35 写基站字符串 |

## 5.2 基础管理类

### 5.2.1 通用附加配置

&emsp;&emsp;用于配置基站的其他特性，特别是新加特性。例如V4.5版本时候，支持教育体系下，基站要新加基站名称和配对模式设定。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 1 读取基站配对模式和基站名称 <br>2 写基站配对模式和基站名称<br>其他模式附表：<br>3 读取基站多信道模式参数<br>4 设置基站多信道模式参数<br>5-读取考勤基站时钟设置<br>6-写考勤基站时钟设置<br>7-读取考勤基站射频衰减设置<br>8-写考勤基站射频衰减<br>9-读取免配对SN号模式下的网络状态<br>10-写免配对SN号模式下的网络状态<br>11-读取免配对SN号模式下的基站设置<br>12-写免配对SN号模式下的基站设置<br>13-读取考勤基站去重设置<br>14-写考勤基站去重设置<br>15 读取基站快速配对低功率设置<br>16 写基站快速配对低功率设置 <br>17 写基站设备状态，例如NFC <br>18 读基站设备状态 <br>19 写NFC刷卡信息<br> 20 NFC刷卡返回 <br>21 读基站数据开关 <br>22 写基站数据开关<br>23 读基站名称<br>24 写基站名称<br>25 读基站登录密码（S6）<br>26 写基站登录密码（S6）<br>27 读基站Plus模式（S6） LOGMODE = 1 0<br>28 写基站Plus模式（S6） LOGMODE = 1 0 对应相应开关 <br>29 写基站配置-快速响应信标模式 （MODE下一字节为快速休眠持续时间单位S 填0基站默认10S，意思10S之后基站自动回到正常休眠信标发送） （基站正常模式信标内WCT\_Pos位0-7循环发送，快速响应信标模式为一直发送7，让键盘以30MS周期休眠持续固定市场 基站自动关闭该模式） <br>30 读空闲设置-反馈参数设置<br> 31 写空闲设置-反馈参数设置 <br>32 读空闲设置-语言设置 <br>33 写空闲设置-语言设置 <br>34 读基站组网公开位<br>35 写基站组网公开位 |
| 5 | LOGMODE | （以下参数只对MODE=1有效）<br>配对模式，固定还是自由登录<br>（只支持4-8模式）<br> 4配对SN号模式 <br>5 自由SN号模式 <br>6 免配对SN号模式 <br>~~7 免配对同频点SN号模式（正道远）~~~~ <br>8 免配对多频点SN号模式（正道远）~~<br>7 配对序列号+编号模式（S6Plus体系）-K1套装模式<br>8 白名单序列号+编号模式（S6Plus体系）-K1白名单模式 |
| 6-8 | PWD | 自由模式下基站的密码，必须满3位，ASC字符 <br>000不用核对<br>25、26新模式下，2字节，高位前，密码范围9999，0不用核对 |
| 6-17 | BASENAME | 如果是写基站名称字符串指令，从6开始，12字节，0提前结束 |
| -29 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 11通用附加配置 |
| 4 | MODE | 对应指令MODE值 |
| 5 | LOGMODE | 当前LOGMODE值 |
| 6- | PWD-BASENAME | 自由模式下基站的密码或者是基站名称 |
| -29 || 参数无意义 |

### 5.2.2 考勤基站时钟设置

用于配置基站的其他特性，特别是新加特性。例如V4.5版本时候，支持教育体系下，基站要新加基站名称和配对模式设定。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型11 通用附加配置 |
| 4 | MODE | 5-读取考勤基站时钟设置6-写考勤基站时钟设置 |
| 5 | HOUR | 考勤基站时钟的时 |
| 6 | MIN | 考勤基站时钟的分 |
| 7 | SEC | 考勤基站时钟的秒 |
| 8-29 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 11通用附加配置 |
| 4 | MODE | 5 返回考勤基站配置参数 |
| 5 | HOUR | 考勤基站时钟的时 |
| 6 | MIN | 考勤基站时钟的分 |
| 7 | SEC | 考勤基站时钟的秒 |
| 8-29 || 参数无意义 |

### 5.2.2b 考勤基站射频衰减值设置

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型11 通用附加配置 |
| 4 | MODE | 7-读取考勤基站射频衰减设置8-写考勤基站射频衰减 |
| 5 | ATT1 | 内读头衰减值0-31 |
| 6 | ATT2 | 外读头衰减值0-31 |
||||
| 8-29 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 11通用附加配置 |
| 4 | MODE | 7 返回考勤基站射频衰减设置 |
| 5 | ATT1 | 内读头衰减值 |
| 6 | ATT2 | 外读头衰减值 |
||||
| 8-29 || 参数无意义 |

### 5.2.3 免配对SN号模式网络状态（正道远）

在5.2.1节基站配对模式是7和8的时候有效。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型11 通用附加配置 |
| 4 | MODE | 9-读取免配对SN号模式下的网络状态10-写免配对SN号模式下的网络状态 |
| 5 | NET | 服务器在线情况 0 离线 1 在线，基站数据可以上传SDK定时10秒向基站设置一次，相当于握手信号，否则基站认为离线，不再接收键盘数据 |
| 6 |||
| 7-29 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 11通用附加配置 |
| 4 | MODE | 9 返回免配对SN号模式下的网络状态|
| 5 | NET | 同设置值 |
| 6-29 || 参数无意义 |

### 5.2.4 TCPIP相关配置

注意：仅支持TCPIP连接功能的基站才能执行这些指令。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>12 TCPIP相关配置 |
| 4 | MODE | 1 读取基站4字节的IP地址，高位前<br> 2 设置基站4字节的IP地址，高位前<br> 3 读取基站6字节的MAC地址 <br>4 设置基站6字节的MAC地址<br> 5 读取基站4字节的子网掩码<br> 6 设置基站4字节的子网掩码 <br>7 读取基站4字节的网关地址 <br>8 设置基站4字节的网关地址<br>9 读取基站4字节的DNS地址<br>10 设置基站4字节的DNS地址<br>11 读取基站4字节的待连接服务器地址<br>12 设置基站4字节的待连接服务器地址<br>13 读取网络端口参数<br>14 设置网络端口参数<br>15 读取服务器4字节的IP地址<br>16 设置服务器4字节的IP地址<br>17 读取服务器用户名<br>18 设置服务器用户名<br>19 读取服务器密码<br>20 设置服务器密码|
| 5-10 | IPMAC | 设置的IP地址或MAC地址字节数据、掩码、网关 |
| 11-29 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 1 当前的IP地址<br> 3 当前的MAC地址<br> 5 当前的子网掩码 <br>7 当前的网关地址 <br>9 读取基站4字节的DNS地址<br>11 读取基站4字节的待连接服务器地址<br>13 读取网络端口参数 |
| 5-10 | IPMAC | 当前的IP地址或MAC地址字节数据、掩码、网关 |
| 11-29 || 参数无意义 |

#### 5.2.4.1 基站IP地址

电脑向基站发送(参考IP地址: 200.200.100.251)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 1 读取基站4字节的IP地址，高位前<br>2 设置基站4字节的IP地址，高位前 |
| 5 | IP\_ADDR | 十六进制,IP地址,如:200 |
| 6 | IP\_ADDR | 十六进制,IP地址,如:200 |
| 7 | IP\_ADDR | 十六进制,IP地址,如:100 |
| 8 | IP\_ADDR | 十六进制,IP地址,如:251 |
| 9-29 || 参数无意义 |

基站应答(参考IP地址: 200.200.100.251)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 1 读取基站4字节的IP地址，高位前 |
| 5 | IP\_ADDR | 十六进制,IP地址,如:200 |
| 6 | IP\_ADDR | 十六进制,IP地址,如:200 |
| 7 | IP\_ADDR | 十六进制,IP地址,如:100 |
| 8 | IP\_ADDR | 十六进制,IP地址,如:251 |
| 9-29 || 参数无意义 |

#### 5.2.4.2 基站MAC地址

电脑向基站发送(参考MAC地址: EA-37-35-82-23-51)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型 <br>12 TCPIP相关配置 |
| 4 | MODE | 3 读取基站6字节的MAC地址<br>4 设置基站6字节的MAC地址 |
| 5 | MAC | 十六进制,MAC地址,如:0xea |
| 6 | MAC | 十六进制,MAC地址,如:0x37 |
| 7 | MAC | 十六进制,MAC地址,如:0x35 |
| 8 | MAC | 十六进制,MAC地址,如:0x82 |
| 9 | MAC | 十六进制,MAC地址,如:0x23 |
| 10 | MAC | 十六进制,MAC地址,如:0x51 |
| 11-29 || 参数无意义 |

基站应答(参考MAC地址: EA-37-35-82-23-51)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 3 读取基站6字节的MAC地址 |
| 5 | MAC | 十六进制,MAC地址,如:0xea |
| 6 | MAC | 十六进制,MAC地址,如:0x37 |
| 7 | MAC | 十六进制,MAC地址,如:0x35 |
| 8 | MAC | 十六进制,MAC地址,如:0x82 |
| 9 | MAC | 十六进制,MAC地址,如:0x23 |
| 10 | MAC | 十六进制,MAC地址,如:0x51 |
| 11-29 || 参数无意义 |

#### 5.2.4.3 基站子网掩码

电脑向基站发送(参考掩码地址: 255.255.255.0)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 5 读取基站4字节的子网掩码<br>6 设置基站4字节的子网掩码 |
| 5 | MAC | 十六进制,掩码地址,如:255 |
| 6 | MAC | 十六进制,掩码地址,如:255 |
| 7 | MAC | 十六进制,掩码地址,如:255 |
| 8 | MAC | 十六进制,掩码地址,如:0 |
| 9-29 || 参数无意义 |

基站应答(参考掩码地址: 255.255.255.0)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 5读取基站4字节的子网掩码 |
| 5 | MAC | 十六进制,掩码地址,如:255 |
| 6 | MAC | 十六进制,掩码地址,如:255 |
| 7 | MAC | 十六进制,掩码地址,如:255 |
| 8 | MAC | 十六进制,掩码地址,如:0 |
| 9-29 || 参数无意义 |

#### 5.2.4.4 基站网关地址

电脑向基站发送(参考网关地址: 200.200.100.1)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 7 读取基站4字节的网关地址<br>8 设置基站4字节的网关地址 |
| 5 | GATEWAY | 十六进制,网关地址,如:200 |
| 6 | GATEWAY | 十六进制,网关地址,如:200 |
| 7 | GATEWAY | 十六进制,网关地址,如:100 |
| 8 | GATEWAY | 十六进制,网关地址,如:1 |
| 9-29 || 参数无意义 |

基站应答(参考网关地址: 200.200.100.1)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 7读取基站4字节的网关地址 |
| 5 | GATEWAY | 十六进制,网关地址,如:200 |
| 6 | GATEWAY | 十六进制,网关地址,如:200 |
| 7 | GATEWAY | 十六进制,网关地址,如:100 |
| 8 | GATEWAY | 十六进制,网关地址,如:1 |
| 9-29 || 参数无意义 |

#### 5.2.4.5 基站DNS地址

电脑向基站发送(参考DNS地址: 200.200.100.1)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 9读取基站4字节的DNS地址10设置基站4字节的DNS地址 |
| 5 | DNS | 十六进制,网关地址,如:200 |
| 6 | DNS | 十六进制,网关地址,如:200 |
| 7 | DNS | 十六进制,网关地址,如:100 |
| 8 | DNS | 十六进制,网关地址,如:1 |
| 9-29 || 参数无意义 |

基站应答(参考DNS地址: 200.200.100.1)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>12 TCPIP相关配置 |
| 4 | MODE | 9读取基站4字节的DNS地址 |
| 5 | DNS | 十六进制,网关地址,如:200 |
| 6 | DNS | 十六进制,网关地址,如:200 |
| 7 | DNS | 十六进制,网关地址,如:100 |
| 8 | DNS | 十六进制,网关地址,如:1 |
| 9-29 || 参数无意义 |

#### 5.2.4.6 基站待连接服务器地址

电脑向基站发送(参考服务器地址: 200.200.100.1)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型 <br>12 TCPIP相关配置 |
| 4 | MODE | 11 读取基站4字节的待连接服务器地址<br>12 设置基站4字节的待连接服务器地址 |
| 5 | SERVERIP | 十六进制,网关地址,如:200 |
| 6 | SERVERIP | 十六进制,网关地址,如:200 |
| 7 | SERVERIP | 十六进制,网关地址,如:100 |
| 8 | SERVERIP | 十六进制,网关地址,如:1 |
| 9-29 || 参数无意义 |

基站应答(参考服务器地址: 200.200.100.1)：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 11读取基站4字节的待连接服务器地址 |
| 5 | SERVERIP | 十六进制,网关地址,如:200 |
| 6 | SERVERIP | 十六进制,网关地址,如:200 |
| 7 | SERVERIP | 十六进制,网关地址,如:100 |
| 8 | SERVERIP | 十六进制,网关地址,如:1 |
| 9-29 || 参数无意义 |

#### 5.2.4.7 基站连接端口参数

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型 <br>12 TCPIP相关配置 |
| 4 | MODE | 13 读取网络端口参数<br>14 设置网络端口参数 |
| 5 | LOCAL\_IP | 基站IP地址获取方式：0=手动指定；1=DHCP获取 |
| 6 | CONNET\_M | 连接服务器方式：0=IP地址方式；1=域名方式 |
| 7-10 | HEART\_TIME | 心跳时间长度：[0, 65535] 秒 |
| 11-14 | CLIENT\_PORT | TCP Client连接端口：[0, 65535] |
| 15-18 | LISTEN\_PORT | TCP Server监听端口：[0, 65535] |
| 19-22 | SERVER\_PORT | 待连接服务器的服务端口：[0, 65535] |
| 23-29 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>12 TCPIP相关配置 |
| 4 | MODE | 13读取网络端口参数 |
| 5 | LOCAL\_IP | 基站IP地址获取方式：0=手动指定；1=DHCP获取 |
| 6 | CONNET\_M | 连接服务器方式：0=IP地址方式；1=域名方式 |
| 7-10 | HEART\_TIME | 心跳时间长度：[0, 65535] 秒 |
| 11-14 | CLIENT\_PORT | TCP Client连接端口：[0, 65535] |
| 15-18 | LISTEN\_PORT | TCP Server监听端口：[0, 65535] |
| 19-22 | SERVER\_PORT | 待连接服务器的服务端口：[0, 65535] |
| 23-29 || 参数无意义 |

~~#### 5.2.4.8 服务器IP地址
电脑向基站发送(参考IP地址: 200.200.100.251)~~

~~| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 15 读取服务器4字节的IP地址，高位前<br>16 设置服务器4字节的IP地址，高位前 |
| 5 | IP\_ADDR | 十六进制,IP地址,如:200 |
| 6 | IP\_ADDR | 十六进制,IP地址,如:200 |
| 7 | IP\_ADDR | 十六进制,IP地址,如:100 |
| 8 | IP\_ADDR | 十六进制,IP地址,如:251 |
| 9-29 || 参数无意义 |~~

基站应答(参考IP地址: 200.200.100.251)：
~~| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>12 TCPIP相关配置 |
| 4 | MODE | 15 读取服务器4字节的IP地址，高位前 |
| 5 | IP\_ADDR | 十六进制,IP地址,如:200 |
| 6 | IP\_ADDR | 十六进制,IP地址,如:200 |
| 7 | IP\_ADDR | 十六进制,IP地址,如:100 |
| 8 | IP\_ADDR | 十六进制,IP地址,如:251 |
| 9-29 || 参数无意义 |~~

#### 5.2.4.9 服务器用户名

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br> 12 TCPIP相关配置 |
| 4 | MODE | 15 读取服务器用户名<br>16 设置服务器用户名 |
| 5 | SEVER\_name\_LEN | 服务器用户名字节个数 |
| 6-56 | SEVER\_name | 服务器用户名字符（50字节） |
||||
||||
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>12 TCPIP相关配置 |
| 4 | MODE | 15读取服务器用户名 |
| 5 | SEVER\_name\_LEN | 服务器用户名字节个数 |
| 6-56 | SEVER\_name | 服务器用户名字符（50字节） |
||||
||||
| 9-29 || 参数无意义 |

#### 5.2.4.10 服务器密码

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型 <br>12 TCPIP相关配置 |
| 4 | MODE | 17 读取服务器密码<br>18 设置服务器密码 |
| 5 | SEVER\_code\_LEN | 服务器密码字节个数 |
| 6-56 | SEVER\_code | 服务器密码字符（50字节） |
||||
||||
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>12 TCPIP相关配置 |
| 4 | MODE | 17读取服务器密码 |
| 5 | SEVER\_code\_LEN | 服务器密码字节个数 |
| 6-56 | SEVER\_code | 服务器密码字符（50字节） |
||||
||||
| 9-29 || 参数无意义 |

### 5.2.5 免配对SN号模式基站设置（正道远）

在5.2.1节基站配对模式是7和8的时候有效。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 11-读取免配对SN号模式下的基站设置<br>12-写免配对SN号模式下的基站设置，此模式下第5字节后面数据有效 |
| 5 | ATTN | 0 键盘考勤关闭<br>1 键盘考勤打开 |
| 6 | REPORT | 0 键盘定时报告状态关闭<br>1 打开 |
| 7 | BEACON | 0 基站发投票信标关闭<br>1 打开，基站在测试模式，可控制进入测试模式的键盘进行在线测试、写号等 |
| 8-29 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 11通用附加配置 |
| 4 | MODE | 11 返回免配对SN号模式下的基站设置 |
| 5 | ATTN | 0 键盘考勤关闭<br>1 键盘考勤打开 |
| 6 | REPORT | 0 键盘定时报告状态关闭<br>1 打开 |
| 7 | BEACON | 0 基站发投票信标关闭<br>1 打开，基站在测试模式，可控制进入测试模式的键盘进行在线测试、写号等 |
| 8-29 || 参数无意义 |

### 5.2.6 考勤基站去重配置

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 13-读取考勤基站去重设置<br>14-写考勤基站去重设置 |
| 5 | FLAG | 是否设置去重: 0=不去重; 1=去重; |
| 6 | COUNT | 去重秒数=[1, 5] |
||||
| 8-29 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 11通用附加配置 |
| 4 | MODE | 13返回考勤基站考勤基站去重设置 |
| 5 | FLAG | 是否设置去重: 0=不去重; 1=去重; |
| 6 | COUNT | 去重秒数=[1, 5] |
||||
| 8-29 || 参数无意义 |

### 5.2.7 软件狗功能

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>9 基站软件狗功能 |
| 4 | MODE | 1 核对密码 <br>2 读用户区 <br>3 写用户区 <br>4 读出密码（内部功能，不对用户公开）<br> 5 修改密码（内部功能，不对用户公开）<br>6 读出基站唯一硬件编号UID |
| 5 | USERZONE | 用户区号，读写用户区时候有意义，1-4，每区16字节，SDK支持按字节读写，都先需要核对密码才能读写 |
| 6-21 | USERINFO | 读密码和用户区信息时候，参数无意义<br>核对密码和修改密码时候，前8字节是密码字符串，不足8字节补00，后8字节无意义<br>写用户区信息时候，是16字节用户信息，字符串格式，不足16字节补00 |
| 22-24 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>9 基站软件狗功能应答 |
| 4 | RESULT | 结果类型 <br>1核对密码状态 <br>2返回用户信息 <br>3返回密码<br>6 返回基站UID |
| 5 | STATUS | 核对密码时，1成功 2失败<br>返回用户信息时候，是用户区号，1为1区，2为2区<br>返回密码时候，本字节无意义 |
| 6-21 | USERINFO | 核对密码时候参数无意义。<br>返回用户区时候是16字节用户区字符串，如果1-4区未正确核对密码，不能操作，返回字符串"LOCK"。<br>返回密码时候，前8字节有效。<br>返回UID时候，STM32系列是12字节 |
| 22-24 || 参数无意义 |

### 5.2.8 低功率快速配对

用于控制基站进入快速配对时候，是否降低功率，以满足多教室同时配对需求

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 15-读取基站快速配对低功率模式<br>16-写基站快速配对低功率模式 |
| 5 | ENABLE | 是否低功率: 0=不使用; 1=使用; |
||||
| 6-29 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 11通用附加配置 |
| 4 | MODE | 15返回基站快速配对低功率设置 |
| 5 | ENABLE | 是否低功率: 0=不使用; 1=使用 |
||||
| 6-29 || 参数无意义 |

### 5.2.9 语音基站状态控制/显示

用于控制语音基站状态显示；语音键盘的数据是通过无线路由器转usb直接传给sdk,而基站

本身无法检测到是否有数据传输，所以需要sdk将一些状态信息传输给基站的mcu,显示到lcd、led上。

电脑向基站发送： （先1秒1次执行写）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 17-读取语音基站状态<br>18-写语音基站状态 |
| 5 | DEV\_STAT | 设备状态 0-正常 \>1故障 <br>1 WIFI连接错误<br>2 NFC读卡器连接错误 |
| 6 | SDK\_STAT | 电脑数据灯闪烁模式<br> 0 灭 1快闪<br>SDK连接上后总发送1，基站闪烁显示，但最好间隙随机 |
| 7 | KEY\_STAT | 键盘数据等闪烁模式<br>0 灭 N\>0 1秒内闪烁N次，暂1到10<br>SDK1秒收到键盘应答数据，根据键盘个数送1到10，如果1秒内没收到任何键盘数据，送0 |
| 8 | VOTE\_MODE | 投票模式，投票信标中的MODE值<br>用于基站显示状态 |
| ~~9~~ | ~~Fast\_charge\_STAT~~ | ~~是否在快充状态；1=快速充电；0=普通充电~~ |
||||
| 8-29 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>11通用附加配置 |
| 4 | MODE | 17返回语音基站状态 |
| 5 | DEV\_STAT ||
| 6 | SDK\_STAT ||
| 7 | KEY\_STAT ||
| 8 | VOTE\_MODE ||
| 9.。 || 参数无意义 |

### 5.2.10 基站写NFC信息

用于基站本身带NFC，刷卡写键盘信息，基站返回2次信息，第1次表示收到，第2次是刷卡写成功的时候返回键盘SN和当前信息。

电脑向基站发送： （SDK按64字节长度发送包）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 19 写NFC学生信息<br>20 读键盘NFC学生信息 |
| 5 | MSGTYPE | 信息类型<br> 1 学生信息（学号、姓名、金币）--为了简单，先1次写完，SDK按64字节长度发送包<br>4 学生信息，单条48字节,IDSTR48字节是姓名NAME内容 |
| 6-21 | IDSTR | 16字符学号信息，0xFF开始的话表示不修改键盘原有的信息 |
| 22-37 | NAME | 16字符姓名信息，0xFF开始的话表示不修改 |
| 38-41 | MONEY | 金币，4字节，高位在前，全部0xFFFF表示不修改 |
|| 。。。 ||
| 。。58 |||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 11通用附加配置 |
| 4 | MODE | 19 刷卡写应答<br>20 返回刷卡读信息（19类刷卡ok也返回） |
| 5 | STATUS | ~~1 收到指令~~<br>~~2 刷卡写ok格式1，先只返回SN~~<br>STATUS等于发送的MSGTYPE<br>（S6体系，T2体系目前都回1） |
| 6-9 | SN | 刷卡键盘的SN， 4字节，高位前 |
| 10-11 | SN2 | 政务体系6字节SN的后面2字节 |
| 12-13 | ID | 键盘编号，高位在前 |
| .。 || 参数无意义 |

针对G1政务商务应用股东姓名比较长(52字节)情况：

| 5 | MSGTYPE | 信息类型<br>2股东姓名(52字节)，SDK按64字节长度发送包 |
| --- | --- | --- |
| 6-57 | STOCKNAME | 股东姓名（52字节）,00提前结束<br>NFC是4字节一段，刚好13段 |
| 58 |||

针对G1政务商务应用股东股权数情况：

| 5 | MSGTYPE | 信息类型<br>3股东股权数目，SDK按64字节长度发送包 |
| --- | --- | --- |
| 6-13 | STOCKNAME | 股东股权数（8字节）<br>键盘端是按BCD码，例如1234就是1234FFFFFFFFFFFF |
| 14.。。 |||
| 。。58 |||

### 5.2.11 基站数据开关配置

用于C200K基站设置投票数据发送通道：USB or TCPIP

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 21 读基站数据开关<br>22 写基站数据开关 |
| 5 | DATA\_SW | 0：投票数据收发接口是USB<br>1: 投票数据收发接口是TCPIP |
| 6 || 参数无意义 |
||||
||||
|| 。。。 ||
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 11通用附加配置 |
| 4 | MODE | 21 读基站数据开关<br>22 写基站数据开关 |
| 5 | DATA\_SW | 0：投票数据收发接口是USB<br>1: 投票数据收发接口是TCPIP |
| 6 || 参数无意义 |
||||
||||
| .。 || 参数无意义 |

### 5.2.12 基站容量配置

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 23 基站容量配置 |
| 5 | MODE1 | 1 设置<br>2 读取 |
| 6-7 | KPNUMS | 容量，带键盘个数，高位在前 |
| 8 | LOCK | 是否锁定当前键盘，锁定就不继续添加键盘<br>1 锁定 0 不锁定 |
||||
|| 。。。 ||
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>11通用附加配置 |
| 4 | MODE | 23 基站容量配置 |
| 5 | MODE1 | 2 返回容量配置信息 |
| 6-7 | KPNUMS | 容量，带键盘个数，高位在前 |
| 8 | LOCK | 是否锁定当前键盘，锁定就不继续添加键盘<br>1 锁定 0 不锁定 |
||||
| .。 || 参数无意义 |

### 5.2.13 基站测试
20231011 ：
- 1，增加了mode=13，基站IO控制外部继电器给答题器按键;
- 2, 增加了mode=14,控制基站rf开关，制造出离线/在线的效果。
- 3，增加了mode=15,用于内部调试，sdk只需如实下发用户数据和显示基站反馈的数据即可。
- 
电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型13基站测试 |
| 4 | MODE | 1 基站进入射频测试模式（FCC测试模式）<br> 2 基站退出射频测试模式<br> 3 模块射频测试，参数是CHAN和MDNO <br>4 外设功能测试，参数是CHAN（老版本3是发送N包，4是纯接收N包，5是接收键盘信号，6是RSSI监听，7是读RSSI）<br> 10 基站蜂鸣器响一下<br><br>11 写音质测试刷卡参数（具体描述在后面）<br>12 读音质测试刷卡参数 <br><br>  13 键盘按键( byte5-end数据无效) <br> 14 基站rf开关控制 <br> 15 内部调试接口(byte5-end数据自定义)|
| 5 | CHAN | 信道，0是缺省，否则指定信道（FCC用到）<br>外设功能测试时候是功能，0 是自动（比如led和蜂鸣器） <br><br> 基站rf开关：0-关闭rf发送 1-开启rf发送 (MODE=14时有效)|
| 6 | MDNO | 模块编号 一般1-4<br>或FCC测试模式（老版本没带这个参数，直接连续载波发射）<br>0和1=连续载波发射 2连续发送 3接收模式 |
| 6-29 || 参数无意义 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br>13 基站测试 |
| 4 | MODE | 1 基站进入射频测试模式<br> 2 基站退出射频测试模式<br> 3 基站测试结果反馈<br>4  <br>13 键盘按键 <br> 14 基站rf开关控制 <br> 15 内部调试接口|
| 5 || 预留 |
| 6 | Rfid num | Mode=3时基站反馈模块的测试结果;测试结果通过5.6.3报告给SDK |
| 7-8 | Tx\_total | 高位在前 |
| 9-10 | Tx\_sucess | 高位在前 |
| 11-12 | Rx\_total | 高位在前 |
| 13-14 | Rx\_sucess | 高位在前 |
||| 参数无意义 |

音质测试刷卡基站（T2用）相关指令：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 4 | MODE | 11 写音质测试刷卡参数<br>12 读音质测试刷卡参数 |
| 5 | TEST\_FUNC | 暂1，音质测试 |
| 6-7 | VOLUME | 音量下限值，2字节，高位前 |
| 8-9 | NOISE | 噪音上限值，2字节，高位前 |
||||

备注：

1、仅专用音质测试基站支持本指令，其他不要支持

2、基站应答，用MODE=12返回

3、基站刷卡写数据地址，在原来wifi\_name的区域，把TEST\_FUNC开始的数据写入

```c
uint8_t match_code[3];  //addr=40
uint8_t frequency_point //addr=43
uint8_t wifi_name[12];  //addr=44
uint8_t wifi_pass[16];  //addr=56   // 14-17区：wifi密码
uint8_t Preserve[16];   //addr=72   // 18-22区：保留16字节，空出来，以后可能是云网址
```

### 5.2.14 基站调试信息互动

用于读取基站当前调试变量值、log记录等。

基站先应答，具体的信息可以多条，用3.3.5节的基站log信息打包返回。

SDK向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>32 基站调试信息互动 |
| 4 | MODE | SDK可填入不同值，基站来根据不同值具体反馈信息<br>1 读取 |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 32基站调试信息互动 |
| 4 | MODE | 同SDK指令 |

### 5.2.15 SDK退出通知

用于基站加硬件usb复位尝试重连时候。

如果SDK正常退出，通知到基站，基站就知道不是故障断开。

SDK向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>33 SDK退出连接 |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 33 收到断开 |
||||

### 5.2.16 NFC指纹管理

用于NFC刷卡进行指纹管理。

SDK向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>34 NFC指纹管理 |
| 4 | CMD |1、指纹清空，并加指纹<br>2、新加指纹<br>3、指纹清空|
| 5 | FPNUM | 指纹数量，例如加2个指纹，表示新录入2个指纹 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 34 收到指纹管理 |
||||

### 5.2.17 NFC写指定配对码

用于NFC刷卡进行键盘的指定绑定不同教室的基站，所以配对码不同。

刷卡后用3.3.5节刷卡消息回报。

SDK向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>35 NFC写指定配对码 |
| 4 | ATC | 4字节配对码 |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 35 收到 |
||||

### 5.2.18 管理基站指令清空

&emsp;&emsp;管理基站可能一直有电，上次软件退出可能还有指令没执行，比如残留了NFC指纹管理指令还没执行。软件连接后清空比较保险。

SDK向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>36 管理指令清空 |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 36 收到管理指令清空 |
||||

### 5.2.19 SDK读写基站字符串

用于SDK判断基站是否已连接（双SDK连接基站BUG）

SDK向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>34 读基站字符串 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 34 读基站字符串 |
| 4-44 | String | 基站存储字符串 40字节 |

SDK向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>35 写基站字符串 |
| 4-44 | String | 40字节字符串 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 35 读基站字符串 |
| 4-44 | String | 基站存储字符串 40字节 |

### 5.2.20 读写基站设置-反馈参数

==基站需保存参数到Eeprom，上电恢复。==

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 30 读空闲设置-反馈参数设置<br>31 写空闲设置-反馈参数设置 |
| 5 | KEYREP | 反馈模式（参数解释对应键盘协议空闲模式下参数） |
| 6 | KEYMAX | 反馈有效按键（参数解释对应键盘协议空闲模式下参数） |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 11通用附加配置 |
| 4 | MODE | 30 读空闲设置-反馈参数设置<br>31 写空闲设置-反馈参数设置 |
| 5 | KEYREP | 反馈模式（参数解释对应键盘协议空闲模式下参数） |
| 6 | KEYMAX | 反馈有效按键（参数解释对应键盘协议空闲模式下参数） |

### 5.2.21 读写基站设置-语言设置

==基站需保存参数到Eeprom，上电恢复。==

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 32 读空闲设置-语言设置33 写空闲设置-语言设置 |
| 5 | ATTRIB\_EX1 | 语言选择（参数解释对应键盘协议空闲模式下参数） |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>11通用附加配置 |
| 4 | MODE | 32 读空闲设置-语言设置33 写空闲设置-语言设置 |
| 5 | KEYREP | 反馈模式（参数解释对应键盘协议空闲模式下参数） |

### 5.2.22 读写基站组网公开位

==基站需保存参数到Eeprom，上电恢复。==

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 34 读基站组网公开位<br>35 写基站组网公开位 |
| 5 | Conterl | 1:开 0：关 对于基站组网广播信标的==基站信息公开位（0x51信标内ST-Bit第一个Bit）== |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>11通用附加配置 |
| 4 | MODE | 34 读基站组网公开位35 写基站组网公开位 |
| 5 | Conterl | 1:开 0：关 |

### 5.2.23 基站复位

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 36 基站复位 |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 11通用附加配置 |
| 4 | MODE | 36 收到复位指令 |
| 5 |||

### 5.2.24 基站刷卡清指纹和姓名

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 37 基站刷卡清空指纹和姓名 |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 11通用附加配置 |
| 4 | MODE | 37 收到 |
| 5 |||

### 5.2.25 基站刷卡写生僻字（12号字体）

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 39 基站刷卡写生僻字 |
| 5 | Cont | 预留 |
| 6-7 | GB\_CODE | GB18030\_编码 |
| 8 - 31 | GB\_DATA | 点阵库数据（24字节） |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 11通用附加配置 |
| 4 | MODE | 39 收到 |
| 5 |||

基站NFC写入规则（基站自己写缓存，写满之后保留最新数据、缓存在使用刷卡生效之后清空）

地址从200开始 片区200/4=50 总消耗空间（26\*8+1+1=210字节）

数据格式：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | Cont | 0x01 （控制字，暂固定为1表示有效） |
| 2-3 | GB\_CODE | GB18030\_编码 |
| 4-27 | GB\_DATA | 点阵库数据（24字节） |
| ... | GB\_CODEx | GB18030\_编码 (最大缓存8个生僻字) |
| ... | GB\_CODEx | 点阵库数据（24字节） |
| 28 | End | 0x55 (表示停止,后续没有内容了) |
||||
||||
||||
||||

### 5.2.26 基站刷卡生效控制

电脑向基站发送： （暂时在刷卡基站与最新基站生效，后续新产品都使用该方式，老产品不动）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 40 基站刷卡生效控制 |
| 5 | Control | 1、开始多条NFC指令，等命令 2 才能开始刷卡<br>2、多条NFC指令结束，可以启动刷卡 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>11通用附加配置 |
| 4 | MODE | 40 收到 |
| 5 | Control ||

### 5.2.27 基站指纹刷卡生效控制

用于G1答题基站的生产测试模式，暂停指纹核对才能刷卡。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 41 基站指纹刷卡生效控制 |
| 5 | Control | 1、不用指纹核对也可以刷卡<br>2、重新启用指纹核对后才能刷卡（基站也可以重新上电后恢复） |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>11通用附加配置 |
| 4 | MODE | 41 收到 |
| 5 | Control | Conttol值 |

### 5.2.28 基站扫描干扰频点

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 42 基站扫描频点 |
| 5 | Type | 0、基站停止扫描（预留）<br> 1、基站开启扫描（预留）<br>2、读取扫描结果 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>11通用附加配置 |
| 4 | MODE | 42基站扫描频点 |
| 5 | type | 0 <br>1<br>2 -基站报告扫描频点结果 |
| 6 | NUM | 扫描到的频点个数,最大12个<br>目前是干扰频点 |
| 7-18 | FREQ ||


### 5.2.29 基站写信标基础设置

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 43 写基础设置信息<br>44 读基础设置信息 |
| 5 | ATTRIB3 | 对应键盘协议2.2.19内位置 |
| 6 | ATTRIB4 | 对应键盘协议2.2.19内位置 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>11通用附加配置 |
| 4 | MODE | 43 写基础设置信息<br>44 读基础设置信息 |
| 5 | ATTRIB3 | 对应键盘协议2.2.19内位置 |
| 6 | ATTRIB4 | 对应键盘协议2.2.19内位置 |

### 5.2.30 基站写配置模式

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 45 写基站配置模式 <br> 46 读基础配置模式 |
| 5 | mode1 | 0：正常发信标模式   <br> 1:设置为不发信标模式  |
| 6 | mode2 | 0：无意义 1：基站开启回复键盘 监听模式（基站进入键盘升级自动关闭该设置） |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>11通用附加配置 |
| 4 | MODE | 43 写基础设置信息<br>44 读基础设置信息 |
| 5 | mode1 | 0：正常发信标模式   <br> 1:设置为不发信标模式  |
| 6 | mode2 | 0：无意义 1：基站开启回复键盘 监听模式（基站进入键盘升级自动关闭该设置） |

### 5.2.31 AES加密参数设置
政务商务协议5.2.12 是0x61 -23 24,但是在本协议中已做他用(5.5基站上传多包)，所以重新拟定。


SDK向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 37 读取通讯加密参数 <br>38写通讯加密参数 |
| 4 | MODE |写时候有效，加密模式 <br>0 不加密 <br>1无线AES128加密<br>2 AES256加密 <br> 3 写秘钥<br> 4 读秘钥|
| 5 <br><br>5-36| MODE1 | <br>0 加密模式下，新配对使用新的秘钥 <br>1 不使用新秘钥，继续使用上次秘钥 <br><br>写秘钥时，sdk从此字节开始,长度32bytes|
|37-end|default|
基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 37 反馈参数 |
| 4 | MODE |写时候有效，加密模式 <br>0 不加密 <br>1无线AES128加密<br>2 AES256加密 <br> 3 写秘钥<br> 4 读秘钥|
| 5 <br><br>5-36| MODE1 | <br>0 加密模式下，新配对使用新的秘钥 <br>1 不使用新秘钥，继续使用上次秘钥 <br><br>读写秘钥时,基站从此字节开始 ,长度32bytes|
|37-end|default|

### 5.2.32 数据存储接口
sdk在做某些业务时，基站拔插或者更换pc等场景导致某些参数丢失，而无法继续业务；
此接口的作用就是用于保存掉电不丢失的参数，此处的基站仅仅是存储作用。


SDK向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 39 读取参数 <br>40写参数 |
| 4 | LEN |参数个数|
| 5 | DATA | 具体参数，最大57字节|

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 39 反馈参数 |
| 4 | LEN |参数个数 写错误时反馈LEN=0|
| 5 | DATA | 具体参数，最大57字节|

#### 5.2.30.1 参数表
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CustomQuestionNOH | 自定义题编号高字节 |
| 2 | CustomQuestionNOL | 自定义题编号低字节 |
| 3 | AuthorCodeH | 授权码高字节 |
| 4 | AutchorCodeL | 授权码低字节 |
| 5 | LastExamNoH | 在线测验题号高字节 |
| 6 | LastExamNoL | 在线测验题号低字节 |

### 5.2.33 读写基站BIC&PIC码

==基站需保存参数到Eeprom，上电恢复。==
基站原设置字符串的接口保留 ，单最终与改接口只保存2字节参数。那条指令后发 那条生效。不冲突
注意 BIC码二进制不能连续出现3个0或者三个1 。降低RF出错概率，由软件设置具体BIC和品牌码绑定记录。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 51 读基站BIC<br>52 写基站BIC |
| 5-6 | DATA | 2字节 BIC码 |
| 7-10 | DATA | 4字节 PIC码 ASCII 字符串|

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>11通用附加配置 |
| 4 | MODE | 51 读基站BIC<br>52 写基站BIC |
| 5-6 | DATA | 2字节 BIC码 |
| 7-10 | DATA | 4字节 PIC码 ASCII 字符串|


### 5.2.34 读写基站键盘欠费检测开关

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>11 通用附加配置 |
| 4 | MODE | 53 读基站键盘欠费检测<br>54 写基站键盘欠费检测 |
| 5 | DATA | 0关、1开 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>11通用附加配置 |
| 4 | MODE | 53 读基站键盘欠费检测<br>54 写基站键盘欠费检测 |
| 5 | DATA | 0关、1开 |

## 5.3 白名单设置

### 5.3.1 白名单按区设置

用于白名单批次全部更新或读取，软件自己编个循环，按区读取或写，每区10个SN号同时操作，区数和基站有关，例如20区，就是支持200个键盘的名单。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>14 白名单相关配置 |
| 4 | MODE | 1 读取指定区的白名单SN号表<br>2 改写指定区的SN号表 |
| 5 | ZONE | 区号，0-19（最大和基站有关），每区10个SN号<br> 4字节一个SN，高位前，SN号全00表示空<br>注意：写第0区时候基站自动把其他区清除空 |
| 6-9 | SN1 | 第一个SN，高位前，SN号全00表示空 |
| 10-13 | SN2 | 第2个SN |
| 14-17 | SN3 | 第3个SN |
| 18… | SN4---SN10 | 第4到第10个SN |
||||
| …58 || 参数无意义 |

基站应答：（读取和改写都返回，SDK判断是否写正确）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 14 白名单相关配置 |
| 4 | MODE | 1返回对应区的白名单表 |
| 5 | ZONE | 区号 |
| 6-9 | SN1 | 第一个SN，高位前，SN号全00表示空 |
| 10-13 | SN2 | 第2个SN |
| 14-17 | SN3 | 第3个SN |
| 18… | SN4---SN10 | 第4到第10个SN |
| …58 |||

### 5.3.2 白名单单独设置

用于白名单单个或多个单独添加或删除，一次可最多操作10个SN。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br> 14 白名单相关配置<br>17 T2基站白名单单独配置 |
| 4 | MODE | 3 清除白名单SN号表(SN1后数据空)<br> 4 白名单增加SN<br> 5 白名单删除SN（相当于软件单独指定任意键盘）<br>6 查询白名单是否有SN |
| 5 || 空 |
| 6-9 | SN1 | 第一个SN，高位前，SN号全00表示空 |
| 10-13 | SN2 | 第2个SN |
| 14-17 | SN3 | 第3个SN |
| 18… | SN4---SN10 | 第4到第10个SN |
||||
| …58 || 参数无意义 |

基站应答：（读取和改写都返回，SDK判断是否写正确）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型<br> 14 白名单相关配置 |
| 4 | MODE | 对应SDK的MODE值 |
| 5 | STATUS | 0 有失败<br>1 全部执行成功 |
| 6 | SN1\_OK | 第1个SN的执行结果 0 失败 1成功 |
| 7 | SN2\_OK | 第2个SN的执行结果 0 失败 1成功 |
| 8 | SN3\_OK | 第3个SN的执行结果 0 失败 1成功 |
| 9…15 | SN4---SN10 | 第4到第10个SN的执行结果 0 失败 1成功 |
||||

### 5.3.3 基站键盘SN名单管理

T2双基站时候，需要管理可连接键盘SN。

为避免和白名单接口冲突，CMDTYPE改17，其他操作和白名单一致。

### 5.3.4 基站键盘SN名单管理-长包

用于T2基站，1个长指令包读写所有键盘SN名单。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型18 T2基站SN名单管理-长包格式 |
| 4 | MODE | 1 读取名单(仅仅在线)<br> 2 写名单<br> 3 双基站下白名单删除SN，由SDK判断双基站有键盘SN号相同后发出指令，避免老基站占坑 <br>4 锁定键盘，可以n个 <br>5 锁定所有当前在线的键盘 <br>6 解锁键盘<br>7 解锁所有锁定的键盘 <br>8 读取所有名单及离在线状态-从byte7开始4字节SN+1字节的离线(0)在线(1)状态|
| 5 | TYPE | 名单类型，暂1 |
| 6 | NUM | SN的个数 |
| 7-10 | SN1 | 第一个SN，高位前，4字节 |
| 11-14 | SN2 | 第2个SN |
||| 。。。 |
| … || 第NUM个SN |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 应答的基站的编号 |
| 3 | CMDTYPE | 应答类型 <br>18 T2基站SN名单管理-长包格式 |
| 4 | MODE | 对应SDK的MODE值 |
| 5 | TYPE | 名单类型，暂1 |
| 6 | NUM | SN的个数 |
| 7-10 | SN1 | 第一个SN，高位前，4字节 |
| 11-14 | SN2 | 第2个SN |
||||

## 5.4基站下载多包

目的：解决电脑直接和键盘下载多包耗时长的问题；

原理：

修改前：下载多包是电脑与键盘通信，基站仅仅做转发，电脑通过usb多次询问，耗时多；

修改后：电脑将升级的文件数据发送给基站，由基站来完成传输和询问，最后在上报给电脑。

流程：

S1,电脑先把下载键盘的ID或SN表单传给基站—5.4.2节。

S2, 电脑发送进入下载状态指令给基站---5.4.1节，然后基站开始逐个通知键盘进入下载状态—键盘新版协议6.2节；基站将失败的键盘上报给电脑(电脑需要回应表示收到)---5.4.5节；通知完所有键盘后基站告知电脑（有指令，5.4.5节）可以进入下一阶段通信。

S3, 电脑收到基站信号后，开始发送256字节是数据块，每次16字节，分16次完成，基站每次都要对16字节回应，保证数据收到；然后电脑告知基站启动一轮发送，5.4.5节；

S4,基站启动广播发给键盘和查询状态—键盘新版6.3节，基站会将失败的键盘上报给电脑(5.4.5节，电脑需要回应表示收到)；数据块发送给了所有键盘后，基站会告知电脑可以进入下一个数据块的发送（5.4.5节）；重复S3-S4直到完成所有数据。

S5，电脑通知基站退出下载，基站通知所有（包括失败的）键盘退出下载，并报告状态（只报告失败和全部完成，5.4.5节）。

### 5.4.1 开始/结束基站下载多包

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型22 基站下载多包 |
| 4 | MODE | 1 进入或退出下载状态 <br><font color="#FF0000">31 后台静默升级进入或退出下载状态</font>|
| 5 | ID/SN | 1：2字节ID模式; <br>2：4字节SN; <br>3：6字节SN模式 |
| 6 | ~~NC~~ | (DOWNTYPE) 原指令漏了 |
| 7 | DCMD | 模式 1进入下载； 0退出下载； |
||| （以下数据在下载键盘固件时候有效） |
| 8 | a_HVER | 键盘硬件版本 |
| 9-11 | a_SVER | 键盘软件版本，3字节，10进制数字<br>一定要和固件内部版本号相同，便于上位机软件好对比版本，知道键盘升级成功 |
| 12-13 | a_CRC-16 | 固件校验字 |
| 14-17 | a_FILELEN | 固件文件大小，4字节，高位在前 |
| 18 | <font color="#FF0000">a_BR</font>| BR1 硬件分支号 |
| 19 | <font color="#FF0000">b_HVER</font> | 键盘硬件版本 |
| 20-22 | <font color="#FF0000">b_SVER</font> | 键盘软件版本，3字节，10进制数字<br>一定要和固件内部版本号相同，便于上位机软件好对比版本，知道键盘升级成功 |
| 23-24 | <font color="#FF0000">b_CRC-16</font> | 固件校验字 |
| 25-28 | <font color="#FF0000">b_FILELEN</font> | 固件文件大小，4字节，高位在前 |
| 29 | <font color="#FF0000">b_BR</font> | BR2 硬件分支号 |



==红色字体部分为添加的双升级功能中的第二个固件数据==

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>22 基站下载多包 |
| 4 | MODE | 1 进入或退出下载状态 <br><font color="#FF0000"> 31后台静默升级|
| 5 | ID/SN | 1：2字节ID模式; <br>2：4字节SN; <br>3：6字节SN模式 |
| 6 | ~~NC~~ ||
| 7 | DCMD | 模式 1进入下载 0退出下载 <br><font color="#FF0000"> 2 基站已有相同文件，无需下载，升级结束|
| 8 | HVER | 键盘硬件版本 |
| 9-11 | SVER | 键盘软件版本，3字节，10进制数字<br>一定要和固件内部版本号相同，便于上位机软件好对比版本，知道键盘升级成功 |
| 12-13 | CRC-16 | 固件校验字 |
| 14-17 | FILELEN | 固件文件大小，4字节，高位在前 |
||||

### 5.4.2 下载指定升级键盘的ID/SN号给基站

电脑分多次将ID/SN号传输给基站。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>22发送升级键盘的ID/SN |
| 4 | MODE | 2 下载ID/SN表单 |
| 5 | ID/SN All | 升级键盘的总个数 |
| 6 | ID/SN PACK | 当前包序号，从0开始 |
| 7-54 | ID/SN | 7-12 SN1; 13-18 SN2; 19-24 SN3….<br>6字节SN，高位在前,每次可下8个SN键盘；不够的用0xFFFF填补 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>22基站下载多包 |
| 4 | MODE | 2 下载ID/SN表单 |
| 5 | ID/SN All | 升级键盘的总个数 |
| 6 | ID/SN Current | 当前包序号，从0开始 |
| 7-54 | ID/SN | 7-12 SN1; 13-18 SN2; 19-24 SN3….<br>6字节SN，高位在前,每次可下8个SN键盘；不够的用0xFFFF填补 |

### 5.4.3电脑发数据包给基站

流程上可以电脑向基站主动发送（在基站报告本次发送完成后），也可以基站主动申请要。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>22基站下载多包 |
| 4 | DOWNCMD | 4 下载具体数据--16字节 <br>6 下载具体数据—512字节每片段 <br>7 下载具体数据---64字节（48字节有效，区别于4类型的16字节有效） 10 基站问64字节包（根据代码补充）<br>11 基站问512字节包（根据代码补充） <br><font color="#FF0000">37  后台静默升级；sdk向基站发送固件数据(相当于普通模式下7)|
| 5 | DOWNTYPE | 多包类型<br>30 短信广播信息（SDK组包模式） |
| 6 | DOWNID | 数据包标识码（DOWNTYPE=30时，是总包数）<br>文件下载模式时候是最高位地址 V4.52<br>由于非文件下载模式PACKH加上PACKL，只能下载65536字节，文件下载模式为支持大文件，用DOWNID作为高位地址，可以下载16384K字节 |
| 7 | PACKH | 数据段编号，0-255 |
| 8 | PACKL | 数据片编号， 0-15（每片段16字节） ; <br>如果是每次512字节的PACKDATA，PACKL=0和1，1K数据传输2次；48字节的传22包(0-21) |
| 9-24 | PACKDATA | 16字节的数据，48字节数据 或 512字节的数据（对应usb1024字节长包指令） |

备注：参数的具体意义见表决器协议6.3

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>22基站下载多包 |
| 4 | MODE | 4下载具体数据的应答或请求具体数据<br>6 下载具体数据的应答或请求传输—512字节每片段<br>7 下载具体数据（48字节有效）<br><font color="#FF0000">37  后台静默升级； |
| 5 | DOWNTYPE | 多包类型 |
| 6 | DOWNID | 数据包标识码<br>文件下载模式时候是最高位地址 V4.52<br>由于非文件下载模式PACKH加上PACKL，只能下载65536字节，文件下载模式为支持大文件，用DOWNID作为高位地址，可以下载16384K字节 |
| 7 | PACKH | 数据段编号，0-255 |
| 8 | PACKL | 数据片编号， 0-15<br>如果是每次512字节的PACKDATA，PACKL=0和1<br>如果是每次64字节的PACKDATA，PACKL=0-21 基站保存1K数据再发给键盘 |
| 9-24 | PACKDATA | 16字节的数据<br>或 512字节的数据（对应usb1024字节长包指令）<br>48字节有效数据 |

### 5.4.4电脑通知基站本次数据块发送完毕

用于SDK主动控制数据块传输的过程。SDK是分片段传输，基站被动响应，并不知道数据块传输完成，所以留给SDK控制，基站收到这条指令后，就开始向键盘下载这块数据。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>22基站下载多包 |
| 4 | DOWNCMD | 5 本次数据块下载完成 |
||||
||||

备注：参数的具体意义见表决器协议6.3

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>22基站下载多包 |
| 4 | MODE | 5本次数据块下载完成 |
||||
||||

### 5.4.5基站主动发送 键盘更新状态

基站主动发送状态：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>22基站下载多包 |
| 4 | MODE | 6 上报状态<br>9 上报状态，告诉sdk,底层键盘固件升级完成<br>10 向sdk请求（索要）数据包（数据包以1K为单位）byte6之后的数据无效 <br><font color="#FF0000"> 39 后台静默升级 上报状态(相当于普通模式下的9) <br><font color="#FF0000"> 38 后台静默升级 向sdk请求（索要）数据包（数据包以1K为单位）(相当于普通模式下的10) |
| 5 | PACKH | 数据段编号，0-255<br>申请的数据包号PACK\_H |
| 6 | PACKL | 数据片编号， 0-15<br>申请的数据包号PACK\_L |
| 7 | Update status | 2-失败；（包括通知键盘进入下载和数据块下载失败；）<br>1-全部完成，电脑可以下一个流程（包括本次256字节成功、键盘进入下载、键盘退出下载） |
| 8-13 | Keypad ID/SN | ID/SN 号，固定6字节, 高位在前 |
| 14 | HW |键盘硬件版本  |
| 15-24 | NC | 参数无意义 |

电脑确认：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>22基站下载多包 |
| 4 | MODE | 6 上报状态 |
| 5 | PACKH | 数据段编号，0-255 |
| 6 | PACKL | 数据片编号， 0-15 |
| 7 | Update status | 2-失败；（包括通知键盘进入下载和数据块下载失败；）<br>1-全部完成，电脑可以下一个流程（包括本次256字节成功、键盘进入下载、键盘退出下载） |
| 8-13 | Keypad ID/SN | ID/SN 号，固定6字节, 高位在前 |
| 14-24 | NC | 参数无意义 |

### 5.4.6T2soc基站说明

1、多包下载的数据传输(键盘固件升级)，增加每次传512字节，见5.4.3节

2、维持原先SDK控制下载流程的方式

3、基站和模块之间的SPI指令沿用本指令体系，只是BaseID相当于ModelID

4、本流程一样适用于模块固件升级，只是少SN号指定步骤

5、基站主控收到一段数据后，给模块分别发送，然后模块对自己带的键盘进行下载

6、下载失败的键盘报告给主控

7、本模块键盘下载一段完成，模块报告基站主控

8、基站主控判断全部模块完成本段数据，报告给sdk

9、sdk再传输下一段数据

## 5.5基站上传多包

目的：键盘上传多包提速，用于键盘上传课后练习结果；

【SDK主动模式】

原理：

修改前：上传多包是电脑SDK与键盘通信，基站仅仅做转发，电脑通过usb多次询问，耗时多；

修改后：电脑将要取多包的类型、对应键盘的SN或ID告诉基站，由基站来完成传输和询问，数据动态上报给电脑。一次只支持1个键盘取包，取包完成，SDK才能执行新的取包。

流程：

S1, 应用软件开启收作业模式时候，键盘先提交多包申请，SDK解析传给应用软件，应用软件先记录下键盘SN和多包类型。

S2, 应用软件调用SDK，向基站发送5.5.1节的开始基站上传多包，基站应答1表示收到指令，这时候SDK要停止询问数据的流程，等待基站报告数据和状态

S3,基站按键盘的多包上传流程执行，先点名，然后获取数据长度，然后查询。如果点名失败或者取包失败，基站用5.5.2节报告失败，如果最终成功，也报告成功

S4，成功或者失败，SDK都会重新开始前面停下的询问数据流程；注意，基站上报状态是不需要SDK应答的，只发送一次，为避免sdk接收漏掉，SDK要做超时判断，例如5秒没有状态报告，就认为失败；

S5，基站执行取包过程中所有键盘的应答，对应键盘协议4.1、4.2、4.3节的所有键盘的应答，基站都会转发给SDK，原有SDK对多包应答的处理可以不动，其实主要就是对4.2节多包数据片段的保存和组合

### 5.5.1 开始/结束基站上传多包（SDK主动模式）

适用于SDK主动模式，电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>23 基站上传多包 |
| 4 | MODE | 1 进入取多包模式<br> 0 停止取多包模式 |
| 5 | ID/SN | 1：2字节ID模式; <br>2：4字节SN; <br>3：6字节SN模式 |
| 6-11 | IDSN | ID或SN，高位前<br>ID模式下前2字节有效，SN4模式下前4字节有效 |
| 12 | PACKTYPE | 多包类型，这和键盘提交的多包申请里的类型一致 |
| 13 | PACKID | 数据包辨别码，一般是0，和键盘提交的多包申请里数据一致 |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>23 基站上传多包 |
| 4 | STATUS | 1 收到指令 |
||||
||||
||||

### 5.5.2 基站报告执行状态（改3.3.4节）

参见3.3.4节基站多包上传状态报告。

下面指令仅是参考，不适用。

~~基站主动向电脑发送：~~

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br> ~~23 基站上传多包状态~~ |
| 4 | MODE | 2 键盘点名失败 <br>3 取包失败<br>4 取包完成 |
| 5 | ID/SN | 1：2字节ID模式; <br>2：4字节SN; <br>3：6字节SN模式 |
| 6-11 | IDSN | 键盘的ID或SN |
||||

注意：由于5.8G系统基站取多包2.5ms内能取6包，USB透传键盘0xA0的应答数据，SDK实测会丢包，所以键盘包数据改成投票结果类结果传输

### 5.5.3 基站主动模式

&emsp;&emsp;当键盘申请多包上传时候，基站不会转发申请给SDK，而是自动转多包接收，完成多包的收取（包含数据暂存），然后向SDK报告多包接收成功（3.2.4节基站多包状态报告），然后SDK收取基站暂存的多包内容。

&emsp;&emsp;如果基站接收失败，也会向SDK报告，同样在3.3.4节。

### 5.5.4 SDK询问基站多包数据

SDK收到3.2.4节里面基站申请提交多包数据后，根据每包长度，依次读取。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>23 基站上传多包 |
| 4 | MODE | 2 取基站多包数据 |
| 5 | PACKTYPE | 多包类型，这和键盘提交的多包申请里的类型一致 |
| 6 | PACKID | 数据包辨别码，一般是0，和键盘提交的多包申请里数据一致 |
| 7-8 | DATALEN | 每次应答片段数据长度，short，高位前<br>等同于申请包里面的DATALEN，不要变 |
| 9-10 | PACKNO | 片段编号，1开始，最大值=申请包的PACKLEN/DATALEN |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 基站编号 |
| 3 | CMDTYPE | 基站管理命令类型<br>23 基站上传多包 |
| 4 | MODE | 2 取基站多包数据 |
| 5 | PACKTYPE | 多包类型 |
| 6 | PACKID | 数据包辨别码 |
| 7-8 | DATALEN | 每次应答片段数据长度，short，高位前<br>等同于申请包里面的DATALEN，不要变 |
| 9-10 | PACKNO | 片段编号，1开始 |
| 11-12 | CRC16 | DATA段数据的效验值 |
| 13-16 || 空 |
| 17- | DATA | 从第17字节开始，共DATALEN字节数据 |

## 5.6基站下载单包

目的：键盘单包下载指令提速，用于下发姓名、自定义文字信息等，而且支持SDK连续写入多条；

原理：

修改前：下载单包是电脑SDK与键盘通信，基站仅仅做转发，SDK多次询问，判断收到键盘应答才停止，一般100ms一个间隔，时间较长；

修改后：

1、SDK告诉基站要执行的单包下载的内容，然后由基站执行对键盘的单包下载，间隔可以调整到10ms保证键盘可靠应答（键盘代码如果先应答再执行可加快速度），如果收到键盘应答就转发给SDK（和原来类似），如果10ms没收到键盘应答就重发（原来是SDK判断超时重发），重发次数可以根据实际情况调整，比如可先定10次，如果10次键盘没应答就向SDK报告执行失败。

2、基站内部有队列，SDK可以连续写入多条单包下载指令，队列数目可以暂定60（相当于1次可写60个键盘信息），如果满了向SDK报告队列满，没法执行；

3、基站还是每次执行队列中的1条，成功就清除，空出队列空间；失败的时候可以马上清除，也可以优化，例如放到队列后面，重新执行1次（有些键盘一下子无线不行，过会就好了）

4、基站执行下载单包的时候，还是要注意间隔性地插入投票信标取包过程，避免长时间执行单包下载导致键盘离线或没法提交数据；

5、由于键盘单包下载SN位置有不同，有6字节19-24位置的，也有4字节5-8位置的，所以可以先只对第11类的读写个人信息指令执行基站下载模式；

6、由于SDK要向应用反馈执行结果，而且可能是1个键盘连续写多个信息，所以有1个指令流水号，SDK内部向基站写指令的时候，也通过队列记录SN号和执行的操作类型，等基站反馈执行结果的时候，通过流水号好取出对应的键盘SN和操作类型反馈给应用，也好删除队列中的记录；

### 5.6.1基站下载单包

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>27 基站下载单包 |
| 4 | DataPos | 下载单包指令流水号，每次加1，用于分辨执行结果，SDK自动维护 |
| 5 | KEYCMD | 一般是0x30，对应键盘单包指令的KEYCMD字节 |
| 6-30 | Datas | 25字节，从KEYCMD算起，一般是26字节 |
|| （CRC） | SDK指令不用加CRC，基站发的时候，根据版本填写CRC |
||||
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>27基站下载单包 |
| 4 | DataPos | 对应写入的DataPos，用于SDK好判断哪条写指令的结果 |
| 5 | STATUS | 1 收到指令 <br>2 基站队列满，没法执行 <br>3 执行ok <br>4 执行错误（键盘超时没有应答） |
||||
||||

如果键盘有应答，基站向SDK转发键盘的0xB0应答外，还要同时报告成功，注意DataPos值要对，SDK要根据DataPos值来删除队列和反馈SN给应用。

### 5.6.2 T2Soc基站下载单包-长包1024字节

电脑向基站发送：（也可用于基站主控向模块发送）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>28 T2Soc基站下载单包 |
| 4 | DataPos | 下载单包指令流水号，每次加1，用于分辨执行结果，SDK自动维护 |
| 5 | Format | 格式，暂定1 |
| 6 | CMDNUM | 后面单包下载指令数目，每条58字节，最多17条 |
| 7 || 空 |
| 8-65 | CMD\_1 | 第一条指令58字节，第1个字节对应键盘单包下载指令的0x38指令码 |
| 66.. | CMD\_2 | 第2条指令58字节 |
|| …. | 第N条指令58字节… |
||||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 28基站下载单包 |
| 4 | DataPos | 对应写入的DataPos，用于SDK好判断哪条写指令的结果 |
||||

### ~~5.6.3 基站下载单包失败报告（改3.2.1节）~~

考虑到主动报告流程需要应答确认，已经改为3.2.1节当成投票结果来报告。

~~基站主动发送：（使用5.6.1节的应答结构和命令码）~~

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型<br>27基站下载单包 |
| 4 | DataPos | 对应写入的DataPos，用于SDK好判断哪条写指令的结果 |
| 5 | STATUS | 4执行错误（键盘超时没有应答） |
| 6 | CMD | 0x38 键盘命令码，快速设置是0x38<br>其实从本字节开始的N个字节，都是对应设置指令的，这样SDK配合DataPos能准确判断键盘是哪个指令执行失败，注意基站要准确返回DataPos |
| 7-10 | SN | 执行失败的键盘SN，4字节 |
| 11 | KCMD | 快速设置的哪个类型的指令 |
||||

SDK应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 27基站下载单包 |
| 4 | DataPos | 基站送回的DataPos |
| 5 | STATUS | 4执行错误收到 |

## 5.7 组网相关【T2soc】

&emsp;&emsp;本章节用于T2Soc多模块基站的组网功能用到的SPI指令。架构上基站主控芯片负责和SDK的通讯，然后通过SPI给各模块指令和收取数据，具体的业务操作都是模块Soc完成。

### 5.7.1模块配置

基站主控上电的时候，先对各模块进行配置。

基站主控向模块发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | MD\_ID | 指定的模块接收，1-4，为0时候不指定，一般是0 |
| 3 | CMDTYPE | 30 组网相关 |
| 4 | CMD | 1 模块配置 |
| 5 | MODULE\_ID | 设置模块编号，1-4，主模块编号1 |
| 6 | IDNUM | 模块总数量1-4，相当于用几个模块 |
| 7-10 | MATCHCODE | 配对码，4字节 |
| 11-14 | FREQ1-4 | 4字节，频点1-4，频点1是主频点 |
| 15 | NODEMAX | 每频点带键盘最多数目 |
||||

模块应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | MD\_ID | 应答的模块ID |
| 3 | CMDTYPE | 30 模块配置指令应答 |
| 4 | CMDACK | 1 模块配置应答 |
| 5 |||

### 5.7.2组网状态报告

模块向基站主控发送：（或者主控转发给模块）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | MD\_ID | 模块编号 |
| 3 | CMDTYPE | 30 组网相关 |
| 4 | CMD | 2 组网状态报告消息<br>3 转发组网报告（基站把CMD2转发成3） |
| 5 | STATUS | 0 离线 1在线（入网） |
| 6 | MD\_REP | CMD=2的时候要转发消息的模块的编号<br>CMD=3的时候，是消息来源的模块ID |
| 7-10 | KEYSN | 键盘SN，4字节 |
| 11 | HW | 键盘硬件代号 |
| 12-14 | SW1-SW3 | 键盘固件版本，3字节 |
| 15 | VOLT | 电池电压 |
||||

接收方应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | MD\_ID | 模块ID，主控芯片ID=0 |
| 3 | CMDTYPE | 30 模块配置指令应答 |
| 4 | CMDACK | 2 组网状态报告收到<br>3 离线收到 |
||||

备注：

4模块之间要共享组网信息，主要是副模块要知道有新键盘安排给我，和主模块知道副模块有键盘离线。

入网操作只在主模块1上执行，所以入网报告都是主模块发起的，基站主控芯片收到后，如果MD\_REP不是1，就还要把相同的报告通过CMD3报告给模块MD\_REP，这样模块MD\_REP知道有1个键盘安排到自己的频点。

离线报告的时候，都是各模块独立报告，SDK收到后，如果MD\_REP=1，要转发给主模块。

所以各模块发消息的时候，自己处理好MD\_REP的值。

### 5.7.3入网键盘信息汇总

基站主控向主模块发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | MD\_ID | 1或0，基站主控只询问主模块 |
| 3 | CMDTYPE | 30 组网相关 |
| 4 | CMD | 4 读取在线键盘信息 |
| 5 | MODULE\_ID | 询问那个模块的在线键盘情况，1-4<br>如果有4个模块，就询问4次 |

模块应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | MD\_ID | 1，主模块 |
| 3 | CMDTYPE | 30 模块配置指令应答 |
| 4 | CMDACK | 4 读取在线键盘信息应答 |
| 5 | MODULE\_ID | 哪个模块ID的情况 |
| 6 | NUMS | 在线键盘数目 |
| 7 | INFOTYPE | 1 状态格式1，每个键盘信息共10字节 |
| 8 | NOP | 空，备用 |
| 9-12 | KEYSN | 4字节键盘SN |
| 13-16 | HW-SW3 | 4字节，键盘类型代码，SW1-SW3 |
| 17-18 | VOLT-NOP | 1字节电压值，1字节空 |
||| 下1个键盘的信息 |
||||

备注：SDK向基站询问时候，也可以遵照本指令，基站相当于模块1。

### 5.7.4 SDK读在线键盘

SDK向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 基站编号，0广播 |
| 3 | CMDTYPE | 30 组网相关 |
| 4 | CMD | 5 读取在线键盘信息 |
| 5 |||

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 基站编号 |
| 3 | CMDTYPE | 30 模块配置指令应答 |
| 4 | CMDACK | 5读取在线键盘信息应答 |
| 5 | OK | 1收到 |
| 6-7 | TOTAL | 在线键盘数目，高位前 |

具体键盘SN号通过基站报告状态类返回，具体3.2.3节在线键盘状态报告。

## 5.7 测试相关

用于基站进行自动测试，或者返回LOG信息。

SDK向基站发送：（T2soc基站主控转发给模块）

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | MD\_ID | 指定的模块接收，1-4，为0时候不指定，一般是0 |
| 3 | CMDTYPE | 31 测试相关 |
| 4 | TESTMODE | 测试模式 <br>1、载波测试 ，MODE1是频点 <br>2、指定键盘进行通讯测试，测试结果通过LOG结果返回 MODE1-MODE4是SN号 <br>3、模拟产生投票结果，MODE1、2是结果条数量，高位前然后SDK或应用统计接收到的结果数量，显示出来 |
| 5 | MODE1 | 参数1 |
| 6 | MODE2 | 参数2 |
| 7 | MODE3 ||
| 8 | MODE4 ||
||||

基站s应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | MD\_ID | 应答的模块ID |
| 3 | CMDTYPE | 31 测试指令应答 |
| 4 | CMDACK | 1 收到 |
| 5 |||

## 5.8 基站组合多包-新

用于64字节包基站，组合成长包与基站通信，1个长指令包读写与基站通信。

电脑向基站发送：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 19 短包组合长包 |
| 4 | PackMax | 总包数量 总共这包包含多少个64字节的包 |
| 5 | PackCurrent | 当前包号 从1开始 第几包。 |
| 6-7 | CRC-16 | 从8开始计算 全部Data的CRC校验 |
| 8-End | Data | 原包指令数据 末尾数据补0 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令应答 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 19 短包组合长包 |
| 4 | PackMax | 总包数量 总共这包包含多少个64字节的包 |
| 5 | PackCurrent | 当前包号 从1开始 第几包。 |
| 6-7 | CRC-16 | 从8开始计算 全部Data的CRC校验 |
| 8-End | Data | 原包指令数据 |

目前实现是Sdk送一次，基站应答一次，直到sdk送完所有包。

### 5.8.1 CMDTYPE概述

具体数据包格式，由data数据段拼接后，头一个字节决定后面数据的解析。

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMDTYPE | 类型 <br>1：单包下载 <br>2：单包下载ACK <br>3：扩展信标预置<br> 4：扩展信标预置ACK<br> 5、（带题干文字内容的）测验题|
| N | Data | 数据详细内容根据指令不同解释不同 |

### 5.8.2 组合多包-快速下发

电脑向基站发送：（也可用于基站主控向模块发送）
基站应答：
使用5.8协议外层包裹打包成（最大）1024数据长度【sdk并没有按这种方式实现】
Data 为下载单包具体内容 具体为：

指令下发：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMDTYPE | 1 单包下载内容 |
| 2 | DataPos | 下载单包指令流水号，每次加1，用于分辨执行结果，SDK自动维护 |
| 3 | Len1 | SN1+Tr\_Count+Data1 长度 1 Byte |
| 4-7 | SN1 | Sn号 4 Byte |
| 8 | Tr\_Count | 传输序号 1 Byte |
| 9 | Data1 | 单包下载内容 N Byte |
|| Len2 | SN2+Data2 长度 |
|| SN2 | Sn号 |
|| Tr\_Count | 传输序号 |
|| Data2 | 单包下载内容 |
|| Len3 | SN2+Data2 长度 |
|| SN3 | Sn号 |
|| Tr\_Count | 传输序号 |
|| Data3 | 单包下载内容 |
| 。。。 | 。。。 | 。。。 |

基站应答：【sdk连续发完多包，然后基站应答的方式才用到】

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMDTYPE | 2 单包下载内容应答 |
| 2 | DataPos | 对应写入的DataPos，用于SDK好判断哪条写指令的结果 |
||||

### 5.8.3 组合多包-扩展信标

电脑向基站发送：（也可用于基站主控向模块发送）
基站应答：
使用5.8协议外层包裹打包成（最大）1024数据长度
具体为：
扩展信标预置，在下轮《设置投票模式信标》开始生效，生效时基站将17信标中MODE的BIT7位置1，并周期性在17信标前发送0x34扩展投票信息（键盘协议2.5节）。

指令下发：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMDTYPE | 3 扩展信标预置，在下轮《设置投票模式信标》开始生效 |
| 2 | DataPos | 下载单包指令流水号，每次加1，用于分辨执行结果，SDK自动维护 |
| 3-4 | LEN | 有效Cmd\_Data 长度 |
| N | Cmd\_Data | 键盘协议Cmd\_Data数据 |

基站应答：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMDTYPE | 4 扩展信标预置应答 |
| 2 | DataPos | 对应写入的DataPos，用于SDK好判断哪条写指令的结果 |

### 5.8.4 组合多包-测验题内容

指令下发：

| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | CMDTYPE | 5 测验题内容 |
| 2- || 本字节开始是键盘协议的测验题内容<br>比如2.4.5节的type开始的数据 |
||||


## 5.9 sdk下载多包给基站
20231106 目前键盘固件升级速度慢的原因是：sdk与基站多次通信消耗大量时间。
类似的速度受限的功能模块还有：基站固件升级，快速下发，广播...
解决办法：将sdk与基站重复多次一问一答 改成 sdk连续多次下发，最后在问答下发情况。
举例：如果sdk要1500bytes下发给基站
step1:5.9.1 sdk下发数据信息，DATA_total=1500;DATA crc =?byte per PACK=64;
收到基站的回应后
step2:连续24次发送纯数据，每包64，最后一包28bytes有效；
step3：sdk询问 数据是否接收正确;基站回复，如果不正确 sdk重复step1;

### 5.9.1 sdk发送数据信息
电脑向基站发送：
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型41 sdk下载多包 |
| 4 | type | 1 要下载的数据信息 |
| 5 | DATA-type | 1：基站固件升级 <br>2：键盘固件升级;  <br>3：快速下发; <br>4：广播 <br><font color="#FF0000">32：后台静默升级键盘固件;|
| 6-9 | DATA_total| 数据总字节数 高位在前 |
| 10-11 | DATA crc | 数据crc 高位在前|
| 12-13 | byte per PACK |高位在前 每包数据最大字节长度：64... |
| other | default |  |


基站应答：
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型41 sdk下载多包 |
| 4 | type | 1 要下载的数据信息 |
| 5 | DATA-type | 1：基站固件升级 <br>2：键盘固件升级; <br>3：快速下发; <br>4：广播 |
| 6-9 | DATA_total| 数据总字节数 高位在前|
| 10-11 | DATA crc | 数据crc 高位在前|
| 12-13 | byte per PACK |高位在前 每包数据最大字节长度：64 |
| other | default |  |

### 5.9.2 sdk连续发送N包纯数据包，基站无需回复

### 5.9.3 sdk发送询问
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型41 sdk下载多包 |
| 4 | type | 2 询问基站 |
| 5 | DATA-type | 1：基站固件升级 <br>2：键盘固件升级; <br>3：快速下发; <br>4：广播 <br><font color="#FF0000">32：后台静默升级键盘固件;|
| 6-9 | DATA_total| 数据总字节数 高位在前|
| 10-11 | DATA crc | 数据crc 高位在前|
| 12-13 | byte per PACK |高位在前 每包数据最大字节长度：64 |
| other | default |  |

基站应答：
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型41 sdk下载多包 |
| 4 | type | 2 询问基站 |
| 5 | DATA-type | 1：基站固件升级 <br>2：键盘固件升级; <br>3：快速下发; <br>4：广播 |
| 6-9 | DATA_total| 数据总字节数 高位在前|
| 10-11 | DATA crc | 数据crc 高位在前|
| 12-13 | byte per PACK |高位在前 每包数据最大字节长度：64 |
| 14 | result | 1-正确;0-错误 |
| other | default |  |


## 5.10 sdk获取键盘名单
电脑向基站发送：
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0x61 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型42  |
| 4 | seq | 获取序号 从0开始 |
|  |  |  |


基站应答：
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 1 | BASECMD | 0xE1 基站管理类指令 |
| 2 | BASEID | 指定的基站编号，为0时候不指定 |
| 3 | CMDTYPE | 基站管理命令类型42 |
| 4 | seq | 获取序号 |
| 5 | count | 本次有效键盘个数 ；小于7个(包括0)表示结束 |
| 6-9 | kp1_SN| 第1个键盘sn |
| 10 | kp1_state | 第1个键盘状态:0-离线;1-在线|
| 11-13 | kp1_ver |第1个键盘版本号|
| 14 | kp1_volt | 第1个键盘电量|
| ... | ... | ... |
| 50-53 | kp6_SN| 第6个键盘sn |
| 54 | kp6_state | 第6个键盘状态:0-离线;1-在线|
| 55-57 | kp6_ver |第6个键盘版本号|
| 58 | kp6_volt | 第6个键盘电量|






# 六、版本历史

V0.5 新体系基础框架。

V0.6 增加3.2.3新考勤打包格式，增加5.2.2节考勤射频衰减值设置

V0.7 5.2.1节增加免配对同频和多频点SN模式的类型；（键盘协议部分增加的键盘主动发信模式，不用更改3.2.1节的打包格式；）增加5.2.3节SDK握手，告知PC后台传数据正常，可以给键盘发确认包；增加5.2.4节TCPIP网络设置；增加5.2.5节设置考勤、心跳、基站测试模式；

V0.75增加白名单模式，可设置SN号白名单，增加5.3节

V0.76基站设置增加考勤基站去重设置5.2.6节，5.2.1节补充附加配置的模式列表

V0.8版本，增加了序列号和编号同时传的数据包打包格式，修改了3.2.1节和3.2.2节；加上5.2.7节软件狗，并支持基站UID读取；

V0.9

1. 拷贝原商务体系基站下载多包5.4节，原先用于无线升级键盘固件提速
2. 完善2.3.2节设置基站广播信标发送内容
3. 2.1节基站配置修改成套装、白名单模式，白名单支持智能和授权
4. 2.8节基站特性增加快速配对低功率控制
5. 增加5.2.9节wifi基站状态控制显示

V0.93

完善了K1使用到的基站广播信息，2.3节

V0.94

1、增加5.5节基站取多包，用于A1取课后作业结果

2、增加基站NFC刷卡写姓名学号等，5.2.10节

3、刷卡指令根据G1要求，增加股东姓名、股权数、应答SN支持6字节和编号ID返回

V0.95

1、增加2.4节设置扩展投票信标，以支持新东方的自定义题型提示

V0.96

1、2.3.2节的设置200题型，支持sdk回读，用于sdk崩溃后恢复

V0.97

增加3.2.8节，用于处理状态报告带16字符姓名时候，基站和SDK不好兼容老协议的问题

V0.98

增加5.6节 基站下载单包

V0.99

1、增加5.7节组网相关，先用于T2Soc语音系统的模块SPI指令。

2、增加5.6.2节T2Soc基站单包下载长包指令

3、SDK和主控之间的多包下载具体数据，每片段16字节改512字节

4、支持S6soc新升级方法，修改5.4.3节和增加5.4.5节

5、5.2.4节增加MQTT服务器设置

6、增加5.2.11节usb还是tcp传输数据设置

V0.99-5

1、增加5.2.12节（T2）基站容量设置，白名单没动

V0.99-6

1、增加3.3节基站主动报告结果类，当成键盘结果提交

2、增加5.3.3节基站键盘SN名单管理

V0.99-7

1、增加5.2.13节基站测试模式（老商务协议体系的指令）

V0.99-8

1、增加3.2.2节基站自检结果报告类型

V0.99-9

1、5.2.13节增加基站受控蜂鸣器响一声，提示用户基站连接上

2、增加5.7.4节SDK读键盘在线状态；

3、增加3.2.3节键盘在线状态汇报；

4、基站NFC写键盘姓名，5.2.10节增加48字节姓名模式

5、完善基站多包上传，主要是增加5.5.3节基站主动模式说明，和3.2.4节多包状态报告

6、增加5.5.4节SDK问基站要多包上传数据

7、增加3.3.5节NFC刷卡消息—容量满

8、NFC刷卡消息—增加正常刷卡报告

9、5.2.13节增加NFC刷卡进音质测试模式

V0.99-10

1、3.3.5节刷卡消息，增加首个键盘被移出消息

2、增加5.3.4节，基站白名单长包读写

V0.99-11

1、5.4.3节多包数据下发增加短信息

2、基站上报状态，增加调试log信息上报3.3.6节

3、增加5.2.14节，读取基站调试信息

V0.99-12

1. 增加5.2.15节SDK退出通知
2. 3.5节刷卡消息增加键盘在线数目
3. 3.4节 白名单增加删除基站键盘SN
4. 3.4节 基站名单增加锁定和解锁

V0.99-13

1. 基站名称重新定义指令，原先改成密码了，SDK不好兼容，5.2.1节通用配置
2. 密码也改成2字节，原先3字节

V0.99-14

1. 新增5.8章 组合多包方式 基站&SDK通信传输数据

V0.99-15

1、5.8.2节基站组合多包传输，增加传输题干测验数据表模式

2、增加5.2.16节NFC指纹管理

3、增加5.2.17节NFC写指定配对码，和对应的回报消息3.3.5节增加

4、增加5.2.18节管理指令清空

5、增加2.5节空闲信标参数

V0.99-16

1. 添加5.2.16读写基站字符串
2. 删除2.5节空闲信标参数
3. 增加5.2.20 5.2.21基站空闲设置

V0.99-17

1. 增加5.2.22读写基站组网公开位

V0.99-18

1、加5.2.34 基站复位

2、修改5.2.10节NFC写姓名的应答

3、增加5.2.24节基站刷卡清空指纹和姓名

V0.99-19

1. 增加5.2.26节，多条NFC指令执行控制
2. 增加5.2.27节，可暂停指纹核对后才能刷卡

V0.99-20

1、增加5.2.28节基站扫描干扰频点