<br>
<br>
<br>

<div  style="text-align: center;font-size: 70px;">
WSCmdApp协议接口说明
</div>


<div  style="text-align: center;font-size: 30px;">
Ver5.1.13
</div>
<br>
<br>
<br>
<br>
<br>
<br>

<div  style="text-align: center;font-size: 30px;">
长沙中天电子设计开发有限公司
</div>

<br>

<div  style="text-align: center;font-size: 30px;">
二〇二四年十一月
</div>

<br>
<br>
<br>
<br>

文件控制：

文件名：WSCmdApp接口说明

起草人：陈定敏

最新版本作者： 刘琴
<br>
<br>
| 文档版本 | 日期 | 作者 | 版本说明 |
|---|---|---|---|
|5.1.1| 2023年10月09日|陈定敏|1.  初始版|
|5.1.2| 2023年11月07日|陈定敏|1.  增加配对模式设置接口|
|5.1.3| 2023年11月15日|陈定敏|1.  更新语音题接口参数|
|5.1.5| 2023年12月28日|陈定敏|1.  增加Json指令支持基站id和基站SN两种模式|
|5.1.6| 2024年02月19日|陈定敏|1.  增加keypadRemoteControl接口<br>2.  增加举手功能接口|
|5.1.7| 2024年04月22日|陈定敏|1.  增加后台签到接口<br>2.  增加键盘最终提交状态接口|
|5.1.8| 2024年07月01日|陈定敏|1.  投票反馈数据增加电池状态|
|5.1.9| 2024年07月19日|陈定敏|1.  增加获取SDK版本接口|
|5.1.10| 2024年09月03日|陈定敏|1.  移去主动获取在线信息接口|
|5.1.12| 2024年11月01日|刘琴|1.  修改writeKeyMessage接口中keySnList说明|
|5.1.13| 2024年11月29日|刘琴|1.  修改immediateFeedback、<br>keypadRemoteControl接口中增加keyId参数|
<!-- |5.1.11| 2024年10月17日|刘琴|1.  增加设置基站容量的接口| -->
<br>

[TOC]

# 系统概述

WSCmdApp
无线反馈系统是由手持的键盘、通讯基站、WSCmdApp（控制台程序）、控制电脑组成的。控制电脑通过USB接口与基站连接。控制指令由控制电脑通过基站发送给键盘。

WSCmdApp可以让用户开发的应用程序与WSCmdApp无线反馈系统通讯。WSCmdApp控制台程序（下文用WSCmdApp代替）提供websocket通讯方式，使用JSON通信格式，来实现互动系统的管理及投票指令的发送和接收功能。调用结构图如下：![](img/image1.png)

如果用户想开发互联网应用，可以参考如下设计：

![](img/image2.png)

目前WSCmdApp只支持Windows系统。用户只需运行WSCmdApp程序即可。

WSCmdApp程序中config.ini配置文件中可设置WebSocket的端口，见以下位置：

![](img/image3.png)

config.ini 文件关键字解释说明：
role： WSCmdApp当前WebSocket运行模式；client：客户端模式，server：服务端模式。
ip: 需要访问的WebSocket服务器的ip地址，此参数在客户端模式下有效
port: WebSocket通讯的端口地址
heartBeatOnOf:心跳判定开关，此参数配合协议文档中的“心跳”指令使用。
当参数配置为0: WSCmdApp会配合的回复对应参数，不进入心跳检测程序，
当参数配置为1: WSCmdApp会配合的回复对应参数，进入心跳检测程序。
heartbeat: 心跳间隔时长 范围：10-60 单位秒
当heartBeatOnOff配置为1，并且WebSocket运行模式为客户端时，进入心跳检测程序后，在单位时间没有收到心跳指令，WebSocket客户端会重启，重新连接服务器。
language：切换WSCmdApp使用的语言，0:简体中文 1:英文
jsonBase：切换Json指令中使用基站ID还是基站SN， 0:基站ID生效，基站SN无效，1:基站SN生效，基站ID无效。

# 设计目的

1、协议通过Websocket封装后将具有更好的扩展空间和跨应用使用能力，为平台应用开发提供数据通讯基础。

2、应用程序（后续基于WSCmdApp开发的程序称为应用程序），基于业务发送指令到WSCmdApp，WSCmdApp收到指令后，完成对基站或键盘的操作后回复应用程序。

![](img/image4.png)

# 通讯接口设计概要

应用程序和WSCmdApp之间采用Json数据通信，通信的基本格式如下：

关于baseId和baseSn的使用说明：二者使用切换可以在config.ini 文件的关键字jsonBase中切换，0:基站ID生效[baseId的值有效]，基站SN无效，1:基站SN生效[baseSn的值有效]，基站ID无效，baseSn是字符串数字类型,可以传递一个基站SN。

下发：应用程序 -> WSCmdApp

```json
{
	fun: "" // 功能定义
	baseId: 1 // 基站id,数字类型
	baseSn:"2023031402"	//基站SN，字符串
	params： {} //参数对象/数组
	packetTag: "" //数据包标签字符串
}
```

fun 为功能对应的名称 如："readBaseStationID" 读取基站的id,"startChoices" //开始选择题, "stopChoices" //停止选择题.

baseId：基站ID，用来区分基站标志,参数范围1~32，基站对应的baseId 可以通过readConnectBase指令获取。[此参数请和config.ini 文件的关键字jsonBase的值配合使用]
baseSn：基站SN列表，用来区分基站标志。[此参数请和config.ini 文件的关键字jsonBase的值配合使用]
params：参数，功能相对于的参数，可以是数组或字段。
packerTag:这个是扩展字段，内容需要应用程序管理，功能相应的反馈指令packerTag位置会反馈相同字符串，方便应用程序跟踪记录。

反馈：WSCmdApp-> 应用程序

```json
{
	fun: "" //功能定义
	baseId: 1 //基站id,数字类型
	baseSn:"2023031402" //基站SN
	infos: {} //信息对象/数组
	packetTag: "" // 数据包标签字符串。
}
```

fun： 功能对应的名称,如:"BaseStationID"读取基站id, " answerChoices" //选择题键盘反馈值.
baseId: 基站ID，用来区分基站标志；参数范围1~32，基站对应的baseId 可以通过readConnectBase指令获取。
baseSn: 基站SN，用来区分基站标志。
infos: WSCmdApp反馈给APP层的数据。具体详见具体功能定义。
packetTag:这个是扩展字段，内容需要应用程序管理，反馈接收到的字符串。

字段值说明：
反馈infos中的状态字段state，OK表示成功，FAIL表示失败。
反馈infos中的硬件参数字段的值，FAIL表示失败，其他值为成功。
X\~Y:范围内的值特指整数。

# 通信方式
数据交互采取发送<-->应答的方式。应用程序发送数据到WSCmdApp，WSCmdApp收到后执行完成后回复。

应用程序没有数据发送给WSCmdApp时，可通过向WSCmdApp发送心跳指令。

WSCmdApp端被设置为Websocket 服务端模式时，应用程序可通过WSCmdApp回复的心跳来确认与WSCmdApp的连接状态。

WSCmdApp端被设置为Websocket 客户端模式时， WSCmdApp将自动根据心跳判定开关及心跳参数的设置内容进行重连的自动判断。



# 编程流程说明

用户使用WSCmdApp编程的基本流程如下：
配置参数：(可配置、详情见配置文件config.ini)

编程开发：

1、使用websocket通讯，IP为IP地址
2、启动WSCmdApp.exe（WSCmdApp）进程
3、业务软件连接服务器后就可直接通信，通信的数据格式为JSON(UTF-8编码)。具体参数请看JSON指令说明部分。
4、业务软件发送退出指令，WSCmdApp.exe（WSCmdApp）收到指令后退出。

# JSON指令说明

应用程序和WSCmdApp之间采用Json数据通信，通信的基本格式如下：



下发：应用程序 ->WSCmdApp

```json
{
	fun: "" // 功能定义
	baseId: 1 // 基站id,数字类型
	baseSn:"2023031402"	//基站SN，字符串
	params： {} //参数对象/数组
	packetTag: "" //数据包标签字符串
}
```

fun：为功能定义，下发命令，要下发的命令函数

baseId：基站ID，数字类型，参数范围1~32，基站对应的baseId 可以通过readConnectBase指令获取。如果要指定多个基站ID，则需要多次下发该命令，切换不同的基站ID进行发送。[此参数请和config.ini 文件的关键字jsonBase的值配合使用]

baseSn：基站SN列表，字符串数组。可以传递一个基站SN。[此参数请和config.ini 文件的关键字jsonBase的值配合使用]

params：参数，可以为对象或者数组，用于伴随命令下发的数据附属包，详见具体功能定义。

packerTag:
数据标签字符串,用于区别当前指令与其他指令。应用程序发送给WSCmdApp的，用户可以自定义数据（如果用户无自定义数据，可以为包序号，这样可以区分回复的数据回复的是哪个数据包）。WSCmdApp回复应用程序时，直接回填应用程序收到的标签数据。

反馈：WSCmdApp -> 应用程序

```json
{
	fun: "" //功能定义
	baseId: 1 //基站id,数字类型
	baseSn:"2023031402" //基站SN
	infos: {} //信息对象/数组
	packetTag: "" // 数据包标签字符串，用于区别当前指令与其他指令。WSCmdApp发送给应用程序的用自增数字标记。WSCmdApp回复应用程序的，直接回填WSCmdApp收到的标签。
}
```

fun：同下发描述.
baseId:同下发描述.
baseSn：同下发描述.
infos:WSCmdApp反馈给应用程序层的数据。具体详见具体功能定义。
packetTag:数据标签字符串，反馈功能函数的状态为应用程序附带的数据包，如果WSCmdApp主动发送数据，是一组自增数据。

字段值说明：
反馈infos中的状态字段state，OK表示成功，FAIL表示失败。
反馈infos中的硬件参数字段的值，FAIL表示失败，其他值为成功。
X\~Y:范围内的值特指整数。

## 心跳

应用程序发送心跳，WSCmdApp回应，用于判断连接状态。

发送：

fun: "heartBeat" //心跳
baseId: //无该值
params:{}//无该值
packetTag:"1"//收到的packetTag,可用于分析通信状态

指令样例：
```json
{
	"fun": "heartBeat",
	"packetTag": "1"
}
```

接收：

fun: "heartBeat" //心跳
baseId: //无该值
infos:{}//无该值
packetTag:"1"//数据包标签

指令样例：

```json
{
	"fun": "heartBeat",
	"packetTag": "1"
}
```

## 基站的连接、断开和复位

应用程序与WSCmdApp网络连接成功后（收到心跳），可发送连接基站指令。收到基站连接成功后就可以与SunVote无线反馈系统（基站、键盘）通讯。

### 连接基站

读取在线基站状态
发送：
fun: "readConnectBase" //连接基站
packetTag:"1" //

指令样例：
```json
{
	"fun": "readConnectBase",
	"packetTag": "1"
}
```

接收：

fun: "connectBase" //连接基站
baseId:1 //基站ID
baseSn:"2023031402" //基站SN
infos: {"value":"OK"} //OK连接成功
packetTag:"1" //收到的packetTag

指令样例：
```json
{
	"fun": "connectBase",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "OK"
	},
	"packetTag": "1"
}
```

基站连接后主动上报，WSCmdApp上报信息。

接收：

fun: "connectBase" //连接基站
baseId:1 //基站ID
baseSn:"2023031402" //基站SN
infos: {"value":"OK"} //OK连接成功
packetTag:"1" //收到的packetTag

指令样例：
```json
{
	"fun": "connectBase",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "OK"
	},
	"packetTag": "1"
}
```

### 断开基站

WSCmdApp上报信息。

接收：

fun: "disconnectBase" //断开基站
baseId:1 //基站ID
infos: {} //无该值
packetTag:"1"

指令样例：
```json
{
	"fun": "disconnectBase",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```


### 复位基站

发送：

fun: "resetBase" //复位基站
baseId:1,
params:{} //无该值

指令样例：

```json
{
	"fun": "resetBase",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```



注意：B200支持此命令

## 答题

答题流程：

![](img/image5.png)


在开始作答，各类答题都可指定显示标题和开始作答键盘，也可以为空。

顶层对象增加的字段如下：


|**Json字段**|**字段含义**|**赋值及含义**|
| --- | --- | --- |
|keySnList|指定键盘列表|keySn数组，为空表示所有键盘都参与。|



在停止作答时，各类答题都可指定停止作答键盘，也可以为空。

顶层对象增加的字段如下：

|**Json字段**|**字段含义**|**赋值及含义**|
| --- | --- | --- |
|keySnList|指定键盘列表|keySn数组，为空表示所有键盘都参与。|



如果指定了键盘，则会逐个返回指定键盘的接收状态。收到的infos数组对象如下：

|**Json字段**|**字段含义**|**赋值及含义**|
| --- | --- | --- |
|keySn|键盘Sn||          
|state|状态|OK表示成功|



开始作答

指令样例：

```json
{
	"keySnList": [{
		"keySn": "1837454011"        
	}, {            
		"keySn": "1837454012"        
	}]
}
```



键盘的接收状态返回

fun: "startXXKeypad" //开始XX作答键盘(XX是开始作答对应具体名称)
baseId: 1//接收到指令的基站ID
infos:{}//数组对象
指令样例：

```json
{    
	"fun": "startBindKeypad",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": [{            
		"keySn": "1837454011",
		"state": "OK"        
	}],
	"packetTag": "1"
}
```



回复键盘的接收状态返回

发送：

fun: "startXXKeypad" //开始xx作答键盘
baseId:"1"//收到的基站ID
params:{} //为空

指令样例：

```json
{    
	"fun": "startBindKeypad",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

键盘的接收状态返回

fun: "stopXXKeypad" //停止XX作答键盘(XX是停止作答对应具体名称)
baseId: 1//接收到指令的基站ID
infos:{}//数组对象

指令样例：

```json
{
	"fun": "stopBindKeypad",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": [{
		"keySn": "1837454011",
		"state": "OK"
	}],
	"packetTag": "1"
}
```

回复键盘的接收状态返回

发送：

fun: "stopXXKeypad" //停止xx作答键盘
baseId: "1"//收到的基站ID
params：{} //为空

指令样例：
```json
{
	"fun": "stopBindKeypad",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```


### 签到设备
#### 普通签到
##### 开始签到

发送：

fun: "startBind" //开始签到
params：{}


|**Json字段**| **字段含义** | **赋值及含义**|
| --- | --- | --- |
| bindMode | 签到模式| 1:指定键签到 <br> 2:PIN码签到(默认值) |
| modifyMode     | 修改模式     | 0:不可修改 <br>1:可以修改(默认值)|
| lessMode       | 预留| 0:(默认值）|
| options        | 预留 | 10:(默认值）|
| optionalN      | 可选位数 | 1≤N≤14 |
| keyValue       | 指定按键键值 | 0:未指定[OK键签到] <br>1:1 <br>2:2 <br> 3:3 <br> 4:4 <br> 5:5 <br> 6:6 <br> 7:7 <br> 8:8 <br> 9:9 <br> 10:0 <br> 11:上键  <br> 12:下键 <br> 13:OK  <br> 14:ESC  <br> 15: Menu |
| tipTitle       | 提示标题     | 字符串，长度最多不超过16个字节|


指令样例：

```json
{
	"fun": "startBind",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"bindMode": "1",
		"lessMode": "0",
		"modifyMode": "1",
		"options": "10",
		"optionalN": "10",
		"keyValue": "0"
	},
	"packetTag": "1"
}
```

##### 接收签到信息

接收：

fun: "answerBind" //签到返回
baseId: "1"//接收到指令的基站ID
infos:{}

|  Json字段|字段含义|赋值及含义|
|---|---|---|
|time|答题时间|单位秒|
|keySn|键盘Sn||
|keyId|键盘Id||
|keyValue|键值|键盘提交的值|
|keyBattery|电池状态|S6键盘电压值（V）<br>T2键盘电量值（%）|

指令样例：

```json
{
	"fun": "answerBind",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keyBattery":"2.52",
		"time": "2.42",
		"keySn": "1479824643",
		"keyId": "00001",
		"keyValue": "1234"
	},
	"packetTag": "1"
}
```

##### 停止签到

发送：

fun: "stopBind" //停止签到
params:{} //默认空

指令样例：

```json
{
	"fun": "stopBind",
	"baseId": 0,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopBind" //停止签到
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopBind",
	"baseId": 1,
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

##### 支持设备说明

|**基站+键盘 **|**支持/不支持**|**备注**|
| --- | --- | --- |
|B100-2.4G+S6|支持||                 
|B200-2.4G+S6|支持||               
|B200-5.8G+T2|支持||
#### 后台签到
##### 设置后台签到模式

注意：此接口只支持广播模式使用。

发送：

fun: "backendBind" //
params：{}

|**Json字段**| **字段含义** | **赋值及含义**|
| --- | --- | --- |
| mode | 签到模式| 0: 关闭 <br> 1: 开启 |


指令样例：

```json
{
	"fun": "backendBind",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"mode": "1"
	},
	"packetTag": "1"
}
```

接收：

fun: "backendBind" //
baseId: "1"//接收到指令的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "backendBind",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"mode": "1",
		"state": "OK"
	},
	"packetTag": "1"
}
```

##### 接收签到信息

接收：

fun: "answerBind" //签到返回
baseId: "1"//接收到指令的基站ID
infos:{}

|  Json字段|字段含义|赋值及含义|
|---|---|---|
|time|答题时间|单位秒|
|keySn|键盘Sn||
|keyId|键盘Id||
|keyValue|键值|键盘提交的值|
|keyBattery|电池状态|S6键盘电压值（V）<br>T2键盘电量值（%）|

指令样例：

```json
{
	"fun": "answerBind",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keyBattery":"2.52",
		"time": "0",
		"keySn": "1479824643",
		"keyId": "00001",
		"keyValue": "1234"
	},
	"packetTag": "1"
}
```



##### 键盘授权

注意：此接口配合后台签到指令使用，只支持指定键盘操作。

发送：

fun: "keyPadAuthorize" //
baseId: "1"//收到的基站ID
keySnList:[{"keySn": "0112540402"}]  //指定键盘SN，不可为空
params:{} //默认空

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| baseId | 基站ID | 1-32 |
| authorize | 状态 | 1:授权成功<br>2:授权失败<br>3:授权解除|


指令样例：
```json
{
	"fun": "keyPadAuthorize",
	"baseId": 0,
	"baseSn": "2023031402",
	"keySnList": [{
		"keySn": "0112540402"
	}],
	"params": {
		"authorize": "1"
	},
	"packetTag": "20"
}
```

接收：

fun: "keyPadAuthorize" //
baseId: "1"//收到的基站ID
infos:{"authorize":"1"}//返回状态

指令样例：
```json
{
	"fun": "keyPadAuthorize",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"authorize": "1",
		"keySn": "0112402128"
	},
	"packetTag": "20"
}
```

##### 支持设备说明

|**基站+键盘 **|**支持/不支持**|**备注**|
| --- | --- | --- |
|B100-2.4G+S6|支持||                 
|B200-2.4G+S6|支持||            

### 选择题

#### 开始作答

发送：

fun: "startChoices" //开始选择题
params：{}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|optionsMode|选项类别|1:显示字母(默认值) </br>2:显示数字 |
|secrecyMode|保密模式|0:不保密(默认值)</br>1:保密 |
|modifyMode|修改模式|0:不可修改  </br>1:可以修改(默认值) |
|lessMode|迫选模式| 0:可缺选(默认值) </br>1:不可缺选</br>2:允许重复输入</br>3:允许重复输入且不可缺选 |
| options|选项数目|1≤M≤10(默认值4)|
| optionalN|可选项数|1≤N≤M(默认值1)|
| tipTitle|提示标题|字符串，长度最多不超过16个字节|


指令样例：

```json
{
	"fun": "startChoices",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"optionsMode": "1",
		"secrecyMode": "0",
		"modifyMode": "1",
		"lessMode": "0",
		"options": "4",
		"optionalN": "1"
	},
	"packetTag": "1"
}
```

接收：

fun: "startChoices" //开始选择题
baseId: "1"//接收到指令的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startChoices",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```


#### 接收作答

接收：

fun: "answerChoices" //选择题作答返回
baseId: "1"//接收到指令的基站ID
infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|time|答题时间|单位秒|
|keySn|键盘Sn||
|keyId|键盘Id||
|keyValue|键值|键盘提交的值|
|keyBattery|电池状态|S6键盘电压值（V）<br>T2键盘电量值（%）|


指令样例：
```json
{
	"fun": "answerChoices",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keyBattery":"2.52",
		"time": "2.42",
		"keySn": "1479824643",
		"keyId": "00001",
		"keyValue": "A"
	},
	"packetTag": "1"
}
```

#### 停止作答

发送：

fun: "stopChoices" //停止选择题
params:{} //默认空
指令样例：

```json
{
	"fun": "stopChoices",
	"baseId": 0,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopChoices" //停止选择题
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopChoices",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```


#### 支持设备说明
|基站+键盘|支持/不支持|备注|
|---|---|---|
|B100-2.4G+S6|支持||
|B200-2.4G+S6|支持||
|B200-5.8G+T2|支持||


### 判断题

#### 开始作答

发送：

fun: "startTrueFalse" //开始判断题
params：{}

|**Json字段**|**字段含义**|**赋值及含义**|
|---|---|---|
| optionsMode    | 选项类别     | 1:True/False 对/错 </br>2:Yes/No 是/否</br> 3:√/×|
| secrecyMode    | 保密模式     | 0:不保密(默认值) </br> 1:保密|
| modifyMode     | 修改模式     | 0:不可修改</br>1:可以修改(默认值)|
| tipTitle       | 提示标题     | 字符串，长度最多不超过16个字节|


指令样例：
```json
{
	"fun": "startTrueFalse",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"optionsMode": "1",
		"secrecyMode": "0",
		"modifyMode": "1"
	},
	"packetTag": "1"
}
```

接收：

fun: "startTrueFalse" //开始判断题
baseId: "1"//接收到指令的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startTrueFalse",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答 

接收：

fun: "answerTrueFalse" //判断题作答返回
baseId: "1"//接收到指令的基站ID
infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
| time|答题时间|单位秒|
|keySn|键盘Sn||
|keyId|键盘Id||
|keyValue|键值|键盘提交的值(1对、2错)|
|keyBattery|电池状态|S6键盘电压值（V）<br>T2键盘电量值（%）|


指令样例：

```json
{
	"fun": "answerTrueFalse",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keyBattery":"2.52",
		"time": "2.42",
		"keySn": "1479824643",
		"keyId": "00001",
		"keyValue": "1"
	},
	"packetTag": "1"
}
```

#### 停止作答

发送：

fun: "stopTrueFalse" //停止判断题
params:{} //默认空

指令样例：

```json
{
	"fun": "stopTrueFalse",
	"baseId": 0,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopTrueFalse" //停止判断题
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopTrueFalse",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B100-2.4G+S6|支持||
|B200-2.4G+S6|支持||
|B200-5.8G+T2|支持||

### 多题快答

#### 开始作答

发送：

fun: "startMulQuestions" //开始多小题
params：{}


|Json字段|字段含义|赋值及含义|
|---|---|---|
|questionType|题型|0:单选题(默认值)<br>1:判断题|
|secrecyMode| 保密模式| 0:不保密(默认值)<br>1:保密|
|modifyMode| 修改模式| 0:不可修改<br>1:可以修改(默认值)|
|lessMode| 预留|0|
|questionNumber|题目个数|1~16 |
|options|选项数目|1~10 (单选题有效, 默认值4)|
|tipTitle|提示标题|字符串，长度最多不超过16个字节|

指令样例：
```json
{
	"fun": "startMulQuestions",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"questionType": "0",
		"secrecyMode": "0",
		"modifyMode": "1",
		"lessMode": "0",
		"questionNumber": "10",
		"options": "4"
	},
	"packetTag": "1"
}
```

接收:

fun: "startMulQuestions" //开始多小题
baseId: "1"//接收到指令的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startMulQuestions",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答

接收：

fun: "answerMulQuestions" //多小题作答返回
baseId: "1"//接收到指令的基站ID
infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|time|答题时间|单位秒|
|keySn|键盘Sn||
|keyId|键盘Id||
|keyValue|键值|键盘提交的值|
|keyBattery|电池状态|S6键盘电压值（V）<br>T2键盘电量值（%）|

指令样例：

```json
{
	"fun": "answerMulQuestions",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keyBattery":"2.52",
		"time": "2.42",
		"keySn": "1479824643",
		"keyId": "00001",
		"keyValue": "AACDBDADBD"
	},
	"packetTag": "1"
}
```

#### 停止作答

发送：

fun: "stopMulQuestions" //停止多小题
params:{} //默认空

指令样例：

```json
{
	"fun": "stopMulQuestions",
	"baseId": 0,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun:"stopMulQuestions" //停止多小题
baseId: "1" //收到的基站ID
infos:{"state":"OK"}  //返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopMulQuestions",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B100-2.4G+S6|支持||
|B200-2.4G+S6|支持||
|B200-5.8G+T2|支持||

### 语音题

#### 开始作答

发送：

fun: "startVoice" //开始语音题
params：{}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|recordingMode|录音模式|0:按键录音(默认值)|
|submitTimes|提交次数|0 (0：不限制, 默认值0)|
|recordingTimeLimit|预留|0|
|recordingFormat|预留|0(默认值0)|
|recordAudioFormat|音频格式|0:mp3(默认值)<br>1:实时流|
|buttonMode|按键方式|0:按压录音(默认值)<br>1:单击录音|


指令样例：

```json
{
	"fun": "startVoice",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"recordingMode": "0",
		"submitTimes": "0",
		"recordingTimeLimit": "0",
		"recordingFormat": "0",
		"recordAudioFormat": "0",
		"buttonMode": "0"
	},
	"packetTag": "1"
}
```

接收：

fun: "startVoice" //开始语音题
baseId: "1"//接收到指令的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startVoice",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答

按开始作答时设置的录音格式分为录音文件和实时流两种。

录音文件

接收：

fun: "answerVoiceFile" //录音文件返回
baseId: "1"//接收到指令的基站ID
infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|keySn|键盘Sn||
|filePath|文件路径|录音文件路径|

指令样例：

```json
{
	"fun": "answerVoiceFile",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479749926",
		"filePath": "D:\voice\3_1479749926_196_2023-08-21 16-09-02 530.Mp3"
	},
	"packetTag": "1"
}
```

实时流

接收：

fun: "answerVoiceStream" //语音实时流返回
baseId: "1"//接收到指令的基站ID
infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|keySn|键盘Sn||
|voiceId|回话ID|答题时间内，可重复提交语音，每段语音流加一个回话ID，用于区分作答|
|sampleRate|音频采样率||
|bits|音频采样精度||
|channel|声道数||
|dataIndex|数据包号|1开始|
|data|数据|将原始数据通过Base64编码后得到json中 "data" 字段。应用可通过Base64解码得到原始语音数据。|
|dataLen|数据长度|Base64编码后的字符串长度。应该将 "data" 通过Base64解码后得到原始的数据长度。|
|endFlag|结束标志|默认为0，为1表示结束|

指令样例：


```json
{
	"fun": "answerVoiceStream",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"voiceId": "1",
		"sampleRate": 16000,
		"bits": 16,
		"channel": 1,
		"endFlag": 0,
		"dataIndex": 1,
		"dataLen": 856,
		"data": "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEQAAAO7/AAARAAAA7v8AACMAAADK/wAA+gARAI8ANQDoAO7/EQDP/mwD6ADSBBkFgPm+/iH6J/ko/HD8F/8L/u7/rQGU/yMA4f5fAin/MgpDBwADvwRk+yn/fP1e/Jr+DAEAA+gAPAXpBnECgwK5BdEEmwFaA7oF4f63/DX9n/rJ+f75q/tA+5n7fP1q/Y79av1B/nb+Qf70AX0AfQNx/6b8EQBY/Ub9awD0AZUCfgahA4MCBgLV/az+L/5k/o79LwEdAYkBvv5q/X0AHf48BYMCgwKmAgYCdwH0/uL+0P6C/7j/sgApAsr/Kf+U/8T9L/ig+rL3HfVZA6AAsgYSBi8BIwMRABf/pvxB/nH/4v6m/7IAgv9f/7j/3P+gAAsB4gH0AS8BawAAANz/Kf8F/8r/RwAAACMA6ADoAKb/xAC4AgYCLwFBBO4FWQMAA7kFTQUYAnECiQRlASn/4v47/0H+uPxH/UH+L/6O/fn9F//Q/h3+rP5f/zv/8/5N/9z/uP+C/9z/RwBHACMAWQCgAH0ANQA1AEcAEQDK/8r/3P+4/5T/lP+m/5T/gv+C/5T/lP+C/5T/pv+m/w=="
	},
	"packetTag": "1"
}
```

#### 回传分数

收到语音后，可对评测分数回传给键盘，详见[自定义信息]

#### 停止作答

发送：

fun: "stopVoice" //停止语音题
params:{} //默认空，

指令样例：

```json
{
	"fun": "stopVoice",
	"baseId": 0,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopVoice" //停止语音题
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopVoice",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 丢包信息

语音结束时WSCmdApp会发送该次语言的丢包率。

注意：此数据只在语音实时流时有效。

接收：

fun: "voicePacketLossInfo" //丢包信息
baseId:1 	//1~32,连接基站
infos:{} 	//

|Json字段|字段含义|赋值及含义|
|---|---|---|
|keySn|键盘Sn||
|voiceId|回话ID|答题时间内，可重复提交语音，每段语音流加一个回话ID，用于区分作答|
|recordTime|录音延迟时间||
|shouldSendPacketNum|应发数据包数||
|actualSendPacketNum|实发数据包数||
|lossRate|丢包率|百分比|


指令样例：

```json
{
	"fun": "voicePacketLossInfo",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1837454011",
		"voiceId": "1",
		"recordTime": "42",
		"shouldSendPacketNum": "56",
		"actualSendPacketNum": "56",
		"lossRate": "0"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B200-5.8G+T2|支持|单次录音最长180秒|

### 抢答题

#### 开始作答

发送：

fun: "startRushAnswer" //开始抢答题
params：{}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|rushAnswerMode| 抢答模式|0:普通抢答(默认值)|
|modifyMode|修改模式|0:不可修改<br>1:可以修改(默认值)|



指令样例：
```json
{
	"fun": "startRushAnswer",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"rushAnswerMode": "0",
		"modifyMode": "1"
	},
	"packetTag": "1"
}
```

接收：

fun: "startRushAnswer" //开始抢答题
baseId: "1"//接收到指令的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startRushAnswer",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答 

接收：

fun: "answerRushAnswer" //抢答题作答返回
baseId: "1"//接收到指令的基站ID
infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|time|答题时间|单位秒|
|keySn|键盘Sn||
|keyId|键盘Id||
|keyValue|键值|键盘提交的值|
|keyBattery|电池状态|S6键盘电压值（V）<br>T2键盘电量值（%）|

指令样例：

```json
{
	"fun": "answerRushAnswer",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keyBattery":"2.52",
		"time": "1.42",
		"keySn": "1479824643",
		"keyId": "00001",
		"keyValue": "1"
	},
	"packetTag": "1"
}
```
#### 停止作答

发送：

fun: "stopRushAnswer" //停止抢答题
params:{} //默认空

指令样例：

```json
{
	"fun": "stopRushAnswer",
	"baseId": 0,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopRushAnswer" //停止抢答题
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopRushAnswer",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B100-2.4G+S6|支持||
|B200-2.4G+S6|支持||
|B200-5.8G+T2|支持||

### 数字题

#### 开始作答

发送：

fun: "startNumber" //开始数字题
params：{}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|secrecyMode|保密模式|0:不保密(默认值)<br>1:保密|
|modifyMode|修改模式|0:不可修改<br>1:可以修改(默认值)|
|aswOption|按键模式|0:无规则 （S6最多16位，T2最多14位）<br>1:预留<br>2:预留<br>3:带小数位上下限（T2不支持）|
|digits|小数位数|0:没有小数点<br>1:一位小数点<br>2:二位小数点|
|numMin|下限|aswOption=3<br>digits=0 范围：0~65535 <br> digits=1 范围：0~6553 <br> digits=2 范围：0~655|
|numMax|上限|aswOption=3<br>digits=0 范围：0~65535 <br> digits=1 范围：0~6553 <br> digits=2 范围：0~655|
|tipTitle|提示标题|字符串，长度最多不超过16个字节|



指令样例：
```json
{
	"fun": "startNumber",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"secrecyMode": "0",
		"modifyMode": "1",
		"aswOption": "0",
		"digits": "0",
		"numMin": "0",
		"numMax": "0"
	},
	"packetTag": "1"
}
```

接收：

fun: "startNumber" //开始数字题
baseId: "1"//接收到指令的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startNumber",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答 

接收：

fun: "answerNumber" //数字题作答返回
baseId: "1"//接收到指令的基站ID
infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|time|答题时间|单位秒|
|keySn|键盘Sn||
|keyId|键盘Id||
|keyValue|键值|键盘提交的值|
|keyBattery|电池状态|S6键盘电压值（V）<br>T2键盘电量值（%）|


指令样例：

```json
{
	"fun": "answerNumber",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keyBattery":"2.52",
		"time": "2.42",
		"keySn": "1479824643",
		"keyId": "00001",
		"keyValue": "12"
	},
	"packetTag": "1"
}
```

#### 停止作答

发送：

fun: "stopNumber" //停止数字题
params:{} //默认空

指令样例：

```json
{
	"fun": "stopNumber",
	"baseId": 0,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopNumber" //停止数字题
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopNumber",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B100-2.4G+S6|支持|按键模式（0-无规则 最多16位）|
|B200-2.4G+S6|支持|按键模式（0-无规则 最多16位）|
|B200-5.8G+T2|支持|按键模式（0-无规则 最多14位）<br>按键模式 (3-带小数位上下限)（不支持）|

### 多题题型
#### 开始测试

#####  在线测验题型接口

发送：

fun: "startKeyPadMultipleQuestionsTest" //开始在线测验题型
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 <br>注意：1:新的题开始|
| displayMode | 题号显示模式 | 0:不显示开头<br>1:显示“Q”开头<br>2:显示“题”开头|
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| questionLevel2Symbol | 二级题号 | 1-99 [displayMode=0时有效] |
| questionLevel3Symbol | 三级题号 | 1-99 [displayMode=0时有效] |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| option | 选项数目 | 当questionType = 1 有效。<br>当questionType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|


指令样例：一级题型 + 不显示开头
样例目的：一级题型不显示开头，总题数4题
```json
{
	"fun": "startKeyPadMultipleQuestionsTest",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：二级题型 + 不显示开头
样例目的：二级题型不显示开头，总题数4题
```json
{
	"fun": "startKeyPadMultipleQuestionsTest",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "2",
			"questionLevel2Symbol": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "2",
			"questionLevel2Symbol": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：三级题型 + 不显示开头
样例目的：三级题型不显示开头，总题数4题
```json
{
	"fun": "startKeyPadMultipleQuestionsTest",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：一级题型 + 显示“Q”开头
样例目的：一级题型显示“Q”开头，总题数4题
```json
{
	"fun": "startKeyPadMultipleQuestionsTest",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```
指令样例：一级题型 + 显示“题”开头
样例目的：一级题型显示“题”开头，总题数4题
```json
{
	"fun": "startKeyPadMultipleQuestionsTest",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 2,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```
接收：

fun: "keyPadMultipleQuestionsTest" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "keyPadMultipleQuestionsTest",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

##### 多科作业题型接口

发送：

fun: "startKeyPadMultipleQuestionsCourse" //开始多科作业题型
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 <br>注意：1:新的题开始|
| displayMode | 题号显示模式 | 0:不显示开头<br>1:显示“Q”开头<br>2:显示“题”开头|
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| questionLevel2Symbol | 二级题号 | 1-99 [displayMode=0时有效] |
| course | 科目 | 1:语文<br>2:数学<br>3:英语<br>4:政治<br>5:历史<br>6:地理<br>7:生物<br>8:物理<br>9:化学 |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| option | 选项数目 |  当questionType = 1 有效。<br>当questionType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|

指令样例：带科目 + 二级题型 + 不显示开头
样例目的：语文2题+数学2题+英语2题
```json
{
	"fun": "startKeyPadMultipleQuestionsCourse",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "2",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "2",
			"questionType": "4"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "3",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：带科目 + 一级题型 + 不显示开头
样例目的：语文4题
```json
{
	"fun": "startKeyPadMultipleQuestionsCourse",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：带科目 + 一级题型 + 显示“Q”开头
样例目的：语文4题
```json
{
	"fun": "startKeyPadMultipleQuestionsCourse",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：带科目 + 一级题型 + 显示“题”开头
样例目的：语文4题
```json
{
	"fun": "startKeyPadMultipleQuestionsCourse",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 2,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

接收：

fun: "keyPadMultipleQuestionsCourse" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "keyPadMultipleQuestionsCourse",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

##### 主观题分数输入接口
发送：

fun: "startKeyPadMultipleQuestionsSubjective" //开始主观题分数输入
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 <br>注意：1:新的题开始 |
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| toplimit | 数字上限 | 1-600 |
| decimal | 小数位数 | 0:无效小数<br>1:一位小数<br>2:二位小数 <br>此项缺省时默认是0。|

```json
{
	"fun": "startKeyPadMultipleQuestionsSubjective",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"toplimit": "100",
			"decimal": "0"
		}, {
			"questionLevel1Symbol": "2",
			"toplimit": "100",
			"decimal": "1"
		}, {
			"questionLevel1Symbol": "3",
			"toplimit": "100",
			"decimal": "2"
		}, {
			"questionLevel1Symbol": "4",
			"toplimit": "100"
		}]
	},
	"packetTag": "59"
}
```

接收：

fun: "KeyPadMultipleQuestionsSubjective" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "KeyPadMultipleQuestionsSubjective",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```



#### 接收作答 

接收：

fun: "answerKeyPadMultipleQuestions" 	//多题题型返回

baseId: "1"		//接收到指令的基站ID

infos: {}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| Time | 答题时间 | 单位秒，20分钟内有效 |
| keySn | 键盘Sn | |
| Seq | 题序号 | |
| keyValue | 键值 |键盘提交的值 |
|keyBattery|电池状态|S6键盘电压值（V）<br>T2键盘电量值（%）|



指令样例：
```json
{
	"fun": "answerKeyPadMultipleQuestions",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keyBattery":"2.52",
		"time": "5.42",
		"keySn": "1479824643",
		"seq": "1",
		"keyValue": "12"
	},

	"packetTag": "1"
}
```

#### 退出作答

发送：

fun: "stopKeyPadMultipleQuestions" //停止多题题型

params:{} //默认空

指令样例：

```json
{
	"fun": "stopKeyPadMultipleQuestions",
	"baseId": 0,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopKeyPadMultipleQuestions" //停止键盘测试

baseId: "1"//收到的基站ID

infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopKeyPadMultipleQuestions",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 暂停作答

发送：

fun: "pauseKeyPadMultipleQuestions" //暂停多提题型

baseId: "1"//收到的基站ID

params:{} //默认空

指令样例：

```json
{
	"fun": "pauseKeyPadMultipleQuestions",
	"baseId": 0,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```


接收：

fun: "pauseKeyPadMultipleQuestions" //暂停键盘测试

baseId: "1"//收到的基站ID

infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "pauseKeyPadMultipleQuestions",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 继续测试


#####  在线测验题型接口

发送：

fun: "continueKeyPadMultipleQuestionsTest" //继续在线测验题型
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 |
| displayMode | 题号显示模式 | 0:不显示开头<br>1:显示“Q”开头<br>2:显示“题”开头|
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| questionLevel2Symbol | 二级题号 | 1-99 [displayMode=0时有效] |
| questionLevel3Symbol | 三级题号 | 1-99 [displayMode=0时有效] |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| option | 选项数目 | 当questionType = 1 有效。<br>当questionType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|


指令样例：一级题型 + 不显示开头
```json
{
	"fun": "continueKeyPadMultipleQuestionsTest",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：二级题型 + 不显示开头
```json
{
	"fun": "continueKeyPadMultipleQuestionsTest",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：三级题型 + 不显示开头
```json
{
	"fun": "continueKeyPadMultipleQuestionsTest",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：一级题型 + 显示“Q”开头
```json
{
	"fun": "continueKeyPadMultipleQuestionsTest",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：一级题型 + 显示“题”开头
```json
{
	"fun": "continueKeyPadMultipleQuestionsTest",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 2,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```
接收：

fun: "keyPadMultipleQuestionsTest" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "keyPadMultipleQuestionsTest",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

##### 多科作业题型接口

发送：

fun: "continueKeyPadMultipleQuestionsCourse" //继续多科作业题型
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 |
| displayMode | 题号显示模式 | 0:不显示开头<br>1:显示“Q”开头<br>2:显示“题”开头|
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| questionLevel2Symbol | 二级题号 | 1-99 [displayMode=0时有效] |
| course | 科目 | 1:语文<br>2:数学<br>3:英语<br>4:政治<br>5:历史<br>6:地理<br>7:生物<br>8:物理<br>9:化学 |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| option | 选项数目 |  当questionType = 1 有效。<br>当questionType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|

指令样例：带科目 + 二级题型 + 不显示开头
样例目的：语文2题+数学2题+英语2题
```json
{
	"fun": "continueKeyPadMultipleQuestionsCourse",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "2",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "2",
			"questionType": "4"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "3",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```



指令样例：带科目 + 一级题型 + 不显示开头
样例目的：语文4题
```json
{
	"fun": "continueKeyPadMultipleQuestionsCourse",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：带科目 + 一级题型 + 显示“Q”开头
样例目的：语文4题
```json
{
	"fun": "continueKeyPadMultipleQuestionsCourse",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：带科目 + 一级题型 + 显示“题”开头
样例目的：语文4题
```json
{
	"fun": "continueKeyPadMultipleQuestionsCourse",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 2,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

接收：

fun: "keyPadMultipleQuestionsCourse" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "keyPadMultipleQuestionsCourse",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

##### 主观题分数输入接口
发送：

fun: "continueKeyPadMultipleQuestionsSubjective" //继续主观题分数输入
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 |
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| toplimit | 数字上限 | 1-600 |
| decimal | 小数位数 | 0:无效小数<br>1:一位小数<br>2:二位小数 <br>此项缺省时默认是0。|

```json
{
	"fun": "continueKeyPadMultipleQuestionsSubjective",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"toplimit": "100",
			"decimal": "0"
		}, {
			"questionLevel1Symbol": "2",
			"toplimit": "100",
			"decimal": "1"
		}, {
			"questionLevel1Symbol": "3",
			"toplimit": "100",
			"decimal": "2"
		}, {
			"questionLevel1Symbol": "4",
			"toplimit": "100"
		}]
	},
	"packetTag": "59"
}
```

接收：

fun: "keyPadMultipleQuestionsSubjective" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "keyPadMultipleQuestionsSubjective",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

#### 指定键盘转移作答内容
注意：此接口一次只能对一只键盘进行操作。

发送：

fun: "copyKeyPadMultipleQuestions" //转移键盘作答内容
params:{} //

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| baseId | 键盘所连基站ID | 1-32 |
| keySn | 目标键盘SN |  |
| id | 题目编号 | 1-200 |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| value | 题目答案 |字符串16字节   |


指令样例：

```json
{
	"fun": "copyKeyPadMultipleQuestions",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"keySn": "0007831203",
		"questions": [{
			"id": "1",
			"questionType": "1",
			"value": "A"
		}, {
			"id": "2",
			"questionType": "2",
			"value": "AB"
		}]
	},
	"packetTag": "19"
}
```

接收：

fun: "copyKeyPadMultipleQuestions" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "copyKeyPadMultipleQuestions",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 向键盘广播正确答案

发送：

fun: "okKeyPadMultipleQuestions" //向键盘广播正确答案
baseId: "1"//收到的基站ID
params:{} //默认空

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| baseId | 基站ID | 1-32 |
| id | 题目编号 | 1-200 |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| value | 题目答案 |字符串16字节   |


指令样例：
```json
{
	"fun": "okKeyPadMultipleQuestions",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": [{
		"id": "1",
		"questionType": "1",
		"value": "A"
	}, {
		"id": "2",
		"questionType": "2",
		"value": "AB"
	}],
	"packetTag": "20"
}

```

接收：

fun: "okKeyPadMultipleQuestions" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：
```json
{
	"fun": "okKeyPadMultipleQuestions",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 键盘最终提交状态
##### 键盘主动上报类型

接收：

fun: "keyPadFinalSubmit" //
baseId: "1"//收到的基站ID
infos:{"commitok":"0"}//返回状态

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| baseId | 基站ID | 1-32 |
| commitok | 状态 | 0:解锁<br>1:锁定|
| keySn | 键盘SN | 键盘SN |

指令样例：
```json
{
	"fun": "keyPadFinalSubmit",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"commitok": "1",
		"keySn": "0112402128",
		"time": "84.5"
	},
	"packetTag": "20"
}
```
##### 指令设置类型

发送：

fun: "keyPadFinalSubmit" //
baseId: "1"//收到的基站ID
params:{} //默认空

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| baseId | 基站ID | 1-32 |
| commitok | 状态 | 0:解锁 |


指令样例：
```json
{
	"fun": "keyPadFinalSubmit",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"commitok": "0"
	},
	"packetTag": "20"
}
```

接收：

fun: "keyPadFinalSubmit" //
baseId: "1"//收到的基站ID
infos:{"commitok":"0"}//返回状态

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| baseId | 基站ID | 1-32 |
| commitok | 状态 | 0:解锁<br>1:锁定|
| keySn | 键盘SN | 键盘SN |

指令样例：
```json
{
	"fun": "keyPadFinalSubmit",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"commitok": "0",
		"keySn": "0112402128",
		"time": "84.5"
	},
	"packetTag": "20"
}
```

#### 支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 |  |
| B200-2.4G+S6 | 支持 |  |


### 填空题

#### 开始作答

发送：

fun: "startTextAnswer" //开始填空题
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| optionsMode | 填空类型 | 1:任意输入(默认值) |
| modifyMode | 预留 | 1: (默认值) |
| secrecyMode | 预留 | 0: (默认值) |


指令样例：

```json
{
	"fun": "startTextAnswer",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {
		"optionsMode": "1",
		"modifyMode": "1",
		"secrecyMode": "0"
	},
	"packetTag": "1"
}
```

接收：

fun: "startTextAnswer " //开始填空题
baseId: "1"				//接收到指令的基站ID
infos:{"state":"OK"}	//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startTextAnswer",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答 

接收：

fun: "answerTextAnswer" 	//填空题作答返回
baseId: "1"				//接收到指令的基站ID
infos: {}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| keySn | 键盘Sn |  |
| keyValue | 键值 | 字符串 |


指令样例：

```json
{
	"fun": "answerTextAnswer",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"keyValue": "abcdef"
	},
	"packetTag": "1"
}
```

#### 停止作答

发送：

fun: "stopTextAnswer" //停止填空题
params:{} //默认空

指令样例：
```json
{
	"fun": "stopTextAnswer",
	"baseId": 0,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopTextAnswer" //停止填空题
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：
```json
{
	"fun": "stopTextAnswer",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 |  |
| B200-2.4G+S6 | 支持 |  | 

### 自由题型

#### 开始作答

发送：

fun: "startFreeQuestion" //开始填空题
params：{}

指令样例：

```json
{
	"fun": "startFreeQuestion",
	"baseId": 0,
	"baseSn":"2023031402",
	"params": {},
	"packetTag": "1"
}
```

接收：

fun: "startFreeQuestion " //开始自由题型
baseId: "1"				//接收到指令的基站ID
infos:{"state":"OK"}	//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startFreeQuestion",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答 

接收：
接收作答数据有键盘提交决定分为：选择题、判断题和数字题三个类型

选择题：
fun: "answerChoices" //自由题型作答返回
baseId: "1"//接收到指令的基站ID
infos: {}


| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| keySn | 键盘Sn | |
| keyValue | 键值 | ABCD/1234 |


指令样例：

```json
{
	"fun": "answerChoices",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"keyValue": "ABC"
	},
	"packetTag": "0"
}
```

判断题：
fun: "answerTrueFalse" //自由题型作答返回
baseId: "1"//接收到指令的基站ID
infos: {} 

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| keySn | 键盘Sn | |
| keyValue | 键值 |1~2|

指令样例：

```json
{
	"fun": "answerTrueFalse",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"keyValue": "1"
	},
	"packetTag": "0"
}
```
数字题：
fun: "answerNumber" //自由题型作答返回
baseId: "1"//接收到指令的基站ID
infos: {} 

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| keySn | 键盘Sn | |
| keyValue | 键值 |键盘提交的值|

指令样例：

```json
{
	"fun": "answerNumber",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"keyValue": "99.99"
	},
	"packetTag": "0"
}
```



#### 停止作答

发送：
fun: "stopFreeQuestion" //停止自由题型
params:{} //默认空


指令样例：
```json
{
	"fun": "stopFreeQuestion",
	"baseId": 0,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopFreeQuestion" //停止自由题型
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：
```json
{
	"fun": "stopFreeQuestion",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 |需要指定键盘支持| 

## 刷卡

刷卡流程：
![](img/image6.png)

刷卡后可以将键盘和基站自动完成配对。当需要刷卡绑定时应用软件先给基站发送一个键盘的姓名，键盘靠近基站感应区就会直接绑定当前数据并返回状态给应用。绑定成功后应用再发送下一个键盘的绑定信息，依次循环来绑定多个。

### 写刷卡数据

发送：

fun: "writeNFCInfo" //写NFC绑定数据
baseId: 1//1~32 (键盘所连基站ID)
params:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|userName|姓名|最多24个汉字（48个字符）,键盘左上角显示| 
|matchCode|配对码|四字节 十六进制显示| 



指令样例：

```json
{
	"fun": "writeNFCInfo",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"userName": "张三",
		"matchCode": "22120007"
	},
	"packetTag": "1"
}
```

接收：
fun: "writeNFCInfo" //
baseId: "1"//收到的基站ID
infos:{"value":"OK"}//返回状态,成功为OK


指令样例：
```json
{
	"fun": "writeNFCInfo",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "OK"
	},
	"packetTag": "1"
}
```

 支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4GS+S6 | 支持 |带NFC键盘有效| 

### 刷卡反馈

接收：
fun: "NFCInfo" //刷卡反馈
baseId: "1"//键盘所连基站ID
infos:{} 

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘Sn|| 
|state|状态|1:预留<br>2:基站报告NFC刷卡的键盘SN<br>3:预留<br>4:刷卡写指定配对码消息<br>5:基站报告M1刷卡的键盘SN| 
|number|数量|预留|


指令样例：

```json
{
	"fun": "NFCInfo",
	"baseId": 1,
	"baseSn":"2023031402", 	
	"infos": {
		"keySn": "1479824643",
		"state": "4",
		"number": "0"
	},
	"packetTag": "1"
}
```

支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B200-2.4GS+S6|支持||
|B200-2.4GS+M1|支持||
|B200-5.8G+T2|支持||


### NFC数据清除指令

发送：
fun: "writeNFCEmpty" //清除NFC数据
baseId: 1//1~32 (键盘所连基站ID)
params:{}//


指令样例：

```json
{
	"fun": "writeNFCEmpty",
	"baseId": 1,
	"baseSn":"2023031402",	
	"params": {},
	"packetTag": "1"
}
```
接收：
fun: "writeNFCEmpty" //
baseId: "1"//收到的基站ID
infos:{"value":"OK"}//返回状态,成功为OK


指令样例：
```json
{
	"fun": "writeNFCEmpty",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "OK"
	},
	"packetTag": "1"
}
```

 支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4GS+S6 | 支持 |带NFC键盘有效| 


## 硬件参数

硬件的读写操作返回数据都是相同的，具体值参见写指令的value

### 基站

#### 基站编号

读

发送：
fun: "readBaseStationID" //读基站编号
baseId: 1//1~32
params：{}//可不填



指令样例：
```json
{
	"fun": "readBaseStationID",
	"baseId": 2,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

返回
接收：
fun: "baseStationID" 
baseId: "2"//基站ID
infos:{"value":"2"}//返回基站ID
指令样例：


指令样例：

```json
{
	"fun": "baseStationID",
	"baseId": 2,
	"baseSn":"2023031402",
	"infos": {
		"pathAdd": "12345",
		"value": "2"
	},
	"packetTag": "1"
}
```
支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 


#### 基站频点

读

发送：
fun: "readBaseStationChannel" //读基站频点
baseId: 1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationChannel",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：
fun: "writeBaseStationChannel" //写基站频点
baseId: 1//1~32  (必须指定基站)
params：{"value":"1"}//1~12 （频点）

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|基站频点|单频点基站有效| 
|values|基站频点|多频点基站有效| 


单频点基站指令样例：

```json
{
	"fun": "writeBaseStationChannel",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"value": "3"
	},
	"packetTag": "1"
}
```

多频点基站指令样例：

```json
{
	"fun": "writeBaseStationChannel",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"values": ["3", "6", "9", "12"]
	},
	"packetTag": "1"
}
```

返回

接收：
fun: "baseStationChannel" 
baseId: 1//基站ID
infos:{"value":"3"}//返回基站频点值


指令样例：

```json
{
	"fun": "baseStationChannel",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "3",
		"values": ["3", "6", "9", "12"]
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
|B100-2.4GS+S6|支持单频点|频率范围1~80| 
|B200-2.4GS+S6|支持单频点|频率范围1~80| 
|B200-2.4GM+S6|支持多频点|频率范围1~80| 
|B200-5.8G+T2|支持单频点|频率范围1~12| 

#### 键盘登录菜单显示

读

发送：
fun: "readKeyboardLoginMenu" //读键盘登录菜单显示
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readKeyboardLoginMenu",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：
fun: "writeKeyboardLoginMenu" //写键盘登录菜单显示
baseId: 1 //1~32  (必须指定基站)
params：{"value":"1"}//0~1 （0不允许登录；1允许登录）


指令样例：

```json
{
	"fun": "writeKeyboardLoginMenu",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"value": "1"
	},
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationKeyboardLoginMenu" 
baseId: 1//基站ID
infos:{"value":"1"}//返回键盘登录菜单显示值


指令样例：

```json
{
	"fun": "baseStationKeyboardLoginMenu",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "1"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 



#### 基站型号(只读)

读

发送：

fun: "readBaseStationModel" //读基站型号
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationModel",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationModel" 
baseId: 1//基站ID
infos:{"value":"218"}//返回基站型号


指令样例：

```json
{
	"fun": "baseStationModel",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "218"
	},
	"packetTag": "1"
}
```

基站型号代码查询表

| **基站型号代码** | **基站型号** | **备注** |
| --- | --- | --- |
| 217  | B100-2.4G || 
| 218  | B200-2.4G || 
| 219  | B200-5.8G || 


支持设备说明

 | **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站软件版本(只读)

读

发送：

fun: "readBaseStationSVersion" //读基站软件版本
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationSVersion",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationSVersion" 
baseId: 1//基站ID
infos:{"value":"V2.0.2"}//返回基站软件版本


指令样例：

```json
{
	"fun": "baseStationSVersion",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "V2.0.2"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站序列号(只读)

读

发送：

fun: "readBaseStationSN" //读基站序列号
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationSN",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationSN" 
baseId: 1//基站ID
infos:{"value":"FFFFFFFFFF"}//返回基站序列号


指令样例：

```json
{
	"fun": "baseStationSN",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "FFFFFFFFFF"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站名称

读

发送：

fun: "readBaseStationTitle" //读基站名称
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationTitle",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：

fun: "writeBaseStationTitle" //写基站名称
baseId: 1//1~32(必须指定基站)
params：{"value":" A2021"}//基站名称，最长12字节


指令样例：

```json
{
	"fun": "writeBaseStationTitle",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"value": "A2021"
	},
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationTitle" 
baseId: 1//基站ID
infos:{"value":"A2021"}//返回基站名称


指令样例：

```json
{
	"fun": "baseStationTitle",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "A2021"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站配对模式
读
发送：
fun: "readBaseStationPairMode" //读基站配对模式
baseId:  1//1~32 (必须指定基站)
params：{}//可不填

指令样例：
```json
{
	"fun": "readBaseStationPairMode",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```


<font color="#dd0000" size="5">注意：写操作请谨慎使用。</font><br /> 

写
发送：
fun: "writeBaseStationPairMode" //写基站配对模式
baseId: 1//1~32  (必须指定基站)
params：{"value":"1"}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|模式|1:配对SN号模式<br>2:白名单模式| 


指令样例：
```json
{
	"fun": "writeBaseStationPairMode",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"value": "1"
	},
	"packetTag": "1"
}
```

返回
接收：
fun: "baseStationPairMode" 
baseId: 1//基站ID
infos:{"value":"1"}//返回基站配对模式值

指令样例：
```json
{
	"fun": "baseStationPairMode",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "1"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站配对码

读

发送：

fun: "readBaseStationMatchCode" //读基站配对码
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationMatchCode",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationMatchCode" 
baseId: 1//基站ID
infos:{"value":"21072333"}//返回基站配对码


指令样例：

```json
{
	"fun": "baseStationMatchCode",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "21072333"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 


#### 基站频点冲突

检测到基站频点冲突将会返回给应用程序提示，应用程序可根据情况更改频点。
接收：
fun: "baseStationChannelInterference" // 基站频点冲突
baseId: //发生冲突基站ID 
infos:{ "value":"5"}//频点5冲突 
packetTag:"0"//数据包标签


指令样例：

```json
{
	"fun": "baseStationChannelInterference",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "5"
	},
	"packetTag": "0"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站容量

读

发送：

fun: "readBaseStationCapacity" //读基站容量
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationCapacity",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```
<!-- 
写

发送：

fun: "writeBaseStationCapacity" //写基站容量
baseId:  1//1~32 (必须指定基站)
params：{"keypadNumber":"60","lock":"1"}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keypadNumber|基站容量|基站键盘容量|
|lock|是否锁定|现只支持设置1-锁定|


指令样例：
```json
{
	"fun": "writeBaseStationPairMode",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"keypadNumber": "60",
		"lock": "1"
	},
	"packetTag": "1"
}
``` -->

返回

接收：

fun: "baseStationCapacity" 
baseId: "1"//基站ID
infos:{"keypadNumber":"60","lock":"1"}//返回基站键盘容量值


指令样例：

```json
{	
	"fun": "baseStationCapacity",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keypadNumber": "60",
		"lock": "1"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2  | 支持 || 


#### 快速配对

##### 开始快速配对

发送：

fun: "startQuickMatch" //开始快速配对
baseId:1		// 1~32 (必选参数,范围（1~32）)
params：{} 


指令样例：

```json
{
	"fun": "startQuickMatch",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "startQuickMatch" //开始快速配对
baseId: "1"//接收到指令的基站ID
infos:{"state":"OK"}//返回状态,成功为OK


指令样例：

```json
{
	"fun": "startQuickMatch",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

##### 停止快速配对

发送：

fun: "stopQuickMatch" //停止快速配对
params:{} //默认空


指令样例：

```json
{
	"fun": "stopQuickMatch",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopQuickMatch" //停止快速配对
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK


指令样例：

```json
{
	"fun": "stopQuickMatch",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

##### 支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 


#### 键盘登录密码

读

发送：

fun: "readKeyboardLoginPW" //读键盘登录密码
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readKeyboardLoginPW",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：

fun: "writeKeyboardLoginPW" //写键盘登录密码
baseId: 1 //1~32  (必须指定基站)
params：{"value":"0"}//0~9999 （0不用核对）

指令样例：

```json
{
	"fun": "writeKeyboardLoginPW",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"value": "0"
	},
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationKeyboardLoginPW" 
baseId: 1//基站ID
infos:{"value":"1"}//返回键盘登录密码值


指令样例：

```json
{
	"fun": "baseStationKeyboardLoginPW",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "0"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 


#### 基站名称隐藏

读

发送：

fun: "readBaseStationNameHidden" //读基站名称隐藏
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationNameHidden",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：

fun: "writeBaseStationNameHidden" //写基站名称隐藏
baseId: 1 //1~32  (必须指定基站)
params：{"value":"0"}//0~1 （0隐藏，1不隐藏）

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|模式|0:隐藏<br>1:不隐藏| 

指令样例：

```json
{
	"fun": "writeBaseStationNameHidden",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"value": "0"
	},
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationNameHidden" 
baseId: 1//基站ID
infos:{"value":"1"}//返回基站名称隐藏值  （0隐藏，1不隐藏）


指令样例：

```json
{
	"fun": "baseStationNameHidden",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "0"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 

#### 基站TCP/IP参数

读

发送：

fun: "readBaseStationTcpIp" //读基站TCP/IP参数
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationTcpIp",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：

fun: "writeBaseStationTcpIp" //写基站TcpIp
baseId: 1 //1~32  (必须指定基站)
params： 


指令样例：

```json
{
	"fun": "writeBaseStationTcpIp",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"mac": "FF:FF:FF:FF:FF:FF",
		"ip": "192.168.10.10",
		"mask": "255.255.255.0",
		"gateway": "192.168.10.1"
	},

	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationTcpIp" 
baseId: 1//基站ID
infos:{"value":"1"}//返回基站TcpIp


指令样例：

```json
{
	"fun": "baseStationTcpIp",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"ip": "192.168.10.10",
		"mac": "FF:FF:FF:FF:FF:FF",
		"mask": "255.255.255.0",
		"gateway": "192.168.10.1"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| EA4000T-2.4G+S5  | 支持 |带LAN接口版本| 


#### 基站键盘白名单管理

读

发送：

fun: "readWhiteList" //读白名单列表
baseId:  1//1~32 (必须指定基站)


指令样例：

```json
{
	"fun": "readWhiteList",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {},
	"packetTag": "1"
}
```

读返回
接收：
fun: "whiteList" 
baseId: 1 //1~32 (必须指定基站)
infos:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘Sn|| 
|state|键盘状态<br>[B200_5.8G+T2组合有效]|0:离线<br>1:在线| 

指令样例：

```json
{
	"fun": "whiteList",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": [{
			"keySn": "2111120140",
			"state": "0"
		},
		{
			"keySn": "0005243136",
			"state": "0"
		},
		{
			"keySn": "2111120102",
			"state": "0"
		}
	],
	"packetTag": "1"
}
```

写

<font color="#dd0000" size="5">注意：写操作前请把基站配对模式切换到白名单模式。</font><br /> 

发送：

fun: "writeWhiteList" //写白名单列表
baseId: 1 //1~32  (必须指定基站)
keySnList：[]//键盘SN数组最多200键盘SN

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySnList|键盘列表|B200-2.4GS+S6:键盘最多 200只<br>EA3100-2.4G+S62:键盘最多 200只<br>B200-5.8G+T2:键盘最多 需要参考 7.5.1.10基站容量| 


指令样例：

```json
{
	"fun": "writeWhiteList",
	"baseId": 1,
	"baseSn":"2023031402",
	"keySnList": [{
			"keySn": "2111120140"
		},
		{
			"keySn": "0005243136"
		},
		{
			"keySn": "2111120102"
		}
	],
	"packetTag": "10"
}
```

返回

接收：

fun: "whiteList" 
baseId:  1//1~32 (必须指定基站)
infos:{}// 

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘Sn|| 
|state|键盘状态|OK：成功| 

指令样例：

```json
{
	"fun": "whiteList",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": [{
			"keySn": "2111120140",
			"state": "OK"
		},
		{
			"keySn": "0005243136",
			"state": "OK"
		},
		{
			"keySn": "2111120102",
			"state": "OK"
		}
	],
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 || 
| B200-5.8G+T2 | 支持 || 
| EA3100-2.4G+S62 | 支持 |EA3100写白名单后，返回是没有STATE状态|

#### 基站锁定键盘

发送：
fun: "lockKeypad" //锁定键盘
baseId: 0// 0~32 (指令不发送baseID，默认为0表示所有基站)
params:{} //数组对象，指定键盘需填

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|baseId|基站id|在指定键盘时请传对应的基站baseId<br>0：所有基站| 
|keySnList|键盘列表|没有列表时为锁定当前所有在线列表| 

指令样例：
锁定指定键盘
```json
{
	"fun": "lockKeypad",
	"baseId": 1,
	"baseSn":"2023031402",
	"keySnList": [{
			"keySn": "2111120140"
		},
		{
			"keySn": "0005243136"
		},
		{
			"keySn": "2111120102"
		}
	],
	"params": {},
	"packetTag": "1"
}
```

接收：
```json
{
	"fun": "lockKeypad",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": [{
			"keySn": "1837454011",
			"state": "OK"
		},
		{
			"keySn": "1837454012",
			"state": "OK"
		}
	],
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2 | 支持 || 

#### 基站解锁键盘
发送：
fun: "unlockKeypad" //解锁键盘
baseId:  1//1~32 (必须指定基站)
params:{} //数组对象，指定键盘需填

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|baseId|基站id|在指定键盘时请传对应的基站baseId<br>0：所有基站| 
|keySnList|键盘列表|没有列表时为解锁所有键盘| 

指令样例：

解锁键盘
```json
{
	"fun": "unlockKeypad",
	"baseId": 1,
	"baseSn":"2023031402",
	"keySnList": [{
			"keySn": "2111120140"
		},
		{
			"keySn": "0005243136"
		},
		{
			"keySn": "2111120102"
		}
	],
	"params": {},
	"packetTag": "1"
}
```

接收：
```json
{
	"fun": "unlockKeypad",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": [{
			"keySn": "2111120140",
			"state": "OK"
		},
		{
			"keySn": "0005243136",
			"state": "OK"
		},
		{
			"keySn": "2111120102",
			"state": "OK"
		}
	],
	"packetTag": "1"
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2 | 支持 || 

#### 基站追加键盘 

发送：
fun: "addWhiteList" //追加键盘
params:{} //键盘sn 
keySnList:[ {"keySn":"2111120140"} ]	//列表不能为空

指令样例：

```json
{
	"fun": "addWhiteList",
	"baseId": 1,
	"baseSn":"2023031402",
	"keySnList": [{
		"keySn": "2111120140"
	}],
	"params": {},
	"packetTag": "1"
}
```
接收：
fun: "whiteList" 
baseId: 1//基站ID
infos:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN|| 
|state|键盘状态|OK：成功| 

```json
{
	"fun": "whiteList",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1837454012",
		"state": "OK"
	},
	"packetTag": "1"
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 || 
| B200-5.8G+T2 | 支持 || 

#### 基站删除键盘 

发送：
fun: "delWhiteList" //踢出键盘,删除键盘
params:{} //键盘sn 
keySnList:[ {"keySn":"2111120140"} ]	//列表不能为空

指令样例：

```json
{
	"fun": "delWhiteList",
	"baseId": 1,
	"baseSn":"2023031402",
	"keySnList": [{
		"keySn": "2111120140"
	}],
	"params": {},
	"packetTag": "1"
}
```
接收：
fun: "delWhiteList" 
baseId: 1//基站ID
infos:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN|| 
|state|键盘状态|OK：成功| 

```json
{
	"fun": "delWhiteList",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1",
	"infos": {
		"keySn": "1837454012",
		"state": "OK"
	}
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 || 
| B200-5.8G+T2 | 支持 || 

#### 基站清掉所有键盘 

发送：
fun: "clearWhiteList" //清掉所有键盘
params:{} //无 



指令样例：

```json
{
	"fun": "clearWhiteList",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```
接收：
fun: "clearWhiteList" 
baseId: 1//基站ID
infos:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|state|键盘状态|OK：成功| 

```json
{
	"fun": "clearWhiteList",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1",
	"infos": {
		"state": "OK"
	}
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 || 
| B200-5.8G+T2 | 支持 || 
| EA3100-2.4G+S62 | 支持 || 

#### 键盘关机时间

读
发送：
fun: "readKeypadAutoPowerOffLevel" //读键盘关机时间等级
baseId:  1//1~32 (必须指定基站)
params：{"value":0}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|键盘关机时间等级|0-30秒<br>1:2分钟<br>2:10分钟<br>3:45分钟<br>255:不自动关机| 

指令样例：
```json
{
	"fun": "readKeypadAutoPowerOffLevel",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写
发送：
fun: "writeKeypadAutoPowerOffLevel" //写键盘关机时间等级
baseId: 1//1~32 (必须指定基站)
params：{"value":"0"}//

指令样例：

```json
{
	"fun": "writeKeypadAutoPowerOffLevel",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"value": "0"
	},
	"packetTag": "1"
}
```

返回
接收：
fun: "keypadAutoPowerOffLevel" 
baseId: 1//基站ID
infos:{"value":"0"}//返回键盘关机时间等级
指令样例：

```json
{
	"fun": "keypadAutoPowerOffLevel",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "0"
	},
	"packetTag": "1"
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| 全系列 | 支持 || 

#### 基础参数配置

读
发送：
fun: "readBaseStationBaseConfig" //读基站BaseConfig
baseId:  1//1~32 (必须指定基站)
params：{}//可不填

指令样例：
```json
{
	"fun": "readBaseStationBaseConfig",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写
发送：
fun: "writeBaseStationBaseConfig" //写基站BaseConfig
baseId: 1 //1~32  (必须指定基站)
params：{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|bootVibraton|开机震动|0: 关闭<br>1: 开启| 
|voteVibraton|答题开始震动|0: 关闭<br>1: 开启| 
|led|指示灯开关|0: 关闭<br>1: 开启| 


指令样例：

```json
{
	"fun": "writeBaseStationBaseConfig",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"bootVibraton": "1",
		"voteVibraton": "1",
		"led": "1"
	},
	"packetTag": "1"
}
```

返回
接收：
fun: "baseStationBaseConfig" 
baseId: 1//基站ID
infos:{ }//返回基站

指令样例：

```json
{
	"fun": "baseStationBaseConfig",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"bootVibraton": "1",
		"voteVibraton": "1",
		"led": "1"
	},
	"packetTag": "1"
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2 | 支持 || 

### 键盘

键盘写参数可以不指定键盘SN，则对所有在线键盘进行写操作，但没有键盘状态返回。如需指定键盘信息下发，则需要指定键盘SN，所有键盘状态返回。

注：如果一条指定键盘指令中有一个keySN为空，则该指令会按不指定键盘执行。

#### 键盘外设(只写)

写

fun: "writeKeypadDevice" //写键盘外设,由led灯、蜂鸣器、马达组合
keySnList:[{"keySn":"0007899478"}]  //指定键盘SN列表，为空表示所有在线键盘
params：{} //

数组对象,对象中的默认值为空字符串，各类(led、beep、motor)外设字段都不设置,表示该类不设置

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| ledTimes | Led灯闪烁次数 | 0~255 (0是马上灭，255是长亮)|
| ledOnTime | Led灯每次开时间 |0~255 (单位0.1s)|
| ledOffTime | Led灯每次关时间 |0~255 (单位0.1s，为0就是连续亮)|
| ledColorR | Led灯灯颜色,红值 |0~255(现只支持0灭和1亮,，>1也认为是1)|
| ledColorG | Led灯灯颜色,绿值 |0~255(现只支持0灭和1亮,，>1也认为是1)|
| ledColorB | Led灯灯颜色,蓝值 |0~255(现只支持0灭和1亮,，>1也认为是1)|
| beepTimes | 蜂鸣器响次数 | 0~255 (0是马上响，255是长响) |
| beepOnTime | 蜂鸣器每次开时间 |0~255 (单位0.1s)|
| beepOffTime | 蜂鸣器每次关时间 |0~255 (单位0.1s，为0就是连续响)|
| motorTimes |马达震动次数|0~255|
| motorOnTime | 马达每次开时间 |0~255 (单位0.1s)|
| motorOffTime | 马达每次关时间 |0~255 (单位0.1s，为0就是连续振动)|

指令样例：

所有键盘

```json
{
	"fun": "writeKeypadDevice",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"ledTimes": "3",
		"ledOnTime": "1",
		"ledOffTime": "1",
		"ledColorR": "1",
		"ledColorG": "1",
		"ledColorB": "1",
		"beepTimes": "3",
		"beepOnTime": "1",
		"beepOffTime": "1",
		"motorTimes": "3",
		"motorOnTime": "2",
		"motorOffTime": "1"
	},
	"packetTag": "1"
}
```

返回

fun: "writeKeypadDevice" 
infos:{"state":"OK"}//返回状态,成功为OK


指令样例：

```json
{
	"fun": "writeKeypadDevice",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "0000000000",
		"state": "OK"
	},
	"packetTag": "1"
}
```

指定键盘

```json
{
	"fun": "writeKeypadDevice",
	"baseId": 1,
	"baseSn":"2023031402",
	"keySnList": [{
		"keySn": "0007899478"
	}],
	"params": {
		"ledTimes": "3",
		"ledOnTime": "1",
		"ledOffTime": "1",
		"ledColorR": "1",
		"ledColorG": "1",
		"ledColorB": "1",
		"beepTimes": "3",
		"beepOnTime": "1",
		"beepOffTime": "1",
		"motorTimes": "3",
		"motorOnTime": "2",
		"motorOffTime": "1"
	},
	"packetTag": "1"
}
```

返回

fun: "writeKeypadDevice" 
infos:{}//数组对象,同发送的


指令样例：

```json
{	
	"fun": "writeKeypadDevice",
	"baseId": 3,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "0007899478",
		"state": "OK"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2 | 支持 | 蜂鸣器部分参数无效 |

#### 键盘反馈参数

读
发送：
fun: "readKeypadFeedbackMode" //读键盘反馈模式参数
baseId:  1//1~32 (必须指定基站)
params：{}//读取时不需要

指令样例：

```json
{
	"fun": "readKeypadFeedbackMode",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：
fun: "writeKeypadFeedbackMode" //写键盘反馈模式参数
baseId: 1//1~32 (必须指定基站)
params：{"mode":"1", "value":"4"}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|mode|反馈模式| 0:不启用（默认0不启用）<br>1:通用键码|
|value|反馈最大有效按键|1~10|

指令样例：

```json
{
	"fun": "writeKeypadFeedbackMode",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"mode": "1",
		"value": "4"
	},
	"packetTag": "1"
}
```

返回

接收：
fun: "keypadFeedbackMode" 
baseId: 1//基站ID
infos:{ "mode":"1", "value":"4"}//返回键盘反馈模式参数值

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|mode|反馈模式| 0:不启用（默认0不启用）<br>1:通用键码，不显示|
|value|反馈最大有效按键|1\~10|

指令样例：
```json
{
	"fun": "keypadFeedbackMode",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"mode": "1",
		"value": "4"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 |  |
| B200-2.4G+S6 | 支持 |  |


#### 键盘即时反馈[主动上报]

接收：

fun: "immediateFeedback"
baseId: 1//基站ID
infos:{ "keyId": "00001", "keySn":"2307269906", "keyValue":"A"}//返回键盘反馈模式参数值

指令样例：

```json
{
	"fun": "immediateFeedback",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keyId": "00001",
		"keySn": "2307269906",
		"keyValue": "A"
	},
	"packetTag": "0"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 |  |
| B200-2.4G+S6 | 支持 |  |

#### 键盘上线通知[上报]

S6键盘上线后上报键盘SN信息。
接收：
fun: "keyboardOnlineOne" 
baseId: 1//基站ID
infos:{ "keySn":"1479824643"}//返回键盘反馈模式参数值

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|hModel|键盘型号代码||
|keySn|键盘Sn||
|keyId|键盘Id||
|keyVer|键盘固件版本||

指令样例：

```json
{
	"fun": "keyboardOnlineOne",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"hModel": "79",
		"keyId": "00001",
		"keySn": "1479824643",
		"keyVer": "2.1.12"
	},
	"packetTag": "0"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 |  |

#### 键盘心跳反馈[上报] 
接收：
fun: " KeyboardHeartbeat" 
baseId: 1//基站ID
infos:{ "hModel": "67","keySn":"1479824643","keyValue":"0","ver":"1.0.0","volt":"50"}//返回键盘反馈模式参数值

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|hModel|键盘型号|75： T2-5.8G<br>67： S6-2.4G|
|keySn|键盘Sn||
|keyVer|键盘版本||
|Volt|键盘电量|T2百分比值，S6无效|

指令样例：

```json
{
	"fun": "KeyboardHeartbeat",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"hModel": "67",
		"keySn": "1479824643",
		"keyValue": "0",
		"ver": "1.0.0",
		"volt": "50"
	},
	"packetTag": "0"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 |出厂配置有心跳时反馈，出厂配置无心跳时不反馈|
| B200-2.4G+S6 | 支持 |出厂配置有心跳时反馈，出厂配置无心跳时不反馈|


#### 键盘遥控器反馈[上报] 
特定的遥控器键盘反馈数据接口。

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘Sn||
|keyId|键盘Id|5位字符串，键盘编号，65535代表无编号|
|keyValue|值|S7T：1~17<br> S6T：1~15|
|count|提交次数|1~255|

指令样例：

```json
{
	"fun": "keypadRemoteControl",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"keyId": "00001",
		"keyValue": "1",
		"count": "1"
	},
	"packetTag": "0"
}
```
S7T键值对应请参考图片，如下：
![](img/S7遥控器键盘键值分布图.png)

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S7T | 支持 ||
| B200-2.4G+S7T | 支持 ||
| B100-2.4G+S6T | 支持 ||

#### 键盘举手功能参数

读
发送：
fun: "readKeypadHandUpMode" //读键盘举手功能参数
baseId:  1//1~32 (必须指定基站)
params：{}//读取时不需要

指令样例：

```json
{
	"fun": "readKeypadHandUpMode",
	"baseId": 1,
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：
fun: "writeKeypadHandUpMode" //写键盘举手功能参数
baseId: 1//1~32 (必须指定基站)
params：{"value":"0"}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|举手功能开关|0：关闭举手功能<br>1：开启举手功能|

指令样例：

```json
{
	"fun": "writeKeypadHandUpMode",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"value": "0"
	},
	"packetTag": "1"
}
```

返回

接收：
fun: "keypadHandUpMode" 
baseId: 1//基站ID
infos:{ "value":"0"}//返回参数值

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|举手功能开关|0：关闭举手功能<br>1：开启举手功能|

指令样例：
```json
{
	"fun": "keypadHandUpMode",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"value": "0"
	},
	"packetTag": "1"
}
```


下面是键盘按了举手键后接收到指令。

接收：
fun: "keypadHandUp" 
指令样例：
```json
{	
	"fun": "keypadHandUp",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "0589445416"
	},
	"packetTag": "2"
}
```



支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S7 | 支持 |  |
| B200-2.4G+S7 | 支持 |  |

#### 遥控键盘关机
##### 遥控所有键盘关机
写
发送：
fun: "remoteKeyShutdown" //遥控键盘关机
params：{}// 
指令样例：

```json
{
	"fun": "remoteKeyShutdown",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": [],
	"packetTag": "1"
}
```

##### 遥控指定键盘关机
写
发送：
fun: "remoteKeyShutdown" //遥控键盘关机
params：{}// 
指令样例：

```json
{
	"fun": "remoteKeyShutdown",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": [{
		"keySn": "1837454011"
	}],
	"packetTag": "1"
}
```
返回
接收：
fun: "remoteKeyShutdown" 
baseId: 1//基站ID
infos:{"keySn":"1837454011","state":"OK"}//遥控键盘关机


指令样例：
```json
{
	"fun": "remoteKeyShutdown",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1837454011",
		"state": "OK"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||
| B200-5.8G+T2 | 支持 ||


#### 键盘短消息

写
fun: "writeKeyMessage" //写键盘短消息
keySnList:[{"keySn":"0007899478"}]  //指定键盘SN列表，为空表示所有在线键盘
params：{} // 数组对象,对象中的默认值为空字符串

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|txt|短消息内容|字符串最长40字节[20汉字]|


指令样例：

所有键盘
```json
{
	"fun": "writeKeyMessage",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"txt": "最新消息"
	},
	"packetTag": "1"
}
```

返回
fun: "writeKeyMessage" 
infos:{"state":"OK"}//返回状态,成功为OK


指令样例：

```json
{
	"fun": "writeKeyMessage",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "0000000000",
		"state": "OK"
	},
	"packetTag": "1"
}
```

指定键盘

```json
{
	"fun": "writeKeyMessage",
	"baseId": 1,
	"baseSn":"2023031402",
	"keySnList": [{
		"keySn": "0007899478"
	}],
	"params": {
		"txt": "最新消息"
	},
	"packetTag": "1"
}
```

返回

fun: "writeKeyMessage" 
infos:{}//数组对象,同发送的


指令样例：

```json
{	
	"fun": "writeKeyMessage",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "0007899478",
		"state": "OK"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||


## 键盘显示设置

注：返回指令中的"baseId":0, 可忽略不处理

### 空闲标题

修改参数后设备重启生效。

发送：
fun: "writeKeypadFreeTitle" //写键盘空闲标题显示
params:{} 

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|title|标题|最多8个汉字（16个字符）|

指令样例：
```json
{
	"fun": "writeKeypadFreeTitle",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": {
		"title": "请认真听讲"
	},
	"packetTag": "1"
}
```

接收:
fun: "writeKeypadFreeTitle" //写键盘空闲标题显示
baseId: 1//接收到指令的基站ID
infos:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|state|返回信息|OK(成功)|


指令样例：

```json
{
	"fun": "writeKeypadFreeTitle",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2 | 支持 ||

### 自定义信息

当启动PIN码签到绑定模式，则可对键盘进行绑定操作
发送：
fun: "writeKeypadCustomInfo" //写键盘的自定义信息
params：{}//数组对象,字段不填则保留上次值。

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| keySn| 键盘Sn| 不能为空|
| scoreMode| 分数模式|1:清除<br>2:字符显示(默认值)<br>3:五角星显示|
| scoreValue| 分数值|scoreMode == 1,此处无效. <br>scoreMode == 2,8个字符长度. <br>scoreMode == 3,0~6，2个分数表示1个五角星，最多3个. |
|tipText|提示文本| 最多8个汉字（16个字符）,键盘第二行显示|

注意：scoreMode和scoreValue字段在 B200+S6和B100+S6设备中无效。


指令样例：
样例目的：将SN为"1479824643"的键盘积分位置设置成"99"，第二行文本位置设置成"已绑定"。

```json
{
	"fun": "writeKeypadCustomInfo",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": [{
		"keySn": "1479824643",
		"scoreMode": "2",
		"scoreValue": "99",
		"tipText": "已绑定"
	}],
	"packetTag": "1"
}
```

接收：

指定键盘

fun: "writeKeypadCustomInfo" //写键盘的用户信息
baseId:0 //接收到指令的基站ID
infos:{}//数组对象

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN||
|state|状态|OK(成功)|

指令样例：


```json
{
	"fun": "writeKeypadCustomInfo",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": [{
		"keySn": "1479824643",
		"state": "OK"
	}],
	"packetTag": "1"
}
```


支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||
| B200-5.8G+T2 | 支持 ||


### 用户姓名

当启动PIN码签到绑定模式，则可对键盘进行绑定操作

发送：
fun: "writeKeypadUserName" //写键盘的用户姓名
params：{}//数组对象,字段不填则保留上次值。

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN|不能为空|
|userName|姓名|最多24个汉字（48个字符）,键盘左上角显示|

指令样例：

```json
{
	"fun": "writeKeypadUserName",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": [{
		"keySn": "1479824643",
		"userName": "张三"
	}],
	"packetTag": "1"
}
```

接收：

指定键盘
fun: "writeKeypadUserName" //写键盘的用户姓名
baseId:0 //接收到指令的基站ID
infos:{}//数组对象

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN||
|state|状态|OK(成功)<br>FAIL(失败)|


指令样例：

```json
{
	"fun": "writeKeypadUserName",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"state": "OK"
	},
	"packetTag": "1"
}
```


支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||
| B200-5.8G+T2 | 支持 ||

### 指定用户姓名[C100B+S6旧款]

当启动PIN码签到绑定模式，则可对键盘进行绑定操作
发送：
fun: "writeOneKeypadUserName" //写键盘的用户姓名
params：{}//数组对象,字段不填则保留上次值。

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN|空则为所有在线键盘，其他数组值无效|
|userName|姓名|最多5个汉字（10个字符）, 键盘左上角显示|

指令样例：

```json
{
	"fun": "writeOneKeypadUserName",
	"baseId": 1,
	"baseSn":"2023031402",
	"params": [{
		"keySn": "1479824643",
		"value": "张三"
	}],
	"packetTag": "1"
}
```

接收：

指定键盘
fun: "oneKeypadUserName" //写键盘的用户姓名
baseId:1 //接收到指令的基站ID
infos:{}//数组对象

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN|空则为所有在线键盘，其他数组值无效|
|userName|姓名|最多5个汉字（10个字符）, 键盘左上角显示|

指令样例：

```json
{
	"fun": "oneKeypadUserName",
	"baseId": 1,
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"value": "张三"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| C100B-2.4G+S6 | 支持 |S6旧款支持，不支持生僻字。|


## 键盘在线信息

### 自动返回在线信息

基站连接成功后，自动返回所有在线的键盘信息。当键盘在线状态改变时，也会统一返回。

接收：
fun: "keypadOnLine" //键盘在线状态
infos:{} //数组对象

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|baseId|基站id|keySn键盘所在基站id|
|keySn|键盘SN||
|keyVer|键盘版本||


指令样例：

```json
{
	"fun": "keypadOnLine",
	"baseId": 0,
	"baseSn":"2023031402",
	"infos": [{
			"baseId": "1",
			"keySn": "1837454011",
			"keyVer": "1.0.6"
		},
		{
			"baseId": "1",
			"keySn": "1837454012",
			"keyVer": "1.0.6"
		}
	],
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2| 支持 ||





## 系统参数
### 获取 WSCmdApp 版本
	获取 WSCmdApp 当前版本
发送：
fun: "getSdkVer" // 
params:{}//无该值
packetTag:"1"//


指令样例：

```json
{
	"fun": "getSdkVer",
	"packetTag": "1"
}
```

接收:

fun: "getSdkVer" //
infos:{
	"value": "5.1.0.01"
}


指令样例：

```json
{
	"fun": "getSdkVer",
	"infos": {
	"value": "5.1.0.01"
	}
	"packetTag": "1"
}
```
### 退出WSCmdApp

WSCmdApp,WSCmdApp回应后将结束WSCmdApp.exe进程。
发送：
fun: "exit" //退出WSCmdApp 
params:{}//无该值
packetTag:"1"//收到的packetTag,可用于分析通信状态 


指令样例：

```json
{
	"fun": "exit",
	"packetTag": "1"
}
```

接收:

fun: "exit" //退出WSCmdApp
infos:{}//无该值


指令样例：

```json
{
	"fun": "exit",
	"packetTag": "1"
}
```

注意：配置文件中启用，命令才有效。



### 支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||
| B200-5.8G+T2 | 支持 ||

## 异常处理

### WSCmdApp收到数据异常

WSCmdApp收到异常数据，会不做处理，并返回以下错误信息描述。

接收:
fun: "error" //功能错误
baseId: //无该值
infos:{ "funId":"F0001","code":"10002"}// 


指令样例：
```json
{
	"fun": "error",
	"infos": {
		"funId": "F0001",
		"code": "10002"
	},
	"packetTag": "1"
}
```

| **code** | **含义** |
| --- | --- | 
|10001|不能正确解析的JSON数据|
|10002|解析JSON错误|
|20001|基站未连接|
|20002|功能不支持|
|20003|基站ID为负数，应用可以不传ID，默认为0|
|20004|参数错误|
|20005|基站繁忙|
|30001|找不到对应的SN|
|30002|找不到对应的BaseID|
|30003|基站SN不是对应的BaseID|
|40001|升级功能只能支持一个基站在线|
|50001|此功能必须指定基站ID|
|60001|此功能必须指定键盘SN|

| **funId** | **含义** |
| --- | --- | 
|F0001|基站未连接|
|F0002|读基站信道|
|F0003|写基站信道|
|F0004|读取基站baseId 、信道、RF功率等级|
|F0005|写基站baseId|
|F0006|读基站名称|
|F0007|写基站名称|
|F0008|读键盘关机时间等级|
|F0009|写键盘关机时间等级|
|F0010|读基站配对码|
|F0011|写基站配对码|
|F0012|读基站序列号|
|F0013|写基站序列号|
|F0014|读取基站的型号、硬件版本、软件版本、设备SN号|
|F0015|写基站硬件版本|
|F0016|读基站类型|
|F0017|写基站类型|
|F0018|读基站键盘容量和Lock|
|F0019|写基站键盘容量和Lock|
|F0020|读手动获取返回在线信息|
|F0021|写手动获取返回在线信息|
|F0022|读基站设备RF功率|
|F0023|写基站设备RF功率|
|F0024|基站设备配对模式或基站名称（自定义）|
|F0025|基站设备升级固件|
|F0026|读基站快速配对低功率模式|
|F0027|写基站快速配对低功率模式|
|F0028|读键盘登录菜单显示允许[S6适用]|
|F0029|写键盘登录菜单显示允许[S6适用]|
|F0030|读键盘登录密码[S6适用]|
|F0031|写键盘登录密码[S6适用]|
|F0032|读基站名称隐藏开关|
|F0033|写基站名称隐藏开关|
|F0034|读基站和键盘之间的心跳开关|
|F0035|写基站和键盘之间的心跳开关|
|F0036|读基站语言|
|F0037|写基站语言|
|F0038|读基站CRC|
|F0039|写基站CRC|
|F0040|写广播投票标题|
|F0041|核对投票开启密码|
|F0042|读基站获取投票开启密码|
|F0043|写基站获取投票开启密码|
|F0044|读基站用户自定义字符串|
|F0045|写基站用户自定义字符串|
|F0046|读基站UID|
|F0047|写基站UID|
|F0048|读键盘反馈模式参数|
|F0049|写键盘反馈模式参数|
|F0050|读基站当前是开启升级状态|
|F0051|写基站当前是开启升级状态|
|F0052|手动停止键盘升级状态|
|F0053|写键盘当前是开启升级状态|
|F0054|写踢出单只键盘|
|F0055|写清掉所有键盘|
|F0056|写锁定键盘|
|F0057|写解锁键盘|
|F0058|写T2键盘第二行文本【空闲模式】|
|F0059|读考勤基站时钟设置|
|F0060|写考勤基站时钟设置|
|F0061|读考勤键盘每秒发送考勤信号次数|
|F0062|写考勤键盘每秒发送考勤信号次数|
|F0063|读考勤键盘发送考勤信号功率|
|F0064|写考勤键盘发送考勤信号功率|
|F0065|写修改键盘配对码|
|F0066|写键盘功能提示预设字符串反馈|
|F0067|写空闲模式|
|F0068|单选多选带计时模式|
|F0069|判断题带计时模式|
|F0070|抢答题带计时模式|
|F0071|数字题带计时模式|
|F0072|绑定带计时模式|
|F0073|基站快速配对|
|F0074|读基站特征数据|
|F0075|遥控关机|
|F0076|读键盘在线SN|
|F0077|写基站复位|
|F0078|写键盘外设指令|
|F0079|写键盘配对码|
|F0080|写锁定键盘,解锁键盘|
|F0081|填空题模式|
|F0082|读NFC信息 姓名|
|F0083|写NFC信息 姓名|
|F0084|写NFC配对码|
|F0085|NFC清除指令|
|F0086|多题题型开始|
|F0087|多题题型暂停|
|F0088|多题题型继续上一次|
|F0089|多题题型正确答案下发|
|F0090|多题题型已答题结果转移|
|F0091|写白名单|
|F0092|读白名单|
|F0093|写基站黑名单|
|F0094|读基站黑名单|
|F0095|C100B+S6[旧款]写键盘姓名|
|F0096|C100B+S6[旧款]读键盘姓名|
|F0097|键盘暂停休眠操作|
|F0098|异步测试模式|
|F0099|Tcp参数读|
|F0100|Tcp参数写|
|F0101|自定义题型参数|
|F0102|写S6短信|
|F0103|写S6键盘FSN|
|F0104|自由题模式|
|F0105|基站AES|
|F0106|基站AES 克隆|
|F0107|基础参数配置|
|F0108|删除指定白名单SN|
|F0109|追加指定SN 到白名单|
|F0110|语音题模式|
|F0111|多题快答模式|
|F0112|快速配对模式|
|F0113|键盘测试模式|
|F0114|写入积分和第二行文本|
|F0115|写入键盘姓名|
|F0116|键盘关机时间等级|
|F0117|基础配置模式|
|F0118|最终提交状态|
|F0119|后台签到|
|F0120|键盘授权|
|F0121|基站BIC码|
|F0122|科目预设|

