# C200K

# 基站

# 开发说明文档

版 本 历 史


|版本/状态 | 日期 | 备注 |
| --- | --- | --- |
| 1.0 | 2022-9-30 | |
| 1.1 | 2022-10-14 | 1. 添加刷卡事件<br> 2. 修改套题带题干指令码<br> 原qm =3 修改成qm = 8签到 qm =0 修改成 qm =7 |
| 1.2  | 2022-11-21 | 1. 离线下载套题带题干 <br> 2. 收取离线带题干答案 <br> 3. 离线下载多题不带题干 <br> 4. 收取离线多题不带题干 <br> 5. 收取离线文本 <br> 6. 添加了指纹事件|
| 1.3 | 2022-11-30 | 1. 考勤功能<br> 2. 添加基站信息设置和读取 <br> 3. 在线键盘检测 <br> 4. 自动测试模式添加（单题，套题，离线文本收取）<br> 5. 键盘关机 |
| 1.4 | 2022-12-30 | 第一版协议整理 |
| 1.5 | 2023-3-3 | 紫光和指纹答题器协议整合 |
| 1.6 | 2024-1-19 | 1. 添加pin签到 <br> 2. 下发姓名 <br> 3. 多级编号题目下发 |
| | | |



# 1. 前言

  
## 1.1 背景

方便客户基于C200K基站设备使用 通信基站数据接收及解析。

  
## 1.2 编写目的

此说明书是为了说明协议内容，开发流程，方便基于此进行二次开发。

 
##  1.3 读者对象

1. 相关研发人员
2. 方案制定人员
3. 决策人员


# 2. 开发流程

C200K基站，采用MQTT协议进行开发，基站接入MQTT服务器，应用从MQTT服务器下发指令和接收数据

整个交互图如下:

![](RackMultipart20240201-1-g1fo09_html_f478434017db65da.png)

  
## 2.1 MQTT服务器准备

MQTT服务器要求：

能够正常收发MQTT数据。

服务器的性能参数由业务决定。

域名：

公网域名或ip或者基站所处局域网ip。

MQTT服务器配置结果检查

使用MQTT.FX客户端，配置域名，端口，用户名和密码信息，然后连接，如果提示连接成功，则表示MQTT服务器可用。基站client id 是基站编号。

![](RackMultipart20240201-1-g1fo09_html_fee7c61a6124a949.png)

  
## 2.2 基站配置

通过USB连接基站，打开基站服务器配置软件。

![](RackMultipart20240201-1-g1fo09_html_689c86321ee2757c.png)

如果基站没有连接电脑，工具显示检测基站中，这时候读写无效。

连接正常后，按照各个信息进行写入。

设置基站服务器域名（ip）、端口，用户信息、密码信息，写入基站。

如果MQTT服务器没有启用用户密码验证，用户密码信息可以随机设置。

拔掉USB，连接网线，接入网络，查看网络是否连接正常。（基站上面的灯是否蓝色闪烁）

基站说明

![](RackMultipart20240201-1-g1fo09_html_39a2e5f2d9f1e7b5.png)

  
## 2.3 应用开发

整体开发流程图如下：

![](RackMultipart20240201-1-g1fo09_html_5eea82088a9bba36.png)


# 3. 功能清单

  
## 3.1 支持的功能清单

| **功能** | **说明** |
| --- | --- |
| 授时 | 给基站校时 |
| 基站上下线 | 基站上下线信息 |
| 键盘上下线 | 键盘上下线信息 |
| 刷卡/指纹 | 键盘刷卡/指纹信息 |
| 签到 | 答题器按键签到 |
| 单题 | 下发一题测验 |
| 多题 | 下发多题测验 |
| 套卷 | 下发复杂题型测验 |
| 离线下载 | 下载试题到键盘，离线答题 |
| 基站升级 | 基站固件升级 |
| 键盘升级 | 键盘固件升级 |
| 基站错误信息上报 | 基站错误信息上报 |

  
## 3.2 协议简介

    
### 3.2.1 MQTT

关于MQTT说明，请参考 https://mqtt.org/

${clinetId} clinetId 是基站编号，为替换字符串。

      
#### 3.2.1.1 应用程序发布的主题

| 主题 | 功能 |
| --- | --- |
| /client/${clientId}/operate | 基站的设置，查询等指令 |
| /lesson/class/${clinetId}/receive | 接收答题的指令 |

      
#### 3.2.1.2 应用程序订阅的主题

| 主题 | 功能 |
| --- | --- |
| /client/${clientId}/online | 基站上线通知。 |
| /client/${clientId}/offline | 基站下线通知。 |
| /client/${clientId}/card/online | 答题器上线通知。 |
| /client/${clientId}/card/offline | 答题器离线通知。 |
| /client/${clientId}/card/swipe | 答题器刷卡事件 |
| /client/${clientId}/report | 基站主动上报状态，或者对设置指令的回应。 |
| /lesson/class/${clinetId}/send | 基站对答题/签到数据的反馈 |
| /client/${clientId}/card/fingerprint | 指纹事件 |
| /client/${clientId}/error | 基站错误信息上报 |

    
### 3.2.2 协议格式

![](RackMultipart20240201-1-g1fo09_html_d43b4a7f2872481.png)

协议采用json格式，数据中字段见属性介绍。

    
### 3.2.3 指令属性介绍

| 名称 | 类型 | 说明 |
| --- | --- | --- |
| i | number | 消息指令类型（instruction），取值范围： 1-9999。 I=1 开启白名单 I=2 关闭白名单 I=3 添加白名单 I=4 删除白名单 I=5 清除白名单i = 6 开启考勤i = 7 关闭考勤 i=8 设置考勤信息 i =9 上报考勤数据 i = 11 停止i = 12开启答题/签到 i = 13 接收答题数据 i = 14 键盘上线 i = 15 键盘下线 i = 16 键盘检测 i = 17 基站升级 i = 18 升级报告 i = 19 授时i=20 设置基站信息i=21基站信息上报i=22基站错误信息上报 i = 28 键盘升级 i = 29 键盘升级报告 I= 30 读取白名单 I= 31 白名单上传 i = 40 基站上线 i = 41 基站下线 i = 50 刷卡事件 I = 51 指纹事件 I = 60 姓名下发I = 61 文本预设 |
| m | object | 答题消息的内容(message) 对象或数组 |
| c | string | 答题器的序号(card) |
| t | number | 时间戳(10位timestamp) |
| qm | number | 模式(question model)取值范围： 0：停止 1：单题 2：多题 3：套卷 4: 抢答 5：单题测试 6：多题测试 7：签到 8：套卷带题干 9：离线下载套题带题干 10：收取离线带题干答案 11：离线下载多题不带题干 12：收取离线多题不带题干 13：收取离线文本14：多级编号答题 |
| qt | number | 题型（question type），取值范围： 0：字母单选 1：字母多选 2：数字题 3：判断题 4: 填空题 ~~5：抢答~~ 6：文本题（目前只支持离线答题） |
| qs | number | 该题型数量（question sum），单体为1，多题则为实际数量。 |
| qn | number | 题型序号(question No) |
| tp | String | 类型，例如在签到中，tp=pin 表示pin签到类型 |
| a | string | 答案（answer）示例：字母单选：A字母多选：A|B文本题：hex: 标记是gbk编码的hex内容 |
| en | string | 练习（考试）编号(exercise No)每次考试或者练习的唯一编号，用于确定提交的答案属于那次练习。 |
| on | number | 单选和多选题的选项数量(option No) |
| cid | string | 客户端ID(client Id) |
| cm | string | 客户端型号(client Model) |
| cv | string | 客户端版本(client Version)基站软件版本号 |
| f | number | 信道频点(frequency)基站频点取值：1-80 |
| ap | number | 考勤功率(attend Power)取值：0-31，值约小，基站的接收能力约强。 |
| rssi | number | 答题器考勤的RSSI阈值，软件实现的过滤。RSSI高于该值的答题器的该次考勤会丢弃。默认0，不过滤。 |
| khs | string | 键盘心跳开关(keyboard Heartbeat Switch)，on开启，off关闭 |
| arti | number | 考勤上报时间间隔(attend Reoprt Time Interval),默认30秒 |
| content | string | 题干内容（选项信息都包含在此），中文信息用hex进行传输。内容前面需要 hex:详见后面示例 |
| at | Number | Auto Test自动测试，at = 1，则键盘按到约定自动提交目前支持功能：离线问题提取后续功能慢慢增加 |
| sn | String | SN  序列号 |
| mc | string | Match code 基站配对码 |
| mm | number | match mode 基站配对模式 mm = 1 固定模式 mm = 2 自由模式 mm = 3 免配对模式 mm = 4 配对SN模式 mm= 5 自由sn模式 mm= 6 免配对sn模式 mm= 7 免配对同频点sn号模式 mm= 8 免配对多频点sn号模式 mm =9 免配对白名单模式
 |
| el | number | Electricity 键盘电量 百分比 0.75 75% |
| pm | Number | Power mode 关机模式 pm = 0 在线不关机Pm = 1 在线超时关机 |
| et | number | 错误类型et =1 基站频点冲突 |
| em | String | 错误消息em = "3" 配合et使用，如et=1 em=3 表示3号频点冲突 |
| success | number | 0 成功 非0：错误码 |

  
## 功能说明

    
### 授时

对客户端授时，发送指令即可，基站会完成校时。

| 主题 | /client/${client}/operate | 备注 |
| --- | --- | --- |
| { "i": 19, "t": 1634802943} | t 当前时间轴 秒 |

    
### 基站管理

      
#### 基站上线

由基站发给应用程序，应用需要订阅主题

| 主题 | /client/${clientId}/online | 备注 |
| --- | --- | --- |
| { "i": 40} | 基站上线 |

      
#### 基站下线

由服务器发给应用程序，应用需要订阅主题

| 主题 | /client/${clientId}/offline | 备注 |
| --- | --- | --- |
| { "i": 41} | 基站下线 |

      
#### 基站信息设置与读取

应用程序发送给基站

| 主题 | /client/${client}/operate | 备注 |
| --- | --- | --- |
| { "i": 20, "m": { "f": 0, "ap": 0, "rssi": 0, "khs": "on", "mm": 1, "pm": 0, "arti": 30, "mqtt\_ip": "edunew.sunvotecloud.cn", "mqtt\_port": 8443, "mqtt\_username": "admin", "mqtt\_password": "1223456789", "heartbeat":0, "keypad\_af":0, "keypad\_ap":0 }} | f 基站频点ap 考勤功率 rssi 答题器考勤的RSSI阈值 khs 键盘心跳开关 mm 基站配对模式arti 考勤上报时间间隔 pm 键盘关机模式 mqtt\_ip:连接服务器的IP(只能是IP，不能是域名) mqtt\_port：连接mqtt服务器的端口 mqtt\_username: 连接mqtt服务器的用户名 Mqtt\_password:连接mqtt服务器的密码 heartbeat: 心跳 0 关闭 1 开启 Keypad\_af:考勤频率（0-3） keypad\_ap:考勤功率（0-5）注意：如果没有该字段则不设置该值，保持原值下发对有需要修改的值设置完成后，基站信息会自动上报一次
 |

      
#### 基站信息上报

基站发送给应用程序

| 主题 | /client/${client}/report | 备注 |
| --- | --- | --- |
| { "i": 21,"cId":"2024010282" "m": { "f": 1, "ap": 1, "rssi": 1, "khs": "off", "mc": "AFCEABCD", "mm": 4, "sn": "32121234", "arti": 30, "pm": 1, "cm": "1.0.0", "cv": "1.0.0", "mqtt\_ip": "edunew.sunvotecloud.cn", "mqtt\_port": 8443, "mqtt\_username": "admin", "mqtt\_password": "1223456789", "heartbeat":0, "keypad\_af":0, "keypad\_ap":0

 }} | f 基站频点ap 考勤功率 rssi 答题器考勤的RSSI阈值 khs 键盘心跳开关 mc 基站配对码 mm 基站配对模式arti 考勤上报时间间隔 sn 基站sn号 cm 客户端设备型号 cv 客户端设备版本 pm 键盘关机模式读取时，会全部返回值 mqtt\_ip:连接服务器的IP mqtt\_port：连接mqtt服务器的端口 mqtt\_username: 连接mqtt服务器的用户名 Mqtt\_password:连接mqtt服务器的密码 heartbeat: 心跳 0 关闭 1 开启 Keypad\_af:考勤频率（0-3 0关闭） keypad\_ap:考勤功率（0-5） cId 基站编号
 |

      
#### 基站错误信息上报

基站发送给应用程序

| 主题 | /client/${client}/error | 备注 |
| --- | --- | --- |
| { "i": 22, "m": { "et": 1, "em": "3" }} | et 错误类型 et = 1 ：基站频点冲突 em 错误消息 em=3 ：3号频点示例 基站频点3冲突 |

    
### 键盘管理

      
#### 键盘上线

由基站发给应用程序，应用需要订阅主题

| 主题 | /client/${clientId}/card/online | 备注 |
| --- | --- | --- |
| { "i":14, "m":[{ "c":"12345", "el":0.75, "t":1626016299 }]} | i = 14 键盘上线 el 电量信息答题器编号和上线时间及电量信息 |

      
#### 键盘下线

由基站发给应用程序，应用需要订阅主题

| 主题 | /client/${clientId}/card/offline | 备注 |
| --- | --- | --- |
| { "i":15, "m":[{ "c":"12345", "t":1626016299 }]} | i = 15 键盘下线
答题器编号和下线时间 |

      
#### 键盘在线检测

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":16} | i = 16应用主动通知键盘发送在线键盘信息。键盘上线参考"键盘上线3.3.3.1" |

      
#### 键盘遥控指令

应用程序发送给基站

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":52, "m"{ "cmd":"shutdown" }} | i = 52通知遥控指令 Cmd 不超过16个字符 Cmd = "shutdown"遥控关机Cmd="reset" 遥控重启 |

      
#### 开启白名单

应用程序发送给基站

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":1} | i = 1 开启白名单 |

      
#### 关闭白名单

应用程序发送给基站

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":2} | i = 2 关闭白名单 |

      
#### 读取白名单

应用程序发送给基站

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":30,} | i = 30 读取白名单 |

基站发给应用程序

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 31, "total": 1, "current": 1, "m": ["2126932551"]} | i = 31 白名单上传 |

      
#### 添加白名单

应用程序发送给基站

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":3, "m":["12345","56789"]
} | i = 3 添加白名单m内包含白名单键盘按编号 |

      
#### 删除白名单

应用程序发送给基站

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":4, "m":["12345","56789"]
} | i = 4 删除白名单m内包含白名单键盘按编号 |

      
#### 清空白名单

应用程序发送给基站

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":5} | i = 5 清空白名单 |

    
### 签到

      
#### 开启签到

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 12, "en": "12340", "qm": 7, "m": { "tp":"pin", "content":"hex: c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" }} | qm= 7 签到 en 序号（事务）ID，每个任务需要变化 Tp 签到模式 pin表示pin签到 Ok 表示按ok键签到，默认按OK键签到

 |

      
#### 接收签到信息

由基站发给应用程序，应用订阅主题

| 主题 | /lesson/class/${clinetId}/send | 备注 |
| --- | --- | --- |
| { "i":13, "en":"12340", "qm":7, "m":[{ "c":"12345", "a":"6542", "t":1626016299 }] } | qm = 7 签到 en 发起的序号ID c 键盘sn号 t 表示时间A 签到附带信息 |

      
#### 停止签到

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11, "en": "12340"} | 停止对序号12340的签到 |

      
#### 签到结果下发

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 62, "en": "12340" "sn":["1","2"], "m":{ "success":0 "text":"hex:shjdfhkjhkjfd" }} | Pin 签到的签到结果下发 Success 签到状态结果Text 签到信息（例如签到失败） |

    
### 单题

      
#### 开启答题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 12, "en": "12340", "qm": 1, "m": { "qt": 0, "on": 4, "content":"hex: c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" }} | 示例为单题模式的字母单选。题目内容必须要转成GBK 16进制hex进行传输，并且在内容前面标记为hex: qm =1 单题模式 i=12 下发答题/签到指令 qt 字母单选on 选项数content 题目主干内容 |
| { "i": 12, "en": "12340", "qm": 1, "at": 1, "m": { "qt": 0, "on": 4, "content":"hex: c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" }} | 添加 at = 1 自动测试，键盘固定答案上传 |

      
#### 接收答题数据

由基站发给应用程序，应用订阅主题

| 主题 | /lesson/class/${clinetId}/send | 备注 |
| --- | --- | --- |
| { "i":13, "en":"12340", "qm":1, "c":"12345", "m":[{ "qn":1, "a":"A", "t":1626016299 }] } | 按照题号（qn）来上报答题数据，单题题号固定为1， t为提交答案时间文本题：hex: 标记是gbk编码的hex内容 I = 13 上报信息 qm 字母单选题 c 键盘编号 qn 第几题 单选固定是1t 答题时间 |

      
#### 停止答题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11, "en": "12340"} | 停止对序号12340的测验 |

    
### 多题

      
#### 开启答题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| "i":12, "en":"12341", "qm":2, "m":{ "qt":0, "on": 4, "qs":20, "content":"hex: c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" }} | 示例为多题模式不带内容的快速20道字母单选。 qm =2 多题模式 Qt 题目模式 qt = 0 字母单选 On 选项数量 Qs 题目数量
 |

      
#### 接收答题数据

由基站发给应用程序，应用订阅主题

| 主题 | /lesson/class/${clinetId}/send | 备注 |
| --- | --- | --- |
| { "i":13, "en":"12341", "qm":2, "c":"12345", "m":[{ "qn":1, "a":"A", "t":1626016299 }] } | 按照题号（qn）来上报答题数据，单题题号固定为1， t为提交答案时间 "a":"hex:",文本题：hex: 标记是gbk编码的hex内容 |

      
#### 停止答题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11, "en": "12341"} | 停止对序号12341的测验 |

    
### 套卷

      
#### 开启答题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| "i":12, "en":"12341", "qm":3, "qs":4, "m":[{ "qt":0, "qs":1, "on":6 },{ "qt":1, "qs":1, "on":6
 },{ "qt":3, "qs":1, "on":6
 },{ "qt":0, "qs":1, "on":6 }]} | 示例为多题模式不带内容的快速20道字母单选。 qm =3 套卷模式 Qt 题目模式 qt = 0 字母单选 On 选项数量 Qs 题目数量
 |

      
#### 接收答题数据

由基站发给应用程序，应用订阅主题

| 主题 | /lesson/class/${clinetId}/send | 备注 |
| --- | --- | --- |
| { "i":13, "en":"12341", "qm":2, "c":"12345", "m":[{ "qn":1, "a":"A", "t":1626016299 }] } | 按照题号（qn）来上报答题数据，单题题号固定为1， t为提交答案时间 "a":"hex:",文本题：hex: 标记是gbk编码的hex内容 |

      
#### 停止答题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11, "en": "12341"} | 停止对序号12341的测验 |

    
### 抢答

      
#### 开启答题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":12, "en":"12341", "qm":4} | 示例为多题模式不带内容的快速20道字母单选。 qm =3 套卷模式 Qt 题目模式 qt = 0 字母单选 On 选项数量 Qs 题目数量
 |

      
#### 接收答题数据

由基站发给应用程序，应用订阅主题

| 主题 | /lesson/class/${clinetId}/send | 备注 |
| --- | --- | --- |
| { "i":13, "en":"12341", "qm":2, "c":"12345", "m":[{ "qn":1, "a":"A", "t":1626016299 }] } | 按照题号（qn）来上报答题数据，单题题号固定为1， t为提交答案时间 "a":"hex:",文本题：hex: 标记是gbk编码的hex内容 |

      
#### 停止答题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11, "en": "12341"} | 停止对序号12341的测验 |

    
### 套卷带题干

      
#### 开启答题（套卷带题干）

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":12, "en":"12342", "qm":8, "qs":4, "total":1, "current":1, "m":[{ "qt":0, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" },{ "qt":1, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" },{ "qt":3, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" },{ "qt":0, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" }] } | 示例: 1道字母单选， 1道字母多选， 1道判断题， 1道字母单选。 I = 12 指令 en = 12342该答题序号为12342，应用程序自定义 qm 题型 total 这次数据一共多少包 current 当前第几包。如果套卷内容过大，需要分包传输，一个包的数据量是整个 json数据不能超过4k（4096个字节）。 m 题目详情 qt 题型 qs 题数 on 选项数 content 题目内容 |
| { "i":12, "en":"12342", "qm":8, "qs":4, "total":1, "current":1, "at":1, "m":[{ "qt":0, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" },{ "qt":1, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" },{ "qt":3, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" },{ "qt":0, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" }] } | 比上一个用例多一个 at= 1表示自动测试键盘固定答案上传 |

      
#### 接收答题信息

由基站发给应用程序，应用需要订阅主题

| 主题 | /lesson/class/${clinetId}/send | 备注 |
| --- | --- | --- |
| { "i":13, "en":"12342", "qm":8, "c":"12345", "m":[{ "qn":1, "a":"A", "t":1626016299
 }] } | 按照题号（qn）来上报答题数据，单题题号固定为1， t为提交答案时间示例说明：键盘号为12345的键盘在时间轴1626016299 答的套卷第一题的答案为A "a":"hex:",文本题：hex: 标记是gbk编码的hex内容 |

      
#### 停止答题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11, "en": "12342"} | 停止对序号12342的测验 |

    
### 离线套卷带题干下载

      
#### 下载套题（套卷带题干） 键盘只能保存一套套卷试题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":12, "en":"12342", "qm":9, "qs":4, "total":1, "current":1, "m":[{ "qt":0, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" },{ "qt":1, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" },{ "qt":3, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" },{ "qt":0, "on":6, "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" }] } | 示例: 1道字母单选， 1道字母多选， 1道判断题， 1道字母单选。 I = 12 指令 en = 12342该答题序号为12342，应用程序自定义 qm 题型 total 这次数据一共多少包 current 当前第几包。如果套卷内容过大，需要分包传输，一个包的数据量是整个json数据不能超过4k（4096个字节）。 m 题目详情 qt 题型 qs 题数 on 选项数 content 题目内容
套题最多20题，每题不超过50个汉字 |

      
#### 停止下载

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11, "en": "12342"} | 停止对序号12342的下载 |

      
#### 收取离线答案（键盘在线）

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 12, "en": "12342", "qm": 10,} | 开始对序号12342的离线答案收取 |
|
 |
 |

      
#### 接收答题信息

由基站发给应用程序，应用需要订阅主题

| 主题 | /lesson/class/${clinetId}/send | 备注 |
| --- | --- | --- |
| { "i":13, "en":"12342", "c":"12345", "qm":"10", "m":[{ "qn":1, "a":"A", "t":1626016299
 }] } | 按照题号（qn）来上报答题数据，单题题号固定为1， t为提交答案时间示例说明：键盘号为12345的键盘在时间轴1626016299 答的套卷第一题的答案为A "a":"hex:",文本题：hex: 标记是gbk编码的hex内容 |

      
#### 停止收取离线答案

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11, "en": "12342"} | 停止对序号12342的下载 |

    
### 离线下载多题不带题干

      
#### 下载套题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 12, "en": "12341", "qm": 11, "m": [{ "qn": 1, "qt": 0, "qs": 20, "on": 4, "content":"hex: c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" }, { "qn": 21, "qt": 1, "qs": 20, "on": 4 }]} | qm = 11示例为多题模式不带内容的快速20道字母单选,20题多选。总题数不能超过200题目前只支持客观题 |
| { "i": 12, "en": "12341", "qm": 11, "at": 1, "m": [{ "qn": 1, "qt": 0, "qs": 20, "on": 4 }, { "qn": 21, "qt": 1, "qs": 20, "on": 4 }]} | "at":1 表示自动测试模式。基站根据各题型自动填充答案。
 |

      
#### 停止下载套题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11, "en": "12341"} | 停止对序号12341的测验 |

      
#### 开启收取离线多题答案

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 12, "en": "12342", "qm": 12} | 开始对序号12342的离线答案收取 |

      
#### 离线多题答案收取

基站发给应用程序

| 主题 | /lesson/class/${clinetId}/send | 备注 |
| --- | --- | --- |
| { "i":13, "en":"12342", "c":"12345", "qm": 12, "m":[{ "qn":1, "a":"A", "t":1626016299 }] } | 按照题号（qn）来上报答题数据，单题题号固定为1， t为提交答案时间示例说明：键盘号为12345的键盘在时间轴1626016299 答的套卷第一题的答案为A "a":"hex:",文本题：hex: 标记是gbk编码的hex内容 |

      
#### 停止收取离线多题答案

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11, "en": "12342"} | 停止对序号12342的离线答案收取 |

    
### 收取离线文本

      
#### 开始收取离线文本

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 12, "qm": 13} | 正常收取离线文本 |
| { "i": 12, "qm": 13, "at": 1} | 自动测试收取离线文本 at = 0 或缺省是正常模式 at = 1 表示自动测试测试
 |

      
#### 离线文本收取

基站发给应用程序

| 主题 | /lesson/class/${clinetId}/send | 备注 |
| --- | --- | --- |
| { "i":13, "en":"12342", "c":"12345", "qm": 13, "m":{ "a":"hex:", "t":1626016299 } } | t为提交答案时间示例说明：键盘号为12345的键盘在时间轴1626016299 答的套卷第一题的答案为 "a":"hex:",文本题：hex: 标记是gbk编码的hex内容 |

      
#### 停止收取离线文本

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11} | 停止收取离线文本 |

    
### 多题题号多题

      
#### 开启答题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| {"i":12, "en":"12341", "qm":14, "qs":3, "m":[{ "qt":0, "on": 4, "qn":"1-1-1", "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" },{ "qt":0, "on": 4, "qn":"2-1" "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" },{ "qt":0, "on": 4, "qn":"3" "content":"hex:c7ebbbd8b4f0cfc2c3e633b5c0cad4cce2" }]} | 示例为多题模式 qm =14 多题多级编号模式 Qt 题目模式 qt = 0 字母单选 On 选项数量 Qn 题目多级编号 多级编号必须用"-"隔开。其他必须是数字 content 题目内容
 |

      
#### 接收答题数据

由基站发给应用程序，应用订阅主题

| 主题 | /lesson/class/${clinetId}/send | 备注 |
| --- | --- | --- |
| { "i":13, "en":"12341", "qm":14, "c":"12345", "m":[{ "qn":"1-1-1", "a":"A", "t":1626016299 }] } | 按照题号（qn）来上报答题数据，t为提交答案时间 |

      
#### 停止答题

由应用程序发给基站，应用按照主题发送

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i": 11, "en": "12341"} | 停止对序号12341的测验 |

    
### 下发姓名

      
#### 姓名下发

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":60, "total":1, "current":1, "en":"12342", "qs":2, "m":[{ "sn":"202308093214", "name":"张三", },{ "sn":"202308093215", "name":"李四",}]} | Qs 总下发姓名数量 I=60 姓名下发指令 total 这次数据一共多少包 current 当前第几包。 Sn 键盘编号name 姓名 |

      
#### 成功失败返回

| 主题 | /lesson/class/${clinetId}/send | 备注 |
| --- | --- | --- |
| { "i":60, "total":1, "current":1, "m":[{ "sn":"202308093214", "success":0 },{ "sn":"202308093215", "success":0}]} |
 Sn 姓名写成功键盘编号
 |

    
### 基站升级

      
#### 开始升级

| 主题 | /client/${client}/operate | 备注 |
| --- | --- | --- |
| { "i":17, "m":{ "url":"", "version":"", "CRC":"" }} | url：升级包地址 version：版本号CRC：CRC-32校验码 |

      
#### 升级进度报告

| 主题 | /client/${client}/report | 备注 |
| --- | --- | --- |
| { "i":18, "m":{ "cId":"123456", "percent":0, "status":0 }} | cId：客户端设备ID percent：升级进度，0-100status：升级状态信息，0：未开始；1：升级中；2：升级成功；4固件版本号错误；5：不在升级名单内；6：升级指令错误；\>127：升级中的错误码。 |

    
### 键盘升级

      
#### 开始升级

| 主题 | /client/${client}/operate | 备注 |
| --- | --- | --- |
| { "i":28, "m":{ "url":"", "version":"", "CRC":"" }} | url：升级包地址 version：版本号CRC：CRC-32校验码 |

      
#### 升级进度报告

| 主题 | /client/${client}/report | 备注 |
| --- | --- | --- |
| { "i":29, "m":{ "cId":"123456", "percent":0, "status":0 }} | cId：客户端设备ID percent：升级进度，0-100 status：升级状态信息， 0：未开始； 1：升级中； 2：升级成功； 4固件版本号错误； 5：不在升级名单内；6：升级指令错误；\>127：升级中的错误码。 |

    
### 刷卡事件

由基站发给应用程序，应用需要订阅主题

| 主题 | /client/${clientId}/card/swipe | 备注 |
| --- | --- | --- |
| { "i":50, "m":[{ "c":"12345", "el":0.75, "t":1626016299 }]} | i = 50 刷卡事件答题器编号和刷卡时间 |

    
### 指纹事件

由基站发给应用程序，应用需要订阅主题

| 主题 | /client/${clientId}/card/fingerprint | 备注 |
| --- | --- | --- |
| { "i":51, "m":[{ "c":"12345", "el":0.75, "t":1626016299 }]} | i = 51指纹事件答题器编号和刷卡时间 |

    
### 考勤

      
#### 打开考勤功能

应用程序发送给基站

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":6} | i = 6 开启考勤功能 |

      
#### 关闭考勤功能

应用程序发送给基站

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":7} | i = 7 关闭考勤功能 |

      
#### 设置考勤上传频率

应用程序发送给基站

| 主题 | /lesson/class/${clinetId}/receive | 备注 |
| --- | --- | --- |
| { "i":8, "m":30} | i = 8 设置考勤频率m = 30 表示频率率为30秒采集一次 |

      
#### 上报考勤数据

| 主题 | /lesson/class/${clientId}/attend | 备注 |
| --- | --- | --- |
| { "i":9, "m":[{ "c":"12345", "t":1626016299 }], "total":4, "current":1} | 内容为答题器序号和时间戳， total为本次上报的总的传输包数，current为当前传输包序号。 |

    
### 文本预设

      
#### 文本设置

| 主题 | /client/${client}/operate | 备注 |
| --- | --- | --- |
| { "i":61, "en":"123552", "sn":["12345","56789"], "m":[{ "cmd":81, "text":"",}]} | Cmd:对应测验题显示 1 姓名 2 积分 3 81 单选 82 多选 83 数字 84 判断 85 自判题判断 86 自判题数字 87 清除 Text：文本预设内容，最长不超过8个汉字。 sn 键盘列表
 |

      
#### 设置返回

| 主题 | /client/${client}/report | 备注 |
| --- | --- | --- |
| { "i":61, "en":"123552", "m":[{ "cmd":81, "success":0, "sn":["12345","56789"]}]} | Cmd:对应测验题显示 81单选 82 多选 83 数字 84 判断 85 自判题判断 86 自判题数字 87 清除Text：文本预设内容，最长不超过8个汉字。 |

    
### 学生卡信息上报

主题：/client/${client}/report

| 主题 | /client/${client}/report | 备注 |
| --- | --- | --- |
| { "i":32, "m":[{ "c":"1873373905", "cv":"0.2.2", "hw":"67.0", "t":1638865040 }] }
 | 消息格式：卡初始化组网的时候会上报一次 c 键盘编号 t 时间 hw 硬件版本号cv 软件版本号 |