/*!
    \file    gd32f30x_it.c
    \brief   main interrupt service routines

    \version 2020-08-01, V3.0.0, firmware for GD32F30x
*/

/*
    Copyright (c) 2020, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#include "gd32f30x_it.h"
#include "drv_usbd_int.h"
#include "custom_hid_core.h"
#include "HW_MCUIO.h"
#include "platform.h"
#include "base_core_user.h"

extern usb_core_driver custom_hid;
extern uint32_t usbfs_prescaler;
extern void usb_timer_irq (void);

/* local function prototypes ('static') */
static void resume_mcu_clk(void);

/*!
    \brief      this function handles NMI exception
    \param[in]  none
    \param[out] none
    \retval     none
*/
void NMI_Handler(void)
{
}

/*!
    \brief      this function handles HardFault exception
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HardFault_Handler(void)
{
    /* if Hard Fault exception occurs, go to infinite loop */
    while (1);
}

/*!
    \brief      this function handles MemManage exception
    \param[in]  none
    \param[out] none
    \retval     none
*/
void MemManage_Handler(void)
{
    /* if Memory Manage exception occurs, go to infinite loop */
    while (1);
}

/*!
    \brief      this function handles BusFault exception
    \param[in]  none
    \param[out] none
    \retval     none
*/
void BusFault_Handler(void)
{
    /* if Bus Fault exception occurs, go to infinite loop */
    while (1);
}

/*!
    \brief      this function handles UsageFault exception
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UsageFault_Handler(void)
{
    /* if Usage Fault exception occurs, go to infinite loop */
    while (1);
}

/*!
    \brief      this function handles SVC exception
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SVC_Handler(void)
{
}

/*!
    \brief      this function handles DebugMon exception
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DebugMon_Handler(void)
{
}

/*!
    \brief      this function handles PendSV exception
    \param[in]  none
    \param[out] none
    \retval     none
*/
void PendSV_Handler(void)
{
}

/*!
    \brief      this function handles SysTick exception
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SysTick_Handler(void)
{
    HW_GD_IncTick();
}

/*!
    \brief      this function handles USBFS interrupt
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBFS_IRQHandler (void)
{
    usbd_isr (&custom_hid);
}

/*!
    \brief      this function handles USBFS wakeup interrupt request.
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBFS_WKUP_IRQHandler(void)
{
    if (custom_hid.bp.low_power) {
        resume_mcu_clk();

        rcu_usb_clock_config(usbfs_prescaler);

        rcu_periph_clock_enable(RCU_USBFS);

        usb_clock_active(&custom_hid);
    }

    exti_interrupt_flag_clear(EXTI_18);
}


void TIMER1_IRQHandler(void)
{
    if (RESET != timer_interrupt_flag_get(TIMER1, TIMER_INT_FLAG_UP))
    {
        timer_interrupt_flag_clear(TIMER1, TIMER_INT_FLAG_UP);

        base_core.timer_2ms5_enter();
		void user_2ms5_timer(void);
        user_2ms5_timer();
    }
	timer_interrupt_flag_clear(TIMER1, TIMER_INT_FLAG_UP);//
}

void TIMER2_IRQHandler(void)
{
    if (RESET != timer_interrupt_flag_get(TIMER2, TIMER_INT_FLAG_UP))
    {
        timer_interrupt_flag_clear(TIMER2, TIMER_INT_FLAG_UP);
        
        base_core.timer_20ms_enter();

        void user_20ms_timer(void);
        user_20ms_timer();
    }
	timer_interrupt_flag_clear(TIMER2, TIMER_INT_FLAG_UP);
}

//void TIMER3_IRQHandler(void)
//{
//    if (RESET != timer_interrupt_flag_get(TIMER1, TIMER_INT_FLAG_UP))
//    {
//        timer_interrupt_flag_clear(TIMER1, TIMER_INT_FLAG_UP);
//        //isr
//    }
//}

/*!
    \brief      this function handles Timer2 interrupt request.
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER3_IRQHandler(void)
{
	if (RESET != timer_interrupt_flag_get(TIMER3, TIMER_INT_FLAG_UP))//TIMER_INT_UP))
	{
        timer_interrupt_flag_clear(TIMER3, TIMER_INT_FLAG_UP);//TIMER_INT_UP);
		
		usb_timer_irq();
	}
}

void EXTI5_9_IRQHandler(void)
{
    if (RESET != exti_interrupt_flag_get(EXTI_7))
    {
//        HW_Battery_CHGHandler();
        rf_Irq(3);
        exti_interrupt_flag_clear(EXTI_7);
    }
}

///*!
//    \brief      this function handles EXTI0_1_IRQ Handler.
//    \param[in]  none
//    \param[out] none
//    \retval     none
//*/
//void EXTI0_IRQHandler (void)
//{
//    if (RESET != exti_interrupt_flag_get(EXTI_0)) {//(WAKEUP_KEY_EXTI_LINE)) {
//        if (USBD_CONFIGURED == usbd_custom_hid.cur_status) {
//            Send_Buffer[0] = 0x15U; 

////            if (RESET == gd_eval_key_state_get(KEY_WAKEUP)) {
////                if(Send_Buffer[1]) {
////                    Send_Buffer[1] = 0x00U;
////                } else {
////                    Send_Buffer[1] = 0x01U;
////                }
////            }

//            custom_hid_report_send (&usbd_custom_hid, Send_Buffer, 2U);
//        }

//        /* clear the EXTI line interrupt flag */
//        exti_interrupt_flag_clear(EXTI_0);
//    }
//}

///*!
//    \brief      this function handles EXTI14_15_IRQ Handler.
//    \param[in]  none
//    \param[out] none
//    \retval     none
//*/
//void EXTI10_15_IRQHandler (void)
//{
//    if (RESET != exti_interrupt_flag_get(EXTI_13)) {//(TAMPER_KEY_EXTI_LINE)) {
//        if(USBD_CONFIGURED == usbd_custom_hid.cur_status) {
//            Send_Buffer[2] = 0x16U; 

////            if (RESET == gd_eval_key_state_get(KEY_TAMPER)) {
////                if(Send_Buffer[3]) {
////                    Send_Buffer[3] = 0x00U;
////                } else {
////                    Send_Buffer[3] = 0x01U;
////                }
////            }
//            custom_hid_report_send (&usbd_custom_hid, &Send_Buffer[2], 2U);
//        }

//        /* clear the EXTI line interrupt flag */
//        exti_interrupt_flag_clear(EXTI_13);
//    }
//}

#ifdef USBD_LOWPWR_MODE_ENABLE

/*!
    \brief      this function handles USBD wakeup interrupt request.
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBD_WKUP_IRQHandler (void)
{
    exti_interrupt_flag_clear(EXTI_18);
}

#endif /* USBD_LOWPWR_MODE_ENABLE */

/*!
    \brief      resume mcu clock
    \param[in]  none
    \param[out] none
    \retval     none
*/
static void resume_mcu_clk(void)
{
    /* enable HSE */
    rcu_osci_on(RCU_HXTAL);

    /* wait till HSE is ready */
    while(RESET == rcu_flag_get(RCU_FLAG_HXTALSTB)){
    }

    /* enable PLL1 */
    rcu_osci_on(RCU_PLL1_CK);

    /* wait till PLL1 is ready */
    while(RESET == rcu_flag_get(RCU_FLAG_PLL1STB)){
    }

    /* enable PLL */
    rcu_osci_on(RCU_PLL_CK);

    /* wait till PLL is ready */
    while(RESET == rcu_flag_get(RCU_FLAG_PLLSTB)){
    }

    /* select PLL as system clock source */
    rcu_system_clock_source_config(RCU_CKSYSSRC_PLL);

    /* wait till PLL is used as system clock source */
    while(RCU_SCSS_PLL != rcu_system_clock_source_get()){
    }
}
