#include "SEGGER_RTT.h"
#include "SEGGER_RTT_Conf.h"
#include    "my_headfile.h"
#include    "stdlib.h"
#include "core_extern.h"
#include "platform_extern.h"


////-------------------------------------------------
extern unsigned int PRINT_DBG_CTRL;
void dbg__print_vote_kp_info(const unsigned char *sn);	//ͶƱ/·
void dbg__print_multpkt_info(const unsigned char *sn);	//ϴ
void dbg_print_e2prom_info(unsigned int addr);	//ȡַָe2prom
void dbg_clear_e2prom_space(void);							//e2prom 0-0x100ַ
void dbg__multpkt_up__info(void);

void dbg_downbeaon_info(void);	//·ز
void dbg_multpkt_linklist_ele(void);//ϴģУվϴsdk




unsigned char check_endian(void)
{
	unsigned int u32_raw_data = 0x11223344;
	unsigned char *p_u8 = (unsigned char*) &u32_raw_data;
	if( *p_u8 == 0x44)
		return 0;
	else if( *p_u8 == 0x11)
	return 1;
}





/*
* յַתʮ
*/
static unsigned int conver2sn(const unsigned char *rx,unsigned char *sn)
{
	unsigned int kp_sn = atoi((char*)rx );
	
	sn[0] = kp_sn>>24;
	sn[1] = kp_sn>>16;					
	sn[2] = kp_sn>>8;
	sn[3] = kp_sn>>0;	
	return kp_sn;
}


/*------------------------------- rx process start-------------------------------
* called by mainloop  cmd001:1873006518
* rx data from rtt viewer
*/
void rx_rtt_process(void)
{  
    unsigned char rxbuf[64];
    unsigned char cnt =0;
		unsigned char sn[4];
    cnt =SEGGER_RTT_Read(0,rxbuf,64);
	
    if(cnt ==0){
        return;
    } 
    else if( (cnt==1)&&(memcmp(rxbuf,"m",1)==0) ){
        my_debug.printf(1,"-------debug cmd menu--------- \n");
        my_debug.printf(1,"cmd001:1234567890  list all/search special kp info\n");	//1гָ/ȫ̵Ϣ
        my_debug.printf(1,"cmd002:1234567890  list all/search special vote&confirm info\n");  			//2гָ/ȫ̵ͶƱȷϢ    
				my_debug.printf(1,"cmd003: list report parameter\n");										
				my_debug.printf(1,"cmd004: print blacklist info\n");
				my_debug.printf(1,"cmd005: print multi channel info\n");
				my_debug.printf(1,"cmd006: setting config \n");
				my_debug.printf(1,"cmd007: print call keypad sn \n");	
				my_debug.printf(1,"cmd008: print all call keypad sn \n");	
				my_debug.printf(1,"cmd009: print all call keypad sn \n");				
				return;
    }
		
		//0- ôӡϢ
		if(memcmp(rxbuf,"cmd000",6)==0){//0- cmd000:|16 cmd000:&16
			unsigned char bit = atoi((char*)rxbuf+8 );			
			my_debug.printf(1,"befor config =%x,config =%c bit=%d\n",PRINT_DBG_CTRL,rxbuf[7],bit);
			if( rxbuf[7] =='|'){
				PRINT_DBG_CTRL |= (1<<bit);
			}
			else{
				PRINT_DBG_CTRL &= ~(1<<bit);
			}
			my_debug.printf(1,"after config =%x\n",PRINT_DBG_CTRL);
		}
		
		
		if(memcmp(rxbuf,"cmd00d",6)==0){//
			//conver2sn(rxbuf+7,sn);
//			dbg__multpkt_up__info();
//			#if (MON_DBG_MD)
//			core__mon_dbg_intf.clear_parameter();
//			#endif
			//dbg_downbeaon_info();
			dbg_multpkt_linklist_ele();
		}		
		
		
		//1гָ/ȫ̵ͶƱϢ 0-ӡм̣other-ӡָ		
		if(memcmp(rxbuf,"cmd001",6)==0){
			conver2sn(rxbuf+7,sn);
			#if (MON_DBG_MD)
			dbg__print_vote_kp_info(sn);
			#endif
		}			
		//2,ӡe2promַָ cmd002:1E3 cmd002:ffff
		else if(memcmp(rxbuf,"cmd002",6)==0){
			unsigned int addr =0;
			unsigned char rslt;
			for(unsigned char i=0;i<4;i++){
				if( (rslt= char_conver_hex(rxbuf[7+i]) ) == 0xff) 
					break;
				else{
					addr <<=4;
					addr |= rslt;
				}
			}//for				
			if(addr == 0xffff)
				dbg_clear_e2prom_space();
			else
				dbg_print_e2prom_info(addr);
		}	
		//3г̶ϴ
		else if(memcmp(rxbuf,"cmd003",6)==0){
			conver2sn(rxbuf+7,sn);
			#if MON_MULTPKT
			dbg__print_multpkt_info(sn);
			#endif
		}				
		
//		else if(memcmp(rxbuf,"cmd003",6)==0){//3гrptز
//			conver2sn(rxbuf+7,sn);
//			dbg__print_vote_rpt_info(sn);
//		}				
//		else if(memcmp(rxbuf,"cmd005",6)==0){//5гƵϢ
//			conver2sn(rxbuf+7,sn);
////			dbg__print_multi_info(sn);				
//		}			 
//		else if(memcmp(rxbuf,"cmd007",6)==0){//ӡָǷ񱻵
//			conver2sn(rxbuf+7,sn);
//			if(HBYTEL_COMB_INT(sn) == 0){
//				//my_debug.printf(1,"sn = %d \n",HBYTEL_COMB_INT(sn));
//				return;
//			}
//			memcpy(_dbg_str.special_sn,sn,SN_LEN);
//			_dbg_str.special_call_flag ^= 1;		//turn on/off
//		}
//		else if(memcmp(rxbuf,"cmd008",6)==0){//ӡеıļ
//			_dbg_str.special_all_flag ^= 1;		//turn on/off
//		}
	
				
}



