#include "SEGGER_RTT.h"
#include "SEGGER_RTT_Conf.h"
#include <stdlib.h>
#include <stdarg.h>
#include "my_headfile.h"
#include "base_config.h"
#include "HW_MCUIO.h"

#include "gd32f30x_gpio.h"
#include "gd32f30x_exti.h"

////write
//#define 	HAL_GPIO_WritePin		gpio_bit_write
//#define 	GPIO_PIN_SET				SET
//#define 	GPIO_PIN_RESET			RESET
////read
//#define 	HAL_GPIO_ReadPin		gpio_input_bit_get
////
//#define 	HAL_GPIO_TogglePin		gpio_bit_toggle	

unsigned           int const dbg_io_port[] ={GPIOD,GPIOD,GPIOD,GPIOD };
unsigned           int const dbg_io_pin[]={GPIO_PIN_11,GPIO_PIN_12,GPIO_PIN_13,GPIO_PIN_14};
#define 		DBG_IO_COUNT		4


static void debug_io__init(void)
{
    HW_GPIO_InitTypeDef  GPIO_InitStruct;
	for(unsigned char i=0;i<DBG_IO_COUNT;i++){
    /* configure  GPIO port */ 
		//rcu_periph_clock_enable(RCU_GPIOE);
        
        
    
     /*Configure GPIO pin Output Level */
    HW_GPIO_ResetPin(GPIOC, GPIO_PIN_1|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6);

    /*Configure GPIO pin Output Level */
    HW_GPIO_ResetPin(GPIOA, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_8);

    /*Configure GPIO pin Output Level */
    HW_GPIO_ResetPin(GPIOB, GPIO_PIN_8|GPIO_PIN_9);
    
    /*Configure GPIO pins : PC1 PC4 PC5 PC6 */
    GPIO_InitStruct.Pin = GPIO_PIN_1|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6;
    GPIO_InitStruct.Mode = HW_GPIO_MODE_OUT_PP;
    GPIO_InitStruct.Pull = GPIO_NOPULL;
    GPIO_InitStruct.Speed = HW_GPIO_SPEED_VERY_HIGH;
    HW_GPIO_Init(GPIOC, &GPIO_InitStruct);
		
//    gpio_mode_set(dbg_io_port[i], GPIO_MODE_OUTPUT, GPIO_PUPD_NONE,dbg_io_pin[i]);
//    gpio_output_options_set(dbg_io_port[i], GPIO_OTYPE_PP, GPIO_OSPEED_50MHZ,dbg_io_pin[i]);
	}//for
}


/*----------------- IO debug ----------------------------
* dpi led seq:Led2-Led1-Led4-Led3;
*/
void _debug_io_ctrl(dbgIO_nmb_enum numb, dbgIO_stat_enum st)
{
	unsigned char i = numb;
	
	switch(st){
		case 0: //off
			HAL_GPIO_WritePin(dbg_io_port[i],dbg_io_pin[i], GPIO_PIN_RESET);
			break;

		case 1:	//on
			HAL_GPIO_WritePin(dbg_io_port[i],dbg_io_pin[i], GPIO_PIN_SET);
			break;

		case 2:	//toggle
			HAL_GPIO_TogglePin(dbg_io_port[i],dbg_io_pin[i]);
			break;
		
		default:
			break;
	}//sw	
}	




//------------------------------------------------------------------------------------------------
extern int SEGGER_RTT_vprintf(unsigned BufferIndex, const char * sFormat, va_list * pParamList);
extern int _VPrintHost(const char* s, unsigned int Options, va_list* pParamList);

int _user_SEGGER_RTT_printf(unsigned char md, const char * sFormat, ...)
{
	if(md==0)   return 0;

	int r;
	va_list ParamList;

	va_start(ParamList, sFormat);
	#if 1
	r = SEGGER_RTT_vprintf(0, sFormat, &ParamList);
	#else
	SEGGER_SYSVIEW_PrintfHost(sFormat,&ParamList); //
	#endif
	va_end(ParamList);
	if( r<0){
		r =0;
	}
	return r;
}

void _user_print_buf(unsigned char md,const char * sFormat,const unsigned char *buf,unsigned char len)
{
	_user_SEGGER_RTT_printf(md,sFormat);
	for(unsigned char i=0;i<len;i++)
		_user_SEGGER_RTT_printf(md,"%02x ",buf[i]);
	_user_SEGGER_RTT_printf(md,"\r\n");
}

//-------------------------------------------------------------------
void user_printf_warn(const char * sFormat, ...)
{
	if(PRINT_DBG_WARN ==0) return;
	
	va_list ParamList;
	va_start(ParamList, sFormat);
	SEGGER_RTT_vprintf(0, "<<<<-!WARN!!WARN!!!WARN->>>", &ParamList);
	SEGGER_RTT_vprintf(0, sFormat, &ParamList);
	va_end(ParamList);	
}

void user_printf_error(const char * sFormat, ...)
{
	if(PRINT_DBG_ERROR ==0) return;
	
	va_list ParamList;
	va_start(ParamList, sFormat);
	SEGGER_RTT_vprintf(0, "<<<<-!ERROR!!ERROR!!!ERROR->>>", &ParamList);
	SEGGER_RTT_vprintf(0, sFormat, &ParamList);
	va_end(ParamList);
}




void _debug_init(void)
{
//	SEGGER_RTT_Init();
	//SEGGER_RTT_ConfigUpBuffer(0, NULL, NULL, 0, SEGGER_RTT_MODE_BLOCK_IF_FIFO_FULL);
    /* ͨ0ãSTM32->RTT Viewer */
    SEGGER_RTT_ConfigUpBuffer(0, "RTTUP", NULL, 0, SEGGER_RTT_MODE_NO_BLOCK_SKIP);
    
    /* ͨ0ãRTT Viewer->STM32 */   
    SEGGER_RTT_ConfigDownBuffer(0, "RTTDOWN", NULL, 0, SEGGER_RTT_MODE_NO_BLOCK_SKIP);	//
	//SEGGER_SYSVIEW_Conf();

	debug_io__init();		
}







struct debug_STR  my_debug={
	.init = _debug_init, 
	.ctrl_io = _debug_io_ctrl,
	.printf = _user_SEGGER_RTT_printf,
	.print_buf = _user_print_buf,
	.process_input = rx_rtt_process,
	
	.printf_warn = user_printf_warn,
	.printf_error =user_printf_error,
};



unsigned int PRINT_DBG_CTRL =PRINT_DBG_CTRL_DEFAULT;//xffffffff;


