#ifndef     _GEN_QUEUE_H_
#define     _GEN_QUEUE_H_

typedef 	  unsigned char 	GEN_QUEUE_DATA_TYPE;

typedef struct gen_circle_queue_STR{
	unsigned short front;
	unsigned short rear;	
	unsigned short count;	
	GEN_QUEUE_DATA_TYPE **pdata;
	const unsigned short node_size;	
	const unsigned short data_len;	
}GenCircleQueue;


//void gen_queue_init(GenCircleQueue *const queue, void **data);
signed short gen_queue_out(GenCircleQueue * const queue,GEN_QUEUE_DATA_TYPE* data);	
signed short gen_queue_in(GenCircleQueue * const queue,const GEN_QUEUE_DATA_TYPE* data);
unsigned short gen_queue_get_len(GenCircleQueue *const queue);
unsigned char* gen_queue_get_ele(GenCircleQueue *const queue,unsigned short i);


#define CONCAT_2(p1, p2)     p1##p2

#define     GEN_CIRCLE_QUEUE_DEF(name,nodesize,datalen)\
/*定义一个环形队列所需的空间-避免使用malloc!!*/\
            GEN_QUEUE_DATA_TYPE CONCAT_2(name,_buf)[nodesize][datalen];\
/*定义一个环形队列*/\
            GenCircleQueue name={\
                .pdata = (GEN_QUEUE_DATA_TYPE **)CONCAT_2(name,_buf),\
                .front = 0,\
                .rear = 0,\
                .count = 0,\
								.node_size =nodesize,\
								.data_len = datalen,\
            };\
/*封装相关函数*/\
            signed short CONCAT_2(name,__out)(GEN_QUEUE_DATA_TYPE *data){\
                return gen_queue_out(&name,data);\
            }\
            signed short CONCAT_2(name,__in)(const GEN_QUEUE_DATA_TYPE *data){\
                return gen_queue_in(&name,data);\
            }\
            unsigned short CONCAT_2(name,__get_length)(void){\
                return gen_queue_get_len(&name);\
            }\
            unsigned char* CONCAT_2(name,__get_ele)(unsigned short i){\
                return gen_queue_get_ele(&name,i);\
            }
						







#endif
