#ifndef 	_GEN_LINKLIST_H_
#define 	_GEN_LINKLIST_H_

#include 	"string.h"
#include 	"stdlib.h"

//2,node 链表节点信息
typedef struct gen_linknode_STR{
	void *pdata;	
	struct gen_linknode_STR *next;
}GenLinkNode;

//3,链表总信息
typedef struct gen_linklist_STR{
	GenLinkNode*front;
	GenLinkNode *rear;
	unsigned short length;
}GenLinkList;

//遍历器
typedef struct gen_linkiter_STR
{
    GenLinkNode * pnode;
    int count;
}GenLinkIter;

//insert
unsigned char gen_linklist__insert(GenLinkList* const list,void *pele,unsigned short index);
//detele
void* gen_linklist__detele(GenLinkList* const list,unsigned short index);
//get node
void* gen_linklist__get_ele(GenLinkList* const list,unsigned short index);
//get link length
unsigned short gen_linklist__get_len(GenLinkList* const list);
////iter
// void gen_iter__init(GenLinkIter* iter, GenLinkList* const list);
// unsigned char gen_iter__is_end(GenLinkIter* const iter);
// void* gen_iter__get_ele(GenLinkIter* const iter);
// unsigned char gen_iter__get_index(GenLinkIter* const iter);



//----------------------------------------------------------------------------
#define CONCAT_2(p1, p2)     p1##p2

#define CONCAT_3(p1, p2, p3)     p1##p2##p3

#define _ELE_STAT_NULL		0xff
#define _ELE_STAT_VALID		0x01
/*
* name -用户定义的链表名称
* ele_str 用户定义的ele数据结构体
* cnt 数据结构体数组元素个数
*/
#define	GEN_LINKLIST_DEF(name,ele_str,cnt)\
/*1 定义一个头节点*/\
		GenLinkNode	CONCAT_2(name,_node_head)={\
			.pdata =NULL,\
			.next =NULL,\
		};\
/*2 定义应用链表并初始化指向头节点*/\
			GenLinkList name={					\
				.front =&CONCAT_2(name,_node_head),		\
				.rear =&CONCAT_2(name,_node_head),		\
				.length =0,						\
			};									\
			void CONCAT_2(name,__init)(void){\
				name.front =&CONCAT_2(name,_node_head);		\
				name.rear =&CONCAT_2(name,_node_head);		\
				name.length =0;					\
			}\
/*3 定义ele数组*/			\
		ele_str CONCAT_2(name,_ele)[cnt];\
/*3.1 初始化ele status//--- next need app called ------*/\
		void CONCAT_2(name,__init_ele)(void){\
			for(unsigned short x = 0;x < cnt;x++)\
				CONCAT_2(name,_ele)[x].status = _ELE_STAT_NULL;\
		}\
/*3.2 获取一个空闲的ele 返回其地址*/			\
  		ele_str *CONCAT_2(name,__malloc_ele)(void){\
				for(unsigned short x = 0;x < cnt;x++){\
					if(CONCAT_2(name,_ele)[x].status == _ELE_STAT_NULL ){\
						CONCAT_2(name,_ele)[x].status = _ELE_STAT_VALID;\
						return &CONCAT_2(name,_ele)[x];\
					}\
				}\
				return NULL;\
			}\
/*3.3 获取空闲ele的总个数*/\
		unsigned char CONCAT_2(name,__get_free_ele_cnt)(void){\
				unsigned char count=0;\
				for(unsigned short x = 0;x < cnt;x++){\
					if(CONCAT_2(name,_ele)[x].status == _ELE_STAT_NULL ){\
						count++;\
					}\
				}\
				return count;\
		}\
/* 5封装linklist相关函数*/			\
		unsigned char	CONCAT_2(name,__insert)(void *pele,unsigned short index){\
			return gen_linklist__insert(&name,pele,index);\
		}\
		void* CONCAT_2(name,__detele)(ele_str * pele,unsigned short index){\
			pele->status = _ELE_STAT_NULL;\
			ele_str *pe =gen_linklist__detele(&name,index);\
			return pe;\
		}\
		unsigned short CONCAT_2(name,__get_len)(void){\
			return gen_linklist__get_len(&name);\
		}\
		void * CONCAT_2(name,__get_ele)(unsigned short index){\
			return gen_linklist__get_ele(&name,index);\
		}\
/* 通用遍历函数*/	\
		unsigned char CONCAT_2(name,__traverse)(unsigned char (*trav_func)(ele_str *,unsigned char) ){\
			ele_str *pele;	\
			unsigned char ret_cnt=0;\
			for(unsigned short i=0;i< gen_linklist__get_len(&name);i++){\
				pele = gen_linklist__get_ele(&name,i);\
				if( trav_func(pele,i) )\
					ret_cnt++;\
			}\
			return ret_cnt;\
		}	\
/* 通用遍历函数,同时输入用户指针*/	\
		unsigned char CONCAT_2(name,__traverse_input)(unsigned char (*trav_func)(ele_str *,unsigned char*),unsigned char* pt ){\
			ele_str *pele;	\
			unsigned char ret_cnt=0;\
			for(unsigned short i=0;i< gen_linklist__get_len(&name);i++){\
				pele = gen_linklist__get_ele(&name,i);\
				if( trav_func(pele,pt) )\
					ret_cnt++;\
			}\
			return ret_cnt;\
		}	


			
#endif
