
#ifndef 	_BASE_CONFIG_H_
#define 	_BASE_CONFIG_H_

#ifndef 	_OLD_CONFIG_




//*---------------------------
//* !!!!!!!禁止修改!!!!!!!!!
//*---------------------------
#define 	TYPE_T2					10

#define 	TYPE_EVS200			50
#define 	TYPE_EVS100			51

#define 	TYPE_CRS200			40
#define 	TYPE_CRS200_NL	41
#define 	TYPE_CRS200_433	30
#define 	TYPE_C100					41
//--------------------------------------
/**
*EVS200:
*	1,E11 -	a,4个模块都发基础信标，投票信标和ack; b,需要把基础信标和投票信标都修改成28Bytes; //20200616
*	2,G1  - a,AES加密 信标需要发送32bytes;b,投票信标中带主频点信息；c,容量均衡。
*
*CRS200:
* 1,T1Lite - 在投票信标tmp32必须是信标的crc校验的低字节!
*
*EVS200_433：
* 1,voxm - 转发数据必须要加crc校验!!
*/





// <<< Use Configuration Wizard in Context Menu >>>

//-----------------------------------------------------------------------
// <h> debug config
//<i> debug function-choose 5.8G or No5.8G
//<i> monitor vote data for lose vote
//<i> other debug function: force keypad poweroff when test mode
//  <o>RF type(5.8G or not)
//   <i> Default:OFF
//   <0=> OFF
//   <1=> 5.8G
//   <2=> Not5.8G(2.4G/433M)
#define DEBUG_CONFIG	 0

#if (DEBUG_CONFIG ==1)
	#define 	_DEBUG_CORE_			//总开关
	#define		_DBG_VOICE_KP					//监测键盘数据，包括语音和非语音模式;T2语言基站
#elif (DEBUG_CONFIG ==2)
	#define 	_DEBUG_CORE_			//总开关
	#define 	_DBG_2G4_KP_			//与键盘的通信
#endif 

// <c1> base forces all keypad poweroff when SDK disconnect
//  <i> This function is used to keypad battary test 
//#define 	_SDK_OFFLINE_							//sdk断联后，基站强制关闭所有键盘; 用于配合做键盘电量测试;;	
//#define 	_SDK_SYSMODE0_KEEPTIMER_	//sysmode0保持一段时间后关闭所有键盘
// </c>

// </h>

//------------------------------------------------------------------------------------------
// <h> Base model choose and config
//<i> you must choose a BASE Model,then config parameter if you need;
//<i> you should input test or release version,
//  <o>Base model
//   <i> Default:OFF
//   <0=> OFF
//   <1=> T2 
//   <2=> EVS200
//   <3=> EVS100  
//   <4=> CRS200
//   <5=> CRS200_433
//   <6=> C200
//   <7=> CRS200_5G8
//   <8=> C100

#define 	BASE_MODEL		8

//-----
#define 	T2							1
#define 	EVS200					2
#define 	EVS100					3
#define 	CRS200					4
#define 	CRS200_433			5
#define 	C200						6
#define 	CRS200_5G8			7
#define 	C100						8



void operation_debug_io(unsigned char nbr);//debug only
#define 	TEST_SW1	100



// <h> T2 voice config
//<i> hardware:RF200 board with charge Box
//<i> RF:5.8G-A5130 ;1 rf modual
//<i> usb High speed(usb3300 ENABLE)
#if (BASE_MODEL ==T2)
		//--------------1 HARDWARE_SETTING  --------------------------------------------			
		//硬件代号
		#define 	HMODEL 0xCA	//202
		#define 	BASE_TYPE 	TYPE_T2

		#define 	BASE_HARDWARE_T2			
		//#define 	BASE_HARDWARE_200S
		/*a,No display;
		**b,buzzer IO changge*/
		
		// I2C lcd switch	//lcd display switch
		#define 	LCD_ON 		

		//无线模块相关	
		//#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		#define 	A5130

		/* 模块个数由下面的参数计算得出,最多支持4个模块！
		0-不启用
		0xff-主模块(包括单模块，必须设置且只有1个)
		0xfe-副模块 (可以有多个，最多3个)
		0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/
		#define 	RF_MODUAL0_SET		0
		#define 	RF_MODUAL1_SET		0
		#define 	RF_MODUAL2_SET		0xff
		#define 	RF_MODUAL3_SET		0

		#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
		#define		LOCK_RF_CNT		0//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
		//----------------------------B function modual setting ------------------------
		#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
		#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
		#define 	BASE_TEST			0	//基站测试
		#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
		#define 	WHITELIST   	0	//白名单功能开关 :0-off

		#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
		#define 	CRS2   				1	//CRS2协议功能开关 :0-off
		#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
		#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
		#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
		#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码
		#define	  AUX_ATT				0	//考勤
		#define   AUX_BEATS			0	//心跳
		#define 	BROADCAST			0	//广播信息信标
		
		
		#define 	CRC16_CHECK_KEYPAD		0//1	//CRC16校验与键盘之间的数据;
		#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据
		
		#define 	AES						0//1
		#define 	NFC						1//
#define 	_NEW_NFC_APP	//优化NFC寻卡		
		#define		NFC_T2
		#define 	T2_KEY60			//对platform来说，就是是否开启一个新的timer定时器
		#define 	TCPIP					0//1
		#define 	USB3300		1 //highspeed
		
		//-----from base_core.h--------
		#define 	RF_5G8
		#define 	KEYPAD60						//第二版语音协议-60路
		#define 	VOICE_PROTOCOL_3RD	//第三版语音协议-60路+可靠传输(基于第二版)	
		#define   BUF_ALERT2   //支持键盘重传语音单独连续点名
		/*开启此宏定义，投票数据处理(rf接收和rpt to pc的投票数据)就在主程序循环中进行，否则在中断里直接处理(默认)	*/
		#define 	MAINLOOP_PROCESS_VOTE		
		
			// <e> test version	
			//<i> SW1=100 for test version
			#define 	VER_TEST		 1
			#if  (VER_TEST==1)
			#define 	SW1    100
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    5//4//3//2//1
			#endif			
			// </e> 

			// <e> release version
			//<i> this is release version
			#define 	VER_RELEASE		 0
			#if (VER_RELEASE==1)
			// <o> SW1	
			#define 	SW1    0
			// <o> SW2		
			#define 	SW2    4	
			// <o> SW3				
			#define 	SW3    3	
			#endif
			// </e> 
			
//		////基站固件版本
////		#define 	SW1    0
////		#define 	SW2    4
////		#define 	SW3    3//2//1		
//		#define 	SW1    1//TEST_SW1
//		#define 	SW2    0
//		#define 	SW3    0//24

// </h>

// <h> CRS200_5G8 config
//<i> hardware:200/400S board
//<i> RF:5.8G-A5130 ;2 rf modual:timing switch work-ABABAB.....
//<i> usb High speed(usb3300 ENABLE)
#elif (BASE_MODEL ==CRS200_5G8)
		//--------------1 HARDWARE_SETTING  --------------------------------------------			
		//硬件代号
		#define 	HMODEL 0xCA	//202
		#define 	BASE_TYPE 	TYPE_T2

		//#define 	BASE_HARDWARE_T2			
		#define 	BASE_HARDWARE_200S
		/*a,No display;
		**b,buzzer IO changge*/
		
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		//#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		#define 	A5130

		/* 模块个数由下面的参数计算得出,最多支持4个模块！
		0-不启用
		0xff-主模块(包括单模块，必须设置且只有1个)
		0xfe-副模块 (可以有多个，最多3个)
		0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/
		#define 	RF_MODUAL0_SET		0
		#define 	RF_MODUAL1_SET		0xff
		#define 	RF_MODUAL2_SET		0xfb
		#define 	RF_MODUAL3_SET		0

		#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
		#define		LOCK_RF_CNT		0//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
		//----------------------------B function modual setting ------------------------
		#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
		#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
		#define 	BASE_TEST			0	//基站测试
		#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
		#define 	WHITELIST   	0	//白名单功能开关 :0-off

		#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
		#define 	CRS2   				1	//CRS2协议功能开关 :0-off
		#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
		#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
		#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
		#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码
		#define	  AUX_ATT				0	//考勤
		#define   AUX_BEATS			0	//心跳
		#define 	BROADCAST			0	//广播信息信标
		
		
		#define 	CRC16_CHECK_KEYPAD		0//1	//CRC16校验与键盘之间的数据;
		#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据
		
		#define 	AES						0//1
		#define 	NFC						1//
		#define 	_NEW_NFC_APP	//优化NFC寻卡		
		#define		NFC_T2
		#define 	T2_KEY60			//对platform来说，就是是否开启一个新的timer定时器
		#define 	TCPIP					0//1
		#define 	USB3300				1 //highspeed
		
		//-----from base_core.h--------
		#define 	RF_5G8
		#define 	KEYPAD60						//第二版语音协议-60路
		#define 	VOICE_PROTOCOL_3RD	//第三版语音协议-60路+可靠传输(基于第二版)	
		#define   BUF_ALERT2   //支持键盘重传语音单独连续点名
		/*开启此宏定义，投票数据处理(rf接收和rpt to pc的投票数据)就在主程序循环中进行，否则在中断里直接处理(默认)	*/
		#define 	MAINLOOP_PROCESS_VOTE		
		
		#define 	MULTI_5G8			1
		
		
			// <e> test version	
			//<i> SW1=100 for test version
			#define 	VER_TEST		 1
			#if  (VER_TEST==1)
			#define 	SW1    100
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    1
			#endif			
			// </e> 

			// <e> release version
			//<i> this is release version
			#define 	VER_RELEASE		 0
			#if (VER_RELEASE==1)
			// <o> SW1	
			#define 	SW1    0
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    0	
			#endif
			// </e> 

// </h>

// <h> EVS200 config
//<i> hardware:200/400S board
//<i> RF:cc2500 ;4 rf modual-RF comm
//<i> usb High speed(usb3300 ENABLE)
#elif (BASE_MODEL == EVS200) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCB	
		#define 	BASE_TYPE 	TYPE_EVS200
		
		//#define 	BASE_HARDWARE_T2	
		#define 	BASE_HARDWARE_200S
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		//#define 	SI24R1
		#define 	CC2500
		//#define 	CC1101
		//#define 	A5130

		/* 模块个数由下面的参数计算得出,最多支持4个模块！
		0-不启用
		0xff-主模块(包括单模块，必须设置且只有1个)
		0xfe-副模块 (可以有多个，最多3个)
		0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/
		#define 	RF_MODUAL0_SET		0xff//
		#define 	RF_MODUAL1_SET		0xfe
		#define 	RF_MODUAL2_SET		0xfe
		#define 	RF_MODUAL3_SET		0xfe

		#define 	RF_SPEED			0	//无线模块通信速率：0-250K;	1-1M;	2-2M
		#define		LOCK_RF_CNT		0	//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数	
		//----------------------------B function modual setting ------------------------
		#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
		#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
		#define 	BASE_TEST			1	//基站测试
		#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
		#define 	WHITELIST   	0	//白名单功能开关 :0-off

		#define 	NO_ID_MODE  	0//1	//1-不支持id模式; 0-支持id模式;
		#define 	CRS2   				0//1	//CRS2协议功能开关 :0-off
		#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
		#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
		#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制		
		#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码
		#define	  AUX_ATT				0	//考勤
		#define   AUX_BEATS			0	//心跳
		#define 	BROADCAST			0	//广播信息信标
		
		#define 	CRC16_CHECK_KEYPAD		1	//CRC16校验与键盘之间的数据;
		#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据
		
		#define 	AES						1 //需要打开和键盘的CRC校验 CRC16_CHECK_KEYPAD
		#define 	NFC						1
			#define	 	NFC_G1
		#define 	TCPIP					1   
		
			// <e> test version	
			//<i> SW1=100 for test version
			#define 	VER_TEST		 1
			#if  (VER_TEST==1)
			#define 	SW1    100
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    73
			#endif			
			// </e> 

			// <e> release version
			//<i> this is release version
			#define 	VER_RELEASE		 0
			#if (VER_RELEASE==1)
			// <o> SW1	
			#define 	SW1    0
			// <o> SW2		
			#define 	SW2    2	
			// <o> SW3				
			#define 	SW3    0	
			#endif
			// </e> 		
		////基站固件版本
		//formal version
//		#define 	SW1    0
//		#define 	SW2    2//1		
//		#define 	SW3    0			
		//test Version
//		#define 	SW1    TEST_SW1
//		#define 	SW2    0
//		#define 	SW3    73//70//69//68//66//67//65//64//63//62//61//60//59//58//57//56//55//54//53//52//0			
//		//debug//47//46//45//44//43//42//41//40//39//38//37//36//35//34//33//32//31//30//29//28//27//26//25//24//23//22//21//20//19//18//17//16//15//14//13//12//10//9//8//7//6//5//4//3//2//1

//</h>


// <h> CRS200 config
//<i> hardware:200/400S board
//<i> RF:24L01 ;2 rf modual-RF com and whitelist
//<i> usb High speed(usb3300 ENABLE)
//<i>rf modual monitor
#elif (BASE_MODEL == CRS200) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCE
		#define 	BASE_TYPE 	TYPE_CRS200	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_200S
		
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		//#define 	A5130	


			/* 模块个数由下面的参数计算得出,最多支持4个模块！
			0-不启用
			0xff-主模块(包括单模块，必须设置且只有1个)
			0xfe-副模块 (可以有多个，最多3个)
			0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/		
			#define 	RF_MODUAL0_SET		0//xff
			#define 	RF_MODUAL1_SET		0xff
			#define 	RF_MODUAL2_SET		0xfb
			#define 	RF_MODUAL3_SET		0//xfb	
			
			#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
			#define		LOCK_RF_CNT		2//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
			//#define 	KEYPAD_TYPE		KP_T1LITE	//适配特殊键盘，0-通用;other-特殊键盘代号
			//----------------------------B function modual setting ------------------------
			#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
			#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
			#define 	BASE_TEST			1	//基站测试
			#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
			#define 	WHITELIST   	1	//白名单功能开关 :0-off

			#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
			#define 	CRS2   				1	//CRS2协议功能开关 :0-off
			#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
			#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
			#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
			#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码 0-off;1-on
			#define	  AUX_ATT				0	//考勤
			#define   AUX_BEATS			0	//心跳
			#define 	BROADCAST			1	//广播信息信标
			
			#define 	CRC16_CHECK_KEYPAD		2//1	//0-off,1-26bytes,2-CRC22bytes,3- 22or26bytes; CRC16校验与键盘之间的数据;因为AES包括了crc所以不能和AES功能同时开启;
			#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

			#define 	AES						0//1
			#define 	NFC						1
#define 	_NEW_NFC_APP	//优化NFC寻卡				
				#define	NFC_STD_T1LITE
				#define	NFC_STD			
				//#define		NFC_T2
			#define 	TCPIP					1 
			
			#define 	USB3300		1 //highspeed
			
			//-----from base_core.h--------
			#define 	RF_MODUAL_MONITOR		//rf 模块监测			


			// <e> test version	
			//<i> SW1=100 for test version
			#define 	VER_TEST		 1
			#if  (VER_TEST==1)
			#define 	SW1    100
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    87
			#endif			
			// </e> 

			// <e> release version
			//<i> this is release version
			#define 	VER_RELEASE		 0
			#if (VER_RELEASE==1)
			// <o> SW1	
			#define 	SW1    0
			// <o> SW2		
			#define 	SW2    2	
			// <o> SW3				
			#define 	SW3    3	
			#endif
			// </e> 
			////基站固件版本
			//formal version
//			#define 	SW1    0
//			#define 	SW2    2//1		
//			#define 	SW3    3//2//1//0			
			//cong V100.0.18版本开始使用内置天线模块
//			#define 	SW1    TEST_SW1
//			#define 	SW2    0
//			#define 	SW3    87//86//85//84//83//82//81//80//74//73//72//71//70//69//68//67//66//63//62//61//57//55//54//53//52//50//49//48//47//46//45//44//43//42//41//40//39//38//37//36//35//33//32//30//29//28//27//26//23//22//21//20//19//18//17//16//15//14//13//12//11//10//9//8//7//6//5//4//3//2//1//0

// </h> 


#elif (BASE_MODEL == CRS200_NENGLONG) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCC
		#define 	BASE_TYPE 	TYPE_CRS200_NL //CRS200_NENGLONG	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_200S
		
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		//#define 	A5130
	
		/*		
		//log_mod=7;lock_chan=80;no_match code;com speed=1M;rf_sync=0x25A4*/
			/* 模块个数由下面的参数计算得出,最多支持4个模块！
			0-不启用
			0xff-主模块(包括单模块，必须设置且只有1个)
			0xfe-副模块 (可以有多个，最多3个)
			0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/		
			#define 	RF_MODUAL0_SET		0//xff
			#define 	RF_MODUAL1_SET		0xff
			#define 	RF_MODUAL2_SET		0//xfb
			#define 	RF_MODUAL3_SET		0//xfb	
			
			#define		LOCK_RF_CNT		0//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
			#define 	RF_SPEED			1//无线模块通信速率：0-250K;	1-1M;	2-2M
			//----------------------------B function modual setting ------------------------			
			#define 	FAST_MATCH   	0//1	//快速配对功能开关 :0-off
			#define 	UPDATE_KP   	0//1	//基站广播更新键盘固件功能开关
			#define 	BASE_TEST			0//1	//基站测试
			#define 	MON_FREQ   		0//1	//同频检测功能开关 :0-off
			#define 	WHITELIST   	1//0	//白名单功能开关 :0-off

			#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
			#define 	CRS2   				1	//CRS2协议功能开关 :0-off
			#define 	LOCK_LOGMODE  7	//固件登录模式功能开关 :0-off ,on -要固定的logmode
			#define 	LOCK_CHAN   	80	//固定频点功能								,on -要固定的channel
			#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
			#define 	NO_MATCHCODE  1	//与键盘之间的通信数据中没有包括配对码,0-off;1-on
			#define	  AUX_ATT				1	//考勤
			#define   AUX_BEATS			0	//心跳
			#define 	BROADCAST			0	//广播信息信标
			
			#define 	CRC16_CHECK_KEYPAD		1	//CRC16校验与键盘之间的数据;因为AES包括了crc所以不能和AES功能同时开启;
			#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

			#define 	AES						0//1
			#define 	NFC						1
				#define	NFC_STD_T1LITE
				#define	NFC_STD			
				//#define		NFC_T2
			#define 	TCPIP					0//1 
			
			////基站固件版本
			#define 	SW1    TEST_SW1
			#define 	SW2    0
			#define 	SW3    5//4//3//2//1


// <h> CRS200_433 config
//<i> hardware:200/400S board
//<i> RF:CC1101-433M ;2 rf modual-RF com 
//<i> usb High speed(usb3300 ENABLE)
//<i>rf modual monitor
#elif (BASE_MODEL == CRS200_433) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCF
		#define 	BASE_TYPE 	TYPE_CRS200_433	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_200S
		
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		
		
		//无线模块相关	
		//#define 	SI24R1
		//#define 	CC2500
		#define 	CC1101
		//#define 	A5130

		/* 模块个数由下面的参数计算得出,最多支持4个模块！
		0-不启用
		0xff-主模块(包括单模块，必须设置且只有1个)
		0xfe-副模块 (可以有多个，最多3个)
		0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/
		#define 	RF_MODUAL0_SET		0xff
		#define 	RF_MODUAL1_SET		0//0xfe
		#define 	RF_MODUAL2_SET		0//xfb
		#define 	RF_MODUAL3_SET		0xfe

		#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
		#define		LOCK_RF_CNT		0//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
		//----------------------------B function modual setting ------------------------
		#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
		#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
		#define 	BASE_TEST			1	//基站测试
		#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
		#define 	WHITELIST   	0	//白名单功能开关 :0-off

		#define 	NO_ID_MODE  	0	//1-不支持id模式; 0-支持id模式;
		#define 	CRS2   				0//1	//CRS2协议功能开关 :0-off
		#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
		#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
		#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制		
		#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码
		#define	  AUX_ATT				0	//考勤
		#define   AUX_BEATS			0	//心跳
		#define 	BROADCAST			0	//广播信息信标
		
		#define 	CRC16_CHECK_KEYPAD		1	//CRC16校验与键盘之间的数据;
		#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

		#define 	AES						0//1
		#define 	NFC						1
			#define		NFC_T2
		#define 	TCPIP					1 
		#define 	USB3300		1 //highspeed

		//-----from base_core.h--------
		#define 	RF_MODUAL_MONITOR		//rf 模块监测

			// <e> test version	
			//<i> SW1=100 for test version
			#define 	VER_TEST		 1
			#if  (VER_TEST==1)
			#define 	SW1    100
			// <o> SW2		
			#define 	SW2    3	
			// <o> SW3				
			#define 	SW3    13//12//11//10//9//8//7//6//5//4//3//2//1
			#endif			
			// </e> 

			// <e> release version
			//<i> this is release version
			#define 	VER_RELEASE		 0
			#if (VER_RELEASE==1)
			// <o> SW1	
			#define 	SW1    0
			// <o> SW2		
			#define 	SW2    3	
			// <o> SW3				
			#define 	SW3    0	
			#endif
			// </e> 
//		#define 	SW1    0
//		#define 	SW2    3
//		#define 	SW3    0		
		////基站固件版本
		//从V100.3.6开始使用两个模块!!
//		#define 	SW1    TEST_SW1
//		#define 	SW2    3
//		#define 	SW3    13//12//11//10//9//8//7//6//5//4//3//2//1

//</h>


// <h> EVS100 config (full speed)
//<i> hardware:100S board
//<i> RF:cc2500 ;1 rf modual-RF com 
//<i> usb Full speed(usb3300 DISABLE)
#elif (BASE_MODEL == EVS100) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCD	
		#define 	BASE_TYPE 	TYPE_EVS100	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_100S
		
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		//#define 	SI24R1
		#define 	CC2500
		//#define 	CC1101
		//#define 	A5130

		/* 模块个数由下面的参数计算得出,最多支持4个模块！
		0-不启用
		0xff-主模块(包括单模块，必须设置且只有1个)
		0xfe-副模块 (可以有多个，最多3个)
		0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/
		#define 	RF_MODUAL0_SET		0//xff
		#define 	RF_MODUAL1_SET		0//0xfe
		#define 	RF_MODUAL2_SET		0//xfb
		#define 	RF_MODUAL3_SET		0xff

		#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
		#define		LOCK_RF_CNT		0//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
//		#define 	FIX_RF_TX_BEACON_CNT	0	//发送信标的无线模块个数,是固定的，与sdk设置的个数无关;0-只有主模块发送信标;
		//----------------------------B function modual setting ------------------------
		#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
		#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
		#define 	BASE_TEST			1	//基站测试
		#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
		#define 	WHITELIST   	0	//白名单功能开关 :0-off

		#define 	NO_ID_MODE  	0//1	//1-不支持id模式; 0-支持id模式;
		#define 	CRS2   				0//1	//CRS2协议功能开关 :0-off
		#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
		#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
		#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
		#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码
		#define	  AUX_ATT				0	//考勤
		#define   AUX_BEATS			0	//心跳
		#define 	BROADCAST			0	//广播信息信标
		#define 	AES						1
		
		#if (AES==1)
		#define 	CRC16_CHECK_KEYPAD		1	////0-off,1-26bytes,2-CRC22bytes,3- 22or26bytes;CRC16校验与键盘之间的数据;
		#else
		#define 	CRC16_CHECK_KEYPAD		1	//0-off,1-26bytes,2-CRC22bytes,3- 22or26bytes;CRC16校验与键盘之间的数据;
		#endif				
		#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据


		#define 	NFC						0//1
			#define		NFC_T2
		#define 	TCPIP					0//1 

	
			// <e> test version	
			//<i> SW1=100 for test version
			#define 	VER_TEST		 0
			#if  (VER_TEST==1)
			#define 	SW1    100
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    8
			#endif			
			// </e> 

			// <e> release version
			//<i> this is release version
			#define 	VER_RELEASE		 1
			#if (VER_RELEASE==1)
			// <o> SW1	
			#define 	SW1    1
			// <o> SW2		
			#define 	SW2    1	
			// <o> SW3				
			#define 	SW3    0	
			#endif
			// </e>
			
		////基站固件版本
//		#define 	SW1    TEST_SW1
//		#define 	SW2    0
//		#define 	SW3    2//1

//</h>

// <h> C100 config (full speed)
//<i> hardware:100S board
//<i> RF:24L01 ;1 rf modual-RF com 
//<i> usb Full speed(usb3300 DISABLE)
#elif (BASE_MODEL == C100) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		// <h> C100 custom 
		//<i> you must choose a BASE Model,then config parameter if you need;
		//<i> you should input test or release version,
		//  <o> Base model
		//   <i> Default:STD
		//   <0=> STD
		//   <1=> NL
		//   <2=> ZDY
		//   <3=> SUPPORT_HS6621_SOC		
		#define 	CUSTOM		3
		

		#if (CUSTOM ==0)
		//硬件代号
		#define 	HMODEL 0xD0
		#define 	BASE_TYPE 	TYPE_C100	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_100S
	
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		//#define 	A5130	


			/* 模块个数由下面的参数计算得出,最多支持4个模块！
			0-不启用
			0xff-主模块(包括单模块，必须设置且只有1个)
			0xfe-副模块 (可以有多个，最多3个)
			0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/		
			#define 	RF_MODUAL0_SET		0//xff
			#define 	RF_MODUAL1_SET		0//xff
			#define 	RF_MODUAL2_SET		0//xfb
			#define 	RF_MODUAL3_SET		0xff	
			
			#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
			#define		LOCK_RF_CNT		0//2//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
			//#define 	KEYPAD_TYPE		KP_T1LITE	//适配特殊键盘，0-通用;other-特殊键盘代号
			//----------------------------B function modual setting ------------------------
			#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
			#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
			#define 	BASE_TEST			1	//基站测试
			#define 	MON_FREQ   		0//1	//同频检测功能开关 :0-off
			#define 	WHITELIST   	0//1	//白名单功能开关 :0-off

			#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
			#define 	CRS2   				1	//CRS2协议功能开关 :0-off
			#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
			#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
			#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
			#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码 0-off;1-on
			#define	  AUX_ATT				0	//考勤
			#define   AUX_BEATS			0	//心跳
			#define 	BROADCAST			1	//广播信息信标
			
			#define 	CRC16_CHECK_KEYPAD		2//1	//0-off,1-26bytes,2-CRC22bytes,3- 22or26bytes; CRC16校验与键盘之间的数据;因为AES包括了crc所以不能和AES功能同时开启;
			#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

			#define 	AES						0//1
			#define 	NFC						0//1
				#define	NFC_STD_T1LITE
				#define	NFC_STD			
				//#define		NFC_T2
			#define 	TCPIP					0//1 

			// <e> standard test version	
			//<i> SW1=100 for test version
			#define 	VER_TEST		 0
			#if  (VER_TEST==1)
			#define 	SW1    100
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    10//9//8
			#endif			
			// </e> 

			// <e> standard release version
			//<i> this is release version
			#define 	VER_RELEASE		 0
			#if (VER_RELEASE==1)
			// <o> SW1	
			#define 	SW1    1
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    0	
			#endif
			// </e> 
#elif  (CUSTOM ==1)	//-------- NL--------------------------------------
		//硬件代号
		#define 	HMODEL 		197//0xD0 //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		#define 	BASE_TYPE 	TYPE_C100	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_100S
	
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		//#define 	A5130	


			/* 模块个数由下面的参数计算得出,最多支持4个模块！
			0-不启用
			0xff-主模块(包括单模块，必须设置且只有1个)
			0xfe-副模块 (可以有多个，最多3个)
			0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/		
			#define 	RF_MODUAL0_SET		0//xff
			#define 	RF_MODUAL1_SET		0//xff
			#define 	RF_MODUAL2_SET		0//xfb
			#define 	RF_MODUAL3_SET		0xff	
			
			#define 	RF_SPEED			1//无线模块通信速率：0-250K;	1-1M;	2-2M
			#define		LOCK_RF_CNT		0//2//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
			//#define 	KEYPAD_TYPE		KP_T1LITE	//适配特殊键盘，0-通用;other-特殊键盘代号
			//----------------------------B function modual setting ------------------------
			#define 	FAST_MATCH   	0//1	//快速配对功能开关 :0-off
			#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
			#define 	BASE_TEST			1	//基站测试
			#define 	MON_FREQ   		0//1	//同频检测功能开关 :0-off
			#define 	WHITELIST   	1	//白名单功能开关 :0-off

			#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
			#define 	CRS2   				1	//CRS2协议功能开关 :0-off
			#define 	LOCK_LOGMODE  7	//固件登录模式功能开关 :0-off ,on -要固定的logmode
			#define 	LOCK_CHAN   	80	//固定频点功能								,on -要固定的channel
			#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
			#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码 0-off;1-on
			#define	  AUX_ATT				0	//考勤
			#define   AUX_BEATS			0	//心跳
			#define 	BROADCAST			0//1	//广播信息信标
			
			#define 	CRC16_CHECK_KEYPAD		1	//0-off,1-26bytes,2-CRC22bytes,3- 22or26bytes; CRC16校验与键盘之间的数据;因为AES包括了crc所以不能和AES功能同时开启;
			#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

			#define 	AES						0//1
			#define 	NFC						0//1
				#define	NFC_STD_T1LITE
				#define	NFC_STD			
				//#define		NFC_T2
			#define 	TCPIP					0//1 

			// <e> CUSTOM_NL test version	
			//<i> SW1=100 for test version
			#define 	VER_TEST		 0
			#if  (VER_TEST==1)
			#define 	SW1    100
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    2
			#endif			
			// </e> 

			// <e> CUSTOM_NL release version
			//<i> this is release version
			#define 	VER_RELEASE		 0
			#if (VER_RELEASE==1)
			// <o> SW1	
			#define 	SW1    0
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    0	
			#endif
			// </e> 
#elif  (CUSTOM ==2)	//-------- ZDY--------------------------------------
		//硬件代号
		#define 	HMODEL 		0xC5 //0xD0	//!!!!与CRS100的ZDY一致
		#define 	BASE_TYPE 	TYPE_C100	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_100S
	
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		//#define 	A5130	


			/* 模块个数由下面的参数计算得出,最多支持4个模块！
			0-不启用
			0xff-主模块(包括单模块，必须设置且只有1个)
			0xfe-副模块 (可以有多个，最多3个)
			0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/		
			#define 	RF_MODUAL0_SET		0//xff
			#define 	RF_MODUAL1_SET		0//xff
			#define 	RF_MODUAL2_SET		0//xfb
			#define 	RF_MODUAL3_SET		0xff	
			
			#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
			#define		LOCK_RF_CNT		0//2//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
			//#define 	KEYPAD_TYPE		KP_T1LITE	//适配特殊键盘，0-通用;other-特殊键盘代号
			//----------------------------B function modual setting ------------------------
			#define 	FAST_MATCH   	0//1	//快速配对功能开关 :0-off
			#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
			#define 	BASE_TEST			1	//基站测试
			#define 	MON_FREQ   		0//1	//同频检测功能开关 :0-off
			#define 	WHITELIST   	0//1	//白名单功能开关 :0-off

			#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
			#define 	CRS2   				1	//CRS2协议功能开关 :0-off
			#define 	LOCK_LOGMODE  7	//固件登录模式功能开关 :0-off ,on -要固定的logmode
			#define 	LOCK_CHAN   	26	//固定频点功能								,on -要固定的channel
			#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
			#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码 0-off;1-on
			#define	  AUX_ATT				0	//考勤
			#define   AUX_BEATS			0	//心跳
			#define 	BROADCAST			0//1	//广播信息信标
			
			#define 	CRC16_CHECK_KEYPAD		1	//0-off,1-26bytes,2-CRC22bytes,3- 22or26bytes; CRC16校验与键盘之间的数据;因为AES包括了crc所以不能和AES功能同时开启;
			#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

			#define 	AES						0//1
			#define 	NFC						0//1
				#define	NFC_STD_T1LITE
				#define	NFC_STD			
				//#define		NFC_T2
			#define 	TCPIP					0//1 

			// <e> CUSTOM_ZDY test version	
			//<i> SW1=100 for test version
			#define 	VER_TEST		 0
			#if  (VER_TEST==1)
			#define 	SW1    100
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    1
			#endif			
			// </e> 

			// <e> CUSTOM_ZDY release version
			//<i> this is release version
			#define 	VER_RELEASE		 0
			#if (VER_RELEASE==1)
			// <o> SW1	
			#define 	SW1    0
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    0	
			#endif
			// </e> 		

#elif  (CUSTOM ==3)	//-------- #define 	SUPPORT_HS6621_SOC		 1--------------------------------------
		#define 	SUPPORT_HS6621_SOC		 1
		//硬件代号
		#define 	HMODEL 		217
		#define 	BASE_TYPE 	TYPE_C100	
//		#define 	CUSTOM_USBD_VID		0x1314	
//		#define 	CUSTOM_USBD_PID		0x1710
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_100S
	
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		//#define 	A5130	


			/* 模块个数由下面的参数计算得出,最多支持4个模块！
			0-不启用
			0xff-主模块(包括单模块，必须设置且只有1个)
			0xfe-副模块 (可以有多个，最多3个)
			0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/		
			#define 	RF_MODUAL0_SET		0//xff
			#define 	RF_MODUAL1_SET		0//xff
			#define 	RF_MODUAL2_SET		0//xfb
			#define 	RF_MODUAL3_SET		0xff	
			
			#define 	RF_SPEED			1//无线模块通信速率：0-250K;	1-1M;	2-2M
			#define		LOCK_RF_CNT		    0//2//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
			//#define 	KEYPAD_TYPE		    KP_T1LITE	//适配特殊键盘，0-通用;other-特殊键盘代号
			//----------------------------B function modual setting ------------------------
			#define 	FAST_MATCH   	    1	//快速配对功能开关 :0-off
			#define 	UPDATE_KP   	    1	//基站广播更新键盘固件功能开关
			#define 	UPDATE_KP_2   	    1	
            #define     TEXT_MESSAGE        0   //使能短信，老版本短信下发，弃用，已用快速下发代替，20230404
			#define 	BASE_TEST			1	//基站测试
			#define 	MON_FREQ   		    1	//同频检测功能开关 :0-off
			#define 	WHITELIST   	    0//1	//白名单功能开关 :0-off

			#define 	NO_ID_MODE  	    1	//1-不支持id模式; 0-支持id模式;
			#define 	CRS2   				1	//CRS2协议功能开关 :0-off
			#define 	LOCK_LOGMODE        0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
			#define 	LOCK_CHAN   	    0	//固定频点功能								,on -要固定的channel
			#define 	MASK_SPEC_CHAN      0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
			#define 	NO_MATCHCODE        0	//与键盘之间的通信数据中没有包括配对码 0-off;1-on
			#define	  AUX_ATT				0	//考勤
			#define   AUX_BEATS			    0	//心跳
			#define 	BROADCAST			1	//广播信息信标
			
			#define 	CRC16_CHECK_KEYPAD	2//1	//0-off,1-26bytes,2-CRC22bytes,3- 22or26bytes; CRC16校验与键盘之间的数据;因为AES包括了crc所以不能和AES功能同时开启;
			#define 	CRC16_CHECK_PC		0			//CRC16校验与pc之间的数据

			#define 	AES					0//1
			#define 	NFC					0//1
            #define	NFC_STD_T1LITE
            #define	NFC_STD			
            //#define		NFC_T2
			#define 	TCPIP				0//1 
            #define 	NETWORK     	    1   //组网
            #define	    SN_LEN				4
            #define     USB_REPORT_MAX      64
			//#define     USB_RX_REMOVE_DUPLICATE
            
            #define 	MD_GEN_LGPKT_CH		1	//通用长包传输通道
            #define 	MD_LIST_MGNT		0	//依赖MD_GEN_LGPKT_CH		
            #define		MD_DOWN_BEACON		1	//快速下发，依赖MD_GEN_LGPKT_CH	
            #define 	MD_EXT_BEACON		1	//扩展信标，依赖MD_GEN_LGPKT_CH	
            
            #define     MD_MULTIPKT_UP      1   //多包上传
			#define		MD_SPECIAL_STOP_PRO	1		//特殊处理停止信标
            #define     MD_FAST_BEACON      1		//tx beacon7

			// <e> SUPPORT_HS6621_SOC test version	
			//<i> SW1=100 for test version
			#define 	VER_TEST		    0
			#if  (VER_TEST==1)
			#define 	SW1    100
			// <o> SW2		
			#define 	SW2    14	
			// <o> SW3				
			#define 	SW3    1
//			#define DEBUG_IO	1//逻辑分析仪IO启用
			#endif			
			// </e> 

			// <e> SUPPORT_HS6621_SOC release version
			//<i> this is release version
			#define 	VER_RELEASE		 1
			#if (VER_RELEASE==1)
			// <o> SW1	
			#define 	SW1    0
			// <o> SW2		
			#define 	SW2    1	
			// <o> SW3				
			#define 	SW3    4	
			#endif
			// </e> 		
			#endif

		// </h> 
		
		
//</h>


// <h> C200 config (fullspeed)
//<i> hardware:200/400S board
//<i> RF:24L01 ;2 rf modual-RF com and whitelist
//<i> usb Full speed(usb3300 DISABLE)
//<i>rf modual monitor
#elif (BASE_MODEL == C200) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCE
		#define 	BASE_TYPE 	TYPE_CRS200 //C200	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_200S
		
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		//#define 	A5130	


			/* 模块个数由下面的参数计算得出,最多支持4个模块！
			0-不启用
			0xff-主模块(包括单模块，必须设置且只有1个)
			0xfe-副模块 (可以有多个，最多3个)
			0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/		
			#define 	RF_MODUAL0_SET		0//xff
			#define 	RF_MODUAL1_SET		0xff
			#define 	RF_MODUAL2_SET		0xfb
			#define 	RF_MODUAL3_SET		0//xfb	
			
			#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
			#define		LOCK_RF_CNT		2//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
			//#define 	KEYPAD_TYPE		KP_T1LITE	//适配特殊键盘，0-通用;other-特殊键盘代号
			//----------------------------B function modual setting ------------------------
			#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
			#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
			#define 	BASE_TEST			1	//基站测试
			#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
			#define 	WHITELIST   	1	//白名单功能开关 :0-off

			#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
			#define 	CRS2   				1	//CRS2协议功能开关 :0-off
			#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
			#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
			#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
			#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码 0-off;1-on
			#define	  AUX_ATT				0	//考勤
			#define   AUX_BEATS			0	//心跳
			#define 	BROADCAST			1	//广播信息信标
			
			#define 	CRC16_CHECK_KEYPAD		2//1	//0-off,1-26bytes,2-CRC22bytes,3- 22or26bytes; CRC16校验与键盘之间的数据;因为AES包括了crc所以不能和AES功能同时开启;
			#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

			#define 	AES						0//1
			#define 	NFC						1
   #define 	_NEW_NFC_APP	//优化NFC寻卡				
				#define	NFC_STD_T1LITE
				#define	NFC_STD			
				//#define		NFC_T2
			#define 	TCPIP					1 
			
			//#define 	USB3300		1 //highspeed
			
			//-----from base_core.h--------
			#define 	RF_MODUAL_MONITOR		//rf 模块监测
			
			// <e> test version	
			//<i> SW1=100 for test version
			#define 	VER_TEST		 1
			#if  (VER_TEST==1)
			#define 	SW1    100
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    5//4//3//2//1
			#endif			
			// </e> 

			// <e> release version
			//<i> this is release version
			#define 	VER_RELEASE		 0
			#if (VER_RELEASE==1)
			// <o> SW1	
			#define 	SW1    1
			// <o> SW2		
			#define 	SW2    0	
			// <o> SW3				
			#define 	SW3    0	
			#endif
			// </e> 

			////基站固件版本
			//formal version
//			#define 	SW1    1
//			#define 	SW2    0		
//			#define 	SW3    0			
//			//cong V100.0.18版本开始使用内置天线模块
//			#define 	SW1    TEST_SW1
//			#define 	SW2    0
//			#define 	SW3    5//4//3//2//1
			
#endif 
// </h>

// </h>


// <<< end of configuration section >>>



#endif //#ifndef 	_OLD_CONFIG_

#endif 	//#ifndef 	_BASE_CONFIG_H_

