

#ifndef 	_PLATFORM_H_
#define 	_PLATFORM_H_

#include "platform_interface.h"
#include "gd32f30x.h"
#include "core_cm4.h"


//临界保护，do{} while的写法确保成对出现，可防止代码光中断后忘记开中断
//__disable_irq()//
//__enable_irq();//
#define PLATFORM_DISABLE_IRQ()          \
        {                               \
            uint32_t LockState;     \
            LockState = __get_PRIMASK();\
            __set_PRIMASK(1);
            
#define PLATFORM_ENABLE_IRQ()           \
            __set_PRIMASK(LockState);   \
        }            


extern unsigned char rx_uart_buf;
extern volatile unsigned short _20ms_timer_count;
extern volatile unsigned char _0s5_flag;
extern volatile unsigned char mainloop_20ms_flag;//_20ms_flag;
extern volatile unsigned char mainloop_2ms5_flag;


/*
*检测当前的tcpip还是usb通信方式
*/
void set_pc_communication_type(unsigned char type);

unsigned char get_pc_communication_type(void);


////中断总开关 
//extern void CLI(void);
//extern void SEI(void);


/*
2019.12.04 实测1ms;
环境：主频168MHz,关闭中断,IO取反用示波器测试!!	*/
void basic_delay_ms( unsigned short  time );

/*
2019.12.04 实测 delay(500) =500us;
环境：主频168MHz,关闭中断,IO取反用示波器测试!!	
由于GPIO无法响应 delayus(1)，所以实际测试delay(500) =500us	*/
void basic_delay_us( unsigned int time );


unsigned short CRC16(const unsigned char *ptr,unsigned char len);


unsigned char get_usb_status(void);

//buzzer ctrl;
void beep_ctrl(unsigned char mode);



//----------------LED  --------------------------------
#define	 LED_NO1 	1
#define	 LED_NO2 	2
#define	 LED_NO3 	3
#define	 LED_NO4 	4
#define	 LED_STA_OFF		0
#define	 LED_STA_ON			1
#define	 LED_STA_TOG		2
void display_led_ctrl(unsigned char led_NO,unsigned char status);
//
//void led_init(void);
void led1_control(unsigned char type);
void led2_control(unsigned char type);


//i2c
void i2c_init( void );
void i2c_start(void);
void i2c_stop(void);
unsigned char i2c_send_byte(unsigned char byt);
unsigned char i2c_read_byte(void);

//e2prom 
unsigned char EE_ReadBytes( unsigned int Addr, unsigned char Array[],unsigned char Len);
void EE_WriteBytes( unsigned int Addr , const unsigned char Array[], unsigned char Len);

//---------------------lcd --------------------------------
void lcd_init(void);

void lcd_back_light_ctrl( unsigned char on_off);

void display_chinese(unsigned short x,unsigned short y 
																		//,unsigned char char_type																	 
																		,const unsigned char *chr
																		,unsigned char len
																		//,unsigned char reverse
																			);
																	
																		
void display_char(unsigned short x,unsigned short y 
																	//,unsigned char char_type																	 
																	,const unsigned char *chr
																	//,unsigned char len
																	//,unsigned char reverse
																		);





																	
																	
																	
																	
//---------------------------- NFC--------------------																	
//rfid card
void rfid_init(void);
//unsigned char rfid_write_card(void);
unsigned char get_rfid_reader_Hard_connect_status(void);
int nfc_write_read_N_block(struct nfc_app_STR *nfc)	;

unsigned char nfc_reader(unsigned char addr,unsigned char cnt,unsigned char *out)	;

//-------------------------	RF --------------
void rf_Irq(unsigned char rf_id);
void rf_initial(unsigned char rf_id);	
void rf_setfreq(unsigned char freq,unsigned char rf_id);
void rf_SendPacket( unsigned char* txbuf, unsigned char Length,unsigned char rf_id );
void rf_set_PA_Mode( unsigned char mode,unsigned char rf_id );
void A5130_send_data_sub(unsigned char *buf,unsigned char count,unsigned char rf_id);
void A5130_send_beacon(void (*send_function)(const unsigned char *,unsigned char id),const unsigned char *tmp,unsigned char rf_id );
//#if	(SUPPORT_HS6621_SOC)
void rf_set_syncode(unsigned short sync,unsigned char sync_cnt,unsigned char rf_seq);
//#else
//void rf_set_syncode(unsigned short sync,unsigned char rf_id);
//#endif
void set_tx_ok_flag(unsigned char flag);
unsigned char get_tx_ok_flag(void);
void waitfor_tx_ok(void);


void uart1_send_datas(unsigned char *pt,unsigned short len);

/**/
void set_hard_flag(unsigned char h_flag);
unsigned char get_hard_flag(void);



#endif //_PLATFORM_H_
