
#ifndef 	_FUNCTION_H_
#define 	_FUNCTION_H_

#include 	"base_config.h"

#ifdef _DEBUG_CORE_
    #include "SEGGER_RTT.h"
    #include "SEGGER_RTT_Conf.h"
#endif

#ifdef 	_OLD_CONFIG_
//*---------
//* 只能开关,禁止修改!!!
//*-----------------------
//#define 	T2							10

//#define 	EVS200					50
//#define 	EVS100					51


//#define 	CRS200					40
//#define 	CRS200_NENGLONG	41
//#define 	CRS200_433			30
//#define 	C100					41

#define 	C200					40
//--------------------------------------



void operation_debug_io(unsigned char nbr);//debug only
#define 	TEST_SW1	100




#ifdef T2
		//--------------1 HARDWARE_SETTING  --------------------------------------------			
		//硬件代号
		#define 	HMODEL 0xCA	//202
		#define 	BASE_TYPE 	T2


		#define 	BASE_HARDWARE_T2			
		//#define 	BASE_HARDWARE_200S
		/*a,No display;
		**b,buzzer IO changge*/
		
		// I2C lcd switch	//lcd display switch
		#define 	LCD_ON 		

		//无线模块相关	
		//#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		#define 	A5130

		/* 模块个数由下面的参数计算得出,最多支持4个模块！
		0-不启用
		0xff-主模块(包括单模块，必须设置且只有1个)
		0xfe-副模块 (可以有多个，最多3个)
		0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/
		#define 	RF_MODUAL0_SET		0
		#define 	RF_MODUAL1_SET		0
		#define 	RF_MODUAL2_SET		0xff
		#define 	RF_MODUAL3_SET		0

		#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
		#define		LOCK_RF_CNT		0//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
		//----------------------------B function modual setting ------------------------
		#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
		#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
		#define 	BASE_TEST			0	//基站测试
		#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
		#define 	WHITELIST   	0	//白名单功能开关 :0-off

		#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
		#define 	CRS2   				1	//CRS2协议功能开关 :0-off
		#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
		#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
		#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
		#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码
		#define	  AUX_ATT				0	//考勤
		#define   AUX_BEATS			0	//心跳
		#define 	BROADCAST			0	//广播信息信标
		
		
		#define 	CRC16_CHECK_KEYPAD		0//1	//CRC16校验与键盘之间的数据;
		#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据
		
		#define 	AES						0//1
		#define 	NFC						1//
#define 	_NEW_NFC_APP	//优化NFC寻卡		
		#define		NFC_T2
		#define 	T2_KEY60			//对platform来说，就是是否开启一个新的timer定时器
		#define 	TCPIP					0//1
		#define 	USB3300		1 //highspeed
		////基站固件版本
//		#define 	SW1    0
//		#define 	SW2    4
//		#define 	SW3    3//2//1		
		#define 	SW1    1//TEST_SW1
		#define 	SW2    0
		#define 	SW3    0//24


#elif defined(EVS200) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCB	
		#define 	BASE_TYPE 	EVS200
		
		//#define 	BASE_HARDWARE_T2	
		#define 	BASE_HARDWARE_200S
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		//#define 	SI24R1
		#define 	CC2500
		//#define 	CC1101
		//#define 	A5130

		/* 模块个数由下面的参数计算得出,最多支持4个模块！
		0-不启用
		0xff-主模块(包括单模块，必须设置且只有1个)
		0xfe-副模块 (可以有多个，最多3个)
		0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/
		#define 	RF_MODUAL0_SET		0xff//
		#define 	RF_MODUAL1_SET		0xfe
		#define 	RF_MODUAL2_SET		0xfe
		#define 	RF_MODUAL3_SET		0xfe

		#define 	RF_SPEED			0	//无线模块通信速率：0-250K;	1-1M;	2-2M
		#define		LOCK_RF_CNT		0	//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数	
		//----------------------------B function modual setting ------------------------
		#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
		#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
		#define 	BASE_TEST			1	//基站测试
		#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
		#define 	WHITELIST   	0	//白名单功能开关 :0-off

		#define 	NO_ID_MODE  	0//1	//1-不支持id模式; 0-支持id模式;
		#define 	CRS2   				0//1	//CRS2协议功能开关 :0-off
		#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
		#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
		#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制		
		#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码
		#define	  AUX_ATT				0	//考勤
		#define   AUX_BEATS			0	//心跳
		#define 	BROADCAST			0	//广播信息信标
		
		#define 	CRC16_CHECK_KEYPAD		1	//CRC16校验与键盘之间的数据;
		#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据
		
		#define 	AES						1 //需要打开和键盘的CRC校验 CRC16_CHECK_KEYPAD
		#define 	NFC						1
			#define	 	NFC_G1
		#define 	TCPIP					1   
		
		
		////基站固件版本
		//formal version
//		#define 	SW1    0
//		#define 	SW2    2//1		
//		#define 	SW3    0			
		//test Version
		#define 	SW1    TEST_SW1
		#define 	SW2    0
		#define 	SW3    73//70//69//68//66//67//65//64//63//62//61//60//59//58//57//56//55//54//53//52//0			
//		//debug//47//46//45//44//43//42//41//40//39//38//37//36//35//34//33//32//31//30//29//28//27//26//25//24//23//22//21//20//19//18//17//16//15//14//13//12//10//9//8//7//6//5//4//3//2//1


#elif defined(CRS200) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCE
		#define 	BASE_TYPE 	CRS200	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_200S
		
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		//#define 	A5130	


			/* 模块个数由下面的参数计算得出,最多支持4个模块！
			0-不启用
			0xff-主模块(包括单模块，必须设置且只有1个)
			0xfe-副模块 (可以有多个，最多3个)
			0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/		
			#define 	RF_MODUAL0_SET		0//xff
			#define 	RF_MODUAL1_SET		0xff
			#define 	RF_MODUAL2_SET		0xfb
			#define 	RF_MODUAL3_SET		0//xfb	
			
			#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
			#define		LOCK_RF_CNT		2//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
			//#define 	KEYPAD_TYPE		KP_T1LITE	//适配特殊键盘，0-通用;other-特殊键盘代号
			//----------------------------B function modual setting ------------------------
			#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
			#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
			#define 	BASE_TEST			1	//基站测试
			#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
			#define 	WHITELIST   	1	//白名单功能开关 :0-off

			#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
			#define 	CRS2   				1	//CRS2协议功能开关 :0-off
			#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
			#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
			#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
			#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码 0-off;1-on
			#define	  AUX_ATT				0	//考勤
			#define   AUX_BEATS			0	//心跳
			#define 	BROADCAST			1	//广播信息信标
			
			#define 	CRC16_CHECK_KEYPAD		2//1	//0-off,1-26bytes,2-CRC22bytes,3- 22or26bytes; CRC16校验与键盘之间的数据;因为AES包括了crc所以不能和AES功能同时开启;
			#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

			#define 	AES						0//1
			#define 	NFC						1
#define 	_NEW_NFC_APP	//优化NFC寻卡				
				#define	NFC_STD_T1LITE
				#define	NFC_STD			
				//#define		NFC_T2
			#define 	TCPIP					1 
			
			#define 	USB3300		1 //highspeed
			////基站固件版本
			//formal version
//			#define 	SW1    0
//			#define 	SW2    2//1		
//			#define 	SW3    3//2//1//0			
			//cong V100.0.18版本开始使用内置天线模块
			#define 	SW1    TEST_SW1
			#define 	SW2    0
			#define 	SW3    87//86//85//84//83//82//81//80//74//73//72//71//70//69//68//67//66//63//62//61//57//55//54//53//52//50//49//48//47//46//45//44//43//42//41//40//39//38//37//36//35//33//32//30//29//28//27//26//23//22//21//20//19//18//17//16//15//14//13//12//11//10//9//8//7//6//5//4//3//2//1//0



#elif defined(CRS200_NENGLONG) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCC
		#define 	BASE_TYPE 	CRS200_NENGLONG	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_200S
		
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		//#define 	A5130
	
		/*		
		//log_mod=7;lock_chan=80;no_match code;com speed=1M;rf_sync=0x25A4*/
			/* 模块个数由下面的参数计算得出,最多支持4个模块！
			0-不启用
			0xff-主模块(包括单模块，必须设置且只有1个)
			0xfe-副模块 (可以有多个，最多3个)
			0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/		
			#define 	RF_MODUAL0_SET		0//xff
			#define 	RF_MODUAL1_SET		0xff
			#define 	RF_MODUAL2_SET		0//xfb
			#define 	RF_MODUAL3_SET		0//xfb	
			
			#define		LOCK_RF_CNT		0//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
			#define 	RF_SPEED			1//无线模块通信速率：0-250K;	1-1M;	2-2M
			//----------------------------B function modual setting ------------------------			
			#define 	FAST_MATCH   	0//1	//快速配对功能开关 :0-off
			#define 	UPDATE_KP   	0//1	//基站广播更新键盘固件功能开关
			#define 	BASE_TEST			0//1	//基站测试
			#define 	MON_FREQ   		0//1	//同频检测功能开关 :0-off
			#define 	WHITELIST   	1//0	//白名单功能开关 :0-off

			#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
			#define 	CRS2   				1	//CRS2协议功能开关 :0-off
			#define 	LOCK_LOGMODE  7	//固件登录模式功能开关 :0-off ,on -要固定的logmode
			#define 	LOCK_CHAN   	80	//固定频点功能								,on -要固定的channel
			#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
			#define 	NO_MATCHCODE  1	//与键盘之间的通信数据中没有包括配对码,0-off;1-on
			#define	  AUX_ATT				1	//考勤
			#define   AUX_BEATS			0	//心跳
			#define 	BROADCAST			0	//广播信息信标
			
			#define 	CRC16_CHECK_KEYPAD		1	//CRC16校验与键盘之间的数据;因为AES包括了crc所以不能和AES功能同时开启;
			#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

			#define 	AES						0//1
			#define 	NFC						1
				#define	NFC_STD_T1LITE
				#define	NFC_STD			
				//#define		NFC_T2
			#define 	TCPIP					0//1 
			
			////基站固件版本
			#define 	SW1    TEST_SW1
			#define 	SW2    0
			#define 	SW3    5//4//3//2//1



#elif defined(CRS200_433) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCF
		#define 	BASE_TYPE 	CRS200_433	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_200S
		
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		
		
		//无线模块相关	
		//#define 	SI24R1
		//#define 	CC2500
		#define 	CC1101
		//#define 	A5130

		/* 模块个数由下面的参数计算得出,最多支持4个模块！
		0-不启用
		0xff-主模块(包括单模块，必须设置且只有1个)
		0xfe-副模块 (可以有多个，最多3个)
		0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/
		#define 	RF_MODUAL0_SET		0xff
		#define 	RF_MODUAL1_SET		0//0xfe
		#define 	RF_MODUAL2_SET		0//xfb
		#define 	RF_MODUAL3_SET		0xfe

		#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
		#define		LOCK_RF_CNT		0//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
		//----------------------------B function modual setting ------------------------
		#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
		#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
		#define 	BASE_TEST			1	//基站测试
		#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
		#define 	WHITELIST   	0	//白名单功能开关 :0-off

		#define 	NO_ID_MODE  	0	//1-不支持id模式; 0-支持id模式;
		#define 	CRS2   				0//1	//CRS2协议功能开关 :0-off
		#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
		#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
		#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制		
		#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码
		#define	  AUX_ATT				0	//考勤
		#define   AUX_BEATS			0	//心跳
		#define 	BROADCAST			0	//广播信息信标
		
		#define 	CRC16_CHECK_KEYPAD		1	//CRC16校验与键盘之间的数据;
		#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

		#define 	AES						0//1
		#define 	NFC						1
			#define		NFC_T2
		#define 	TCPIP					1 
		#define 	USB3300		1 //highspeed
		
		#define 	SW1    0
		#define 	SW2    3
		#define 	SW3    0		
		////基站固件版本
		//从V100.3.6开始使用两个模块!!
//		#define 	SW1    TEST_SW1
//		#define 	SW2    3
//		#define 	SW3    13//12//11//10//9//8//7//6//5//4//3//2//1



#elif defined(EVS100) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCD	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_100S
		
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		//#define 	SI24R1
		#define 	CC2500
		//#define 	CC1101
		//#define 	A5130

		/* 模块个数由下面的参数计算得出,最多支持4个模块！
		0-不启用
		0xff-主模块(包括单模块，必须设置且只有1个)
		0xfe-副模块 (可以有多个，最多3个)
		0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/
		#define 	RF_MODUAL0_SET		0//xff
		#define 	RF_MODUAL1_SET		0//0xfe
		#define 	RF_MODUAL2_SET		0//xfb
		#define 	RF_MODUAL3_SET		0xff

		#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
		#define		LOCK_RF_CNT		0//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
//		#define 	FIX_RF_TX_BEACON_CNT	0	//发送信标的无线模块个数,是固定的，与sdk设置的个数无关;0-只有主模块发送信标;
		//----------------------------B function modual setting ------------------------
		#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
		#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
		#define 	BASE_TEST			1	//基站测试
		#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
		#define 	WHITELIST   	0	//白名单功能开关 :0-off

		#define 	NO_ID_MODE  	0//1	//1-不支持id模式; 0-支持id模式;
		#define 	CRS2   				0//1	//CRS2协议功能开关 :0-off
		#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
		#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
		#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
		#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码
		#define	  AUX_ATT				0	//考勤
		#define   AUX_BEATS			0	//心跳
		#define 	BROADCAST			0	//广播信息信标
		
		#define 	CRC16_CHECK_KEYPAD		0//1	//CRC16校验与键盘之间的数据;
		#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

		#define 	AES						0//1
		#define 	NFC						0//1
			#define		NFC_T2
		#define 	TCPIP					0//1 
		
		////基站固件版本
		#define 	SW1    TEST_SW1
		#define 	SW2    0
		#define 	SW3    2//1

#elif defined(C100) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xD0
		#define 	BASE_TYPE 	C100	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_100S
	
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		//#define 	A5130	


			/* 模块个数由下面的参数计算得出,最多支持4个模块！
			0-不启用
			0xff-主模块(包括单模块，必须设置且只有1个)
			0xfe-副模块 (可以有多个，最多3个)
			0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/		
			#define 	RF_MODUAL0_SET		0//xff
			#define 	RF_MODUAL1_SET		0//xff
			#define 	RF_MODUAL2_SET		0//xfb
			#define 	RF_MODUAL3_SET		0xff	
			
			#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
			#define		LOCK_RF_CNT		0//2//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
			//#define 	KEYPAD_TYPE		KP_T1LITE	//适配特殊键盘，0-通用;other-特殊键盘代号
			//----------------------------B function modual setting ------------------------
			#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
			#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
			#define 	BASE_TEST			1	//基站测试
			#define 	MON_FREQ   		0//1	//同频检测功能开关 :0-off
			#define 	WHITELIST   	0//1	//白名单功能开关 :0-off

			#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
			#define 	CRS2   				1	//CRS2协议功能开关 :0-off
			#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
			#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
			#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
			#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码 0-off;1-on
			#define	  AUX_ATT				0	//考勤
			#define   AUX_BEATS			0	//心跳
			#define 	BROADCAST			1	//广播信息信标
			
			#define 	CRC16_CHECK_KEYPAD		2//1	//0-off,1-26bytes,2-CRC22bytes,3- 22or26bytes; CRC16校验与键盘之间的数据;因为AES包括了crc所以不能和AES功能同时开启;
			#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

			#define 	AES						0//1
			#define 	NFC						0//1
				#define	NFC_STD_T1LITE
				#define	NFC_STD			
				//#define		NFC_T2
			#define 	TCPIP					0//1 
			
			////基站固件版本
			//formal version
//			#define 	SW1    0
//			#define 	SW2    0	
//			#define 	SW3    0	
			//
			#define 	SW1    TEST_SW1
			#define 	SW2    0
			#define 	SW3    2//1



#elif defined(C200) 
		//--------------1 HARDWARE_SETTING  --------------------------------------------	
		//硬件代号
		#define 	HMODEL 0xCE
		#define 	BASE_TYPE 	C200	
		
		//#define 	BASE_HARDWARE_T2	
		//hardware 200s RF modual silk screen:J2-J3-J1-J4
		#define 	BASE_HARDWARE_200S
		
		/*a,No display;
		**b,buzzer IO changge*/
		// I2C lcd switch	//lcd display switch
		//#define 	LCD_ON 		

		//无线模块相关	
		#define 	SI24R1
		//#define 	CC2500
		//#define 	CC1101
		//#define 	A5130	


			/* 模块个数由下面的参数计算得出,最多支持4个模块！
			0-不启用
			0xff-主模块(包括单模块，必须设置且只有1个)
			0xfe-副模块 (可以有多个，最多3个)
			0xfb-白名单专用模块 (只有在开启白名单时才设置)	*/		
			#define 	RF_MODUAL0_SET		0//xff
			#define 	RF_MODUAL1_SET		0xff
			#define 	RF_MODUAL2_SET		0xfb
			#define 	RF_MODUAL3_SET		0//xfb	
			
			#define 	RF_SPEED			0//无线模块通信速率：0-250K;	1-1M;	2-2M
			#define		LOCK_RF_CNT		2//锁定无线模块的个数不被sdk修改;	0-不锁定,其他是锁定具体个数
			//#define 	KEYPAD_TYPE		KP_T1LITE	//适配特殊键盘，0-通用;other-特殊键盘代号
			//----------------------------B function modual setting ------------------------
			#define 	FAST_MATCH   	1	//快速配对功能开关 :0-off
			#define 	UPDATE_KP   	1	//基站广播更新键盘固件功能开关
			#define 	BASE_TEST			1	//基站测试
			#define 	MON_FREQ   		1	//同频检测功能开关 :0-off
			#define 	WHITELIST   	1	//白名单功能开关 :0-off

			#define 	NO_ID_MODE  	1	//1-不支持id模式; 0-支持id模式;
			#define 	CRS2   				1	//CRS2协议功能开关 :0-off
			#define 	LOCK_LOGMODE  0	//固件登录模式功能开关 :0-off ,on -要固定的logmode
			#define 	LOCK_CHAN   	0	//固定频点功能								,on -要固定的channel
			#define 	MASK_SPEC_CHAN 0 //屏蔽指定的频点: 0-off			,on -开启跳过指定频点功能;//锐捷定制
			#define 	NO_MATCHCODE  0	//与键盘之间的通信数据中没有包括配对码 0-off;1-on
			#define	  AUX_ATT				0	//考勤
			#define   AUX_BEATS			0	//心跳
			#define 	BROADCAST			1	//广播信息信标
			
			#define 	CRC16_CHECK_KEYPAD		2//1	//0-off,1-26bytes,2-CRC22bytes,3- 22or26bytes; CRC16校验与键盘之间的数据;因为AES包括了crc所以不能和AES功能同时开启;
			#define 	CRC16_CHECK_PC				0			//CRC16校验与pc之间的数据

			#define 	AES						0//1
			#define 	NFC						1
#define 	_NEW_NFC_APP	//优化NFC寻卡				
				#define	NFC_STD_T1LITE
				#define	NFC_STD			
				//#define		NFC_T2
			#define 	TCPIP					1 
			
			//#define 	USB3300		1 //highspeed
			////基站固件版本
			//formal version
//			#define 	SW1    1
//			#define 	SW2    0		
//			#define 	SW3    0			
//			//cong V100.0.18版本开始使用内置天线模块
			#define 	SW1    TEST_SW1
			#define 	SW2    0
			#define 	SW3    5//4//3//2//1
			
#endif 

#endif  //









//FCCFE 模式
#define 	FCCCE	

//频点个数
#if defined(CC1101)
	#define 	FREQ_MAX		32
#elif defined(A5130)	
	#define 	FREQ_MAX		12//24
#else
	#define 	FREQ_MAX		80
#endif 

//------------------------- Next is function declare -------------------------------------------------------------

/*
初始化基站功能模块，所有的！！！
*/
void function_init_all(void);


void user__pc_cmd_ack(unsigned char cmd,unsigned char type, const unsigned char *ack_buf,unsigned char type_data_len);




// --------- 2 whitelist 白名单 -------------------------------------
/*
初始化白名单相关参数
*/
void whitelist_init(void);

/*
白名单功能总入口
input:来自pc/SDK的数据
*/
void whitelist_enter(const unsigned char *rxpc);	


/*
查找指定的list,返回位置指针
return:NULL-没有在名单里
	*unsigned char 
*/
unsigned char *search_special_list(const unsigned char *ptr);

/*
基站回复键盘的白名单申请
called by 基站发送信标函数中！
*/
unsigned char  base_confirm_keypad_whitelist_request(void);
	
/*
基站记录白名单申请
*/
unsigned char keypad_idsn_record_whitelist_request(const unsigned char *rxkp);


//白名单授权相关
void whitelist__2ms5_call(void);
/*
* 删除所有名单时*/
void auth_all_keypad(void);

/*
* 删除单个白名单时*/
void auth_special_keypad(const unsigned char *sn);

//------------3 fast match -------------------------------------------------------------
/*
检测 pc设置投票信标类型是否是快速配对 40 
called by pc设置投票信标
*/
void fastmatch_enter_exit(const unsigned char *rxpc);

/*
快速配对模式下，加载相关数据到投票信标中
called by 基站发送投票信标
*/
unsigned char fastmatch_load_info_to_vote_beacon(unsigned char *ptr);

/*
检测接收到的键盘数据是否正确，如果正确配对成功，切换到下一个快速配对id
配对id在键盘数据中的位置是不同的
	id模式下byte6-7
	SN模式下byte11-12
	CRS2模式下 byte19-20
called by 接收键盘函数
*/
unsigned char fastmatch_success_check(const unsigned char *rxkp);

extern unsigned char fastmatch_status(void);

/*
快速配对开关函数，
*/
extern void fastmatch_switch(unsigned char on_off);


unsigned char check_fastmatch_lowerPA(void);

/*
sdk读取快速配对下低功耗设置状态*/
void fastmatch_lowerPA_ack(void);
/*
sdk设置快速配对下无线模块低功率设置开关*/
void fastmatch_lowerPA_setup(const unsigned char *rxpc);	



//----------------------4 , 基站测试 ------------------------------------------------
/*
基站测试处理
this function called by main loop 
*/
void basetest_progress(void);

/*
初始化基站测试相关固件
*/
void basetest_init(void);

/*
获取基站升级状态
*/
unsigned char basetest_get_status(void);
/*
接收并且加载ack pc 数据
*/
//void basetest_load_info_ack_pc(unsigned char *ack_buf);
void basetest_rx_and_ack_pc(const unsigned char *rxpc,unsigned char *ack_buf);



//-------------------------5 基站升级键盘固件 --------------------
/*
基站升级键盘固件之 基站与pc之间的通信入口，也是升级功能的总入口！
call by rx_pc_0x61
*/
void update_kp_enter(const unsigned char *rx_pc);

/*
基站升级键盘固件 之 基站与键盘之间的通信
this function called by base send beacon(2.5ms)
*/
unsigned char update_kp_progress(void);	

/*
保存键盘的回应数据 
called by 基站处理键盘转发给pc的数据处理函数
return 1-有键盘回应
*/
unsigned char save_keypad_ack_data(const unsigned char *rxkp);

/*
获取更新状态
 0- 没有进入更新模式
*/
unsigned char update_get_status(void);


/*
*/
void update_monitor_sdk_connect(void);
	

//-------------------------------6 监测同频点的基站干扰 --------------------------------------
/*
pc发送命令开启搜索新频点，
*/
void auto_search_freq_enter(void);

/*
监测无线键盘数据 
called by 无线接收函数！！
*/
unsigned char monitor_rf_data(unsigned char *rx_kp);

/*
基站检测当前频点是否有干扰，
如果有干扰，上报给pc,查找干净的频点
called by 20ms 
*/
void monitor_freq_process(void);
	
unsigned char get_same_freq_lcd_display(void);



//------------------------ 7 nfc的应用---------------------
void NFC_monitor(void);
void base_record_keypad_NFC_info(const unsigned char *info);



//------------------------- 8  T2语音基站显示 --------------------------
void lcd_display_menu(void);
void lcd_display_same_freq_distrub(unsigned char );
void T2_voice_base_dispaly_main_loop(void);


//---------------------- 9  AES加密---------------------------------------
void aes_init(void);

/*
*更新秘钥，快速配对启动时被调用！
*/
void aes_keycode_upgrade(void);

/*
*快速配对时 增加aes秘钥的传送;
*
*/
void aes_load_fastmatch_data(unsigned char *fdata);

/*
* 0x61 cmd
*/
void process_pc_aes_config(const unsigned char *rx_pc);


void rf_Encrypt(unsigned char *src);
unsigned char rf_Decrypt(unsigned char *src);
void get_aes_key(unsigned char *key);
/*
获取AES加密的状态：不加密，128 or 256
*/
unsigned char get_aes_status(void);



//---------------------------10 Ethernet W5500 ---------------------------------
void w5500_init(void);
unsigned char tcp_send_data_to_pc(unsigned char *buff,unsigned short len);
void do_tcp_server(void);
void _0x61_tcpip_sub(const unsigned char *rxpc);


//-------------------------- 11 broadcast ------------------------------
void broadcast_config(const unsigned char *rx_pc);
void base_broadcast_process_2ms5(void);
void startup_broadcast(void);
unsigned char process_keypad_broadcast_requst(unsigned char request);
unsigned char det_blank_content(void);

//-------------------------- 12 msg broadcast ------------------------------
//unsigned char msg_get_pc_data(unsigned char *buf,unsigned int buf_len);
//unsigned char msg_get_pc_data(unsigned char flag, const unsigned char *buf, unsigned char pack_all,unsigned int buf_len);
unsigned char msg_get_pc_data(const unsigned char *PC_buf);//, unsigned char *Save_buf);
void msg_polling(void);
void msg_send(unsigned char *Send_buf);
unsigned char msg_get_status(void);
void msg_set_status(unsigned char status);
void msg_clr_len(void);

//-------------------------- 13 network ------------------------------------
void network_polling(unsigned char mode);
unsigned char network_get_netseq(void);
void network_set_netseq_change(void);
unsigned short network_get_pwd(void);
void network_set_pwd(unsigned short pwd);
unsigned char network_get_name(unsigned char *buf, unsigned char buflen);
unsigned char network_set_name(unsigned char *buf, unsigned char buflen);
unsigned char network_get_nameview(void);
void network_set_nameview(unsigned char view);

//-------------------------- 14 list_name ------------------------------------
void list__init_all(void);
void user_ops_list(const unsigned char *rxpc);
unsigned short list__fetch_e2prom(void);

//-------------------------- debug ---------------------------
void _debug_function_enter(const unsigned char *in);

#endif //_FUNCTION_H_


