#ifndef __HW_MCUIO_H__
#define __HW_MCUIO_H__

#define MCU_STM32F4XX   0
#define MCU_GD32F30X    1

#include "function.h"

#if ( MCU_STM32F4XX == 1 )
    #include "stm32f4xx_hal.h"
    #define HW_GPIO_PortDef GPIO_TypeDef*
//    typedef GPIO_TypeDef HW_GPIO_PortDef;
#elif ( MCU_GD32F30X == 1 )
    #include "gd32f30x_gpio.h"
    #include "gd32f30x_exti.h"
    
//    typedef uint32_t HW_GPIO_PortDef;
    #define HW_GPIO_PortDef uint32_t
#endif

#define RF_SPI_TIMEOUT 20000          // SPI的超时计数，每次只是单纯的计数--

typedef struct
{
  uint32_t Pin;       /*!< Specifies the GPIO pins to be configured.
                           This parameter can be any value of @ref GPIO_pins_define */

  uint32_t Mode;      /*!< Specifies the operating mode for the selected pins.
                           This parameter can be a value of @ref GPIO_mode_define */

  uint32_t Pull;      /*!< Specifies the Pull-up or Pull-Down activation for the selected pins.
                           This parameter can be a value of @ref GPIO_pull_define */

  uint32_t Speed;     /*!< Specifies the speed for the selected pins.
                           This parameter can be a value of @ref GPIO_speed_define */

  uint32_t Alternate;  /*!< Peripheral to be connected to the selected pins. 
                            This parameter can be a value of @ref GPIO_Alternate_function_selection */
  uint32_t Port;
}HW_GPIO_InitTypeDef;




// GPIO适配层

#if ( MCU_STM32F4XX == 1 )
    
    #define HW_GPIO_MODE_AIN GPIO_MODE_ANALOG              /*!< analog input mode */
//    #define HW_GPIO_MODE_FLOATING GPIO_MODE_IN_FLOATING /*!< floating input mode */
    #define HW_GPIO_MODE_IPD GPIO_MODE_INPUT              /*!< pull-down input mode */
    #define HW_GPIO_MODE_IPU GPIO_MODE_INPUT              /*!< pull-up input mode */
    #define HW_GPIO_MODE_OUT_OD GPIO_MODE_OUTPUT_OD        /*!< GPIO output with open-drain */
    #define HW_GPIO_MODE_OUT_PP GPIO_MODE_OUTPUT_PP        /*!< GPIO output with push-pull */
    #define HW_GPIO_MODE_AF_OD GPIO_MODE_AF_OD          /*!< AFIO output with open-drain */
    #define HW_GPIO_MODE_AF_PP GPIO_MODE_AF_PP

    #define HW_GPIO_SPEED_LOW GPIO_SPEED_FREQ_LOW      /*!< output max speed 2MHz */
    #define HW_GPIO_SPEED_MEDIUM GPIO_SPEED_FREQ_MEDIUM  /*!< output max speed 10MHz */
    #define HW_GPIO_SPEED_HIGH GPIO_SPEED_FREQ_HIGH   /*!< output max speed 50MHz */
    #define HW_GPIO_SPEED_VERY_HIGH GPIO_SPEED_FREQ_VERY_HIGH /*!< GPIO very high output speed, max speed more than 50MHz */

    #define HW_GPIO_Init(Port, init) HAL_GPIO_Init(Port, init)
    #define HW_GPIO_ReadPin(Port, Pin) HAL_GPIO_ReadPin(Port, Pin)
    #define HW_GPIO_SetPin(Port, Pin) HAL_GPIO_WritePin(Port, Pin, GPIO_PIN_SET)
    #define HW_GPIO_ResetPin(Port, Pin) HAL_GPIO_WritePin(Port, Pin, GPIO_PIN_RESET)
    #define HW_GPIO_TogglePin(Port, Pin) HAL_GPIO_TogglePin(Port, Pin)
    
    #define HW_RF_SPI_Init  MX_SPI1_Init
    
    #define HW_DelayMs HAL_Delay
#elif ( MCU_GD32F30X == 1 )
    void HW_GD_GPIO_Init(HW_GPIO_PortDef Port, HW_GPIO_InitTypeDef *GPIO_init);
    void HW_GD_GPIO_TogglePin(HW_GPIO_PortDef Port, uint32_t Pin);
    void HW_GD_Delay(uint32_t DelayMs);
    void HW_GD_IncTick(void);
    void HW_GD_SPI0_Init(void);
    uint8_t HW_GD_SPI0_TransmitReceive(uint8_t *txbuf, uint8_t *rxbuf, uint16_t len);
    uint8_t HW_GD_CUSTOM_HID_REPORT_SEND(uint8_t *buf, uint16_t len);
    uint8_t HW_GD_SPI0_TransmitOneByte(uint8_t Data);
    uint8_t HW_GD_SPI0_ReceiveOneByte(void);

    //GPIO
    #define  GPIO_NOPULL        0x00000000U   /*!< No Pull-up or Pull-down activation  */
    #define  GPIO_PULLUP        0x00000001U   /*!< Pull-up activation                  */
    #define  GPIO_PULLDOWN      0x00000002U   /*!< Pull-down activation                */

    #define HW_GPIO_MODE_AIN GPIO_MODE_AIN              /*!< analog input mode */
    #define HW_GPIO_MODE_FLOATING GPIO_MODE_IN_FLOATING /*!< floating input mode */
    #define HW_GPIO_MODE_IPD GPIO_MODE_IPD              /*!< pull-down input mode */
    #define HW_GPIO_MODE_IPU GPIO_MODE_IPU              /*!< pull-up input mode */
    #define HW_GPIO_MODE_OUT_OD GPIO_MODE_OUT_OD        /*!< GPIO output with open-drain */
    #define HW_GPIO_MODE_OUT_PP GPIO_MODE_OUT_PP        /*!< GPIO output with push-pull */
    #define HW_GPIO_MODE_AF_OD GPIO_MODE_AF_OD          /*!< AFIO output with open-drain */
    #define HW_GPIO_MODE_AF_PP GPIO_MODE_AF_PP

    #define HW_GPIO_SPEED_LOW GPIO_OSPEED_2MHZ      /*!< output max speed 2MHz */
    #define HW_GPIO_SPEED_MEDIUM GPIO_OSPEED_10MHZ  /*!< output max speed 10MHz */
    #define HW_GPIO_SPEED_HIGH GPIO_OSPEED_50MHZ    /*!< output max speed 50MHz */
    #define HW_GPIO_SPEED_VERY_HIGH GPIO_OSPEED_MAX /*!< GPIO very high output speed, max speed more than 50MHz */
    
    #define HW_GPIO_Init(Port, init) HW_GD_GPIO_Init(Port, init)
    #define HW_GPIO_ReadPin(Port, Pin) gpio_input_bit_get(Port, Pin)
    #define HW_GPIO_SetPin(Port, Pin) gpio_bit_set(Port, Pin)
    #define HW_GPIO_ResetPin(Port, Pin) gpio_bit_reset(Port, Pin)
    #define HW_GPIO_TogglePin(Port, Pin) HW_GD_GPIO_TogglePin(Port, Pin)
    
    //SPI
    #define HW_RF_SPI_Init  HW_GD_SPI0_Init
    #define HW_RF_SPI_TransmitReceive(txbuf, rxbuf, len)  HW_GD_SPI0_TransmitReceive(txbuf, rxbuf, len)

    
    //TIMER
    #define HW_TIMER_Count_get( TIMERX )  timer_counter_read( TIMERX ) 
    
    //USB custom_hid_report_send
    #define HW_CUSTOM_HID_REPORT_SEND  HW_GD_CUSTOM_HID_REPORT_SEND
    
    #define HW_DelayMs HW_GD_Delay
	
	#define HW_DEBUG_0_L  	HW_GPIO_ResetPin(GPIOA, GPIO_PIN_10)
	#define HW_DEBUG_0_H  	HW_GPIO_SetPin(GPIOA, GPIO_PIN_10)
	#define HW_DEBUG_1_L  	HW_GPIO_ResetPin(GPIOA, GPIO_PIN_9)
	#define HW_DEBUG_1_H  	HW_GPIO_SetPin(GPIOA, GPIO_PIN_9)
    
#endif



#endif
