/*
platform平台主页，
*/
#include "platform.h"
#include "platform_interface.h"
#include "HW_MCUIO.h"//#include "stm32f4xx_hal.h"
#include "function.h"
#include "function_interface.h"
//#include "usbd_def.h"
#include "function.h"
#include "usbd_hw.h"
#include "custom_hid_core.h"



#if (USB3300==1) // #ifdef STM32F405xx
extern unsigned char USBD_CUSTOM_HID_SendReport_HS(unsigned char *report, unsigned short len);
extern USBD_HandleTypeDef hUsbDeviceHS;
#else
//extern unsigned char  USBD_CUSTOM_HID_SendReport_FS(unsigned char *report, unsigned short len);
//extern USBD_HandleTypeDef hUsbDeviceFS; //F401 add;
extern usb_dev usbd_custom_hid;
#endif 

//extern UART_HandleTypeDef huart1;


unsigned char rx_uart_buf;
volatile unsigned short _20ms_timer_count;
volatile unsigned char _0s5_flag;

volatile unsigned char mainloop_20ms_flag;

volatile unsigned char mainloop_2ms5_flag;


void timer2_count_down(unsigned int down_timer)
{
	timer_counter_value_config(TIMER2, TIMER_CAR(TIMER2) -down_timer);
}


/*
*
*/
void user_20ms_timer(void)
{
	#if 0
	//a,timer sdk connect at update keypad firmware function
	function.update__monitor_sdk_connect();
	
	//b, scan nfc in NO T2 voice base;
	mainloop_20ms_flag=1;
	
	//c, w550 -tcpip //w5500	
	#if (TCPIP==1) //#if defined(TCPIP)&&(TCPIP==1)
	void timer2_isr(void);	
	timer2_isr(); 
	#endif 

	if( ++_20ms_timer_count %5) return ;

	//500ms
	if( !(_20ms_timer_count%25)){
		_20ms_timer_count=0;
		_0s5_flag=1;
	}
	#endif
	
	#if (UPDATE_KP_2)
	extern void update_2_timer(void);
	update_2_timer();
	#endif	
}



void user_2ms5_timer(void)
{
	//a, tcpip -w5500 scan flag
	mainloop_2ms5_flag=1;

	//b,broadcast beacon send//void base_broadcast_process_2ms5(void);
	base_broadcast_process_2ms5();
	
	//c, whitelist auth 
	whitelist__2ms5_call();
    
}





/*
2019.12.04 实测1ms;
环境：主频168MHz,关闭中断,IO取反用示波器测试!!	*/
void basic_delay_ms( unsigned short  time )
{
    unsigned short  i = 0;
    while( time-- ){
			i = 33400;
			while( i-- );
    }
}

/*
2019.12.04 实测 delay(500) =500us;
环境：主频168MHz,关闭中断,IO取反用示波器测试!!	
由于GPIO无法响应 delayus(1)，所以实际测试delay(500) =500us	*/
void basic_delay_us( unsigned int time )
{
    unsigned int i = 0;
    while( time-- ){
			i = 30; 
			while( i-- ) ;
    }
}



//-----------------------------------------------------------------------
//CRC这些算法，是老PVS系统的算法
unsigned short const crc_table2[16] = //CRC余式表
{
    0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7,
    0x8108, 0x9129, 0xa14a, 0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef,
};

unsigned short CRC16(const unsigned char *ptr,unsigned char len)
{
    unsigned short Crc;
    unsigned char da;

    Crc = 0;
    while( len-- != 0 )
    {
        da = Crc >> 12; 	/* 暂存CRC的高四位 */
        Crc <<= 4; 				/* CRC左移4位，相当于取CRC的低12位）*/
        Crc ^= crc_table2[da ^ ( *ptr / 16 )]; 	/* CRC的高4位和本字节的前半字节相加后查表计算CRC，
                              然后加上上一次CRC的余数 */
        da = Crc >> 12; 	/* 暂存CRC的高4位 */
        Crc <<= 4; 				/* CRC左移4位， 相当于CRC的低12位） */
        Crc ^= crc_table2[da ^ ( *ptr & 0x0f )]; 	/* CRC的高4位和本字节的后半字节相加后查表计算CRC，然后再加上上一次CRC的余数 */
        ptr++;
    }
    return( Crc );	
}

/*

*/
void uart1_send_datas(unsigned char *pt,unsigned short len)
{
//	unsigned short i;
//	for(i=0;i<len;i++){
//		USART_SendData(USART1, *pt++);
//		while(USART_GetFlagStatus(USART1, USART_FLAG_TXE) == RESET) ;		
//	}//for
    
    
//	HAL_UART_Transmit(&huart1,pt,len,5);
}




//-------------------------------------------------------------------------------------------------
/*
获取usb连接用于LED显示连接状态！	*/
unsigned char get_usb_status(void)
{
	/*增加了USBD_STATE_SUSPENDED的判断，解决window10系统下被suspend，导致pc连接灯不闪烁；
	*/
		#if (USB3300==1)// #ifdef STM32F405xx
		if( (hUsbDeviceHS.dev_state ==USBD_STATE_CONFIGURED)||(hUsbDeviceHS.dev_state ==USBD_STATE_SUSPENDED ) ) //modify by Gavin  
		#else
//		if( (hUsbDeviceFS.dev_state ==USBD_STATE_CONFIGURED)||(hUsbDeviceFS.dev_state ==USBD_STATE_SUSPENDED ) )// STM32 USB	
//       if(usbd_connect_status_get(&usbd_custom_hid) == (uint8_t)USBD_CONNECTED || usbd_connect_status_get(&usbd_custom_hid) == (uint8_t)USBD_CONFIGURED)//GD32 USB
	if(1)
	#endif
            return 1;
		else 
			return 0;
}


/*
双天线切换*/
void ant_sw(unsigned char seq)
{
#ifdef BASE_HARDWARE_100S
		if(seq){			
			HW_GPIO_ResetPin(GPIOA,GPIO_PIN_0);
			HW_GPIO_SetPin(GPIOC,GPIO_PIN_1);								
		}
		else{//主天线 ??
			HW_GPIO_ResetPin(GPIOC,GPIO_PIN_1);
			HW_GPIO_SetPin(GPIOA,GPIO_PIN_0);					
		}	
#endif 	
}

/*
This function use to debug only 
*/
void operation_debug_io(unsigned char nbr)
{
	switch(nbr){
//		case 2:
////			HAL_GPIO_TogglePin(GPIOE,GPIO_PIN_2);
//			break;
//		
		case 3: //buzzer test only
			HW_GPIO_ResetPin(GPIOC,GPIO_PIN_13);
			break;

		case 4://LED4
			HW_GPIO_ResetPin(GPIOE,GPIO_PIN_4);
			break;
		
		case 5://LED3
			HW_GPIO_ResetPin(GPIOE,GPIO_PIN_5);
			break;
		
		case 6: //led connect  LED1
			HW_GPIO_ResetPin(GPIOC,GPIO_PIN_1);
			break;		
		
		default:break;
	}
}




static unsigned char pc_tcpip_usb_com_type_flag=0;//上电后只允许修改一次;
/*
*检测当前的tcpip还是usb通信方式
*/
void set_pc_communication_type(unsigned char type)
{
	if( pc_tcpip_usb_com_type_flag) return; //修改过一次了，不允许再修改；
//	pc_tcpip_usb_com_type_flag =1;
	
	if( type ==0){
		pc_tcpip_usb_com_type_flag =1;
		#if (USB3300==1)// #ifdef STM32F405xx
		platform.base_send_data_to_pc = USBD_CUSTOM_HID_SendReport_HS;
		#else
		platform.base_send_data_to_pc = HW_CUSTOM_HID_REPORT_SEND;//USBD_CUSTOM_HID_SendReport_FS; //F401
		#endif
	}
	#if (TCPIP==1) //#if defined(TCPIP)&&(TCPIP==1)
	else{
		pc_tcpip_usb_com_type_flag =2;
		platform.base_send_data_to_pc = tcp_send_data_to_pc;
	}
	#endif
}


/*
* 
*/
unsigned char get_pc_communication_type(void)
{
		return pc_tcpip_usb_com_type_flag;
}

////中断总开关 
//void CLI(void)
//{   
//	__disable_irq();
//}
//void SEI(void)
//{  
//	__enable_irq();
//}


/*
https://blog.csdn.net/foxclever/article/details/80294516
96bit =12bytes
不同系列是mcu id的地址不同;
*/
void get_stm32_chip_id(unsigned char *id)
{
    unsigned int tmp[3];
		unsigned char i,j;
			
    for (i=0;i<3;i++){
			j =i<<2;
			#ifdef STM32F405xx
			tmp[i] =*( uint32_t* )( 0x1FFF7A10 +j);
			#else
			tmp[i] =*( uint32_t* )( 0x1FFFF7E8 +j);	
			#endif		
		}//for	
		memcpy(id,tmp,12);			
}



/*
2020.05 200系列基站主板，用IO检测来实现固件识别新旧硬件!!!
1- 200s旧硬件
0- 200s新硬件
T2基站 属于旧硬件
*/
static unsigned char hard_200s_ver3;
void set_hard_flag(unsigned char h_flag)
{
	hard_200s_ver3 =h_flag;
}

unsigned char get_hard_flag(void)
{
	#ifdef BASE_HARDWARE_T2
	return 1;
	#else
	return hard_200s_ver3;
	#endif
	
}


//定义平台相关的结构体
struct hardware_platform_STR platform ={
	/*-------------------------------------------------------
		!!!!!!!!!!!! 警戒线  此后的数据禁止任何修改 !!!!!!!!
	--------------------------------------------------------*/
//	.disable_interrupt=CLI,
//	.enable_interrupt=SEI,	
	.system_reset = NVIC_SystemReset,//复位,
	.get_chip_id =get_stm32_chip_id,
	
	
	#if (USB3300==1)// #ifdef STM32F405xx
	.base_send_data_to_pc = USBD_CUSTOM_HID_SendReport_HS,
	#else
	.base_send_data_to_pc = HW_CUSTOM_HID_REPORT_SEND,//USBD_CUSTOM_HID_SendReport_FS, //F401
	#endif	
	
	.usb_connect_status =get_usb_status,
	
	//rf
	.rf_send_data= rf_SendPacket,
	.rf_set_freq = rf_setfreq,
	.rf_set_send_pwr =rf_set_PA_Mode,
	.rf_init = rf_initial,
	.rf_update_sync_code =rf_set_syncode,	
	#ifdef A5130//5.8G
	.rf_5G8_send_multi_frame =A5130_send_beacon,
	.rf_5G8_load_send_data =A5130_send_data_sub,
	#endif
	
	//e2prom
	.e2prom_write=EE_WriteBytes,
	.e2prom_read=EE_ReadBytes,	
	
	.delay_ms =HW_DelayMs,
    .delay_us =basic_delay_us,
	
	.pc_led_ctrl =led1_control,
	.rf_led_ctrl =led2_control,	
		
	.doule_ANT_sw=ant_sw,	
	.buzzer_ctrl =beep_ctrl,
	
	#if (NFC==1) //#if defined(NFC)&&(NFC==1)
	.rfid_get_hard_connect_status =get_rfid_reader_Hard_connect_status,
	.rfid_write_read_N_block =nfc_write_read_N_block,
	.rfid_reader =nfc_reader,
	#endif
	
	#ifdef LCD_ON
	.lcd_display_chinese=display_chinese,
	.lcd_display_char =display_char,
	#endif
	
//	.get_timer_cnt =TIM5->CNT,
//	.enable_crc_clk =__HAL_RCC_CRC_CLK_ENABLE,//__CRC_CLK_ENABLE,
		
	
	
	.uart1_print_bytes =uart1_send_datas,
	/*-------------------------------------------------------
		!!!!!!!!!!!! 警戒线  此前的数据禁止任何修改 !!!!!!!!
		如需添加请在此之后!!!!!!!!!!!!!!!!!
	--------------------------------------------------------*/
    .rf_set_txok_flag = set_tx_ok_flag,
    .rf_get_txok_flag = get_tx_ok_flag,
    .rf_waitfor_txok = waitfor_tx_ok,
    ._2ms5_count_down = timer2_count_down,
};



