
#include "HW_MCUIO.h"//#include "stm32f4xx_hal.h"
#include "platform.h"
#include "function.h"

#ifdef 	BASE_HARDWARE_T2
	#define LED1_PORT  	GPIOE
	#define LED2_PORT  	GPIOE
	#define LED1        GPIO_PIN_10
	#define LED2        GPIO_PIN_8
#elif defined(BASE_HARDWARE_200S)
	#define LED1_PORT  	GPIOE
	#define LED2_PORT  	GPIOE
	#define LED1        GPIO_PIN_3
	#define LED2        GPIO_PIN_2	
#elif defined(BASE_HARDWARE_100S)
	#define LED1_PORT  	GPIOA
	#define LED2_PORT  	GPIOA
	#define LED1        GPIO_PIN_2//1
	#define LED2        GPIO_PIN_1//2		
	
#endif

/*
LEDs are low level drivers,
INPUT: 
	1- on
	2- flashing
	0- off 
*/
void led1_control(unsigned char type)
{
		if(type==1)
			HW_GPIO_ResetPin(LED1_PORT,LED1);
		else if(type==2)
			HW_GPIO_TogglePin(LED1_PORT,LED1);
		else
			HW_GPIO_SetPin(LED1_PORT,LED1);	
}


void led2_control(unsigned char type)
{
		if(type==1)
			HW_GPIO_ResetPin(LED2_PORT,LED2);
		else if(type==2)
			HW_GPIO_TogglePin(LED2_PORT,LED2);
		else
			HW_GPIO_SetPin(LED2_PORT,LED2);				
}







//------------------------------ led ----------------------------------------
/*实测：此处定义的LED1-4与T2面板的对应：
* LED1-右1;			LED2-右2；
* LED3-右3 bule ;LED4-右3Red；
*/

/*
#define 	LED1_PIN	GPIO_PIN_11
#define 	LED1_PORT	GPIOE
#define 	LED2_PIN	GPIO_PIN_10
#define 	LED2_PORT	GPIOE

#define 	LED3_PIN	GPIO_PIN_8
#define 	LED3_PORT	GPIOE
#define 	LED4_PIN	GPIO_PIN_9
#define 	LED4_PORT	GPIOE

void display_led_ctrl(unsigned char led_NO,unsigned char status)
{
		GPIO_TypeDef *led_port;
		uint16_t led_pin;
		switch(led_NO){
			
			case LED_NO1:
				led_port = LED1_PORT;
				led_pin = LED1_PIN;
				break;
			
			case LED_NO2:
				led_port = LED2_PORT;
				led_pin = LED2_PIN;							
				break;
			
			case LED_NO3:
				led_port = LED3_PORT;
				led_pin = LED3_PIN;							
				break;	
			
			case LED_NO4:
				led_port = LED4_PORT;
				led_pin = LED4_PIN;							
				break;			
						
			default: return;//break;	//led编号不合法，
		}//sw
	
		switch(status){
			case LED_STA_OFF: //off
				HAL_GPIO_WritePin(led_port, led_pin, GPIO_PIN_SET);
			break;
			
			case LED_STA_ON://on
				HAL_GPIO_WritePin(led_port, led_pin, GPIO_PIN_RESET);
				break;
			
			case LED_STA_TOG://trig
				HAL_GPIO_TogglePin(led_port, led_pin);
				break;
			
			default:break;
		}
}

*/



/* --------------------------- LCD back light ------------------------------------------
lcd背光控制
*/
void lcd_back_light_ctrl( unsigned char on_off)
{
	if(on_off)
		HW_GPIO_SetPin(GPIOB, GPIO_PIN_6);
	else
		HW_GPIO_ResetPin(GPIOB, GPIO_PIN_6);
}














