
#include "HW_MCUIO.h"//#include "stm32f4xx_hal.h"
#include "dot.h"
#include "platform.h"
#include "function.h"
#include "base_core_user.h"


#ifdef LCD_ON

/*
F4系列速度太快，需要加延时，读写才正常!!!*/
static void lcd_delay(unsigned short dy)
{
	unsigned short i;	
	for(i=0;i<dy;i++);
}

#define 	LCD_IO_DELAY  1

#define		RST_1			{HAL_GPIO_WritePin(GPIOB, GPIO_PIN_7, GPIO_PIN_SET);lcd_delay(LCD_IO_DELAY);}
#define		RST_0			{HAL_GPIO_WritePin(GPIOB, GPIO_PIN_7, GPIO_PIN_RESET);lcd_delay(LCD_IO_DELAY);}



static void lcd_write_data_sub(unsigned char addr, unsigned char data)
{
		i2c_start();
		i2c_send_byte(addr);	
		i2c_send_byte(data);
		i2c_stop();
}


/*
0x78 -write command
0x7A -write data
*/
static void lcd_write_cmd( unsigned char cmd)
{
		lcd_write_data_sub(0x78,cmd);
}

static void lcd_write_data( unsigned char data)
{
		lcd_write_data_sub(0x7A,data);
}


/*
	设置光标位置
	*/
static void lcd_set_cursor_position(	unsigned short x,unsigned short y)
{
	unsigned short xh,xl;
	xh=y/16;
	xl=y%16;
	lcd_write_cmd(0x04);//SET COLUMN ADDRESS
	lcd_write_data(x+80);
	lcd_write_cmd(0x70+xh);//SET PAGE ADDRESS
	lcd_write_cmd(0x60+xl);
	lcd_write_cmd(0x01); //WRITE DATA TO DISPLAY MEMORY	
}



/*
查表得到字符的数据*/
static unsigned char * get_string_table( const unsigned char *pt)
{
		unsigned char *rt=0;
	
		if( (*pt>=0x61)&&(*pt<=0x7A) ) //小写
		  rt = &chardot[(*pt-0x61)*16];
		else if( (*pt>=0x41)&&(*pt<=0x5A) )	//大写
			rt = &chardot[((CHAR_41)+*pt-0x41)*16];
		else if( (*pt>=0x30)&&(*pt<=0x39) )	//数字
			rt = &chardot[((CHAR_30)+*pt-0x30)*16];			
		else if (*pt==0x20)//空格
			rt = &chardot[(CHAR_20)*16];
		else if (*pt==0x2D)//-中杠
			rt = &chardot[(CHAR_2D)*16];
		else if (*pt==0x5F)//_下杠
			rt = &chardot[(CHAR_5F)*16];
		else if (*pt==0x2E)//.
			rt = &chardot[(CHAR_2E)*16];
		else if (*pt==0x3A)//:
			rt = &chardot[(CHAR_3A)*16];		
		
		else //出错时，显示空格(空白)
			rt = &chardot[(CHAR_20)*16];
		return rt;
}





#define 	CHAR_16x8						1
#define 	CHAR_16x8_MIDLINE		2
#define 	CHIN_12x12				3

#define 	CHIN_16x16				4

/*
*
*/
static unsigned char display_char_chinese(unsigned short x,unsigned short y, 
																	unsigned char char_type,																	 
																	const unsigned char *chr,
																	unsigned char len,
																	unsigned char reverse)
{
		unsigned char i,j,*pt;
	
		switch(char_type){
			case CHAR_16x8:
				for(j=0;;j++){
					if( chr[j] ==0x00 )break;		
					pt =get_string_table(chr+j);
					//写一个字符
					lcd_set_cursor_position(x+j*8,y);
					for(i=0;i<8;i++)	lcd_write_data( (reverse==0)?pt[i]:~pt[i] );
					lcd_set_cursor_position(x+j*8,y+1);
					for(i=0;i<8;i++)	lcd_write_data( (reverse==0)?pt[i+8]:~pt[i+8] );			
				}//for				
				break;
				
			case CHAR_16x8_MIDLINE://特殊处理:下划线代替中划线
				for(j=0;;j++){
					if( chr[j] ==0x00 )break;		
					pt =get_string_table(chr+j);
					//写一个字符
					lcd_set_cursor_position(x+j*8,y);
					for(i=0;i<8;i++)	lcd_write_data( (reverse==0)?pt[i]:~pt[i] );
					lcd_set_cursor_position(x+j*8,y);//lcd_set_cursor_position(x+j*8,y+1);
					for(i=0;i<8;i++)	lcd_write_data( (reverse==0)?pt[i+8]:~pt[i+8] );			
				}//for				
				break;				
				
			#if 0
			case CHIN_12x12:
				for(j=0;j<len;j++){
					pt =&hzdot[chr[j]*24];
					
					lcd_set_cursor_position(x+j*12,y);
					for(i=0;i<12;i++)	lcd_write_data( (reverse==0)?pt[i]:~pt[i] );
					lcd_set_cursor_position(x+j*12,y+1);
					for(i=12;i<24;i++)	lcd_write_data( (reverse==0)?pt[i]:~pt[i] );					
					
				}//for						
				break;
			#endif
			
			case CHIN_16x16:
				for(j=0;j<len;j++){
					pt =&hzdot[chr[j]*32];
					
					lcd_set_cursor_position(x+j*16,y);
					for(i=0;i<16;i++)	lcd_write_data( (reverse==0)?pt[i]:~pt[i] );
					lcd_set_cursor_position(x+j*16,y+1);
					for(i=16;i<32;i++)	lcd_write_data( (reverse==0)?pt[i]:~pt[i] );		
//					lcd_set_cursor_position(x+j*24,y+2);
//					for(i=48;i<72;i++)	lcd_write_data( (reverse==0)?pt[i]:~pt[i] );											
				}//for					
				break;
				
				
				
				
			default:break;
		}//sw

		return 1;
}




/*
清除全屏*/
void lcd_all_clear(void)
{
	unsigned short i,j;
	for (i=0;i<12;i++){ 
		lcd_set_cursor_position(0,i);
		for (j=0;j<160;j++) 
			lcd_write_data(0x00);
	}//for	
}

/*
显示全屏*/
void lcd_all_display(void)
{
	unsigned short i,j;
	for (i=0;i<12;i++){ 
		lcd_set_cursor_position(0,i);
		for (j=0;j<160;j++) 
		lcd_write_data(0xff);
	}	
}


/*
lcd 初始化*/
void lcd_init(void)
{	
	RST_0
	basic_delay_ms(10);//delay_Nms(100);//
	RST_1	
	basic_delay_ms(250);//	delay_Nms(250);////复位时间一定要足够
	
	lcd_write_cmd(0xe1);
	lcd_write_data(0xe2);	
	basic_delay_ms(10);//	delay_Nms(10);
	lcd_write_cmd(0xc9);	//display on
	lcd_write_data(0xac);		
	
	lcd_write_cmd(0x24);	
	lcd_write_cmd(0xc4);	
	lcd_write_cmd(0xa1);	
	
	lcd_write_cmd(0x2d);	
	lcd_write_cmd(0xea);	
	lcd_write_cmd(0x81);	
	lcd_write_data(0x70);	
	
	lcd_write_cmd(0x89);    //SET RAM ADDRESS CONTROL 
	lcd_write_cmd(0x86);	  // 0X86??DD or 0X87?eDD

	lcd_write_cmd(0x85);    //SET PARTIAL DISPLAY CONTROL
	lcd_write_cmd(0xf1);    //SET COM END
	lcd_write_data(159);
	lcd_write_cmd(0xf2);    //SET PARTIAL DISPLAY START
	lcd_write_data(64);
	lcd_write_cmd(0xf3);    //SET PARTIAL DISPLAY END
	lcd_write_data(159);

	lcd_write_cmd(0xf9);    //SET WINDOW PROGRAM ENABLE
	lcd_write_cmd(0xf4);    //SET WINDOW PROGRAM STARTING COLUMN ADDRESS
	lcd_write_data(80);
	lcd_write_cmd(0xf5);    //SET WINDOW PROGRAM STARTING PAGE ADDRESS
	lcd_write_data(16);
	lcd_write_cmd(0xf6);    //SET WINDOW PROGRAM ENDING COLUMN ADDRESS
	lcd_write_data(239);
	lcd_write_cmd(0xf7);    //SET WINDOW PROGRAM ENDING PAGE ADDRESS
	lcd_write_data(39);

	lcd_write_cmd(0x95);    // set DC5=0 DC4=1     1 bits per pixel 
	lcd_write_cmd(0xc9);	  //dispaly on
	lcd_write_data(0xad);	
		
	lcd_all_clear();	
}

//#define 	CHAR_16x8						1
//#define 	CHAR_16x8_MIDLINE		2
//#define 	CHIN_12x12					3
/*
*显示12x12的中文
*/
#if 0
void display_chinese(unsigned short x,unsigned short y 
																		//,unsigned char char_type																	 
																		,const unsigned char *chr
																		,unsigned char len
																		//,unsigned char reverse
																		)
{
	display_char_chinese(x,y,CHIN_12x12,chr,len,0);
}																			
#endif

/*
*显示24x24的汉字!!!
*/
void display_chinese(unsigned short x,unsigned short y 
																		//,unsigned char char_type																	 
																		,const unsigned char *chr
																		,unsigned char len
																		//,unsigned char reverse
																		)
{
	display_char_chinese(x,y,CHIN_16x16,chr,len,0);
}	

/*
* 显示字符;特殊处理下划线;
*/
void display_char(unsigned short x,unsigned short y 
																	//,unsigned char char_type																	 
																	,const unsigned char *chr
																	//,unsigned char len
																	//,unsigned char reverse
																	)	
{
	
	if( (chr[0] ==0x5F)&&(chr[1] ==0x5F)&&(chr[2] ==0x5F) ) //特殊处理 下划线实现中线的效果
		display_char_chinese(x,y,CHAR_16x8_MIDLINE,chr,0,0);
	else
		display_char_chinese(x,y,CHAR_16x8,chr,0,0);	
}																	
																	

#endif 

