
#include "HW_MCUIO.h"//#include "stm32f4xx_hal.h"
#include "platform.h"
#include "base_core_user.h"
#include "function.h"

/*----------------------------- 蜂鸣器 ---------------------------------------
*/
#ifdef BASE_HARDWARE_T2 
	#define 	BUZZER_PIN			GPIO_PIN_13
	#define 	BUZZER_PORT			GPIOE
#elif defined(BASE_HARDWARE_200S)
	#define 	BUZZER_PIN			GPIO_PIN_13
	#define 	BUZZER_PORT			GPIOC
#endif



//
static void Beep(unsigned int sound,unsigned short len)
{
	#if defined(BASE_HARDWARE_200S) || defined(BASE_HARDWARE_T2) 
		unsigned int i;
		unsigned int k;

		for (i=0;i<len;i++){
			 HW_GPIO_TogglePin(BUZZER_PORT, BUZZER_PIN);
			 for (k=0;k<sound;k++);
		} //for
		
		HW_GPIO_ResetPin(BUZZER_PORT, BUZZER_PIN);
	#endif
		
}


#ifdef 	_BZ_DEBUG_		//20200927重新弄调整buzzer的声调;
#include "base_pc_protocol.h"
extern struct bs_cfg_STR  base_config;
#endif 
/*

*/
void beep_ctrl(unsigned char mode)
{
//		Beep(8000,400);	//basic
	
#ifdef 	_BZ_DEBUG_	
//	Beep((base_config.keymax[0]<<8)+base_config.keymax[1],(base_config.keymin[0]<<8)+base_config.keymin[1]);
#else
	Beep(7200,400);	
#endif 
	
}











