#include "HW_MCUIO.h"
#include "custom_hid_core.h"
#include "usbd_hw.h"

#if ( MCU_GD32F30X == 1 )

void HW_GD_GPIO_Init(HW_GPIO_PortDef Port, HW_GPIO_InitTypeDef *GPIO_init)
{
    gpio_init(Port, GPIO_init->Mode, GPIO_init->Speed, GPIO_init->Pin);
}

void HW_GD_GPIO_TogglePin(HW_GPIO_PortDef Port, uint32_t Pin)
{
    if (gpio_input_bit_get(Port, Pin) == SET)
    {
        gpio_bit_reset(Port, Pin);
    }
    else
    {
        gpio_bit_set(Port, Pin);
    }
}

static volatile uint32_t systick;
uint32_t HW_GD_GetTick(void)
{
    return systick;
}

void HW_GD_IncTick(void)
{
    systick++;
}

void HW_GD_Delay(uint32_t DelayMs)
{
    uint32_t tick = HW_GD_GetTick();

    do
    {
        if (HW_GD_GetTick() - tick >= DelayMs)
        {
            return;
        }
    } while (1);
}

void HW_GD_DelayUS(uint32_t DelayUs)
{
    uint32_t cnt = DelayUs * 22; // 98.340M,1000us,??996us
    while (cnt--)
    {
        /* code */
    }
}

void HW_GD_SPI0_Init(void)
{
    rcu_periph_clock_enable(RCU_GPIOA);
    rcu_periph_clock_enable(RCU_GPIOC);
    rcu_periph_clock_enable(RCU_AF);
    rcu_periph_clock_enable(RCU_SPI0);
    
//    HW_GPIO_SetPin(RF_CS_GPIO_Port, RF_CS_Pin);
//    HW_GPIO_Init(RF_CS_GPIO_Port, RF_CS_Pin, GPIO_MODE_OUT_PP, HW_GPIO_SPEED_HIGH);
    
//    gpio_init(GPIOC, GPIO_MODE_OUT_PP, GPIO_OSPEED_50MHZ, GPIO_PIN_6);//CS
//    gpio_init(GPIOA, GPIO_MODE_AF_PP, GPIO_OSPEED_50MHZ, GPIO_PIN_5 | GPIO_PIN_7);
//    gpio_init(GPIOA, GPIO_MODE_IN_FLOATING, GPIO_OSPEED_50MHZ, GPIO_PIN_6);
//    gpio_init(GPIOC, GPIO_MODE_IN_FLOATING, GPIO_OSPEED_50MHZ, GPIO_PIN_7);
     gpio_init(GPIOC, GPIO_MODE_OUT_PP, GPIO_OSPEED_MAX, GPIO_PIN_6);//CS
    gpio_init(GPIOA, GPIO_MODE_AF_PP, GPIO_OSPEED_MAX, GPIO_PIN_5 | GPIO_PIN_7);
    gpio_init(GPIOA, GPIO_MODE_IN_FLOATING, GPIO_OSPEED_MAX, GPIO_PIN_6);
    gpio_init(GPIOC, GPIO_MODE_IN_FLOATING, GPIO_OSPEED_MAX, GPIO_PIN_7);
    spi_parameter_struct spi_init_struct;

    /* SPI0 parameter config */
    spi_init_struct.trans_mode           = SPI_TRANSMODE_FULLDUPLEX;
    spi_init_struct.device_mode          = SPI_MASTER;
    spi_init_struct.frame_size           = SPI_FRAMESIZE_8BIT;
    spi_init_struct.clock_polarity_phase = SPI_CK_PL_LOW_PH_1EDGE;
    spi_init_struct.nss                  = SPI_NSS_SOFT;
    spi_init_struct.prescale             = SPI_PSC_8;//SPI_PSC_8;
    spi_init_struct.endian               = SPI_ENDIAN_MSB;
    spi_init(SPI0, &spi_init_struct);
    spi_enable(SPI0);
    
    
    nvic_irq_enable(EXTI5_9_IRQn, 3U, 0U);//(EXTI5_9_IRQn, 3U, 0U);
    gpio_exti_source_select(GPIO_PORT_SOURCE_GPIOC, GPIO_PIN_SOURCE_7);
    exti_init(EXTI_7, EXTI_INTERRUPT, EXTI_TRIG_FALLING);
    exti_interrupt_flag_clear(EXTI_7);
    
}

uint8_t HW_GD_SPI_TransmitReceiveOneByte(uint32_t SPIX, uint8_t tx_data, uint8_t *rx_data)
{
//    uint32_t time_out = RF_SPI_TIMEOUT;
//    uint8_t rtn=0;
//    while (!spi_i2s_flag_get(SPIX, SPI_FLAG_TBE) && time_out--)
//        ;
//    spi_i2s_data_transmit(SPIX, tx_data);
//    if(time_out==0) rtn=1;
//    time_out = RF_SPI_TIMEOUT;
//    while (!spi_i2s_flag_get(SPIX, SPI_FLAG_RBNE) && time_out--)
//        ;
//    *rx_data=spi_i2s_data_receive(SPIX);
//    if(time_out==0) rtn=1; 
//    
//    return rtn;
    
    while (!spi_i2s_flag_get(SPI0, SPI_FLAG_TBE))
        ;
    spi_i2s_data_transmit(SPI0, tx_data);
    while (!spi_i2s_flag_get(SPI0, SPI_FLAG_RBNE))
        ;
    *rx_data=spi_i2s_data_receive(SPI0);
    return *rx_data;
}

uint8_t HW_GD_SPI0_TransmitReceive(uint8_t *txbuf, uint8_t *rxbuf, uint16_t len)
{
    uint8_t rtn=0;
    for(uint16_t i=0;i<len;i++)
    {
        rtn|=HW_GD_SPI_TransmitReceiveOneByte(SPI0, *txbuf++, rxbuf++);
    }
    
    return 0;
}


extern usb_core_driver custom_hid;
uint8_t HW_GD_CUSTOM_HID_REPORT_SEND(uint8_t *buf, uint16_t len)
{
    return custom_hid_report_send (&custom_hid, buf, len);
}



#endif