
/*

*/
#include "HW_MCUIO.h"
#include "A5130.h"
#include "function.h"
#include "base_core_user.h"
#include "platform.h"


#ifdef 	A5130


//#define 	RF_PORT 				GPIOD
//#define 	RF_CS						GPIO_PIN_3

//#define 	RF_PATX_PORT 		GPIOD
//#define 	RF_PATX					GPIO_PIN_1
//#define 	RF_PARX_PORT 		GPIOD
//#define 	RF_PARX					GPIO_PIN_2




const unsigned char ID_Tab[8]={0x34,0x75,0xC5,0x8C,0xC7,0x33,0x45,0xE7};	//ID code

#ifdef BASE_HARDWARE_T2
//cs of SPI
GPIO_TypeDef* const rf_cs_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
uint16_t const rf_cs_pin[4] ={GPIO_PIN_13,GPIO_PIN_8,GPIO_PIN_3,GPIO_PIN_6};

//外部中断
GPIO_TypeDef* const rf_it_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
uint16_t const rf_it_pin[4] ={GPIO_PIN_14,GPIO_PIN_9,GPIO_PIN_4,GPIO_PIN_7};

//用于设置开关中断
const unsigned char rf_it_pin_nbr[]={14,9,4,7};

//TX PA
GPIO_TypeDef* const rf_paTX_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
uint16_t const rf_paTX_pin[4] ={GPIO_PIN_11,GPIO_PIN_6,GPIO_PIN_1,GPIO_PIN_4};

GPIO_TypeDef* const rf_paRX_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
uint16_t const rf_paRX_pin[4] ={GPIO_PIN_12,GPIO_PIN_7,GPIO_PIN_2,GPIO_PIN_5};

#elif defined(BASE_HARDWARE_200S)
//GPIO_TypeDef* const rf_cs_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
//uint16_t const rf_cs_pin[4] ={GPIO_PIN_13,GPIO_PIN_8,GPIO_PIN_3,GPIO_PIN_6};

////isr
//GPIO_TypeDef* const rf_it_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
//uint16_t const rf_it_pin[4] ={GPIO_PIN_14,GPIO_PIN_9,GPIO_PIN_4,GPIO_PIN_7};

////用于设置开关中断
//const unsigned char rf_it_pin_nbr[]={14,9,4,7};


////TX PA 5.8G 	//cc2500 RF_LNA
//GPIO_TypeDef* const rf_paTX_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
//uint16_t const rf_paTX_pin[4] ={GPIO_PIN_1,GPIO_PIN_11,GPIO_PIN_6,GPIO_PIN_4};

////RX PA 5.8G   //cc2500-RF_PA_EN
//GPIO_TypeDef* const rf_paRX_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
//uint16_t const rf_paRX_pin[4] ={GPIO_PIN_2,GPIO_PIN_12,GPIO_PIN_7,GPIO_PIN_5};

//hardware 200s RF modual silk screen:J2-J3-J1-J4
GPIO_TypeDef* const rf_cs_port[4]={GPIOD,GPIOB,GPIOD,GPIOC};
uint16_t const rf_cs_pin[4] ={GPIO_PIN_13,GPIO_PIN_4,GPIO_PIN_3,GPIO_PIN_6};

//isr
GPIO_TypeDef* const rf_it_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
uint16_t const rf_it_pin[4] ={GPIO_PIN_14,GPIO_PIN_5,GPIO_PIN_4,GPIO_PIN_7};

//用于设置开关中断
const unsigned char rf_it_pin_nbr[]={14,5,4,7};


//TX PA 5.8G 	//cc2500 RF_LNA
GPIO_TypeDef* const rf_paTX_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
uint16_t const rf_paTX_pin[4] ={GPIO_PIN_11,GPIO_PIN_6,GPIO_PIN_1,GPIO_PIN_4};

//RX PA 5.8G   //cc2500-RF_PA_EN
GPIO_TypeDef* const rf_paRX_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
uint16_t const rf_paRX_pin[4] ={GPIO_PIN_12,GPIO_PIN_7,GPIO_PIN_2,GPIO_PIN_5};
#endif




#define 	A5130_SET_CS_HIGH(i)		HAL_GPIO_WritePin(rf_cs_port[i],rf_cs_pin[i], GPIO_PIN_SET) //HAL_GPIO_WritePin(RF_PORT,RF_CS, GPIO_PIN_SET)
#define 	A5130_SET_CS_LOW(i)		HAL_GPIO_WritePin(rf_cs_port[i],rf_cs_pin[i], GPIO_PIN_RESET) //HAL_GPIO_WritePin(RF_PORT,RF_CS, GPIO_PIN_RESET)

#define 	PA_TX_ENABLE(i) 				HAL_GPIO_WritePin(rf_paTX_port[i],rf_paTX_pin[i], GPIO_PIN_SET)	//HAL_GPIO_WritePin(RF_PATX_PORT,RF_PATX, GPIO_PIN_SET)
#define 	PA_TX_DISENABLE(i) 		HAL_GPIO_WritePin(rf_paTX_port[i],rf_paTX_pin[i], GPIO_PIN_RESET)

#define 	PA_RX_DISENABLE(i)			HAL_GPIO_WritePin(rf_paRX_port[i],rf_paRX_pin[i], GPIO_PIN_RESET) //HAL_GPIO_WritePin(RF_PARX_PORT,RF_PARX, GPIO_PIN_RESET)
#define 	PA_RX_ENABLE(i)					HAL_GPIO_WritePin(rf_paRX_port[i],rf_paRX_pin[i], GPIO_PIN_SET)

#define 	WAITFOR_TX_COPMLATE(i)		HAL_GPIO_ReadPin(rf_it_port[i],rf_it_pin[i]) //HAL_GPIO_ReadPin(GPIOD,GPIO_PIN_4)


#ifdef BASE_HARDWARE_T2
#define OPEN_MISO(id)		{}
#define CLOSE_MISO(id)	{}
#else
// miso control
GPIO_TypeDef* const miso_ctrl_port[4]={GPIOE,GPIOB,GPIOE,GPIOE};
uint16_t const miso_ctrl_pin[4] ={GPIO_PIN_8,GPIO_PIN_7,GPIO_PIN_9,GPIO_PIN_10};
#define OPEN_MISO(id)		HAL_GPIO_WritePin(miso_ctrl_port[id],miso_ctrl_pin[id], GPIO_PIN_SET)	
#define CLOSE_MISO(id)	HAL_GPIO_WritePin(miso_ctrl_port[id],miso_ctrl_pin[id], GPIO_PIN_RESET)		
#endif 

/*
初始化参数*/
const unsigned char A5130Config[]=
{
	0x00, //RESET register,			
	0x62,	//0x60, //MODE register, //Gavin
	0x00, //CALIBRATION register,	
	0x3F, //FIFO1 register,
	0x00, //FIFO2 register,
	0x00, //FIFO register,		
	0x00, //IDDATA register,	
	0x00, //RCOSC1 register,
	
	0x00, //RCOSC2 register,
	0x0C, //RCOSC3 register,
	0x02, //CKO register,		//Gavin
	0x01, //GPIO1 register  0x0B//Gavin
	0x59, //GPIO2 register,	//Gavin
	0x1F, //DATARATECLOCK register,
	0x41, //PLL1 register,
	0x1E, //PLL2 register, 
	
	0x59, //PLL3 register,
	0x74, //PLL4 register,
	0x01, //PLL5 register,
	0x32, //ChannelGroup1 register,
	0x64, //ChannelGroup1 register,
	0x2D, //TX1 register, 				
	0x40, //TX2 register,
	0x09,//0x19, //DELAY1 register,
	0x40, //DELAY2 register,
	0x70, //RX register,
	0x7B, //RXGAIN1 register,
	0xC0, //RXGAIN2 register,				
	0x7C, //RXGAIN3 register,
	0xCA, //RXGAIN4 register,
	0x00, //RSSI register,
	0xC9, //ADC register,
	0x1C, //CODE1 register,  开启crc  关闭crc 0x0c
	0x8F, //CODE2 register,  开启crc  关闭crc 0x0f			
	0x2A, //CODE3 register,
	0xE4, //IFCAL1 register,
	0x01, //IFCAL2 register,    			
	0x4F, //VCOCCAL register,
	0xC0, //VCOCAL1 register,
	0x80, //VCOCAL2 register,
	0x70, //VCO deviation 1 register,
	0x40, //VCO deviation 2 register,
	0x00, //DSA register,
	0xBF, //VCO Modulation delay register,	
	0x60, //BATTERY register, 2CH?
	
	0x49, //TXTEST register,   0x41  -4.8db  /////0x7b 3.3db  //0x49 -3.5db
	//0x41, //TXTEST register,   0x41  -4.8db  /////0x7b 3.3db
	0x57, //RXDEM1 register,
	0x74, //RXDEM2 register,
	0xF3, //CPC1 register,
	0x33, //CPC2 register,
	0x4D, //CRYSTAL register,
	0x15, //PLLTEST register,
	0x0F, //VCOTEST register,
	0x00, //RF Analog register,
	0x00, //Key data register,
	0x37, //Channel select register,
	0x00, //ROM register,
	0x00, //DataRate register,
	0x00, //FCR register,
	0x00, //ARD register,
	0x00, //AFEP register,
	0x00, //FCB register,
	0x00, //KEYC register,
	0x00  //USID register,
};


const unsigned char A5130_Addr2A_Config[]=    // 2A 额外偏移地址设置
{
	0x1A,//0x2A, //page0, //49US, CL=18pF, CSXTL=42
	0x81, //page1,
	0xF0, //Page2,
	0x80, //page3,
	0x80, //page4,
	0x48, //page5,
	0x00, //page6,
	0xC0, //page7,
	0x3A, //page8,
	0x3E, //page9,
	0xE8, //page10,
	0x80, //page11,
	0x00  //page12,
};

const unsigned char A5130_Addr38_Config[]=   // 38额外偏移地址设置
{
	0x74, //page0,
	0x50, //page1,
	0x0D, //page2,
	0x24, //page3,
	0x06, //page4,
	0x40, //page5,
	0x60, //page6,
	0x04, //page7,
	0x00, //page8,
	0x00, //page9,
	0x00  //page10,

};




#define 	SPI_TIME_OUT		100
extern SPI_HandleTypeDef hspi1;
void spi_writebyte(unsigned char data,unsigned char id)
{
	//OPEN_MISO(id);
	HAL_SPI_Transmit(&hspi1,&data,1,SPI_TIME_OUT);
	//CLOSE_MISO(id);
}

void spi_writebyteN(unsigned char *data,unsigned char count,unsigned char id)
{	
	//OPEN_MISO(id);
	HAL_SPI_Transmit(&hspi1,data,count,SPI_TIME_OUT);
	//CLOSE_MISO(id);
}


unsigned char spi_readbyte(unsigned char id)
{
	unsigned char rxdata;
	HAL_StatusTypeDef rslt;
	
	OPEN_MISO(id);
	rslt =HAL_SPI_Receive(&hspi1,&rxdata,1,SPI_TIME_OUT);
	CLOSE_MISO(id);
	
	if( HAL_OK ==rslt )
		return rxdata;
	else
		return 0;		
}

unsigned char spi_readbyteN(unsigned char *rxdata,unsigned char count,unsigned char id)
{
	unsigned char data=0xff;
	HAL_StatusTypeDef rslt;
	
	OPEN_MISO(id);	
	rslt =HAL_SPI_TransmitReceive(&hspi1,&data,rxdata,count,SPI_TIME_OUT);
	CLOSE_MISO(id);
	
	if( rslt==HAL_OK)
		return 1;
	else
		return 0;	
}





/************************************************************************
**  A5130_WriteReg  向寄存器写入数据
************************************************************************/
void A5130_WriteReg(unsigned char addr, unsigned char sdata,unsigned char id)
{

	
	A5130_SET_CS_LOW(id);
	
	spi_writebyte(addr|0x00,id);
	//Gavin1211//basic_delay_us(2);//delay_us(2);//add by Gavin	
	spi_writebyte(sdata,id);
	//Gavin1211//basic_delay_us(2);//delay_us(2);
	
	A5130_SET_CS_HIGH(id);
}

/*按页写*/
void A5130_WriteReg_Page(unsigned char addr, unsigned char sdata,unsigned char page,unsigned char id)
{
	A5130_WriteReg(RFANALOG_REG, (A5130Config[RFANALOG_REG] &0x0f)| (page<<4),id);
	A5130_WriteReg(addr,sdata,id);
}


/************************************************************************
**  A5130_ReadReg
************************************************************************/
unsigned char A5130_ReadReg(unsigned char addr,unsigned char id)
{
	unsigned rdata;
	A5130_SET_CS_LOW(id);
	
	spi_writebyte(addr|0x40,id);
	rdata =spi_readbyte(id);
	//Gavin1211//basic_delay_us(2);//delay_us(2);
	
	A5130_SET_CS_HIGH(id);
	return rdata;
}

/*按页读*/
unsigned char A5130_ReadReg_Page(unsigned char addr,unsigned char page,unsigned char id)
{
	A5130_WriteReg(RFANALOG_REG, (A5130Config[RFANALOG_REG] &0x0f)| (page<<4),id);
	return A5130_ReadReg(addr,id);
}

void A5130_Trimming(unsigned char id)	//read then write 
{
	unsigned char	CBG,CTR,BDC,STM;
	
	A5130_WriteReg_Page(ROMP_REG, 0xA0, 9,id);	
	basic_delay_ms(10);//delay_ms(10);
	
	A5130_SET_CS_LOW(id);
	
	spi_writebyte(USID_REG|0x40,id);
	basic_delay_us(3);//delay_us(3);

	CBG	=	spi_readbyte(id);	//BPBG
	CTR	=	spi_readbyte(id);	//ADC trimming
	BDC	=	spi_readbyte(id);	//Battery detect
	STM	=	spi_readbyte(id);	//V-temp trimming	

	A5130_SET_CS_HIGH(id);
	basic_delay_ms(5);//delay_ms(5);
	
	A5130_WriteReg_Page(ROMP_REG, 0x40+CBG, 1,id);	//BPBG
	A5130_WriteReg_Page(ROMP_REG, CTR, 2,id);	//ADC trimming
	A5130_WriteReg_Page(ROMP_REG, BDC << 2, 0,id);	//Battery detect
	A5130_WriteReg_Page(ROMP_REG, STM, 4,id);	//V-temp trimming	
}



/*********************************************************************
** Strobe Command
*********************************************************************/
void StrobeCmd(unsigned char cmd,unsigned char id)
{
	if(cmd== CMD_SLEEP)
		A5130_WriteReg(BATTERY_REG, A5130Config[BATTERY_REG] & ~0x20,id);
	else
		A5130_WriteReg(BATTERY_REG, A5130Config[BATTERY_REG],id);
	
	A5130_SET_CS_LOW(id);
	spi_writebyte(cmd,id);
	//Gavin1211//basic_delay_us(2);//delay_us(2);
	A5130_SET_CS_HIGH(id);	
}


static void re_set_MISO(unsigned char id)
{
//	A5130_WriteReg(GIO2_REG, 0x59,id);	//GIO2 add by Gavin 1226	

}


/*-------------------------------------------
写入同步码id code,并验证是否正确
*/
static unsigned char A5130_write_ID_code(const unsigned char *code,unsigned char id)
{
	unsigned char i,tmp[8],rslt=1;

re_set_MISO(id);//test?
	
	A5130_SET_CS_LOW(id);
	
	basic_delay_us(1);//delay_us(1);
	spi_writebyte(IDCODE_REG,id);// write
	for(i=0;i<8;i++){
		spi_writebyte(code[i],id);
		basic_delay_us(10);//delay_us(10);
	}	
	A5130_SET_CS_HIGH(id);	
	basic_delay_us(10);//delay_us(10);
	
	A5130_SET_CS_LOW(id);	
	spi_writebyte(IDCODE_REG|0x40,id);//read
	basic_delay_us(3);//delay_us(3);
	spi_readbyteN(tmp,8,id);
	A5130_SET_CS_HIGH(id);	
	
	//debug only 
	for(i=0;i<8;i++){
		if(tmp[i] != code[i]){
			rslt =0;
			break;
		}			
	}//for
	

	
	return rslt;
}

/*
read device id*/
void A5130_read_device_id(unsigned char *device_id,unsigned char id)
{
//	unsigned char i;
	
re_set_MISO(id);//test?
	
	A5130_SET_CS_LOW(id);	
	spi_writebyte(USID_REG|0x40,id);// read
	basic_delay_us(3);//delay_us(3);
	spi_readbyteN(device_id,4,id);		
	A5130_SET_CS_HIGH(id);	
}


/**/
static void A5130_set_FIFO(unsigned char id)
{
	re_set_MISO(id);//test?
	
	A5130_SET_CS_LOW(id);	
	spi_writebyte(FIFO1_REG,id);// 
	spi_writebyte(0x3F,id); 	
	spi_writebyte(0x00,id); 		
	basic_delay_us(3);//delay_us(3);
	A5130_SET_CS_HIGH(id);	
}


void A5130_rx_packet(unsigned char *tmp,unsigned char id)
{
	re_set_MISO(id);//test?
	
	A5130_SET_CS_LOW(id);
	
	//basic_delay_us(1);
	spi_writebyte(FIFO_REG | 0x40,id);// 
	//basic_delay_us(2);
	spi_readbyteN(tmp,64,id);		
	//basic_delay_us(2);
	
	A5130_SET_CS_HIGH(id);	
}


/*-------------------------------------------------------------------------------
*/
static void A5130_config(unsigned char id)
{
	unsigned char i;
	
re_set_MISO(id);//test?
	
	for (i=MODECTRL_REG; i<=FIFO2_REG; i++)
		A5130_WriteReg(i, A5130Config[i],id);
	basic_delay_us(3);//	delay_us(3);
	
	for (i=RCOSC1_REG; i<=VCODEVCAL2_REG; i++)
		A5130_WriteReg(i, A5130Config[i],id);
	basic_delay_us(3);//	delay_us(3);

	for (i=0; i<=12; i++)	//0x2A DAS
		A5130_WriteReg_Page(DASP_REG, A5130_Addr2A_Config[i], i,id);
	basic_delay_us(3);//	delay_us(3);

	for (i=VCOMODDELAY_REG; i<=RFANALOG_REG; i++)
		A5130_WriteReg(i, A5130Config[i],id);
	basic_delay_us(3);//	delay_us(3);
	
	A5130_WriteReg(CHSELECT_REG, A5130Config[CHSELECT_REG],id);
	basic_delay_us(3);//	delay_us(3);
		
	for (i=0; i<=10; i++)	//0x38 ROM
		A5130_WriteReg_Page(ROMP_REG, A5130_Addr38_Config[i], i,id);	
	basic_delay_us(3);//	delay_us(3);
		
	for (i=DATARATECLOCK; i<=AFEP_REG; i++)
		A5130_WriteReg(i, A5130Config[i],id);
	basic_delay_us(3);//	delay_us(3);
	
	A5130_WriteReg(KEYC_REG, A5130Config[KEYC_REG],id);	
}



/*********************************************************************
** CHGroupCal
*********************************************************************/
static void CHGroupCal(unsigned char ch,unsigned char id)
{
	unsigned char i,tmp;
	unsigned int j=0;
	unsigned char vb,vbcf,vc,vccf,deva,adev;
	
re_set_MISO(id);//test?	
	
	A5130_WriteReg(PLL1_REG, ch,id);
	A5130_WriteReg(VCOCCAL_REG, A5130Config[0x25],id);	//for test mode
	
	for(i=0;i<5;i++){
		A5130_WriteReg(CALIBRATION_REG, 0x1C,id);
		do{
			tmp = A5130_ReadReg(CALIBRATION_REG,id);
			tmp &= 0x1C;
			j++;
			basic_delay_us(100);//pei
		}
		while ((tmp)&&(j<200));//while ((tmp)&&(j<2000));
	}//for	

    //for check
	tmp = A5130_ReadReg(VCOCAL1_REG,id);
	vb = tmp & 0x0F;
	vbcf = (tmp >>4) & 0x01;
	
	tmp = A5130_ReadReg(VCOCCAL_REG,id);
	vc = tmp & 0x0F;
	vccf = (tmp >>4) & 0x01;

	tmp = A5130_ReadReg(VCODEVCAL1_REG,id);
	deva = tmp;

	tmp = A5130_ReadReg(VCODEVCAL2_REG,id);
	adev = tmp;

	if (vbcf && vccf&&vb&&vc&&deva&&adev){ // 避免报错而已
		//error status.......		
	}		
}



/*
*/
static void A5130_cal(unsigned char id)
{
	unsigned char i,tmp;
	unsigned char fb, fbcf, fcd, rhc, rlc;
	
	StrobeCmd(CMD_PLL,id);	//calibration @PLL state	
	//calibration IF procedure
//	A5130_WriteReg(CALIBRATION_REG, 0x63);
	
	//calibration IF procedure
	A5130_WriteReg(CALIBRATION_REG, 0x63,id);
	i=0; //add by pei
	do
	{
		i++;
		tmp = A5130_ReadReg(CALIBRATION_REG,id);
		tmp &= 0x63;
		basic_delay_us(400);//pei 
	}
	while(tmp&&(i<200));	
	
	//calibration VBC,VDC,VCC procedure
	CHGroupCal(25,id);		//calibrate channel group Bank I
	CHGroupCal(75,id);		//calibrate channel group Bank II
	CHGroupCal(125,id);	//calibrate channel group Bank III

	StrobeCmd(CMD_STBY,id); //return to STBY state
	
	//for check
	tmp = A5130_ReadReg(IFCAL1_REG,id);
	fb = tmp & 0x0F;
	fbcf = (tmp >>4) & 0x01;

	tmp = A5130_ReadReg(IFCAL2_REG,id);
	fcd = tmp & 0x1F;

	rhc = A5130_ReadReg(RXGAIN2_REG,id);
	rlc = A5130_ReadReg(RXGAIN3_REG,id);

	if (fbcf&&fb&&fcd&&rhc&&rlc){// 避免报错而已
		//error //Err_State();
	}	
}




/*----------------------------------------------------
发送数据函数*/
void A5130_send_data_sub(unsigned char *buf,unsigned char count,unsigned char id)
{
	unsigned int j;
		
	//step1 --see datasheet page69 
	StrobeCmd(CMD_TFR,id); 
	//step 2
	A5130_SET_CS_LOW(id);	
	spi_writebyte(FIFO_REG,id );
	spi_writebyteN(buf,count,id);	//64	
	A5130_SET_CS_HIGH(id);
	//step3
	StrobeCmd(CMD_TX,id);   // 启动发送	
	//step 4: wait for WTR
	j=0;	
//	while(WAITFOR_TX_COPMLATE(id)){
//		if(j++>100000) 
//			break;
//	}//while
//	if(j>=100000)//没有发送完成的信号？
//		StrobeCmd(CMD_STBY,id);	

	//modify by pei 
	while(WAITFOR_TX_COPMLATE(id)){
		if(j++>2000) //原100000=18.5ms 实测2000=355us满足需求
			break;
	}//while
	if(j>=2000)//没有发送完成的信号？
		StrobeCmd(CMD_STBY,id);
}



/*
* send multi frame data, that included in *send_function  function;	*/
void A5130_send_beacon(void (*send_function)(const unsigned char *,unsigned char id),const unsigned char *tmp,unsigned char id)
{
	unsigned char it_pin_nbr =rf_it_pin_nbr[id];
	
	EXTI->IMR&=~(1<<it_pin_nbr);	  // 屏蔽接收中断
	
re_set_MISO(id);//test?
	
	StrobeCmd(CMD_STBY,id);	//强制切换到stby,为发送做准备
	PA_RX_DISENABLE(id);
	PA_TX_ENABLE(id);	//开PA

	send_function(tmp,id);	//send_function 
	
	PA_TX_DISENABLE(id); //关PA
	PA_RX_ENABLE(id);		
	StrobeCmd( CMD_RX,id); //切换成接收 执行此命令会拉高中断口GIO1
	
	{
		/*//add by Gavin1211 ,
		发送完7帧后，中断脚上会多出一个意外中断信号，会引起中断，读出的数据都是0x00的无效数据，增加mcu负担;
		增加此语句后，mcu就不响应这个意外中断！！
		*/
			uint16_t it_pin =rf_it_pin[id];
		__HAL_GPIO_EXTI_CLEAR_IT(it_pin);	//清除LINE2上的中断标志位 
	}

  EXTI->IMR |=(1<<it_pin_nbr);	  	// 屏蔽接收中断	
}



/*
*  5.8G modual send data that in buf[] only */
void rf_SendPacket(unsigned char *buf,unsigned char len,unsigned char id )
{
	unsigned char it_pin_nbr =rf_it_pin_nbr[id];
	
	EXTI->IMR&=~(1<<it_pin_nbr);	  // 屏蔽接收中断
	
re_set_MISO(id);//test?	
	
	StrobeCmd(CMD_STBY,id);	//强制切换到stby,为发送做准备
	PA_RX_DISENABLE(id);
	PA_TX_ENABLE(id);	//开PA

	A5130_send_data_sub(buf,len,id);
	
	PA_TX_DISENABLE(id); //关PA
	PA_RX_ENABLE(id);		
	StrobeCmd( CMD_RX,id); //切换成接收 执行此命令会拉高中断口GIO1
	
	{//add by Gavin1211
			uint16_t it_pin =rf_it_pin[id];
		__HAL_GPIO_EXTI_CLEAR_IT(it_pin);	//清除LINE2上的中断标志位 
	}	
	
  EXTI->IMR |=(1<<it_pin_nbr);	  	// 屏蔽接收中断	
}





//#include "base_core.h"
extern void rf_modual_5G8_invalid_set(void);
/*----------------------------------------
A5130 interrupt receive  service function!
called by exti*/
void rf_Irq(unsigned char id)	
{
	
	unsigned char rx_buf[65];
	uint16_t it_pin =rf_it_pin[id];
	
	__HAL_GPIO_EXTI_CLEAR_IT(it_pin);	//清除LINE2上的中断标志位 	

	A5130_rx_packet(rx_buf+1,id);

	PA_RX_ENABLE(id);		
	StrobeCmd(CMD_RFR,id);		//清除接收buf，否则接收数据会错位!!!
	StrobeCmd(CMD_RX,id); 		//切换成接收 执行此命令会拉高中断口GIO1
		
	rx_buf[0] = id;	//record INT id
	base_core.rf_data_fifo_in(rx_buf);
	#ifdef 	RF_MODUAL_5G8_MONITOR
	//特点：a,有中断信号但是没有数据或者数据不正确;b,发送时reg0=0x18;c,接收时reg0=0x19;
	if( A5130_ReadReg(0,id) !=0x19)
		rf_modual_5G8_invalid_set();
	#endif
	__HAL_GPIO_EXTI_CLEAR_IT(it_pin);	//清除LINE2上的中断标志位 		
}


/*********************************************************************
** SetCH
*********************************************************************/
void rf_setfreq(unsigned char ch,unsigned char id)
{
	PLATFORM_DISABLE_IRQ();//CLI();
//	ch *=5;	//24个频点;
	ch *=10;	//12个频点;
	StrobeCmd(CMD_STBY,id);//pei 否则RX模式下设置会导致发送全面失效
	A5130_WriteReg(PLL1_REG, ch,id);	//RF freq = RFbase + (CH_Step * ch)
	PLATFORM_ENABLE_IRQ();//SEI();
}

//基站设置功率，放在频点初始化函数里面
void rf_set_PA_Mode( unsigned char mode ,unsigned char rf_seq)
{

}



unsigned char dev_id[4];
//------------------------------------------------------------------
void rf_initial(unsigned char id)
{	
	A5130_WriteReg(MODE_REG, 0x00,id);	//reset RF chip
	basic_delay_ms(200);//delay_ms(200);
	A5130_config(id);
	A5130_write_ID_code(ID_Tab,id);			
	A5130_read_device_id(dev_id,id);	

	A5130_Trimming(id);
	A5130_cal(id);
	rf_setfreq(1,id);
	A5130_set_FIFO(id);
				
	PA_RX_DISENABLE(id);
	PA_TX_DISENABLE(id); //??	
	
}

#endif












