/*
上传多包处理：
基站协议V0.95，第5.5基站上传多包
键盘协议V0.99-11,第四章上传多包;

*/


#include 	"platform_interface.h"
#include 	"function_interface.h"
#include 	"function.h"
#include 	"base_core_user.h"
#include "string.h"






#if 0
/*
* see base protocol V0.95 section5.5 基站多包上传
*/
struct upload_multipkt_STR{
	unsigned char mode_status;	//byte4
	unsigned char id_sn_mode;	
	unsigned char id_sn[6];		
	unsigned char pkt_type;			//byte12
	unsigned char pkt_id;				//byte13	

	//-above parameter is protocol ;next is user define------------
	unsigned char packH;	
	unsigned char packL;
	
	unsigned char pack_cur;
	unsigned short pack_16bits;	
	unsigned short pack_total;
	unsigned char keypad_ack_flag;
	unsigned char start_stop_flag;
	
};
struct upload_multipkt_STR up_multipkt;


/*
* process sdk setting data,then ack 
*/
void upload_multipkt_0x61_process(unsigned char *rxpc)
{	
	unsigned char ack_buf[2];

	memcpy(&up_multipkt.mode_status,rxpc+4,10);	
	ack_buf[0] =1;
	user__pc_cmd_ack(0x61,23,ack_buf,1);
	
	if(up_multipkt.mode_status==1){
		
	}
	else{
		
	}
	
}




//--------------------------------------------------
/*
* see keypad protocol V0.99-10 section4 上传多包
*section4.1 键盘开始多包接收
*section4.2 询问多包和应答
*section4.3 多包接收完毕确认
*/
#define 	UPMULTI_CMD__STARTUP	1	//进入多包上传模式
#define 	UPMULTI_CMD__INQUIRY	2	//询问多包数据
#define 	UPMULTI_CMD__DONE			3 //多包接收完毕-确认

static void base_tx__multipkt_cmd(unsigned char cmd)
{
	unsigned char tmp[64];
	memset(tmp,0,64);

	tmp[0] =32;
	base_core.get_match_code(tmp+1);
	tmp[5] =0x20;
	
	if( up_multipkt.id_sn_mode==1){
		tmp[6] =up_multipkt.id_sn[0];
		tmp[7] =up_multipkt.id_sn[1];		
	}
	else{
		tmp[6] =0xff;
		tmp[7] =0xff;		
		memcpy(tmp+14,up_multipkt.id_sn,6);
	}
	tmp[8] =cmd; 
	tmp[9] =up_multipkt.pkt_type; 	
	tmp[10] =up_multipkt.pkt_id; 

	if(cmd==UPMULTI_CMD__INQUIRY){
		tmp[11] =up_multipkt.pack_cur; 	
		tmp[12] =up_multipkt.pack_16bits>>8; 	
		tmp[13] =up_multipkt.pack_16bits; 
	}	
	
	base_core.send_rf_data(tmp,base_core.get_mainRF_hard_id());
}


/*
*初始化接收多包的参数！！
*/
static void init_multipkt_rcv_parameter(void)
{
	if(up_multipkt.pack_total >=16){
		up_multipkt.pack_16bits=0xffff;
		up_multipkt.pack_total -=16;
	}
	else{
		up_multipkt.pack_16bits= (1<<up_multipkt.packL)-1;
		up_multipkt.pack_total=0;
	}
}

/*
* 初始化发送询问命令
*/
static void multipkt_inquiry_init(void)
{
	up_multipkt.pack_cur =0;
	up_multipkt.pack_total=(up_multipkt.packH<<8) +up_multipkt.packL;
	init_multipkt_rcv_parameter();

}

/*
* 
*return : 0- 全部完成了; 1-还要继续
* 
*/
static unsigned char check_multipkt_ack(void)
{
	if(up_multipkt.pack_16bits==0){
		//本次数据包收齐了;是否还有下一个大包
		if(up_multipkt.pack_total==0){
			return 0;
		}
		else{
			up_multipkt.pack_cur++;
			init_multipkt_rcv_parameter();
		}
	}
	
	return 1;
}




/*
*处理键盘多包上传数据
*/
unsigned char keypad_multipkt_process(unsigned char *rxkp)
{
	if(rxkp[1] !=0xA0) return 0;

	switch(rxkp[4]){
		case UPMULTI_CMD__STARTUP:
			
			//up_multipkt.packH =
			break;
		
		
		default:break;
	}//sw
	
}





#define 	WAIT_ACK_TIME		20
/*
* 基站处理上传多包
* called by 2.5ms timer isr
*
*/
void base_tx_keypad_get_multipkt_progress(void)
{
	static unsigned char multipkt_beacon_count=0;
	static unsigned char multipkt_beacon_step;
	static unsigned char wait_ack_time=0;	
	
	if(!up_multipkt.start_stop_flag) return;
		
	if(++multipkt_beacon_count>=13){
		multipkt_beacon_count=0;
		//send normal beacon 
		base_core.switch_send_beacon(1); //on basic beacon send
		return;	
	}
	else if(multipkt_beacon_count>10){
		
		return;
	}
	
	
	//1-10 时间片用于发送
	base_core.switch_send_beacon(0); //off basic beacon send
	
	switch(multipkt_beacon_step){
		case 0:	break;
		
		case 1: //启动多包
			base_tx__multipkt_cmd(UPMULTI_CMD__STARTUP);
			wait_ack_time=0;
			up_multipkt.keypad_ack_flag =0;
			multipkt_beacon_step=2;
			break;
		
		case 2://等待键盘对多包启动的回应
			if( up_multipkt.keypad_ack_flag){
				multipkt_inquiry_init();
				multipkt_beacon_step=3;
				goto goto_send_inquiry;
			}
			else{
				if(++wait_ack_time>= WAIT_ACK_TIME){
					//error
					return;
				}
				base_tx__multipkt_cmd(UPMULTI_CMD__STARTUP);
			}
			break;
		
		case 3:	//发送多包请求
		goto_send_inquiry:
			base_tx__multipkt_cmd(UPMULTI_CMD__INQUIRY);
			wait_ack_time=0;
			up_multipkt.keypad_ack_flag =0;	
			multipkt_beacon_step=4;
			break;
		
		case 4://等待键盘对多包回应
			if( up_multipkt.keypad_ack_flag){
				if(check_multipkt_ack() ){
					base_tx__multipkt_cmd(UPMULTI_CMD__INQUIRY);//发的是下一个数据包
				}
				else{
					//finish report;
					multipkt_beacon_step=5;
				}
			}
			else{
				if(++wait_ack_time>= WAIT_ACK_TIME){
					//error report
					return;
				}
				base_tx__multipkt_cmd(UPMULTI_CMD__INQUIRY);//重复发本次
			}
		
		case 5:
			base_tx__multipkt_cmd(UPMULTI_CMD__DONE);
			wait_ack_time=0;
			up_multipkt.keypad_ack_flag =0;	
			multipkt_beacon_step=6;		
			break;
		
		case 6:
			if( up_multipkt.keypad_ack_flag){
				//ok,exit
				multipkt_beacon_step=0;
				up_multipkt.start_stop_flag=0;
			}
			else{
				if(++wait_ack_time>= WAIT_ACK_TIME){
					//error, exit
					multipkt_beacon_step=0;
					up_multipkt.start_stop_flag=0;
					return ;
				}
				base_tx__multipkt_cmd(UPMULTI_CMD__DONE);
			}
			break;
		
		default:break;
	}//sw

}




#endif
