/*
*2020.02.05 Gavin 
设置发送信息 信标

*/


#include 	"platform_interface.h"
#include 	"function_interface.h"
#include 	"function.h"
#include 	"base_core_user.h"
#include "string.h"

#if 0

///*
//发送信息信标 --参数
//cmdtype =11
//*/
//struct txmsg_beacon_para_STR{
//	unsigned char head_addr; 	//is struct head address,no actual utility
//	unsigned char type;	//byte4
//	unsigned char times;	
//	unsigned char slots;	
//};


///*
//发送信息信标 --内容
//cmdtype =12
//*/
//struct txmsg_beacon_content_STR{
//	unsigned char head_addr; 	//is struct head address,no actual utility		
//	unsigned char type;
//	unsigned char slotmax;
//	unsigned char cur_slot;	
//	
//};


/*
发送信息  信标
*/
struct msg_beacon_STR{
//	//a参数
	unsigned char type;
//	unsigned char times;	
//	unsigned char slots;	
	
	//b内容
	unsigned char slotmax;
//	unsigned char cur_slot;	
	unsigned char sdata[255][16];
	
//	//c 启动
//	unsigned char specify_or_boardcast;
//	unsigned char id_sn[6];
	
	//-----NO protocol parameter --------------------
	unsigned char start_stop_flag;
	unsigned char cur_slot;		
	unsigned char datapos;
	unsigned char cur_times;	
};
struct msg_beacon_STR msg_beacon;


#define 	MSG_BEACON_SLOT_MAX		20	
#define 	MSG_BEACON_BOARD_TIMES		10

//------------------ 与pc的通信 --------------------------------------------

void msg_beacon_0x60_process(unsigned char *rxpc)
{	
		unsigned char ack_buf[32];
	
		switch(rxpc[3]){	
			case 11:
				break;
			
			case 12:
				if( (rxpc[4] ==1)||(rxpc[4] ==2) ){ //题型
					unsigned char cur_slot;
					msg_beacon.type =rxpc[4];
					if( (msg_beacon.slotmax =rxpc[5])>MSG_BEACON_SLOT_MAX)
						msg_beacon.slotmax =MSG_BEACON_SLOT_MAX;				
//					msg_beacon.slotmax = (rxpc[5]>MSG_BEACON_SLOT_MAX)?MSG_BEACON_SLOT_MAX:rxpc[5];									
					if( (cur_slot =rxpc[6])>MSG_BEACON_SLOT_MAX-1)
						cur_slot =MSG_BEACON_SLOT_MAX-1;
					memcpy(msg_beacon.sdata[cur_slot],rxpc+7,16);
					ack_buf[0] =1;
					user__pc_cmd_ack(0x60,12,ack_buf,1);
				}
				break;			
			
			
			case 13:
				break;	
			
			default:break;
		}//sw
}







/*
* see keypad protocol section2.4
*/
static void send_msg_beacon_sub(void)
{
	unsigned char tmp[64];
	memset(tmp,0,64);

	tmp[0] =32;
	base_core.get_match_code(tmp+1);
	tmp[5] =0x31;
	//tmp[6] =0x31;//6-11
	tmp[12] =msg_beacon.type |(msg_beacon.datapos<<4);
	tmp[13] =0;		//高4位：广播和提交数据比;低4位：第几个时序
	tmp[14] =msg_beacon.slotmax;	//slot max
	tmp[15] =msg_beacon.cur_slot; //current slot
	memcpy(tmp+16,msg_beacon.sdata[msg_beacon.cur_slot],16);
	msg_beacon.cur_slot++;
	//tmp[32] =0x31;	//CRC
	base_core.send_rf_data(tmp,base_core.get_mainRF_hard_id());
}


/*
* called by 2.5ms timer isr
*
*/
void base_tx_keypad_msg_beacon(void)
{
	static unsigned char msg_beacon_count=0;
		
	if(!msg_beacon.start_stop_flag) return;
	
	if(++msg_beacon_count>= 13){
		msg_beacon_count=0;
		base_core.switch_send_beacon(1); //on basic beacon send
	}
	else{
			//12个时间片里只发10个，为什么？
		
			base_core.switch_send_beacon(0); //off basic beacon send
		
			send_msg_beacon_sub();
			if( msg_beacon.cur_slot>=msg_beacon.slotmax){				
				//广播完一轮了
				if(++msg_beacon.cur_times >=MSG_BEACON_BOARD_TIMES){
					base_core.switch_send_beacon(1); //on basic beacon send
					msg_beacon.start_stop_flag =0;
				}
			}			
	}
	
}










//判断是否需要自动进入信息信标广播
void msg_beacon_enter_exit(const unsigned char *rxpc)
{
	if (rxpc[3]!=4) return;//写投票信标
	if((rxpc[5]==14)&&((rxpc[6]==20)||(rxpc[6]==21)))// 5是MODE，14是异步测验  20、21是带长题型和答案
	{
		msg_beacon.cur_times =0;				//init send times 
		msg_beacon.cur_slot =0;					//init solt
		if(++msg_beacon.datapos>15)			//init data pos
			msg_beacon.datapos =1;
		msg_beacon.start_stop_flag =1;	//start		
	}
	else{
		if(msg_beacon.start_stop_flag){
			base_core.switch_send_beacon(1); //on basic beacon send
			msg_beacon.start_stop_flag =0;
		}
	}	
	
}


#endif
