
#include "function_interface.h"
#include "platform_interface.h"
#include "base_core_user.h"
//#include "base_pc_protocol.h"
#include "base_core.h"
#include "function.h"
#include "string.h"
#include <stdlib.h>
#include "HW_MCUIO.h"

#define  NAME_VIEW_BIT          0x01
#define  DISABLE_NAME_VIEW_BIT  0xFE
#define  MATCH_BIT              0x02
#define  DISABLE_MATCH_BIT      0xFD
#define  WHITELIST_BIT          0x04
#define  DISABLE_WHITELIST_BIT  0xFB

void set_tx_ok_flag(unsigned char flag);
unsigned char get_tx_ok_flag(void);
void basic_delay_us( unsigned short time );

struct network_STR
{
    unsigned char cnt;
    unsigned char net_seq;
    unsigned char st_bit;
    unsigned short pwd;
    unsigned char reserve[2];
    unsigned char name[13];
    unsigned char name_viewable;
    unsigned char send_flag;
    unsigned int  randspace;
    unsigned short send_cnt;
};

struct network_STR Network={
	.net_seq=0,
    .cnt=60,
    .st_bit=0,
    .pwd=0x0400,
    .name="B100",
    .name_viewable=1,
    .send_flag=0,
    .randspace=100,
    .send_cnt=0,
};

unsigned int RandData(unsigned int max)
{
    unsigned char buf[5];
    base_core.get_match_code(buf);
    if (max == 0)
    {
        srand((buf[0]+buf[1])*256+buf[2]+buf[3]);
        return 0;
    }
    else if (max == 1)
    {
        srand((buf[0]+buf[1])*256+buf[2]+buf[3] + HW_TIMER_Count_get( TIMER5 ));//TIM5->CNT);
        return 1;
    }
    else
    {
        return (rand() % max);
    }
}

unsigned int network_randtime(unsigned int max)
{
    unsigned int rr, randmax, subtime;
    
    if(Network.send_cnt==0)
    {
        RandData(1);//
    }
    if(Network.send_cnt>250)
    {
        Network.send_cnt=0;
    }
    else
    {
        Network.send_cnt++;
    }
    
    randmax = max / 4;// 4 times per 1S
    rr = RandData(randmax);
    subtime = randmax + rr - Network.randspace; //
    Network.randspace = rr;
    return subtime;
}

void network_wait_rfsendOK(void)
{
    unsigned char status;
    unsigned short wait = 500;

    while (wait)
    {
        if (get_tx_ok_flag())
            return;
        basic_delay_us(2);
        wait--;
    }
}

/*

*/
void network_tx_beacon(void)
{	
    unsigned char buf[40]={0};
    unsigned char j;
    unsigned short crc;
    buf[0] =32;			
    base_core.get_match_code(buf+1);//tmp1-4
    buf[5] = 0x51;	
    buf[6] =Network.net_seq; //nowT
    if( log_mode_is_WHITELIST)	
        buf[7]=2;
    else
        buf[7]=1;
    buf[8]=base_core.get_main_rf_chan();
    buf[9]=0;
    buf[10]=0;
    buf[11]=0;
    buf[12]=0;
    buf[13]=0;
    if(Network.name_viewable) 
        buf[13]|=NAME_VIEW_BIT;
    else
        buf[13]&=DISABLE_MATCH_BIT;
    
    if(base_core.get_run_status() == _STA_FAST_MATCH)
        buf[13]|=MATCH_BIT;
    else
        buf[13]&=DISABLE_MATCH_BIT;
    
    if(buf[7]==2) 
        buf[13]|=WHITELIST_BIT;
    else
        buf[13]&=DISABLE_WHITELIST_BIT;
    
    buf[14]=(Network.pwd>>8)&0xFF;
    buf[15]=(Network.pwd)&0xFF;

    buf[16]=0;buf[17]=0;
    memcpy(buf+18, Network.name, 12);  
    crc = crc16(buf+5, 27);
    buf[31]=(crc>>8)&0xFF;
    buf[32]=crc&0xFF;
    
    Network.send_flag=1;
    platform.rf_set_freq(0,base_core.get_mainRF_hard_id());
    base_core.send_rf_data(buf,base_core.get_mainRF_hard_id());
    
}

//4 or 5 times per S
static void network_creat_random_delay(void)
{
    Network.cnt = network_randtime(400);//60;//
    if(Network.cnt == 0) 
    {
        Network.cnt = 60;
    }
}

void network_polling(unsigned char mode)
{
    if(Network.send_flag)
    {
        Network.send_flag=0;
        platform.rf_set_freq(base_core.get_main_rf_chan(),base_core.get_mainRF_hard_id());
    }
    
    if(mode)
    {
        if(Network.cnt)
        {
            Network.cnt--;
            if(Network.cnt==0)
            {
                network_tx_beacon();
                network_creat_random_delay();
            }            
        }
        else//20221101  if Network.cnt==0  
        {
            network_creat_random_delay();
        }
    }
}

unsigned char network_get_netseq(void)
{
    return Network.net_seq;
}

void network_set_netseq_change(void)
{
    Network.net_seq++;
}
unsigned short network_get_pwd(void)
{
    return Network.pwd;
}

void network_set_pwd(unsigned short pwd)
{
    Network.pwd = pwd;
}

unsigned char network_get_name(unsigned char *buf, unsigned char buflen)
{
    if(buflen<12) return 0;
    memcpy(buf,Network.name,12);
    return 1;
}

unsigned char network_set_name(unsigned char *buf, unsigned char buflen)
{
    if(buflen>12) return 0;
    memcpy(Network.name,buf,buflen);
    return 1;
}

unsigned char network_get_nameview(void)
{
    return Network.name_viewable;
}

void network_set_nameview(unsigned char view)
{
    if(view) Network.name_viewable = 1;
    else Network.name_viewable = 0;
}




