
#include "base_core_user.h"
#include "platform_interface.h"
#include "function.h"
#include "function_interface.h"
#include "string.h"

/*
见基站协议section5.2.7
信道评估，同频点干扰检测及上报
*/






struct monitor_freq_STR{
volatile	unsigned char monitor_interval;//检测干扰的间隔
	unsigned char disturb_cnt;
	unsigned char report_interval; //报告干扰的间隔
	
	unsigned char search_new_freq_flag;
	unsigned char search_cnt;	
	unsigned char new_freq;
	
	// unsigned char disturb_status;
	// unsigned char disturb_last_status;
};
//static 
	struct monitor_freq_STR monitor_freq;

// #ifdef LCD_ON
// /*

// */
// unsigned char get_same_freq_lcd_display(void)
// {
	
// 		if( !function.monitor__SW) 
// 			return 0;
		
// 		if(monitor_freq.disturb_status !=monitor_freq.disturb_last_status){
// 				monitor_freq.disturb_last_status =monitor_freq.disturb_status;
			
// 				if( monitor_freq.disturb_status==1){
// 					lcd_display_same_freq_distrub(1);
// 				}
// 				else if( monitor_freq.disturb_status==2){
// 					lcd_display_same_freq_distrub(0);//退出同频干扰显示
// 				}
// 				return 1;						
// 		}
		
// 		if(monitor_freq.disturb_status ==1)
// 			return 1;
		
// 		return 0;
// }
// #endif










/*
pc发送命令开启搜索新频点，
*/
void auto_search_freq_enter(void)
{
		monitor_freq.disturb_cnt =0;
		monitor_freq.monitor_interval=0;
		monitor_freq.search_cnt=0;
	
		monitor_freq.new_freq = base_core.get_main_rf_chan();
		monitor_freq.search_new_freq_flag=1;
}


/*
监测无线键盘数据 
called by 无线接收函数！！
*/
unsigned char monitor_rf_data(unsigned char *rx_kp)
{
	if( !function.monitor__SW) return 0;
	
	#ifdef A5130
	if(rx_kp[1]==0x17)			
	#else
	//if( (rx_kp[5]==0x10)&&(rx_kp[7]==0xA5)&&(rx_kp[8]==base_core.get_main_rf_chan()) )		
	//非CRS2协议下，id和sn模式都有效
	//CRS2协议下只有id模式有效	
	if(  ( (rx_kp[5]==0x10)&&(rx_kp[8]==base_core.get_main_rf_chan()) ) \
		|| ( ((rx_kp[5]==0x13) ||(rx_kp[5]==0x14))&&(rx_kp[30]== base_core.get_main_rf_chan()) )  \
		|| ( (rx_kp[5]==0x17)&&(rx_kp[31]==base_core.get_main_rf_chan()) )   )
	#endif 
	{		
		if(monitor_freq.disturb_cnt<250)//防止溢出
			monitor_freq.disturb_cnt++;	
//		//debug 
//		if( monitor_freq.disturb_cnt> 25){
//			monitor_freq.disturb_cnt =26;
//		}		
		return 1;
	}
	return 0;

}





/*
检测是否有干扰
return:
	0- 定时时间未到
	1- 有干扰
	2- 没有干扰
*/
static unsigned char check_disturb(void)
{	
	//5s内收到25次干扰，认为有同频干扰	
	 if(++monitor_freq.monitor_interval<250) return 0;	//20ms*250=5S定时器
		monitor_freq.monitor_interval=0;
		
		if(monitor_freq.disturb_cnt>=45){		//25->45
			monitor_freq.disturb_cnt=0;
			return 1;
		}
		else{
			monitor_freq.disturb_cnt=0;
			return 2;			
		}		
}

static void monitor_freq_ack_pc(const unsigned char *ack_buf,unsigned char type_data_len)
{
		unsigned char tmp[64]; //whitelist 需要的buf长些

		memset(tmp,0,sizeof(tmp)/sizeof(tmp[0]));//mem_set(tmp,sizeof(tmp)/sizeof(tmp[0]),0);
		tmp[0]= 31;
		tmp[1]= 0xE1;
		tmp[2]= base_core.get_id();//
		tmp[3]= 10;//type;
		memcpy( tmp+4,ack_buf,type_data_len);//mem_cpy( ack_buf,tmp+4,type_data_len);
		
		//send to pc 
		if(base_core.get_sdk_connect_status_acc() )
		base_core.send_data_to_pc(tmp);//user__base_tx_to_pc_sub(tmp);
}


/*
基站检测当前频点是否有干扰，
如果有干扰，上报给pc,查找干净的频点
called by 20ms 
*/
void monitor_freq_process(void)
{
#if 0
		unsigned char rslt;
		unsigned char ack_pc[32];

		if( !function.monitor__SW) return;
	
		if( ( rslt=check_disturb())==0 ) return;//0 5S定时未到
		monitor_freq.disturb_status	=rslt;
	
		if(monitor_freq.disturb_status==1){		//1 有干扰
			if(monitor_freq.search_new_freq_flag){//搜索状态
				if( monitor_freq.search_cnt>function.rf_channel_max){ //FREQ_MAX  FREQMAX
					//所有频点都搜索完了
					platform.rf_set_freq(base_core.get_main_rf_chan(),base_core.get_mainRF_hard_id());//platform.rf_set_freq(base_core.get_main_rf_chan(),base_core.get_main_rf_id());					//恢复搜索前的频点
					monitor_freq.search_new_freq_flag=0;
					//report to pc 
					ack_pc[0] =3;
					ack_pc[1] =base_core.get_main_rf_chan();//get_base_main_rfchannel();					
					ack_pc[2] =77;
					ack_pc[3] =20;
					ack_pc[4] =5;
					monitor_freq_ack_pc(ack_pc,5);
				}
				else{				
					monitor_freq.new_freq++;
					monitor_freq.search_cnt++;					
					if( (monitor_freq.new_freq <=0)||(monitor_freq.new_freq> function.rf_channel_max) ) //assert_freq  80??
						monitor_freq.new_freq=1;
					
					//platform.rf_set_freq(monitor_freq.new_freq,base_core.get_mainRF_hard_id());
					base_core.set_main_rf_chan(monitor_freq.new_freq);
				}
			}
			else{
				//report to pc
					ack_pc[0] =3;//4;//同频干扰提醒;
					ack_pc[1] =base_core.get_main_rf_chan();//monitor_freq.new_freq;					
				  monitor_freq_ack_pc(ack_pc,2);
					platform.buzzer_ctrl(1);
			}
		}
		else if(monitor_freq.disturb_status==2){//2 没有干扰
			if( !monitor_freq.search_new_freq_flag) return;//搜索状态
			monitor_freq.search_new_freq_flag=0;//关闭搜索新频点功能
			base_core.set_main_rf_chan(monitor_freq.new_freq);//记录新的频点//保存新频点到E2prom				
			//report to pc
			ack_pc[0] =4;	//
			ack_pc[1] =monitor_freq.new_freq;					
      monitor_freq_ack_pc(ack_pc,2);			
		}	
#else
		unsigned char rslt;
		unsigned char ack_pc[32];
		if( !function.monitor__SW) return;
	
		switch (check_disturb())
		{
		case 1://有干扰
			if(monitor_freq.search_new_freq_flag){//搜索状态
				if( monitor_freq.search_cnt>function.rf_channel_max){ //FREQ_MAX  FREQMAX
					//所有频点都搜索完了
					//platform.rf_set_freq(base_core.get_main_rf_chan(),base_core.get_mainRF_hard_id());////恢复搜索前的频点???					
					monitor_freq.search_new_freq_flag=0;
					//report to pc 
					ack_pc[0] =3;
					ack_pc[1] =base_core.get_main_rf_chan();//get_base_main_rfchannel();					
					ack_pc[2] =77;
					ack_pc[3] =20;
					ack_pc[4] =5;
					monitor_freq_ack_pc(ack_pc,5);
				}
				else{				
					monitor_freq.new_freq++;
					monitor_freq.search_cnt++;					
					if( (monitor_freq.new_freq <=0)||(monitor_freq.new_freq> function.rf_channel_max) ) //assert_freq  80??
						monitor_freq.new_freq=1;
					//设置新频点后，重新计时和计数;
					monitor_freq.monitor_interval=0;
					monitor_freq.disturb_cnt=0;
					//platform.rf_set_freq(monitor_freq.new_freq,base_core.get_mainRF_hard_id());
					base_core.set_main_rf_chan(monitor_freq.new_freq);
				}
			}
			else{
				//report to pc
					ack_pc[0] =3;//4;//同频干扰提醒;
					ack_pc[1] =base_core.get_main_rf_chan();//monitor_freq.new_freq;					
				  monitor_freq_ack_pc(ack_pc,2);
					//platform.buzzer_ctrl(1);
			}			
			break;

		case 2://没有干扰
			if( !monitor_freq.search_new_freq_flag) return;//搜索状态
			monitor_freq.search_new_freq_flag=0;//关闭搜索新频点功能
			//base_core.set_main_rf_chan(monitor_freq.new_freq);//记录新的频点//保存新频点到E2prom				
			//report to pc
			ack_pc[0] =4;	//
			ack_pc[1] =monitor_freq.new_freq;					
      		monitor_freq_ack_pc(ack_pc,2);		
			break;

		default:
			break;
		}

#endif		
}







