/*
function_hard_test.c用于硬件测试
1,收到某个触发信号后进入硬件测试模式
2,进入死循环，测试完成通过led,lcd,buzzer等指示测试结果
3,需要重新拔插才能回到正常模式;
*/

#include "function_interface.h"
#include "platform_interface.h"

struct hard_test_STR{
	#define HARD_TEST_CH	19		//硬件测试时使用的频点
	unsigned char flag;
	unsigned char rf_modual_cnt;
	unsigned char rf_modual_id[4];	
};

struct hard_test_STR hard_test;


/*

*/
unsigned char rf_modual_RXTX_test(unsigned char id)
{
		unsigned char main_id= hard_test.rf_modual_id[0];
		char tx_buf[32]= "Sunvote base hard test";
	
		//a,main rf modual init
		platform.rf_init(main_id);
		platform.rf_set_freq(HARD_TEST_CH,main_id);
		
		//b,target rf modual init
		platform.rf_init(id);
		platform.rf_set_freq(HARD_TEST_CH,id);	
		
		//c,target modual TX,Main modual RX
		platform.rf_send_data((unsigned char *)tx_buf,32,id);
		//wait for main modual Rx data,then check data right or not;		
	
		//d,target modual RX,Main modual TX
		platform.rf_send_data((unsigned char *)tx_buf,32,main_id);
	
	

		//e,set target modual to other channel after test complete;
		platform.rf_set_freq(1,id);
		
		return 0;
}




/*
硬件测试入口

*/
void hard_test__enter(void)
{
		unsigned char i,err_flag=0;
		//a,init 
		
		//统计模块的个数，每个模块的硬件编号;
		hard_test.rf_modual_cnt =0;
		for(i=0;i<4;i++){ 		
			if((function.rf_id[i]==0xff)||(function.rf_id[i]==0xfe)||(function.rf_id[i]==0xfb) ){
				hard_test.rf_modual_id[hard_test.rf_modual_cnt ] = i;		
				hard_test.rf_modual_cnt++;			
			}		
		}//for	
				
		for(i=1;i<hard_test.rf_modual_cnt;i++){
			if( rf_modual_RXTX_test(hard_test.rf_modual_id[i]) ==0){
				err_flag =1;
				break;
			}				
		}//for
				
		if(err_flag){  //error
					
		}
		else{ //test pass;
					
		}	
}






