
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "platform_interface.h"


//-------------------------------------- NFC  reader --------------------------------------------------

#ifdef _NFC_READER_
/*
* nfc function 调试函数
*/
static void _debug_process__nfc(const unsigned char *pc,unsigned char *ack)
{
	
	if(pc[11] =='S'){	//status 
		switch (pc[12]){
			case '1':	//set 
				if(pc[14]== 1){
					nfc_app.mode_status =0x02;
					memcpy(ack,"OK ",3);//mem_cpy("OK ",ack,3); 
				} 
				else if(pc[14]== 0){
					nfc_app.mode_status =0x00;
					memcpy(ack,"OK ",3);//mem_cpy("OK ",ack,3); 
				}
				else
					memcpy(ack,"ERR",3);//mem_cpy("ERR",ack,3); 
				break;

			case '3':	//get
				ack[0] = (nfc_app.mode_status==0x02)?1:0;
				break;		

			default:
				memcpy(ack,"ERR",3);//mem_cpy("ERR",ack,3);
				break;
		}//sw
	}
	else if(pc[11] =='O'){	//write or read operation
		switch (pc[12]){
			case '1':	//read block			
				platform.rfid_reader(pc[14],pc[15],ack);
				break;

			case '2':	//write block
				break;

			default:
				memcpy(ack,"ERR",3);//mem_cpy("ERR",ack,3);
				break;
		}//sw
	}

}
#endif 




//ack
static void _dbg_function__response_pc_cmd( char type[], unsigned char *ack,unsigned char len)
{
    unsigned char tmp[64];
    if(len>56) len=56;   
    memcpy(tmp+8,ack,len);// mem_cpy(ack,tmp+8,len);
    memset(tmp+8+len,' ',56-len); //mem_set(tmp+8+len,56-len,' ');
    tmp[0] = 'a';
    tmp[1] = 'c';
    tmp[2] = 'k'; 
    tmp[3] = '-';     
    tmp[4] = type[0];
    tmp[5] = type[1];
    tmp[6] = type[2];
    tmp[7] = ':';        
    platform.base_send_data_to_pc(tmp,64);
}


/* ------------------------------------------------------------
* function debug 总入口
* bushound input format: ff A0 *in
*
*/
void _debug_function_enter(const unsigned char *pc)
{
	unsigned char tmp[64];//,cmd_type;
	unsigned char start_offset =6;

	memset(tmp,' ',64); //mem_set(tmp,64,' ');
	memcpy(tmp,pc+8,start_offset); //mem_cpy(pc+8,tmp,start_offset);
	//cmd_type =pc[12];
	//pc[14] ---有效数据开始....
	#ifdef _NFC_READER_	//NFC相关
	if(memcmp(pc+8,(unsigned char*)"NFC",3) ==0 ){ //if(mem_compare(pc+8,(unsigned char*)"NFC",3) ){
		_debug_process__nfc(pc,tmp+start_offset); 
	}
	#endif 



	//response pc cmd 
	_dbg_function__response_pc_cmd("fun",tmp,64);
}

