
#include "platform_interface.h"
#include "dot.h"
#include "function.h"
#include "base_core_user.h"
#include "function_interface.h"


#ifdef LCD_ON
//版本
const unsigned char VERSION[]={	
	CB0E6,
	CB1BE,
	CA3BA //:
};

//频点
const unsigned char CHANNEL[]={
	CC6B5,
	CB5E3,
	CA3BA //:	
};


/*连接状态*/
const unsigned char CONNECT_STAT[]={
	CC1AC,
	CBDD3,
	CD7B4,
	CCCAC,
	CA3BA //:
};

//已连接
const unsigned char CONNECT_STAT_LINK[]={
	CD2D1,
	CC1AC,
	CBDD3,

};
//未连接
const unsigned char CONNECT_STAT_NOLINK[]={
	CCEB4,
	CC1AC,
	CBDD3,

};




/*
* 显示数字子函数：头数字是0不显示；b,每个单元只是显示一个字符(尽管是0也显示)
*/
static unsigned char calc_valid_disp_char(unsigned char sw,unsigned char *ver_tmp)
{
	unsigned char tmp[3],len=0;
	
	
	tmp[0] = sw/100;
	tmp[1] = (sw%100)/10;	
	tmp[2] = sw%10;		
	if( tmp[0]!=0){
		ver_tmp[0] = tmp[0]+0x30;
		ver_tmp[1] = tmp[1]+0x30;
		ver_tmp[2] = tmp[2]+0x30;	
		len=3;
	}
	else{
		if( tmp[1]!=0){
			ver_tmp[0] = tmp[1]+0x30;
			ver_tmp[1] = tmp[2]+0x30;			
			len=2;
		}
		else{
			ver_tmp[0] = tmp[2]+0x30;
			len=1;
		}		
	}
	return len;
}

/*
* 显示基站固件版本号
*/
void lcd_display_ver(void)
{
	unsigned char tmp[12],len=0;
	
	len = calc_valid_disp_char(SW1,tmp);
	tmp[len] ='.';
	len +=1;
	
	len += calc_valid_disp_char(SW2,tmp+len);
	tmp[len] ='.';
	len +=1;	

	len += calc_valid_disp_char(SW3,tmp+len);
	tmp[len] =0x00;	
	
	platform.lcd_display_char(3*16,7,(unsigned char *)tmp);	//硬件版本	
}

/*
* 显示基站工作的无线频点
*/
void lcd_display_channel(void)
{
	unsigned char tmp[3],ch;	
//	len = calc_valid_disp_char(base_core.get_main_rf_chan(),tmp);
//	if(len ==1){ 
//		tmp[1]=' ';
//		len++;
//	}
	//add by Gavin20201221,刷新频点信息从两位切换到一位时 原来的第二位还保持的问题；
	ch = base_core.get_main_rf_chan();
	tmp[0] = (ch/10)%10 + 0x30;
	tmp[1] = ch%10 +0x30;	
	tmp[2] = 0x00;
	
	platform.lcd_display_char(3*16,10,(unsigned char *)tmp);	
}


/*
* 显示基站与SDK的连接状态
*/
void lcd_display_connect_status(unsigned char sta)
{
	if(sta)
		platform.lcd_display_chinese(5*16,4,CONNECT_STAT_LINK,sizeof(CONNECT_STAT_LINK)/sizeof(unsigned char));
	else
		platform.lcd_display_chinese(5*16,4,CONNECT_STAT_NOLINK,sizeof(CONNECT_STAT_NOLINK)/sizeof(unsigned char));
}




void lcd_display_same_freq_distrub(unsigned char enter_exit)
{
	#if 0
	if(enter_exit){
		platform.lcd_display_char(0,4, (unsigned char *)"      Warning         ");
		platform.lcd_display_char(0,6, (unsigned char *)"frequency interference");	
		platform.lcd_display_char(0,8, (unsigned char *)"                     ");		
		
	}
	else{
		platform.lcd_display_char(0,4, (unsigned char *)"                       ");
		platform.lcd_display_char(0,6, (unsigned char *)"                       ");	
		platform.lcd_display_char(0,8, (unsigned char *)"                       ");			
		
		platform.lcd_display_chinese(0,4,CONNECT_STAT,sizeof(CONNECT_STAT)/sizeof(unsigned char));
		platform.lcd_display_chinese(0,6,READER_STAT,sizeof(READER_STAT)/sizeof(unsigned char));	
		platform.lcd_display_chinese(0,8,ANSWER_STAT,sizeof(ANSWER_STAT)/sizeof(unsigned char));
		lcd_display_vote_stat();
		lcd_display_nfc_stat();
		lcd_display_sdk_stat();			
	}
	#endif	
}


/*
* 固定显示的菜单;
* called by sys init
*/
void lcd_display_menu(void)
{
	platform.lcd_display_char(0,0,(unsigned char *)"SunVote   RF200-T30B");
	platform.lcd_display_char(0,2,(unsigned char *)"____________________");	
	platform.lcd_display_chinese(0,4,CONNECT_STAT,sizeof(CONNECT_STAT)/sizeof(unsigned char));
	platform.lcd_display_chinese(0,7,VERSION,sizeof(VERSION)/sizeof(unsigned char));	
	platform.lcd_display_chinese(0,10,CHANNEL,sizeof(CHANNEL)/sizeof(unsigned char));
	
	//显示内容
	lcd_display_connect_status(0);
	lcd_display_ver();
	lcd_display_channel();
}


/*
* called by mainloop
*/
void T2_voice_base_dispaly_main_loop(void)
{
	static unsigned char sdk_connect_record=0;
	static unsigned char channel_record=0;
	//2020.12.03 调试改善姓名下发速度时发现，转发数据时开启NFC和LCD显示对姓名下发成功率影响很大；
	//简化LCD显示界面，按项目经理提供的新界面做;同时，转发时关闭显示和NFC
		function.nfc__scan();

		if( sdk_connect_record != base_core.get_sdk_connect_status() ){
			sdk_connect_record = base_core.get_sdk_connect_status();
			lcd_display_connect_status(sdk_connect_record);
		}

		if(base_core.get_main_rf_chan() != channel_record){
			channel_record =base_core.get_main_rf_chan();
			lcd_display_channel();
		}
}


#endif 



