//#include    "base_config.h"
//#include    "platform_extern.h"
//#include    "func_extern.h"
//#include    "core_extern.h"

#include    "base_config.h"
#include "gen_lgpkt_ch_intf.h"
#include "func_multipkt_up_intf.h"
#include "function_interface.h"
#include "platform.h"
#include "base_core_user.h"
#include "base_core.h"
#include "function.h"
#include "string.h"
#include <stdlib.h>
#include "HW_MCUIO.h"
#include    "my_headfile.h"
#include "base_pc_protocol.h"

//#include "SEGGER_RTT.h"
//#include "SEGGER_RTT_Conf.h"

#if  MD_MULTIPKT_UP

//------------------------------基站报告------------------------------------------
typedef struct {
  unsigned char sn[4];
  unsigned char pkt_type; //byte10
  unsigned char pkt_id;
  unsigned char data_len_total[4]; 
	unsigned char kp_data[1024];
  //---
  unsigned char status;
	//unsigned char index;
}base_pktup_ele_STR;
GEN_LINKLIST_DEF(base_pktup_linklist,base_pktup_ele_STR,4);  

#define		DBG_BASE_PKTUP							0


#define   BASE_PKTUP_RPT_DATA_LEN     32    //基站上报数据的长度

base_pktup_ele_STR *rpt_pele;
unsigned char current_sn[4];
volatile unsigned char rpt_ing_flag =0;
//unsigned char rpt_pkt_max;
unsigned char rpt_resp_timeout;
#define 		RPT_RESP_TIMEOUT		60	//N*20ms   //此次由10改为60，GD303 USBD库 USB传输不稳定时2023-02-03  测到超时引发基站重新申请，导致两次删除链表，错误的删除了并未申请过的键盘，导致漏键盘
//unsigned char cmp_str[] ="AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
//save data 
static unsigned char base_pktup__link_in(base_pktup_ele_STR *in_ele,unsigned short len)
{
    base_pktup_ele_STR *pele =NULL;
    unsigned char rtn=0;
    PLATFORM_DISABLE_IRQ();//platform.disable_interrupt();
		if( (pele= base_pktup_linklist__malloc_ele()) ==NULL){//no space to save
			//platform.enable_interrupt();
            rtn = 0;
		}
		else{		
			memcpy(pele,in_ele,len+10);//copy ele and save rear of linklist		
			rtn = base_pktup_linklist__insert(pele,base_pktup_linklist__get_len() );	//save at rear
			//platform.enable_interrupt();
                
		}
   PLATFORM_ENABLE_IRQ();     
   return rtn;
}



/*
* 发送申请 基站协议3.3.4 
*/
void base_pktup__request(void)
{
		if( rpt_ing_flag ){ //防止最后pktNO=0收不到，导致流程进行不下去的问题
			if( rpt_resp_timeout-- ==0){
				rpt_ing_flag = 0;
//				SEGGER_RTT_printf(0,RTT_CTRL_BG_WHITE RTT_CTRL_TEXT_RED "OUT TIME!!!\n");
//				SEGGER_RTT_printf(0,RTT_CTRL_BG_BLACK RTT_CTRL_TEXT_WHITE "\n");
			}
		}	
		
		if( (base_pktup_linklist__get_len() ==0) || rpt_ing_flag ) return;
		rpt_ing_flag =1;
		rpt_resp_timeout = RPT_RESP_TIMEOUT;
    rpt_pele = base_pktup_linklist__get_ele(0);
	
	memcpy(current_sn, rpt_pele->sn, 4);	
    unsigned char tmp[32];
    tmp[3] = 5; //type protocol byte 3
    tmp[4] = 1; 
    tmp[5] = rpt_pele->pkt_type; 
    tmp[6] = rpt_pele->pkt_id; 
    memcpy(tmp+7,rpt_pele->data_len_total,4);
    //memcpy(tmp+5,&rpt_pele->pkt_type,6);
    tmp[11] = BASE_PKTUP_RPT_DATA_LEN>>8; 
    tmp[12] = BASE_PKTUP_RPT_DATA_LEN & 0xff; 
    tmp[13] = base_core.get_id();//core__attr_intf.get_id();
    memcpy(tmp+14,rpt_pele->sn,SN_LEN);
//	SEGGER_RTT_printf(0,"PC_REQ_SN:%u_%u, LEN:%d\n",HBYTEL_COMB_INT(rpt_pele->sn), HBYTEL_COMB_INT(current_sn), base_pktup_linklist.length);
		#if MON_MULTPKT
		func__mon_multipkt_intf.req_pc(rpt_pele->sn);
		#endif	
    Core_PC_active_rpt(tmp+3,15);//core__pc_intf.active_rpt(tmp+3,15);
}

/*
基站协议5.5.3 ,报告数据
*/
void base_pktup__rpt_data(unsigned short pktNO)
{
  unsigned char tmp[64+4];
  memset(tmp,0,64);
  tmp[0]= BASE_PKTUP_RPT_DATA_LEN+17;
  tmp[1]= 0xe1;
  tmp[2]=  base_core.get_id();//core__attr_intf.get_id(); 
  tmp[3]= 23; //type;
  tmp[4] =2;
  tmp[5] = rpt_pele->pkt_type; 
  tmp[6] = rpt_pele->pkt_id; 
  tmp[7] = BASE_PKTUP_RPT_DATA_LEN>>8; 
  tmp[8] = BASE_PKTUP_RPT_DATA_LEN & 0xff; 
  tmp[9] = pktNO>>8; 	//byte9-10 pkt no 
  tmp[10] = pktNO;
//	unsigned short crc = crc16();	//byte11-12 crc 
//  tmp[11] = crc>>8; 
//  tmp[12] = crc & 0xff; 
  //byte 13-16 null
	if(pktNO > 0){
		memcpy(tmp+17,rpt_pele->kp_data + (pktNO-1)*BASE_PKTUP_RPT_DATA_LEN,BASE_PKTUP_RPT_DATA_LEN);
		rpt_resp_timeout = RPT_RESP_TIMEOUT;
		rpt_ing_flag =2;
	}
	else{
		//complete
    if(base_pktup_linklist__get_ele(0) != NULL)
	{	
//		SEGGER_RTT_printf(0,"PC_DEL_SN:%u_%u, LEN:%d\n",HBYTEL_COMB_INT(rpt_pele->sn), HBYTEL_COMB_INT(current_sn), base_pktup_linklist.length);
		if(current_sn[0] != rpt_pele->sn[0] || current_sn[1] != rpt_pele->sn[1] || current_sn[2] != rpt_pele->sn[2] || current_sn[3] != rpt_pele->sn[3])
		{
//			SEGGER_RTT_printf(0,RTT_CTRL_BG_WHITE RTT_CTRL_TEXT_RED "LOST_SN:%u",HBYTEL_COMB_INT(rpt_pele->sn));
//			SEGGER_RTT_printf(0,RTT_CTRL_BG_BLACK RTT_CTRL_TEXT_WHITE "\n");
		}
		else
		{
			base_pktup_linklist__detele(rpt_pele,0); 
		}
		//此处增加判断，防误删。GD303 USBD库 USB传输不稳定时2023-02-03  测到超时引发基站重新申请，导致两次删除链表，错误的删除了并未申请过的键盘，导致漏键盘
//		if(current_sn[0] == rpt_pele->sn[0] && current_sn[1] == rpt_pele->sn[1] && current_sn[2] == rpt_pele->sn[2] && current_sn[3] == rpt_pele->sn[3])
//		{
//			base_pktup_linklist__detele(rpt_pele,0); 
//		}
	}
		rpt_ing_flag =0;
	}
	
	unsigned short crc = crc16(tmp+17, BASE_PKTUP_RPT_DATA_LEN);	//byte11-12 crc 
  tmp[11] = (crc>>8); 
  tmp[12] = crc & 0xff; 
	#if MON_MULTPKT
	func__mon_multipkt_intf.rpt_pc(rpt_pele->sn);
	#endif	
	
	{	
	unsigned char tmp1[64];
	memset(tmp1,0,64);
	tmp1[0] =0xF5;	
	tmp1[1] =0xAA;
	tmp1[2] =0xAA;
	memcpy(tmp1+3,tmp,tmp[0]+1);		
    
//    if(strncmp(cmp_str,rpt_pele->kp_data,145)!=0)
//    {
//        SEGGER_RTT_printf(0,"ERR\n");
//    }
//   
//    
//    if(pktNO<5 && pktNO>0)
//    {
//        if(strncmp(cmp_str,tmp1+20,32)!=0)
//        {
//            SEGGER_RTT_printf(0,"ERR\n");
//        }
//    }
//    else if(pktNO == 5)
//    {
//        if(strncmp(cmp_str,tmp1+20,16)!=0)
//        {
//            SEGGER_RTT_printf(0,"ERR\n");
//        }
//    }
	platform.base_send_data_to_pc(tmp1,USB_REPORT_MAX);//platform__usb_intf.send_data(tmp1,USB_REPORT_MAX); //send to pc  core__pc_intf.ack_pc(0xe1,23,tmp,BASE_PKTUP_RPT_DATA_LEN+13 );
	}
}




//rx sdk get cmd
void base_pktup__rxpc(const unsigned char *rxpc)
{
  //rxpc[3] = 23 type
  if( rxpc[4] != 2)
      return;
  if(rxpc[5] != rpt_pele->pkt_type){ //byte5 pkt type
    return ;
  }  
  // rxpc[6] //byte6 pkt id 
  if( (rxpc[7]<<8) + rxpc[8] != BASE_PKTUP_RPT_DATA_LEN){ //byte7-8 data len
    return ;
  }

  base_pktup__rpt_data((rxpc[9]<<8) + rxpc[10]);//byte9-10 pkt no 
}

//debug only
void dbg__multpkt_up_linklist_ele(void)
{
	base_pktup_ele_STR *pele;
	for(unsigned char i=0;i<base_pktup_linklist__get_len();i++){
		pele = base_pktup_linklist__get_ele(i);
		platform.delay_ms(5);//platform__system_intf.delay_ms(5);
		platform.delay_ms(5);//platform__system_intf.delay_ms(5);
	}//for
}

unsigned char lose_sn[10][4];
unsigned char lose_cnt=0;



//----------------------------------------------------------------------------
/*
键盘协议4.6 透传多包上传
*/

#define   DBG_MULTI_UP    1


typedef struct {
  unsigned char sn[4];
  unsigned char tr_pos;
  unsigned char rf_sleep[2];
  unsigned char pkt_type; //byte10
  unsigned char pkt_id;
  unsigned char data_len_total[4]; 
  unsigned char data_len_per[2];//byte16-17
  unsigned char pkt_crc[2];
  //---
  unsigned char status;
	unsigned char index;
  unsigned short retry_cnt;
  #define   KP_RETRY_CNT   10
}multi_up_ele_STR;


GEN_LINKLIST_DEF(multipkt_up_linklist,multi_up_ele_STR,10);  //10-同时允许多少个键盘多包申请
//----------------------------------------------------
//multi_up_ele_STR  cur_req;	//当前处理的申请
multi_up_ele_STR  *p_req;//=&cur_req;

typedef struct{
  unsigned short pktNO_max;
  unsigned short pktNO_cur;

  unsigned char cur_node;   //当前处理的申请在链表中的位置
  unsigned char step;
  unsigned short wait_timeout;
  volatile unsigned char rx_ok_flag;
  unsigned short retry_times;
  #define   CALL_RETRY_CNT    100   //某个数据包重复尝试的次数
	
	unsigned char rx_kp_data[1024];
	
	unsigned short break_peroid;
	#define 	EXE_PEROID		40
}multipkt_up_call_STR;
multipkt_up_call_STR  up_call={
  .cur_node =0,
  .step =0,
  .rx_ok_flag =0,
};


static unsigned char multipkt_up__link_in(multi_up_ele_STR *in_ele)
{
    multi_up_ele_STR *pele =NULL;

		if( (pele= multipkt_up_linklist__malloc_ele()) ==NULL){//no space to save
			return 0;
		}
		else{	
            unsigned int temp=0;
			memcpy(pele,in_ele,17);
			pele->retry_cnt = in_ele->retry_cnt;
			temp=multipkt_up_linklist__insert(pele,multipkt_up_linklist__get_len() );	//save at rear
			return 1; 
		}
}


/*
* search special sn;return struct point
*/
static multi_up_ele_STR* multipkt_up__link_search(const unsigned char *sn,unsigned char tr_pos)
{
		multi_up_ele_STR *pele;	
		
		for(unsigned char i=0;i<multipkt_up_linklist__get_len();i++){
			if( (pele = multipkt_up_linklist__get_ele(i)) ==NULL) break;//continue;
			if(memcmp(pele->sn,sn,4) == 0){
				pele->index = i;
				return pele;			
			}						
		}//for	
		return NULL;	
}

//debug only
void dbg_multpkt_linklist_ele(void)
{
	multi_up_ele_STR *pele;
	for(unsigned char i=0;i<multipkt_up_linklist__get_len();i++){
		pele = multipkt_up_linklist__get_ele(i);
		platform.delay_ms(5);//platform__system_intf.delay_ms(5);
		platform.delay_ms(5);//platform__system_intf.delay_ms(5);
	}//for
	
	dbg__multpkt_up_linklist_ele();
	
	for(unsigned char i=0;i<lose_cnt;i++){;
	}
}
//------------------------------------- linklist end -------------------------------------------------------------



/*
* 接收键盘多包申请，保存到链表
return:0-空间不够，键盘不处理不给确认
1-基站正确的接收到多包申请
*/
unsigned char multipkt_up__rx_request(const unsigned char *rxkp)
{
  multi_up_ele_STR ele[1],*pele=ele;
  memcpy(pele,rxkp+3,17 );
  pele->retry_cnt =0 ;
	if( HBYTEL_COMB_INT(pele->data_len_total) ==0 ){
			return 0;
	}

  if( multipkt_up__link_search(pele->sn,pele->tr_pos) == NULL){ 
    if( multipkt_up__link_in(pele) != 0){		
			#if MON_MULTPKT
			func__mon_multipkt_intf.kp_req(pele->sn);
			#endif
//			SEGGER_RTT_printf(0,"_____RQ_SN:%u, len:%d\n",HBYTEL_COMB_INT(pele->sn), multipkt_up_linklist.length);
			return 1;
		}
    else{
//			SEGGER_RTT_printf(0,RTT_CTRL_BG_WHITE RTT_CTRL_TEXT_RED "_____RQ_LOST_SN:%u, len:%d\n",HBYTEL_COMB_INT(pele->sn), multipkt_up_linklist.length);
//			SEGGER_RTT_printf(0,RTT_CTRL_BG_BLACK RTT_CTRL_TEXT_WHITE "\n");
      return 0; //no space to save
		}
  }
  else{
    return 1; //重复了，不处理
  }
}


/*
*/
static void multipkt_up__call_sub(unsigned short pkt_no)
{
  unsigned char tmp[33];	
  memset(tmp,0,33);
  tmp[0] =32;	
  base_core.get_match_code(tmp+1);//core__attr_intf.get_matchcode(tmp+1);
  tmp[5] =0x28;	
  tmp[6] = HBYTEL_COMB_SHORT(p_req->rf_sleep)>>8;
  tmp[7] =HBYTEL_COMB_SHORT(p_req->rf_sleep) & 0xff;
  memcpy(tmp+8,p_req->sn,4);
  tmp[12] =p_req->tr_pos;
  tmp[13] =pkt_no>>8;
  tmp[14] =pkt_no&0xff;  
  tmp[15] =p_req->pkt_type;
  tmp[16] =p_req->pkt_id;
  tmp[17] = HBYTEL_COMB_SHORT(p_req->data_len_per)>>8;
  tmp[18] = HBYTEL_COMB_SHORT(p_req->data_len_per) & 0xff;
  platform.rf_send_data(tmp+1,tmp[0],get_main_rf_hard_id());//platform__rf_intf.write_buf(tmp+1,tmp[0],core__multi_intf.get_main_hardid() );	
}





void dbg_multpkt_up_print_rslt(const unsigned char*);
#define 	RX_WAIT_TIMEOUT			4 //
/*
*基站点名收取键盘
* return:1 -
*/
unsigned char multipkt_up__tx_call(void)
{

  switch(up_call.step){
    case 0:// ready for tx ;fet new request
      if( multipkt_up_linklist__get_len() && base_pktup_linklist__get_free_ele_cnt()  ){  // 有键盘申请，有数据存储空间
        if( (p_req = multipkt_up_linklist__get_ele(up_call.cur_node)) == NULL){
          if(++up_call.cur_node >= multipkt_up_linklist__get_len())
            up_call.cur_node =0;
					return 0;
				}					
        //计算总包数				
        up_call.pktNO_max  = HBYTEL_COMB_INT(p_req->data_len_total)/HBYTEL_COMB_SHORT(p_req->data_len_per)+\
				((HBYTEL_COMB_INT(p_req->data_len_total)%HBYTEL_COMB_SHORT(p_req->data_len_per) )?1:0);
        up_call.pktNO_cur =1;
        up_call.step =1; 
        up_call.retry_times =0;
      }
      else{
        return 0;
      }
			//break;
			
    case 1: // tx
			if(++up_call.break_peroid >= EXE_PEROID){
				up_call.break_peroid =0;
				up_call.step = 3;
				return 0;
			}			
      multipkt_up__call_sub(up_call.pktNO_cur);
      up_call.rx_ok_flag = 0;
      up_call.wait_timeout = RX_WAIT_TIMEOUT;
      up_call.retry_times++;  //记录发送次数
      up_call.step =2;
      break;
    
    case 2: //

      //---------start success process ----
      if(up_call.rx_ok_flag == 1){ //成功接收一个数据包
        if(++up_call.pktNO_cur  <= up_call.pktNO_max){//注意 pktNO_cur从1开始的，所有==
          up_call.step =1;
        }
        else{//所有包都收齐了，发送packNO=0给键盘，告知接收完成
					#if MON_MULTPKT
					func__mon_multipkt_intf.tx_kp(p_req->sn);
					#endif					
          up_call.pktNO_cur =0;
          up_call.step =1;
        }
        break;      
      }
      else if(up_call.rx_ok_flag == 2){ //end info rx ok ->packNO==0 //当前键盘的所有包都收完了，下一个键盘
        //for rpt 
        base_pktup_ele_STR ele[1], *pele=ele;
        memcpy(&pele->pkt_type,&p_req->pkt_type,6);
        memcpy(pele->sn,p_req->sn,SN_LEN);
				unsigned short data_len_total = up_call.pktNO_max*HBYTEL_COMB_SHORT(p_req->data_len_per);
				if( data_len_total >1024)
					data_len_total = 1024;
				memcpy(pele->kp_data,up_call.rx_kp_data,data_len_total );
        if( base_pktup__link_in(pele,data_len_total) == 0){
					if(lose_cnt < 10){//debug only
						memcpy(lose_sn[lose_cnt],pele->sn,SN_LEN);
						lose_cnt++;
					}
//					SEGGER_RTT_printf(0,RTT_CTRL_BG_WHITE RTT_CTRL_TEXT_RED "_____IN_LOST_SN:%u, len:%d\n",HBYTEL_COMB_INT(pele->sn), multipkt_up_linklist.length);
//					SEGGER_RTT_printf(0,RTT_CTRL_BG_BLACK RTT_CTRL_TEXT_WHITE "\n");
          return 0; //is error
        }
//		else
//		{
//			SEGGER_RTT_printf(0,"_____IN_SN:%u, LEN:%d\n",HBYTEL_COMB_INT(pele->sn), base_pktup_linklist.length);
//		}
		
        //this kp rx ok ,detele then start next keypad 
        if(multipkt_up_linklist__get_ele(up_call.cur_node) != NULL)
        {
            void *temp=0;
			temp=multipkt_up_linklist__detele(p_req,up_call.cur_node);
        }
				//dbg_linklist_ele();//debug only
        up_call.step = 0;
        break;
      }
      //---------success process end --start fail process ----

			if( --up_call.wait_timeout ==0){	//fail
        if( up_call.retry_times < CALL_RETRY_CNT){  //本次数据包重复次数还没到，继续尝试
          up_call.step =1;
        }
        else{
          if(++p_req->retry_cnt >= KP_RETRY_CNT){
			  if(multipkt_up_linklist__get_ele(up_call.cur_node) != NULL)
			  {
				  void *temp=0;
				temp=multipkt_up_linklist__detele(p_req,up_call.cur_node);
			  }
          }
          //start next keypad 
          if(++up_call.cur_node >= multipkt_up_linklist__get_len())
            up_call.cur_node =0;
			up_call.step = 0;          
        }
			}
      break;
		
		case 3:
			if( ++up_call.break_peroid >2){
				up_call.break_peroid =0;
				up_call.step = 1;
				return 0;
			}
			break;
		
    default:break;
  }//sw
	return 1;
}



//--------------------------------------rx data ----------------------------------
typedef struct{
  unsigned char pkt_cnt;
  unsigned char data_type; //byte9;
  unsigned char crc[2];
  unsigned char sn[4];
  unsigned char tr_pos; //byte16
  unsigned char pkt_NO[2];  
  unsigned char pkt_type;
  unsigned char pkt_id;  
  unsigned char data_len[2];  //byte21-22
  //--------------
	#define   RX_DATA_LEN_PER_PKT   32		//每次接收键盘数据的长度
	#define 	RX_PIECES_EVERY_TIME	8			//每次接收键盘的片数
	#define		RX_DATA_TOTAL					(RX_DATA_LEN_PER_PKT* RX_PIECES_EVERY_TIME)		
  unsigned char rx_buf[RX_DATA_TOTAL];
}multipkt_up_rx_STR;
multipkt_up_rx_STR up_rx;


static unsigned char analy_rx_data(void)
{
        unsigned short datalen = HBYTEL_COMB_SHORT(up_rx.data_len);
        if( crc16(up_rx.rx_buf,datalen) != HBYTEL_COMB_SHORT(up_rx.crc) ){//crc error 
          return 0;//
        }
        else{
          unsigned short rx_pkt_no = HBYTEL_COMB_SHORT(up_rx.pkt_NO) ;
          if(up_call.pktNO_cur != rx_pkt_no){; //是否需要判断????????????
          }

          if(rx_pkt_no ==0){//键盘对上传OK的应答
					#if MON_MULTPKT
					func__mon_multipkt_intf.kp_resp(up_rx.sn);
					#endif							
            return 2;//
          }
          else{
            //键盘数据在up_rx.rx_buf里
						memcpy( up_call.rx_kp_data + (up_call.pktNO_cur-1)*RX_DATA_TOTAL,up_rx.rx_buf,RX_DATA_TOTAL);
						
            return 1;//
          }
        }  
}

#define IS_KP_MULTI_UPLOAD(rxkp)  ((rxkp[4]==0x8F)&&(rxkp[5]==0xDE)&&(rxkp[6]==0x48)&&(rxkp[7]==0xFE) )
/*
*接收到键盘数据
*键盘收到基站的询问后，发送32字节头+N片32字节数据
* return:1-是多包数据，
*/
unsigned char multipkt_up__rx_data(const unsigned char *rxkp)
{
  static unsigned char head_flag=0, rx_piece_cur=0,rx_piece_max;
	if(conver_id(rxkp[0]) ==0xff) return 0;//if( core__multi_intf.hdid_2_sid(rxkp[0]) ==1) return 0;	//白名单模块的数据不处理
	const unsigned char *prxkp = rxkp+2;
	
	if(mem_compare(prxkp,base_mac.match_code,4)){//if(core__attr_intf.check_matchcode(prxkp) ){//packet head
    if( IS_KP_MULTI_UPLOAD(prxkp) ){ 
			rx_piece_max = ( prxkp[8] >RX_PIECES_EVERY_TIME)?RX_PIECES_EVERY_TIME:prxkp[8];//rxkp[8] -后续传输的包总数
      rx_piece_cur =0;
			head_flag =1;
      memcpy(&up_rx.pkt_cnt,prxkp+8,15);			
      return 1;
    }
    else
      return 0;
  }
  else{
			if(head_flag){
				//copy data
				memcpy(up_rx.rx_buf+rx_piece_cur*RX_DATA_LEN_PER_PKT,prxkp,RX_DATA_LEN_PER_PKT);
				if( ++rx_piece_cur >=  rx_piece_max){//收齐了 
					up_call.rx_ok_flag = analy_rx_data();
					head_flag =0;
				}
				return 1;
			}
  }
	return 0;
}


//debug only 打印基站接收到的键盘多包数据
void dbg_multpkt_up_print_rslt(const unsigned char *pdata)
{
			for(unsigned char i=0;i<up_call.pktNO_max;i++){
				for(unsigned char j=0;j<RX_PIECES_EVERY_TIME;j++){
					platform.delay_ms(5);//platform__system_intf.delay_ms(5);
				}
				platform.delay_ms(10);//platform__system_intf.delay_ms(10);
			}//for	
}













//-----------------------------
static void _init_all(void)
{
	multipkt_up_linklist__init();
	multipkt_up_linklist__init_ele();

  base_pktup_linklist__init();
  base_pktup_linklist__init_ele();
}



struct multipkt_up_intf_STR func__multipkt_up_intf={
	.init = _init_all,
  .rx_request = multipkt_up__rx_request,
  .tx_call = multipkt_up__tx_call,
  .rx_data = multipkt_up__rx_data,

	//
	.tx_rpt_request = base_pktup__request,
  .rx_pc =base_pktup__rxpc,
};

#endif






