
#include "function_interface.h"
#include "platform_interface.h"
#include "base_core_user.h"
#include "string.h"
#include "function.h"

//see BASE protocol 5.2.10 		
struct base_test_STR{
	unsigned char head_addr; 	//is struct head address,no actual utility 	
	unsigned char type;
	unsigned char chan;
	unsigned char Tmode;
	unsigned char rf_pwr;
	unsigned short send_cnt[2];	//发送次数
	unsigned char interval; //发送间隔 ms	
	#define 	BASE_TEST_LEN		7
};

struct base_test_STR base_test;




/*
包括了a,cc2500测试基站发送时的Rssi;b,24L01 tx only;c,normal base;
*/


static unsigned short cur_send_cnt,cur_recv_cnt;
unsigned char rx_rssi,rssi_request_flag;






/*
初始化基站测试相关固件
*/
void basetest_init(void)
{
	base_test.type=0;
	cur_send_cnt=0;
	cur_recv_cnt=0;
}

/*
获取基站测试状态
*/
unsigned char basetest_get_status(void)
{
		if(base_test.type) return 1;
		return 0;
}

unsigned char base_test_chan=1;
/*
接收并且加载ack pc 数据
*/
void basetest_rx_and_ack_pc(const unsigned char *rxpc,unsigned char *ack_buf)
//void basetest_load_info_ack_pc(unsigned char *rxpc,unsigned char *ack_buf)
{
		memcpy(&base_test.head_addr+1,rxpc+4,BASE_TEST_LEN);//mem_cpy(rxpc+4,&base_test.head_addr+1,BASE_TEST_LEN);
	
		ack_buf[0] =base_test.type;
		ack_buf[1] =base_test.chan;
		ack_buf[2] =base_test.rf_pwr;	
		ack_buf[3] =cur_send_cnt>>8;	//tx
		ack_buf[4] =cur_send_cnt;
		ack_buf[5] =cur_recv_cnt>>8;	//rx
		ack_buf[6] =cur_recv_cnt;
		ack_buf[7] =rx_rssi;					//rssi	
	
	
		#ifdef	FCCCE
		//---------------------------------------------
		void FCC_test_enter(unsigned char mode,unsigned char rf_id);	
		if( base_test.type !=3 ) return;
		if( (base_test.Tmode<1) ||(base_test.Tmode >4) )return;
//		if( (base_test.rf_pwr<1) ||(base_test.rf_pwr >4) )return;	
		base_test_chan =base_test.chan;
	
		if( base_test.rf_pwr ==0)
			platform.doule_ANT_sw(0);
		else
			platform.doule_ANT_sw(1);
		FCC_test_enter(base_test.Tmode,base_test.chan);
		#endif 
}


/*
基站测试处理
this function called by main loop 
*/
void basetest_progress(void)
{
	unsigned char i,tmp[40];
	unsigned char keypad_buf[64];
	
	switch(base_test.type){
		case 1:		//进入射频测试模式 ,只执行一次就退出;被测基站进入FCC3模式
			platform.rf_set_FCC_mode(base_test.Tmode);
			base_test.type =0xff;
			break;
		
		case 2://退出测试模式 
			basetest_init();
			break;
		
		case 3://基站进入测试发送模式
			if(++cur_send_cnt>= (base_test.send_cnt[0]<<8) +base_test.send_cnt[1] )break;
			tmp[0] =32;
			for(i=0;i<32;i++)	tmp[i] = i;
			base_core.send_rf_data(tmp,base_core.get_mainRF_hard_id());//base_tx_to_keypad_sub(tmp,base_core.get_main_rf_id());
			platform.delay_ms(base_test.interval);
			break;
		
		case 4://基站进入测试接收模式
			cur_recv_cnt=0;
			break;		
		case 5:
			//此处检测接收键盘数据，需要关闭正常的处理键盘数据函数！！
//			if( !fifo_output(&keypad_data,keypad_buf+1,&keypad_buf[0]) )return; //buf中没有有效数据  !!!!!!!!!!?????????????
			if(keypad_buf[0]!=32)	return;
			if(keypad_buf[1]!=0)	return;	
			if(keypad_buf[2]!=1)	return;	
			if(keypad_buf[3]!=2)	return;	
			cur_recv_cnt++;	
			break;
		
		case 6://基站进入检测RSSI模式
			rx_rssi=0;
			break;
		
		case 7:
			if( !rssi_request_flag) break;
			rx_rssi = platform.rf_get_rssi();
			break;
		
		default:break;				
	}//sw
}



#ifdef CCxxxx	//cc2500 频率转换
/*
cc2500用于基站测试的作用是 检测基站的RSSI
cc2500的频点范围 2403-2482;1M的 步进	而且1-40频点和41-80频点间隔的 1-2404;2-2406; 41-2403;42-2405M;
24L01的频率范围是2401-2480，步进1M; 频点与频率对应；1-2401；2-2402； 79-2479M	
为了解决cc2500和24L01对应关系,特添加次转换函数
	*/
unsigned char basetest_cc2500_freq_conver(unsigned char freq)
{
	//只有在测试模式下才做频点转换，否则会导致频点错乱而无法和键盘通信；
	if(!base_test.type) return freq;
	
	if(freq<3) freq=3;
	if(freq>80) freq=80;
	if(freq%2) 
		freq=((freq-3)>>1)+41;
	else 
		freq =((freq-4)>>1)+1;
	
	return freq;
}
#endif //#ifdef CCxxxx




