/*
此文档用于 a 初始化投票数据队列；
b,上报投票数据给PC
*/
#include "base_pc_protocol.h"
#include "platform_interface.h"
#include "function_interface.h"
#include "base_core.h"
#include "base_core_user.h"


struct RPT_PKT_STR{
	volatile unsigned char pkt_seq;//1,2,3,...10;
	volatile unsigned char buf_no_empty_flag;//投票buf中有数据	
	volatile unsigned char flag; //发送标志位	
	volatile unsigned char interval_timer;
};
static struct RPT_PKT_STR rpt_vote;


/*
启动发送投票数据给pc
called by : 	pc发送询问投票数据时被调用
*/
void vote_data_report_startup(void)
{
	vote_status_reset_NOconfirmed();
	rpt_vote.buf_no_empty_flag =1;
	rpt_vote.flag=1;
	rpt_vote.pkt_seq=0;	
	rpt_vote.interval_timer =0;
}

/*
如果还有数据，开启定时器
called by 2.5ms 
*/
//void vote_data_report_interval(unsigned char interval)
//{
//		//没有数据要上报，就不需要计时
//		if(!rpt_vote.buf_no_empty_flag) return;
//		if(++rpt_vote.interval_timer <interval)	return;		
//		rpt_vote.interval_timer=0;
//		rpt_vote.flag=1;		//定时时间到，开启上报
//}
void vote_data_report_interval(void)
{
		//没有数据要上报，就不需要计时
		//if(!rpt_vote.buf_no_empty_flag) return;
		if(++rpt_vote.interval_timer <2)	return;		
		rpt_vote.interval_timer=0;
		rpt_vote.flag=1;		//定时时间到，开启上报
	
		#ifndef 	MAINLOOP_PROCESS_VOTE
		vote_data_report_to_pc();
		#endif
}

/*
将来自键盘的投票数据 打包发送给pc
如果需要多次(最多10次)发送，每次之间的间隔(每包之间的间隔)是25ms;
//触发：pc询问数据时启动
called by :main loop

rpt_vote.flag控制上报的频率
rpt_vote.buf_no_empty_flag,表示buf中是否还有数据
rpt_vote.pkt_seq,表示最大上报10pkt
*/
void vote_data_report_to_pc(void)
{
	#ifdef 	RF_5G8
	if( (rpt_vote.buf_no_empty_flag)&&(rpt_vote.pkt_seq<10)&&(rpt_vote.flag)){ //
	#else
	if( (rpt_vote.buf_no_empty_flag)&&(rpt_vote.pkt_seq<10)&&(rpt_vote.flag)){ //
	#endif
		
		rpt_vote.pkt_seq++;	//包序号加1
		rpt_vote.buf_no_empty_flag = vote_data_packing(rpt_vote.pkt_seq);//packet seq from 1,2,3...10
		rpt_vote.flag=0;		//clear flag,after 25ms，flag set!!				
	}
}


/*
初始化上报投票数据 相关参数
called by main init */
void vote_data_parameter_init(void)
{
	vote_init_queue();
	rpt_vote.buf_no_empty_flag =0;
	rpt_vote.flag=0;
	rpt_vote.pkt_seq=0;
	rpt_vote.interval_timer =0;	
}



//---------------------------------------------------- 打包规则 ---------------------------------------------------------------------------------
/*
根据数据类型type，得出打包需要的参数：1包数据包含几个投票数据
*/
unsigned char get_packing_parameter(unsigned char *type,unsigned char *cnt,unsigned char *len)
{
			unsigned char _1pkt_keypad_cnt,type_len=6; 
			unsigned char rpt_len =31;
			switch(*type){
				
				case 1:	//single vaule 
					if( (vote_beacon.sys_mode&0x7F)==5 ){//20200111 modify by Gavin
						_1pkt_keypad_cnt=4;
						*type=7;	//modify type!!!
					}
					else{					
						_1pkt_keypad_cnt=8;
						type_len=3;
					}						
					break;

				case 2://单选带计时
					_1pkt_keypad_cnt=4;
					//type_len=6;
					break;
				
				case 3://评分
					_1pkt_keypad_cnt=2;
					type_len=12;	
					break;					
				
				case 4://批次结果
					_1pkt_keypad_cnt=1;
					type_len=23;	
					break;

				case 5://排序
					_1pkt_keypad_cnt=2;
					type_len=9;	
					break;
				
				case 6://填空， id+SN扫描时会执行
					_1pkt_keypad_cnt=1;
					type_len=21;	
					break;					
				
				case 10:// A状态信息， 测试键盘
					_1pkt_keypad_cnt=4;
					//type_len=6;	
					break;					
				
				case 11:// B状态信息
					_1pkt_keypad_cnt=1;
					type_len=22;	
					break;						
				
				case 12:// C申请类
					_1pkt_keypad_cnt=4;
					//type_len=6;	
					break;						
				
				case 13:// D 扩展信息
					_1pkt_keypad_cnt=2;
					type_len=11;
					//tmp[6]=1; //crs??
					//rpt_offset=7;//???					
					break;

				case 20:						
					_1pkt_keypad_cnt=3;
					type_len=16;
					rpt_len =60;	//big packet			
					break;
													
				case 21:
					_1pkt_keypad_cnt=3;
					type_len=16;
					rpt_len =60;//58	//big packet
					break;
				
				case 22:						
					_1pkt_keypad_cnt=1;
					type_len=27;
					rpt_len =60;//58 	//big packet
					break;
				
				case 27: //t1lite新增 3.2.6
				case 28: //3.2.7
					_1pkt_keypad_cnt=2;
					type_len=26;
					rpt_len =60;//58					
					break;								
				
				default:
					_1pkt_keypad_cnt=1;
					type_len=22;					
					break;
			}//switch	//输出的是type及其len，looptimes	

			*cnt =_1pkt_keypad_cnt;
			//*len =type_len+1; ///include type,so 7bytes 20200111 modify by Gavin
			*len =type_len; 
			return rpt_len;
}



