
/*
此文档用来处理pc转发给键盘的数据和
	键盘转发给pc的数据 	
*/
#include "base_pc_protocol.h"
#include "platform.h"
#include "function_interface.h"
#include "base_core.h"
#include "base_core_user.h"


//--------------------keypad transfer to pc dircet ------------------------------------------
/*
开辟一个用于键盘转发给基站的缓冲区！！*/
#define 	TRANS2PC_NODE_SIZE		10//5		//节点个数，即缓冲区长度
#define 	TRANS2PC_DATA_SIZE  	64		//数据的最大长度
struct 	fifo_queue_STR	trans2pc_queue;
unsigned char trans2pc_buf[TRANS2PC_NODE_SIZE][TRANS2PC_DATA_SIZE];

void transfer2pc_init_queue(void)
{
	queue_init(&trans2pc_queue,(unsigned char **)trans2pc_buf,TRANS2PC_NODE_SIZE,TRANS2PC_DATA_SIZE);
}

/*
基站保存 keypad直接给 pc 的数据
called by 基站处理接收键盘rf数据的函数 */
//unsigned char keypad_transfer2pc_data_save(const unsigned char *trans2kp)
//{	
//	return queue_in(&trans2pc_queue,trans2kp,TRANS2PC_NODE_SIZE,TRANS2PC_DATA_SIZE);
//}
void keypad_transfer2pc_data_save(const unsigned char *trans2kp)
{	
	queue_in(&trans2pc_queue,trans2kp,TRANS2PC_NODE_SIZE,TRANS2PC_DATA_SIZE);
}
/*
基站转发 keypad直接给 pc的数据
如此转发是否会和正常数据冲突 ？？？ 如何避免
called by main loop , */
unsigned char keypad_transfer2pc_data_fetch(void)
{
	unsigned char transfer2pc_buf[64+4];
	//coye data
//	if( !queue_out(&trans2pc_queue,transfer2pc_buf,TRANS2PC_NODE_SIZE,TRANS2PC_DATA_SIZE)) return 0;
	unsigned char ret_val;
	PLATFORM_DISABLE_IRQ();//platform.disable_interrupt();
	ret_val =queue_out(&trans2pc_queue,transfer2pc_buf,TRANS2PC_NODE_SIZE,TRANS2PC_DATA_SIZE);
	PLATFORM_ENABLE_IRQ();//platform.enable_interrupt();	
	if( !ret_val) return 0;
	
	transfer2pc_buf[0] +=2;	//len,为什么不是直接转发键盘的原始数据？
	
	base_tx_to_pc_sub(transfer2pc_buf);
//operation_debug_io(5);//test only	
	return 1;
}
	



//--------------------pc transfer to  keypad dircet ------------------------------------------
#define 	TRANS2KP_NODE_SIZE		10//5		//节点个数，即缓冲区长度
#define 	TRANS2KP_DATA_SIZE  	64	//数据的最大长度
struct 	fifo_queue_STR	trans2kp_queue;
unsigned char trans2kp_buf[TRANS2KP_NODE_SIZE][TRANS2KP_DATA_SIZE];
/*
*/
void transfer2kp_init_queue(void)
{
	queue_init(&trans2kp_queue,(unsigned char**)trans2kp_buf,TRANS2KP_NODE_SIZE,TRANS2KP_DATA_SIZE);	
}

/*
基站保存pc直接转发给键盘的数据 
called by 基站处理pc数据的函数 */
unsigned char pc_transfer2keypad_data_save(unsigned char *trans2keypad)
{	
//	return queue_in(&trans2kp_queue,trans2keypad,TRANS2KP_NODE_SIZE,TRANS2KP_DATA_SIZE);	
	unsigned char ret_val;
	PLATFORM_DISABLE_IRQ();//platform.disable_interrupt();
	ret_val =queue_in(&trans2kp_queue,trans2keypad,TRANS2KP_NODE_SIZE,TRANS2KP_DATA_SIZE);
	PLATFORM_ENABLE_IRQ();//platform.enable_interrupt();
	return ret_val;	
}


/*
基站发送 pc直接给 keypad 的数据
called by 信标发送函数 base_tx_keypad_beacon()
return :
	0- 没有要转发的数据或者 连续转发时间到
	1- 还有数据或者转发等待，		*/
unsigned char pc_transfer2keypad_data_fetch(void)
{
	unsigned char trans2kp_buf[64+5],j;
	//coye data
	if( !queue_out(&trans2kp_queue,trans2kp_buf+4,TRANS2KP_NODE_SIZE,TRANS2KP_DATA_SIZE)) return 0;	
	
	//来自pc的转发数据是没有配对码的，加上之后再发给键盘
	trans2kp_buf[0] =trans2kp_buf[4]+4;	
	get_base_match_code(trans2kp_buf+1);

	#ifndef RF_5G8
	
	if( get_ext_basicbeacon_startup_flag() ){//容量均衡模式下，每个模块都和主模块一样发送信标
		for(j=0;j<multi.count;j++){
			base_tx_to_keypad_sub(trans2kp_buf,j);//base_tx_to_keypad_sub(trans2kp_buf,multi.modual_id[j]);//20200527
		}
	}
	else{		
		//转发数据通过主频点发出！！
//		if((function.match_keypad_type ==KP_VOXM)&&(function.crc16_keypad__SW) ){
		if((function.base_type == TYPE_CRS200_433)&&(function.crc16_keypad__SW) ){	
			unsigned short crc_tmp;
			crc_tmp = crc16(trans2kp_buf+5,26);
			trans2kp_buf[31]=crc_tmp>>8;
			trans2kp_buf[32]=crc_tmp&0xff;
			trans2kp_buf[0]=32;			
		}
		base_tx_to_keypad_sub(trans2kp_buf,get_mainRF_usr_id());
	}
	#else
	platform.rf_5G8_load_send_data(trans2kp_buf+1,64,multi.modual_id[get_mainRF_usr_id()]);	
	platform.rf_5G8_load_send_data(trans2kp_buf+1,64,multi.modual_id[get_mainRF_usr_id()]);	

	spec_trans__record_sn(trans2kp_buf);
	#endif
	
	return 1;
}



