//#include	"core_extern.h"
//#include	"base_pc_protocol.h"
//#include "platform_extern.h"
//#include "func_extern.h"
#include "base_core.h"
#include "string.h"
#include "stop_beacon_intf.h"

#if MD_SPECIAL_STOP_PRO

#define 	RSP_LEN		2
#define 	LANG_LEN	1
unsigned char rsp_para[RSP_LEN],lang[LANG_LEN];

//
void stop_beacon__rxpc(const unsigned char *rxpc)
{
    //rxpc[3] = 11 
		//rxpc[4] = 30 31 32 33
		unsigned char ack_buf[8];
    switch(rxpc[4]){
        case 31:
					memcpy( rsp_para,rxpc+5,RSP_LEN);
					base_write_e2prom(STORE_BASE_STOP_BEACON,rsp_para,RSP_LEN);//func__store_intf.write_with_flag(STORE_BASE_STOP_BEACON,rsp_para,RSP_LEN);
		case 30:			
//					my_debug.print_buf(1,"stop beacon data rsp:",rsp_para,RSP_LEN);
					ack_buf[0] =rxpc[4];
					memcpy(ack_buf+1,rsp_para,RSP_LEN);
					pc_cmd_0x61_ack(11,ack_buf,RSP_LEN+1);//core__pc_intf.ack_pc(0xe1,11,ack_buf,RSP_LEN+1);
					break;

        case 33:
					memcpy( lang,rxpc+5,LANG_LEN);
					base_write_e2prom(STORE_BASE_STOP_BEACON2,lang,LANG_LEN);//func__store_intf.write_with_flag(STORE_BASE_STOP_BEACON2,lang,LANG_LEN);
		case 32:			
//					my_debug.print_buf(1,"stop beacon data lang:",lang,LANG_LEN);
					ack_buf[0] =rxpc[4];
					memcpy(ack_buf+1,lang,LANG_LEN);
					pc_cmd_0x61_ack(11,ack_buf,LANG_LEN+1);//core__pc_intf.ack_pc(0xe1,11,ack_buf,LANG_LEN+1);
					break;
							
        default:break;
    }	//sw   
}


void stop_beacon__cover(unsigned char *tmp)
{
	memcpy(tmp,rsp_para,RSP_LEN);	//byte 10
	memcpy(tmp+2,lang,LANG_LEN);		//byte 14
}



void stop_beacon__powerup(void)
{
	unsigned char tmp[2+1];
	if( base_read_e2prom(STORE_BASE_STOP_BEACON,tmp,RSP_LEN) ){//if( func__store_intf.read_with_flag(STORE_BASE_STOP_BEACON,tmp,RSP_LEN) ){
		memcpy( rsp_para,tmp,RSP_LEN);			
	}	
	
	if( base_read_e2prom(STORE_BASE_STOP_BEACON2,tmp,LANG_LEN) ){//if( func__store_intf.read_with_flag(STORE_BASE_STOP_BEACON2,tmp,LANG_LEN) ){
		memcpy( lang,tmp,LANG_LEN);			
	}
	
}



struct stop_beacon_intf_STR core__stop_beacon_intf={
    .rxpc = stop_beacon__rxpc,
    .cover = stop_beacon__cover,
    .pwrup = stop_beacon__powerup,
};


#endif


