

#include "base_core.h"
#include "base_core_user.h"
#include "platform_interface.h"
#include "base_pc_protocol.h"
#include "function_interface.h"



//#ifdef 	RF_5G8
#if defined(RF_5G8) || defined(_DBG_SN_KP)

struct link_node_STR	node_array[KEYPAD_COUNT_MAX+1];//[0]作为指针头，不保存实际数据



//---------------------- Element --------------------------------
static void element_init(ELEMENT *node_ele)
{
	mem_set(node_ele->id_sn,4,0);	
	node_ele->offline_count=0;
	node_ele->re_send_slot=0xff;
	
	#ifdef _DBG_VOICE_KP
	node_ele->re_send_timers=0x00;
	#endif
}

static void element_cpy(ELEMENT *ele,ELEMENT *node_ele)
{
	//mem_cpy(ele->id_sn,node_ele->id_sn,sizeof(ELEMENT)/sizeof(node_ele));
	mem_cpy(ele->id_sn,node_ele->id_sn,4);
	node_ele->offline_count=ele->offline_count;
	node_ele->re_send_slot=ele->re_send_slot;
	
	#ifdef _DBG_VOICE_KP
	node_ele->re_send_timers=ele->re_send_timers;
	#endif
}



/*--------------------- Node------------------------
开辟node，实际是在数组中搜索空闲node;*/
static struct link_node_STR *mallco_node(void)
{
	/*为了每次在数组中快速找到空闲node，定义一个标准位，
	交替从数组头和为搜索*/
	static unsigned char flag=1;
	unsigned char i;

	flag^=1;	
	if( flag==0){
		for(i=1;i<KEYPAD_COUNT_MAX+1;i++){	
			if(node_array[i].status!=0) continue;
			return &node_array[i];//break; //找到了，就返回
		}//for
	}
	else{
		for(i=KEYPAD_COUNT_MAX;i>0;i--){	
			if(node_array[i].status!=0) continue;
			return &node_array[i];//break; //找到了，就返回
		}//for		
	}	
			
	return NULL;
}



//------------------------------------------------------- Queue -------------------------------------
//初始化队列
void  link_queue_init(struct link_queue_STR *queue)
{
	unsigned char i;
	//init node[], independent 
	for(i=0;i<KEYPAD_COUNT_MAX+1;i++){
		node_array[i].status =0; //空闲
		node_array[i].next=NULL;
		element_init(&node_array[i].element);
	}
	//
	node_array[0].status =1;	
	queue->front =&node_array[0];
	queue->rear =&node_array[0];
	queue->rear->next =NULL;	
}

/*入队列, 后来的数据放在队列的 尾部*/
unsigned char link_queue_input(struct link_queue_STR *queue,ELEMENT *ele)
{
	struct link_node_STR *new_node=NULL;

	if( (new_node =mallco_node()) ==NULL ) return 0;
	new_node->next =NULL;
	new_node->status=1;
	element_cpy(ele,&new_node->element);	//保存element数据
	
	queue->rear->next = new_node;
	queue->rear =new_node;
	
	return 1;
}




/*
在队列中查找是否存在指定的SN
return: 如果查找成功 Node的位置
否则 返回NULL*/
struct link_node_STR *link_queue_find_special_sn(struct link_queue_STR *queue,const unsigned char *sn)	
{
	struct link_node_STR *p =queue->front;
	
	while(p->next!= NULL){
		if( mem_compare(sn,p->next->element.id_sn,4) )//找到了
			return (p->next);
		p =p->next;		
	}//while

	return NULL;
}



/*
遍历整个队列，返回整个队列元素个数!!!--即键盘个数  */
unsigned char get_link_queue_length(struct link_queue_STR *queue)
{
	unsigned char length=0;
	struct link_node_STR *p =queue->front;
	
	while(p->next!=NULL){
		length++;
		p =p->next;
	}//while	
	
	return length;
}






#if 0
//------------------------------------------------------------------------------------------------
/*
*
*
*/
unsigned char traverse_link_queue(void (*traverse_operation)(unsigned char *),unsigned char *out,unsigned char offset)
{
	struct link_node_STR *p =keypad_info.front;
	unsigned char i,ret_val=0;
	
	for(i=0;i<offset;i++)
		p = p->next;		
		
	while(p->next!= NULL){
		
		//traverse_operation();
		
		p =p->next;		
	}//while
	
	return ret_val;
}


///*
//1, 获取各个元素数据;
//2, 获取需要重传的元素数据
//3, 是否需要重传
//4,监测离线在线
//5,获取在线个数
//6,获取在线SN表单
//*/
//static unsigned char op_check_re_send(struct link_node_STR *p)
//{
//		//if( p->next->element.re_send_slot !=0)
//			
//		
//}
#endif 


#endif




