/*
*5.3.5 用于传输长包的数据通道
*/
//#include "platform_extern.h"
//#include "core_extern.h"
//#include "func_extern.h"

#include "gen_lgpkt_ch_intf.h"
#include "ext_beacon_intf.h"
#include "func_down_beacon_intf.h"
#include "base_pc_protocol.h"
#include "platform_interface.h"
#include "function_interface.h"
#include "base_core.h"
#include "base_core_user.h"
#include "string.h"
#include    "gen_queue.h"

#ifdef _DEBUG_CORE_
    #include "SEGGER_RTT.h"
    #include "SEGGER_RTT_Conf.h"
#endif

#if MD_GEN_LGPKT_CH	

//#define     LGPKT_DATA_LEN       1024  
//GEN_CIRCLE_QUEUE_DEF(lgpkt_fifo,3,LGPKT_DATA_LEN);   

//unsigned char lgpkt_data_fetch(unsigned char *out)
//{
//	if( lgpkt_fifo__get_length()){
//		if( lgpkt_fifo__out(out) <0 )
//			return 0;
//		else
//			return 1;
//	}
//	else 
//		return 0;
//}

struct gen_lgpkt_STR{
    #define     BUF_LEN_MAX    			1024 	//最大数据总数
    unsigned char buf[BUF_LEN_MAX];
    #define     PKT_DATA_LEN         51		//每包的有效数据长度
};

struct gen_lgpkt_STR gen_lgpkt;




//-------------------------------------
static void pc_cmd_0x61_ack_lgpkt(const unsigned char *ack_buf,unsigned short len)
{
		unsigned char tmp[64]; 
	
		memset(tmp,0,64);
		tmp[0] =0xF5;	
		tmp[1] =0xAA;
		tmp[2] =0xAA;	
		tmp[3]= len+8;	//len
		tmp[4]= 0xE1;
		tmp[5]= base_core.get_id();//core__attr_intf.get_id();
		tmp[6]= 19;
		
		memcpy( tmp+7,ack_buf,len);
		
		#if (MD_LIST_MGNT_CRC)
		unsigned short crc = crc16(tmp+11,CRC_LEN);
		tmp[9]= crc>>8;			//crc
		tmp[10]= crc;			
		#endif
		
		//send to pc 
		platform.base_send_data_to_pc(tmp,USB_REPORT_MAX);//base_core.send_data_to_pc(tmp);//platform__usb_intf.send_data(tmp,USB_REPORT_MAX); 
}



static void gen_lgpkt__rx(const unsigned char *rxpc)
{
		//rxpc[3] = 19
		unsigned char pkt_max,pkt_cur;
		pkt_max = rxpc[4];
		pkt_cur = rxpc[5];	
		if(pkt_cur > pkt_max) return;
        if( (pkt_cur<1)||(pkt_cur>20) ) return;
		if( pkt_cur==1)	
            memset(gen_lgpkt.buf,0,BUF_LEN_MAX);
		memcpy(gen_lgpkt.buf + (pkt_cur-1)*PKT_DATA_LEN,rxpc+8,PKT_DATA_LEN);	
		
		#if (MD_LIST_MGNT)
		if( (rxpc[8] == 18)&&(rxpc[9] == 1)	){//if( (lgpkt_buf[0] == 18)&&(lgpkt_buf[1] == 1)	){		
			func__list_mgnt_intf.pc_rx_read(rxpc);
			return;
		}			
		#endif 

		//ack pc 
		unsigned char ack_buf[16];
		ack_buf[0] =rxpc[4]; 	//pkt_max	
		ack_buf[1] =rxpc[5]; 	//pkt_cur			
		ack_buf[2] =rxpc[6]; 	//crc	
		ack_buf[3] =rxpc[7]; 	//crc			
		
//		my_debug.print_buf(1,"lgpkt data:",rxpc,32);
		
		if(pkt_cur == pkt_max){
			switch(gen_lgpkt.buf[0]){
					#if (MD_DOWN_BEACON)//5.6.4
					case 1: 
						func__down_beacon_intf.pc_rx(gen_lgpkt.buf);//lgpkt_fifo__in(gen_lgpkt.buf);
						break;
					#endif

					#if (MD_LIST_MGNT)
					case 18:
							break;
					#endif

					#if (MD_EXT_BEACON)
					case 3:
							core__ext_beacon_intf.rxpc(gen_lgpkt.buf);
							break;
					#endif

					default:break;
			}//sw						
		}		
        
        pc_cmd_0x61_ack_lgpkt(ack_buf,4);	//ack		
}



struct gen_lgpkt_intf_STR core__gen_lgpkt_intf={
    .rx_pc = gen_lgpkt__rx,
//    .fetch_data = lgpkt_data_fetch,
};

#endif
