
#include "base_pc_protocol.h"
#include "platform_interface.h"
#include "function_interface.h"
#include "function.h"
#include "base_core.h"
#include "base_core_user.h"
#include "stop_beacon_intf.h"
#include "string.h"



unsigned char base_write_e2prom( unsigned short addr, const unsigned char * ptr,unsigned char len)
{
		unsigned char tmp[0xff];
		
		tmp[0] = STORE_FLAG;
		mem_cpy(ptr,tmp+1,len);
		platform.e2prom_write(addr,tmp,len+1);
				
		return 1;
}

unsigned char base_read_e2prom( unsigned short addr, unsigned char * ptr,unsigned char len)
{		
	unsigned char tmp[0xff];	
	platform.e2prom_read(addr,tmp,len+1);
		
	if(tmp[0] == STORE_FLAG){
		mem_cpy(tmp+1,ptr,len);
		return 1;
	}
	else
		return 0;
}



//------------------------------------------------------------------------
const unsigned char OEM_CODE[] = {"@SUNVOTE"}; //默认厂家

unsigned short calc_custom_rf_sync_code(const unsigned char*input)
{
			unsigned char i;
			unsigned char sum0,sum1;	
			
			sum0=0;
			sum1=0;					
			for(i=0;i<4;i++){
				sum0 +=input[0+i];	//很可能会溢出,how to do
				sum1 +=input[4+i];	//很可能会溢出,how to do
			}
			sum0 ^=0xA5;
			sum1 ^=0xA5;
#if	(SUPPORT_HS6621_SOC)
			if(sum0 == 0xBF && sum1 == 0x79)//20230320 测到网易HABOOK!!同步码接近全1数据如BF、EE、FF等数据时键盘与基站通讯存在问题，提交不上答题，或升级容易卡顿,改成更正常的0x55
			{
				sum0 = 0x55;
			}
#endif
			return( (sum1<<8) +sum0 );
}
/*
读取基站初始化参数，E2prom
called by 上电初始化
*/
void base_read_e2prom_parameter(void)
{		
		unsigned char tmp[0xff];
			
		//----1 read base name and log mode
		if(base_read_e2prom(STORE_BASE_NAME_ADDR,tmp,AUX_NAME_LEN) ){
			mem_cpy(tmp,&base_name_log_mode.head_addr+1,AUX_NAME_LEN);
            mem_cpy(tmp,&base_name_setup.head_addr+1,AUX_NAME_LEN);
            function.network__set_name(base_name_setup.base_name, 12);
			//here,you can add assert log mode,
		}
		else{
			base_name_log_mode.log_mode=1;
			mem_set(base_name_log_mode.base_name,12,0);
            function.network__set_name(base_name_setup.base_name, 12);
		}
		assert_base_log_mode();
        
		if(base_read_e2prom(STORE_BASE_PWD_ADDR,tmp,AUX_PWD_LEN) ){
            mem_cpy(tmp,&base_pwd_setup.head_addr+1,AUX_PWD_LEN);
            function.network__set_pwd(base_pwd_setup.base_pwd[0]*256+base_pwd_setup.base_pwd[1]);
			//here,you can add assert log mode,
		}
        else{
            function.network__set_pwd(1024);//默认基站登录密码1024
			base_pwd_setup.base_pwd[0]=0x04;
			base_pwd_setup.base_pwd[1]=0x00;
        }
        
		//----2,read base config 
		if( base_read_e2prom(STORE_BASE_CONFIG_ADDR,tmp,BASE_CONFIG_LEN) ){
			mem_cpy(tmp,&base_config.head_addr+1,BASE_CONFIG_LEN);			
		}
		else{	
			unsigned short tmp16;
			base_config.bs_id=1;
			base_config.chan=1;			
			
			_2BYTE_TO_16BIT(base_config.keymin,tmp16);
			tmp16=1;
			_16BIT_TO_2BYTE(tmp16,base_config.keymin);

			_2BYTE_TO_16BIT(base_config.keymax,tmp16);
			tmp16=256;
			_16BIT_TO_2BYTE(tmp16,base_config.keymax);								
		}

		assert_base_id();//assert base id 		
		assert_base_channel(); //assert base channal, then set it to RF module;
		//特别注意，此处没有设置频点 ！！！！！等待后面的多模块参数，因为内核设置频点是用模块参数multi的

				
		//3 ---- read base hard info 
		if( base_read_e2prom(STORE_BASE_HDINFO_ADDR,tmp,BASE_HDINFO_LEN) ){
			mem_cpy(tmp,&base_hdinfo.head_addr+1,BASE_HDINFO_LEN);							
		}
		else{
			mem_set(base_hdinfo.SERIAL,6,0xff);
		}
		set_base_hard_firmware_info();//function.version_info(); //固定的硬件版本信息
				
		//4,----read base match code 
		if( base_read_e2prom(STORE_BASE_MAC_ADDR,tmp,BASE_MAC_LEN) ){
			mem_cpy(tmp,&base_mac.head_addr+1,BASE_MAC_LEN);							
		}
		else{
			mem_set(&base_mac.head_addr+1,BASE_MAC_LEN,0xff);//test only
		}

		//5, ----read basic beacon 
		if( base_read_e2prom(STORE_BASIC_BEACON_ADDR,tmp,6) ){
			mem_cpy(tmp,&basic_beacon.head_addr+1,6);							
		}
		else{
			basic_beacon.auth_code[0]=0;
			basic_beacon.auth_code[0]=0;
			basic_beacon.login=0;
			basic_beacon.report=0;
			basic_beacon.offtime=10;
			basic_beacon.attrib=8;
		}
		
		//6,---- read vote beacon 
		if( base_read_e2prom(STORE_VOTE_BEACON_ADDR,tmp,VOTE_BEACON_LEN) ){
			mem_cpy(tmp,&vote_beacon.head_addr+1,VOTE_BEACON_LEN);		
			if( function.BROADCAST__SW&&(vote_beacon.sys_mode ==0x0E)&&(vote_beacon.vbuf[0]==0x14)	){
				if( function.broadcast__det_content_err() ==0)
				kernel.multi_title_flag =1;
			}			
		}
		else{
			mem_set(&vote_beacon.head_addr+1,VOTE_BEACON_LEN,0x00);
		}		
		
		//7,---- OEM 
		if( base_read_e2prom(STORE_OEM_CODE_ADDR,tmp,8) ){
				#if 1
				kernel.custom_rf_sync_code =0;
				if(tmp[0]!='@'){					
					kernel.custom_rf_sync_code =calc_custom_rf_sync_code(tmp);
				}
				else{				
					//platform.rf_update_sync_code( (sum2<<8)+sum1 );	//sunvote default;
				}	
				#else			
				//默认只支持@sunvote
				unsigned char len =sizeof(OEM_CODE)/sizeof(unsigned char);
				if( mem_compare(tmp,OEM_CODE,len) ==0){ //!= OEM_CODE
					mem_cpy(OEM_CODE,tmp,len);
					base_write_e2prom(STORE_OEM_CODE_ADDR,tmp,len);						
				}
				#endif
		}
		else{
				unsigned char len =sizeof(OEM_CODE)/sizeof(unsigned char);
				mem_cpy(OEM_CODE,tmp,len);
				base_write_e2prom(STORE_OEM_CODE_ADDR,tmp,len);										
		}
		
			
		//8,--- read CRS2 mode basic beacon
		if( base_read_e2prom(STORE_BASE_ATTRIB_ADDR,tmp,BASIC_BEACON_CRS2_LEN) ){
			mem_cpy(tmp,&basic_beacon_crs2.head_addr+1,BASIC_BEACON_CRS2_LEN);							
		}
		else{
			mem_set(&basic_beacon_crs2.head_addr+1,BASIC_BEACON_CRS2_LEN,0x00);
			basic_beacon_crs2.crs2_attrib[0] = 0x48;//默认设置 键盘的登录菜单允许，在线2分钟关机  见键盘协议2.2.1 第25字节
		}											
		
		//9,--read ATT		
		if( base_read_e2prom(STORE_AUX_ATT_ADDR,tmp,AUX_ATT_LEN)){
			mem_cpy(tmp,&aux_att.head_addr+1,AUX_ATT_LEN);							
		}
		else{
			aux_att.keypad_attn_sw=1;
			aux_att.keypad_report_sw=0;
			aux_att.base_beacon_sw=0;
		}

		//10,--read multi channel 
		if( base_read_e2prom(STORE_MULTI_CHAN_ADDR,tmp,MULTI_FREQ_LEN) ){
			mem_cpy(tmp,&multi_freq_setup.head_addr+1,MULTI_FREQ_LEN);
			if(function.lock_rf_count)
				multi_freq_setup.chan_count=function.lock_rf_count;
			if( (multi_freq_setup.chan_count==0) ||(multi_freq_setup.chan_count>4) )//模块数不能为零,至少也有一个
				multi_freq_setup.chan_count=1;
			if( multi_freq_setup.chan_freq[0] !=base_config.chan){//20200416 解决LOCK_CHAN !=0时，无法关联到多频点的问题
				single_relevant_to_multi_chan(base_config.chan);
			}
		}
		else{
			//无效多频点信息，需要设置初始参数; 
			if(function.lock_rf_count)
				multi_freq_setup.chan_count=function.lock_rf_count;
			else
				multi_freq_setup.chan_count=1;
			single_relevant_to_multi_chan(base_config.chan);
		}					
		
		//11 ,ext basic beacon	//20200415不保存基础扩展信标，	
//		if( base_read_e2prom(STORE_BASIC_EXT_BEACON_ADDR,tmp,BASIC_EXT_BEACON_LEN) ){
//			mem_cpy(tmp,&basic_ext_beacon.head_addr+1,BASIC_EXT_BEACON_LEN);							
//		}
//		else{
//			//how to init ??
//			mem_set(&basic_ext_beacon.head_addr+1,BASIC_EXT_BEACON_LEN,0);
//		}	

		//12  keypad crc config 
		if( base_read_e2prom(STORE_KP_CRC_CONFIG,tmp,1) ){
			kernel.keypad_crc_flag = tmp[0];
		}
		else{
			if( function.crc16_keypad__SW)
				kernel.keypad_crc_flag =1; //默认打开键盘CRC校验
			else
				kernel.keypad_crc_flag =0;
		}
		
		if( base_read_e2prom(STORE_BASE_NAME_VIEW,tmp,1) ){
			network_set_nameview(tmp[0]);		
		}
		else{
			network_set_nameview(0);//默认基站名称可见
		}
        
        #if (MD_LIST_MGNT)
		function.list_mgnt__read_from_e2prom();
		#endif
		
		#if 	MD_SPECIAL_STOP_PRO	
		core__stop_beacon_intf.pwrup();
		#endif
		
				
}

void base_clear_e2prom_parameter(void)
{
	unsigned char tmp[32];
	memset(tmp,0xFF,sizeof(tmp));
	
	for(unsigned char i=0;i<35;i++)
	{
		platform.e2prom_write(i*32, tmp, 32);
	}
	
}


