//#include	"core_extern.h"
#include	"base_pc_protocol.h"
#include    "fast_beacon_intf.h"
/*
base protocol 5.2.1  mode=29
*/



#if MD_FAST_BEACON      

#define     DEF_1S      50//20ms
unsigned int hold_time =0;



void fast_beacon__rxpc(const unsigned char *rxpc)
{
    //rxpc[3] = 11 
	//rxpc[4] = 29
	unsigned char ack_buf[8];
    if(rxpc[4] == 29){
        hold_time = (rxpc[5]==0)?10:rxpc[5];
        hold_time *= DEF_1S;
        ack_buf[0] =rxpc[4];
        ack_buf[1] =rxpc[5];
        pc_cmd_0x61_ack(11,ack_buf,2);//core__pc_intf.ack_pc(0xe1,11,ack_buf,2);        
    }
}

//called by timer
void fast_beacon__exe(void)
{
    if( hold_time ){
        hold_time--;
    } 
}

unsigned char fast_beacon__get_stutas(void)
{
    return ( hold_time )?1:0;
}





struct fast_beacon_intf_STR core__fast_beacon_intf={
    .rxpc = fast_beacon__rxpc,
    .execute = fast_beacon__exe,
    .get_status = fast_beacon__get_stutas,
};


#endif
