//#include "platform_extern.h"
//#include "core_extern.h"
//#include "func_extern.h"
////base protocol  5.8.3

#include    "base_config.h"
#include "func_down_beacon_intf.h"
#include "ext_beacon_intf.h"
#include "gen_lgpkt_ch_intf.h"
#include "function_interface.h"
#include "platform_interface.h"
#include "base_core_user.h"
#include "base_core.h"
#include "function.h"
#include "string.h"
#include <stdlib.h>
#include "HW_MCUIO.h"
#include    "my_headfile.h"





#if MD_EXT_BEACON	

#define   DBG_EXT_BEACON    1		//debug sw

struct ext_beacon_STR{
  const unsigned char *pbuf;
  unsigned short buf_len;

  unsigned char cur_status;
  unsigned char pbuf_status;
  #define   FIRST_PKT_LEN   21
  #define   GEN_PKT_LEN     32 
  #define   DATA_OFFSET 4 
};
struct ext_beacon_STR ext_beacon;





void ext_beacon__rxpc(const unsigned char *rxpc)
{
  //rxpc[0] =3
  //data = offset4
  ext_beacon.pbuf_status = 1;
  ext_beacon.pbuf = rxpc;
  ext_beacon.buf_len = (rxpc[2]<<8) +rxpc[3];
	
  //next debug only  
  unsigned char pkt_cnt = GET_PKT_CNT(ext_beacon.buf_len,FIRST_PKT_LEN,GEN_PKT_LEN); 
//  my_debug.print_buf(DBG_EXT_BEACON,"rx data:",ext_beacon.pbuf,32);
//  my_debug.printf(DBG_EXT_BEACON,"pkt length=%d pkt count=%d \n",ext_beacon.buf_len,pkt_cnt);
	unsigned char index,len;
  for(unsigned char i=0;i<pkt_cnt;i++){
		index = GET_PKT_INDEX(FIRST_PKT_LEN,GEN_PKT_LEN,i);
		len = GET_PKT_LEN(ext_beacon.buf_len,FIRST_PKT_LEN,GEN_PKT_LEN,i,pkt_cnt);		
//    my_debug.printf(DBG_EXT_BEACON,"seq=%d index=%d len=%d \n",i,index,len);
  }
	 
}

//called by sysmode change input=0 stop
void ext_beacon__startup_check(unsigned char type)
{
  if(ext_beacon.pbuf == NULL) return;
	
  if( (type ==0) &&(ext_beacon.cur_status != 0) ){ //stop
    ext_beacon.pbuf = NULL;
    ext_beacon.cur_status =0;
	base_core.set_sysmode(base_core.get_sysmode() & ~(1<<7) );	//core__attr_intf.set_sysmode( core__attr_intf.get_sysmode() & ~(1<<7) );
//		my_debug.printf(DBG_EXT_BEACON,"%s() ext beacon stop\n",__FUNCTION__);
  }
  if(type == 1)
  {
    if(ext_beacon.pbuf_status == 1)//在这次投票改变之前发生过下载扩展信标 则开启扩展方式
      {
        ext_beacon.pbuf_status = 0;
        ext_beacon.cur_status = 1;
        
//        my_debug.printf(DBG_EXT_BEACON,"%s() ext beacon start\n",__FUNCTION__);
      }
//      else{
//        ext_beacon.pbuf = NULL; 
//        ext_beacon.cur_status =0;
//       base_core.set_sysmode(base_core.get_sysmode() & ~(1<<7) );//core__attr_intf.set_sysmode( core__attr_intf.get_sysmode() & ~(1<<7) );
//        my_debug.printf(DBG_EXT_BEACON,"%s() ext beacon stop\n",__FUNCTION__);
//      }
  }
    
}


//------------------------------------------------------
static void ext_beacon__first_pkt(void)
{			
		unsigned char tmp[33];
		memset(tmp,0,33);
		tmp[0] =32;	
		base_core.get_match_code(tmp+1);//core__attr_intf.get_matchcode(tmp+1);
		tmp[5] =0x34;	
		tmp[6] = GET_PKT_CNT(ext_beacon.buf_len,FIRST_PKT_LEN,GEN_PKT_LEN);	  
    unsigned short crc = crc16(ext_beacon.pbuf+DATA_OFFSET,GET_CRC_DATA_LEN(tmp[6],FIRST_PKT_LEN,GEN_PKT_LEN) );
		//debug only 
//		my_debug.printf(1,"crc val=%x, crc leng=%d \n",crc,GET_CRC_DATA_LEN(tmp[6],FIRST_PKT_LEN,GEN_PKT_LEN));
		tmp[7] =crc>>8;	
		tmp[8] =crc &0xff;	
		tmp[9] = base_core.get_vote_datapos();//core__attr_intf.get_datapos();// ext_beacon.pbuf[1];//?	
		tmp[10] =0;	
		tmp[11] =0;	
    memcpy(tmp+12,ext_beacon.pbuf+DATA_OFFSET,FIRST_PKT_LEN);
//	my_debug.print_buf(1,"tx first pkt data:",tmp,33);
		platform.rf_set_txok_flag(0);//platform__rf_intf.set_txok_flag(0);
		base_core.send_rf_data(tmp,base_core.get_mainRF_hard_id());//platform__rf_intf.write_buf(tmp+1,tmp[0],core__multi_intf.get_main_hardid() );
	//	my_debug.printf(DBG_EXT_BEACON,"%s() first pkt\n",__FUNCTION__);
}

void ext_beacon__gen_pkt(unsigned char seq)
{
		unsigned char tmp[33];
		memset(tmp,0,33);
		tmp[0] =32;
    unsigned char pkt_cnt = GET_PKT_CNT(ext_beacon.buf_len,FIRST_PKT_LEN,GEN_PKT_LEN);
    unsigned char index = GET_PKT_INDEX(FIRST_PKT_LEN,GEN_PKT_LEN,seq);
    unsigned char len = GET_PKT_LEN(ext_beacon.buf_len,FIRST_PKT_LEN,GEN_PKT_LEN,seq,pkt_cnt);	
    memcpy(tmp+1,ext_beacon.pbuf+DATA_OFFSET+index,len );
    platform.rf_set_txok_flag(0);//platform__rf_intf.set_txok_flag(0);
		base_core.send_rf_data(tmp,base_core.get_mainRF_hard_id());//platform__rf_intf.write_buf(tmp+1,tmp[0],core__multi_intf.get_main_hardid() );
//		my_debug.printf(DBG_EXT_BEACON,"%s() gen pkt\n",__FUNCTION__);
}




unsigned char ext_beacon__execute(void)
{
  if(ext_beacon.cur_status ==0) 
      return 0;
	unsigned char pkt_cnt = GET_PKT_CNT(ext_beacon.buf_len,FIRST_PKT_LEN,GEN_PKT_LEN);
	base_core.set_sysmode(base_core.get_sysmode() | (1<<7) );//core__attr_intf.set_sysmode( core__attr_intf.get_sysmode() |(1<<7) ); 
  ext_beacon__first_pkt();
	//platform__system_intf.delay_ms(1);
  platform.rf_waitfor_txok();//platform__rf_intf.waitfor_txok();
  for(unsigned char i=1;i< pkt_cnt;i++){
    ext_beacon__gen_pkt(i);
    platform.rf_waitfor_txok();//platform__rf_intf.waitfor_txok();
  }
    return 1;
}

/*
* 增加此接口用于解决启动扩展信标后，还会出现普通投票然后再切换到扩展业务的问题
*/
void ext_beacon__set_sysmod_bit7(void)
{
  if(ext_beacon.cur_status ==0) 
      return;
	base_core.set_sysmode(base_core.get_sysmode() | (1<<7) );//core__attr_intf.set_sysmode( core__attr_intf.get_sysmode() |(1<<7) ); 
}



struct ext_beacon_intf_STR core__ext_beacon_intf={
	.rxpc = ext_beacon__rxpc,
  .startup_check =ext_beacon__startup_check,
  .execute = ext_beacon__execute,
	.set_sysmode_flag = ext_beacon__set_sysmod_bit7,
};







#endif
