
#include "base_pc_protocol.h"
#include "base_core_user.h"
#include "base_core.h"


//-------------------------配合 keypad battery test -----------------------------------------------------
#if defined(_SDK_OFFLINE_) || defined(_SDK_SYSMODE0_KEEPTIMER_)
struct monitor_sdkoffline_sysmode0_STR
{	
	unsigned char exec_type;
	unsigned int sdk_offline_cnt;
	unsigned int sysmode0_keep_cnt;
	unsigned int exec_step_timer;	
	unsigned short waitfor_timer_Sec; //秒数  //default
};

struct monitor_sdkoffline_sysmode0_STR _sdkoffline_sysmode0={
	.exec_type =0 ,
	.sdk_offline_cnt =0,
	.sysmode0_keep_cnt=0,
	.exec_step_timer=0,
};



//基站发送关机命令，强制所以键盘关机
static void base_force_keypad_poweroff(void)
{
    unsigned char tmp[32];
    tmp[0] =0x1A+2;
    get_base_match_code(tmp+1);
		tmp[5] =0x30;
		tmp[6] =0x00;
		tmp[7] =0x00;	
		tmp[8] =0x05;
		tmp[9] =0x00;	
		tmp[10] =0x00;		
		tmp[11] =0x00;	
		tmp[29] =0x72;		
		tmp[30] =0xB8;
    //发送数据，需要考虑容量均衡模式和5.8G时....
    base_tx_to_keypad_sub(tmp,get_mainRF_usr_id());
}


/* 20201021 需要测试验证!!!!!!!!!!!!!!!!!!!!!
* called by 2.5ms
*/
void _monitor_sdkoffline_sysmode0(void)
{
	switch(_sdkoffline_sysmode0.exec_type){
		case 1:
			{
				unsigned char flag=0;
							
				//if( (++_sdkoffline_sysmode0.sdk_offline_cnt >= 400*60 ) || (_sdkoffline_sysmode0.sysmode0_keep_cnt >=400*60*40) ){
				#ifdef 	_SDK_OFFLINE_
				if(++_sdkoffline_sysmode0.sdk_offline_cnt >= 400*60 )
					flag =1;
				#endif
				#ifdef 	_SDK_SYSMODE0_KEEPTIMER_
				if(vote_beacon.sys_mode ==0) 		
					_sdkoffline_sysmode0.sysmode0_keep_cnt++;
				else
					_sdkoffline_sysmode0.sysmode0_keep_cnt=0;						
				if(_sdkoffline_sysmode0.sysmode0_keep_cnt >=400*60*40)
					flag =1;
				#endif 
				
				if(flag){
					_sdkoffline_sysmode0.sdk_offline_cnt =0;
					_sdkoffline_sysmode0.sysmode0_keep_cnt =0;
					_sdkoffline_sysmode0.exec_step_timer =0 ;
					_sdkoffline_sysmode0.exec_type =2;
				}
			}				
			break;
			
		case 2:
        vote_beacon.sys_mode =0;        //退出当前业务，持续一260*2.5ms小段时间;
        mem_set(vote_beacon.vbuf,5,0);	//	memset(vote_beacon.param,0,5);  //			
			if( ++_sdkoffline_sysmode0.exec_step_timer >= 260){
				_sdkoffline_sysmode0.exec_step_timer =0 ;
				_sdkoffline_sysmode0.exec_type =3;
			}
			break;
			
		case 3:
			base_force_keypad_poweroff(); 
			if( ++_sdkoffline_sysmode0.exec_step_timer >= 260*3){
				base_send_beacon_switch(0);		// 关闭基站发送信标数据 //send_order = SEND_NONE; //不发任何信标；
				_sdkoffline_sysmode0.exec_step_timer =0 ;
				_sdkoffline_sysmode0.exec_type =4;	//off
			}			
			break;
		
		default:break;
	}//switch
	
}

//called by sdk cmd;除了一问十答之外的sdk命令都可以重新激活检测;
void reset__monitor_sdkoffline_sysmode0(void)
{
	_sdkoffline_sysmode0.sdk_offline_cnt =0;	
	
	if(_sdkoffline_sysmode0.exec_type !=4) return;
	_sdkoffline_sysmode0.exec_type =1;	//re-startup
	if( get_base_send_beacon_status()==0)
		base_send_beacon_switch(1);	
}

#endif



//---------------------- base core info------------------------------------------------------------------
/*
*
*/
#if defined(_DEBUG_CORE_)
void _debug_core__process_core_info(const unsigned char *pc)
{
	unsigned char tmp[64],cmd_type;
	unsigned char start_offset =6;

	mem_set(tmp,64,' ');
	mem_cpy(pc+8,tmp,start_offset);
	cmd_type =pc[12];
	//pc[13] ==':'
	//pc[14] ---有效数据开始....
	if(mem_compare(pc+8,(unsigned char*)"BATT",4) ){
		switch (cmd_type){
			#if defined(_SDK_OFFLINE_) || defined(_SDK_SYSMODE0_KEEPTIMER_)
			case '1':	//set 
				_sdkoffline_sysmode0.exec_type = pc[14];
				if( (pc[15]<<8) + pc[16] )
        	_sdkoffline_sysmode0.waitfor_timer_Sec = (pc[15]<<8) + pc[16];
				mem_cpy("ok ",tmp+start_offset,3);
				break;
			case '3':	//get
				tmp[start_offset+0] = _sdkoffline_sysmode0.exec_type;
				tmp[start_offset+1] = _sdkoffline_sysmode0.waitfor_timer_Sec>>8;
				tmp[start_offset+2] = _sdkoffline_sysmode0.waitfor_timer_Sec;								
				break;
			#endif 
			
			
			default:
				mem_cpy("ERR",tmp+start_offset,3);
				break;
		}//sw
	}

	//response pc cmd 
	response_pc_cmd("cor",tmp,64);
}

#endif 

