
/*
内存复制
*/
void mem_cpy( const unsigned char *src,unsigned char *dist,unsigned char len)
{
		unsigned char i;
		for(i=0;i<len;i++)
			dist[i] = src[i] ;
}

/*
初始化数组的值都为指定常量
*/
void mem_set(unsigned char *tmp,unsigned char len,unsigned char set_val)
{
		unsigned char i;	
		for(i=0;i<len;i++)
			tmp[i] =set_val;
}

/*
比较两个数组对应位数据是否相等
只要有不相等就返回0 
*/
unsigned char mem_compare(const unsigned char *ptr1,const unsigned char *ptr2,unsigned char len)
{
		unsigned char i;
		for(i=0;i<len;i++)
			if(ptr1[i]!=ptr2[i]) return 0;
		
		return 1;
}

/*
比较数组的每个元素都与指定常量是否相等
只要有不相等的就 return 0;
*/
unsigned char mem_cmp_const(const unsigned char *ptr1,unsigned char len,unsigned char _const)
{
		unsigned char i;
		for(i=0;i<len;i++)
			if(ptr1[i]!=_const) return 0;
		
		return 1;
}


/*
搜索数组中元素是否有指定常量

*/
unsigned char mem_search_const(const unsigned char *ptr1,unsigned char len,unsigned char _const)
{
		unsigned char i;
		for(i=0;i<len;i++)
			if(ptr1[i]==_const) return 1;
		
		return 0;
}


//-----------------------------------------------------------------------
//CRC这些算法，是老PVS系统的算法
unsigned short const crc_table[16] = //CRC余式表
{
    0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7,
    0x8108, 0x9129, 0xa14a, 0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef,
};

unsigned short crc16(const unsigned char *ptr,unsigned short len)
{
    unsigned short Crc;
    unsigned char da;

    Crc = 0;
    while( len-- != 0 )
    {
        da = Crc >> 12; 	/* 暂存CRC的高四位 */
        Crc <<= 4; 				/* CRC左移4位，相当于取CRC的低12位）*/
        Crc ^= crc_table[da ^ ( *ptr / 16 )]; 	/* CRC的高4位和本字节的前半字节相加后查表计算CRC，
                              然后加上上一次CRC的余数 */
        da = Crc >> 12; 	/* 暂存CRC的高4位 */
        Crc <<= 4; 				/* CRC左移4位， 相当于CRC的低12位） */
        Crc ^= crc_table[da ^ ( *ptr & 0x0f )]; 	/* CRC的高4位和本字节的后半字节相加后查表计算CRC，然后再加上上一次CRC的余数 */
        ptr++;
    }
    return( Crc );	
}




#include "stdio.h"
#include "stdlib.h"
#include "string.h"
/*
输入的十六进制数（5字节），当成10进制（只有4字节）; 
例如 :
输入 12 34; 实际是0x1234；但是用户想要的是十进制的1234；
*/
void Dec_to_Hex(unsigned char *sn,unsigned char len, unsigned char *dec )
{
	int tmp;
	char buf[10];
	unsigned char i;
	
	//a,hex conver to string
	for(i=0;i<len;i++)
		sprintf( (char *)(buf + (i<<1)),"%02x",sn[i]);
	//b,string conver to integer
	tmp =atoi(buf);
	
	dec[0] = tmp>>24;
	dec[1] = tmp>>16;	
	dec[2] = tmp>>8;	
	dec[3] = tmp>>0;	
}







