
#include "base_pc_protocol.h"
#include "platform_interface.h"
#include "function_interface.h"
#include "base_core.h"
#include "base_core_user.h"
#include "func_down_beacon_intf.h"
#include "func_multipkt_up_intf.h"

volatile unsigned char __1ms_flag,__2ms5_flag,__20ms_flag;

void fcc_mode1(void);
/*
2.5ms中断服务程序
*/
void base_core_2ms5_isr(void)
{
    __2ms5_flag =1;
    #if (MD_DOWN_BEACON)
	if(func__down_beacon_intf.execute() != 1)
	#endif
    
	#ifndef 	KEYPAD60
	//基站发送信标给键盘总入口
//	base_tx_keypad_beacon();
	#endif
//operation_debug_io(4);
	//基站上报投票数据给pc的数据包发送间隔
	vote_data_report_interval();
	
	#if defined(_SDK_OFFLINE_) || defined(_SDK_SYSMODE0_KEEPTIMER_)//配合键盘电量测试
	_monitor_sdkoffline_sysmode0();
	#endif 
	
	{
		static unsigned char count=0;
		if(++count >=12){
			count=0;
			fcc_mode1();
		}	
	}
	    
}

/*
* 
*/
void base_core_28ms_isr(void)
{
	#ifdef 	KEYPAD60
	//基站发送信标给键盘总入口
	base_tx_keypad_beacon();
	#endif
}


//-----------------------------------------------------------------
/*
20ms中断服务程序
*/
void base_core_20ms_isr(void)
{
		static volatile unsigned char _0s5_cnt;
	
		unsigned short tmp16;
        __20ms_flag =1;
    
		_2BYTE_TO_16BIT(basic_beacon.nowT,tmp16);
		tmp16++;
		_16BIT_TO_2BYTE(tmp16,basic_beacon.nowT);	
	
		timer_20ms_function();
	
		if(++_0s5_cnt >=25){//0.5S定时器功能
			_0s5_cnt =0;			
			
			//如果开启了心跳功能，则启用定时器
			if( (function.aux_beat__SW)&&(aux_beats.net_timer) )	aux_beats.net_timer--;

			//sysmode ==0的监测;
			if( vote_beacon.sys_mode ==0)
				kernel.sysmode0_keeptimer_05S++;
			else
				kernel.sysmode0_keeptimer_05S =0;
		}

		//rf error warning 
		rf_error_warning();
				
}

/* -----------------------------------------------
* 各个时间间隔 定时执行
* called by mainloop
*/
void timer_mainloop_process(void)
{

    if( __1ms_flag){
		  __1ms_flag =0;

    }
		
    if( __2ms5_flag){
      __2ms5_flag =0;

    }
		
    if( __20ms_flag){
      __20ms_flag =0;
        #if MD_MULTIPKT_UP
        func__multipkt_up_intf.tx_rpt_request();
        #endif			
    }
		
}




