
#include "base_pc_protocol.h"
#include "platform_interface.h"
#include "function_interface.h"
#include "base_core.h"
#include "base_core_user.h"
#include "ext_beacon_intf.h"

//#ifdef _DEBUG_CORE_
    #include "SEGGER_RTT.h"
    #include "SEGGER_RTT_Conf.h"
//#endif


//--------------------------- 0x60 ---------------------------------------
#define 	_0x60_READ_BASIC_BEACON			1
#define 	_0x60_WRITE_BASIC_BEACON		2
#define 	_0x60_READ_VOTE_BEACON			3
#define 	_0x60_WRITE_VOTE_BEACON			4
#define 	_0x60_READ_VOTE_MSG					5
#define 	_0x60_WRITE_VOTE_MSG				6
#define 	_0x60_READ_BASIC_BEACON_CRS2		7
#define 	_0x60_WRITE_BASIC_BEACON_CRS2  	8
#define 	_0x60_WRITE_BROADCAST_PARAMETER	11	//V0.95  Section2.3设置发信息信标
#define 	_0x60_WRITE_BROADCAST_CONTENT		12
#define 	_0x60_WRITE_BROADCAST_START			13

#define 	_0x60_READ_EXT_BEACON				14
#define 	_0x60_WRITE_EXT_BEACON			15


void _0x60_basic_delay_ms( unsigned short  time )
{
    unsigned short  i = 0;
    while( time-- ){
			i = 33400;
			while( i-- );
    }
}
/*
基站回应来自pc的0x60命令 
input:
	type-pc的数据类型
	ack_buf - 回应的buf
	type_data_len - 回应buf的长度 */
void pc_cmd_0x60_ack(unsigned char type, unsigned char *ack_buf,unsigned char type_data_len)	
{
	unsigned char tmp[64];
	mem_set(tmp,sizeof(tmp)/sizeof(unsigned char),0);	
	tmp[0]= 31;
	tmp[1]= 0xE0;
	tmp[2]= get_base_id();//pc2bs_Bb.bs_id;	//Gavin
	tmp[3]= type;
	mem_cpy( ack_buf,tmp+4,type_data_len);	//tmp[4]......
	//here,you can set some special type
	
	base_tx_to_pc_sub(tmp);	
}


/*
基站处理来自pc的0x60命令
1,复制相关参数
2，保存到E2prom
3, 回应pc   */
unsigned char pc_cmd_0x60_process(const unsigned char *rxpc)
{
	switch(rxpc[3]){	
		//----1,2 read,write basic beacon 		
		case _0x60_WRITE_BASIC_BEACON:
			//a copy data
			//disable_INT();
			mem_cpy( rxpc+4,&basic_beacon.head_addr+1,BASIC_BEACON_LEN);
			//enable_INT();
			//b store to e2prom 
			base_write_e2prom(STORE_BASIC_BEACON_ADDR,&basic_beacon.head_addr+1,BASIC_BEACON_LEN);
		  //
			if(basic_beacon.more_info ==3){
				mem_cpy(rxpc+13,kernel.bill_info,9);
			}
		
			//c ack pc
		case _0x60_READ_BASIC_BEACON:
			pc_cmd_0x60_ack(_0x60_READ_BASIC_BEACON,&basic_beacon.head_addr+1,BASIC_BEACON_LEN);
			break;		

		//-----3,4 read,write vote beacon
		case _0x60_WRITE_VOTE_BEACON:	
            if ((rxpc[4] != vote_beacon.DATAPOS)||(rxpc[5] != vote_beacon.sys_mode))
			{
				vote_beacon_change_callback(rxpc);
			}
            
			if(rxpc[4] != vote_beacon.DATAPOS){//DataPos ---- is changge!!!
				#ifdef _DEBUG_CORE_
				_debug_core__init_parameter_datapos_change();//新的一轮投票开始，清除必要debug参数!!	
                _debug_set_subject(rxpc[8]);                
				#endif
				#ifdef RF_5G8
				re_init_all_resend_slot();
				#endif 
				#ifdef _DBG_VOICE_KP
				_debug_voice_kp__init_all_parameter();
				#endif	
				SEGGER_RTT_printf(0,RTT_CTRL_BG_BLACK RTT_CTRL_TEXT_YELLOW "---------------------------------------\n");
				SEGGER_RTT_printf(0,RTT_CTRL_BG_BLACK RTT_CTRL_TEXT_YELLOW "\n\n\n------------------New:%d------------------", rxpc[4]);				
				SEGGER_RTT_printf(0,RTT_CTRL_BG_BLACK RTT_CTRL_TEXT_WHITE "\n");
				kernel.rx_buf_overflow =0; //add by Gavin 20201201 debug only
			}
//            #ifdef _DEBUG_CORE_
//            if(11 == vote_beacon.vbuf[0] && rxpc[6] == 0)
//            {
//                _debug_core__printf();
//            }
//            #endif
			if(rxpc[5] != vote_beacon.sys_mode){//sys mode ---- is changge!!!
				kernel.ext_vbeacon_sysmode_change_flag =1;	//
			}

			//检测多题型测验题
			if(   (rxpc[5]==14)&&(rxpc[6]==20 || rxpc[6]==0x1E)&& ( (rxpc[5] != vote_beacon.sys_mode) || ((rxpc[5] == vote_beacon.sys_mode)&&(vote_beacon.vbuf[0] != rxpc[6])) )   ){
				function.broadcast__startup();
#ifdef _DEBUG_CORE_
                if(rxpc[6]==20)
                    SEGGER_RTT_printf(0,"T\n");
                else
                    SEGGER_RTT_printf(0,"A\n");
                
                SEGGER_RTT_printf(0,"DCMD:%d\n",rxpc[6]);
#endif                
                if(rxpc[6]==20)
                    kernel.multi_title_flag =1; //used to ack title
			}
			else if( (rxpc[5]!=14) || (rxpc[6]!=20) )
				kernel.multi_title_flag =0; //

			//copy data
			// #ifdef VOTE_BEACON_64BYTE
			// mem_cpy( rxpc+4,&vote_beacon.head_addr+1,55);//special!!!!!!!Gavin20200204
			// #else
			mem_cpy( rxpc+4,&vote_beacon.head_addr+1,VOTE_BEACON_LEN);
			// #endif
#ifdef _DEBUG_CORE_            
			SEGGER_RTT_printf(0,"Sysmode:%d,Datapos:%d\n",rxpc[5],rxpc[4]);
#endif		
            
            #if MD_EXT_BEACON
			core__ext_beacon_intf.set_sysmode_flag();
			#endif
			//enable_INT();
			//store to e2prom 
			base_write_e2prom(STORE_VOTE_BEACON_ADDR,&vote_beacon.head_addr+1,VOTE_BEACON_LEN);		
			//快速配对入口
			function.fastmatch__enter_exit(rxpc);//fastmatch_enter_exit(rxpc);
		  //ack pc 
		case _0x60_READ_VOTE_BEACON:
			pc_cmd_0x60_ack(_0x60_READ_VOTE_BEACON,&vote_beacon.head_addr+1,VOTE_BEACON_LEN);	
			break;

		//-----5,6 pc send get vote msg requset!!
		case _0x60_READ_VOTE_MSG:
			vote_data_report_startup(); //queue
			break;
		case _0x60_WRITE_VOTE_MSG:	//pc ack the vote msg!
			{
			unsigned char ack_tmp=1;
			vote_status_clear_confirmed(&rxpc[4]);	//queue 
			pc_cmd_0x60_ack(_0x60_WRITE_VOTE_MSG,&ack_tmp,1);
			}
			break;
		
		//-----7,8 CRS2协议下的基础信标				
		case _0x60_WRITE_BASIC_BEACON_CRS2:
			if(!function.crs2__SW) break;	
			//disable_INT();
			mem_cpy( rxpc+4,&basic_beacon_crs2.head_addr+1,BASIC_BEACON_CRS2_LEN);
			//enable_INT();
			base_write_e2prom(STORE_BASE_ATTRIB_ADDR,&basic_beacon_crs2.head_addr+1,BASIC_BEACON_CRS2_LEN);
			_0x60_basic_delay_ms(5);
		case _0x60_READ_BASIC_BEACON_CRS2:
			if(!function.crs2__SW) break;	
			pc_cmd_0x60_ack(_0x60_READ_BASIC_BEACON_CRS2,&basic_beacon_crs2.head_addr+1,BASIC_BEACON_CRS2_LEN);
			break;

		case _0x60_WRITE_BROADCAST_PARAMETER://	11	//V0.95  Section2.3设置发信息信标
		case _0x60_WRITE_BROADCAST_CONTENT://		12
		case _0x60_WRITE_BROADCAST_START://			13
			function.broadcast__config_enter(rxpc);
			break;
		
		//----14,15 read,write ext beacon 		
		case _0x60_WRITE_EXT_BEACON:
			//a copy data
			//disable_INT();
			#ifdef EXTEND_VBEACON2
			if(rxpc[4] ==1){ //自定义题型；键盘协议section2.2.17-1;
				mem_cpy( rxpc+4,&ext_vbeacon.head_addr+1,EXT_VBEACON_LEN);
				kernel.ext_vbeacon_type1_flag =1;
				kernel.ext_vbeacon_sysmode_change_flag=0;	//解决sdk 发送stop后又快速启动导致无效的问题，32.5ms
			}
			else if(rxpc[4] ==2){//指定答题器
				mem_cpy( rxpc+4,&ext_vbeacon_2.head_addr+1,EXT_VBEACON_LEN);
				kernel.ext_vbeacon_type2_flag =1;
				kernel.ext_vbeacon_sysmode_change_flag=0;
			}
			#else
			mem_cpy( rxpc+4,&ext_vbeacon.head_addr+1,EXT_VBEACON_LEN);
			#endif
			kernel.ext_vbeacon_onoff_flag  =1;		
			//enable_INT();
			//b store to e2prom 
			//base_write_e2prom(STORE_BASIC_BEACON_ADDR,&basic_beacon.head_addr+1,BASIC_BEACON_LEN);
		
			//c ack pc
		case _0x60_READ_EXT_BEACON:
			//pc_cmd_0x60_ack(_0x60_READ_EXT_BEACON,rxpc+4,EXT_VBEACON_LEN);			
			pc_cmd_0x60_ack(_0x60_READ_EXT_BEACON,&ext_vbeacon.head_addr+1,EXT_VBEACON_LEN);
			break;

		
		default:
			function.user_pc_0x60cmd(rxpc);
			break;
	}//sw

	return 1;
}


