
#include "base_core.h"
#include "_debug_core_.h"



#if defined(_DBG_2G4_KP_)
/*
return:
-1--- my < dist 
0--- my ==dist 
1--- my > dist	
*/
static int check_mem(const unsigned char*my,const unsigned char*dist,unsigned char len)
{
    unsigned char i;
    for(i=0;i<len;i++){
       if( my[len-1-i] > dist[len-1-i])    return 1;
       else if( my[len-1-i] < dist[len-1-i])  return -1;       
    }//for
    return 0;
}


/*
function:将一个sn存放在当前list中指定pos位置
0 - 排在pos后面after
1 -排在pos前面before
*/
static void move_(struct _debug_core_STR *tmp,
            unsigned char pos,
            unsigned char bf_aft,
            const unsigned char *sn)
{
    unsigned char i,len = tmp->valid_kp_cnt;
		unsigned char idsn_len = tmp->idsn_len;
	
    if(len==0) return; //prevent overflow
		
    if( bf_aft ==0){// 放在pos后面
				for(i=pos+1;i<len;i++)
					mem_cpy(tmp->kp_info[len+pos-i].kp_idsn,tmp->kp_info[len+pos-i+1].kp_idsn,idsn_len);
				mem_cpy(sn,tmp->kp_info[pos+1].kp_idsn,idsn_len); //insert
    } 
    else{
				for(i=pos;i<len;i++)
					mem_cpy(tmp->kp_info[len-1+pos-i].kp_idsn,tmp->kp_info[len-1+pos-i+1].kp_idsn,idsn_len);
				mem_cpy(sn,tmp->kp_info[pos].kp_idsn,idsn_len); //insert      
    }  
}


/*Input:
* rx_kp[0] -- len
* rx_kp[1] -- 0x91/92/93,94
 fucntion :用于记录连接到基站的所有键盘，并且按照键盘SN从小到大的顺序（便于后续使用时快速查表)
* input: 包含键盘SN 
* 按顺序插入到列表中(找到第一个比自己大的，放在其前面);如果已经存在就不处理
*/
unsigned char _debug_core__creat_keypad_list(const unsigned char *rx_kp)
{
    unsigned char mid,len;
    unsigned char range_start,range_end;
    int s_rslt,e_rslt,mid_rslt;
    unsigned char idsn_len;
		unsigned char index;  

    //update/record idsn_len and idsn_index
    if( get_idsn_and_len(rx_kp[1],&_dbg_core_.idsn_index,&_dbg_core_.idsn_len)==0 ) return 0;

    idsn_len = _dbg_core_.idsn_len;
		index = _dbg_core_.idsn_index;
    //process [0] specially!!
    if( (len = _dbg_core_.valid_kp_cnt) ==0 ){
        mem_cpy(rx_kp + index,_dbg_core_.kp_info[0].kp_idsn,idsn_len);
        _dbg_core_.valid_kp_cnt++;
        return 1;
    }

    range_start =0;
    range_end = len -1;

    while (1){
       if(range_end - range_start <= 1){
            s_rslt = check_mem(rx_kp + index,_dbg_core_.kp_info[range_start].kp_idsn,idsn_len);
            e_rslt = check_mem(rx_kp + index,_dbg_core_.kp_info[range_end].kp_idsn,idsn_len);  
            if( (s_rslt==0) || (e_rslt==0) )    return 0;   //已经存在就不用排序了
            else if(s_rslt==-1)
                move_(&_dbg_core_,range_start,1,rx_kp + index);
            else if( (s_rslt==1)&& (e_rslt==-1))
                move_(&_dbg_core_,range_start,0,rx_kp + index);
            else
                move_(&_dbg_core_,range_end,0,rx_kp + index);
            
            break;
       } 

        mid =(range_end - range_start)>>1; // /2
        mid_rslt = check_mem(rx_kp + index,_dbg_core_.kp_info[range_start+mid].kp_idsn,idsn_len);
        if( mid_rslt ==0)   return 0;	//已经存在就不用排序了
        else if( mid_rslt ==1)
            range_start = range_start+mid;
        else
            range_end = range_start+mid;
    }//while
    
    _dbg_core_.valid_kp_cnt++;
    return 1;                
}



/*
* 查找keypad list中指定sn的位置；如果存在就返回其下标;
0xff - 没有这个SN
0- _DBG_KP_CNT ;got it 
*/
unsigned char _debug_core__find_idsn_in_list( const unsigned char *rx_sn)
{
    unsigned char mid,len;
    unsigned char range_start,range_end;
    int mid_rslt;
    unsigned char idsn_len = _dbg_core_.idsn_len;

    //process [0] specially!!
    if( (len = _dbg_core_.valid_kp_cnt) ==0 ) return 0xff;

    range_start =0;
    range_end = len -1;

    while (1){
       if(range_end - range_start <= 1){
					if( check_mem(rx_sn,_dbg_core_.kp_info[range_start].kp_idsn,idsn_len) ==0)
							return range_start;
					else if( check_mem(rx_sn,_dbg_core_.kp_info[range_end].kp_idsn,idsn_len) ==0)
							return range_end;
					else 
						break; //not found!!!
       } 

        mid =(range_end - range_start)>>1; // /2
        mid_rslt = check_mem(rx_sn,_dbg_core_.kp_info[range_start+mid].kp_idsn,idsn_len);
        if( mid_rslt ==0)   return range_start+mid;
        else if( mid_rslt ==1)
            range_start = range_start+mid;
        else
            range_end = range_start+mid;
    }//while
    
    return 0xff; 
}

#endif





