
#include "base_core.h"
#include "_debug_core_.h"
#include "platform_interface.h"
#include "function_interface.h"

/*
2020.11.08 为更好的适应各种调试需求和配合base Assist Tool;重写调试部分的固件
*/

#ifdef  _DEBUG_CORE_

struct _debug_core_STR _dbg_core_={
    .valid_kp_cnt =0,
};



/* 此函数用于回复assist tool的命令
*/
void response_pc_cmd( char type[], unsigned char *ack,unsigned char len)
{
    unsigned char tmp[64];
    if(len>56) len=56;   
    mem_cpy(ack,tmp+8,len);
    mem_set(tmp+8+len,56-len,' ');
    tmp[0] = 'a';
    tmp[1] = 'c';
    tmp[2] = 'k'; 
    tmp[3] = '-';     
    tmp[4] = type[0];
    tmp[5] = type[1];
    tmp[6] = type[2];
    tmp[7] = ':';        
    platform.base_send_data_to_pc(tmp,64);
}


/*
* 获取错误信息函数
*/
void get_SNerror_info(unsigned char err_total,unsigned char (*err_p)[6], unsigned char seq, unsigned char *info)
{
	unsigned char i;
	info[0] = err_total;	
	for(i=0;i<6;i++){
		info[1+i*8] = seq;
		info[2+i*8] = ':';
		mem_cpy(err_p[seq],info+3+i*8,6); //mem_cpy(_dbg_core_.rx_idsn_err[seq],info+3+i*8,6);
	}
}

#endif




#if  defined(_DBG_2G4_KP_)

/* ------------
* 获取基础键盘信息
*/
static void get_keypad_info__basic(unsigned char offset, unsigned char *info)
{
    struct _debug_keypad_info_STR p =_dbg_core_.kp_info[offset];
		mem_cpy(p.kp_idsn,info+0,6);
    info[6] = p.rx_kp_cnt>>8;
    info[7] = p.rx_kp_cnt;
    info[8] = p.ack_kp_cnt>>8;
    info[9] = p.ack_kp_cnt;
    info[10] = p.tx_pc_cnt>>8;
    info[11] = p.tx_pc_cnt;
    info[12] = p.acked_pc_cnt>>8;
    info[13] = p.acked_pc_cnt;   
}


/*-------------------
* 处理键盘调试信息入口
* called by 
*/
void _debug_core__process_keypad_info(unsigned char *pc)
{
//	unsigned char tmp[64],cmd_type;
//	unsigned char start_offset =6;

//	mem_set(tmp,64,' ');
//	mem_cpy(pc+8,tmp,start_offset);
//	cmd_type =pc[12];
//	//pc[13] ==':'
//	//pc[14] ---有效数据开始....
//	if(mem_compare(pc+8,(unsigned char*)"READ",4) ){//read keypad info
//			unsigned char index;
//			index = pc[14];
//			switch (cmd_type){
//				case '1':   //read键盘基础信息
//					get_keypad_info__basic(index,tmp+start_offset);                    
//					break;
//				case '2':   //rx keypad  sn error
//					get_SNerror_info(_dbg_core_.rx_idsn_err_cnt,_dbg_core_.rx_idsn_err,index,tmp+start_offset);
//					break;
//				case '3':   //ack keypad sn error
//					get_SNerror_info(_dbg_core_.ack_idsn_err_cnt,_dbg_core_.ack_idsn_err,index,tmp+start_offset);
//					break;					
//				case '4':   //tx pc sn error
//					get_SNerror_info(_dbg_core_.txpc_idsn_err_cnt,_dbg_core_.txpc_idsn_err,index,tmp+start_offset);
//					break;					
//				
//				default:
//					mem_cpy("ERR",tmp+start_offset,3);
//					break;
//			}//sw
//	}//if
//	else if(mem_compare(pc+8,(unsigned char*)"STAT",4) ){
//			switch (cmd_type){
//				case '1'://setting
//					if( (pc[14] ==0)||(pc[14] ==1)||(pc[14] ==2) ){
//						_dbg_core_.status =pc[14];
//						mem_cpy("ok ",tmp+start_offset,3);
//					}
//					else
//						mem_cpy("ERR",tmp+start_offset,3);                   
//						break;
//				case '3':	//inquire
//					tmp[start_offset] = _dbg_core_.status;
//					tmp[start_offset+1] = _dbg_core_.valid_kp_cnt;
//					tmp[start_offset+2] = _dbg_core_.idsn_len;
//					tmp[start_offset+3] = _dbg_core_.rx_idsn_err_cnt;
//					tmp[start_offset+4] = _dbg_core_.ack_idsn_err_cnt;				
//					tmp[start_offset+5] = _dbg_core_.txpc_idsn_err_cnt;				
//					break;
//				default:
//					mem_cpy("ERR",tmp+start_offset,3);
//					break;
//			}//sw            
//	}
//	else{
//			mem_cpy("ERR",tmp+start_offset,3);
//	}

//	//response pc cmd 
//	response_pc_cmd("kyp",tmp,64);
}
#endif 



/*----------------------------------------------------------------
所有调试命令的总入口
called by usb rx functionW
*/
void _debug_core__cmd_enter(unsigned char *pc)	
{
//    #ifdef  _DEBUG_CORE_
//		if( (pc[0] !='s')||(pc[1] !='n')||(pc[2] !='d')||(pc[3] !='-')||(pc[13] !=':')) return;

//    //1,调试键盘
//    if(mem_compare(pc+4,(unsigned char*)"kyp:",4) ){
//				#if  defined(_DBG_2G4_KP_)
//        //_debug_core__process_keypad_info(pc);
//			  #endif
//    }
//    else if(mem_compare(pc+4,(unsigned char*)"fun:",4) ){
//			function._debug__function_enter(pc);
//    }		
//    else if(mem_compare(pc+4,(unsigned char*)"cor:",4) ){
//			_debug_core__process_core_info(pc);
//    }
//    else if(mem_compare(pc+4,(unsigned char*)"5g8:",4) ){
//			#ifdef _DBG_VOICE_KP
//			_debug_core__process_5G8_keypad(pc);
//			#endif
//    }
//	
//    #endif 
}

