

#ifndef 	_PLATFORM_INTERFACE_H_
#define 	_PLATFORM_INTERFACE_H_


//
#define 	NFC_BLOCK_CNT		64//32

//#define 	_NFC_DEBUG_

//#define 	_NFC_READER_

#ifdef _NFC_DEBUG_
struct _info_STR{
	unsigned char name[16];
	unsigned char keypad_sn[6];
	unsigned char card_sn_record[8];	
	unsigned char keep_;
	unsigned char start_;		
	unsigned char complish_;			
};

struct _nfc_err_STR{
	unsigned char cnt;
	unsigned char card_sn[NFC_BLOCK_CNT][8];
};

#endif 	
	
	
/*
*define nfc block info struct */
struct nfc_app_STR{
	unsigned char waddr[NFC_BLOCK_CNT];
	unsigned char wbuf[NFC_BLOCK_CNT][4];
	unsigned wblock_cnt;
	
	unsigned char raddr[NFC_BLOCK_CNT];
	unsigned char rbuf[NFC_BLOCK_CNT][4];	
	unsigned rblock_cnt;

	volatile unsigned char mode_status;	//default, user write,nfc reader(debug only)
	unsigned char card_write_cnt_addr;
	unsigned short wait_sdk_info;						//
	unsigned char sdk_offline_cnt;					//sdk connect det		
	
	
	
	#ifdef 	_NFC_DEBUG_ 
	
	unsigned char debug_sdk_change_cnt;
	unsigned char debug_sdk_down_cnt;
	unsigned char debug_custom_ok_cnt;		
	unsigned char debug_default_ok_cnt;
	unsigned char debug_driver_ok_cnt;
	unsigned char debug_driver_start_cnt; 
	unsigned char debug_driver_keep_cnt;	
	unsigned char ok_cnt;
	unsigned char card_sn[8];
	
	struct _nfc_err_STR error[8];	
	struct _info_STR kp_nfc_info[NFC_BLOCK_CNT];		
	#endif
	
};
extern struct nfc_app_STR nfc_app;


struct hardware_platform_STR{
	/*-------------------------------------------------------
		!!!!!!!!!!!! 警戒线  此后的数据禁止任何修改 !!!!!!!!
	--------------------------------------------------------*/
//	void (*disable_interrupt)(void);
//	void (*enable_interrupt)(void);	
	void (*system_reset)(void);
	void (*delay_ms)(unsigned int );
    void (*delay_us)(unsigned int );
	void (*get_chip_id)(unsigned char *chip_id);

	//usb 
	unsigned char (*base_send_data_to_pc)(unsigned char *buf,unsigned short len);
	unsigned char (*usb_connect_status)(void);
	
	//i2c 
	void(*e2prom_write)(unsigned int addr,const unsigned char *buf,unsigned char len);
	unsigned char(*e2prom_read)(unsigned int addr,unsigned char *buf,unsigned char len);	
	
	//rf
	void (*rf_send_data)(unsigned char* buf,unsigned char len,unsigned char rf_id);
	void (*rf_set_freq)(unsigned char freq,unsigned char rf_id);
	void (*rf_set_send_pwr)(unsigned char pa,unsigned char rf_id);	
	void (*rf_set_FCC_mode)(unsigned char mode);
	unsigned char (*rf_get_rssi)(void);
	void (*rf_init)(unsigned char rf_id);
	void (*rf_update_sync_code)(unsigned short sync,unsigned char sync_cnt,unsigned char rf_id);
	//
	void (*rf_5G8_load_send_data)(unsigned char* buf,unsigned char len,unsigned char rf_id);
	void (*rf_5G8_send_multi_frame)(void (*send_function)(const unsigned char *,unsigned char id),const unsigned char *tmp ,unsigned char rf_id);
	//void (*rf_send_data_sub)(unsigned char* buf,unsigned char len,unsigned char rf_id);
	//void (*rf_5G8_send_multi_frame)(void (*send_function)(const unsigned char *),const unsigned char *tmp ,unsigned char rf_id);
	
	//led
	void (*pc_led_ctrl)(unsigned char high_low);
	void (*rf_led_ctrl)(unsigned char high_low);	
	void (*general_led_ctrl)(unsigned char led_NO, unsigned char high_low);
	
	//double ANT
	void (*doule_ANT_sw)(unsigned char);
	
	//buzzer
	void (*buzzer_ctrl)(unsigned char);
	
	//rfid
	unsigned char (*rfid_get_hard_connect_status)(void);
	unsigned char (*rfid_reader)(unsigned char addr,unsigned char cnt,unsigned char *out)	;	
	int (*rfid_write_read_N_block)(struct nfc_app_STR *);

	
	//LCD
	void (*lcd_display_chinese)(unsigned short x,unsigned short y 
																		//,unsigned char char_type																	 
																		,const unsigned char *chr
																		,unsigned char len
																		//,unsigned char reverse
																			);
																		
	void (*lcd_display_char)(unsigned short x,unsigned short y
																	//, unsigned char char_type,																	 
																	,const unsigned char *chr
																	//unsigned char len,
																	//unsigned char reverse
																		);																		

//	//used to AES
//	unsigned int (*get_timer_cnt)(void);
//	void (*enable_crc_clk)(void);																
																
	
	void (* uart1_print_bytes)(unsigned char *pt,unsigned short len);
	/*-------------------------------------------------------
		!!!!!!!!!!!! 警戒线  此前的数据禁止任何修改 !!!!!!!!
		如需添加请在此之后!!!!!!!!!!!!!!!!!
	--------------------------------------------------------*/
    void (*rf_set_txok_flag)(unsigned char);
    unsigned char (*rf_get_txok_flag)(void);
    void (*rf_waitfor_txok)(void);
    void (*_2ms5_count_down)(unsigned int);

};
extern  struct hardware_platform_STR platform;




#endif

