

#ifndef 	_FUNCTION_INTERFACE_H_
#define 	_FUNCTION_INTERFACE_H_


/*
功能接口结构
*/
struct function_STR{
	/*-------------------------------------------------------
		!!!!!!!!!!!! 警戒线  此后的数据禁止任何修改 !!!!!!!!
	--------------------------------------------------------*/	
		//1 whitelist
		const unsigned char whitelist__SW;	//功能开关
		void (*whitelist__init)(void);//预留
		void (*whitelist__enter)(const unsigned char *ptr);	
		unsigned char *(*whitelist__search_special_list)(const unsigned char *ptr);
		unsigned char  (*whitelist__base_confirm_keypad_request)(void);
		unsigned char (*whitelist__keypad_idsn_record_request)(const unsigned char *rxkp);
	
		//2 fast match 
		const unsigned char fastmatch__SW;	//功能开关	
		void (*fastmatch__enter_exit)(const unsigned char *rxpc);
		unsigned char (*fastmatch__load_info_to_vote_beacon)(unsigned char *ptr);
		unsigned char (*fastmatch__success_check)(const unsigned char *rxkp);	
		void (*fastmatch__lowPA_setup)(const unsigned char *);
		void (*fastmatch__lowPA_ack)(void);
		unsigned char (*fastmatch__get_status)(void);
	
		//3,update keypad firmware
		const unsigned char updatekp__SW;	//功能开关	
		void (*update__kp_enter)(const unsigned char *rx_pc);
		unsigned char (*update__kp_progress)(void);	
		unsigned char (*update__save_keypad_ack_data)(const unsigned char *rxkp);
		unsigned char (*update__get_status)(void);
		void (*update__monitor_sdk_connect)(void);
		
		//4 base test
		const unsigned char basetest__SW;	//功能开关
		void (*basetest__progress)(void);
		void (*basetest__init)(void);
		unsigned char (*basetest__get_status)(void);
		void (*basetest__rx_and_ack_pc)(const unsigned char *rxpc,unsigned char *ack_buf);	

		//5 monitor base freq
		const unsigned char monitor__SW;	//功能开关
		void (*monitor__auto_search_freq_enter)(void);
		unsigned char (*monitor__rf_data)(unsigned char *rx_kp);
		void (*monitor__freq_process)(void);	
		
		//6 hard info
		const unsigned char hdinfo_HMODEL;
		const unsigned char hdinfo_SW1;		
		const unsigned char hdinfo_SW2;
		const unsigned char hdinfo_SW3;
		
		const unsigned char rf_speed_set;
		const unsigned char rf_channel_max;	//最多频点数;2.4G有80个频点，433M只有32个 		
		unsigned char rf_id[4];

		//7 other function
		const unsigned char crs2__SW;					//crs2开关
		const unsigned char	lock_channel;			//固定频点
		const unsigned char	mask_spec_channel;			//屏蔽指定频点
		const unsigned char lock_logmode;			//固定模式
		const unsigned char no_matchcode__SW;	//无配对码开关
		const unsigned char aux_att__SW;
		const unsigned char aux_beat__SW;
		const unsigned char no_ID_mode__SW;		//不支持id模式的开关
		const unsigned char lock_rf_count;		//是否允许	
		//const unsigned char fix_rf_tx_beacon_cnt;
		const unsigned char match_keypad_type;
		const unsigned char base_type;
		
		//8 crc
		const unsigned char crc16_keypad__SW; //
		const unsigned char crc16_pc__SW; //	
		
		//9 ,nfc function
		const unsigned char nfc__SW; //
		void (*nfc__pc_interaction)(const unsigned char *buf);
		void(*nfc__scan)(void);
		
		//10,AES
		const unsigned char AES__SW;
		void(*aes__init)(void);
		void(*aes__config_enter)(const unsigned char *);		
		void(*aes__load_fastmatch)(unsigned char *);
		void(*aes__keycode_upgrade)(void);
		void (*aes__rf_Encrypt)(unsigned char *);
		unsigned char (*aes__rf_Decrypt)(unsigned char *);		
		void (*aes__get_key)(unsigned char *);		
		unsigned char (*aes__get_status)(void);
		
		//11,TCP IP
		const unsigned char TCPIP__SW;		
		void(*tcpip__init)(void);
		void(*tcpip__config_enter)(const unsigned char *);			
		void (*tcpip__process)(void);
		
		//broadcast
		const unsigned char BROADCAST__SW;	
		void(*broadcast__config_enter)(const unsigned char *);
		void(*broadcast__startup)(void);
		unsigned char (*broadcast__keypad_request)(unsigned char);
		unsigned char (*broadcast__det_content_err)(void);
		
		//user extend interface
		void (*user_pc_transfer2keypad)(const unsigned char *buf);	//pc转发给keypad的数据
		void (*user_pc_0x60cmd)(const unsigned char *buf);
		void (*user_pc_0x61cmd)(const unsigned char *buf);
		void (*user_pc_0x61cmd_type0x0B)(const unsigned char *buf);
		
		void (*user_keypad_transfer2pc)(const unsigned char *buf);	//keypad转发给pc的数据			
		
		
	//app debug 
	void (*_debug__function_enter)(const unsigned char *buf);
		
	/*-------------------------------------------------------
		!!!!!!!!!!!! 警戒线  此前的数据禁止任何修改 !!!!!!!!
		如需添加请在此之后!!!!!!!!!!!!!!!!!
	--------------------------------------------------------*/
        void (*msg__polling)(void);
        
        //network
        void (*network__polling)(unsigned char);
        unsigned char (*network__get_netseq)(void);
        void (*network__set_netseq_change)(void);
        unsigned short (*network__get_pwd)(void);
        void (*network__set_pwd)(unsigned short);
        unsigned char (*network__get_name)(unsigned char *buf, unsigned char buflen);
        unsigned char (*network__set_name)(unsigned char *buf, unsigned char buflen);
        unsigned char (*network__get_nameview)(void);
        void (*network__set_nameview)(unsigned char view);
        
        //list_name
        void (*list_mgnt__init)(void);
        unsigned short (*list_mgnt__read_from_e2prom)(void);
        void (*list_mgnt__pc_rx)(const unsigned char *);

};
extern  struct function_STR function;
	


#endif //_FUNCTION_INTERFACE_H_

