
#ifndef 	_BASE_PC_PROTOCOL_
#define 	_BASE_PC_PROTOCOL_

#include	"base_core.h"

//-------------2.1 pc 设置基础信标 ------------------------------
//pc-->BASE 	
struct BASE_Bbeacon_STR{
	unsigned char head_addr; 	//is struct head address,no actual utility	
	unsigned char auth_code[2]; //byte4
	unsigned char login;			//byte6
	unsigned char report;
	unsigned char offtime;		//byte8自动关机时间
	unsigned char attrib;
	unsigned char nowT[2]; 		//byte10-11
	unsigned char more_info;			//byte12
	unsigned char conf_id[2]; //byte13-14
	unsigned char info_id;	
	unsigned char page_id[2]; //byte16-17
	#define 	BASIC_BEACON_LEN 		14//17
};

//crs2协议下的基础信标
struct BASE_Bbeacon_CRS2_STR{
	unsigned char head_addr; 	//is struct head address,no actual utility
	unsigned char crs2_attrib[4];	//byte4-7
    unsigned char pack_cnt;     //信标序号，第24字节低4位，0~7，用于键盘休眠同步唤醒,20220518

	#define 	BASIC_BEACON_CRS2_LEN 		4
};


/*
*扩展基础信标; 
protocol:
	base  V5.34 section5.2.8 type21,22
	keypad V5.4.0 section2.3 ext basic beacon
*/
struct BASE_ext_Bbeacon_STR{
	unsigned char head_addr; 	//is struct head address,no actual utility	
	unsigned char info_type;	//byte5 ---->keypad byte3
	unsigned char base_count; //byte
	unsigned char blank[2]; //null
	unsigned char base_ch[20];	
	
	#define 	BASIC_EXT_BEACON_LEN 		24
};








//------------2.2 pc 设置投票信标 ------------------------------
//pc-->BASE
//pc发送投票信标，4字节及之后的与基站发给键盘的一致。
struct BASE_Vbeacon_STR{
	unsigned char head_addr; 	//is struct head address,no actual utility
	unsigned char DATAPOS;	//byte4
	volatile unsigned char sys_mode;		 
  unsigned char vbuf[24]; //byte6-29	
	
	unsigned char vbuf_default[35]; //used to 64bytes rf vote beacon only
	#ifdef VOTE_BEACON_64BYTE
		#define 	VOTE_BEACON_LEN		55
	#else 	
		#define 	VOTE_BEACON_LEN		26
	#endif
};


/*------------2.4 扩展投票信标 ---------------------------------
扩展信标
cmdtype=14,15 
*see base protocol V0.95 -section2.4 
*see keypad protocol V0.99-10 section2.2.17
* 自定义标题 - 新东方泡泡定制 at CRS100 debug ok first!;
*/
struct ext_vbeacon_STR{
	unsigned char head_addr; 	//is struct head address,no actual utility		
	unsigned char info_type;
	unsigned char null;
	unsigned char datapos;
	unsigned char title[20];
//	unsigned char default_buf[25];

	#define 	EXT_VBEACON_LEN 23//	#define 	EXT_VBEACON_LEN 26
};



//----------------5.2 基站基础管理类 -----------------------------
//5.2.1 读写基站配置
struct bs_cfg_STR{
	 unsigned char head_addr; 	//is struct head address,no actual utility
	 unsigned char bs_id;	//byte4 real id 
   unsigned char chan;
   unsigned char keymin[2];
   unsigned char keymax[2];
   unsigned char  rf_pwr; //byte10
	
	#define 	BASE_CONFIG_LEN		7
};

//5.2.2 读写基站硬件信息
struct bs_hdinfo_STR{
	 unsigned char head_addr; 	//is struct head address,no actual utility
   unsigned char MODEL; //byte4
   unsigned char H_VER;
   unsigned char S_VER;
   unsigned char SERIAL[6]; //byte7-12
   unsigned char NEWVER;		//byte13
   unsigned char SW_3B[3];	//byte14-16
	#define 	BASE_HDINFO_LEN		13	
};

//5.2.3 读写配对码
struct bs_match_code_STR{
	 unsigned char head_addr; 	//is struct head address,no actual utility
   unsigned char match_code[4]; //byte4-7
	#define 	BASE_MAC_LEN		4		
};


//5.2.4 基站升级
//5.2.5 


//5.2.6 软件狗功能
struct soft_dog_STR{
	 unsigned char head_addr; 	//is struct head address,no actual utility	
   unsigned char mode; //byte4
   unsigned char user_zone;
	 unsigned char user_info[16];
	
};


//5.2.7 信道评估
//struct channel_assess_STR{

//};



//------//5.2.8 通用附加配置  --------------------------------------------------
struct general_aux_config_mode1_2_STR{	
	 unsigned char head_addr; 	//is struct head address,no actual utility
   unsigned char log_mode;//byte5
	 unsigned char base_name[12];
	#define 	BASE_NAME_LOG_MODE_LEN		13	
};

struct general_aux_config_mode3_4_STR{	
	 unsigned char head_addr; 	//is struct head address,no actual utility
   unsigned char attrib2;			//byte5
	 unsigned char chan_count;
	 unsigned char chan_freq[4];
	 unsigned char test123;
	#define 	MULTI_FREQ_LEN		6	
};

struct general_aux_config_mode7_8_STR{ //protocol section5.23
	 unsigned char head_addr; 	//is struct head address,no actual utility
   unsigned char net_timer;//byte5
	 
};
struct general_aux_config_mode11_12_STR{	 //protocol section5.23 //考勤相关
	 unsigned char head_addr; 			//is struct head address,no actual utility 
   unsigned char keypad_attn_sw;	//byte5
   unsigned char keypad_report_sw;//byte6
   unsigned char base_beacon_sw;	//byte7 ,开启时发送投票信标	
	#define 	AUX_ATT_LEN		3
};

//struct general_aux_config_mode15_16_STR{	 //protocol section5. 快速配对基站功率设置
//	 unsigned char head_addr; 			//is struct head address,no actual utility 
//   unsigned char lower_PA;				//byte5
//   unsigned char keypad_report_sw;//byte6
//   unsigned char base_beacon_sw;	//byte7 ,开启时发送投票信标	
//	#define 	FASTMATCH_LOWERPA_LEN		1
//};

struct general_aux_config_mode23_24_STR{	
    unsigned char head_addr; 	//is struct head address,no actual utility
    unsigned char log_mode;//byte5
    unsigned char base_name[12];
    #define 	AUX_NAME_LEN		13	
};

struct general_aux_config_mode25_26_STR{	
    unsigned char head_addr; 	//is struct head address,no actual utility
    unsigned char log_mode;//byte5
    unsigned char base_pwd[2];
    #define 	AUX_PWD_LEN		3	
};






////see BASE protocol 5.2.10 		
//struct base_test_STR{
//	unsigned char head_addr; 	//is struct head address,no actual utility 	
//	unsigned char type;
//	unsigned char chan;
//	unsigned char Tmode;
//	unsigned char rf_pwr;
//	unsigned short send_cnt[2];	//发送次数
//	unsigned char interval; //发送间隔 ms	
//	#define 	BASE_TEST_LEN		7
//	
//	
//};



extern struct BASE_Bbeacon_STR  basic_beacon;
extern struct BASE_ext_Bbeacon_STR  basic_ext_beacon;
extern struct BASE_Bbeacon_CRS2_STR  basic_beacon_crs2;
extern struct BASE_Vbeacon_STR  vote_beacon;
extern struct ext_vbeacon_STR ext_vbeacon;
extern struct ext_vbeacon_STR ext_vbeacon_2;
extern struct bs_cfg_STR  base_config;
extern struct bs_hdinfo_STR  base_hdinfo;
extern struct bs_match_code_STR  base_mac;
//extern struct general_aux_config_STR aux_config;
	 extern struct general_aux_config_mode1_2_STR base_name_log_mode;
	 extern struct general_aux_config_mode3_4_STR multi_freq_setup;	 
	 extern struct general_aux_config_mode7_8_STR aux_beats;	
	 extern struct general_aux_config_mode11_12_STR aux_att;
     extern struct general_aux_config_mode23_24_STR base_name_setup;
     extern struct general_aux_config_mode25_26_STR base_pwd_setup;
	 //extern struct general_aux_config_mode15_16_STR fastmatch_lowerPA;

//extern struct base_test_STR base_test;




#endif 


