
#ifndef 	_BASE_CORE_USER_H_
#define 	_BASE_CORE_USER_H_
/*
此头文件是基站内核开放给用户的函数接口*/


#ifndef NULL
#define NULL ((void *)0)
#endif

	

enum core_run_state_ENUM{
	_STA_IDLE,
	_STA_GENERAL_VOTEING,
	_STA_VOICE_START,
	_STA_VOICE_VOTEING,	
	_STA_FAST_MATCH,
	_STA_SYSMODE_0,
};
//extern enum core_run_state_ENUM KERNEL_RUN_STATE;



struct base_core_STR{
	void (*get_core_ver)(unsigned char *);
	void(*core_init)(void);
	void(*core_loop)(void);	
	void(*timer_2ms5_enter)(void);
	void(*timer_20ms_enter)(void);
	void(*timer4_enter)(void);	
	
	void(*get_match_code)(unsigned char *mcode);
	unsigned char (*get_id)(void);
	unsigned char (*get_log_mode)(void);
	void (*set_main_rf_chan)(unsigned char);
	unsigned char (*get_main_rf_chan)(void);	
	unsigned char (*get_mainRF_hard_id)(void);
	unsigned char (*get_whitelistRF_hard_id)(void);
	
	void (*send_rf_data)(unsigned char *buf,unsigned char rf_hard_id);
	void (*switch_send_beacon)(unsigned char sw);
	unsigned char (*get_send_beacon)(void);
	unsigned char (*rf_data_fifo_in)( unsigned char *rxkp);
	
	
	void (*send_data_to_pc)(const unsigned char *dt);	
	
	unsigned char (*get_vote_datapos)(void);

	unsigned char (*sdk_data_fifo_in)(const unsigned char *rxpc);		
	//using display
	unsigned char (*get_run_status)(void);
	unsigned char (*get_sdk_connect_status)(void);
	unsigned char (*get_sdk_connect_status_acc)(void);
	unsigned char (*get_permit_dispaly_flag)(void);	
	

	//
	unsigned char (*get_5G8_keypad_sn_list)(unsigned char *sn);
	unsigned char (*get_5G8_keypad_online_count)(void);	
    
	void(*force_sysmode0)(void);
    unsigned char (*get_sysmode)(void);
    void(*set_sysmode)(unsigned char );
};
extern struct base_core_STR base_core;






//crc16 
unsigned short crc16(const unsigned char *ptr,unsigned short len);


//高位在前
#define _2BYTE_TO_16BIT(_byte,_short)	 _short= ((_byte)[0]<<8)+(_byte)[1];
#define _16BIT_TO_2BYTE(_short,_byte) (_byte)[0] =(_short)>>8;(_byte)[1] =(_short)&0xff;


//乘法转成位移!!
#define		MULTIx60(i)				((i<<5)+(i<<4)+(i<<3)+(i<<2))			//60=32+16+8+4
#define		MULTIx5(i)				((i<<2)+i)											//5=4+1





#endif //_BASE_CORE_USER_H_

