

#ifndef 	_BASE_CORE_H_
#define 	_BASE_CORE_H_

#include 	"base_config.h"

#ifdef 	_OLD_CONFIG_

//#define 	RF_5G8	//区别于常规2.4G
/*支持60路的语言协议和30路的协议是不同的!!
*发送信标的周期个数及处理都有细微差别!
a,初始版本：		Cycle 13*2.5ms; Max 30keypad; 48bytes voice/packet		->default
	中间版本			Cycle 28ms; 		Max 60keypad; 52bytes voice/packet		->#define KEYPAD60
	可靠传输版本: Cycle 28ms; 		Max 60keypad; 48bytes voice/packet		->#define KEYPAD60 && define VOICE_PROTOCOL_3RD
b,
*/
#ifdef 	RF_5G8
	#define 	KEYPAD60						//第二版语音协议-60路
	#define 	VOICE_PROTOCOL_3RD	//第三版语音协议-60路+可靠传输(基于第二版)	
	#define   BUF_ALERT2   //支持键盘重传语音单独连续点名
	/*
	开启此宏定义，投票数据处理(rf接收和rpt to pc的投票数据)就在主程序循环中进行，否则在中断里直接处理(默认)	*/
	#define 	MAINLOOP_PROCESS_VOTE	
#endif 




//#define 	RF_MODUAL_MONITOR		//rf 模块监测

//------------------- 2020.11 重写debug ----------------------------------------------------------
/*
*
*/
//#define 	_DEBUG_CORE_			//总开关
//#define 	_DBG_2G4_KP_			//与键盘的通信
//#define		_DBG_VOICE_KP					//监测键盘数据，包括语音和非语音模式;T2语言基站

//#define 	_SDK_OFFLINE_		//sdk断联后，基站强制关闭所有键盘; 用于配合做键盘电量测试;;
//#define 	_SDK_SYSMODE0_KEEPTIMER_	//sysmode0保持一段时间后关闭所有键盘







//*---------
//* 只能开关,禁止修改!!!
//*-----------------------
#define 	TYPE_T2					10

#define 	TYPE_EVS200			50
#define 	TYPE_EVS100			51

#define 	TYPE_CRS200			40
#define 	TYPE_CRS200_NL	41
#define 	TYPE_CRS200_433	30
#define 	TYPE_C100					41
//--------------------------------------
/**
*EVS200:
*	1,E11 -	a,4个模块都发基础信标，投票信标和ack; b,需要把基础信标和投票信标都修改成28Bytes; //20200616
*	2,G1  - a,AES加密 信标需要发送32bytes;b,投票信标中带主频点信息；c,容量均衡。
*
*CRS200:
* 1,T1Lite - 在投票信标tmp32必须是信标的crc校验的低字节!
*
*EVS200_433：
* 1,voxm - 转发数据必须要加crc校验!!
*/

#endif 


//20200930  //扩展投票信标下，自定义题型和指定答题器功能叠加，需要两个缓冲区保存;特殊处理!!!!!
#define 	EXTEND_VBEACON2

/*
*基站核心固件的版本，
*/
#ifdef RF_5G8
#define 	CORE_VER0		4	//stm32F4
#define 	CORE_VER1		5	//5.8G
#define 	CORE_VER2		0
#define 	VOTE_BEACON_64BYTE		//64字节的投票信标，常规无线通信只用32字节
#else 
#define 	CORE_VER0		4	//stm32F4
#define 	CORE_VER1		2 //2.4G
#define 	CORE_VER2		0

//#define 	CORE_VER0		1	//stm32F1
//#define 	CORE_VER1		2 
//#define 	CORE_VER2		0
#endif


//-------------------------- kernel status --------------------------------------------
/*
* 
*/
#include "base_core_user.h"
struct kernel_STR{
	unsigned char sdk_connect_status;
	unsigned short sdk_connect_count;
	unsigned char sdk_connect_status_acc;
	unsigned short sdk_connect_count_acc;
	
	unsigned char pc_led_count;
	unsigned char rf_led_status;
	unsigned char rf_led_count;

	//unsigned char run_state; //内核运行状态: //enum core_run_state_ENUM
	enum core_run_state_ENUM run_state; //内核运行状态:
	
	unsigned char permit_display_flag;	//语音基站有效!
	unsigned char bill_info[9];					//议案信息	
	unsigned char _20ms_flag;
	
	unsigned char keypad_crc_flag;	//crc软开关,与sdk通信!
	
	
	unsigned char keypad_online_cnt;		//语言基站有效!
	//debug used
	unsigned short rx_buf_overflow;			//接收缓冲区溢出个数;
	unsigned short rx_idsnbuf_overflow;	//保持idsn缓冲区溢出个数; 语音模式下无效;
	unsigned short re_rpt_pc_count;			//基站没有被pc确认，重发的数据包个数
	
	
	//20200825,增加多题型开始标志,用于特殊ack
	unsigned char multi_title_flag;
	//20200914 扩展投票信标
	unsigned char ext_vbeacon_onoff_flag;
	unsigned char ext_vbeacon_sysmode_change_flag;
	//#ifdef 	EXTEND_VBEACON2	
	unsigned char ext_vbeacon_type1_flag;	//自定义题型----A,B,AB
	unsigned char ext_vbeacon_type2_flag;	//指定答题器
	
	unsigned int sysmode0_keeptimer_05S;
	
	unsigned short custom_rf_sync_code;	
//	unsigned short tmp1;
//	unsigned short tmp2;	
//	unsigned char tmp3;
//	unsigned short tmp4[20];	
};
extern struct kernel_STR kernel;


//get sys mode0 保持时间;
unsigned int get_sysmode0_keeptimer(void);


/*
* turn on LED if it stay OFF status;
*called by rcvRF data 
*/
void refresh_rcvRF_indicate(void);

/*
* indicate led, and update pc connect status
* called by base core rx function	*/
void refresh_pc_connect_status(void);
unsigned char get_pc_connect_status_acc(void);
/*
* timer monitor pc connect status
*called by 20ms timer 
*/
void timer_20ms_function(void);

/*
* get pc connect status 	*/
unsigned char get_pc_connect_status(void);


unsigned char get_datapos(void);
	
unsigned char get_base_status(void);
/*
*
*/
unsigned char get_permit_dispaly_status(void);


//-------------------- base core -------------------------------

#ifdef 	RF_5G8
	#define 	USB_REPORT_MAX	1024
#else
	#define 	USB_REPORT_MAX	64
#endif 

/* 
初始化基站核心的参数*/
void base_core_init_all(void);

/*
基站核心函数在主程序循环中被调用*/
void base_core_main_loop(void);

/*
设置硬件信息*/
void set_base_hard_firmware_info(void);

/*获取白名单模块编号*/
unsigned char get_whitelist_rfid(void);

void vote_beacon_change_callback(const unsigned char*rxpc);




//------------------ timer isr -------------------------------
/*
核心需要的定时器中断服务程序*/
extern void base_core_2ms5_isr(void);
extern void base_core_20ms_isr(void);
extern void base_core_28ms_isr(void);



//---------------------------pc/sdk ----------------------------------
/*
基站接收pc的usb数据，保存到 队列中
此函数被usb endpoint callback 调用*/
unsigned char pcrx_data_save(const unsigned char *pc_buf);
void pcrx_init_queue(void);

//send data to pc via usb 
void base_tx_to_pc_sub(const unsigned char *dt);


/*
初始化处理 基站和sdk/PC的数据通信
a,初始化 接收pc数据的队列
b,初始化 键盘转发给pc的数据队列*/
void base_process_pc_init(void);

/* 
基站处理pc数据的总入口
called by mainloop*/
void base_process_pc_data(void);

/*
基站回应来自pc的0x60命令 
input:
	type-pc的数据类型
	ack_buf - 回应的buf
	type_data_len - 回应buf的长度*/
void pc_cmd_0x60_ack(unsigned char type, unsigned char *ack_buf,unsigned char type_data_len);
/*
基站处理来自pc的0x60命令
1,复制相关参数
2，保存到E2prom
3, 回应pc*/
unsigned char pc_cmd_0x60_process(const unsigned char *rxpc);

/*
基站处理来自pc的0x60命令
1,复制相关参数
2，保存到E2prom
3, 回应pc*/
unsigned char pc_cmd_0x61_process(const unsigned char *rxpc);
/*
基站回应来自pc的0x61命令 */
void pc_cmd_0x61_ack(unsigned char type,const unsigned char *ack_buf,unsigned char type_data_len);


//转发 给PC
/*
基站转发 keypad直接给 pc的数据
如此转发是否会和正常数据冲突 ？？？ 如何避免
called by main loop , */
unsigned char keypad_transfer2pc_data_fetch(void);	
/*
基站保存 keypad直接给 pc 的数据
called by 基站处理接收键盘rf数据的函数 */
void keypad_transfer2pc_data_save(const unsigned char *trans2kp);

unsigned short calc_custom_rf_sync_code(const unsigned char*input);

//-------------------基站相关函数 ---------------------------------------
/*
复制配对码 */
void get_base_match_code(unsigned char *mac);

#define 	log_mode_is_SN 	(get_base_log_mode()>3)
#define 	log_mode_is_ID 	(get_base_log_mode()<=3)
#define 	log_mode_is_CRS2 ( log_mode_is_SN && function.crs2__SW )
#define 	log_mode_is_free_match ( (get_base_log_mode()==3)||(get_base_log_mode()==6) )
#define 	log_mode_is_WHITELIST	(function.whitelist__SW &&( (get_base_log_mode()==8)||(get_base_log_mode()==9)) )


unsigned char assert_base_log_mode(void);
unsigned char get_base_log_mode(void);

/*获取基站主频点模块编号*/
unsigned char get_mainRF_usr_id(void);
/*
获取 主频点对应的硬件编号！！！！,		*/
unsigned char get_main_rf_hard_id(void);

unsigned char get_base_main_rfchannel(void);
void set_base_main_rfchannel(unsigned char freq);
/*
判断/限制基站频点*/
unsigned char assert_base_channel(void);

/*
判断基站id是否合法*/
unsigned char assert_base_id(void);
/*
获取基站的id*/
unsigned char get_base_id(void);

/*
* sdk设置的扩展基础信标之后，就开启和标准基础信标交替发送;	*/
void set_ext_basicbeacon_startup_flag(unsigned char);

//============================================ keypad  =============================================================
/*
CRC设置
*/
void set_keypad_crc_config(unsigned char flag);
unsigned char get_keypad_crc_config(void);
unsigned char keypad_crc_check(void);




/*
判断是否在容量均衡模式*/
unsigned char get_ext_basicbeacon_startup_flag(void);

///*
//基站发给键盘的数据：
//基础信标，投票信标和投票数据的确认*/
void base_tx_to_keypad_sub(unsigned char *buf,unsigned char rf_id);

/*
和上述函数相比，此函数专门给外部使用
rf_id表示的是 无线模块的硬件标号
*/
void send_to_keypad_user_hardID(unsigned char *buf,unsigned char rf_hard_id);

/*
初始化 键盘相关
a, 初始化接收键盘的队列
b,初始化转发给键盘的数据队列
called by main init	*/
void base_process_keyapad_init(void);

/*
基站处理来自键盘 数据 总入口 
将键盘数据分成4中类型：
	id 模式
	sn 模式
	CRS2 模式
	转发至pc的数据
called by main loop		*/
void keypad_rf_data_process(void);

void keypad_rf_data_process_NO_fifo(unsigned char *tmp);

/* ------------------
基站发送信标/时序 给键盘 
此函数2.5ms被调用一次	
called by 2.5ms timer*/
void base_tx_keypad_beacon(void);


/*
基站接收键盘数据，将键盘数据保存到 队列中
被 无线中断函数调用 */
unsigned char keypad_rf_data_save( unsigned char *rf_data);	


//-pc 转发 keypad
/*
基站发送 pc直接给 keypad 的数据
called by 信标发送函数 base_tx_keypad_beacon()
return :
	0- 没有要转发的数据或者 连续转发时间到
	1- 还有数据或者转发等待，		*/
unsigned char pc_transfer2keypad_data_fetch(void);

/*
基站保存pc直接转发给键盘的数据 
called by 基站处理pc数据的函数 */
unsigned char pc_transfer2keypad_data_save(unsigned char *trans2kp);



//-------处理键盘id/sn相关函数
struct keypad_idsn_STR{
//	#define 	SN_LEN		6
	unsigned char number;
	unsigned char idsn[10][6];//[SN_LEN];	
};
extern struct keypad_idsn_STR keypad_idsn;



/*-------------------------------------------------
多无线模块相关参数!(兼容单模块)*/
struct multi_modual_STR{
	unsigned char modual_id[4];			//[0]-主频点模块编号，	
	unsigned char modual_chan[4];		//与sdk设置界面对应
	volatile	unsigned char count;						//与sdk设置界面对应
	volatile	unsigned char hard_rf_modual_cnt;//function·.h中设置无线模块的个数!
	
	unsigned char main_index;				//主模块在modual_id[]中的下标位置index
	unsigned char whitelist_index;	//白名单模块在modual_id[]中的下标位置index
	struct keypad_idsn_STR multi_idsn[4]; 	//记录接收键盘的id/sn	/max 4 rf modual
};
extern struct multi_modual_STR multi;


extern void multi_chan_init(void);
/*
设置无线模块的频点*/
extern void base_set_rf_freq(unsigned char rf_id);


/*
设置多频点时的处理： called by pc设置单模块操作时
	a 同步到多频点
	b 复制到内核multi变量
	c E2prom保存两个频点*/
void process_setup_single_chan(unsigned char single_rf);

/*
设置多频点时的处理： called by multi setup 
	a 同步到单频点
	b 复制到内核multi变量
	c E2prom保存两个频点*/
void process_setup_multi_chan(unsigned char multi_freq);
	
/*
根据来自中断的模块序号查询自己的序号
return :查询到了就直接返回序号
0xff -没有在表格中查询到。
called by rx keypad data */
unsigned char conver_id(unsigned char hard_id);


/*
通过单频点关联多频点,不关联有效频点个数*/
void single_relevant_to_multi_chan(unsigned char single_chan);


void multi_chan_polling(void);


unsigned char get_operaion_rf_count(void);


//基站自监测rf模块！！
void rf_modual__tx_counter(unsigned char id);
void rf_modual__tx_interrupt_counter(unsigned char id);
void rf_modual__check(void);
void rf_modual_5G8__check(void);
extern unsigned char get_rf_error_cnt(unsigned char *buf);
void rf_error_warning(void);
/*
保存键盘的id/sn 
intput:
	idsn--buffer
	byteN- id/sn字符个数
return:
	0- fail
	1- OK			*/
unsigned char keypad_idsn_save(const unsigned char *idsn,unsigned char cnt,unsigned char rf_id);

/*
从缓冲区中取出id/sn 
intput:
	idsn -buffer
	byteN-字节数，2-id,4 sn, 6sn
	idsn_cnt -要读取id/sn的个数;	*/
void keypad_idsn_fetch(unsigned char *idsn,unsigned char byteN,unsigned char idsn_cnt);


unsigned char keypad_rf_data_fetch(unsigned char *rf_data);

/*
清除记录键盘idsn,及有效个数	*/
extern void keypad_idsn_clear(void);

/*
基站发送信标的开关,
某些功能需要关闭 基站发送信标
基站读取基础参数后再开启发送信标	*/
void base_send_beacon_switch(unsigned char sw);
unsigned char get_base_send_beacon_status(void);

unsigned char keypad_crs2_mode(const unsigned char *rxkp,unsigned char rf_id);


//---------------------------------- 5.8G rf-----------------------------------------------------------

#ifdef 		KEYPAD60
#define 	KEYPAD_COUNT_MAX		90//60//30
#define 	TRANSFER_CYCLE_MAX  9//6//(KEYPAD_COUNT_MAX/10+KEYPAD_COUNT_MAX%10)
#else
#define 	KEYPAD_COUNT_MAX		30
#define 	TRANSFER_CYCLE_MAX  6 //(KEYPAD_COUNT_MAX/10+KEYPAD_COUNT_MAX%10)
#endif 

#define 	OFFLINE_COUNT				280//154//10 //10个大周期都没有收到数据，认为离线;

/*
键盘信息结构体 element*/
typedef struct keypad_info_STR{
	unsigned char id_sn[4];
	unsigned char re_send_slot;
	unsigned short offline_count;
	unsigned char filt_heart_pkt_count;	//过滤心跳包计数器	
	#ifdef VOICE_PROTOCOL_3RD
	unsigned char buf_warnning;
	unsigned char ask_resend_state;
	#endif
	
	#ifdef  _DBG_VOICE_KP	
	unsigned short re_send_timers;	//该键盘重发的次数
	unsigned short rxkp_cnt; 				//收到键盘数据包的个数,语音和非语音都有效
	unsigned short ackkp_cnt;				//基站应答键盘的次数， 语音状态不应答!
	unsigned short ackkp_in_cnt;		//记录sn次数与ackkp_cnt对应;语音状态下无效!	
	unsigned short tx_pc_cnt;				//报告给sdk的次数;		 语音和非语音都有效
	
	unsigned short send_beacon_cnt;	//发送信标的次数
	#endif 
	
	
}ELEMENT;

//node
struct link_node_STR{
	ELEMENT element;	//keypad info
	unsigned char status;		
	struct link_node_STR *next;
};
	
struct link_queue_STR{
	struct link_node_STR *front;
	struct link_node_STR *rear;
};
//queue
extern struct link_queue_STR keypad_info;

#ifdef BUF_ALERT2
#define BUF_GET_T  20 //单独点名几次
struct buf_alert_get_STR{
	unsigned char Status;
	unsigned char SN[4];//要点名的SN
	unsigned char GetT;//点名计数
	unsigned char ResendT;//重传周期
};
extern struct buf_alert_get_STR buf_get_info;
#endif

//link queue basic
void  link_queue_init(struct link_queue_STR *queue);
unsigned char link_queue_input(struct link_queue_STR *queue,ELEMENT *ele);
/*
连续取出多个element 数据
return 取出的个数;
*/
unsigned char link_queue_outN(struct link_queue_STR *queue,unsigned char *out,unsigned char offset);
unsigned char link_queue_outN_re_send(struct link_queue_STR *queue,unsigned char *out,unsigned char offset);
unsigned char link_queue_check_re_send(struct link_queue_STR *queue,unsigned char offset);

void link_queue_check_online(struct link_queue_STR *queue);

void base_process_5G8_keyapd_init_queue(void);
//void base_process_rx_keypad_data_5G8(unsigned char *buf);

unsigned char get_link_queue_length(struct link_queue_STR *queue);

unsigned char get_keypad_count(void);
unsigned char get_link_queue_sn(unsigned char *sn);

struct link_node_STR *link_queue_find_special_sn(struct link_queue_STR *queue,const unsigned char *sn);

void re_init_all_resend_slot(void);

//特殊处理指定转发
void spec_trans__record_sn(unsigned char *trans);
void spec_trans__load_sn(unsigned char *start);


//==========================================  上报数据 和 队列处理投票数据  ========================================================
/*
初始化上报投票数据 相关参数
called by main init */
extern void vote_data_parameter_init(void);


/*
功能 ：存储投票数据
input:
	type：键盘投票数据的类型，具体见协议分类
	*data:数据指针
	len: 数据长度
return: 1, 存储成功 ；0-失败; 
调用：基站处理接收到的键盘数据合法后，调用此函数保存投票数据*/

extern unsigned char vote_data_store(unsigned char *vote_data);

//模拟成键盘数据向PC发送基站状态报告,借用一问十答确认机制，确保不丢包
extern unsigned char Core_PC_active_rpt(const unsigned char *info,unsigned char len);
/*
启动数据上报给pc
当pc发送命令询问基站是否有投票数据时被调用！！*/
extern void vote_data_report_startup(void);

/*
基站发送投票数据包给pc
被 main loop 调用*/
extern void vote_data_report_to_pc(void);

/*
功能：如果有多个数据包需要上报给pc,此函数的作用在于控制数据包之间的时间间隔，目前的25ms
input: interval
	数据包之间的发送间隔时间 = interval*2.5ms;

被2.5ms定时器调用
*/
extern void vote_data_report_interval(void);


/*
//初始化队列相关参数*/
extern void vote_init_queue(void);

/*
input: 被确认的数据包序号指针.1-10，具体见基站协议

调用： 基站收到pc的投票数据包确认信息后 调用此函数！！*/
extern void vote_status_clear_confirmed(const unsigned char *confirm);

/*
function: 复位没有被确认的数据包
1，遍历队列中所有数据，找到数据包序号在0< rpt_status<=10	*/
extern void vote_status_reset_NOconfirmed(void);


/*
function: 打包数据上报给sdk
1,如果Qtype队列为空，表示没有任何投票数据，直接报告
2，如果队列不为空，就从Qtype队列头所指向的Qdata数据头开始打包,直到队列尾部！！
3，先发送一个type所包含的data;在下一次sdk询问时再发送下一个type指向的数据;
return:
	0：没有任何数据了 ;; 		
	1：可能还有数据，需要继续调用此函数！！	*/
extern unsigned char vote_data_packing( unsigned char pkt_seq);


unsigned char get_packing_parameter(unsigned char *type,unsigned char *cnt,unsigned char *len);
	
/*
debug only
检测原始投票buf中是否还有数据!
获取数据状态status;和数据对应的键盘id/sn	*/
unsigned char vote_buf_remain_count(unsigned char *id,unsigned char *status);




//-------------------------------------- 通用队列 相关函数 -------------------------------																						
//20190604
typedef 	  unsigned char 	elem_type;
struct fifo_queue_STR{
	//modify by Gavin20191206,//调试超过20个T2键盘时，sdk监测到基站丢失数据严重
//	unsigned char front;
//	unsigned char rear;	
//	unsigned char count;	
	
	unsigned short front;
	unsigned short rear;	
	unsigned short count;	
	elem_type **pdata;
};

void queue_init(struct fifo_queue_STR *queue,unsigned char **data,unsigned short node_size,unsigned char data_len);
unsigned char queue_in(struct fifo_queue_STR *queue,const elem_type* data,unsigned short node_size,unsigned char data_len);

unsigned char queue_out(struct fifo_queue_STR *queue,elem_type* data,unsigned short node_size,unsigned char data_len);
unsigned char queue_out_special(struct fifo_queue_STR *queue,elem_type* data,unsigned short node_size,unsigned char data_len,unsigned char type);
unsigned char queue_out_get_type(struct fifo_queue_STR *queue,unsigned char data_len);


//-----------------------------------
void transfer2kp_init_queue(void);
void transfer2pc_init_queue(void);




//====================== math function ===============================================
/*
内存复制*/
extern void mem_cpy( const unsigned char *src,unsigned char *dist,unsigned char len);

/*
初始化数组的值都为指定常量*/
extern void mem_set(unsigned char *tmp,unsigned char len,unsigned char set_val);

/*
比较两个数组对应位数据是否相等
只要有不相等就返回0 */
extern unsigned char mem_compare(const unsigned char *ptr1,const unsigned char *ptr2,unsigned char len);

/*
比较数组的每个元素都与指定常量是否相等
只要有不相等的就 return 0;*/
extern unsigned char mem_cmp_const(const unsigned char *ptr1,unsigned char len,unsigned char _const);

/*
搜索数组中元素是否有指定常量*/
unsigned char mem_search_const(const unsigned char *ptr1,unsigned char len,unsigned char _const);


void Dec_to_Hex(unsigned char *sn,unsigned char len,unsigned char *dec );



//================================================================ E2prom store ===============================================
#define 	STORE_FLAG							0xF5
//store addr// 20190930 update
#define 	STORE_BASE_CONFIG_ADDR			0			//len=BASE_CONFIG_LEN+1= 8
#define 	STORE_BASE_HDINFO_ADDR			0x08	//len==BASE_HDINFO_LEN +1 =14
#define 	STORE_BASE_MAC_ADDR					0x18	//len=BASE_MAC_LEN +1 =5
#define 	STORE_DFU_ADDR							0x2E  //len=1;fixed!!!!
#define 	STORE_BASIC_BEACON_ADDR			0x30	//len=BASIC_BEACON_LEN+1 =15	
#define 	STORE_OEM_CODE_ADDR					0x40	//len==8+1=9;
#define 	STORE_OEM_USER_ADDR					0x50  //len=16*5 zone0-4=5
#ifndef		VOTE_BEACON_64BYTE
	#define 	STORE_VOTE_BEACON_ADDR			0xa0	//len==VOTE_BEACON_LEN+1=27
#endif
#define 	STORE_BASE_NAME_ADDR				0xc0	//len==BASE_NAME_LOG_MODE_LEN+1=14	
#define 	STORE_BASE_ATTRIB_ADDR			0xd0	//len=4+1
#define 	STORE_AUX_ATT_ADDR					0xd8	//len=3+1
#define 	STORE_OEM_JY_ADDR						0xe0	//len=10+1，极域
#define 	STORE_MULTI_CHAN_ADDR				0xf0	//len=6+1
#define 	STORE_BASIC_EXT_BEACON_ADDR	0x100	//len =BASIC_EXT_BEACON_LEN +1 =25


#define 	STORE_IP_ADDR								0x120	//len=4+1
#define 	STORE_MAC_ADDR							0x128 //len=6+1
#define 	STORE_SUBNET_ADDR						0x130	//len=4+1
#define 	STORE_GATEWAY_ADDR					0x138 //len=4+1
#define 	STORE_KP_CRC_CONFIG					0x140 //len=1+1

#ifdef		VOTE_BEACON_64BYTE
	#define 	STORE_VOTE_BEACON_ADDR			0x150	//len==VOTE_BEACON_LEN+1= 55 ->0x190
#endif

//#define 	E2PROM_ADDR_KEYCODE		0x100	
#define 	STORE_AES_KEYCODE_ADDR			0x400	//len =32
#define 	STORE_AES_CONFIG_ADDR				0x420	//0x120	//len =3	//20200427修改，解决和IP地址存储冲突!!	
#define     STORE_BASE_PWD_ADDR                 0x428//len=4

#define 	STORE_LISTMGNT_CNT_ADDR				0x432	//LEN =
#define 	STORE_LISTMGNT_SN_ADDR				(0x432+2)

#if 	MD_SPECIAL_STOP_PRO	
#define 	STORE_BASE_STOP_BEACON		0x430		// len =2+1
#define 	STORE_BASE_STOP_BEACON2		0x433		// len =1+1
#endif

#define 	STORE_BASE_NAME_VIEW		0x435		// len =1+1


unsigned char base_write_e2prom( unsigned short addr,const unsigned char * ptr,unsigned char len);
unsigned char base_read_e2prom( unsigned short addr, unsigned char * ptr,unsigned char len);
void base_read_e2prom_parameter(void);
void base_clear_e2prom_parameter(void);





//--------------------------- debug_core -----------------------------


#ifdef _DBG_VOICE_KP	//5.8G only 
void _debug_voice_kp__ack_keypad(unsigned char *sn);
void _debug_voice_kp__tx_pc(unsigned char *sn);
void _debug_voice_kp__init_keypad_parameter(ELEMENT *ele_tmp);
void _debug_voice_kp__init_all_parameter(void);
void _debug_voice_kp__app_get_keypad_debug_info(unsigned char *sn);
void _debug_voice_kp__record_illegal_rx_idsn(unsigned char *sn);


void _debug_core__process_5G8_keypad(unsigned char* pc);
#endif




//----------------------------------------------------------
//2020.11
void response_pc_cmd( char type[], unsigned char *ack,unsigned char len);

void _debug_core__init(void);
void _debug_core__init_parameter_datapos_change(void);

void _debug_core__record_rxkp_info(const unsigned char *rx_kp);
//void _debug_core__record_ackkp_info(const unsigned char *ack_kp);
void _debug_core__record_ackkp_info(unsigned char mode_type, const unsigned char *ack_kp);
void _debug_core__record_txpc_info(unsigned char pkt_seq, const unsigned char *tx_pc);
void _debug_core__record_pcack_info(unsigned char pkt_seq);
void _debug_core__record_txpc_info_report(const unsigned char *tx_pc);
void _debug_core__printf(void);
void _debug_set_subject(unsigned char val);

//core
void _debug_core__process_core_info(const unsigned char *pc);

//sdk offline and sysmode0 keeptimer
void _monitor_sdkoffline_sysmode0(void);
void reset__monitor_sdkoffline_sysmode0(void);




#endif //_BASE_CORE_H_



