

//每个数据包里最多包括的键盘信息个数     
#define     KP_MAX_IN_PKT  9   

//最多监测100只键盘; 最多监测100条内容,如果需要的话
#define     _DBG_KP_CNT       (100+1)
//最多记录 键盘SN出错 的个数
#define     _DBG_ERR_CNT      8


#define     _DBG_KP_IDSN_CONTINUE    //键盘是简化SN 1-100;不定义就是无序SN键盘
#ifdef  _DBG_KP_IDSN_CONTINUE
    #define     _DBG_IDSN_LEN        4
    #define     _DBG_VALID_KP_CNT    100//47
#endif 

//监测题号
#define 	_DBG_TITLE_CNT		201
	#define 	_DBG_ERR_TITLE_CNT	5


/*
*以键盘为对象
*/
struct _debug_keypad_info_STR
{
    //witch keyad
    unsigned short rx_kp_cnt;
    unsigned short ack_kp_cnt;
    //witch pc
    unsigned short tx_pc_cnt;
    unsigned short acked_pc_cnt; 
    unsigned char kp_idsn[6];
	
		#if _DBG_TITLE_CNT != 0 
		unsigned char rpt_title_NO[_DBG_TITLE_CNT];
		unsigned char title_NO[_DBG_TITLE_CNT];
		unsigned char title_cnt;	//统计某个键盘接收了多少到题;
		
		//记录题型错误信息
		unsigned char err_title_NO[_DBG_ERR_TITLE_CNT];
		unsigned char err_title_cnt;
		#endif
	
    #if 0   
    unsigned char err_content_unit_cnt;  //需要记录错误内容;正确的不需要；
    unsigned char err_content[_DBG_ERR_CNT][_DBG_CONTENT_LEN]; 
    unsigned char right_content_unit_cnt;            //正确内容的单位数；   
    unsigned char content_unit[_DBG_CONTENT_UNIT_CNT];  //检测内容的单位数；比如100道测验题  
    #endif
};


//单个数据包结构体; cnt-键盘个数；键盘数据
struct _debug_rpt_pkt_STR
{
    unsigned char kp_data[KP_MAX_IN_PKT];
    unsigned char kp_cnt;
};




struct _debug_core_STR
{
    struct _debug_keypad_info_STR   kp_info[_DBG_KP_CNT];
    unsigned char idsn_len;    //2-id;4-sn;6-sn
    unsigned char valid_kp_cnt;              //实际需要检测键盘个数；最大100； 0表示没有开启监测功能；

    unsigned char rx_idsn_err[_DBG_ERR_CNT][6];   //接收时的idsn出错在此记录，其他错误定义成键盘属性！！
    unsigned char rx_idsn_err_cnt;
    unsigned char ack_idsn_err[_DBG_ERR_CNT][6];
    unsigned char ack_idsn_err_cnt; 

    //tx pc/sdk
    unsigned char txpc_idsn_err[_DBG_ERR_CNT][6];
    unsigned char txpc_idsn_err_cnt;
    struct _debug_rpt_pkt_STR rpt_pkt[11];



    #if 0
    unsigned char dist_idsn[_DBG_KP_CNT][6];                      
    unsigned char dist_content[_DBG_CONTENT_LEN];       //实际监测的内容 'AAA'
    unsigned char dist_content_len;                     //检测内容的长度：3bytes
    unsigned char dist_content_unit_cnt;                //每个键盘检测内容的个数，比如30道测验题 ;最大100；0表示不需要检测内容！！ 
    #endif
};

extern struct _debug_core_STR _dbg_core_;










