#ifndef _W5500_CONF_H_
#define _W5500_CONF_H_

#include "stm32f4xx.h"
#include "stdio.h"
#include "types.h"
#define __GNUC__

typedef  void (*pFunction)(void);

extern uint8  	remote_ip[4];															 /*ԶIPַ*/
extern uint16 	remote_port;															 /*Զ˶˿ں*/
extern uint16		local_port;																 /*屾ض˿*/
extern uint8  	use_dhcp;																	 /*ǷʹDHCPȡIP*/
extern uint8  	use_eeprom;																 /*ǷʹEEPROMеIPϢ*/

//#define STM32_SPI1
#define  STM32_SPI2	

/*W5500STM32 SPI1Ӳ߶*/
//	W5500_SCS    --->		STM32_GPIOA4								 			 /*W5500Ƭѡܽ*/
//	W5500_SCLK	 --->	  STM32_GPIOA5								 			 /*W5500ʱӹܽ*/
//  W5500_MISO	 --->		STM32_GPIOA6								 			 /*W5500MISOܽ*/
//	W5500_MOSI	 --->		STM32_GPIOA7								 			 /*W5500MOSIܽ*/
//	W5500_RESET	 --->   STM32_GPIOC0								 			 /*W5500RESETܽ*/
//	W5500_INT		 --->		STM32_GPIOC1								 			 /*W5500INTܽ*/

/*W5500STM32 SPI2Ӳ߶*/
//	W5500_SCS 	--->	 STM32_GPIOB12								 			 /*W5500Ƭѡܽ*/
//	W5500_SCLK	--->	 STM32_GPIOB13								 			 /*W5500ʱӹܽ*/
//  W5500_MISO	--->	 STM32_GPIOB14								 			 /*W5500MISOܽ*/
//	W5500_MOSI	--->	 STM32_GPIOB15								 			 /*W5500MOSIܽ*/
//	W5500_RESET	--->   STM32_GPIOB9								   			 /*W5500RESETܽ*/
//	W5500_INT		--->   STM32_GPIOC6								   			 /*W5500INTܽ*/

#define FW_VER_HIGH  						1               
#define FW_VER_LOW    					0
#define ON	                 		1
#define OFF	                 		0
#define HIGH	           	 			1
#define LOW		             			0

#define MAX_BUF_SIZE		 				1460											 /*ÿݰĴС*/
#define KEEP_ALIVE_TIME	     		30	                       /*30sec*/
#define TX_RX_MAX_BUF_SIZE      2048							 
#define EEPROM_MSG_LEN        	sizeof(EEPROM_MSG)

#define IP_FROM_DEFINE	        0                          /*ʹóʼIPϢ*/
#define IP_FROM_DHCP	          1                          /*ʹDHCPȡIPϢ*/
#define IP_FROM_EEPROM	        2							             /*ʹEEPROMIPϢ*/
extern uint8	ip_from;											               /*ѡIPϢԴ*/
#pragma pack(1)
/*˽ṹ嶨W5500ɹõҪ*/
typedef struct _CONFIG_MSG											
{
  uint8 mac[6];																						 /*MACַ*/
  uint8 lip[4];																						 /*local IPIPַ*/
  uint8 sub[4];																						 /**/
  uint8 gw[4];																						 /**/	
  uint8 dns[4];																						 /*DNSַ*/
  uint8 rip[4];																						 /*remote IPԶIPַ*/
	uint8 sw_ver[2];																				 /*汾*/
}CONFIG_MSG;
#pragma pack()

#pragma pack(1)
/*˽ṹ嶨eepromдļɰ޸*/
typedef struct _EEPROM_MSG	                    
{
	uint8 mac[6];																							/*MACַ*/
  uint8 lip[4];																							/*local IPIPַ*/
  uint8 sub[4];																							/**/
  uint8 gw[4];																							/**/
}EEPROM_MSG_STR;
#pragma pack()

extern EEPROM_MSG_STR EEPROM_MSG;
extern CONFIG_MSG  	ConfigMsg;
extern uint8 dhcp_ok;																				/*DHCPȡɹ*/
extern uint32	dhcp_time;																		/*DHCPм*/
extern vu8	ntptimer;																				/*NPT*/

/*MCUغ*/
void gpio_for_w5500_config(void);														/*SPIӿreset ж*/
void timer2_init(void);																			/*STM32ʱ2ʼ*/
void timer2_isr(void);																			/*ʱжִеĺ*/
void reboot(void);																					/*STM32λ*/
void write_config_to_eeprom(void);													/*дϢEEPROM*/
void read_config_from_eeprom(void);													/*EEPROMжϢ*/

/*W5500SPIغ*/
void IINCHIP_WRITE( uint32 addrbsb,  uint8 data);						/*дһ8λݵW5500*/
uint8 IINCHIP_READ(uint32 addrbsb);													/*W5500һ8λ*/
uint16 wiz_write_buf(uint32 addrbsb,uint8* buf,uint16 len);	/*W5500дlenֽ*/
uint16 wiz_read_buf(uint32 addrbsb, uint8* buf,uint16 len);	/*W5500lenֽ*/

/*W5500غ*/
void reset_w5500(void);																			/*ӲλW5500*/
void set_w5500_mac(void);																		/*W5500MACַ*/
void set_w5500_ip(void);																		/*W5500IPַ*/

/*ҪöʱĵӦú*/
void dhcp_timer_init(void);																	/*dhcpõĶʱʼ*/
void ntp_timer_init(void);																	/*nptõĶʱʼ*/

#endif
